//============================================================================================
/**
 * @file	ev_mapchange.c
 * @brief	tB[h}bvؑւ̃CxgƂ̐`FbN
 * @date	2005.08.01
 * @author	tamada / saito
 */
//============================================================================================

#include "common.h"
#include "fieldsys.h"

#include "field_event.h"

#include "fieldmap.h"
#include "field/location.h"

#include "ev_mapchange.h"

#include "worldmap.h"

#include "zonedata.h"
#include "mapdefine.h"
#include "eventdata.h"		//][̃Cxgf[^QƂ̂

#include "system/snd_tool.h"
#include "fld_bgm.h"
#include "system/brightness.h"
#include "system/pm_overlay.h"  // nڑ̂
#include "comm_player.h"  // nڑ̂
#include "communication/communication.h"
#include "../fielddata/script/common_scr_def.h"		//SCRID_REPORT

#include "map_tool.h"

#include "field_3d_anime_ev.h"

#include "system/wipe.h"
#include "field_cutin.h"
#include "field_ananuke.h"
#include "effect_warppoint.h"

//n
#include "effect_uground.h"
#include "comm_field_state.h"  // nʐMp
#include "underground/ug_manager.h"  // np
//
#include "script.h"

#include "savedata/mystatus.h"	//MyStatus_GetMySex
#include "savedata/gimmickwork.h"
#include "savedata/undergrounddata.h"
#include "field/situation_local.h"	//Situation_GetTMFootMark
#include "townmap_footmark.h"		//TMFootMark_SetNoDir
#include "mapdata_warp.h"			//WARPDATA_SearchByRoomID
#include "field_subscreen.h"
#include "report.h"
#include "mapdata_weather.h"		//WeatherData_Get
#include "weather_sys.h"
#include "savedata/fnote_mem.h"		//FNOTE_DATA
#include "itemtool/itemsym.h"
#include "savedata/savedata.h"
#include "sysflag.h"
#include "syswork.h"
#include "ev_time.h"				//EVTIME_Update

#include "savedata/encount.h"
#include "fieldmap_mem.h"			//FIELD_HEIGHT_DATA_SIZE

#include "fld_flg_init.h"
#include "place_name.h"

#include "msgdata/msg.naix"
#include "msgdata/msg_connect.h"

#include "system/window.h"
#include "system/bmp_menu.h"
#include "talk_msg.h"
#include "fld_bmp.h"


FS_EXTERN_OVERLAY(ol_underground);

static BOOL GMEVENT_MapChange(GMEVENT_CONTROL * event);
static BOOL GMEVENT_FirstMapIn(GMEVENT_CONTROL * event);
static BOOL GMEVENT_FieldChange_FadeIn(GMEVENT_CONTROL * event);

static void MapChg_SetNewLocation(FIELDSYS_WORK * fsys, const LOCATION_WORK * next);
static void MapChg_SetupMapTools(FIELDSYS_WORK * fsys);
static void MapChg_RemoveMapTools(FIELDSYS_WORK * fsys);
static void MapChg_FieldOBJ_Create(FIELDSYS_WORK * fsys);
static void MapChg_FieldOBJ_Delete(FIELDSYS_WORK * fsys);

// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
#if S2424_060818_FIX
static void FNoteStartDataSet_SioError( FIELDSYS_WORK * fsys );
#endif
// ----------------------------------------------------------------------------


//============================================================================================
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	}bvJڃCxgp䃏[N
 */
//-----------------------------------------------------------------------------
typedef struct {
	int seq;							///<V[PXێ[N
	LOCATION_WORK next;					///<}bvJڐwp[N
	FLD_3D_ANIME_WORK_PTR DoorAnimeWork;
}EVENT_MAPCHG_WORK;

//-----------------------------------------------------------------------------
/**
 * @brief	}bvVXȅp[^
 */
//-----------------------------------------------------------------------------
static const MAP_MODE_DATA MapModeData[] = {
	///MAP_MODE_GROUND		ʏtB[h
	{
		FIELD_SUBSCRN_POKETCH,		//TuʁF|Pb`
		DIV_MAP_MODE_GROUND,		//}bv]VXewFʏ
		MAP_TOOL_MODE_GROUND,		//}bvc[wFʏ
		DISP_3D_TO_MAIN,			//ʂ3D
		FALSE,						//Agr[gVXeFgȂ
		TRUE,						//TuI[o[CFǂݍ
		0,							//Agr[gpɕێf[^
		0xc4000,					//tB[hŊmۂq[ṽTCY
	},
	///MAP_MODE_UNDER		Yz
	{
		FIELD_SUBSCRN_UNDER,		//TuʁF[_[
		DIV_MAP_MODE_UNDER,			//}bv]VXewFnp
		MAP_TOOL_MODE_UNDER,		//}bvc[wFnp
		DISP_3D_TO_SUB,				//ʂ3D
		TRUE,						//Agr[gVXeFg
		FALSE,						//TuI[o[CFǂݍ܂Ȃ
		16,							//Agr[gpɕێf[^
		0xc4000,					//tB[hŊmۂq[ṽTCY
	},
	///MAP_MODE_UNION		jI[
	{
		FIELD_SUBSCRN_UNION,		//TuʁFjI{[h
		DIV_MAP_MODE_GROUND,		//}bv]VXewFʏ
		MAP_TOOL_MODE_GROUND,		//}bvc[wFʏ
		DISP_3D_TO_MAIN,			//ʂ3D
		FALSE,						//Agr[gVXeFgȂ
		TRUE,						//TuI[o[CFǂݍ
		0,							//Agr[gpɕێf[^
		0xc4000,					//tB[hŊmۂq[ṽTCY
	},
	///MAP_MODE_COLOSSEUM	ʐMΐ핔
	{
		FIELD_SUBSCRN_NO_POKETCH,	//TuʁFX^[{[\
		DIV_MAP_MODE_UNDER,			//}bv]VXewFnp
		MAP_TOOL_MODE_UNDER,		//}bvc[wFnp
		DISP_3D_TO_MAIN,			//ʂ3D
		TRUE,						//Agr[gVXeFg
		TRUE,						//TuI[o[CFǂݍ
		1,							//Agr[gpɕێf[^
		0xc4000,					//tB[hŊmۂq[ṽTCY
	},
	///MAP_MODE_BTOWER		og^[
	{
		FIELD_SUBSCRN_POKETCH,		//TuʁF|Pb`
		DIV_MAP_MODE_UNDER,			//}bv]VXewFnp
		MAP_TOOL_MODE_UNDER,		//}bvc[wFnp
		DISP_3D_TO_MAIN,			//ʂ3D
		TRUE,						//Agr[gVXeFg
		TRUE,						//TuI[o[CFǂݍ
		1,							//Agr[gpɕێf[^
		0xc4000 - FIELD_HEIGHT_DATA_SIZE * 4,	//tB[hŊmۂq[ṽTCY
	},
};

//============================================================================================
//
//
//	c[֐
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	}bv[hC
 * @param	fsys		tB[h䃏[Nւ̃|C^
 *
 * og^[ł͒ʐMȂƃs邽߂ɁAAgr[g
 * gpB{̓og^[̏oŖIMapMode̎wsׂł邪
 * IȔfAꏈMapMode̐ؑւsB06.05.16 tamada
 */
//-----------------------------------------------------------------------------
static void MapChg_MapModeControl(FIELDSYS_WORK * fsys)
{
	BOOL IsBtower;

	switch (fsys->location->zone_id) {
	case ZONE_ID_D31R0201:
	case ZONE_ID_D31R0202:
	case ZONE_ID_D31R0203:
	case ZONE_ID_D31R0204:
	case ZONE_ID_D31R0205:
	case ZONE_ID_D31R0206:
	case ZONE_ID_D31R0207:
		IsBtower = TRUE;
		break;
	default:
		IsBtower = FALSE;
	}
	if (!IsBtower && fsys->MapMode == MAP_MODE_BTOWER) {
	//og^[ȊOŃ}bv[hBTOWER̂ƂAʏ탂[hɏC
		fsys->MapMode = MAP_MODE_GROUND;
	} 
	if (IsBtower) {
	//og^[̂ƂA}bv[hBTOWERɂ
		fsys->MapMode = MAP_MODE_BTOWER;
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	}bvwXV
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	next		̑JڐwLOCATION_WORKւ̃|C^
 */
//-----------------------------------------------------------------------------
static void MapChg_SetNewLocation(FIELDSYS_WORK * fsys, const LOCATION_WORK * next)
{
	SITUATION * sit = SaveData_GetSituation(fsys->savedata);
	LOCATION_WORK * before = Situation_GetBeforeLocation(sit);
///	LOCATION_WORK * escape = Situation_GetEscapeLocation(sit);
	//P[VXV
	if (next != NULL) {
		*before = *fsys->location;
		*(fsys->location) = *next;
	}
	//][ʃf[^̓ǂݍ
	EventData_LoadZoneData(fsys, fsys->location->zone_id);

	if (fsys->location->door_id != DOOR_ID_JUMP_CODE){
		//oڑ̏ꍇ̏
		const CONNECT_DATA* connect;
		connect = EventData_GetNowConnectDataByID(fsys, fsys->location->door_id);
		fsys->location->grid_x = connect->x;
		fsys->location->grid_z = connect->z;
		//ڑɏoꍇ́Aڑێ悤ɂĂ
		if (connect->link_door_id == SPECIAL_SPEXIT01) {
			LOCATION_WORK *sp, *ent;
			sp = Situation_GetSpecialLocation(sit);
			ent = Situation_GetEntranceLocation(sit);
			*sp = *ent;
		}
	}
#ifdef	DEBUG_ONLY_FOR_tamada
	OS_Printf("ZONE:%d X:%d Z:%d\n",fsys->location->zone_id,
			fsys->location->grid_x, fsys->location->grid_z);
#endif
}

//-----------------------------------------------------------------------------
/**
 * @brief	VXetO3DʂZbg
 * @param	fsys		tB[h䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
void MapChg_Set3DDisplay(FIELDSYS_WORK *fsys)
{
	GF_ASSERT(fsys->MapMode < MAP_MODE_MAX);
	sys.disp3DSW = fsys->MapModeData->disp3DSW;
}

//-----------------------------------------------------------------------------
/**
 * @brief	}bvJڎ̃f[^XV
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	walk_flag	TRUÊƂA邢Đڑ
 *						FALSÊƂA}bvؑւŐڑ
 */
//-----------------------------------------------------------------------------
void MapChg_UpdateGameData(FIELDSYS_WORK * fsys, BOOL walk_flag)
{
	int zone_id = fsys->location->zone_id;
	SITUATION * sit = SaveData_GetSituation(fsys->savedata);

	//--}bvBGMwNA
	Snd_FieldBgmClearSpecial( fsys );

	//--XNvg̃}bvtO[ÑNA
	LocalEventFlagClear(fsys);

	//--tONA
	if (!walk_flag) {
		FldFlgInit_MapJump(fsys);	//}bvWvł̃tOƂ
	}else{
		FldFlgInit_Walk(fsys);		//nł̃][܂tOƂ
	}
	
	//--ogT[`[Zbg
	Sys_BtlSearcherReset( SaveData_GetEventWork(fsys->savedata) );

	//--ԃCxgXV
	if (!walk_flag) {
		EVTIME_Update(fsys);
	}

	//--}bv̎d|p[ÑNA
	if (!walk_flag){
		//}bvWv̂Ƃ̂ݏiă][؂ւꍇ͏Ȃj
		GIMMICKWORK_Init(SaveData_GetGimmickWork(fsys->savedata));
	}
	
	//--VXV
	{
		EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
		u16 id = WeatherData_Get(fsys, zone_id);
		if ((id == WEATHER_SYS_MIST1 && SysFlag_KiribaraiCheck(ev) == TRUE)
				|| (id == WEATHER_SYS_FLASH && SysFlag_FlashCheck(ev) == TRUE)
		   ) {
			id = WEATHER_SYS_SUNNY;
		}
		Situation_SetWeatherID(sit, id);
	}

	//--J
	if (walk_flag) {
		int old_camera = Situation_GetCameraID(sit);
		int new_camera = ZoneData_GetCameraID(zone_id);
		//ă][؂ւ̂ɃJςĂ͂܂
		GF_ASSERT(old_camera == new_camera);
	} else {
		//JwXV
		Situation_SetCameraID(sit, ZoneData_GetCameraID(zone_id));
	}

	//--[vo^
	if (!walk_flag){
		u16 warp_id;
		//[vf[^ɓo^Ă}bvȂ΁A߂Ƃēo^Ă
		warp_id = WARPDATA_SearchByRoomID(zone_id);
		if (warp_id != 0) {
			Situation_SetWarpID(sit, warp_id);
		}
	}

	//--XNvg
	SpScriptSearch(fsys, SP_SCRID_FLAG_CHANGE);


	//GJEg֘A
	fsys->encount.walk_count = 0;
	fsys->encount.WinPokeCount = 0;
#if 0
	//Tt@ɂȂƂ̏
	if ( !SysFlag_SafariCheck(SaveData_GetEventWork(fsys->savedata)) ){
		//][ύXꍇ́A][XV
		ENC_SV_PTR data;
		data = EncDataSave_GetSaveDataPtr(fsys->savedata);
		MP_UpdatePlayerZoneHist(data, fsys->location->zone_id);		
		//Ĉړꍇ͈ړ|P̈ړ
		if (walk_flag){
			//ړ|Pאڈړ
			MP_MovePokemonNeighboring(data);
		}
	}
#endif	
}

//-----------------------------------------------------------------------------
/**
 * @brief	}bvJñtB[hOBJ֘A
 * @param	fsys		tB[h䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static void MapChg_FieldOBJ_Create(FIELDSYS_WORK * fsys)
{
	int sex;
	int form;
	SITUATION *situ;
	PLAYER_SAVE_DATA *jikisave;
	
	//tB[hOBJ ,l͓K
	fsys->fldobjsys = FieldOBJSys_Init( fsys, FLDOBJ_ENTRY_MAX, FLDMAP_PRI_OBJSYS );
	
	//@ǉ
	sex = MyStatus_GetMySex(SaveData_GetMyStatus(fsys->savedata));
	situ = SaveData_GetSituation( fsys->savedata );
	jikisave = Situation_GetPlayerSaveData( situ );
	fsys->player = Player_Init( fsys->fldobjsys,
			fsys->location->grid_x,
			fsys->location->grid_z,
			fsys->location->dir,
			jikisave->form, sex, jikisave );
	
	//ŏ̃][StB[hOBJǉ
	EventData_SetFieldOBJ( fsys );

	//tB[hOBJ쏈|[Y
	FieldOBJSys_MoveStopAll( fsys->fldobjsys );
}
//-----------------------------------------------------------------------------
/**
 * @brief	}bvĨtB[hOBJ֘A
 * @param	fsys		tB[h䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static void MapChg_FieldOBJ_Delete(FIELDSYS_WORK * fsys)
{
    CommPlayerManagerReset();               // ʐM莩@
    Player_Delete( fsys->player );			// @
	FieldOBJ_DeleteAll(fsys->fldobjsys);	// FieldOBJS
	FieldOBJSys_Delete(fsys->fldobjsys);	// FieldOBJVXe
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static void MapChg_FieldOBJ_Continue(FIELDSYS_WORK * fsys)
{
	//tB[hOBJ ,l͓K
	fsys->fldobjsys = FieldOBJSys_Init( fsys, FLDOBJ_ENTRY_MAX, FLDMAP_PRI_OBJSYS );
	

	Field_LoadFieldObj(fsys);
	//@ǉ
	
	{
		SITUATION *situ = SaveData_GetSituation( fsys->savedata );
		PLAYER_SAVE_DATA *jikisave = Situation_GetPlayerSaveData( situ );
		int sex = MyStatus_GetMySex(SaveData_GetMyStatus(fsys->savedata));
		fsys->player = Player_FieldOBJUseRecover(fsys->fldobjsys,jikisave,sex);
	}

	//tB[hOBJ쏈|[Y
	FieldOBJSys_MoveStopAll( fsys->fldobjsys );
}

//-----------------------------------------------------------------------------
/**
 * @brief	}bvc[iAAgr[gAetc.j̐ݒ
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	type		c[̃^Cvw
 */
//-----------------------------------------------------------------------------
static void MapChg_SetupMapTools(FIELDSYS_WORK * fsys)
{
	//og^[̂߂Ƀ}bv[h̏CsĂ
	MapChg_MapModeControl(fsys);

	GF_ASSERT(fsys->map_tool_list == NULL);
	//[hZbgAbv
	SetUpWorldMatrix( fsys->location->zone_id, fsys->World );
	//}bv}gNX㏑FR224
	if (SysWork_HideMapWorkCheck(SaveData_GetEventWork(fsys->savedata),HIDEMAP_ID_D18)) {
		World_Overwrite_R224(fsys->World);
	}
	//}bv}gNX㏑FL04
	if (!SysWork_HideMapWorkCheck(SaveData_GetEventWork(fsys->savedata),HIDEMAP_ID_L04)) {
		World_Overwrite_L04(fsys->World);
	}
	
	GF_ASSERT(fsys->MapMode < MAP_MODE_MAX);
	fsys->MapModeData = &MapModeData[fsys->MapMode];
	fsys->DivMapMode = fsys->MapModeData->DivMapMode;
	fsys->subscreen = fsys->MapModeData->subscreen;
	SetUpMapToolList(&fsys->map_tool_list, fsys->MapModeData->MapToolMode);

	if (fsys->MapModeData->SpecialAttrFlag) {
		//Agr[gǂݍ
		SPATTR_SetUpGroundAttr(fsys, fsys->MapModeData->SpecialAttrNum);
	}
	
}

//-----------------------------------------------------------------------------
/**
 * @brief	}bvc[iAAgr[gAetc.j̔p
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	type		c[̃^Cvw
 */
//-----------------------------------------------------------------------------
static void MapChg_RemoveMapTools(FIELDSYS_WORK * fsys)
{
	GF_ASSERT(fsys->map_tool_list != NULL);
	fsys->map_tool_list = NULL;
	fsys->subscreen = FIELD_SUBSCRN_MAX;

	if (fsys->MapModeData->SpecialAttrFlag) {
		//nAgr[gj
		SPATTR_FreeGroundAttr(fsys);
	}
	fsys->MapModeData = NULL;
}

//-----------------------------------------------------------------------------
/**
 * @brief	`m[g̊Jnf[^쐬
 * @param	fsys		tB[h䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
void FNoteStartDataSet( FIELDSYS_WORK * fsys )
{
	if( fsys->fnote != NULL ){
		void * dat;

		dat = FNOTE_StartDataMake( fsys->location->zone_id, HEAPID_WORLD );
		FNOTE_DataSave( fsys->fnote, dat, FNOTE_TYPE_START );
	}
}

// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
#if S2424_060818_FIX
//-----------------------------------------------------------------------------
/**
 * @brief	`m[g̊Jnf[^쐬iʐMG[̏ꍇj
 * @param	fsys		tB[h䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static void FNoteStartDataSet_SioError( FIELDSYS_WORK * fsys )
{
	if( fsys->fnote != NULL ){
		SITUATION * sit = SaveData_GetSituation( fsys->savedata );
		LOCATION_WORK * lw = Situation_GetSpecialLocation( sit );
		void * dat = FNOTE_StartDataMake( lw->zone_id, HEAPID_WORLD );
		FNOTE_DataSave( fsys->fnote, dat, FNOTE_TYPE_START );
	}
}
#endif
// ----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
/**
 * @brief	݈ʒuLOCATION_WORKɃZbg
 * @param	loc			LOCATION_WORKւ̃|C^
 * @param	fsys		tB[h䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static void SetLocationHere(LOCATION_WORK * loc, const FIELDSYS_WORK * fsys)
{
	SetLocation(loc, fsys->location->zone_id, DOOR_ID_JUMP_CODE,
			Player_NowGPosXGet(fsys->player), Player_NowGPosZGet(fsys->player), DIR_DOWN);
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static BOOL IsUnionRoomSave(const FIELDSYS_WORK * fsys)
{
	if (ZoneData_IsPokecen2F(fsys->location->zone_id)
		&& fsys->location->grid_x == 7
		&& fsys->location->grid_z == 6) {
		return TRUE;
	} else {
		return FALSE;
	}
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static void SetUnionExit(FIELDSYS_WORK * fsys)
{
	//|PZQFJn̏ꍇ͓ڑݒ
	LOCATION_WORK * sp = Situation_GetSpecialLocation(SaveData_GetSituation(fsys->savedata));
	EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
	SetLocation(sp, fsys->location->zone_id, DOOR_ID_JUMP_CODE, 8, 2, DIR_DOWN);
}
//============================================================================================
//
//
//							Q[Jn
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	CxgFQ[Jn
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_FirstMapIn(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	int * seq = FieldEvent_GetSeqWork(event);

	switch (*seq) {
	case 0:
		MapChg_SetNewLocation(fsys, fsys->location);

		//AAgr[gA}bv[h̕@
		MapChg_SetupMapTools(fsys);

		MapChg_UpdateGameData(fsys, FALSE);

		MapChg_FieldOBJ_Create(fsys);

		(*seq) ++;
		break;
	case 1:
		EventCmd_StartField_FadeIn(event);
		(*seq) ++;
		break;
	case 2:
		return TRUE;
	}
	return FALSE;
}
//-----------------------------------------------------------------------------
/**
 * @brief	Q[JnCxgZbg
 * @param	fsys		tB[h䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
void EventSet_FirstMapIn(FIELDSYS_WORK * fsys)
{
	GMEVENT_CONTROL * event;

	fsys->MapMode = MAP_MODE_GROUND;	//n߂͒nォX^[g
	GameStartScriptInit(fsys);				//Q[Jn̓XNvg
	event = FieldEvent_Set(fsys, GMEVENT_FirstMapIn, NULL);
}

//-----------------------------------------------------------------------------
/**
 * @brief	CxgFReBj[
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_ContinueMapIn(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
	int * seq = FieldEvent_GetSeqWork(event);

	switch (*seq) {
	case 0:
        //[hɌĂԒnf[^
        UnderGroundDataLoadUpdate(fsys->savedata);
        // `m[g\`FbN
		if( FNOTE_GameStartOpenCheck(SaveData_GetFNote(fsys->savedata),SysFlag_FNoteCheck(ev)) ){
			FieldFantasyNote_SetProc( fsys, NULL );
			(*seq) = 4;
			break;
		}
		OS_Printf( "FNOTE_FLAG : %d\n", SysFlag_FNoteCheck(ev) );

	case 1:		// tB[h
		fsys->fnote = FNOTE_SavePageGet(SaveData_GetFNote(fsys->savedata),
				SysFlag_FNoteCheck(ev));//`m[gy[W

		if (SysFlag_CommCounterCheck(ev)) {
		//ȏ󋵂̕AsReBj[
			SITUATION * sit = SaveData_GetSituation(fsys->savedata);
			//|PZQFJn̏ꍇ͓ڑݒ
			if (IsUnionRoomSave(fsys)) {
				SetUnionExit(fsys);
			}
			SysFlag_CommCounterReset(ev);
			MapChg_SetNewLocation(fsys, Situation_GetSpecialLocation(sit));
			//AAgr[gA}bv[h̕@
			MapChg_SetupMapTools(fsys);
			MapChg_UpdateGameData(fsys, FALSE);
			MapChg_FieldOBJ_Create(fsys);
		} else {
		//ʏ̃ReBj[
			MapChg_SetNewLocation(fsys, NULL);
			//AAgr[gA}bv[h̕@
			MapChg_SetupMapTools(fsys);
			//MapChg_UpdateGameData(fsys, FALSE);	ReBj[ł͂͌Ă΂Ȃ
			EVTIME_Update(fsys);
			MapChg_FieldOBJ_Continue(fsys);
		}

		FNoteStartDataSet( fsys );		//`m[g̊Jnf[^쐬

		FldFlgInit_Continue(fsys);		//ReBj[ŗLtOƂ

		(*seq) = 2;
		break;

	case 2:		// tF[hZbg
		EventCmd_StartField_FadeIn(event);
		(*seq) = 3;
		break;

	case 3:		// I
		return TRUE;

	case 4:		// `m[gI҂
		if( !( FieldEvent_Cmd_WaitSubProcEnd(fsys) ) ) {
			(*seq) = 1;
		}
		break;
	}

	return FALSE;
}
//-----------------------------------------------------------------------------
/**
 * @brief	Q[JnCxgZbg
 * @param	fsys		tB[h䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
void EventSet_ContinueMapIn(FIELDSYS_WORK * fsys)
{
	GMEVENT_CONTROL * event;

	fsys->MapMode = MAP_MODE_GROUND;	//n߂͒nォX^[g
	event = FieldEvent_Set(fsys, GMEVENT_ContinueMapIn, NULL);
}


//============================================================================================
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief
 */
//-----------------------------------------------------------------------------
typedef struct {
	BOOL WarpEffEnd;
	LOCATION_WORK union_loc;
}ERROR_CONTINUE_WORK;

//-----------------------------------------------------------------------------
/**
 * @brief
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_ErrorContinueMapIn(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	ERROR_CONTINUE_WORK * ecw = FieldEvent_GetSpecialWork(event);
	EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
	int * seq = FieldEvent_GetSeqWork(event);

	switch (*seq) {
	case 0:
		WIPE_SetBrightness( WIPE_DISP_MAIN, WIPE_FADE_BLACK );
		WIPE_SetBrightness( WIPE_DISP_SUB, WIPE_FADE_BLACK );

        //[hɌĂԒnf[^
        UnderGroundDataLoadUpdate(fsys->savedata);

		fsys->fnote = FNOTE_SavePageGet(SaveData_GetFNote(fsys->savedata),
				SysFlag_FNoteCheck(ev));//`m[gy[W

		(*seq) ++;
		break;

	case 1:
		MapChg_SetNewLocation(fsys, &ecw->union_loc);
		//AAgr[gA}bv[h̕@
		MapChg_SetupMapTools(fsys);
		MapChg_UpdateGameData(fsys, FALSE);
		MapChg_FieldOBJ_Create(fsys);
// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
#if S2424_060818_FIX
		FNoteStartDataSet_SioError( fsys );		//`m[g̊Jnf[^쐬
#endif
// ----------------------------------------------------------------------------
		(*seq) ++;
		break;

	case 2:
		// jI[ʐMJn
		fsys->union_work = Comm_UnionRoomInit(fsys);
		// jI[OBJ^XNN
		fsys->union_view = Comm_UnionRoomViewInit(fsys->union_work);

		EventCmd_StartFieldMap(event);
		(*seq) ++;
		break;

	case 3:
		ecw->WarpEffEnd = FALSE;
        StartJumpPointEffect(fsys, FALSE, &ecw->WarpEffEnd);
		(*seq) ++;
		break;

	case 4:
		if (ecw->WarpEffEnd) {
			(*seq) ++;
		}
		break;
	case 5:
		sys_FreeMemoryEz(ecw);
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	Q[JnCxgZbg
 * @param	fsys		tB[h䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
void EventSet_ErrorContinueMapIn(FIELDSYS_WORK * fsys)
{
	GMEVENT_CONTROL * event;
	ERROR_CONTINUE_WORK * ecw;

	if (ZoneData_IsUnionRoom(fsys->location->zone_id)) {
		/* pȂ */
	} else if (IsUnionRoomSave(fsys)) {
		//|PZQFJn̏ꍇ͓ڑݒ
		EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
		SetUnionExit(fsys);
		SysFlag_CommCounterSet(ev);

	} else {

		//ʐMG[łjIȊȌꍇ͒ʏReBj[֕
		EventSet_ContinueMapIn(fsys);
		return;
	}

	ecw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(ERROR_CONTINUE_WORK));
	ecw->WarpEffEnd = FALSE;
	SetLocation(&ecw->union_loc, ZONE_ID_UNION, DOOR_ID_JUMP_CODE, 8, 14, DIR_UP);

	fsys->MapMode = MAP_MODE_UNION;
	FieldEvent_Set(fsys, GMEVENT_ErrorContinueMapIn, ecw);
}


//============================================================================================
//
//
//							Q[I
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	CxgFQ[I
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_GameEnd(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	int * seq = FieldEvent_GetSeqWork(event);
	switch (*seq) {
	case 0:
		EventCmd_FieldFadeOut(event);
		(*seq) ++;
		break;

	case 1:
		EventCmd_FinishFieldMap(event);
		(*seq) ++;
		break;

	case 2:
		MapChg_FieldOBJ_Delete(fsys);
		MapChg_RemoveMapTools(fsys);

		GameSystem_FinishGame(fsys);

		return TRUE;
	}

	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	Q[I
 *
 * Q[CIB
 * fobOpŃ[N`FbN̂ߍ쐬B
 * |Pł̓[U[ŃQ[I邱ƂȂ̂ŁAiłł
 * gpȂ͂B
 */
//-----------------------------------------------------------------------------
void EventSet_ReturnToTitle(FIELDSYS_WORK * fsys)
{
	FieldEvent_Set(fsys, GMEVENT_GameEnd, NULL);
}



//============================================================================================
//============================================================================================
//-----------------------------------------------------------------------------
// @brief	}bvJڃCxg(AjWv)
//-----------------------------------------------------------------------------
static BOOL GMEVENT_MapChange(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);
	LOCATION_WORK* location = &mcw->next;
	
	switch (mcw->seq) {
	case 0:
		Snd_SePlay( SEQ_SE_DP_KAIDAN2 );
		Snd_EvMapChangeBgmFadeCheck( fsys, location->zone_id );	//tB[hBGMtF[hAEg
		EventCmd_FadeOut_FinishField(event);	//TuCxgĂяõCxg̓EFCg
		(mcw->seq) ++;
		break;
	case 1:
		//TuCxgĂяõCxg̓EFCg
		EventCmd_MapChangeByLocation(event, &mcw->next);
		(mcw->seq) ++;
		break;
	case 2:
		if( Snd_FadeCheck() != 0 ){								//TEhtF[h
			break;
		}
		Snd_EvMapChangeBgmPlay( fsys, location->zone_id );		//tB[hBGMĐ
		EventCmd_StartField_FadeIn(event);	//TuCxgĂяõCxg̓EFCg
		(mcw->seq) ++;
		break;
	case 3:
		sys_FreeMemoryEz(mcw);
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	}bvJڃCxgZbg
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	next		Jڐ}bvw
 */
//-----------------------------------------------------------------------------
void EventSet_EasyMapChangeByLocation(FIELDSYS_WORK * fsys, const LOCATION_WORK * next)
{
	EVENT_MAPCHG_WORK * mcw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_MAPCHG_WORK));
	mcw->seq = 0;
	mcw->next = *next;
	FieldEvent_Set(fsys, GMEVENT_MapChange, mcw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	}bvJڃCxgZbg
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	zone		Jڐ}bṽ][w
 * @param	door_id		Jڐ}bvł̏oow
 * @param	x			Jڐ}bvłXObhʒu
 * @param	z			Jڐ}bvłYObhʒu
 * @param	dir			Jڐ}bvł̏
 *
 * Jڐ}bv̂ǂɏo邩͎̏̃}bvǂݍނ܂ł͂킩Ȃ͂Ȃ̂
 * {͍Ww͖ʂȂǁAÔ߁B܂GAƃ][̊֌W͍čl̂
 * GAwȂȂ\B
 */
//-----------------------------------------------------------------------------
void EventSet_EasyMapChange(FIELDSYS_WORK * fsys, int zone, int door_id, int x, int z, int dir )
{
	LOCATION_WORK next;
	SetLocation(&next, zone, door_id, x, z, dir);
	EventSet_EasyMapChangeByLocation(fsys, &next);
}

//-----------------------------------------------------------------------------
/**
 * @brief	}bvJڃCxgR}h
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	next		Jڐ}bvw
 */
//-----------------------------------------------------------------------------
void EventCmd_EasyMapChangeByLocation(GMEVENT_CONTROL * event, const LOCATION_WORK * next)
{
	EVENT_MAPCHG_WORK * mcw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_MAPCHG_WORK));
	mcw->seq = 0;
	mcw->next = *next;
	FieldEvent_Call(event, GMEVENT_MapChange, mcw);
}
//-----------------------------------------------------------------------------
/**
 * @brief	}bvJڃCxgR}h
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	zone		Jڐ}bṽ][w
 * @param	door_id		Jڐ}bvł̏oow
 * @param	x			Jڐ}bvłXObhʒu
 * @param	z			Jڐ}bvłYObhʒu
 * @param	dir			Jڐ}bvł̏
 */
//-----------------------------------------------------------------------------
void EventCmd_EasyMapChange(GMEVENT_CONTROL * event, int zone, int door_id, int x, int z, int dir )
{
	LOCATION_WORK next;
	SetLocation(&next, zone, door_id, x, z, dir);
	EventCmd_EasyMapChangeByLocation(event, &next);
}

//============================================================================================
//
//
//	Cxg[R}hF}bvJڊ֘A
//
//	TuCxgFieldEvent_CallŌĂяoƂŎgpB
//	݂̃Cxg~āAɃTuCxgтB
//	TuCxgIƌ݂̃CxgĂяoB
//
//	IɂFieldEvent_CallĂяoăTuCxgssĂ邪A
//	Cxg͒PȃR}hĂяoŎsł悤Ȍ`ɐĂ\B
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	[R}hp[N`
 */
//-----------------------------------------------------------------------------
typedef struct {
	int seq;
	LOCATION_WORK next;
}SIMPLE_MAPCHG_WORK;

//-----------------------------------------------------------------------------
/**
 * @brief	TuCxgF}bvJ
 * @param	event	Cxg䃏[Nւ̃|C^
 * @retval	TRUE	CxgI
 * @retval	FALSE	Cxgp
 *
 * TuCxgFieldEvent_CallŌĂяoƂŎgpB
 * ݂̃Cxg~āAɃTuCxgтB
 * TuCxgIƌ݂̃CxgĂяoB
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_Sub_MapChange(GMEVENT_CONTROL * event)
{
	u16 bgm_no;
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	SIMPLE_MAPCHG_WORK * smw = FieldEvent_GetSpecialWork(event);

	switch (smw->seq) {
	case 0:
		//--------I--------
		MapChg_FieldOBJ_Delete(fsys);
		MapChg_RemoveMapTools(fsys);
		(smw->seq) ++;
		break;
		
	case 1:
		//--------Jn--------
		MapChg_SetNewLocation(fsys, &smw->next);

		//AAgr[gA}bv[h̕@
		MapChg_SetupMapTools(fsys);

		MapChg_UpdateGameData(fsys, FALSE);

		SwayGrass_InitSwayGrass(fsys->SwayGrass);	//hꑐ
		(smw->seq) ++;
		break;
		
	case 2:
		MapChg_FieldOBJ_Create(fsys);
		sys_FreeMemoryEz(smw);
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hF}bvJ
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	next		Jڐw肷LOCATION_WORK^ւ̃|C^
 */
//-----------------------------------------------------------------------------
void EventCmd_MapChangeByLocation(GMEVENT_CONTROL * event, const LOCATION_WORK * next)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	SIMPLE_MAPCHG_WORK * smw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(SIMPLE_MAPCHG_WORK));
	if (GameSystem_CheckFieldProcExists(fsys)) {
		GF_ASSERT("mainproĉɃ}bvJڏ\n" && 0);
		return;
	}
	smw->seq = 0;
	smw->next = *next;
	FieldEvent_Call(event, GMEVENT_Sub_MapChange, smw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hF}bvJ
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	zone_id		Jڐ][IDw
 * @param	door_id		Jڐow
 * @param	x			JڐXWwidoor_id == DOOR_ID_JUMP_CODÊƂ̂ݗLj
 * @param	z			JڐZWwidoor_id == DOOR_ID_JUMP_CODÊƂ̂ݗLj
 * @param	dir			oł̕w
 *
 */
//-----------------------------------------------------------------------------
void EventCmd_MapChange(GMEVENT_CONTROL * event, int zone_id, int door_id, int x, int z, int dir)
{
	LOCATION_WORK next;
	SetLocation(&next, zone_id, door_id, x, z, dir);
	EventCmd_MapChangeByLocation(event, &next);
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static BOOL GMEVENT_Sub_MapChangeFull(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	SIMPLE_MAPCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);
	LOCATION_WORK* location = &mcw->next;

	switch (mcw->seq) {
	case 0:
		Snd_EvMapChangeBgmFadeCheck( fsys, location->zone_id );	//tB[hBGMtF[hAEg
		EventCmd_FinishFieldMap(event);
		(mcw->seq) ++;
		break;
	case 1:
		EventCmd_MapChangeByLocation(event, &mcw->next);
		(mcw->seq) ++;
		break;
	case 2:
		if( Snd_FadeCheck() != 0 ){								//TEhtF[h
			break;
		}
		Snd_EvMapChangeBgmPlay( fsys, location->zone_id );		//tB[hBGMĐ
		EventCmd_StartFieldMap(event);
		(mcw->seq) ++;
		break;
	case 3:
		sys_FreeMemoryEz(mcw);
		return TRUE;
	}
	return FALSE;
}
//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hF}bvؑ
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	zone_id		Jڐ][IDw
 * @param	door_id		Jڐow
 * @param	x			JڐXWwidoor_id == DOOR_ID_JUMP_CODÊƂ̂ݗLj
 * @param	z			JڐZWwidoor_id == DOOR_ID_JUMP_CODÊƂ̂ݗLj
 * @param	dir			oł̕w
 *
 * tB[h}bvI}bvؑ֏tB[h}bvĊJ܂ł̏Aōs
 */
//-----------------------------------------------------------------------------
void EventCmd_MapChangeFull(GMEVENT_CONTROL * event,
		int zone_id, int door_id, int x, int z, int dir)
{
	SIMPLE_MAPCHG_WORK * smw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(SIMPLE_MAPCHG_WORK));
	smw->seq = 0;
	SetLocation(&smw->next, zone_id, door_id, x, z, dir);
	FieldEvent_Call(event, GMEVENT_Sub_MapChangeFull, smw);
}

//============================================================================================
//
//
//			Ђł킴@Ƃԗp}bvړ
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	Ԑp}bvJڃCxgp䃏[N
 */
//-----------------------------------------------------------------------------
typedef struct {
	int seq;							///<V[PXێ[N
	TCB_PTR tcb_sky;					///<ԓTCB_PTR
	LOCATION_WORK next;					///<}bvJڐwp[N
	FLD_3D_ANIME_WORK_PTR DoorAnimeWork;
}EVENT_MAPCHG_WORK_SKY;

static BOOL GMEVENT_MapChangeBySky(GMEVENT_CONTROL * event);
static void EventCmd_Sky_FinishField(GMEVENT_CONTROL * event);
static void EventCmd_FadeOut_FinishField(GMEVENT_CONTROL * event);
static BOOL GMEVENT_Sub_Sky_FinishField(GMEVENT_CONTROL * event);
static void EventCmd_StartField_FadeInSky(GMEVENT_CONTROL * event);
static BOOL GMEVENT_Sub_StartField_FadeInSky(GMEVENT_CONTROL * event);
static void EventCmd_FieldFadeInSky(GMEVENT_CONTROL * event);
static BOOL GMEVENT_Sub_WaitFadeSky(GMEVENT_CONTROL * event);

//-----------------------------------------------------------------------------
/**
 * @brief	ԗp}bvJڃCxgZbg
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	zone		Jڐ}bṽ][w
 * @param	door_id		Jڐ}bvł̏oow
 * @param	x			Jڐ}bvłXObhʒu
 * @param	z			Jڐ}bvłYObhʒu
 * @param	dir			Jڐ}bvł̏
 */
//-----------------------------------------------------------------------------
void EventSet_MapChangeBySky(
		FIELDSYS_WORK * fsys, int zone, int door_id, int x, int z, int dir )
{
	LOCATION_WORK next;
	SetLocation(&next, zone, door_id, x, z, dir);
	
	{
		EVENT_MAPCHG_WORK_SKY * mcw =
			sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_MAPCHG_WORK_SKY));
		mcw->seq = 0;
		mcw->tcb_sky = NULL;
		mcw->next = next;
		FieldEvent_Set(fsys, GMEVENT_MapChangeBySky, mcw);
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	ԗp}bvJڃCxgZbg@Cxg`FW^
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	zone		Jڐ}bṽ][w
 * @param	door_id		Jڐ}bvł̏oow
 * @param	x			Jڐ}bvłXObhʒu
 * @param	z			Jڐ}bvłYObhʒu
 * @param	dir			Jڐ}bvł̏
 */
//-----------------------------------------------------------------------------
void EventChange_MapChangeBySky(
		GMEVENT_CONTROL *event, int zone, int door_id, int x, int z, int dir )
{
	LOCATION_WORK next;
	SetLocation(&next, zone, door_id, x, z, dir);
	
	{
		EVENT_MAPCHG_WORK_SKY * mcw =
			sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_MAPCHG_WORK_SKY));
		mcw->seq = 0;
		mcw->tcb_sky = NULL;
		mcw->next = next;
		FieldEvent_Change(event, GMEVENT_MapChangeBySky, mcw);
	}
}

//-----------------------------------------------------------------------------
// @brief	}bvJڃCxg(Ƃ)
//-----------------------------------------------------------------------------
static BOOL GMEVENT_MapChangeBySky(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK_SKY * mcw = FieldEvent_GetSpecialWork(event);
	LOCATION_WORK* location = &mcw->next;
	
	switch (mcw->seq) {
	case 0:
		Snd_EvMapChangeBgmFadeCheck( fsys, location->zone_id );	//tB[hBGMtF[hAEg
		EventCmd_Sky_FinishField(event);	//TuCxgĂяõCxg̓EFCg
		(mcw->seq) ++;
		break;
	case 1:
		//@Ԃ񑫕sɂ
		Player_FormSet(fsys->player, HERO_FORM_NORMAL);
		//TuCxgĂяõCxg̓EFCg
		EventCmd_MapChangeByLocation(event, &mcw->next);
		(mcw->seq) ++;
		break;
	case 2:
		if( Snd_FadeCheck() != 0 ){								//TEhtF[h
			break;
		}
		Snd_EvMapChangeBgmPlay( fsys, location->zone_id );		//tB[hBGMĐ

		//ԌŗLtOƂ
		FldFlgInit_FlySky(fsys);

		EventCmd_StartField_FadeInSky(event);	//TuCxgĂяõCxg̓EFCg
		(mcw->seq) ++;
		break;
	case 3:
		sys_FreeMemoryEz(mcw);
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hFtB[hvZXI@Ƃ
 * @param	event		Cxg䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static void EventCmd_Sky_FinishField(GMEVENT_CONTROL * event)
{
	FieldEvent_Call(event, GMEVENT_Sub_Sky_FinishField, NULL);
}

//-----------------------------------------------------------------------------
// @brief	tB[hI(Ƃ)
//-----------------------------------------------------------------------------
static BOOL GMEVENT_Sub_Sky_FinishField(GMEVENT_CONTROL * event)
{
	int * seq = FieldEvent_GetSeqWork(event);
	switch (*seq) {
	case 0:
		EventCmd_FinishFieldMap(event);
		(*seq) ++;
		break;
	case 1:
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hFtB[hvZXJntF[hC@Ƃ
 * @param	event		Cxg䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static void EventCmd_StartField_FadeInSky(GMEVENT_CONTROL * event)
{
	EVENT_MAPCHG_WORK_SKY * mcw = FieldEvent_GetSpecialWork(event);
	FieldEvent_Call(event, GMEVENT_Sub_StartField_FadeInSky, mcw);
}

//-----------------------------------------------------------------------------
// @brief	tB[htF[hC@Ƃ
//-----------------------------------------------------------------------------
static BOOL GMEVENT_Sub_StartField_FadeInSky(GMEVENT_CONTROL * event)
{
	int * seq = FieldEvent_GetSeqWork(event);
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);	
	switch (*seq) {
	case 0:
		EventCmd_StartFieldMap(event);
		(*seq) ++;
		break;
	case 1:
		//n\
		PlaceNameRequestByFsys(fsys);
		
		EventCmd_FieldFadeInSky(event);
		(*seq) ++;
		break;
	case 2:
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hFtF[hC@Ƃ
 * @param	event		Cxg䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static void EventCmd_FieldFadeInSky(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK_SKY * mcw = FieldEvent_GetSpecialWork(event);
	
	if (!GameSystem_CheckFieldProcExists(fsys)) {
		GF_ASSERT("mainprocȂ̂ɃtF[hs\n" && 0);
		return;
	}
	
	//ɃJbgCp̂̂Ă@tF[hC͂̒
	{
#if 0
		WIPE_SYS_Start(
            WIPE_PATTERN_WMS, WIPE_TYPE_FADEIN,
            WIPE_TYPE_FADEIN, WIPE_FADE_WHITE, COMM_BRIGHTNESS_SYNC, 1, HEAPID_FIELD );
#else
		mcw->tcb_sky = FieldHidenSkyLanding_Init( fsys, Player_SexGet(fsys->player) );
#endif
		FieldEvent_Call(event, GMEVENT_Sub_WaitFadeSky, mcw);
	}
}

//-----------------------------------------------------------------------------
// @brief	tB[htF[hC҂@ƂԁB
// ɋԏIGtFNg҂𓖂Ă
//-----------------------------------------------------------------------------
static BOOL GMEVENT_Sub_WaitFadeSky(GMEVENT_CONTROL * event)
{
	EVENT_MAPCHG_WORK_SKY * mcw = FieldEvent_GetSpecialWork(event);
	
	if( FieldHidenSkyLanding_EndCheck(mcw->tcb_sky) == TRUE ){
		FieldHidenSkyLanding_End( mcw->tcb_sky );
		return( TRUE );
	}
	
	return FALSE;
}

//============================================================================================
//
//
//			Ȃʂ̂ЂAȂقAe|[gp}bvړ
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	Ȃʂp}bvJڃCxgp䃏[N
 */
//-----------------------------------------------------------------------------
typedef struct {
	int seq;							///<V[PXێ[N
	ANATYPE ana_type;					///<ANATYPE
	TCB_PTR tcb_jiki;					///<TCB_PTR
	LOCATION_WORK next;					///<}bvJڐwp[N
}EVENT_MAPCHG_WORK_ANANUKE;

static BOOL GMEVENT_MapChangeByAnanuke(GMEVENT_CONTROL * event);
static void EventCmd_Ananuke_FinishField(GMEVENT_CONTROL * event);
static void EventCmd_FadeOut_FinishField(GMEVENT_CONTROL * event);
static BOOL GMEVENT_Sub_Ananuke_FinishField(GMEVENT_CONTROL * event);
static void EventCmd_StartField_FadeInAnanuke(GMEVENT_CONTROL * event);
static BOOL GMEVENT_Sub_StartField_FadeInAnanuke(GMEVENT_CONTROL * event);
static void EventCmd_FieldFadeInAnanuke(GMEVENT_CONTROL * event);
static BOOL GMEVENT_Sub_WaitFadeAnanuke(GMEVENT_CONTROL * event);

//-----------------------------------------------------------------------------
/**
 * @brief	A@Ae|[g}bvJڃCxg`FW
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	escape		Jڐ
 * @param	type		ANATYPE
 */
//-----------------------------------------------------------------------------
void EventChange_MapChangeByAnanuke(
	GMEVENT_CONTROL *event, const LOCATION_WORK *escape, u32 ana_type )
{
	EVENT_MAPCHG_WORK_ANANUKE * mcw =
		sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_MAPCHG_WORK_ANANUKE));
	mcw->seq = 0;
	mcw->ana_type = ana_type;
	mcw->tcb_jiki = NULL;
	mcw->next = *escape;
	FieldEvent_Change( event, GMEVENT_MapChangeByAnanuke, mcw );
}

//-----------------------------------------------------------------------------
// @brief	}bvJڃCxg(Ȃʂ̂Ђ)
//-----------------------------------------------------------------------------
static BOOL GMEVENT_MapChangeByAnanuke(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK_ANANUKE* mcw = FieldEvent_GetSpecialWork(event);
	LOCATION_WORK* location = &mcw->next;
	
	switch (mcw->seq) {
	case 0:
		Snd_EvMapChangeBgmFadeCheck( fsys, location->zone_id );	//tB[hBGMtF[hAEg
		EventCmd_Ananuke_FinishField(event);	//TuCxgĂяo
		(mcw->seq) ++;
		break;
	case 1:
		//@Ԃ񑫕sɂ
		Player_FormSet(fsys->player, HERO_FORM_NORMAL);
		//TuCxgĂяõCxg̓EFCg
		EventCmd_MapChangeByLocation(event, &mcw->next);
		(mcw->seq) ++;
		break;
	case 2:
		if( Snd_FadeCheck() != 0 ){								//TEhtF[h
			break;
		}
		Snd_EvMapChangeBgmPlay( fsys, location->zone_id );		//tB[hBGMĐ

		//e|[gEE@ŗLtOƂ
		if (mcw->ana_type == ANATYPE_TEL){
			FldFlgInit_Teleport(fsys);
		}else if( (mcw->ana_type == ANATYPE_ANA)||
					(mcw->ana_type == ANATYPE_ANAHORI) ){
			FldFlgInit_Escape(fsys);
		}else{
			GF_ASSERT(0&&"Eo@s");
		}

		EventCmd_StartField_FadeInAnanuke(event);	//TuCxgĂяo
		(mcw->seq) ++;
		break;
	case 3:
		sys_FreeMemoryEz(mcw);
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hFtB[hvZXI@Ȃʂ̂Ђ
 * @param	event		Cxg䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static void EventCmd_Ananuke_FinishField(GMEVENT_CONTROL * event)
{
	FieldEvent_Call(event, GMEVENT_Sub_Ananuke_FinishField, NULL);
}

//-----------------------------------------------------------------------------
// @brief	tB[hI(Ȃʂ̂Ђ)
//-----------------------------------------------------------------------------
static BOOL GMEVENT_Sub_Ananuke_FinishField(GMEVENT_CONTROL * event)
{
	int * seq = FieldEvent_GetSeqWork(event);
	switch (*seq) {
	case 0:
		EventCmd_FinishFieldMap(event);
		(*seq) ++;
		break;
	case 1:
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hFtB[hvZXJntF[hC@Ȃʂ̂Ђ
 * @param	event		Cxg䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static void EventCmd_StartField_FadeInAnanuke(GMEVENT_CONTROL * event)
{
	EVENT_MAPCHG_WORK_ANANUKE * mcw = FieldEvent_GetSpecialWork(event);
	FieldEvent_Call(event, GMEVENT_Sub_StartField_FadeInAnanuke, mcw);
}

//-----------------------------------------------------------------------------
// @brief	tB[htF[hC@Ȃʂ̂Ђ
//-----------------------------------------------------------------------------
static BOOL GMEVENT_Sub_StartField_FadeInAnanuke(GMEVENT_CONTROL * event)
{
	int * seq = FieldEvent_GetSeqWork(event);
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK_ANANUKE* mcw = FieldEvent_GetSpecialWork(event);
	switch (*seq) {
	case 0:
		EventCmd_StartFieldMap(event);
		(*seq) ++;
		break;
	case 1:
		//n\
		PlaceNameRequestByFsys(fsys);
		
		EventCmd_FieldFadeInAnanuke(event);
		(*seq) ++;
		break;
	case 2:
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hFtF[hC@Ȃʂ̂Ђ
 * @param	event		Cxg䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static void EventCmd_FieldFadeInAnanuke(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK_ANANUKE * mcw = FieldEvent_GetSpecialWork(event);
	
	if (!GameSystem_CheckFieldProcExists(fsys)) {
		GF_ASSERT("mainprocȂ̂ɃtF[hs\n" && 0);
		return;
	}
	
	//ɃJbgCp̂̂Ă@tF[hC͂̒
	{
		void *wk = EventWorkSet_AnanukeMapIn( fsys, HEAPID_FIELD, mcw->ana_type );
		FieldEvent_Call( event, GMEVENT_AnanukeMapIn, wk );
	}
}

//============================================================================================
//			[v|Cg
//============================================================================================
//-----------------------------------------------------------------------------
//          [v|Cgp}bvJڃCxgp䃏[N
//-----------------------------------------------------------------------------
typedef struct {
	int seq;							///<V[PXێ[N
    BOOL bEnd;
	LOCATION_WORK next;					///<}bvJڐwp[N
} EVENT_MAPCHG_WARP_WORK;



//-----------------------------------------------------------------------------
// @brief	}bvJڃCxg
//-----------------------------------------------------------------------------
static BOOL GMEVENT_MapChangeWorpPoint(GMEVENT_CONTROL * event)
{
    FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
    EVENT_MAPCHG_WARP_WORK* mcw = FieldEvent_GetSpecialWork(event);
	LOCATION_WORK* location = &mcw->next;
	
	switch (mcw->seq) {
      case 0:
        StartJumpPointEffect( fsys, TRUE, &mcw->bEnd);
        mcw->seq++;
		break;
      case 1:
        if(mcw->bEnd){
			Snd_EvMapChangeBgmFadeCheck( fsys, location->zone_id );	//tB[hBGMtF[hAEg
            EventCmd_FinishFieldMap(event);
            mcw->seq++;
        }
        break;
      case 2:
		//TuCxgĂяõCxg̓EFCg
        EventCmd_MapChangeByLocation(event, &mcw->next);
        mcw->seq++;
        break;
      case 3:
		if( Snd_FadeCheck() != 0 ){									//TEhtF[h
			break;
		}
		Snd_EvMapChangeBgmPlay( fsys, location->zone_id );			//tB[hBGMĐ
		EventCmd_StartFieldMap(event);
        mcw->seq++;
		break;
      case 4:
        mcw->bEnd = FALSE;
        StartJumpPointEffect( fsys, FALSE, &mcw->bEnd);
        mcw->seq++;
		break;
      case 5:
        if(mcw->bEnd){
            mcw->seq++;
        }
        break;
      case 6:
		sys_FreeMemoryEz(mcw);
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
// @brief	[v|Cg
//-----------------------------------------------------------------------------
void EventCmd_WarpPoint(FIELDSYS_WORK * fsys, int zone, int door_id)
{
	LOCATION_WORK next;
	EVENT_MAPCHG_WARP_WORK* mcw =
		sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_MAPCHG_WARP_WORK));
    MI_CpuClear8(mcw, sizeof(EVENT_MAPCHG_WARP_WORK));
    
    SetLocation(&next, zone, door_id, 0, 0, Player_DirGet(fsys->player));

	mcw->next = next;
	FieldEvent_Set( fsys, GMEVENT_MapChangeWorpPoint, mcw );
}

///*************************************************************************************
//
//		
//		ñ}bvړ
//
//
//
//
//		ñ}bvړ
//		
//
///*************************************************************************************


//============================================================================================
//
//
//			nWv
//
//
//============================================================================================
static BOOL GMEVENT_UgJump(GMEVENT_CONTROL * event);	//nn
static BOOL UgChg_SubCall(GMEVENT_CONTROL * event, int no);

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
typedef struct {
	int seq;
	int subseq;
	int next_zone_id;
	int next_door_id;
	int next_x;
	int next_z;
	BOOL brightness;
    u16 saveResult;
	void * infowin;			// Z[uEBhEp|C^
	GF_BGL_BMPWIN	win;	// bZ[WEBhE
	STRBUF * str;			// ʐMJnbZ[Wobt@
	u8	midx;				// bZ[WCfbNX
	BMPMENU_WORK * mw;		// ͂Ej[[N
}EVENT_UGCHG_WORK;


//-----------------------------------------------------------------------------
/**
 * @brief	nƒnsCxgp[N̐
 */
//-----------------------------------------------------------------------------
void * MakeUGChangeWork(FIELDSYS_WORK * fsys)
{
	EVENT_UGCHG_WORK * mcw;
	LOCATION_WORK * sp = Situation_GetSpecialLocation(SaveData_GetSituation(fsys->savedata));

	//Cxg
	mcw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_UGCHG_WORK));
	mcw->seq = 0;
	mcw->subseq = 0;
	
	if (fsys->MapMode == MAP_MODE_UNDER){	//ݒn̏ꍇ
		//nփWv
		mcw->next_zone_id = sp->zone_id;
		mcw->next_door_id = DOOR_ID_JUMP_CODE;
		mcw->next_x = sp->grid_x;
		mcw->next_z = sp->grid_z;
	}else{
		SetLocationHere(sp, fsys);			//؂ւȌꏊoĂ
		mcw->next_zone_id = ZONE_ID_UG;
		mcw->next_door_id = DOOR_ID_JUMP_CODE;
		//--Wv̑Io@--
		//ubNW8,8̏ꏊɃWv悤ɂ
		//(YzTCY͒n1/4)<<mɂWvł镔lƑE\
		
		//3030n̒YzWvLubN͏c23ubNA28ubN
		//icJn6ubNƍŉ1ubN͔͈͊OB͗TCh1ubN͈͊Oj
		//1515ñt[[uLubN͏c13ubNA14ubN
		//icJn2ubN͔閧nÁA1ubNʂ閧nj
		//Ӑ}Œnt[[u1ubNɂ̓WvłȂ悤ɂƏc12ubN
		//nc23ubNł́AvZ덷ôŁAŉ͈͊O1ubNWvΏۂƂƏc24ubN
		//āAnWṽubŃA
		//cɊւẮA
		//(݂̒nubN-cItZbg6ubN)/2+閧nItZbg2ubN+Wv1ubN
		//ɊւẮA
		//(݂̒nubN-ItZbg1ubN)/2+閧nItZbg1ubN
		//
		//Wvꏊ́A1ubNi3232j̓ɌāA㉺E8Obhi񂾏
		{
			int x_ofs,z_ofs;
			int block_x,block_z;
			block_x = (sp->grid_x/32)-1;
			block_z = (sp->grid_z/32)-6;

			GF_ASSERT(block_x>=0);
			GF_ASSERT(block_z>=0);	
			
			if (block_x%2 == 0){
				x_ofs = 8;
			}else{
				x_ofs = 23;
			}
			if (block_z%2 == 0){
				z_ofs = 8;
			}else{
				z_ofs = 23;
			}

			block_x = (block_x/2)+1;
			block_z = (block_z/2)+2+1;
			mcw->next_x = block_x*32+x_ofs;
			mcw->next_z = block_z*32+z_ofs;
		}
	}
	return mcw;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
void ChangeUnderGroundDirect(FIELDSYS_WORK * fsys)
{
	EVENT_UGCHG_WORK * mcw = MakeUGChangeWork(fsys);
	if (mcw == NULL) {
		return;
	}
	FieldEvent_Set(fsys, MapChg_GetUgChangeEvent(fsys), mcw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	CxgFnォn
 */
//-----------------------------------------------------------------------------
enum {
	UGCHG_SEQ_SIO_INIT = 0,		// ʐMJnbZ[WZbg
	UGCHG_SEQ_SIO_YNINIT,		// bZ[W҂͂E
	UGCHG_SEQ_SIO_YNWAIT,		// ͂E҂

	UGCHG_SEQ_REPORT_INIT,		// |[g
	UGCHG_SEQ_REPORT_WAIT,		// |[gI҂

	UGCHG_SEQ_CANCEL,			// CxgLZ

	// GtFNg
	UGCHG_SEQ_0,
	UGCHG_SEQ_1,
	UGCHG_SEQ_2,
	UGCHG_SEQ_3,
	UGCHG_SEQ_4,
	UGCHG_SEQ_5,
	UGCHG_SEQ_6,
};

// ͂EEBhEf[^
static const BMPWIN_DAT YesNoBmpDat = {
	FLD_MBGFRM_FONT, FLD_YESNO_WIN_PX, FLD_YESNO_WIN_PY,
	FLD_YESNO_WIN_SX, FLD_YESNO_WIN_SY, FLD_YESNO_WIN_PAL, FLD_YESNO_WIN_CGX
};


BOOL GMEVENT_GroundToUnderGround(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_UGCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);
	
	switch (mcw->seq) {
	case UGCHG_SEQ_SIO_INIT:
		{
			MSGDATA_MANAGER * mman = MSGMAN_Create(
										MSGMAN_TYPE_DIRECT,ARC_MSG,NARC_msg_connect_dat,HEAPID_WORLD );
			mcw->str = MSGMAN_AllocString( mman, msg_connect_common_01 );
			MSGMAN_Delete( mman );
		}
		FldTalkBmpAdd( fsys->bgl, &mcw->win, FLD_MBGFRM_FONT );
		FieldTalkWinPut( &mcw->win, SaveData_GetConfig(fsys->savedata) );
		mcw->midx = FieldTalkMsgStart(
						&mcw->win, mcw->str, SaveData_GetConfig(fsys->savedata), 1 );
		mcw->seq = UGCHG_SEQ_SIO_YNINIT;
		break;

	case UGCHG_SEQ_SIO_YNINIT:
		if( FldTalkMsgEndCheck( mcw->midx ) == 1 ){
			STRBUF_Delete( mcw->str );
			MenuWinGraphicSet(
				fsys->bgl, FLD_MBGFRM_FONT, MENU_WIN_CGX_NUM, MENU_WIN_PAL, 0, HEAPID_WORLD );
			mcw->mw = BmpYesNoSelectInit(
						fsys->bgl, &YesNoBmpDat, MENU_WIN_CGX_NUM, MENU_WIN_PAL, HEAPID_WORLD );
			mcw->seq = UGCHG_SEQ_SIO_YNWAIT;
		}
		break;

	case UGCHG_SEQ_SIO_YNWAIT:
		switch( BmpYesNoSelectMain( mcw->mw, HEAPID_WORLD ) ){
		case 0:
			BmpTalkWinClear( &mcw->win, WINDOW_TRANS_ON );
			GF_BGL_BmpWinDel( &mcw->win );
			mcw->seq = UGCHG_SEQ_REPORT_INIT;
			break;

		case BMPMENU_CANCEL:
			BmpTalkWinClear( &mcw->win, WINDOW_TRANS_ON );
			GF_BGL_BmpWinDel( &mcw->win );
			mcw->seq = UGCHG_SEQ_CANCEL;
		}
		break;


	case UGCHG_SEQ_REPORT_INIT:		// |[gĂяo
		if( SaveData_IsOverwritingOtherData(fsys->savedata) ) {
			EventCall_Script( event, SCRID_REPORT_NG, NULL, NULL );
		}else{
            // nɓÕtO
            UnderGroundDataBeforeUGSave(fsys->savedata);
			//|[g񐶐
			mcw->infowin = ReportInfo_Create( fsys, HEAPID_WORLD, FLD_MBGFRM_FONT );
			ReportInfo_WriteWindow( mcw->infowin );
			mcw->saveResult = FALSE;	// ʎ󂯎p[N
			EventCall_Script( event, SCRID_REPORT, NULL, &mcw->saveResult );
		}
		mcw->seq = UGCHG_SEQ_REPORT_WAIT;
		break;

	case UGCHG_SEQ_REPORT_WAIT:		// |[g҂
		if( SaveData_IsOverwritingOtherData(fsys->savedata) ){
			mcw->seq = UGCHG_SEQ_CANCEL;
		}else{
			ReportInfo_EraseWindow( mcw->infowin );
			ReportInfo_Delete( mcw->infowin );
			if( mcw->saveResult == FALSE ){		//Z[uĂȂ
				mcw->seq = UGCHG_SEQ_CANCEL;
			}else{								//Z[u
				mcw->seq = UGCHG_SEQ_0;
			}
		}
		break;




	case UGCHG_SEQ_CANCEL:
		FieldOBJSys_MovePauseAllClear( fsys->fldobjsys );
		sys_FreeMemoryEz(mcw);
		return TRUE;

	case UGCHG_SEQ_0:
		Snd_BgmFadeOut( 0, BGM_FADE_UG_TIME );	//BGMtF[hAEg
		(mcw->seq) ++;
		break;

	case UGCHG_SEQ_1:
		if (UgChg_SubCall(event, EFCT_UG_DOWN00)) {
			(mcw->seq) ++;
		}
		break;

	case UGCHG_SEQ_2:
		EventCmd_FinishFieldMap(event);
		(mcw->seq) ++;
		break;

	case UGCHG_SEQ_3:
		fsys->MapMode = MAP_MODE_UNDER;
        Overlay_Load( FS_OVERLAY_ID( ol_underground ), OVERLAY_LOAD_NOT_SYNCHRONIZE );
		//fsys->DivMapMode = DIV_MAP_MODE_UNDER;
		// ʐMJn
		CommFieldStateEnterUnderGround(fsys); // ʐMXe[gnJnɕύX
		EventCmd_MapChange(event,
								mcw->next_zone_id,
								DOOR_ID_JUMP_CODE,
								mcw->next_x,
								mcw->next_z,
								DIR_DOWN);

		(mcw->seq) ++;
		break;

	case UGCHG_SEQ_4:
		if( Snd_FadeCheck() != 0 ){				//BGMtF[h҂
			break;
		}
		Snd_SceneSet( SND_SCENE_DUMMY );		//TEhV[NA
		Snd_FieldBgmClearSpecial( fsys );		//}bvBGMwNA

		EventCmd_StartFieldMap(event);
		(mcw->seq) ++;
		break;

	case UGCHG_SEQ_5:
		if (UgChg_SubCall(event, EFCT_UG_DOWN01)) {
			CommFieldStateArrivalUnderGround(); // nɓ
			fsys->UnderGroundRadar = UnderGround_RadarInit(fsys);		//Yz[_[ʂnm
            ChangeBrightnessRequest(30,BRIGHTNESS_NORMAL,BRIGHTNESS_BLACK,
                                    PLANEMASK_BG0|PLANEMASK_BG3|PLANEMASK_OBJ,MASK_SUB_DISPLAY);
            (mcw->seq) ++;
		}
		break;
	case UGCHG_SEQ_6:
		if (IsFinishedBrightnessChg(MASK_SUB_DISPLAY)) {
            UgSecretBaseBootOn(TRUE); // 閧n̓ON
            sys_FreeMemoryEz(mcw);
			return TRUE;
		}
		break;
	
	}
	return FALSE;
}
//-----------------------------------------------------------------------------
/**
 * @brief	CxgFnn
 */
//-----------------------------------------------------------------------------
BOOL GMEVENT_UnderGroundToGround(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_UGCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);
	int end_flg = 0;
		
	
	switch (mcw->seq) {
	case 0:
        // ʐMI
        UgSecretBaseBootOn(FALSE); // 閧n̓OFF
        CommFieldStateExitUnderGround();  // ʐMXe[gnIɕύX
		//n̎̓[_[ɉ
		UnderGround_RadarEnd(fsys->UnderGroundRadar);
		ChangeBrightnessRequest(30,BRIGHTNESS_BLACK,BRIGHTNESS_NORMAL,PLANEMASK_BG0,MASK_SUB_DISPLAY);
		mcw->seq++;
		break;
	case 1:
		if(IsFinishedBrightnessChg(MASK_SUB_DISPLAY)){
            if((fsys->UnderGroundRadar==NULL) && !CommIsInitialize()){
				Snd_BgmFadeOut( 0, BGM_FADE_UG_TIME );	//BGMtF[hAEg
                mcw->seq++;
            }
        }
		break;
	case 2:
		if (UgChg_SubCall(event, EFCT_UG_UP00)) {
			(mcw->seq) ++;
		}
		break;
	case 3:
		EventCmd_FinishFieldMap(event);
		(mcw->seq) ++;
		break;

	case 4:
		fsys->MapMode = MAP_MODE_GROUND;
	    Overlay_UnloadID( FS_OVERLAY_ID(ol_underground) );
	//fsys->DivMapMode = DIV_MAP_MODE_GROUND;
		EventCmd_MapChange(event,
								mcw->next_zone_id,
								DOOR_ID_JUMP_CODE,
								mcw->next_x,
								mcw->next_z,
								DIR_DOWN);

		(mcw->seq) ++;
		break;
	case 5:
		if( Snd_FadeCheck() != 0 ){				//BGMtF[h҂
			break;
		}
		Snd_SceneSet( SND_SCENE_DUMMY );		//TEhV[NA
		Snd_FieldBgmClearSpecial( fsys );		//}bvBGMwNA

		EventCmd_StartFieldMap(event);
		(mcw->seq) ++;
		break;
    case 6:
		if (UgChg_SubCall(event, EFCT_UG_UP01)) {
     		(mcw->seq) ++;
        }
        break;
    case 7:
        sys_FreeMemoryEz(mcw);
        return TRUE;
		break;
	
	}
	return FALSE;
}


//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
GMEVENT_FUNC MapChg_GetUgChangeEvent(const FIELDSYS_WORK * fsys)
{
	if (fsys->MapMode == MAP_MODE_GROUND) {
		return GMEVENT_GroundToUnderGround;
	} else if (fsys->MapMode == MAP_MODE_UNDER) {
		return GMEVENT_UnderGroundToGround;
	} else {
		GF_ASSERT_MSG(0,"Unknown MAP_MODE %d\n",fsys->MapMode);
		return NULL;
	}
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static BOOL UgChg_SubCall(GMEVENT_CONTROL * event, int no)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_UGCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);
	BOOL	ret = FALSE;

	switch(mcw->subseq){
	case 0:		// X^[g
		mcw->brightness = 0;
		StartUnderGroundEffect(fsys, no, &mcw->brightness);
		mcw->subseq++;
		break;
	case 1:		// I҂
		if(mcw->brightness){
			mcw->subseq = 0;
			ret = TRUE;
		}
		break;
	}
	return ret;
}


//============================================================================================
//
//
//			CxgR}hFn`ñ}bvړ
//
//
//============================================================================================
static void EventCmd_UgJump(GMEVENT_CONTROL * event, int zone_id, int door_id, int x, int z, int dir);
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static BOOL GMEVENT_UgJump(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_UGCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);
	int end_flg = 0;
		
	
	switch (mcw->seq) {
	case 0:
        UgSecretBaseBootOn(FALSE);
            //[_[ɉ
		UnderGround_RadarEnd(fsys->UnderGroundRadar);
		CommStateJumpUnderGround();   // ړꍇ̒ʐM֘A
		mcw->seq++;
		break;

	case 1:
		if(fsys->UnderGroundRadar==NULL){
			mcw->seq++;
		}
		break;
	case 2:
		(mcw->seq) ++;
		break;
	case 3:
		EventCmd_FinishFieldMap(event);
		(mcw->seq) ++;
		break;
	case 4:
		
		EventCmd_UgJump(event,
						mcw->next_zone_id,
						DOOR_ID_JUMP_CODE,
						mcw->next_x,
						mcw->next_z,
						DIR_DOWN);

		(mcw->seq) ++;
		break;
	case 5:
		EventCmd_StartFieldMap(event);
		(mcw->seq) ++;
		break;
	case 6:
        UgSecretBaseBootOn(TRUE);
		CommStateJumpEndUnderGround(); // ړIꍇ̒ʐM֘A
		fsys->UnderGroundRadar = UnderGround_RadarInit(fsys);		//Yz[_[ʂnm
		sys_FreeMemoryEz(mcw);
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
void JumpUnderGroundDirect(FIELDSYS_WORK * fsys, const int inX, const int inZ)
{
	EVENT_UGCHG_WORK * mcw;
	
	//Cxg
	mcw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_UGCHG_WORK));
	mcw->seq = 0;
	mcw->subseq = 0;
	mcw->next_zone_id = ZONE_ID_UG;
	mcw->next_door_id = DOOR_ID_JUMP_CODE;
	//ŁAWv肵܂
	mcw->next_x = inX;
	mcw->next_z  = inZ;
	
	FieldEvent_Set(fsys, GMEVENT_UgJump, mcw);
	return;
}


//-----------------------------------------------------------------------------
/**
 * @brief	TuCxgF}bvJ(n`n)
 * @param	event	Cxg䃏[Nւ̃|C^
 * @retval	TRUE	CxgI
 * @retval	FALSE	Cxgp
 *
 * TuCxgFieldEvent_CallŌĂяoƂŎgpB
 * ݂̃Cxg~āAɃTuCxgтB
 * TuCxgIƌ݂̃CxgĂяoB
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_Sub_UgJump(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	SIMPLE_MAPCHG_WORK * smw = FieldEvent_GetSpecialWork(event);

	switch (smw->seq) {
	case 0:
		//--------I--------
		MapChg_FieldOBJ_Delete(fsys);
		(smw->seq) ++;
		break;
		
	case 1:
		//--------Jn--------
		MapChg_SetNewLocation(fsys, &smw->next);
        //--XNvĝݎs  k.ohno & saito
        SpScriptSearch(fsys, SP_SCRID_FLAG_CHANGE);
        
		(smw->seq) ++;
		break;
		
	case 2:
		MapChg_FieldOBJ_Create(fsys);
		sys_FreeMemoryEz(smw);
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hF}bvJ(n`n)
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	next		Jڐw肷LOCATION_WORK^ւ̃|C^
 */
//-----------------------------------------------------------------------------
void EventCmd_UgJumpByLocation(GMEVENT_CONTROL * event, const LOCATION_WORK * next)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	SIMPLE_MAPCHG_WORK * smw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(SIMPLE_MAPCHG_WORK));
	if (GameSystem_CheckFieldProcExists(fsys)) {
		GF_ASSERT("mainproĉɃ}bvJڏ\n" && 0);
		return;
	}
	smw->seq = 0;
	smw->next = *next;
	FieldEvent_Call(event, GMEVENT_Sub_UgJump, smw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hF}bvJ(n`n)
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	zone_id		Jڐ][IDw
 * @param	door_id		Jڐow
 * @param	x			JڐXWwidoor_id == DOOR_ID_JUMP_CODÊƂ̂ݗLj
 * @param	z			JڐZWwidoor_id == DOOR_ID_JUMP_CODÊƂ̂ݗLj
 * @param	dir			oł̕w
 *
 */
//-----------------------------------------------------------------------------
static void EventCmd_UgJump(GMEVENT_CONTROL * event, int zone_id, int door_id, int x, int z, int dir)
{
	LOCATION_WORK next;
	SetLocation(&next, zone_id, door_id, x, z, dir);
	EventCmd_UgJumpByLocation(event, &next);
}



//============================================================================================
//
//
//			jI[p}bvړ
//
//
//============================================================================================
//-----------------------------------------------------------------------------
//          jIp}bvJڃCxgp䃏[N
//-----------------------------------------------------------------------------
typedef struct {
	int seq;							///<V[PXێ[N
    BOOL bEnd;
	LOCATION_WORK next;					///<}bvJڐwp[N
}EVENT_MAPCHG_UNION_WORK;



//-----------------------------------------------------------------------------
// @brief	}bvJڃCxg
//-----------------------------------------------------------------------------
static BOOL GMEVENT_UnionRoomOut(GMEVENT_CONTROL * event)
{
    FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
    EVENT_MAPCHG_UNION_WORK* emuw = FieldEvent_GetSpecialWork(event);
	int * seq = FieldEvent_GetSeqWork(event);
	
	switch (*seq) {
      case 0:
        //"}bvJڐp"tF[hAEg  BGMĐ
		{
			//|PZQKƃjI͓BGMȂ̂ŃTEh[h͉ĂȂI
			LOCATION_WORK* location = &emuw->next;
			Snd_MapChangeFadeOutNextPlaySub( fsys, location->zone_id, BGM_FADE_ROOM_MODE );
		}
        StartJumpPointEffect( fsys, TRUE, &emuw->bEnd);
        (*seq)++;
		break;
      case 1:
        if(emuw->bEnd){
            EventCmd_FinishFieldMap(event);
            (*seq)++;
        }
        break;
      case 2:
		//TuCxgĂяõCxg̓EFCg
        EventCmd_MapChangeByLocation(event, &emuw->next);
        (*seq)++;
        break;
      case 3:
		EventCmd_StartFieldMap(event);
        (*seq)++;
		break;
      case 4:
		EventCmd_FieldFadeIn(event);
        (*seq)++;
		break;
      case 5:
		sys_FreeMemoryEz(emuw);
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
// CxgZbgFjI[p}bvJځF
//-----------------------------------------------------------------------------
void EventSet_UnionRoomMapChangeOut(FIELDSYS_WORK * fsys)
{
	LOCATION_WORK * sp = Situation_GetSpecialLocation(SaveData_GetSituation(fsys->savedata));
	EVENT_MAPCHG_UNION_WORK* emuw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_MAPCHG_UNION_WORK));
    MI_CpuClear8(emuw, sizeof(EVENT_MAPCHG_UNION_WORK));
    
	emuw->next = *sp;
	
	// jI[ʐM
	Comm_UnionFinalize(fsys);
	// jI[\p[N
	Comm_UnionRoomViewEnd(fsys->union_view);

	fsys->MapMode = MAP_MODE_GROUND;

	FieldEvent_Set(fsys, GMEVENT_UnionRoomOut, emuw);
	fsys->union_work = NULL;
}

//-----------------------------------------------------------------------------
// @brief	}bvJڃCxg
//-----------------------------------------------------------------------------
static BOOL GMEVENT_UnionRoomIn(GMEVENT_CONTROL * event)
{
    FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
    EVENT_MAPCHG_UNION_WORK* emuw = FieldEvent_GetSpecialWork(event);
	int * seq = FieldEvent_GetSeqWork(event);
	
	switch (*seq) {
      case 0:
        //"}bvJڐp"tF[hAEg  BGMĐ
		{
			//|PZQKƃjI͓BGMȂ̂ŃTEh[h͉ĂȂI
			LOCATION_WORK* location = &emuw->next;
			Snd_MapChangeFadeOutNextPlaySub( fsys, location->zone_id, BGM_FADE_ROOM_MODE );
		}
		EventCmd_FieldFadeOut(event);
        (*seq)++;
		break;
      case 1:
		EventCmd_FinishFieldMap(event);
		(*seq)++;
        break;
      case 2:
		//TuCxgĂяõCxg̓EFCg
        EventCmd_MapChangeByLocation(event, &emuw->next);
        (*seq)++;
        break;
      case 3:
		EventCmd_StartFieldMap(event);
        (*seq)++;
		break;
      case 4:
        emuw->bEnd = FALSE;
        StartJumpPointEffect( fsys, FALSE, &emuw->bEnd);
        (*seq)++;
		break;
      case 5:
        if(emuw->bEnd){
            (*seq)++;
        }
        break;
      case 6:
		sys_FreeMemoryEz(emuw);
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
// CxgZbgFjI[p}bvJځF
//-----------------------------------------------------------------------------
void EventSet_UnionRoomMapChangeIn(FIELDSYS_WORK * fsys)
{
	LOCATION_WORK * sp = Situation_GetSpecialLocation(SaveData_GetSituation(fsys->savedata));

	SetLocationHere(sp, fsys);			//؂ւȌꏊoĂ

	// jI[ʐMJn
	fsys->union_work = Comm_UnionRoomInit(fsys);
	// jI[OBJ^XNN
	fsys->union_view = Comm_UnionRoomViewInit(fsys->union_work);

	fsys->MapMode = MAP_MODE_UNION;
	EventSet_EasyMapChange(fsys, ZONE_ID_UNION, DOOR_ID_JUMP_CODE, 9, 12, DIR_DOWN);
}

//-----------------------------------------------------------------------------
// CxgR}hFjI[p}bvJځFo藼ifobOpj
//-----------------------------------------------------------------------------
void EventSet_UnionRoomMapChange(FIELDSYS_WORK * fsys)
{
	if (fsys->location->zone_id == ZONE_ID_UNION) {
		EventSet_UnionRoomMapChangeOut(fsys);

		// ʐMZ[ȗÔ܂Ȃ
		SysFlag_CommCounterReset( SaveData_GetEventWork(fsys->savedata) );
	} else {
		// ʐMZ[ȗÔ܂Ȃ
		SysFlag_CommCounterSet( SaveData_GetEventWork(fsys->savedata) );

		EventSet_UnionRoomMapChangeIn(fsys);
	}
}

#if 0
//-----------------------------------------------------------------------------
/// CxgR}hFjI[p}bvJځF
//-----------------------------------------------------------------------------
void EventCmd_UnionRoomMapChangeOut(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	LOCATION_WORK * sp = Situation_GetSpecialLocation(SaveData_GetSituation(fsys->savedata));

	// jI[ʐM
	Comm_UnionFinalize(fsys);
	// jI[\p[N
	Comm_UnionRoomViewEnd(fsys->union_view);
	// UnionBoardĎĂ邩NULLɂȂƌ듮삷
	fsys->union_view = NULL;

	fsys->MapMode = MAP_MODE_GROUND;
	EventCmd_EasyMapChangeByLocation(fsys->event, sp);
	fsys->union_work = NULL;
}
#endif
//-----------------------------------------------------------------------------
/// CxgR}hFjI[p}bvJځF
//-----------------------------------------------------------------------------
void EventCmd_UnionRoomMapChangeIn(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	LOCATION_WORK * sp = Situation_GetSpecialLocation(SaveData_GetSituation(fsys->savedata));
	EVENT_MAPCHG_UNION_WORK* emuw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_MAPCHG_UNION_WORK));
    MI_CpuClear8(emuw, sizeof(EVENT_MAPCHG_UNION_WORK));

	SetLocationHere(sp, fsys);			//؂ւȌꏊoĂ

	SetLocation(&emuw->next, ZONE_ID_UNION, DOOR_ID_JUMP_CODE, 8, 14, DIR_UP);

	// jI[ʐMJn
	fsys->union_work = Comm_UnionRoomInit(fsys);
	// jI[OBJ^XNN
	fsys->union_view = Comm_UnionRoomViewInit(fsys->union_work);

	fsys->MapMode = MAP_MODE_UNION;
	FieldEvent_Call(event, GMEVENT_UnionRoomIn, emuw);
//	EventCmd_EasyMapChange(fsys->event, ZONE_ID_UNION, DOOR_ID_JUMP_CODE, 8, 14, DIR_UP);
}


//============================================================================================
//
//
//		ʐMΐ핔p}bvړ
//
//
//============================================================================================
//-----------------------------------------------------------------------------
// @brief	}bvJڃCxg(ΐ핔ɓp)
//-----------------------------------------------------------------------------
static BOOL GMEVENT_MapChangeColosseum(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);
	LOCATION_WORK* location = &mcw->next;
	
	switch (mcw->seq) {
	case 0:
		Snd_SePlay( SEQ_SE_DP_KAIDAN2 );
		Snd_EvMapChangeBgmFadeCheck( fsys, location->zone_id );	//tB[hBGMtF[hAEg
		EventCmd_FadeOut_FinishField(event);	//TuCxgĂяõCxg̓EFCg
		(mcw->seq) ++;
		break;
	case 1:
		//TuCxgĂяõCxg̓EFCg
		EventCmd_MapChangeByLocation(event, &mcw->next);
		(mcw->seq) ++;
		break;
	case 2:
		if( Snd_FadeCheck() != 0 ){								//TEhtF[h
			break;
		}
		Snd_EvMapChangeBgmPlay( fsys, location->zone_id );		//tB[hBGMĐ
		EventCmd_StartFieldMap(event);
		(mcw->seq) ++;
		break;
	case 3:
		sys_FreeMemoryEz(mcw);
		return TRUE;
	}
	return FALSE;
}


//-----------------------------------------------------------------------------
///	CxgR}hFʐMΐ핔p}bvJځF
//-----------------------------------------------------------------------------
void EventCmd_ColosseumMapChangeIn(GMEVENT_CONTROL * event,
		int zone_id, int door_id, int x, int z, int dir)
{
    LOCATION_WORK next;
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	LOCATION_WORK * sp = Situation_GetSpecialLocation(SaveData_GetSituation(fsys->savedata));

	SetLocationHere(sp, fsys);			//؂ւȌꏊoĂ

	fsys->MapMode = MAP_MODE_COLOSSEUM;	//}bv[hʐMΐ핔p

    {
        EVENT_MAPCHG_WORK * mcw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_MAPCHG_WORK));
        
        SetLocation(&next, zone_id, door_id, x, z, dir);
        mcw->seq = 0;
        mcw->next = next;
        FieldEvent_Call(event, GMEVENT_MapChangeColosseum, mcw);
    }
}


//-----------------------------------------------------------------------------
///	CxgR}hFʐMΐ핔p}bvJځF
//-----------------------------------------------------------------------------
void EventCmd_ColosseumMapChangeOut(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	LOCATION_WORK * sp = Situation_GetSpecialLocation(SaveData_GetSituation(fsys->savedata));
	fsys->MapMode = MAP_MODE_GROUND;		//}bv[hʏ
	EventCmd_EasyMapChangeByLocation(fsys->event, sp);
}

//-----------------------------------------------------------------------------
// CxgZbgFʐMΐ핔p}bvJځF
//-----------------------------------------------------------------------------
void EventSet_ColosseumMapChangeOut(FIELDSYS_WORK * fsys)
{
	LOCATION_WORK * sp = Situation_GetSpecialLocation(SaveData_GetSituation(fsys->savedata));

	fsys->MapMode = MAP_MODE_GROUND;
	EventSet_EasyMapChangeByLocation(fsys, sp);
}

#ifdef PM_DEBUG
//-----------------------------------------------------------------------------
//  nɔCӂ̈ʒuɍ~ׂɍ쐬 fobOp 2006.02.08
//-----------------------------------------------------------------------------
void Debug_ChangeUnderGroundDirect(FIELDSYS_WORK * fsys, int x, int z)
{
	EVENT_UGCHG_WORK * mcw = MakeUGChangeWork(fsys);
	if (mcw == NULL) {
		return;
	}
    mcw->next_x = x;
    mcw->next_z = z;
    mcw->seq = UGCHG_SEQ_0;
	FieldEvent_Set(fsys, MapChg_GetUgChangeEvent(fsys), mcw);
}
#endif //PM_DEBUG
