//===========================================================================
/**
 * @file	ev_pokemon.c
 * @brief	Cxg\[XF|P֘A
 * @author	tamada GAME FREAK Inc.
 * @date	2005.12.18
 */
//===========================================================================
#include "common.h"

#include "fieldsys.h"
#include "poketool/pokeparty.h"
#include "poketool/poke_tool.h"
#include "poketool/poke_memo.h"
#include "savedata/zukanwork.h"
#include "savedata/get_poke.h"

#include "ev_pokemon.h"
#include "battle/battle_common.h"		//CONDITION_`
#include "sodateya.h"

#include "itemtool/itemsym.h"
//===========================================================================
//===========================================================================
#if 0
typedef void(* ITL_FUNC)(POKEMON_PARAM * poke, void *);
//------------------------------------------------------------------
/**
 * @brief	莝Sւ̑ꊇōs
 * @param	party		莝|Pւ̃|C^
 * @param	func		֐ւ̃|C^
 * @param	work		[Nւ̃|C^
 *
 * ^}SłȂAC₵ĂȂ|Pɑ΂֐ĂяoB
 * xxOBԂ񃁃悭Ȃ͂B
 */
//------------------------------------------------------------------
void EvPoke_Itelator(POKEPARTY * party, ITL_FUNC func, void * work)
{
	int i, max;
	POKEMON_PARAM * pp;
	max = PokeParty_GetPokeCount(party);
	for (i = 0; i < max; i++) {
		pp = PokeParty_GetMemberPointer(party, i);
		if (PokeParaGet(poke, ID_PARA_tamago_flag, NULL) != 0) {
			continue;
		}
		if (PokeParaGet(poke, ID_PARA_hp, NULL) == 0) {
			continue;
		}
		func(pp, work);
	}
}
#endif
//------------------------------------------------------------------
/**
 * @brief	|P퓬\ǂ̃`FbN
 * @param	pp		Ώۃ|Pւ̃|C^
 * @return	BOOL	TRUÊƂA퓬\
 *
 * mł^}SłȂTRUEԂ
 */
//------------------------------------------------------------------
BOOL EvPoke_EnableBattle(POKEMON_PARAM * pp)
{
	if (PokeParaGet(pp, ID_PARA_hp, NULL) == 0) {
		return FALSE;
	}
	if (PokeParaGet(pp, ID_PARA_tamago_flag, NULL)) {
		return FALSE;
	}
	return TRUE;
}

//------------------------------------------------------------------
/**
 * @brief
 * @param	heapID
 * @param	sv
 * @param	monsno
 * @param	level
 * @param	itemno
 * @param	place_id
 * @param	ground_id
 * @retval	TRUE
 * @retval	FALSE
 */
//------------------------------------------------------------------
BOOL EvPoke_Add(int heapID, SAVEDATA * sv, u16 monsno, u8 level,
		u16 itemno, int place_id, int ground_id)
{
	BOOL result;
	POKEMON_PARAM *poke_param;
	u32 buf;
	POKEPARTY * party;
	MYSTATUS * my;

	my = SaveData_GetMyStatus(sv);
	party = SaveData_GetTemotiPokemon(sv);
	poke_param = PokemonParam_AllocWork(heapID);
	PokeParaInit(poke_param);
	PokeParaSet(poke_param, monsno, level, POW_RND, RND_NO_SET, 0, ID_NO_SET, 0);
	PokeParaGetInfoSet(poke_param, my, ITEM_MONSUTAABOORU, place_id, ground_id, heapID);
	buf = itemno;
	PokeParaPut(poke_param, ID_PARA_item, &buf);
	result = PokeParty_Add(party, poke_param);
	if (result) {
		SaveData_GetPokeRegister( sv, poke_param );
	}
	sys_FreeMemoryEz(poke_param);

	return result;
}

//------------------------------------------------------------------
/**
 * @brief	莝Ƀ^}S
 * @param	heapID
 * @param	sv
 * @param	monsno
 * @param	eventflg
 * @param	type      ܂ꂽꏊ^Cv  placename.hQ
 * @param	index     ܂ꂽꏊindex
 * @retval	TRUE
 * @retval	FALSE
 * 
 */
//------------------------------------------------------------------
BOOL EvPoke_AddTamago(int heapID, SAVEDATA * sv, u16 monsno, u8 eventflg, PLACENAME_TYPE type, int index)
{
    int number;
    BOOL result;
	MYSTATUS *my = SaveData_GetMyStatus( sv );
	POKEPARTY * temoti = SaveData_GetTemotiPokemon(sv);
	POKEMON_PARAM* poke_param = PokemonParam_AllocWork(HEAPID_EVENT);
	PokeParaInit(poke_param);
    number = PlaceName_IndexToParamNumber( type, index);
	PokemonTamagoSet_forEvent(poke_param, monsno, eventflg, my, TRMEMO_FUSHIGI_PLACESET, number);
	result = PokeParty_Add(temoti, poke_param);
	sys_FreeMemoryEz(poke_param);
	return result;
}

//------------------------------------------------------------------
/**
 * @brief	|Pɂ킴Zbg
 * @param	party		POKEPARTY\̂ւ̃|C^
 * @param	poke_pos	|P̈ʒuiO`Uj
 * @param	waza_pos	킴ZbgꏊiO`Rj
 * @param	waza_no		킴̎
 */
//------------------------------------------------------------------
void EvPoke_ChangeWaza(POKEPARTY * party, int poke_pos, int waza_pos, u16 waza_no)
{
	PokeWazaSetPos(PokeParty_GetMemberPointer(party, poke_pos), waza_no, waza_pos);
}

//------------------------------------------------------------------
/**
 * @brief	莝|P̂킴`FbN
 * @param	party		POKEPARTY\̂ւ̃|C^
 * @param	waza_no		킴̎
 * @retval	0-5			Ă|P̈ʒu
 * @retval	0xff		Ă|PȂ
 *
 * 莝|PɎw肵킴Ă̂邩ǂԂB
 */
//------------------------------------------------------------------
int EvPoke_CheckWaza(POKEPARTY * party, u16 waza_no)
{
	int i, max;
	POKEMON_PARAM * poke;

	max = PokeParty_GetPokeCount(party);

	for (i = 0; i<max; i++){
		poke = PokeParty_GetMemberPointer(party, i);

		//܂`FbN
		if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) != 0 ){
			continue;
		}
		//UXg`FbN
		if( (PokeParaGet( poke, ID_PARA_waza1, NULL ) == waza_no)
				||(PokeParaGet( poke, ID_PARA_waza2, NULL ) == waza_no)
				||(PokeParaGet( poke, ID_PARA_waza3, NULL ) == waza_no)
				||(PokeParaGet( poke, ID_PARA_waza4, NULL ) == waza_no)
			){
			return i;		//Ă|P̃Xg̕тԂ
			break;
		}
	}
	return 0xff;
}

//------------------------------------------------------------------
/**
 * @brief	킦|P̐𐔂
 * @param	party	POKEPARTYւ̃|C^
 * @return	int		킦|P̐
 */
//------------------------------------------------------------------
int EvPoke_CountLivingPokemon(const POKEPARTY * party)
{
	int i, max, count;
	POKEMON_PARAM * pp;
	
	max = PokeParty_GetPokeCount(party);
	count = 0;
	for (i = 0; i < max; i++) {
		pp = PokeParty_GetMemberPointer(party, i);
		if (EvPoke_EnableBattle(pp)) {
			count ++;
		}
#if 0
		if (PokeParaGet(pp, ID_PARA_hp, NULL) == 0) {
			continue;
		}
		if (PokeParaGet(pp, ID_PARA_tamago_flag, NULL)) {
			continue;
		}
		count ++;
#endif
	}
	return count;
}

//------------------------------------------------------------------
/**
 * @brief	|Pp[eB̒̐킦|PԂ(擪璲ׂāAn߂ɈԂ)
 * @param	party	POKEPARTYւ̃|C^
 * @return	pp		|Pp|C^
 */
//------------------------------------------------------------------
POKEMON_PARAM *EvPoke_GetLivingPokemonTop(const POKEPARTY * party)
{
	int i, max;
	POKEMON_PARAM * pp;
	
	max = PokeParty_GetPokeCount(party);
	for (i = 0; i < max; i++) {
		pp = PokeParty_GetMemberPointer(party, i);
		if (EvPoke_EnableBattle(pp)) {
			return pp;
		}
	}
	GF_ASSERT(0);
	return NULL;
}

//--------------------------------------------------------------
/**
 * @brief	擪̃|Pւ̃|C^擾
 * @param	party	POKEPARTYւ̃|C^
 * @return	^}Ŝ擪̃|Pւ̃|C^
 */
//--------------------------------------------------------------
POKEMON_PARAM * EvPoke_GetPokemonTop(const POKEPARTY * party)
{
	u16 i,max;
	POKEMON_PARAM * pp;

	max = PokeParty_GetPokeCount(party);
	for (i = 0; i < max; i++) {
		pp = PokeParty_GetMemberPointer(party, i);
		if (PokeParaGet(pp, ID_PARA_tamago_flag, NULL) == 0) {
			return pp;
		}
	}
	return NULL;
}


//------------------------------------------------------------------
/**
 * @brief	2vs2ΐ킪\ǂ`FbN
 * @param	party	POKEPARTYւ̃|C^
 * @return	BOOL	TRUÊƂA2vs2ΐł
 */
//------------------------------------------------------------------
BOOL EvPoke_Enable2vs2Battle(const POKEPARTY * party)
{
	if (EvPoke_CountLivingPokemon(party) >= 2) {
		return TRUE;
	} else {
		return FALSE;
	}
}

//===========================================================================
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	莝|PSɃVIE`sI{Zbg
 * @param	party	POKEPARTYւ̃|C^
 *
 * a̍ۂɌĂяo
 */
//------------------------------------------------------------------
void EvPoke_SetChampionRibbon(POKEPARTY * party)
{
	int i,max;
	u8 flag = 1;
	POKEMON_PARAM * pp;
	max = PokeParty_GetPokeCount(party);
	for (i = 0; i < max; i++) {
		pp = PokeParty_GetMemberPointer(party, i);
		if (PokeParaGet(pp, ID_PARA_tamago_flag, NULL) == 0) {
			PokeParaPut(pp, ID_PARA_sinou_champ_ribbon, &flag);
		}
	}
}

//===========================================================================
//===========================================================================

//------------------------------------------------------------------
/**
 * @brief	Ń_[W`FbN
 * @param	party		莝|Pւ̃|C^
 * @param	placeID		nID
 * @retval	FLD_POISON_DEAD			|PC₵
 * @retval	FLD_POISON_DAMAGE		|P_[W󂯂
 * @retval	FLD_POISON_NODAMAGE		|P̓_[W󂯂Ȃ
 */
//------------------------------------------------------------------
FLD_POISON_STAT EvPoke_PoisonDamage(POKEPARTY * party, u16 placeID)
{
	int poison_count = 0;
	int dead_count = 0;
	int i, max;
	POKEMON_PARAM * pp;
	max = PokeParty_GetPokeCount(party);
	for (i = 0; i < max; i++) {
		pp = PokeParty_GetMemberPointer(party, i);
		if (EvPoke_EnableBattle(pp)) {
			if (PokeParaGet(pp, ID_PARA_condition, NULL) & (CONDITION_DOKUDOKU|CONDITION_DOKU)) {
				u32 hp = PokeParaGet(pp, ID_PARA_hp, NULL);
				if (hp > 1) {
					hp --;
				}
				PokeParaPut(pp, ID_PARA_hp, &hp);
				if (hp == 1) {
					dead_count ++;
					FriendCalc( pp, FRIEND_DOKU_HINSHI, placeID);	// ȂǌvZ
				}
				poison_count ++;
			}
		}
	}

	if (dead_count) {
		return FLD_POISON_DEAD;
	} else if (poison_count) {
		return FLD_POISON_DAMAGE;
	} else {
		return FLD_POISON_NODAMAGE;
	}
}

//------------------------------------------------------------------
/**
 * @brief	łɂCF
 * @param	pp			|Pւ̃|C^
 * @retval	TRUE		łŋC₵
 * @retval	FALSE		C₵ĂȂ
 *
 * ŏԂłHPÕ|PǂCƂ݂ȂB
 * ̍ۂɃRfBVNAB
 */
//------------------------------------------------------------------
BOOL EvPoke_ApprovePoisonDead(POKEMON_PARAM * pp)
{
	if ((PokeParaGet(pp, ID_PARA_condition, NULL) & (CONDITION_DOKUDOKU|CONDITION_DOKU))
			&& PokeParaGet(pp, ID_PARA_hp, NULL) == 1){
		u32 cond = 0;
		PokeParaPut(pp, ID_PARA_condition, &cond);
		return TRUE;
	}
	return FALSE;
}





