//============================================================================================
/**
 * @file	ev_time.c
 * @brief	Q[Ԑ֘A
 * @author	tamada
 * @date	2006.02.03
 */
//============================================================================================

#include "common.h"

#include "system/pm_rtc.h"

#include "fieldsys.h"

#include "savedata/savedata.h"
#include "savedata/seedbed.h"
#include "savedata/undergrounddata.h"  // UnderGroundDataDayUpdate
#include "savedata/randomgroup.h"
#include "savedata/honeytree_data.h"
#include "savedata/encount.h"
#include "savedata/tv_work.h"
#include "savedata/b_tower.h"
#include "savedata/wifihistory.h"

#include "situation_local.h"


#include "ev_time.h"

#include "savedata/gametime.h"

#include "system/timezone.h"

#include "seedsys.h"

#include "script.h"

#include "tr_card_time.h"

#include "poketool/poke_tool.h"

#include "syswork.h"

#include "b_tower_ev.h"

//============================================================================================
//============================================================================================

//============================================================================================
//============================================================================================
static void UpdateDayEvent(FIELDSYS_WORK * fsys, s32 diff_days);
static void UpdateMinuteEvent(FIELDSYS_WORK * fsys, s32 diff_minute, const RTCTime * now);

static void UpdateDateCheck(FIELDSYS_WORK * fsys, GMTIME * tm, const RTCDate * now_date);
static void UpdateMinuteCheck(FIELDSYS_WORK * fsys, GMTIME * tm,
		const RTCDate * now_date, const RTCTime * now_time);

//============================================================================================
//============================================================================================
//------------------------------------------------------------------
/**
 */
//------------------------------------------------------------------
void EVTIME_Update(FIELDSYS_WORK * fsys)
{
	RTCDate now_date;
	RTCTime now_time;
	GMTIME * tm = SaveData_GetGameTime(fsys->savedata);

	if (tm->use_flag == FALSE) {
		return;
	}

	GF_RTC_GetDateTime(&now_date, &now_time);

	UpdateDateCheck(fsys, tm, &now_date);
	UpdateMinuteCheck(fsys, tm, &now_date, &now_time);
}

//------------------------------------------------------------------
///o߂
//------------------------------------------------------------------
static void UpdateDateCheck(FIELDSYS_WORK * fsys, GMTIME * tm, const RTCDate * now_date)
{
	s32 now_day;
	now_day = RTC_ConvertDateToDay(now_date);

	if (now_day < tm->sv_day) {
		//݁@@ߋ@c肦Ȃ͂
		//ݎԂZbg邾Ŗ߂
		tm->sv_day = now_day;
		return;
	}
	if (now_day > tm->sv_day) {
		UpdateDayEvent(fsys, now_day - tm->sv_day);
		tm->sv_day = now_day;
	}
}

//------------------------------------------------------------------
///bo߂
//------------------------------------------------------------------
static void UpdateMinuteCheck(FIELDSYS_WORK * fsys, GMTIME * tm,
		const RTCDate * now_date, const RTCTime * now_time)
{
	s64 now, sv;
	s32 diff_minute;
	now = RTC_ConvertDateTimeToSecond(now_date, now_time);
	sv = RTC_ConvertDateTimeToSecond(&tm->sv_date, &tm->sv_time);
	if (now < sv) {
		//݁@@ߋ@c肦Ȃ͂
		//ݎԂZbg邾Ŗ߂
		tm->sv_date = *now_date;
		tm->sv_time = *now_time;
		return;
	}
	diff_minute = (now - sv) / 60;
	if (diff_minute > 0) {
		GMTIME_CountDownPenaltyTime(tm, diff_minute);
		UpdateMinuteEvent(fsys, diff_minute, now_time);

		tm->sv_date = *now_date;
		tm->sv_time = *now_time;
	}
}

//============================================================================================
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	Ԃɂf[^XVFP
 * @param	fsys			tB[h䃏[Nւ̃|C^
 * @param	diff_days		o߂ԁij
 *
 * FIELDSYS_WORKƂĂ邪A{IɂSAVEDATÂ݂
 * XVł悤Ȏdg݂̊֐ĂԂׂB
 */
//------------------------------------------------------------------
static void UpdateDayEvent(FIELDSYS_WORK * fsys, s32 diff_days)
{
	
	//L̂悤ȊŎԊ֘ACxgXVǉ
	//
	//TVData_Update(fsys, diff_days);
	//ZukanHyouka_Update
	//c

    // n̓o߂Ɋ֘A
    UnderGroundDataDayUpdate(GameSystem_GetSaveData(fsys), diff_days);

	//1ɃNAtO
	TimeEventFlagClear(fsys);

	//g[i[P[X̃obW𕅂点
	TRCTIME_CorrodeBadge(fsys->savedata, diff_days);	

	// ̎O[vXV
	RandomGroup_Update(SaveData_GetRandomGroup(fsys->savedata), diff_days);

	//GJEg֘A_̎XV
	EncDataSave_UpdateRandSeed(EncDataSave_GetSaveDataPtr( fsys->savedata ),
			RandomGroup_GetDefaultRandom( SaveData_GetRandomGroup(fsys->savedata) ) );

	//|PX̌o߂ by soga 2006.05.16
	{
		POKEPARTY *ppt;

		ppt=SaveData_GetTemotiPokemon(fsys->savedata);
		PokerusCounterDec(ppt,diff_days);
	}

	//VЃCxgpB߂XV by tomo 2006.5.17
	{
		EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
		u16 onedaywork = SysWork_NewsDaysCountGet( ev );
		if (onedaywork > diff_days) {
			onedaywork -= diff_days;
		} else {
			onedaywork = 0;
		}
		SysWork_NewsDaysCountSet( ev , onedaywork );
	}

	//|PNW
	{
		SysWorkUpdatePokeLot(fsys->savedata, diff_days);
	}

	//ACe
	{
		SysWorkUpdatePokeLevelNo(fsys->savedata);
	}


	//og^[Day_V[h̍XV
	BtlTower_UpdateDayRndSeed(fsys->savedata);

	//WIFIʐMf[^̍XV
	WIFIHISTORY_Update(SaveData_GetWifiHistory(fsys->savedata));
}

//------------------------------------------------------------------
/**
 * @brief	Ԃɂf[^XVFP
 * @param	fsys			tB[h䃏[Nւ̃|C^
 * @param	diff_minute		o߂ԁiPʁj
 *
 * FIELDSYS_WORKƂĂ邪A{IɂSAVEDATÂ݂
 * XVł悤Ȏdg݂̊֐ĂԂׂB
 */
//------------------------------------------------------------------
static void UpdateMinuteEvent(FIELDSYS_WORK * fsys, s32 diff_minute, const RTCTime * now)
{
	SeedSys_Growth(fsys, diff_minute);
///	HTE_UpdateHoneyTreeTime(fsys, diff_minute);
	HTSave_UpdateHoneyTreeTime(fsys->savedata, diff_minute);
    UnderGroundDataMinUpdate(fsys->savedata, diff_minute, EVTIME_IsPenaltyMode(fsys));

	{
		TV_WORK * tvwk = SaveData_GetTvWork(fsys->savedata);
		TVWORK_UpdateMinuteCount(tvwk, diff_minute, now->minute);
	}
}




//============================================================================================
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	ԑт̎擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	int		ԑсifield/timezone.hQƁj
 */
//------------------------------------------------------------------
int EVTIME_GetTimeZone(const FIELDSYS_WORK * fsys)
{
	GMTIME * tm = SaveData_GetGameTime(fsys->savedata);
	return GF_RTC_ConvertHourToTimeZone(tm->sv_time.hour);

}
//------------------------------------------------------------------
/**
 * @brief	Cxgԁij̎擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	int		
 */
//------------------------------------------------------------------
int EVTIME_GetMonth(const FIELDSYS_WORK * fsys)
{
	GMTIME * tm = SaveData_GetGameTime(fsys->savedata);
	return tm->sv_date.month;
}
//------------------------------------------------------------------
/**
 * @brief	Cxgԁij̎擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	int		
 */
//------------------------------------------------------------------
int EVTIME_GetDay(const FIELDSYS_WORK * fsys)
{
	GMTIME * tm = SaveData_GetGameTime(fsys->savedata);
	return tm->sv_date.day;
}
//------------------------------------------------------------------
/**
 * @brief	Cxgԁijj̎擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	int		j
 */
//------------------------------------------------------------------
int EVTIME_GetWeek(const FIELDSYS_WORK * fsys)
{
	GMTIME * tm = SaveData_GetGameTime(fsys->savedata);
	return tm->sv_date.week;
}
//------------------------------------------------------------------
/**
 * @brief	Cxgԁij̎擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	int		
 */
//------------------------------------------------------------------
int EVTIME_GetHour(const FIELDSYS_WORK * fsys)
{
	GMTIME * tm = SaveData_GetGameTime(fsys->savedata);
	return tm->sv_time.hour;
}
//------------------------------------------------------------------
/**
 * @brief	Cxgԁij̎擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	int		
 */
//------------------------------------------------------------------
int EVTIME_GetMinute(const FIELDSYS_WORK * fsys)
{
	GMTIME * tm = SaveData_GetGameTime(fsys->savedata);
	return tm->sv_time.minute;
}


//------------------------------------------------------------------
/**
 * @brief	Q[Jn̓tԎ擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	date	Q[Jn̓t󂯎邽߂RTCDate^ւ̃|C^
 * @param	time	Q[Jn̎Ԃ󂯎邽߂RTCTime^ւ̃|C^
 */
//------------------------------------------------------------------
void EVTIME_GetGameStartDateTime(const FIELDSYS_WORK * fsys, RTCDate * date, RTCTime * time)
{
	GMTIME * tm = SaveData_GetGameTime(fsys->savedata);
	RTC_ConvertSecondToDateTime(date, time, tm->start_sec);
}

//------------------------------------------------------------------
/**
 * @brief	Q[NA̓tԎ擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	date	Q[Jn̓t󂯎邽߂RTCDate^ւ̃|C^
 * @param	time	Q[Jn̎Ԃ󂯎邽߂RTCTime^ւ̃|C^
 */
//------------------------------------------------------------------
void EVTIME_GetGameClearDateTime(const FIELDSYS_WORK * fsys, RTCDate * date, RTCTime * time)
{
	GMTIME * tm = SaveData_GetGameTime(fsys->savedata);
	RTC_ConvertSecondToDateTime(date, time, tm->clear_sec);
}

//------------------------------------------------------------------
/**
 * @brief	Q[NA̓tԃZbg
 * @param	fsys	tB[h䃏[Nւ̃|C^
 */
//------------------------------------------------------------------
void EVTIME_SetGameClearDateTime(const FIELDSYS_WORK * fsys)
{
	GMTIME * tm = SaveData_GetGameTime(fsys->savedata);
	tm->clear_sec = GF_RTC_GetDateTimeBySecond();

}

//------------------------------------------------------------------
/**
 * @brief	DSݒύX̃yieB[hǂ̔
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	BOOL	TRUÊƂAyieB
 */
//------------------------------------------------------------------
BOOL EVTIME_IsPenaltyMode(FIELDSYS_WORK * fsys)
{
	GMTIME * gt = SaveData_GetGameTime(fsys->savedata);
	return GMTIME_IsPenaltyMode(gt);
}


