//============================================================================================
/**
 * @file	fd_shop.c
 * @brief	thBVbv obO
 * @author	Hiroyuki Nakamura
 * @date	2006.07.12
 */
//============================================================================================
#include "common.h"
#include "system/procsys.h"
#include "system/bmp_list.h"
#include "system/bmp_menu.h"
#include "system/wordset.h"
#include "system/clact_util.h"
#include "system/clact_tool.h"
#include "application/bag.h"

#include "fieldsys.h"
#include "fieldmap.h"
#include "field_clact.h"
#include "syswork.h"

#include "fd_shop_sys.h"
#include "fd_shop.h"


//=================================================================================================
//	vg^Cv錾
//=================================================================================================
static u8 ShopSaleWaitSeq( FIELDSYS_WORK * fsys, SHOP_WORK * wk );
static void ShopSaleRetSeq( GMEVENT_CONTROL * event );


//--------------------------------------------------------------------------------------------
/**
 * @brief	tB[hCxgFVbvpobO
 * @param	event	tB[hCxgpp[^
 * @retval	TRUE	CxgI
 * @retval	FALSE	Cxgp
 */
//--------------------------------------------------------------------------------------------
BOOL GMEVENT_ShopSale( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	SHOP_WORK * wk;

	fsys = FieldEvent_GetFieldSysWork(event);
	wk = FieldEvent_GetSpecialWork(event);

	switch( wk->seq ){
	case SHOP_SEQ_SALE_WAIT:		// uvI҂
		wk->seq = ShopSaleWaitSeq( fsys, wk );
		break;

	case SHOP_SEQ_SALE_RET:			// uvI -> tF[hC
		ShopSaleRetSeq( event );
		break;
	}
	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * obOʏI҂
 *
 * @param	fsys	tB[h[N
 * @param	wk		Vbv[N
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static u8 ShopSaleWaitSeq( FIELDSYS_WORK * fsys, SHOP_WORK * wk )
{
	// TuvZXI҂
	if( FieldEvent_Cmd_WaitSubProcEnd( fsys ) ) {
		return SHOP_SEQ_SALE_WAIT;
	}

	wk->fnote_sale_cnt = BagSysSaleCntGet( wk->bag_wk );

	sys_FreeMemoryEz( wk->bag_wk );

	FieldEvent_Cmd_SetMapProc( fsys );

	return SHOP_SEQ_SALE_RET;
}

//--------------------------------------------------------------------------------------------
/**
 * VbvA҂
 *
 * @param	event	tB[hCxgpp[^
 *
 * @return	ڍsV[PX
 */
//--------------------------------------------------------------------------------------------
static void ShopSaleRetSeq( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	SHOP_WORK * wk;

	fsys = FieldEvent_GetFieldSysWork(event);
	wk = FieldEvent_GetSpecialWork(event);

	// tB[h}bvvZXJn҂
	if( FieldEvent_Cmd_WaitMapProcStart(fsys) ){
		FieldFadeWipeSet( FLD_DISP_BRIGHT_BLACKIN );
		FieldEvent_Change( event, GMEVENT_Shop, wk );
		wk->seq = SHOP_SEQ_SALE_MENU_RET;
	}
}
