//=============================================================================
/**
 * @file	field_3d_anime.c
 * @bfief	tB[h3DAj[V֘A
 * @author	Nozomu Saito
 *
 */
//=============================================================================

#include "common.h"

#include "field_3d_anime.h"
#include "fieldsys.h"
#include "field_event.h"

#include "map_tool.h"
#include "system/snd_tool.h"	//for SE
#include "system/arc_tool.h"

#include "fielddata/build_model/build_model_id.h"

#define ONE_MODEL_ANM_NUM_MAX	(4)	//P̃fɑ΂čőS܂ŃAjĂƂ
#define NO_ANIME		(0)
#define NO_ENTRY		(0)
#define ANIME_CONT_MAX	(16)	//16܂œǗ
#define CONT_RENDER_OBJ_MAX	(6)	//AjǗf[^Ăő僌_[nai

#define SUICIDE_ANIME_MAX	(2)	//EAjǗő吔

#define ANIME_NONE_CODE		(0xffffffff)

typedef enum{
	STATE_END,	//I
	STATE_MOVE,	//ғ
}ANIME_STATE;

typedef enum{
	DATA_INVALID,
	DATA_VALID,
}DATA_VAL_STATE;

//EAjǗ\
typedef struct SUICIDE_ANIME_DATA_tag
{
	BOOL Valid;						//f[^LtO
	NNSG3dRenderObj *RenderObj;		//AjKp郌_[OBJ
	FLD_3D_ANM_DAT_PTR AnimePtr;	//ΏۃAj|C^
//	int ObjID;						//OBJID
	int AnimeCode;					//ΏۃAjR[h
}SUICIDE_ANIME_DATA;

typedef struct FLD_3D_ANIME_DATA_tag{
	NNSG3dAnmObj* pAnmObj;
	DATA_VAL_STATE Valid;
	int LoopCount;
//	BOOL OneFrameEnd;
//	BOOL *EndFlg;
	int AnimeCode;
	BOOL StopFlg;
	void *pFile;
	int LoopMax;
	ANIME_STATE State;	//
	BOOL Reverse;
	int ControlCode;
}FLD_3D_ANIME_DATA;

typedef struct ANIME_INFO_tag
{
	u8 Flg;			//Aj邩ǂ
	u8 Type;		//Aj^Cv
	u8 Suicide;		//EtO
	u8 dummy;		//_~[
	int Code[4];	//AjR[h
}ANIME_INFO;

typedef struct FLD_3D_ANIME_MANAGER_tag{
	NNSFndAllocator AnimeAllocator;
	FLD_3D_ANIME_DATA Fld3DAnimeData[FLD_3D_ANIME_MAX];
	SUICIDE_ANIME_DATA SuicideData[SUICIDE_ANIME_MAX];
	ARCHANDLE* AnimeHandle;
	ARCHANDLE* AnmInfoHandle;
}FLD_3D_ANIME_MANAGER;

typedef struct ANIME_DATA_LIST_tag{
	FLD_3D_ANM_DAT_PTR Data[ONE_MODEL_ANM_NUM_MAX];	//Aj[Vf[^Xg|C^
	int AnimeNum;						//Aj[Vf[^̐;
}ANIME_DATA_LIST;

typedef struct ANIME_CONT_tag
{
	ANIME_DATA_LIST	AnimeList;			//Aj[Vf[^Xg
	NNSG3dRenderObj *RenderObj[CONT_RENDER_OBJ_MAX];			//AjKp郌_[OBJ
	FLD_3D_ANM_DAT_PTR BindAnime;			//oChĂAj
	int ObjID;							//OBJID
	u8 EntryID;							//o^ID
}ANIME_CONT;

typedef struct ANIME_CONT_MNG_tag
{
	ANIME_CONT AnimeCont[ANIME_CONT_MAX];
}ANIME_CONT_MNG;

typedef struct ANIME_TABLE_tag
{
	int AnimeCode[ONE_MODEL_ANM_NUM_MAX];
}ANIME_TABLE;

//==============================================================================
/**
 * EAjGg[
 *
 * @param	*ioSuicideData				EAjǗ\̂ւ̃|C^
 * @param	*objectdata					Ώۃ_[OBJ
 * @param	anime						Aj|C^
 * @param	inAnimeCode					ΏۃAjR[h
 *
 * @return	BOOL	TRUE:Eς݂œo^	FALSE:܂Ă
 */
//==============================================================================
static BOOL EntrySuicideAnime(	SUICIDE_ANIME_DATA *ioSuicideData,
								NNSG3dRenderObj *objectdata,
								FLD_3D_ANM_DAT_PTR	anime,
								const u8 inAnimeCode	)
{
	int i;
	GF_ASSERT(anime->LoopMax!=LOOP_INFINIT&&"[v񐔂ɐ̂́AΏۊOł");
	
	//Gg[
	for(i=0;i<SUICIDE_ANIME_MAX;i++){
		if (ioSuicideData[i].Valid){
			if ( (ioSuicideData[i].AnimeCode == inAnimeCode)&&
					(ioSuicideData[i].RenderObj == objectdata) ){
///				OS_Printf("̂łɃGgĂ\n");
				return FALSE;
			}
		}
	}
	//Gg[
	for(i=0;i<SUICIDE_ANIME_MAX;i++){
		if (!ioSuicideData[i].Valid){
			ioSuicideData[i].Valid = TRUE;
			ioSuicideData[i].AnimeCode = inAnimeCode;
			ioSuicideData[i].AnimePtr = anime;
			ioSuicideData[i].RenderObj = objectdata;
			break;
		}
	}
	return TRUE;
}


//==============================================================================
/**
 * Aj擾
 *
 * @param	inHandle			A[JCunh
 * @param	inID				A[JCuhc
 * @param	pModel				f\[X
 * @param	pAnmObj				AjOBJ
 * @param	pTex				eNX`
 * @param	allocator			AP[^
 *
 * @return	void*				Aj|C^
 */
//==============================================================================
static void *GetField3DAnimeByArc(	ARCHANDLE *inHandle,
									const u32 inID,
									NNSG3dResMdl* pModel,
									NNSG3dAnmObj** pAnmObj,
									NNSG3dResTex	*pTex,
									NNSFndAllocator *allocator)
{
    void *pAnmRes;
	void *mem = NULL;

	GF_ASSERT(inID != ANIME_NONE_CODE);

	mem = ArchiveDataLoadAllocByHandle( inHandle, inID, HEAPID_FIELD );

	GF_ASSERT(mem != NULL);
    {
        pAnmRes = NNS_G3dGetAnmByIdx(mem, 0);
        GF_ASSERT(pAnmRes != NULL);

        // Kvʂ̃AP[gBCjVCY͕ʓrKvɂȂB
        *pAnmObj = NNS_G3dAllocAnmObj(allocator, // gpAP[^w
                                     pAnmRes,    // Aj[V\[Xw
                                     pModel);    // f\[Xw
		GF_ASSERT(pAnmObj != NULL);

        //
        // AnmObj BWCgAj[VȊOl
        //
        NNS_G3dAnmObjInit(*pAnmObj, // Aj[VIuWFNgւ̃|C^
                          pAnmRes, // Aj\[Xւ̃|C^
                          pModel,  // NNSG3dResMdlւ̃|C^
                          pTex );  // NNSG3dResTexւ̃|C^(eNX`p^[AjȊOȂNULLł悢)
		return mem;
    }
}

//==============================================================================
/**
 * Aj[u
 *
 * @param	inRenderObj				_[OBJ
 * @param	inAnmObj				AjOBJ
 *
 * @return	BOOL				TRUE:[u	FALSE:[uȂ		
 */
//==============================================================================
static const BOOL RemoveAnime(NNSG3dRenderObj *inRenderObj, NNSG3dAnmObj *inAnmObj)
{
	if (inAnmObj == NULL){
		return FALSE;
	}
	if (inRenderObj == NULL){
		return FALSE;
	}

	//sł́A[uΏۂĂ̊֐ʂ(̏ꍇAł̓[uɖ߂)
	NNS_G3dRenderObjRemoveAnmObj( inRenderObj, inAnmObj );
	return TRUE;
}

//==============================================================================
/**
 * EAjĎ
 *
 * @param	*ioSuicideData				EAjǗ\̂ւ̃|C^
 * @param	*objectdata					Ώۃ_[OBJ
 * @param	inAnimeCode					ΏۃAjR[h
 *
 * @return	none
 */
//==============================================================================
static void SuicideAnimeMain(SUICIDE_ANIME_DATA *ioSuicideData)
{
	int i;
	for(i=0;i<SUICIDE_ANIME_MAX;i++){
		if (ioSuicideData[i].Valid){
			//AjI`FbN
			if (F3DA_IsAnimeEnd(ioSuicideData[i].AnimePtr)){
				//IĂAjp[W
				RemoveAnime(ioSuicideData[i].RenderObj, ioSuicideData[i].AnimePtr->pAnmObj);
				ioSuicideData[i].Valid = FALSE;
				ioSuicideData[i].AnimeCode = 0;
				ioSuicideData[i].AnimePtr = NULL;
				ioSuicideData[i].RenderObj = NULL;
			}
		}
	}
}

//==============================================================================
/**
 * 3DAj}l[W̃AP[V
 *
 * @return	FLD_3D_ANM_MNG_PTR				AjǗ\̂ւ̃|C^
 */
//==============================================================================
FLD_3D_ANM_MNG_PTR F3DA_Field3DAnimeInit(void)
{
	int i;
	FLD_3D_ANM_MNG_PTR field_3d_anime_ptr;
	field_3d_anime_ptr = sys_AllocMemory( HEAPID_FIELD, sizeof(FLD_3D_ANIME_MANAGER) );
	//󂢂ĂAjz
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		field_3d_anime_ptr->Fld3DAnimeData[i].Valid = DATA_INVALID;
		field_3d_anime_ptr->Fld3DAnimeData[i].StopFlg = FALSE;
		field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj = NULL;
		field_3d_anime_ptr->Fld3DAnimeData[i].LoopCount = 0;
//		field_3d_anime_ptr->Fld3DAnimeData[i].EndFlg = NULL;
		field_3d_anime_ptr->Fld3DAnimeData[i].AnimeCode = 0;
		field_3d_anime_ptr->Fld3DAnimeData[i].pFile = NULL;
		field_3d_anime_ptr->Fld3DAnimeData[i].LoopMax = LOOP_INFINIT;
		field_3d_anime_ptr->Fld3DAnimeData[i].State = STATE_END;
		field_3d_anime_ptr->Fld3DAnimeData[i].Reverse = FALSE;
		field_3d_anime_ptr->Fld3DAnimeData[i].ControlCode = 0;
	}
	for(i=0;i<SUICIDE_ANIME_MAX;i++){
		field_3d_anime_ptr->SuicideData[i].Valid = FALSE;
		field_3d_anime_ptr->SuicideData[i].RenderObj = NULL;
		field_3d_anime_ptr->SuicideData[i].AnimePtr = NULL;
		field_3d_anime_ptr->SuicideData[i].AnimeCode = 0;
	}
	//AjAP[^
	sys_InitAllocator(&field_3d_anime_ptr->AnimeAllocator,HEAPID_FIELD,4);
	//AjA[JCunhI[v
	field_3d_anime_ptr->AnimeHandle = ArchiveDataHandleOpen( ARC_BM_ANM, HEAPID_FIELD );
	//AjA[JCunhI[v
	field_3d_anime_ptr->AnmInfoHandle = ArchiveDataHandleOpen( ARC_BM_ANM_LIST, HEAPID_FIELD );	
//	field_3d_anime_ptr->EndFlg = FALSE;
	return field_3d_anime_ptr;
}


//==============================================================================
/**
 * AjOBJ擾
 * @param	inFld3DAnmDat			Ajf[^|C^
 *
 * @return	NNSG3dAnmObj			AjOBJ
 */
//==============================================================================
static NNSG3dAnmObj *GetAnmObj(FLD_3D_ANM_DAT_PTR inFld3DAnmDat)
{
	if (inFld3DAnmDat == NULL){
		return NULL;
	}
	return inFld3DAnmDat->pAnmObj;
}

//==============================================================================
/**
 * ǉɏ邩ǂ`FbN
 * @param	inType			Aj^Cv
 *
 * @return	BOOL			TRUE:	FALSE:Ȃ
 */
//==============================================================================
static BOOL CheckAddConditional(const u8 inType)
{
	if ( (inType&0x01) == 0x01 ){
		return TRUE;		//
	}else{
		return FALSE;		//
	}
}

//==============================================================================
/**
 * Zbgɏ邩ǂ`FbN
 * @param	inType			Aj^Cv
 *
 * @return	BOOL			TRUE:	FALSE:Ȃ
 */
//==============================================================================
static BOOL CheckSetConditional(const u8 inType)
{
	if ( ((inType>>1)&0x01) == 0x01){
		return TRUE;		//
	}else{
		return FALSE;		//
	}
}

//==============================================================================
/**
 * AjXe[g̎擾
 *
 * @param	inAnimeData				Ajf[^|C^
 *
 * @return	int						AjXe[g
 */
//==============================================================================
static int GetAnimeState(const FLD_3D_ANM_DAT_PTR inAnimeData)
{
	GF_ASSERT((inAnimeData->Valid == DATA_VALID)&&"f[^͖ł");
	return inAnimeData->State;
}

//==============================================================================
/**
 * Aj[Vǉ
 *
 * @param	inObjCode				OBJID
 * @param	inAnimeNo				ĐAjio[
 * @param	inLoopCount				JԂ
 * @param	inCode					R[h
 * @param	inReverse				tĐtO
 * @param	inStopFlg				~tO
 * @param	inAnimeType				ǉAj^Cv
 * @param	objectmodel				\[Xf
 * @oaram	pTex					eNX`\[XieNX`p^[Ajpj
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 *
 * @return	ANIME_CONT_PTR	Ajf[^|C^
 */
//==============================================================================
FLD_3D_ANM_DAT_PTR F3DA_AddField3DAnime(const int inObjCode,
										const int inAnimeNo,
										const int inLoopCount,
										const int inCode,
										const BOOL inReverse,
										const BOOL inStopFlg,
										const BOOL inConditional,
										NNSG3dResMdl *objectmodel,
										NNSG3dResTex	*pTex,
										FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	FLD_3D_ANM_DAT_PTR data;
	int i;
	int anime_code;
	ANIME_INFO info;

	//wnaiAjA[JCo
	ArchiveDataLoadByHandle(field_3d_anime_ptr->AnmInfoHandle, inObjCode, &info);

	GF_ASSERT(inAnimeNo<ONE_MODEL_ANM_NUM_MAX);

	anime_code = info.Code[inAnimeNo];
	if (anime_code == ANIME_NONE_CODE){
		return NULL;
	}

	if ( CheckAddConditional(info.Type) != inConditional){
///		OS_Printf("ĂȂ:%d\n",anime_code);
		return NULL;
	}
	
	//R[hd`FbN
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		if ((inCode != 0)&&
				(field_3d_anime_ptr->Fld3DAnimeData[i].ControlCode == inCode)){
///			OS_Printf("%d:do^ł\n",inCode);
			GF_ASSERT(0);
		}
	}

	//󂢂ĂAjz
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		if (field_3d_anime_ptr->Fld3DAnimeData[i].Valid == DATA_INVALID){
			field_3d_anime_ptr->Fld3DAnimeData[i].Valid = DATA_VALID;
			field_3d_anime_ptr->Fld3DAnimeData[i].StopFlg = inStopFlg;
			field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj = NULL;
			field_3d_anime_ptr->Fld3DAnimeData[i].LoopCount = 0;
			//field_3d_anime_ptr->Fld3DAnimeData[i].EndFlg = NULL;
			field_3d_anime_ptr->Fld3DAnimeData[i].AnimeCode = anime_code;
			field_3d_anime_ptr->Fld3DAnimeData[i].Reverse = inReverse;
			field_3d_anime_ptr->Fld3DAnimeData[i].ControlCode = inCode;

			field_3d_anime_ptr->Fld3DAnimeData[i].pFile =
									GetField3DAnimeByArc(	field_3d_anime_ptr->AnimeHandle,
																anime_code,
																objectmodel,
																&field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj,
																pTex,
																&field_3d_anime_ptr->AnimeAllocator);
			field_3d_anime_ptr->Fld3DAnimeData[i].LoopMax = inLoopCount;
			field_3d_anime_ptr->Fld3DAnimeData[i].State = STATE_MOVE;
			data = &(field_3d_anime_ptr->Fld3DAnimeData[i]);
			//ĐāAJnt[Zbg
			F3DA_SetStartFrame(&field_3d_anime_ptr->Fld3DAnimeData[i]);
			return data;
		}
	}
	//ǉłȂꍇ
	GF_ASSERT(0&&"3DAjǉł܂ł");
	return NULL;
}

//==============================================================================
/**
 * Aj[Vǉ(ڍׂȐݒ͍sȂA풓Ajp)
 *
 * @param	inObjCode				OBJID
 * @param	objectmodel				\[Xf
 * @oaram	pTex					eNX`\[XieNX`p^[Ajpj
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void F3DA_AddField3DAnimeEasy(	const int inObjCode,
								NNSG3dResMdl *objectmodel,
								NNSG3dResTex	*pTex,
								FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	int anime_code;
	int n;
	int i;

	ANIME_INFO info;
	//wnaiAjA[JCo
	ArchiveDataLoadByHandle(field_3d_anime_ptr->AnmInfoHandle, inObjCode, &info);

	//AjȂ̂͏Ȃ
	if (!info.Flg){
		return;
	}
		
	for(n=0;n<ONE_MODEL_ANM_NUM_MAX;n++){
		anime_code = info.Code[n];
		if (anime_code == ANIME_NONE_CODE){
			return;//𔲂
		}
		
		if ( CheckAddConditional(info.Type) != FALSE){
///				OS_Printf("ĂȂ:%d\n",anime_code);
				return;
		}

		//󂢂ĂAjz
		for(i=0;i<FLD_3D_ANIME_MAX;i++){
			if (field_3d_anime_ptr->Fld3DAnimeData[i].Valid == DATA_INVALID){
				field_3d_anime_ptr->Fld3DAnimeData[i].Valid = DATA_VALID;
				field_3d_anime_ptr->Fld3DAnimeData[i].StopFlg = FALSE;
				field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj = NULL;
				field_3d_anime_ptr->Fld3DAnimeData[i].LoopCount = 0;
				//field_3d_anime_ptr->Fld3DAnimeData[i].EndFlg = NULL;
				field_3d_anime_ptr->Fld3DAnimeData[i].AnimeCode = anime_code;
				field_3d_anime_ptr->Fld3DAnimeData[i].Reverse = FALSE;
				field_3d_anime_ptr->Fld3DAnimeData[i].ControlCode = 0;

				field_3d_anime_ptr->Fld3DAnimeData[i].pFile =
										GetField3DAnimeByArc(	field_3d_anime_ptr->AnimeHandle,
																anime_code,
																objectmodel,
																&field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj,
																pTex,
																&field_3d_anime_ptr->AnimeAllocator);
				field_3d_anime_ptr->Fld3DAnimeData[i].LoopMax = LOOP_INFINIT;
				field_3d_anime_ptr->Fld3DAnimeData[i].State = STATE_MOVE;
				//ĐāAJnt[Zbg
				F3DA_SetStartFrame(&field_3d_anime_ptr->Fld3DAnimeData[i]);
	
				//EAj͊Jn͂Ƃ߂ĂîƂΏۂ͗j
				if ( info.Suicide/*(inObjCode == BMID_CY_SLOPE) || (inObjCode == BMID_CY_SLOPE_DUN)*/ ){	
					field_3d_anime_ptr->Fld3DAnimeData[i].StopFlg = TRUE;
					field_3d_anime_ptr->Fld3DAnimeData[i].LoopMax = 1;
				}
				break;//̓o^
			}
		}//end for(i)
		
		//ǉłȂꍇ
		GF_ASSERT((i!=FLD_3D_ANIME_MAX)&&"3DAjǉł܂ł");
	}// end for(n)
}

//==============================================================================
/**
 * Aj[VZbg
 *
 * @param	inObjCode				OBJID
 * @param	inAnimeNo				ĐAjio[
 * @param	objectdata				_[OBJ
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 *
 * @return	BOOL	TRUE:Zbgł	FALSE:ZbgłȂ
 */
//==============================================================================
BOOL F3DA_SetFld3DAnime(const int inObjCode,
						const int inAnimeNo,
						const BOOL inConditional,
						NNSG3dRenderObj *objectdata,
						FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	int i;
	int anime_code;
	ANIME_INFO info;
	
	BOOL rc;
	if (field_3d_anime_ptr==NULL){
		GF_ASSERT_MSG(0,"Aj}l[WNULLł");
		return FALSE;
	}

	if (inObjCode >= F3DA_GetAnimeArcObjNum(field_3d_anime_ptr)){
		return FALSE;
	}
		
	//wnaiAjA[JCo
	ArchiveDataLoadByHandle(field_3d_anime_ptr->AnmInfoHandle, inObjCode, &info);

	GF_ASSERT(inAnimeNo<ONE_MODEL_ANM_NUM_MAX);
	
	anime_code = info.Code[inAnimeNo];
	if (anime_code == ANIME_NONE_CODE){
		return FALSE;
	}

	if ( CheckSetConditional(info.Type) != inConditional){
///		OS_Printf("𖞂ĂȂ:%d\n",anime_code);
		return FALSE;
	}

	//wAjOBJɃZbg
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		if(anime_code == field_3d_anime_ptr->Fld3DAnimeData[i].AnimeCode){
			//EAj[VGg[
			if (info.Suicide){
				rc = EntrySuicideAnime(	field_3d_anime_ptr->SuicideData,
										objectdata,
										&field_3d_anime_ptr->Fld3DAnimeData[i],
										anime_code	);
			}else{
				rc = TRUE;
			}

			if (rc){
				NNS_G3dRenderObjAddAnmObj( objectdata, field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj );
			}
			
			return TRUE;
		}
	}
	//AjȂꍇ
///	OS_Printf("ObjID=%d:3DAj܂\n",inObjCode);
	return FALSE;
}

//==============================================================================
/**
 * Aj[VZbg
 *
 * @param	inObjCode				OBJID
 * @param	objectdata				_[OBJ
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 *
 * @return	BOOL	TRUE:Zbgł	FALSE:ZbgłȂ
 */
//==============================================================================
BOOL F3DA_SetFld3DAnimeEasy(const int inObjCode,
							NNSG3dRenderObj *objectdata,
							FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	int n;
	int i;
	int anime_code;
	ANIME_INFO info;
	
	BOOL set_flg;
	BOOL rc;

	set_flg = FALSE;
	
	if (field_3d_anime_ptr==NULL){
		GF_ASSERT(0&&"Aj}l[WNULLł");
	}

	if (inObjCode >= F3DA_GetAnimeArcObjNum(field_3d_anime_ptr)){
		return FALSE;
	}
		
	//wnaiAjA[JCo
	ArchiveDataLoadByHandle(field_3d_anime_ptr->AnmInfoHandle, inObjCode, &info);

	if ( CheckSetConditional(info.Type) != FALSE){
///		OS_Printf("𖞂ĂȂ:%d\n",anime_code);
		return FALSE;
	}
	
	for(n=0;n<ONE_MODEL_ANM_NUM_MAX;n++){
		anime_code = info.Code[n];
		if (anime_code == ANIME_NONE_CODE){
			return set_flg;//𔲂
		}

		//wAjOBJɃZbg
		for(i=0;i<FLD_3D_ANIME_MAX;i++){
			if(anime_code == field_3d_anime_ptr->Fld3DAnimeData[i].AnimeCode){
				//EAj[VGg[
				if (info.Suicide){
					rc = EntrySuicideAnime(	field_3d_anime_ptr->SuicideData,
											objectdata,
											&field_3d_anime_ptr->Fld3DAnimeData[i],
											anime_code	);
				}else{
					rc = TRUE;
				}

				if (rc){
					NNS_G3dRenderObjAddAnmObj( objectdata, field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj );
					set_flg = TRUE;
				}
			
				break;
			}
		}
		//AjȂꍇ
///		OS_Printf("ObjID=%d:3DAj܂\n",inObjCode);
	}
	
	return set_flg;
}

//==============================================================================
/**
 * Aj[VS
 *
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void RereaseFld3DAnimeAll(FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	int i;
	if (field_3d_anime_ptr==NULL) return;
	
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		if (field_3d_anime_ptr->Fld3DAnimeData[i].Valid != DATA_INVALID){
			if (field_3d_anime_ptr->Fld3DAnimeData[i].Valid == DATA_VALID){
				NNS_G3dFreeAnmObj(&field_3d_anime_ptr->AnimeAllocator,field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj);
				field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj = NULL;
				sys_FreeMemoryEz(field_3d_anime_ptr->Fld3DAnimeData[i].pFile);
			}
			field_3d_anime_ptr->Fld3DAnimeData[i].Valid = DATA_INVALID;
			field_3d_anime_ptr->Fld3DAnimeData[i].ControlCode = 0;
		}
	}
}

//==============================================================================
/**
 * CfbNXɂAj[V
 *
 * @param	inIdx				CfbNX
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void RereaseFld3DAnimeByIdx(const u8 inIdx, FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	GF_ASSERT(inIdx<FLD_3D_ANIME_MAX);
	
	if (field_3d_anime_ptr==NULL) return;
	
	if (field_3d_anime_ptr->Fld3DAnimeData[inIdx].Valid != DATA_INVALID){
		if (field_3d_anime_ptr->Fld3DAnimeData[inIdx].Valid == DATA_VALID){
			NNS_G3dFreeAnmObj(	&field_3d_anime_ptr->AnimeAllocator,
								field_3d_anime_ptr->Fld3DAnimeData[inIdx].pAnmObj);
			field_3d_anime_ptr->Fld3DAnimeData[inIdx].pAnmObj = NULL;
			sys_FreeMemoryEz(field_3d_anime_ptr->Fld3DAnimeData[inIdx].pFile);
		}
		field_3d_anime_ptr->Fld3DAnimeData[inIdx].Valid = DATA_INVALID;
		field_3d_anime_ptr->Fld3DAnimeData[inIdx].ControlCode = 0;
	}
}

//==============================================================================
/**
 * Aj[V
 *
 * @param	outAnimePtr				Ajf[^|C^
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void F3DA_RereaseFld3DAnime(FLD_3D_ANM_DAT_PTR outAnimePtr, FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	if (field_3d_anime_ptr==NULL) return;
	
	GF_ASSERT(outAnimePtr!=NULL&&"NULL悤ƂĂ܂");
	
	if (outAnimePtr->Valid != DATA_INVALID){
		if (outAnimePtr->Valid == DATA_VALID){
			NNS_G3dFreeAnmObj(	&field_3d_anime_ptr->AnimeAllocator,
								outAnimePtr->pAnmObj);
			outAnimePtr->pAnmObj = NULL;
			sys_FreeMemoryEz(outAnimePtr->pFile);
		}
		outAnimePtr->Valid = DATA_INVALID;
		outAnimePtr->ControlCode = 0;
	}
}

//==============================================================================
/**
 * Aj[V[u
 *
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 * @param	inRenderObj				_[OBJ
 * @param	inObjCode				OBJID
 * @param	inAnimeNo				[uAjio[
 * 
 * @return	none
 */
//==============================================================================
void F3DA_RemoveFld3DAnime(	FLD_3D_ANM_MNG_PTR field_3d_anime_ptr,
							NNSG3dRenderObj *inRenderObj,
							const int inObjCode,
							const int inAnimeNo	)
{
	u8 i;
	int anime_code;
	ANIME_INFO info;
	//wnaiAjA[JCo
	ArchiveDataLoadByHandle(field_3d_anime_ptr->AnmInfoHandle, inObjCode, &info);
	GF_ASSERT(inAnimeNo<ONE_MODEL_ANM_NUM_MAX);
	anime_code = info.Code[inAnimeNo];
	GF_ASSERT(anime_code != ANIME_NONE_CODE);
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		if ( field_3d_anime_ptr->Fld3DAnimeData[i].Valid == DATA_VALID ){
			if(field_3d_anime_ptr->Fld3DAnimeData[i].AnimeCode == anime_code){
				RemoveAnime(inRenderObj, field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj);
				return;
			}
		}
	}
}

//==============================================================================
/**
 * Aj[V}l[W
 *
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 * 
 * @return	none
 */
//==============================================================================
void FreeFld3DAnimeManager(FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	if (field_3d_anime_ptr==NULL) return;
	
	//nhN[Y
	ArchiveDataHandleClose( field_3d_anime_ptr->AnimeHandle );
	ArchiveDataHandleClose( field_3d_anime_ptr->AnmInfoHandle );
	
	sys_FreeMemoryEz( field_3d_anime_ptr );
	field_3d_anime_ptr = NULL;
}

//==============================================================================
/**
 * }l[WǗCfbNXŃAjf[^擾
 *
 * @param	inIndex					CfbNX
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 * 
 * @return	none
 */
//==============================================================================
FLD_3D_ANM_DAT_PTR F3DA_GetFld3DAnmPtrByIdx(const int inIndex,
											FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	FLD_3D_ANM_DAT_PTR data;
	
	GF_ASSERT(inIndex<FLD_3D_ANIME_MAX);
	data = &(field_3d_anime_ptr->Fld3DAnimeData[inIndex]);

	GF_ASSERT(data->Valid!=DATA_INVALID&&"wf[^͖Ԃł");
	
	return data;
}

//==============================================================================
/**
 * R[hŃAjf[^擾
 *
 * @param	inCode					R[h
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 * 
 * @return	none
 */
//==============================================================================
FLD_3D_ANM_DAT_PTR F3DA_GetFld3DAnmPtrByCode(	const int inCode,
												FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	FLD_3D_ANM_DAT_PTR data;
	int i;
	GF_ASSERT(inCode!=0&&"R[hӂĂȂAj͎擾ΏۊOł");
	data = NULL;
	//
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		if (field_3d_anime_ptr->Fld3DAnimeData[i].ControlCode == inCode){
			data = &(field_3d_anime_ptr->Fld3DAnimeData[i]);
			GF_ASSERT(data->Valid!=DATA_INVALID&&"wf[^͖Ԃł");
			break;
		}
	}
	GF_ASSERT(data!=NULL&&"Aj܂ł");
	return data;
}

//==============================================================================
/**
 * Ajf[^擾
 *
 * @param	inObjID					naihc
 * @param	inAnimeNo				Ajio[
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 * 
 * @return	none
 */
//==============================================================================
FLD_3D_ANM_DAT_PTR F3DA_GetFld3DAnmPtr(	const int inObjID,
										const int inAnimeNo,
										FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	FLD_3D_ANM_DAT_PTR data;
	int anime_code;
	int i;
	ANIME_INFO info;
	//wnaiAjA[JCo
	ArchiveDataLoadByHandle(field_3d_anime_ptr->AnmInfoHandle, inObjID, &info);

	GF_ASSERT(inAnimeNo<ONE_MODEL_ANM_NUM_MAX);

	anime_code = info.Code[inAnimeNo];

	data = NULL;
	
	//
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		if (field_3d_anime_ptr->Fld3DAnimeData[i].AnimeCode == anime_code){
			data = &(field_3d_anime_ptr->Fld3DAnimeData[i]);
			GF_ASSERT(data->Valid!=DATA_INVALID&&"wf[^͖Ԃł");
			break;
		}
	}
	GF_ASSERT(data!=NULL&&"Aj܂ł");
	return data;
}

//==============================================================================
/**
 * CfbNXɂXgbvtO̐؂ւ
 *
 * @param	inIdx					CfbNX
 * @param	inFlg					XgbvtO
 * @param	field_3d_anime_ptr		Aj[V}l[Wւ̃|C^
 * 
 * @return	none
 */
//==============================================================================
void F3DA_SetStopFlgByIdx(const u8 inIdx, const BOOL inFlg, FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	GF_ASSERT(inIdx<FLD_3D_ANIME_MAX);
	field_3d_anime_ptr->Fld3DAnimeData[inIdx].StopFlg = inFlg;
}

//==============================================================================
/**
 * XgbvtO̐؂ւ
 *
 * @param	inAnimePtr				Ajf[^|C^
 * @param	inFlg					XgbvtO
 * 
 * @return	none
 */
//==============================================================================
void F3DA_SetStopFlg(FLD_3D_ANM_DAT_PTR inAnimePtr, const BOOL inFlg)
{
	inAnimePtr->StopFlg = inFlg;
}

//==============================================================================
/**
 * Aj[VXe[g𓮍쒆ɂ
 *
 * @param	inAnimePtr				Ajf[^|C^
 * 
 * @return	none
 */
//==============================================================================
void F3DA_MoveAnime(FLD_3D_ANM_DAT_PTR inAnimePtr)
{
	inAnimePtr->State = STATE_MOVE;
}

//==============================================================================
/**
 * Aj[VŏIt[Ԃ
 *
 * @param	inAnimeData	Aj[Vf[^ւ̃|C^
 *
 * @return	BOOL TRUE:ŏIt[	FALSE:ŏIt[ȊO
 */
//==============================================================================
BOOL F3DA_IsLastFrame(FLD_3D_ANM_DAT_PTR	inAnimeData)
{
	BOOL rc;
	if (!inAnimeData->Reverse){	//ʏ܂킵
		if (inAnimeData->pAnmObj->frame >= 
				NNS_G3dAnmObjGetNumFrame(inAnimeData->pAnmObj)-(FX32_ONE)){
			rc = TRUE;
		}else{
			rc = FALSE;
		}
	}else{						//t܂킵
		if (inAnimeData->pAnmObj->frame == 0){
			rc = TRUE;
		}else{
			rc = FALSE;
		}
	}
	return rc;
}

//==============================================================================
/**
 * JnAj[Vt[Zbg
 *
 * @param	outAnimeData	Aj[Vf[^ւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void F3DA_SetStartFrame(FLD_3D_ANM_DAT_PTR	outAnimeData)
{
	if (!outAnimeData->Reverse){	//ʏ܂킵
		outAnimeData->pAnmObj->frame = 0;
	}else{						//t܂킵
		outAnimeData->pAnmObj->frame = NNS_G3dAnmObjGetNumFrame(outAnimeData->pAnmObj)-(FX32_ONE);
	}
}

//==============================================================================
/**
 * JnAj[Vt[Zbg
 *
 * @param	outAnimeData	Aj[Vf[^ւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void F3DA_SetLastFrame(FLD_3D_ANM_DAT_PTR	outAnimeData)
{
	if (!outAnimeData->Reverse){	//ʏ܂킵
		outAnimeData->pAnmObj->frame = NNS_G3dAnmObjGetNumFrame(outAnimeData->pAnmObj)-(FX32_ONE);
	}else{						//t܂킵
		outAnimeData->pAnmObj->frame = 0;
	}
}

//==============================================================================
/**
 * JnAj[Vt[ύX
 *
 * @param	outAnimeData	Aj[Vf[^ւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void F3DA_ChangeFrame(FLD_3D_ANM_DAT_PTR	outAnimeData)
{
	if (!outAnimeData->Reverse){	//ʏ܂킵
		outAnimeData->pAnmObj->frame += (FX32_ONE);
		if (outAnimeData->pAnmObj->frame == NNS_G3dAnmObjGetNumFrame(outAnimeData->pAnmObj)){
			outAnimeData->pAnmObj->frame = 0;
		}

	}else{						//t܂킵
		if (outAnimeData->pAnmObj->frame <= 0){
			outAnimeData->pAnmObj->frame =
				NNS_G3dAnmObjGetNumFrame(outAnimeData->pAnmObj)-(FX32_ONE);
		}else{
			outAnimeData->pAnmObj->frame -= (FX32_ONE);
		}
	}
}

//==============================================================================
/**
 * wAj[V̍Đtɂ
 *
 * @param	outAnimeData	Aj[Vf[^ւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void F3DA_SetAnimeReverse(FLD_3D_ANM_DAT_PTR	outAnimeData)
{
	//񐔎wAj̏ꍇ̓AT[g𔭍s
	///GF_ASSERT(outAnimeData->LoopMax != LOOP_INFINIT && "񐔎wAj[V̋t񂵂̓T|[gĂ܂");
	if (outAnimeData->Reverse){
		outAnimeData->Reverse = FALSE;
	}else{
		outAnimeData->Reverse = TRUE;
	}
}

//==============================================================================
/**
 * wAj[V̍Đtɂ(ڎw)
 *
 * @param	outAnimeData	Aj[Vf[^ւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void F3DA_SetAnimeReverseDirect(FLD_3D_ANM_DAT_PTR	outAnimeData, const BOOL inReverse)
{
	//񐔎wAj̏ꍇ̓AT[g𔭍s
	///GF_ASSERT(outAnimeData->LoopMax != LOOP_INFINIT && "񐔎wAj[V̋t񂵂̓T|[gĂ܂");
	outAnimeData->Reverse = inReverse;
}

//==============================================================================
/**
 * wAj[V̍ő僋[vZbg
 *
 * @param	outAnimeData	Aj[Vf[^ւ̃|C^
 * @param	inLoopMax		[v
 *
 * @return	none
 */
//==============================================================================
void F3DA_SetAnimeLoopMax(FLD_3D_ANM_DAT_PTR	outAnimeData, const int inLoopMax)
{
	outAnimeData->LoopMax = inLoopMax;
}

//==============================================================================
/**
 * wAj[V̐R[hZbg
 *
 * @param	outAnimeData	Aj[Vf[^ւ̃|C^
 * @param	inControlCode	R[h
 *
 * @return	none
 */
//==============================================================================
void F3DA_SetControlCode(FLD_3D_ANM_DAT_PTR	outAnimeData, const int inControlCode)
{
	outAnimeData->ControlCode = inControlCode;
}

//==============================================================================
/**
 * Aj[VC֐
 *
 * @param	field_3d_anime_ptr	3DAj[V}l[Wւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void F3DA_Main(FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	int i;
	FLD_3D_ANM_DAT_PTR	anime_data;
	if (field_3d_anime_ptr==NULL) return;
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		anime_data = &(field_3d_anime_ptr->Fld3DAnimeData[i]);
		//Aj͗Lǂ
		if (anime_data->Valid == DATA_VALID){
			//Aj[V~ĂA̓AjIĂꍇ͏΂
			if ((anime_data->StopFlg == TRUE)||(anime_data->State == STATE_END)){
				continue;
			}

			F3DA_ChangeFrame(anime_data);	//t[؂ւ
			
			if ( anime_data->LoopMax != LOOP_INFINIT ){	//[vw񐔂
				if (F3DA_IsLastFrame(anime_data)){			//ŏIt[H
					if (anime_data->LoopCount+1 >= anime_data->LoopMax){//ŏIw胋[v񐔖ڂH
						//AjI
						anime_data->State = STATE_END;
					}else{
						anime_data->LoopCount++;	//[vCNg
					}
				}
			}
		}
	}// end for
	//EĎ
	SuicideAnimeMain(field_3d_anime_ptr->SuicideData);

}

//==============================================================================
/**
 * Aj[VIĂ邩Ԃ
 * @param	inAnimeData	Ajf[^ւ̃|C^
 *
 * @return	BOOL	TRUE:I@FALSE:NO p
 */
//==============================================================================
BOOL F3DA_IsAnimeEnd(const FLD_3D_ANM_DAT_PTR inAnimeData)
{
	int state;
	state = GetAnimeState(inAnimeData);
	if (state == STATE_END){
		return TRUE;
	}else{
		return FALSE;
	}
}

//==============================================================================
/**
 * AjA[JCuێĂnai̐Ԃ
 * 
 * @param	field_3d_anime_ptr	3DAj[V}l[Wւ̃|C^
 *
 * @return	u16 t@C
 */
//==============================================================================
u16 F3DA_GetAnimeArcObjNum(FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	return ArchiveDataFileCntGetByHandle(field_3d_anime_ptr->AnmInfoHandle);
}

//==============================================================================
/**
 * wnaihc̃AjԂ
 * 
 * @param	field_3d_anime_ptr	3DAj[V}l[Wւ̃|C^
 *
 * @return	u16 Aj
 */
//==============================================================================
const u8 F3DA_GetAnimeNum(FLD_3D_ANM_MNG_PTR field_3d_anime_ptr, const int inObjCode)
{
	u8 n;
	ANIME_INFO info;
	//wnaiAjA[JCo
	ArchiveDataLoadByHandle(field_3d_anime_ptr->AnmInfoHandle, inObjCode, &info);

	//AjȂ̂̐0
	if (!info.Flg){
		return 0;
	}
		
	for(n=0;n<ONE_MODEL_ANM_NUM_MAX;n++){
		if (info.Code[n] == ANIME_NONE_CODE){
			break;
		}
	}
	return n;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//==============================================================================
/**
 * Aj[VGg[
 *
 * @param	inAnimeContMng	Aj[VǗ}l[Wւ̃|C^
 * @param	inEntryID		o^ID
 *
 * @return	ANIME_CONT_PTR	AjǗf[^|C^
 */
//==============================================================================
static ANIME_CONT_PTR EntryAnimeCont(ANIME_CONT_MNG_PTR inAnimeContMng, const u8 inEntryID)
{	
	u8 i;
	u8 idx;
	ANIME_CONT_PTR	data;
	
	data = NULL;
	
	GF_ASSERT(inEntryID!=NO_ENTRY&&"ID=0͎wł܂");
	idx = ANIME_CONT_MAX;
	//󂢂ĂƂA\IDłɂ邩T
	for(i=0;i<ANIME_CONT_MAX;i++){
#ifdef PM_DEBUG		
		if (inAnimeContMng->AnimeCont[i].EntryID == inEntryID ){
			OS_Printf("ID=%d:w肳ꂽID͓o^ς݂ł\n",inEntryID);
			GF_ASSERT(0);
		}
#endif		
		if ( (idx == ANIME_CONT_MAX)&&
			 (inAnimeContMng->AnimeCont[i].EntryID)==NO_ENTRY  ){
			idx = i;
		}
	}

	if (idx != ANIME_CONT_MAX){
		inAnimeContMng->AnimeCont[idx].EntryID = inEntryID;
	}else{
		GF_ASSERT_MSG(0,"idx == ANIME_CONT_MAX");
		return NULL;
	}
	
	return &(inAnimeContMng->AnimeCont[idx]);
}

//==============================================================================
/**
 *	Gg[NA
 * 
 * @param	outData	AjǗf[^|C^
 *
 * @return	none
 */
//==============================================================================
static void EntryClearAnimeCont(ANIME_CONT_PTR outData)
{
	u8 i;
	outData->EntryID = NO_ENTRY;
	outData->ObjID = 0;
	outData->BindAnime = NULL;
	for(i=0;i<CONT_RENDER_OBJ_MAX;i++){
		outData->RenderObj[i] = NULL;
	}
}

//==============================================================================
/**
 *	o^IDŃAjǗf[^擾
 * 
 * @param	inAnimeContMng	Aj[VǗ}l[Wւ̃|C^
 * @param	inEntryID		Gg[hc
 *
 * @return	AjǗf[^|C^
 */
//==============================================================================
static ANIME_CONT_PTR GetAnmContPtrFromEntryID(	ANIME_CONT_MNG_PTR inAnimeContMng,
												const int inEntryID)
{
	int i;
	ANIME_CONT_PTR data;
	data = NULL;
	//\񂳂Ăꏊ
	for(i=0;i<ANIME_CONT_MAX;i++){
		if (inAnimeContMng->AnimeCont[i].EntryID == inEntryID){
			data = &(inAnimeContMng->AnimeCont[i]);
			break;
		}
	}
#ifdef PM_DEBUG
	if (i==ANIME_CONT_MAX){
		OS_Printf("%d:w肳ꂽo^IDAj[V擾ł܂ł",inEntryID);
		GF_ASSERT(0);
	}
#endif
	return data;
}

//==============================================================================
/**
 *	o^IDŃAjǗf[^擾
 * 
 * @param	*pRenderObj		_[nai
 * @param	inNum			Aj
 * @param	outData			AjǗf[^|C^
 *
 * @return	none
 */
//==============================================================================
static void SetAnimeCont(	NNSG3dRenderObj *pRenderObj,
							const int inNum,
							ANIME_CONT_PTR	outData	)
{
	GF_ASSERT(inNum<=ONE_MODEL_ANM_NUM_MAX&&"1̃fĂAjI[o[Ă܂");
	if (pRenderObj != NULL){
		outData->RenderObj[0] = pRenderObj;	//_[nai̎w肪ꍇ0Ԗڂɓo^
	}
	outData->AnimeList.AnimeNum = inNum;
}

//==============================================================================
/**
 *	Ajf[^Zbg
 * 
 * @param	inAnimeContPtr	AjǗf[^|C^
 * @param	inIndex			CfbNX
 * @param	inAnimePtr		Ajf[^ւ̃|C^
 *
 * @return	none
 */
//==============================================================================
static void SetAnimePtr(ANIME_CONT_PTR inAnimeContPtr,
						const int inIndex,
						FLD_3D_ANM_DAT_PTR inAnimePtr)
{
	GF_ASSERT(inIndex<inAnimeContPtr->AnimeList.AnimeNum&&"CfbNXI[o[Ă܂");
	inAnimeContPtr->AnimeList.Data[inIndex] = inAnimePtr;
}

//==============================================================================
/**
 *	Ajf[^擾
 * 
 * @param	inAnimeContPtr	AjǗf[^|C^
 * @param	inIndex			CfbNX
 *
 * @return	FLD_3D_ANM_DAT_PTR	Ajf[^|C^
 */
//==============================================================================
static FLD_3D_ANM_DAT_PTR GetAnimePtr(ANIME_CONT_PTR inAnimeContPtr, const int inIndex)
{
	GF_ASSERT(inIndex<inAnimeContPtr->AnimeList.AnimeNum&&"CfbNXI[o[Ă܂");
	return inAnimeContPtr->AnimeList.Data[inIndex];
}

//==============================================================================
/**
 *	AjoCh
 * 
 * @param	ioAnimeContPtr	AjǗf[^|C^
 * @param	inIndex			CfbNX
 *
 */
//==============================================================================
static FLD_3D_ANM_DAT_PTR BindAnimation(ANIME_CONT_PTR ioAnimeContPtr, const int inIndex)
{
	u8 i;
	FLD_3D_ANM_DAT_PTR anime;
	NNSG3dAnmObj *anm_obj;
	NNSG3dAnmObj *bind_anmobj;
	GF_ASSERT(inIndex<ioAnimeContPtr->AnimeList.AnimeNum&&"CfbNXI[o[Ă܂");
	anime = ioAnimeContPtr->AnimeList.Data[inIndex];
	anm_obj = GetAnmObj(anime);

	bind_anmobj = GetAnmObj(ioAnimeContPtr->BindAnime);
	for(i=0;i<CONT_RENDER_OBJ_MAX;i++){
		if (ioAnimeContPtr->RenderObj[i] != NULL){
			//łɃAjĂꍇ̓[u
			RemoveAnime(ioAnimeContPtr->RenderObj[i], bind_anmobj);
			// RenderObj  AnmObj ǉBWCgAj[VȊOl
			NNS_G3dRenderObjAddAnmObj(ioAnimeContPtr->RenderObj[i], anm_obj );
		}
	}
	ioAnimeContPtr->BindAnime = anime;
	return anime;
}

//==============================================================================
/**
 *	Aj[Vǉ@풓AĵݑΉ
 * 
 * @param		inObjID				OBJID
 * @param		inObjectModel		\[Xf
 * @param		inTex				eNX`
 * @param		inAnimeNum			Aj
 * @param		inLoopCount			[v
 * @param		inReverse			tĐtO
 * @param		field_3d_anime_ptr	3DAj[V}l[Wւ̃|C^
 * @param		outData				Ajf[^
 *
 * @retrun		none
 *
 */
//==============================================================================
static void AddField3DAnime(const int inObjID,
							NNSG3dResMdl 	*inObjectModel,
							NNSG3dResTex *inTex,
							const int inAnimeNum,
							const int inLoopCount,
							const BOOL	inReverse,
							FLD_3D_ANM_MNG_PTR field_3d_anime_ptr,
							ANIME_CONT_PTR outData)
{
	FLD_3D_ANM_DAT_PTR	anm_data;
	int i;
	for(i=0;i<inAnimeNum;i++){
		anm_data = F3DA_AddField3DAnime(inObjID,
										i,
										inLoopCount,
										0,		//O䂵Ȃ
										inReverse,	//
										TRUE,	//n߂͒~
										TRUE,	//t
										inObjectModel,
										inTex,
										field_3d_anime_ptr);
		GF_ASSERT(anm_data!=NULL&&"o^s");

		//AjǗXgɓo^Aj|C^擾Ă
		SetAnimePtr( outData, i, anm_data);	//Ajo^
	}
}

//==============================================================================
/**
 *	Aj[Ṽ[X
 * 
 * @param		field_3d_anime_ptr	3DAj[V}l[Wւ̃|C^
 * @param		outData				Ajf[^
 *
 * @retrun		none
 *
 */
//==============================================================================
static void RereaseField3DAnime(FLD_3D_ANM_MNG_PTR field_3d_anime_ptr,
								ANIME_CONT_PTR outData)
{
	int i;
	NNSG3dAnmObj *anmobj;
	anmobj = GetAnmObj(outData->BindAnime);
	//łɃAjĂꍇ̓[u
	for(i=0;i<CONT_RENDER_OBJ_MAX;i++){
		if (outData->RenderObj[i] != NULL){
			RemoveAnime(outData->RenderObj[i], anmobj);
		}
	}
	for (i=0;i<outData->AnimeList.AnimeNum;i++){
		{		
			FLD_3D_ANM_DAT_PTR anime;
			anime = outData->AnimeList.Data[i];	
			F3DA_RereaseFld3DAnime(anime, field_3d_anime_ptr);
		}
		outData->AnimeList.Data[i] = NULL;
	}
}

//==============================================================================
/**
 *	3DAj}l[W̃AP[V
 * 
 *
 * @retrun		ANIME_CONT_MNG_PTR		Aj[VǗ}l[Wւ̃|C^
 *
 */
//==============================================================================
ANIME_CONT_MNG_PTR F3DASub_InitField3DAnimeCont(void)
{
	int i;
	int size;
	ANIME_CONT_MNG_PTR anime_cont_mng;

	size = sizeof(ANIME_CONT_MNG);

	anime_cont_mng = sys_AllocMemory( HEAPID_FIELD, size );

	MI_CpuClearFast(anime_cont_mng,size);

	return anime_cont_mng;
}

//==============================================================================
/**
 *	3DAj}l[W̉
 * 
 *
 * @param		outAnimeContMng		Aj[VǗ}l[Wւ̃|C^
 *
 * @return		none
 *
 */
//==============================================================================
void F3DASub_FreeAnimeContManager(ANIME_CONT_MNG_PTR *outAnimeContMng)
{
	if ((*outAnimeContMng)==NULL) return;

#ifdef	PM_DEBUG
	{
		int i;
		for(i=0;i<ANIME_CONT_MAX;i++){
			if ((*outAnimeContMng)->AnimeCont[i].EntryID != NO_ENTRY ){
				OS_Printf("EntryID:%d o^̉Ȃ܂܉悤ƂĂ܂\n",
						(*outAnimeContMng)->AnimeCont[i].EntryID);
				GF_ASSERT(0);
			}
		}
	}
#endif
	
	sys_FreeMemoryEz( (*outAnimeContMng) );
	(*outAnimeContMng) = NULL;
}

//==============================================================================
/**
 *	Aj[VZbgAbv
 * 
 *
 * @param		field_3d_anime_ptr		3DAj[V}l[Wւ̃|C^
 * @param		inAnimeContMng			Aj[VǗ}l[Wւ̃|C^
 * @param		inEntryID				Gg[hc
 * @param		inObjID					naihc
 * @param		inRenderObj				_[nai
 * @param		inObjectModel			naif
 * @param		inTex					eNX`
 * @param		inAnimeNum				Aj
 * @param		inLoop					[v
 * @param		inReverse				tĐtO
 *
 * @return		none
 *
 */
//==============================================================================
void F3DASub_SetUpAnimation(FLD_3D_ANM_MNG_PTR field_3d_anime_ptr,
							const ANIME_CONT_MNG_PTR inAnimeContMng,
							const int inEntryID,
							const int inObjID,
							NNSG3dRenderObj *inRenderObj,
							NNSG3dResMdl 	*inObjectModel,
							NNSG3dResTex *inTex,
							const int inAnimeNum,
							const u8 inLoop,
							const BOOL inReverse)
{
	int i;
	u8 loop;
	ANIME_CONT_PTR		cont_data = NULL;
	//AjGg[
	cont_data = EntryAnimeCont(inAnimeContMng, inEntryID);
	if (!cont_data){
		GF_ASSERT_MSG(0,"FAIL_ANIME_ENTRY");
		return ;
	}

	//gpAjǗpAj|C^Xgm
	SetAnimeCont(inRenderObj, inAnimeNum, cont_data);
	loop = inLoop;
	GF_ASSERT(loop != 0);
	if (loop == 0){
		loop = 1;	//0Zbgh~
	}
	
	//Aj[V̒ǉ
	AddField3DAnime(inObjID, inObjectModel, inTex, inAnimeNum, loop, inReverse,
					field_3d_anime_ptr, cont_data);
	//OBJIDL(قڃTEhp)
	cont_data->ObjID = inObjID;
}

//==============================================================================
/**
 *	_[naĩGg[
 *	Aj𕡐̂naigꍇɎgp
 *	F3DASub_SetUpAnimationŃ_[naiw肵ȂƂ
 *	łgăGg
 * 
 * @param		inAnimeContMng			Aj[VǗ}l[Wւ̃|C^
 * @param		inEntryID				Gg[hc
 * @param		inEntryIndex			GgCfbNX
 * @param		inRenderObj				_[nai
 *
 * @return		none
 *
 */
//==============================================================================
void F3DASub_EntryRenderObj(const ANIME_CONT_MNG_PTR inAnimeContMng,
							const int inEntryID,
							const u8 inEntryIndex,
							NNSG3dRenderObj *inRenderObj)
{
	ANIME_CONT_PTR cont_ptr;
	GF_ASSERT(inEntryIndex<CONT_RENDER_OBJ_MAX);
	cont_ptr = GetAnmContPtrFromEntryID( inAnimeContMng, inEntryID);
	GF_ASSERT_MSG((cont_ptr->RenderObj[inEntryIndex]==NULL),"_[OBJłɂ܂");
	cont_ptr->RenderObj[inEntryIndex] = inRenderObj;
}

//==============================================================================
/**
 *	AjJn
 * 
 * @param		inAnimeContMng			Aj[VǗ}l[Wւ̃|C^
 * @param		inEntryID				Gg[hc
 * @param		inAnimeNo				Ajio[
 *
 * @return		none
 *
 */
//==============================================================================
void F3DASub_StartAnimation(const ANIME_CONT_MNG_PTR inAnimeContMng,
							const int inEntryID,
							const int inAnimeNo)
{
	ANIME_CONT_PTR cont_ptr;
	FLD_3D_ANM_DAT_PTR anime;
	GF_ASSERT_MSG((inEntryID!=NO_ENTRY),"ID=0͎wł܂");
	cont_ptr = GetAnmContPtrFromEntryID(inAnimeContMng, inEntryID);

	anime = BindAnimation(cont_ptr, inAnimeNo);	//AjoCh
	//Aj[VX^[g
	F3DA_SetStopFlg(anime, FALSE);
}

//==============================================================================
/**
 *	AjJnij
 * 
 * @param		inAnimeContMng			Aj[VǗ}l[Wւ̃|C^
 * @param		inEntryID				Gg[hc
 * @param		inAnimeNo				Ajio[
 * @param		inSound					rdԍ
 *
 * @return		none
 *
 */
//==============================================================================
void F3DASub_StartAnimeSnd(const ANIME_CONT_MNG_PTR inAnimeContMng,
							const int inEntryID,
							const int inAnimeNo,
							const int inSound)
{
	ANIME_CONT_PTR cont_ptr;
	FLD_3D_ANM_DAT_PTR anime;
	GF_ASSERT(inEntryID!=NO_ENTRY&&"ID=0͎wł܂");
	cont_ptr = GetAnmContPtrFromEntryID(inAnimeContMng, inEntryID);

	anime = BindAnimation(cont_ptr, inAnimeNo);	//AjoCh

	//hA鉹ȊOSEĐ
	if( inSound != SE_JIDO_DOOR_CLOSE ){
		Snd_SePlay(inSound);
	}

	//Aj[VX^[g
	F3DA_SetStopFlg(anime, FALSE);
}

//==============================================================================
/**
 *	AjoCh
 * 
 * @param		inAnimeContMng			Aj[VǗ}l[Wւ̃|C^
 * @param		inEntryID				Gg[hc
 * @param		inAnimeNo				Ajio[
 *
 * @return		none
 *
 */
//==============================================================================
void F3DASub_BindAnimation( const ANIME_CONT_MNG_PTR inAnimeContMng,
							const int inEntryID,
							const int inAnimeNo)
{
	ANIME_CONT_PTR cont_ptr;
	FLD_3D_ANM_DAT_PTR anime;
	GF_ASSERT(inEntryID!=NO_ENTRY&&"ID=0͎wł܂");
	cont_ptr = GetAnmContPtrFromEntryID(inAnimeContMng, inEntryID);

	anime = BindAnimation(cont_ptr, inAnimeNo);	//AjoCh
}

//==============================================================================
/**
 *	AjXgbvtOIIt
 * 
 * @param		inAnimeContMng			Aj[VǗ}l[Wւ̃|C^
 * @param		inEntryID				Gg[hc
 * @param		inAnimeNo				Ajio[
 * @param		inFlg					~tOXCb`
 *
 * @return		none
 *
 */
//==============================================================================
void F3DASub_SetStopFlg( const ANIME_CONT_MNG_PTR inAnimeContMng,
							const int inEntryID,
							const int inAnimeNo,
							const BOOL inFlg)
{
	ANIME_CONT_PTR cont_ptr;
	FLD_3D_ANM_DAT_PTR anime;
	GF_ASSERT(inEntryID!=NO_ENTRY&&"ID=0͎wł܂");
	cont_ptr = GetAnmContPtrFromEntryID(inAnimeContMng, inEntryID);

	anime = BindAnimation(cont_ptr, inAnimeNo);	//AjoCh
	//Aj[VX^[g
	F3DA_SetStopFlg(anime, inFlg);
}

//==============================================================================
/**
 *	
 * 
 * @param		field_3d_anime_ptr		3DAj[V}l[Wւ̃|C^
 * @param		inAnimeContMng			Aj[VǗ}l[Wւ̃|C^
 * @param		inEntryID				Gg[hc
 *
 * @return		none
 *
 */
//==============================================================================
void F3DASub_RereaseAnimation(	FLD_3D_ANM_MNG_PTR field_3d_anime_ptr,
								ANIME_CONT_MNG_PTR inAnimeContMng,
								const int inEntryID)
{
	ANIME_CONT_PTR data;
	GF_ASSERT(inEntryID!=NO_ENTRY&&"ID=0͎wł܂");
	data = GetAnmContPtrFromEntryID(inAnimeContMng, inEntryID);
	//Aj[V̉
	RereaseField3DAnime(field_3d_anime_ptr, data);
	//Gg[NA
	EntryClearAnimeCont(data);
}

//==============================================================================
/**
 *	Aj擾
 * 
 * @param		inAnimeContMng			Aj[VǗ}l[Wւ̃|C^
 * @param		inEntryID				Gg[hc
 * @param		inAnimeNo				Ajio[
 *
 * @return		FLD_3D_ANM_DAT_PTR		Aj|C^
 *
 */
//==============================================================================
FLD_3D_ANM_DAT_PTR F3DASub_GetFld3DAnmPtr(	const ANIME_CONT_MNG_PTR inAnimeContMng,
											const int inEntryID,
											const int inAnimeNo	)
{
	ANIME_CONT_PTR cont_data;
	FLD_3D_ANM_DAT_PTR anime;
	GF_ASSERT(inEntryID!=NO_ENTRY&&"ID=0͎wł܂");
	cont_data =  GetAnmContPtrFromEntryID(inAnimeContMng, inEntryID);
	anime = GetAnimePtr(cont_data, inAnimeNo);
	return anime;
}

//==============================================================================
/**
 *	݃oChĂAj擾
 * 
 * @param		inAnimeContMng			Aj[VǗ}l[Wւ̃|C^
 * @param		inEntryID				Gg[hc
 *
 * @return		FLD_3D_ANM_DAT_PTR		Aj|C^
 *
 */
//==============================================================================
FLD_3D_ANM_DAT_PTR F3DASub_GetFld3DBindAnmPtr(	const ANIME_CONT_MNG_PTR inAnimeContMng,
												const int inEntryID	)
{
	ANIME_CONT_PTR cont_data;
	FLD_3D_ANM_DAT_PTR anime;
	GF_ASSERT(inEntryID!=NO_ENTRY&&"ID=0͎wł܂");
	cont_data =  GetAnmContPtrFromEntryID(inAnimeContMng, inEntryID);
	anime = cont_data->BindAnime;
	return anime;
}

//==============================================================================
/**
 *	Aj[VI҂
 * 
 * @param		inAnimeContMng			Aj[VǗ}l[Wւ̃|C^
 * @param		inEntryID				Gg[hc
 *
 * @return		BOOL		TRUE:AjI		FALSE:Ajp
 *
 */
//==============================================================================
const BOOL F3DASub_WaitAnimation(	const ANIME_CONT_MNG_PTR inAnimeContMng,
									const int inEntryID	)
{
	FLD_3D_ANM_DAT_PTR data;
	data = F3DASub_GetFld3DBindAnmPtr(inAnimeContMng, inEntryID);

	GF_ASSERT_MSG((data!=NULL),"AjoChĂȂ");
	
	if ( F3DA_IsAnimeEnd(data) ){
		return TRUE;
	}else{
		return FALSE;
	}
}

//==============================================================================
/**
 *	AjɃoChĂnaiOBJID擾
 * 
 * @param		inAnimeContMng			Aj[VǗ}l[Wւ̃|C^
 * @param		inEntryID				Gg[hc
 *
 * @return		BOOL		TRUE:AjI		FALSE:Ajp
 *
 */
//==============================================================================
const int F3DASub_GetObjIDFromEntryID(	const ANIME_CONT_MNG_PTR inAnimeContMng,
										const int inEntryID)
{
	ANIME_CONT_PTR cont_ptr;
	cont_ptr = GetAnmContPtrFromEntryID(inAnimeContMng, inEntryID);
	return cont_ptr->ObjID;
}
