//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		field_accessory_shop.c
 *	@brief		ANZT[
 *	@author		tomoya takahashi
 *	@data		2006.06.06
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "common.h"
#include "talk_msg.h"
#include "include/savedata/config.h"
#include "include/savedata/imageclip_data.h"
#include "include/itemtool/myitem.h"
#include "include/itemtool/nuts.h"

#include "include/system/wordset.h"
#include "include/system/msgdata.h"

#include "include/msgdata/msg.naix"
#include "include/msgdata/msg_t03r0101.h"

#include "include/system/window.h"
#include "include/system/bmp_menu.h"
#include "include/system/fontproc.h"

#include "include/system/arc_util.h"

#include "fieldmap.h"

#include "include/system/bmp_list.h"
#include "include/application/imageClip/imc_drawdata_define.h"

#include "system/snd_play.h"
#include "system/snd_tool.h"

// Xg㉺ACRp
#include "shop_gra.naix"


//////// accessoryVbvf[^
#include "acce_shop.dat"


#define __FIELD_ACCESSORY_SHOP_H_GLOBAL
#include "field_accessory_shop.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	ZAN^[
//=====================================
#define ACCE_SHOP_CLACT_WORK_NUM	( 2 )



//-------------------------------------
//	풓LN^@pbgʒu
//=====================================
#define ACCE_SHOP_TALK_CHAROFS		( 1 )
#define ACCE_SHOP_TALK_PLTT			( 10 )
#define ACCE_SHOP_SYSTEM_CHAROFS	( 1+TALK_WIN_CGX_SIZ )
#define ACCE_SHOP_SYSTEM_PLTT		( 11 )
#define ACCE_SHOP_TALKFONT_PLTT			( 12 )
#define ACCE_SHOP_SYSTEMFONT_PLTT		( 13 )

#define ACCE_SHOP_FONTBMP_TALK_COLOR		( GF_PRINTCOLOR_MAKE(1,2,15) )
#define ACCE_SHOP_FONTBMP_SYS_COLOR			( GF_PRINTCOLOR_MAKE(1,2,15) )


//-------------------------------------
//	CbZ[W\̒萔
//=====================================
#define ACCE_SHOP_MAIN_MSGWIN_X		( 2 )
#define ACCE_SHOP_MAIN_MSGWIN_Y		( 19 )
#define ACCE_SHOP_MAIN_MSGWIN_SX	( 27 )
#define ACCE_SHOP_MAIN_MSGWIN_SY	( 4 )
#define ACCE_SHOP_MAIN_MSGWIN_CHAR	( ACCE_SHOP_SYSTEM_CHAROFS+MENU_WIN_CGX_SIZ )
#define ACCE_SHOP_MAIN_MSGWIN_PLTT	( ACCE_SHOP_TALKFONT_PLTT )

//-------------------------------------
//	f[^ʍ\̒萔
//=====================================
#define ACCE_SHOP_DATA_WINWIN_X		( 1 )
#define ACCE_SHOP_DATA_WINWIN_Y		( 11 )
#define ACCE_SHOP_DATA_WINWIN_SX	( 14 )
#define ACCE_SHOP_DATA_WINWIN_SY	( 6 )
#define ACCE_SHOP_DATA_WINWIN_CHAR	( ACCE_SHOP_MAIN_MSGWIN_CHAR + (ACCE_SHOP_MAIN_MSGWIN_SX*ACCE_SHOP_MAIN_MSGWIN_SY) )
#define ACCE_SHOP_DATA_WINWIN_PLTT	( ACCE_SHOP_SYSTEMFONT_PLTT )
enum{
	ACCE_SHOP_DATA_WIN_NUTS_NAME,
	ACCE_SHOP_DATA_WIN_NUTS_NEED,
	ACCE_SHOP_DATA_WIN_NUTS_HAVE,
	ACCE_SHOP_DATA_WIN_NUM,
};
#define ACCE_SHOP_DATA_WINWIN_DRAW_YOFS	( 16 )


//-------------------------------------
//	accessoryXg\̒萔
//=====================================
#define ACCE_SHOP_LIST_WINWIN_X		( 17 )
#define ACCE_SHOP_LIST_WINWIN_Y		( 1 )
#define ACCE_SHOP_LIST_WINWIN_SX	( 14 )
#define ACCE_SHOP_LIST_WINWIN_SY	( 16 )
#define ACCE_SHOP_LIST_WINWIN_CHAR	( ACCE_SHOP_DATA_WINWIN_CHAR + (ACCE_SHOP_DATA_WINWIN_SX*ACCE_SHOP_DATA_WINWIN_SY) )
#define ACCE_SHOP_LIST_WINWIN_PLTT	( ACCE_SHOP_SYSTEMFONT_PLTT )

#define ACCE_SHOP_LIST_WIN_DRAWLINE		( 7 )	// \C
#define ACCE_SHOP_LIST_WIN_DATA_X		( 16 )	// ڕ\ʒu
#define ACCE_SHOP_LIST_WIN_CURSOR_X		( 0 )	// J[\\ʒu
#define ACCE_SHOP_LIST_WIN_DRAW_Y		( 8 )	// \JnYW
#define ACCE_SHOP_LIST_WIN_FONT_COL_F	( 1 )	// F
#define ACCE_SHOP_LIST_WIN_FONT_COL_B	( 15 )	// wiF
#define ACCE_SHOP_LIST_WIN_FONT_COL_S	( 2 )	// eF
#define ACCE_SHOP_LIST_WIN_MSG_SPC		( 0 )	// Ԋu
#define ACCE_SHOP_LIST_WIN_LINE_SPC		( 0 )	// CԊu
#define ACCE_SHOP_LIST_WIN_PAGE_SKIP	( FALSE )	// XLbv
#define ACCE_SHOP_LIST_WIN_FONT			( FONT_SYSTEM )	// ^Cv
#define ACCE_SHOP_LIST_WIN_DISP			( 0 )

#define ACCE_SHOP_LIST_WIN_CLACT_RESNUM	( 4 )	// L@pbg@Z@ZAj
#define ACCE_SHOP_LIST_WIN_CLACT_RESMAN_WORKNUM	( 1 )	// \[X}l[W[N
#define ACCE_SHOP_LIST_WIN_CLACT_RESCONT_ID	( 5000 )
#define ACCE_SHOP_LIST_WIN_CLACT_OBJNUM	( 2 )

#define ACCE_SHOP_LIST_WIN_CLACT_X		( 192 )
#define ACCE_SHOP_LIST_WIN_CLACT_Y_0	( 8 )
#define ACCE_SHOP_LIST_WIN_CLACT_Y_1	( 136 )


//-------------------------------------
//	YESNOEBhE
//=====================================
#define ACCE_SHOP_YESNO_WIN_X	( 24 )		// ʒu
#define ACCE_SHOP_YESNO_WIN_Y	( 13 )		// ʒu
#define ACCE_SHOP_YESNO_WIN_SX	( 7 )		// TCY
#define ACCE_SHOP_YESNO_WIN_SY	( 4 )		// yTCY
#define ACCE_SHOP_YESNO_WIN_CHAR	( ACCE_SHOP_LIST_WINWIN_CHAR + (ACCE_SHOP_LIST_WINWIN_SX*ACCE_SHOP_LIST_WINWIN_SY) )
#define ACCE_SHOP_YESNO_WIN_PLTT	( ACCE_SHOP_SYSTEMFONT_PLTT )




//-------------------------------------
//	S̃V[PX
//=====================================
enum{
	ACCE_SHOP_SEQ_STARTMSG,			// ɂ́I
	ACCE_SHOP_SEQ_FULLHAVE_CHECK,	// SẴANZT[Ă邩`FbN
	ACCE_SHOP_SEQ_LIST_START,		// Xgʂ̊Jn
	ACCE_SHOP_SEQ_LIST_RESTART,		// Xgʂ̍ĊJn
	ACCE_SHOP_SEQ_LIST_MAIN,		// XgC

	ACCE_SHOP_SEQ_YESNO_START,		// nCCCG
	ACCE_SHOP_SEQ_YESNO_MAIN,		// nCCCG

	ACCE_SHOP_SEQ_GET_ACCE,			// ANZT
	ACCE_SHOP_SEQ_GET_ACCE_FULL,	// ANZTS܂
	ACCE_SHOP_SEQ_GET_ACCE_FULL2,	// ANZTS܂

	ACCE_SHOP_SEQ_MSG_WAIT,	// bZ[W҂
	ACCE_SHOP_SEQ_KEY_WAIT,	// L[҂
	ACCE_SHOP_SEQ_END,		// I
};



//-------------------------------------
//	`
//=====================================
#define ACCE_SHOP_SND_KEY_ON	( SEQ_SE_DP_SELECT )		// L[҂ŉꂽƂ̉
#define ACCE_SHOP_SND_LIST_MOVE	( SEQ_SE_DP_SELECT )		// Xg
#define ACCE_SHOP_SND_LIST_SELECT	( SEQ_SE_DP_SELECT )	// Xg
#define ACCE_SHOP_SND_LIST_CANCEL	( SEQ_SE_DP_SELECT )	// CANCEL


// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/23
// bZ[Wpobt@̃TCYg
#define ACCE_SHOP_BUFFER_SIZE	(200)
// ----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------




//-------------------------------------
//	CbZ[W\
//=====================================
typedef struct {
	u32 init;
	GF_BGL_BMPWIN* p_bmp;
	u32 msg_speed;
	u32 msg_idx;
	STRBUF* p_str;	// \̕obt@
} ACCE_SHOP_MAIN_MSG;

//-------------------------------------
//	f[^EBhE
//=====================================
typedef struct {
	u32 init;
	GF_BGL_BMPWIN* p_bmp;
	WORDSET* p_wordset;
	STRBUF* p_drawstr;
	STRBUF* p_wordstr[ACCE_SHOP_DATA_WIN_NUM];
} ACCE_SHOP_DATA_WIN;

#define ACCE_SHOP_DATA_LIST_NUM	( ACCE_SHOP_DATA_NUM + 1 )
//-------------------------------------
//	XgEBhE
//=====================================
typedef struct {
	u32 init;
	GF_BGL_BMPWIN* p_bmp;
	BMPLIST_WORK* p_bmplist;
	BMPLIST_DATA list[ ACCE_SHOP_DATA_LIST_NUM ];
	STRBUF* p_list_str[ ACCE_SHOP_DATA_LIST_NUM ];
	s32 data_num;
	WORDSET* p_wordset;
	STRBUF* p_drawstr;
	u16 now_pos;
	u16 now_pos_param;
	void* p_work;		// XgƂɌĂԃR[obN[N
	void (*callback)( void* p_work, u32 listnum );	// R[obN֐


	// ZAN^[
	CLACT_U_RES_MANAGER_PTR	resMan[ACCE_SHOP_LIST_WIN_CLACT_RESNUM];	// \[X}l[W
	CLACT_U_RES_OBJ_PTR		resObj[ACCE_SHOP_LIST_WIN_CLACT_RESNUM];	// ꂼ̃\[XIuWF
	CLACT_WORK_PTR clact[ ACCE_SHOP_LIST_WIN_CLACT_OBJNUM ];
} ACCE_SHOP_LIST_WIN;
typedef void (*pAcceListMoveFunc)( void* p_work, u32 listnum );

//-------------------------------------
//	YES NO EBhEIuWF
//=====================================
typedef struct {
	u32 init;
	BMPMENU_WORK* p_yesno;	// YESNOj[
	u32 heapID;				// q[v
} ACCE_SHOP_YESNO_MENU;


//-------------------------------------
//	Xg쎞
//	f[^EBhEύX	[N
//=====================================
typedef struct {
	u32 heapID;
	GF_BGL_INI* p_bgl;
	ACCE_SHOP_DATA_WIN* p_data_wnd;	// f[^bZ[WEBhE
	const ACCE_SHOP_DATA* cp_data;	// f[^
	MYITEM* p_myitem;		// ACe
} ACCE_SHOP_DATA_WIN_CHG;



//-------------------------------------
//	accessory
//=====================================
typedef struct _FIELD_ACCE_SHOP{
	u32 seq;
	u32 seq_sub;
	SAVEDATA* p_savedata;
	IMC_ITEM_SAVEDATA* p_item;
	MYITEM* p_myitem;
	GF_BGL_INI* p_bgl;
	u32 heapID;
	CLACT_SET_PTR			clactSet;	// ZAN^[Zbg
	CLACT_U_EASYRENDER_DATA	renddata;	// ȈՃ_[f[^

	// bZ[W}l[W
	MSGDATA_MANAGER* p_msgman;

	// RtBOf[^
	u32 win_type;
	u32 msg_speed;
	
	// e`ǗIuWF
	ACCE_SHOP_MAIN_MSG main_msgwnd;	// CbZ[WEBhE
	ACCE_SHOP_DATA_WIN data_msgwnd;	// f[^bZ[WEBhE
	ACCE_SHOP_LIST_WIN list_wnd;	// XgEBhE
	ACCE_SHOP_YESNO_MENU yes_no;	// ͂@@j[
	
	// \ύXIuWF
	ACCE_SHOP_DATA_WIN_CHG data_msgwnd_chg;	// f[^EBhEύX
} ;

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void AcceShop_BGL_Init( FIELD_ACCE_SHOP* p_acce_shop );
static void AcceShop_BGL_Delete( FIELD_ACCE_SHOP* p_acce_shop );
static void AcceShop_CLACT_Init( FIELD_ACCE_SHOP* p_acce_shop );
static void AcceShop_CLACT_Delete( FIELD_ACCE_SHOP* p_acce_shop );
static void AcceShop_ConfigGet( FIELD_ACCE_SHOP* p_acce_shop );


static void AcceShop_MainMsgInit( ACCE_SHOP_MAIN_MSG* p_win, GF_BGL_INI* p_bgl, u32 heapID, u32 msg_speed );
static void AcceShop_MainMsgDelete( ACCE_SHOP_MAIN_MSG* p_win );
static void AcceShop_MainMsgSet( ACCE_SHOP_MAIN_MSG* p_win, STRBUF* p_str, u32 heapID );
static void AcceShop_MainMsgSet_noWait( ACCE_SHOP_MAIN_MSG* p_win, STRBUF* p_str );
static BOOL AcceShop_MainMsgWait( ACCE_SHOP_MAIN_MSG* p_win );

static void AcceShop_MainMsgChangeStrSet( ACCE_SHOP_MAIN_MSG* p_win, MSGDATA_MANAGER* p_msgman, u32 heapID, const ACCE_SHOP_DATA* cp_data, u32 data_idx );
static void AcceShop_MainMsgChangeEndStrSet( ACCE_SHOP_MAIN_MSG* p_win, MSGDATA_MANAGER* p_msgman, u32 heapID, const ACCE_SHOP_DATA* cp_data, u32 data_idx );


static void AcceShop_DataMsgInit( ACCE_SHOP_DATA_WIN* p_win, GF_BGL_INI* p_bgl, MSGDATA_MANAGER* p_msgman, u32 heapID );
static void AcceShop_DataMsgDelete( ACCE_SHOP_DATA_WIN* p_win );
static void AcceShop_DataMsgSet( ACCE_SHOP_DATA_WIN* p_win, u32 nut, u32 nut_need_num, u32 nut_get_num );

static void AcceShop_ListWinInit( ACCE_SHOP_LIST_WIN* p_win, GF_BGL_INI* p_bgl, u32 heapID, const ACCE_SHOP_DATA* cp_data, u32 data_num, MSGDATA_MANAGER* p_msgman, void* p_work, pAcceListMoveFunc callback, CLACT_SET_PTR clact_set );
static void AcceShop_ListWinDelete( ACCE_SHOP_LIST_WIN* p_win );
static u32 AcceShop_ListWinMain( ACCE_SHOP_LIST_WIN* p_win );
static void AcceShop_ListWinReTrans( ACCE_SHOP_LIST_WIN* p_win );
static void AcceShop_ListWinDrawClean( ACCE_SHOP_LIST_WIN* p_win );
static void AcceShop_ListWinClactResLoad( CLACT_HEADER* p_head, ACCE_SHOP_LIST_WIN* p_win, u32 heapID );
static void AcceShop_ListWinClactResDelete( ACCE_SHOP_LIST_WIN* p_win );
static void AcceShop_ListWinClactDrawSet( ACCE_SHOP_LIST_WIN* p_win );


static void AcceShop_YesNoWinInit( ACCE_SHOP_YESNO_MENU* p_win, GF_BGL_INI* p_bgl, u32 heapID );
static void AcceShop_YesNoWinDelete( ACCE_SHOP_YESNO_MENU* p_win );
static u32 AcceShop_YesNoWinMain( ACCE_SHOP_YESNO_MENU* p_win );


// Xg̃R[obNŁAf[^EBhEύX
static void AcceShop_DataWinChgDataInit( ACCE_SHOP_DATA_WIN_CHG* p_obj, ACCE_SHOP_DATA_WIN* data_win, const ACCE_SHOP_DATA* cp_data, MYITEM* p_save, u32 heapID, GF_BGL_INI* p_bgl );
static void AcceShop_DataWinChgCallBack( void* p_work, u32 listnum );

static BOOL AcceShop_FullAcceCheck( const IMC_ITEM_SAVEDATA* cp_item, const ACCE_SHOP_DATA* cp_data, u32 data_num );
static BOOL AcceShop_NutsOkCheck( MYITEM* p_save, const ACCE_SHOP_DATA* cp_data, u32 data_idx, u32 heapID );
static BOOL AcceShop_AcceHaveOkCheck( const IMC_ITEM_SAVEDATA* cp_item, const ACCE_SHOP_DATA* cp_data, u32 data_idx );

// ACe
static void AcceShop_AcceChange( IMC_ITEM_SAVEDATA* p_acceitem, MYITEM* p_myitem, const ACCE_SHOP_DATA* cp_data, u32 data_idx, u32 heapID );




//----------------------------------------------------------------------------
/**
 *	@brief	ANZTVbv쐬
 *
 *	@param	heapID		q[vID
 *	@param	p_save		Z[uf[^
 *	@param	p_bgl		BGL
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
FIELD_ACCE_SHOP* FIELD_AcceShop_Alloc( u32 heapID, SAVEDATA* p_save, GF_BGL_INI* p_bgl )
{
	FIELD_ACCE_SHOP* p_acce_shop = sys_AllocMemory( heapID, sizeof(FIELD_ACCE_SHOP) );
	memset( p_acce_shop, 0, sizeof(FIELD_ACCE_SHOP) );

	p_acce_shop->heapID = heapID;
	p_acce_shop->p_bgl = p_bgl;
	p_acce_shop->p_savedata = p_save;

	// C[WNbvANZTf[^
	p_acce_shop->p_item = ImcSaveData_GetItemSaveData( SaveData_GetImcSaveData( p_acce_shop->p_savedata ) );

	// myitem
	p_acce_shop->p_myitem = SaveData_GetMyItem( p_save );

	// bZ[W}l[W쐬
	p_acce_shop->p_msgman = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_t03r0101_dat, p_acce_shop->heapID );

	// RtBO
	AcceShop_ConfigGet( p_acce_shop );

	// BGL
	AcceShop_BGL_Init( p_acce_shop );

	// ZAN^[
	AcceShop_CLACT_Init( p_acce_shop );

	return p_acce_shop;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTVbvj
 *
 *	@param	p_acce_shop		[N
 */
//-----------------------------------------------------------------------------
void FIELD_AcceShop_Free( FIELD_ACCE_SHOP* p_acce_shop )
{
	// bZ[W}l[Wj
	MSGMAN_Delete( p_acce_shop->p_msgman );
	
	// BGLj
	AcceShop_BGL_Delete( p_acce_shop );

	// ZAN^-
	AcceShop_CLACT_Delete( p_acce_shop );

	memset( p_acce_shop, 0, sizeof(FIELD_ACCE_SHOP) );
	sys_FreeMemoryEz( p_acce_shop );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTVbv@C
 *
 *	@param	p_acce_shop		[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL FIELD_AcceShop_Main( FIELD_ACCE_SHOP* p_acce_shop )
{
	STRBUF* p_str;
	BOOL result;
	
	switch( p_acce_shop->seq ){
	case ACCE_SHOP_SEQ_STARTMSG:			// ɂ́I
		AcceShop_MainMsgInit( &p_acce_shop->main_msgwnd, 
				p_acce_shop->p_bgl, p_acce_shop->heapID, p_acce_shop->msg_speed );

		p_str = MSGMAN_AllocString( p_acce_shop->p_msgman, mes_accessory_01_01 );
		AcceShop_MainMsgSet( &p_acce_shop->main_msgwnd, p_str, p_acce_shop->heapID );
		STRBUF_Delete( p_str );
		p_acce_shop->seq = ACCE_SHOP_SEQ_KEY_WAIT;
		p_acce_shop->seq_sub = ACCE_SHOP_SEQ_FULLHAVE_CHECK;
		break;

	case ACCE_SHOP_SEQ_FULLHAVE_CHECK:	// SẴANZT[Ă邩`FbN
		// ANZTtɎĂ邩`FbN
		if( AcceShop_FullAcceCheck( p_acce_shop->p_item, AcceShopData, ACCE_SHOP_DATA_NUM ) ){

			// tɎĂ
			p_str = MSGMAN_AllocString( p_acce_shop->p_msgman, mes_accessory_01_02 );
			AcceShop_MainMsgSet( &p_acce_shop->main_msgwnd, p_str, p_acce_shop->heapID );
			STRBUF_Delete( p_str );
			p_acce_shop->seq = ACCE_SHOP_SEQ_KEY_WAIT;	// I
			p_acce_shop->seq_sub = ACCE_SHOP_SEQ_END;
		}else{
			// tɎĂȂ
			p_acce_shop->seq = ACCE_SHOP_SEQ_LIST_START;
		}
		break;
		
	case ACCE_SHOP_SEQ_LIST_START:		// Xgʂ̊Jn
		AcceShop_DataMsgInit( &p_acce_shop->data_msgwnd, 
				p_acce_shop->p_bgl, p_acce_shop->p_msgman, 
				p_acce_shop->heapID );
		AcceShop_DataWinChgDataInit( &p_acce_shop->data_msgwnd_chg,
				&p_acce_shop->data_msgwnd,
				AcceShopData, p_acce_shop->p_myitem, 
				p_acce_shop->heapID, p_acce_shop->p_bgl );
		AcceShop_ListWinInit( &p_acce_shop->list_wnd, 
				p_acce_shop->p_bgl, p_acce_shop->heapID,
				AcceShopData, ACCE_SHOP_DATA_NUM, p_acce_shop->p_msgman,
				&p_acce_shop->data_msgwnd_chg, AcceShop_DataWinChgCallBack, p_acce_shop->clactSet );
		// 
	case ACCE_SHOP_SEQ_LIST_RESTART:		// Xgʂ̍ĊJn
		AcceShop_ListWinReTrans( &p_acce_shop->list_wnd );

		// ǂ̃ANZTقH
		p_str = MSGMAN_AllocString( p_acce_shop->p_msgman, mes_accessory_01_03 );
		AcceShop_MainMsgSet( &p_acce_shop->main_msgwnd, p_str, p_acce_shop->heapID );
		STRBUF_Delete( p_str );
		p_acce_shop->seq = ACCE_SHOP_SEQ_MSG_WAIT;
		p_acce_shop->seq_sub = ACCE_SHOP_SEQ_LIST_MAIN;
		break;
		
	case ACCE_SHOP_SEQ_LIST_MAIN:		// XgC
		result = AcceShop_ListWinMain( &p_acce_shop->list_wnd );
		
		if( (result != BMPLIST_NULL) && (result != BMPLIST_CANCEL) ){

			// Xg\̈̃XN[
			GF_BGL_ScrFill( p_acce_shop->p_bgl, FLD_MBGFRM_FONT,
				0, 0, 0, 32, 18, GF_BGL_SCRWRT_PALIN );

			// OAMOFF
			AcceShop_ListWinDrawClean( &p_acce_shop->list_wnd );

			// CEBhEύX
			AcceShop_MainMsgChangeStrSet( &p_acce_shop->main_msgwnd, p_acce_shop->p_msgman, p_acce_shop->heapID, AcceShopData, p_acce_shop->list_wnd.now_pos );	

			p_acce_shop->seq = ACCE_SHOP_SEQ_MSG_WAIT;
			p_acce_shop->seq_sub = ACCE_SHOP_SEQ_YESNO_START;

			Snd_SePlay( ACCE_SHOP_SND_LIST_SELECT );
			
		}else if( result == BMPLIST_CANCEL ){
			// ܂ǂ
			p_str = MSGMAN_AllocString( p_acce_shop->p_msgman, mes_accessory_01_08 );
			AcceShop_MainMsgSet( &p_acce_shop->main_msgwnd, p_str, p_acce_shop->heapID );
			STRBUF_Delete( p_str );
			p_acce_shop->seq = ACCE_SHOP_SEQ_KEY_WAIT;	// I
			p_acce_shop->seq_sub = ACCE_SHOP_SEQ_END;
			
			Snd_SePlay( ACCE_SHOP_SND_LIST_CANCEL );
		}
		break;
		
	case ACCE_SHOP_SEQ_YESNO_START:		// nCCCG
		// ͂A@EBhE\
		AcceShop_YesNoWinInit( &p_acce_shop->yes_no, p_acce_shop->p_bgl, p_acce_shop->heapID );

		p_acce_shop->seq = ACCE_SHOP_SEQ_YESNO_MAIN;
		break;
		
	case ACCE_SHOP_SEQ_YESNO_MAIN:		// nCCCG
		result = AcceShop_YesNoWinMain( &p_acce_shop->yes_no );
		if( result == 0 ){
			// nCI
			// ؂̎Ă邩`FbN
			if( AcceShop_NutsOkCheck( p_acce_shop->p_myitem, AcceShopData, p_acce_shop->list_wnd.now_pos, p_acce_shop->heapID ) == FALSE ){
				
				// ؂̎ȂI
				p_str = MSGMAN_AllocString( p_acce_shop->p_msgman, mes_accessory_01_06 );
				AcceShop_MainMsgSet( &p_acce_shop->main_msgwnd, p_str, p_acce_shop->heapID );
				STRBUF_Delete( p_str );
				p_acce_shop->seq = ACCE_SHOP_SEQ_KEY_WAIT;	// Cւ
				p_acce_shop->seq_sub = ACCE_SHOP_SEQ_LIST_RESTART;
				AcceShop_YesNoWinDelete( &p_acce_shop->yes_no );
				break;
			}

			// ȏANZTo邩`FbN
			if( AcceShop_AcceHaveOkCheck( p_acce_shop->p_item, AcceShopData, p_acce_shop->list_wnd.now_pos ) == FALSE ){

				// ȏĂȂ
				p_str = MSGMAN_AllocString( p_acce_shop->p_msgman, mes_accessory_01_07 );
				AcceShop_MainMsgSet( &p_acce_shop->main_msgwnd, p_str, p_acce_shop->heapID );
				STRBUF_Delete( p_str );

				AcceShop_YesNoWinDelete( &p_acce_shop->yes_no );
				p_acce_shop->seq = ACCE_SHOP_SEQ_KEY_WAIT;	// C
				p_acce_shop->seq_sub = ACCE_SHOP_SEQ_LIST_RESTART;
				break;
			}

			// ǂ肪Ƃ
			p_str = MSGMAN_AllocString( p_acce_shop->p_msgman, mes_accessory_01_05 );
			AcceShop_MainMsgSet( &p_acce_shop->main_msgwnd, p_str, p_acce_shop->heapID );
			STRBUF_Delete( p_str );

			AcceShop_YesNoWinDelete( &p_acce_shop->yes_no );

			p_acce_shop->seq = ACCE_SHOP_SEQ_KEY_WAIT;	// ANZT
			p_acce_shop->seq_sub = ACCE_SHOP_SEQ_GET_ACCE;

		}else if( result == BMPMENU_CANCEL ){
			// CCGI
			AcceShop_YesNoWinDelete( &p_acce_shop->yes_no );
			p_acce_shop->seq = ACCE_SHOP_SEQ_LIST_RESTART;
		}
		break;
		
	case ACCE_SHOP_SEQ_GET_ACCE:			// ANZT
		// ANZTƃACeݒ
		AcceShop_AcceChange( p_acce_shop->p_item, p_acce_shop->p_myitem, AcceShopData, p_acce_shop->list_wnd.now_pos, p_acce_shop->heapID );

		// bZ[W\
		AcceShop_MainMsgChangeEndStrSet( &p_acce_shop->main_msgwnd, p_acce_shop->p_msgman, p_acce_shop->heapID, AcceShopData, p_acce_shop->list_wnd.now_pos );

		// SW܂
		if( AcceShop_FullAcceCheck( p_acce_shop->p_item, AcceShopData, ACCE_SHOP_DATA_NUM ) ){
			p_acce_shop->seq = ACCE_SHOP_SEQ_KEY_WAIT;	// SW܂
			p_acce_shop->seq_sub = ACCE_SHOP_SEQ_GET_ACCE_FULL;
		}else{
			p_acce_shop->seq = ACCE_SHOP_SEQ_KEY_WAIT;	// x
			p_acce_shop->seq_sub = ACCE_SHOP_SEQ_LIST_RESTART;
		}
		break;

	case ACCE_SHOP_SEQ_GET_ACCE_FULL:	// ANZTS܂
		// SW߂ĂĂ肪Ƃ
		p_str = MSGMAN_AllocString( p_acce_shop->p_msgman, mes_accessory_01_10 );
		AcceShop_MainMsgSet( &p_acce_shop->main_msgwnd, p_str, p_acce_shop->heapID );
		STRBUF_Delete( p_str );
		p_acce_shop->seq = ACCE_SHOP_SEQ_KEY_WAIT;	// SW܂
		p_acce_shop->seq_sub = ACCE_SHOP_SEQ_GET_ACCE_FULL2;
		break;

	case ACCE_SHOP_SEQ_GET_ACCE_FULL2:	// ANZTS܂
		// SW߂ĂĂ肪Ƃ
		p_str = MSGMAN_AllocString( p_acce_shop->p_msgman, mes_accessory_01_02 );
		AcceShop_MainMsgSet( &p_acce_shop->main_msgwnd, p_str, p_acce_shop->heapID );
		STRBUF_Delete( p_str );
		p_acce_shop->seq = ACCE_SHOP_SEQ_KEY_WAIT;	// I
		p_acce_shop->seq_sub = ACCE_SHOP_SEQ_END;
		break;


	case ACCE_SHOP_SEQ_MSG_WAIT:	// bZ[W҂
		if( AcceShop_MainMsgWait( &p_acce_shop->main_msgwnd ) ){
			p_acce_shop->seq = p_acce_shop->seq_sub;
		}
		break;
		
	case ACCE_SHOP_SEQ_KEY_WAIT:// L[҂
		if( AcceShop_MainMsgWait( &p_acce_shop->main_msgwnd ) ){
			if( sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL)  ){
				p_acce_shop->seq = p_acce_shop->seq_sub;
			}
		}
		break;
		
	case ACCE_SHOP_SEQ_END:		// I
		// I
		AcceShop_MainMsgDelete( &p_acce_shop->main_msgwnd );	
		AcceShop_DataMsgDelete( &p_acce_shop->data_msgwnd );	
		AcceShop_ListWinDelete( &p_acce_shop->list_wnd );	
		AcceShop_YesNoWinDelete( &p_acce_shop->yes_no );	
		return TRUE;

	default:
		break;
	}

	CLACT_Draw( p_acce_shop->clactSet );
	
	return FALSE;
}





//-----------------------------------------------------------------------------
/**
 *		vCx[g֐
 */
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
/**
 *	@brief	RtBOf[^擾
 *
 *	@param	p_acce_shop		[N
 */
//-----------------------------------------------------------------------------
static void AcceShop_ConfigGet( FIELD_ACCE_SHOP* p_acce_shop )
{
	CONFIG * cfg = SaveData_GetConfig( p_acce_shop->p_savedata );
	p_acce_shop->win_type = CONFIG_GetWindowType( cfg );
	p_acce_shop->msg_speed = CONFIG_GetMsgPrintSpeed( cfg );
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGL@bZ[Wpʂ́@BGRgp
 *
 *	@param	p_acce_shop 
 */
//-----------------------------------------------------------------------------
static void AcceShop_BGL_Init( FIELD_ACCE_SHOP* p_acce_shop )
{
	// g[NEBhE
	// VXeEBhE
	// 
	TalkWinGraphicSet( p_acce_shop->p_bgl, FLD_MBGFRM_FONT,
			ACCE_SHOP_TALK_CHAROFS,
			ACCE_SHOP_TALK_PLTT,
			p_acce_shop->win_type, 
			p_acce_shop->heapID );
	TalkFontPaletteLoad( PALTYPE_MAIN_BG, 
			ACCE_SHOP_TALKFONT_PLTT * 32, 
			p_acce_shop->heapID );

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/24
// ANZT[VbṽEBhE̐FςĂ܂sC

	/* t[VbṽEBhEEBhE^CvŕςĂ܂oȎΏ */
#if AFTERMASTER_070122_ACCESSORYSHOP_WND_FIX
	MenuWinGraphicSet( p_acce_shop->p_bgl, FLD_MBGFRM_FONT,
			ACCE_SHOP_SYSTEM_CHAROFS,
			ACCE_SHOP_SYSTEM_PLTT,
			MENU_TYPE_SYSTEM,	// VXej[EBhEŌŒ肷
			p_acce_shop->heapID );
#else
	MenuWinGraphicSet( p_acce_shop->p_bgl, FLD_MBGFRM_FONT,
			ACCE_SHOP_SYSTEM_CHAROFS,
			ACCE_SHOP_SYSTEM_PLTT,
			p_acce_shop->win_type, 
			p_acce_shop->heapID );
#endif

// ----------------------------------------------------------------------------

	SystemFontPaletteLoad( PALTYPE_MAIN_BG, 
			ACCE_SHOP_SYSTEMFONT_PLTT * 32, 
			p_acce_shop->heapID );
	
	// XN[N[	
	GF_BGL_ScrClear( p_acce_shop->p_bgl, FLD_MBGFRM_FONT );
}

static void AcceShop_BGL_Delete( FIELD_ACCE_SHOP* p_acce_shop )
{
	// XN[N[	
	GF_BGL_ScrClear( p_acce_shop->p_bgl, FLD_MBGFRM_FONT );

	// tB[h풓LN^A
	FieldMsgPrintInit( PALTYPE_MAIN_BG, MSG_PRINT_INIT_ON );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ZAN^[ݒ
 *
 *	@param	p_acce_shop 
 */
//-----------------------------------------------------------------------------
static void AcceShop_CLACT_Init( FIELD_ACCE_SHOP* p_acce_shop )
{
	p_acce_shop->clactSet = CLACT_U_SetEasyInit( ACCE_SHOP_CLACT_WORK_NUM , &p_acce_shop->renddata, p_acce_shop->heapID );
}
static void AcceShop_CLACT_Delete( FIELD_ACCE_SHOP* p_acce_shop )
{
	CLACT_DestSet( p_acce_shop->clactSet );
}



//----------------------------------------------------------------------------
/**
 *	@brief	CbZ[WEBhE@IuWF@
 *
 *	@param	p_win		EBhEIuWF
 *	@param	p_bgl		BGL
 *	@param	heapID		q[vID
 *	@param	msg_speed	bZ[WXs[h
 */
//-----------------------------------------------------------------------------
static void AcceShop_MainMsgInit( ACCE_SHOP_MAIN_MSG* p_win, GF_BGL_INI* p_bgl, u32 heapID, u32 msg_speed )
{
	if( p_win->init == 1 ){
		return ;
	}
	
	p_win->msg_speed = msg_speed;
	
	p_win->p_bmp = GF_BGL_BmpWinAllocGet( heapID, 1 );

	// rbg}bvEBhEm
	GF_BGL_BmpWinAdd( p_bgl, p_win->p_bmp, FLD_MBGFRM_FONT,
			ACCE_SHOP_MAIN_MSGWIN_X, ACCE_SHOP_MAIN_MSGWIN_Y,
			ACCE_SHOP_MAIN_MSGWIN_SX, ACCE_SHOP_MAIN_MSGWIN_SY,
			ACCE_SHOP_MAIN_MSGWIN_PLTT, ACCE_SHOP_MAIN_MSGWIN_CHAR );

	GF_BGL_BmpWinDataFill( p_win->p_bmp, 15 );

	// g`
	BmpTalkWinWrite( p_win->p_bmp, WINDOW_TRANS_ON, ACCE_SHOP_TALK_CHAROFS, ACCE_SHOP_TALK_PLTT );

	p_win->init = 1;
}

//----------------------------------------------------------------------------
/**
 *	@brief	CbZ[WIuWF@j
 *
 *	@param	p_win	EBhEIuWF
 */
//-----------------------------------------------------------------------------
static void AcceShop_MainMsgDelete( ACCE_SHOP_MAIN_MSG* p_win )
{
	if( p_win->init == 0 ){
		return ;
	}
	
	GF_BGL_BmpWinOff( p_win->p_bmp );
	GF_BGL_BmpWinDel( p_win->p_bmp );
	GF_BGL_BmpWinFree( p_win->p_bmp, 1 );

	p_win->init = 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief	CbZ[Wݒ
 *
 *	@param	p_win		EBhEIuWF
 *	@param	p_str		
 *	@param	heapID
 */
//-----------------------------------------------------------------------------
static void AcceShop_MainMsgSet( ACCE_SHOP_MAIN_MSG* p_win, STRBUF* p_str, u32 heapID )
{
	GF_ASSERT( p_win->p_str == NULL );
	
	GF_BGL_BmpWinDataFill( p_win->p_bmp, 15 );

	p_win->p_str = STRBUF_CreateBufferCopy( p_str, heapID );
	
	p_win->msg_idx = GF_STR_PrintColor( p_win->p_bmp, FONT_TALK, p_win->p_str, 0, 0, p_win->msg_speed, ACCE_SHOP_FONTBMP_TALK_COLOR, NULL );

	GF_BGL_BmpWinOn( p_win->p_bmp );
}

//----------------------------------------------------------------------------
/**
 *	@brief	bZ[WEGCgȂ
 *
 *	@param	p_win	EBhE
 *	@param	p_str	
 */
//-----------------------------------------------------------------------------
static void AcceShop_MainMsgSet_noWait( ACCE_SHOP_MAIN_MSG* p_win, STRBUF* p_str )
{
	GF_BGL_BmpWinDataFill( p_win->p_bmp, 15 );
	p_win->msg_idx = GF_STR_PrintColor( p_win->p_bmp, FONT_TALK, p_str, 0, 0, MSG_NO_PUT, ACCE_SHOP_FONTBMP_TALK_COLOR, NULL );

	GF_BGL_BmpWinOn( p_win->p_bmp );
}

//----------------------------------------------------------------------------
/**
 *	@brief	bZ[WI҂
 *	
 *	@param	p_win	EBhEIuWF
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL AcceShop_MainMsgWait( ACCE_SHOP_MAIN_MSG* p_win )
{
	if( GF_MSG_PrintEndCheck( p_win->msg_idx ) == 0 ){

		// ێĂobt@j
		if( p_win->p_str != NULL ){
			STRBUF_Delete( p_win->p_str );
			p_win->p_str = NULL;
		}
		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	CʂɁ@`Ɓ`܂H@eLXgo
 *
 *	@param	p_win		EBhEIuWF
 *	@param	p_msgman	bZ[W}l[W
 *	@param	heapID		q[v
 *	@param	cp_data		Vbvf[^
 *	@param	data_idx	\f[^CfbNX
 */
//-----------------------------------------------------------------------------
static void AcceShop_MainMsgChangeStrSet( ACCE_SHOP_MAIN_MSG* p_win, MSGDATA_MANAGER* p_msgman, u32 heapID, const ACCE_SHOP_DATA* cp_data, u32 data_idx )
{
	STRBUF* p_str;
	STRBUF* p_drawstr;
	WORDSET* p_wordset;
	
	// ȈՉb쐬
	p_wordset = WORDSET_Create( heapID );

	// WJ敶쐬
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2007/01/23
	// bZ[Wpobt@̃TCYg
	p_drawstr = STRBUF_Create( ACCE_SHOP_BUFFER_SIZE, heapID );
	// ----------------------------------------------------------------------------
	p_str = MSGMAN_AllocString( p_msgman, mes_accessory_01_04 );
	
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2007/01/26
	// ̂ݖ𕡐`Ɂi݂̎dlł́AP݂̂̂邱Ƃ͂Ȃj
	WORDSET_RegisterItemNamePlural( p_wordset, 0, cp_data[ data_idx ].item_no + NUTS_START_ITEMNUM );
	// ----------------------------------------------------------------------------
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2007/01/23
	// ̍̃Xy[X
	WORDSET_RegisterNumber( p_wordset, 1, cp_data[ data_idx ].need_num,
			3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	// ----------------------------------------------------------------------------
	WORDSET_RegisterAccessoryName( p_wordset, 2, cp_data[ data_idx ].acce_no );
	WORDSET_ExpandStr( p_wordset, p_drawstr, p_str );

	// eLXgݒ
	AcceShop_MainMsgSet( p_win, p_drawstr, heapID );
	
	WORDSET_Delete( p_wordset );
	STRBUF_Delete( p_drawstr );
	STRBUF_Delete( p_str );
	
}

//----------------------------------------------------------------------------
/**
 *	@brief	I	\
 *
 *	@param	p_win		CEBhEIuWF
 *	@param	p_msgman	bZ[W}l[W
 *	@param	heapID		q[vID
 *	@param	cp_data		f[^
 *	@param	data_idx	f[^CfbNX
 */
//-----------------------------------------------------------------------------
static void AcceShop_MainMsgChangeEndStrSet( ACCE_SHOP_MAIN_MSG* p_win, MSGDATA_MANAGER* p_msgman, u32 heapID, const ACCE_SHOP_DATA* cp_data, u32 data_idx )
{
	STRBUF* p_str;
	STRBUF* p_drawstr;
	WORDSET* p_wordset;
	
	// ȈՉb쐬
	p_wordset = WORDSET_Create( heapID );

	// WJ敶쐬
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2007/01/23
	// bZ[Wpobt@̃TCY萔}Nɒu
	p_drawstr = STRBUF_Create( ACCE_SHOP_BUFFER_SIZE, heapID );
	// ----------------------------------------------------------------------------
	p_str = MSGMAN_AllocString( p_msgman, mes_accessory_01_09 );
	
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2007/01/26
	// ̂ݖ𕡐`Ɂi݂̎dlł́AP݂̂̂邱Ƃ͂Ȃj
	WORDSET_RegisterItemNamePlural( p_wordset, 0, cp_data[ data_idx ].item_no + NUTS_START_ITEMNUM );
	// ----------------------------------------------------------------------------
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2007/01/23
	// ̍̃Xy[X
	WORDSET_RegisterNumber( p_wordset, 1, cp_data[ data_idx ].need_num,
			3, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	// ----------------------------------------------------------------------------
	WORDSET_RegisterAccessoryName( p_wordset, 2, cp_data[ data_idx ].acce_no );
	WORDSET_ExpandStr( p_wordset, p_drawstr, p_str );

	// eLXgݒ
	AcceShop_MainMsgSet( p_win, p_drawstr, heapID );
	
	WORDSET_Delete( p_wordset );
	STRBUF_Delete( p_drawstr );
	STRBUF_Delete( p_str );
}

//----------------------------------------------------------------------------
/**
 *	@brief	f[^ʏ
 *
 *	@param	p_win		EBhEIuWF
 *	@param	p_bgl		BGL
 *	@param	heapID		q[v
 */
//-----------------------------------------------------------------------------
static void AcceShop_DataMsgInit( ACCE_SHOP_DATA_WIN* p_win, GF_BGL_INI* p_bgl, MSGDATA_MANAGER* p_msgman, u32 heapID )
{
	int i;

	if( p_win->init == 1 ){
		return ;
	}
	
	p_win->p_bmp = GF_BGL_BmpWinAllocGet( heapID, 1 );

	// rbg}bvEBhEm
	GF_BGL_BmpWinAdd( p_bgl, p_win->p_bmp, FLD_MBGFRM_FONT,
			ACCE_SHOP_DATA_WINWIN_X, ACCE_SHOP_DATA_WINWIN_Y,
			ACCE_SHOP_DATA_WINWIN_SX, ACCE_SHOP_DATA_WINWIN_SY,
			ACCE_SHOP_DATA_WINWIN_PLTT, ACCE_SHOP_DATA_WINWIN_CHAR );


	// ȈՉb쐬
	p_win->p_wordset = WORDSET_Create( heapID );
	for( i=0; i<ACCE_SHOP_DATA_WIN_NUM; i++ ){
		p_win->p_wordstr[i] = MSGMAN_AllocString( p_msgman, mes_accessory_03_01+i );
	}

	// WJ敶쐬
	p_win->p_drawstr = STRBUF_Create( WORDSET_DEFAULT_BUFLEN, heapID );


	GF_BGL_BmpWinDataFill( p_win->p_bmp, 15 );

	p_win->init = 1;
}

//----------------------------------------------------------------------------
/**
 *	@brief	f[^ʔj
 *	
 *	@param	p_win	EBhEIuWF
 */
//-----------------------------------------------------------------------------
static void AcceShop_DataMsgDelete( ACCE_SHOP_DATA_WIN* p_win )
{
	int i;

	if( p_win->init == 0 ){
		return ;
	}
	
	for( i=0; i<ACCE_SHOP_DATA_WIN_NUM; i++ ){
		// j
		STRBUF_Delete( p_win->p_wordstr[i] );
	}
	STRBUF_Delete( p_win->p_drawstr );


	WORDSET_Delete( p_win->p_wordset );	
	GF_BGL_BmpWinOff( p_win->p_bmp );
	GF_BGL_BmpWinDel( p_win->p_bmp );
	GF_BGL_BmpWinFree( p_win->p_bmp, 1 );

	p_win->init = 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief	f[^EBhEݒ
 *
 *	@param	p_win		EBhE
 *	@param	nut			؂̎	iio[j
 *	@param	nut_need_num؂̎ɕKvȐ
 *	@param	nut_get_num	؂̎ێ
 */
//-----------------------------------------------------------------------------
static void AcceShop_DataMsgSet( ACCE_SHOP_DATA_WIN* p_win, u32 nut, u32 nut_need_num, u32 nut_get_num )
{
	int i;

	// [hZbg
	WORDSET_RegisterItemName( p_win->p_wordset, ACCE_SHOP_DATA_WIN_NUTS_NAME, nut + NUTS_START_ITEMNUM );
	WORDSET_RegisterNumber( p_win->p_wordset, ACCE_SHOP_DATA_WIN_NUTS_NEED,
			nut_need_num, 3, NUMBER_DISPTYPE_SPACE, NUMBER_CODETYPE_DEFAULT );
	WORDSET_RegisterNumber( p_win->p_wordset, ACCE_SHOP_DATA_WIN_NUTS_HAVE,
			nut_get_num, 3, NUMBER_DISPTYPE_SPACE, NUMBER_CODETYPE_DEFAULT );

	GF_BGL_BmpWinDataFill( p_win->p_bmp, 15 );

	// WJ
	for( i=0; i<ACCE_SHOP_DATA_WIN_NUM; i++ ){
		WORDSET_ExpandStr( p_win->p_wordset, p_win->p_drawstr, p_win->p_wordstr[ i ] );

		GF_STR_PrintColor( p_win->p_bmp, FONT_SYSTEM, p_win->p_drawstr,
				0, 
				ACCE_SHOP_DATA_WINWIN_DRAW_YOFS * i,
				MSG_NO_PUT, ACCE_SHOP_FONTBMP_SYS_COLOR, NULL );
	}

	// g̕`
	BmpMenuWinWrite( p_win->p_bmp, WINDOW_TRANS_ON, ACCE_SHOP_SYSTEM_CHAROFS, ACCE_SHOP_SYSTEM_PLTT );
}

//----------------------------------------------------------------------------
/**
 *	@brief	XgEBhE
 *
 *	@param	p_win		[N
 *	@param	p_bgl		BGL
 *	@param	heapID		q[v
 *	@param	cp_data		f[^e[u
 *	@param	data_num	f[^
 *	@param	p_msgman	bZ[W}l[W
 *	@param	clact_set	ZAN^[Zbg
 */
//-----------------------------------------------------------------------------
static void AcceShop_ListWinInit( ACCE_SHOP_LIST_WIN* p_win, GF_BGL_INI* p_bgl, u32 heapID, const ACCE_SHOP_DATA* cp_data, u32 data_num, MSGDATA_MANAGER* p_msgman, void* p_work, pAcceListMoveFunc callback, CLACT_SET_PTR clact_set )
{
	int i;
	STRBUF* p_str;
	CLACT_HEADER head;
	CLACT_ADD_SIMPLE add;

	static const u8 CLACT_Add_Y[ ACCE_SHOP_LIST_WIN_CLACT_OBJNUM ] = {
		ACCE_SHOP_LIST_WIN_CLACT_Y_0,
		ACCE_SHOP_LIST_WIN_CLACT_Y_1
	};
	static BMPLIST_HEADER BmpListHeader = {
		NULL,
		NULL,
		NULL,
		NULL,
		0,
		ACCE_SHOP_LIST_WIN_DRAWLINE,
		0,
		ACCE_SHOP_LIST_WIN_DATA_X,
		ACCE_SHOP_LIST_WIN_CURSOR_X,
		ACCE_SHOP_LIST_WIN_DRAW_Y,
		ACCE_SHOP_LIST_WIN_FONT_COL_F,
		ACCE_SHOP_LIST_WIN_FONT_COL_B,
		ACCE_SHOP_LIST_WIN_FONT_COL_S,
		ACCE_SHOP_LIST_WIN_MSG_SPC,
		ACCE_SHOP_LIST_WIN_LINE_SPC,
		ACCE_SHOP_LIST_WIN_PAGE_SKIP,
		ACCE_SHOP_LIST_WIN_FONT,
		ACCE_SHOP_LIST_WIN_DISP,
		NULL
	};

	if( p_win->init == 1 ){
		return ;
	}

	
	p_win->init = 1;

	p_win->data_num = data_num + 1;
	
	p_win->p_work = p_work;
	p_win->callback = callback;
	p_win->p_bmp = GF_BGL_BmpWinAllocGet( heapID, 1 );

	// rbg}bvEBhEm
	GF_BGL_BmpWinAdd( p_bgl, p_win->p_bmp, FLD_MBGFRM_FONT,
			ACCE_SHOP_LIST_WINWIN_X, ACCE_SHOP_LIST_WINWIN_Y,
			ACCE_SHOP_LIST_WINWIN_SX, ACCE_SHOP_LIST_WINWIN_SY,
			ACCE_SHOP_LIST_WINWIN_PLTT, ACCE_SHOP_LIST_WINWIN_CHAR );

	// ȈՉb쐬
	p_win->p_wordset = WORDSET_Create( heapID );

	// WJ敶쐬
	p_win->p_drawstr = STRBUF_Create( WORDSET_DEFAULT_BUFLEN, heapID );
	p_str = MSGMAN_AllocString( p_msgman, mes_accessory_03_01 );
	
	// Xgf[^쐬
	for( i=0; i<data_num; i++ ){
		WORDSET_RegisterAccessoryName( p_win->p_wordset, 0, cp_data[ i ].acce_no );
		WORDSET_ExpandStr( p_win->p_wordset, p_win->p_drawstr, p_str );
		p_win->p_list_str[ i ] = STRBUF_CreateBufferCopy( p_win->p_drawstr, heapID );
		p_win->list[ i ].str = p_win->p_list_str[ i ];
		p_win->list[ i ].param = i;
	}
	
	// I
	p_win->p_list_str[ data_num ] = MSGMAN_AllocString( p_msgman, mes_accessory_04_01 );
	p_win->list[ data_num ].str = p_win->p_list_str[ data_num ];
	p_win->list[ data_num ].param = data_num;
	
	WORDSET_Delete( p_win->p_wordset );
	STRBUF_Delete( p_win->p_drawstr );
	STRBUF_Delete( p_str );

	// rbg}bvXgɐݒ
	BmpListHeader.win = p_win->p_bmp;
	BmpListHeader.count = p_win->data_num;
	BmpListHeader.list = p_win->list;
	p_win->p_bmplist = BmpListSet( &BmpListHeader, 0, 0, heapID );

	// g̕`
	BmpMenuWinWrite( p_win->p_bmp, WINDOW_TRANS_ON, ACCE_SHOP_SYSTEM_CHAROFS, ACCE_SHOP_SYSTEM_PLTT );

	// \[X}l[W쐬
	for( i=0; i<ACCE_SHOP_LIST_WIN_CLACT_RESNUM; i++ ){
		p_win->resMan[ i ] = CLACT_U_ResManagerInit( ACCE_SHOP_LIST_WIN_CLACT_RESMAN_WORKNUM,
				i, heapID );
	}

	// \[Xǂݍ
	AcceShop_ListWinClactResLoad( &head, p_win, heapID );

	// AN^[̓o^
	add.ClActSet = clact_set;
	add.ClActHeader = &head;
	add.pri		= 0;
	add.DrawArea = NNS_G2D_VRAM_TYPE_2DMAIN;
	add.heap	= heapID;
	add.mat.x	= ACCE_SHOP_LIST_WIN_CLACT_X * FX32_ONE;
	for( i=0; i<ACCE_SHOP_LIST_WIN_CLACT_OBJNUM; i++ ){
		add.mat.y	= CLACT_Add_Y[ i ] * FX32_ONE;
		p_win->clact[ i ] = CLACT_AddSimple( &add );
		CLACT_AnmChg( p_win->clact[ i ], i );
		CLACT_SetAnmFlag( p_win->clact[ i ], TRUE );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	XgEBhEj
 *
 *	@param	p_win	[N
 */
//-----------------------------------------------------------------------------
static void AcceShop_ListWinDelete( ACCE_SHOP_LIST_WIN* p_win )
{
	int i;

	if( p_win->init == 0 ){
		return ;
	}

	// AN^[j
	for( i=0; i<ACCE_SHOP_LIST_WIN_CLACT_OBJNUM; i++ ){

		CLACT_Delete( p_win->clact[ i ] );
	}

	// AN^[\[Xj
	AcceShop_ListWinClactResDelete( p_win );

	// XgȂj
	for( i=0; i<p_win->data_num; i++ ){
		STRBUF_Delete( p_win->p_list_str[ i ] );
	}

	// rbg}bvXgj
	BmpListExit( p_win->p_bmplist, NULL, NULL );
	GF_BGL_BmpWinOff( p_win->p_bmp );
	GF_BGL_BmpWinDel( p_win->p_bmp );
	GF_BGL_BmpWinFree( p_win->p_bmp, 1 );

	p_win->init = 1;
}

//----------------------------------------------------------------------------
/**
 *	@brief	XgEBhE@C
 *
 *	@param	p_win	EBhE
 *
 *	@retval	"param = Ip[^"
 *	@retval	"BMPLIST_NULL = I"
 *	@retval	"BMPLIST_CANCEL	= LZ(a{^)"
 */
//-----------------------------------------------------------------------------
static u32 AcceShop_ListWinMain( ACCE_SHOP_LIST_WIN* p_win )
{
	u32 result;
	u16 now_pos;
	
	result = BmpListMain( p_win->p_bmplist );

	// IB{^ȊOȂ猻݃|WVݒ
	if( result == BMPLIST_NULL ){
		BmpListDirectPosGet( p_win->p_bmplist, &now_pos );
		if( p_win->now_pos != now_pos ){
			p_win->now_pos = now_pos;
			p_win->callback( p_win->p_work, p_win->now_pos );

			Snd_SePlay( ACCE_SHOP_SND_LIST_MOVE );

			AcceShop_ListWinClactDrawSet( p_win );

		}
	}else if( result != BMPLIST_CANCEL ){

		// ŏIڂI߂@Ȃ̂CANCELԂ
		if( p_win->now_pos == (p_win->data_num - 1) ){
			result = BMPLIST_CANCEL;
		}
	}
	
	return result;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ē]
 *
 *	@param	p_win	[N
 */
//-----------------------------------------------------------------------------
static void AcceShop_ListWinReTrans( ACCE_SHOP_LIST_WIN* p_win )
{
//	BmpListRewrite( p_win->p_bmplist );
	p_win->callback( p_win->p_work, p_win->now_pos );

	// g̕`
	BmpMenuWinWrite( p_win->p_bmp, WINDOW_TRANS_ON, ACCE_SHOP_SYSTEM_CHAROFS, ACCE_SHOP_SYSTEM_PLTT );

	// OAM`ݒ	
	AcceShop_ListWinClactDrawSet( p_win );
}

//----------------------------------------------------------------------------
/**
 *	@brief	EBhE`OFF
 *
 *	@param	p_win 
 */
//-----------------------------------------------------------------------------
static void AcceShop_ListWinDrawClean( ACCE_SHOP_LIST_WIN* p_win )
{
	CLACT_SetDrawFlag( p_win->clact[ 0 ], FALSE );
	CLACT_SetDrawFlag( p_win->clact[ 1 ], FALSE );
}

//----------------------------------------------------------------------------
/**
 *	@brief	AN^[\[Xǂݍ
 *	
 *	@param	p_head	wb_[
 *	@param	p_win	
 */
//-----------------------------------------------------------------------------
static void AcceShop_ListWinClactResLoad( CLACT_HEADER* p_head, ACCE_SHOP_LIST_WIN* p_win, u32 heapID )
{
	// \[Xǂݍ
	p_win->resObj[ CLACT_U_CHAR_RES ] = CLACT_U_ResManagerResAddArcChar( 
			p_win->resMan[ CLACT_U_CHAR_RES ],
			ARC_SHOP_GRA, NARC_shop_gra_shop_arw_NCGR, 
			FALSE, ACCE_SHOP_LIST_WIN_CLACT_RESCONT_ID, 
			NNS_G2D_VRAM_TYPE_2DMAIN, heapID );	

	p_win->resObj[ CLACT_U_PLTT_RES ] = CLACT_U_ResManagerResAddArcPltt( 
			p_win->resMan[ CLACT_U_PLTT_RES ],
			ARC_SHOP_GRA, NARC_shop_gra_shop_obj_NCLR, 
			FALSE, ACCE_SHOP_LIST_WIN_CLACT_RESCONT_ID, 
			NNS_G2D_VRAM_TYPE_2DMAIN, 1,  heapID );	

	p_win->resObj[ CLACT_U_CELL_RES ] = CLACT_U_ResManagerResAddArcKindCell( 
			p_win->resMan[ CLACT_U_CELL_RES ],
			ARC_SHOP_GRA, NARC_shop_gra_shop_arw_NCER, 
			FALSE, ACCE_SHOP_LIST_WIN_CLACT_RESCONT_ID, 
			CLACT_U_CELL_RES, heapID );	

	p_win->resObj[ CLACT_U_CELLANM_RES ] = CLACT_U_ResManagerResAddArcKindCell( 
			p_win->resMan[ CLACT_U_CELLANM_RES ],
			ARC_SHOP_GRA, NARC_shop_gra_shop_arw_NANR, 
			FALSE, ACCE_SHOP_LIST_WIN_CLACT_RESCONT_ID, 
			CLACT_U_CELLANM_RES, heapID );


	CLACT_U_CharManagerSetAreaCont( p_win->resObj[ CLACT_U_CHAR_RES ] );
	CLACT_U_PlttManagerSetCleanArea( p_win->resObj[ CLACT_U_PLTT_RES ] );

	// wb_[쐬
	CLACT_U_MakeHeader(
			p_head,
			ACCE_SHOP_LIST_WIN_CLACT_RESCONT_ID,
			ACCE_SHOP_LIST_WIN_CLACT_RESCONT_ID,
			ACCE_SHOP_LIST_WIN_CLACT_RESCONT_ID,
			ACCE_SHOP_LIST_WIN_CLACT_RESCONT_ID,
			CLACT_U_HEADER_DATA_NONE,
			CLACT_U_HEADER_DATA_NONE,
			0, 0,
			p_win->resMan[ 0 ],
			p_win->resMan[ 1 ],
			p_win->resMan[ 2 ],
			p_win->resMan[ 3 ],
			NULL, NULL );
}

//----------------------------------------------------------------------------
/**
 *	@brief	AN^[\[Xj
 *
 *	@param	p_win 
 */
//-----------------------------------------------------------------------------
static void AcceShop_ListWinClactResDelete( ACCE_SHOP_LIST_WIN* p_win )
{
	int i;
	CLACT_U_CharManagerDelete( p_win->resObj[ CLACT_U_CHAR_RES ] );
	CLACT_U_PlttManagerDelete( p_win->resObj[ CLACT_U_PLTT_RES ] );

	for( i=0; i<ACCE_SHOP_LIST_WIN_CLACT_RESNUM; i++ ){
		CLACT_U_ResManagerDelete( p_win->resMan[ i ] );
	}
}

//----------------------------------------------------------------------------
/**
*	@brief	`ݒ
 *
 *	@param	* p_win 
 */
//-----------------------------------------------------------------------------
static void AcceShop_ListWinClactDrawSet( ACCE_SHOP_LIST_WIN* p_win )
{
	u16 list_pos;
	
	// Xgʒu擾
	BmpListPosGet( p_win->p_bmplist, &list_pos, NULL );
	
	if( (list_pos <= 0) ){
		CLACT_SetDrawFlag( p_win->clact[ 0 ], FALSE );
	}else{
		CLACT_SetDrawFlag( p_win->clact[ 0 ], TRUE );
	}
	if( list_pos >= (p_win->data_num - 7) ){
		CLACT_SetDrawFlag( p_win->clact[ 1 ], FALSE );
	}else{
		CLACT_SetDrawFlag( p_win->clact[ 1 ], TRUE );
	}
}



//----------------------------------------------------------------------------
/**
 *	@brief	f[^EBhEύX@IuWF
 *
 *	@param	p_obj			IuWF
 *	@param	data_win		f[^EBhE
 *	@param	cp_data			ANZT[f[^
 *	@param	p_save			Z[uf[^
 *	@param	heapID			q[v
 *	@param	p_bgl			BGL
 */
//-----------------------------------------------------------------------------
static void AcceShop_DataWinChgDataInit( ACCE_SHOP_DATA_WIN_CHG* p_obj, ACCE_SHOP_DATA_WIN* data_win, const ACCE_SHOP_DATA* cp_data, MYITEM* p_save, u32 heapID, GF_BGL_INI* p_bgl )
{
	p_obj->p_bgl = p_bgl;
	p_obj->p_data_wnd = data_win;
	p_obj->cp_data = cp_data;
	p_obj->p_myitem = p_save;
	p_obj->heapID	= heapID;
}

//----------------------------------------------------------------------------
/**
 *	@brief	XgɌĂł炤@f[^EBhEXVR[obN
 *
 *	@param	p_work
 *	@param	listnum 
 */
//-----------------------------------------------------------------------------
static void AcceShop_DataWinChgCallBack( void* p_work, u32 listnum )
{
	ACCE_SHOP_DATA_WIN_CHG* p_obj = p_work;
	u32 have_item;
	
	// Vbvf[^ڐȉȂ@f[^XV
	if( listnum < ACCE_SHOP_DATA_NUM ){
		
		have_item = MyItem_GetItemNum( p_obj->p_myitem, p_obj->cp_data[ listnum ].item_no + NUTS_START_ITEMNUM, p_obj->heapID );
		AcceShop_DataMsgSet( p_obj->p_data_wnd, 
				p_obj->cp_data[ listnum ].item_no, 
				p_obj->cp_data[ listnum ].need_num, 
				have_item );
	}else{
		// XN[		
		GF_BGL_ScrFill( p_obj->p_bgl, FLD_MBGFRM_FONT,
				0,
				ACCE_SHOP_DATA_WINWIN_X-1, ACCE_SHOP_DATA_WINWIN_Y-1,
				ACCE_SHOP_DATA_WINWIN_SX+2, ACCE_SHOP_DATA_WINWIN_SY+2, 
				GF_BGL_SCRWRT_PALIN );
		GF_BGL_LoadScreenReq( p_obj->p_bgl, FLD_MBGFRM_FONT );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	YESNOEBhE
 *
 *	@param	p_win	EBhE[N
 *	@param	p_bgl	BGL
 *	@param	heapID	q[v
 */
//-----------------------------------------------------------------------------
static void AcceShop_YesNoWinInit( ACCE_SHOP_YESNO_MENU* p_win, GF_BGL_INI* p_bgl, u32 heapID )
{
	static const BMPWIN_DAT BmpWinDat = {
		FLD_MBGFRM_FONT,
		ACCE_SHOP_YESNO_WIN_X,
		ACCE_SHOP_YESNO_WIN_Y,
		ACCE_SHOP_YESNO_WIN_SX,
		ACCE_SHOP_YESNO_WIN_SY,
		ACCE_SHOP_YESNO_WIN_PLTT,
		ACCE_SHOP_YESNO_WIN_CHAR
	};

	if( p_win->init == 1 ){
		return ;
	}
	
	p_win->p_yesno = BmpYesNoSelectInit( p_bgl, &BmpWinDat, ACCE_SHOP_SYSTEM_CHAROFS, ACCE_SHOP_SYSTEM_PLTT, heapID );
	p_win->heapID = heapID;

	p_win->init = 1;
}

//----------------------------------------------------------------------------
/**
 *	@brief	YESNOEBhEj
 *
 *	@param	p_win	EBhE[N
 */
//-----------------------------------------------------------------------------
static void AcceShop_YesNoWinDelete( ACCE_SHOP_YESNO_MENU* p_win )
{
	if( p_win->init == 0 ){
		return ;
	}
	
	// ɔĵŃRgAEg
//	BmpYesNoWinDel( p_win->p_yesno, p_win->heapID );

	p_win->init = 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief	YESNOEBhEC
 *
 *	@param	p_win	[N
 *
 * @retval	"BMPMENU_NULL	IĂȂ"
 * @retval	"0				͂I"
 * @retval	"BMPMENU_CANCEL	orLZ"
 */
//-----------------------------------------------------------------------------
static u32 AcceShop_YesNoWinMain( ACCE_SHOP_YESNO_MENU* p_win )
{
	u32 result;
	result = BmpYesNoSelectMain( p_win->p_yesno, p_win->heapID );
	return result;
}


//----------------------------------------------------------------------------
/**
 *	@brief	VbṽANZTtɎĂ邩`FbN
 *
 *	@param	cp_item		Z[uf[^
 *	@param	cp_data		Vbvf[^
 *	@param	data_num	f[^
 *
 *	@retval	TRUE	tɎĂ
 *	@retval	FALSE	tɂėǂȂ
 */
//-----------------------------------------------------------------------------
static BOOL AcceShop_FullAcceCheck( const IMC_ITEM_SAVEDATA* cp_item, const ACCE_SHOP_DATA* cp_data, u32 data_num )
{
	int i;

	// Sf[^ANZTǉł邩`FbN
	for( i=0; i<data_num; i++ ){
		if( ImcSaveData_CheckAcceAdd( cp_item, cp_data[i].acce_no, 1 ) == TRUE ){
			return FALSE;
		}
	}
	return TRUE;
}


//----------------------------------------------------------------------------
/**
 *	@brief	؂̎Ă邩`FbN
 *
 *	@param	p_save		Z[u
 *	@param	cp_data		f[^
 *	@param	data_idx	CfbNX
 *
 *	@retval	TRUE	Ă
 *	@retval	FALSE	ĂȂ
 */
//-----------------------------------------------------------------------------
static BOOL AcceShop_NutsOkCheck( MYITEM* p_save, const ACCE_SHOP_DATA* cp_data, u32 data_idx, u32 heapID )
{
	u32 item_num;
	
	item_num = MyItem_GetItemNum( p_save, cp_data[ data_idx ].item_no + NUTS_START_ITEMNUM, heapID );

	if( item_num >= cp_data[ data_idx ].need_num ){
		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTĂ邩`FbN
 *
 *	@param	cp_item		[N	
 *	@param	cp_data		f[^
 *	@param	data_idx	CfbNX
 */
//-----------------------------------------------------------------------------
static BOOL AcceShop_AcceHaveOkCheck( const IMC_ITEM_SAVEDATA* cp_item, const ACCE_SHOP_DATA* cp_data, u32 data_idx )
{
	return ImcSaveData_CheckAcceAdd( cp_item, cp_data[ data_idx ].acce_no, 1 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTύX@
 *
 *	@param	p_acceitem		ANZTZ[uf[^
 *	@param	p_myitem		ACe
 *	@param	cp_data			Vbvf[^
 *	@param	data_idx		f[^CfbNX
 */
//-----------------------------------------------------------------------------
static void AcceShop_AcceChange( IMC_ITEM_SAVEDATA* p_acceitem, MYITEM* p_myitem, const ACCE_SHOP_DATA* cp_data, u32 data_idx, u32 heapID )
{
	u32 acce_no = cp_data[ data_idx ].acce_no;
	u32 item_no = cp_data[ data_idx ].item_no + NUTS_START_ITEMNUM;
	u32 need_num = cp_data[ data_idx ].need_num;
	BOOL result;

	ImcSaveData_AddAcceFlag( p_acceitem, acce_no, 1 );
	result = MyItem_SubItem( p_myitem, item_no, need_num, heapID );
	GF_ASSERT( result == TRUE );
}
