//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		field_demo.c
 *	@brief		tB[hł̊ȒPȃf
 *	@author		tomoya takahashi	
 *	@data		2006.04.17
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "common.h"

#include "include/system/swsprite.h"
#include "include/system/arc_util.h"
#include "demo_climax.naix"
#include "fieldmap.h"
#include "fieldmap_work.h"
#include "fieldsys.h"
#include "motion_bl.h"
#include "field_subscreen.h"
#include "fieldobj_draw_legendpoke.h"
#include "field_3dobj.h"
#include "src/fielddata/eventdata/zone_d05r0114evc.h"
#include "field_light.h"

#include "system/snd_tool.h"

#define	__FIELD_DEMO_H_GLOBAL
#include "field_demo.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
#ifdef PM_DEBUG
//#define FIELD_DEMO_DEBUG		// fobN^XN܂킷H
#endif // PM_DEBUG 

#ifdef FIELD_DEMO_DEBUG
static int FIELD_DEMO_DEBUG_STOP = 0;
static TCB_PTR pFieldDemoDebugTcb = NULL;
static void FieldDemoDebugTcb( TCB_PTR tcb, void* p_work );
static void FieldDemoDebugStart( void );
static void FieldDemoDebugEnd( void );
#endif // FIELD_DEMO_DEBUG


#define USE_HEAPID		( HEAPID_FIELD )


//-------------------------------------
//	`
//=====================================
#define FLD_DEMO_LEGENDEFF_SND_00	( SEQ_SE_DP_CLIMAX01 )		// V[
#define FLD_DEMO_LEGENDEFF_SND_01	( SEQ_SE_DP_CLIMAX03 )		// ڂ[
#define FLD_DEMO_LEGENDEFF_SND_02	( SEQ_SE_DP_CLIMAX06 )		// ҂[	tbV
#define FLD_DEMO_LEGENDEFF_SND_03	( SEQ_SE_DP_CLIMAX09 )		// S[SSS	ʗh炵
#define FLD_DEMO_LEGENDEFF_SND_04	( SEQ_SE_DP_CLIMAX10 )		// EB	
#define FLD_DEMO_LEGENDEFF_SND_05	( SEQ_SE_DP_CLIMAX12 )		// V[

//#define FLD_DEMO_LEGENDEFF_SND_06	( SEQ_SE_DP_CLIMAX16 )		// vV[
#define FLD_DEMO_LEGENDEFF_SND_06	( SEQ_SE_DP_CLIMAX15 )		// vV[




//-----------------------------------------------------------------------------
/**
 * 
 *			yfp[Vu[ݒ֐z
 * 
 */
//-----------------------------------------------------------------------------
#define FLD_DEMO_MOTIONBL_DRAWDATA_SETUP_TCB_PRI (1024)
//-------------------------------------
//	V[PX
//=====================================
enum{
	FLD_DEMO_MOTIONBL_SEQ_BGINIT,
	FLD_DEMO_MOTIONBL_SEQ_BLINIT,
	FLD_DEMO_MOTIONBL_SEQ_ENDWAIT,
	FLD_DEMO_MOTIONBL_SEQ_BLEND,
	FLD_DEMO_MOTIONBL_SEQ_BGRESET,
	FLD_DEMO_MOTIONBL_SEQ_END,
};



//-------------------------------------
//	[Vu[[N
//=====================================
typedef struct {
	FIELDSYS_WORK* p_fsys;
	// ۑ̈
	GF_BGL_DISPVRAM vrambank;		// VRAMoNݒ
	// [Vu[
	MOTION_BL_PTR motion_bl;

	int eva;
	int evb;

	u32 seq;		// V[PX
} FLD_DEMO_MOTIONBL;

static void FLD_DEMO_MOTIONBL_Init( FLD_DEMO_MOTIONBL* p_data, FIELDSYS_WORK* p_fsys, int eva, int evb );
static void FLD_DEMO_MOTIONBL_Main( FLD_DEMO_MOTIONBL* p_data );
static void FLD_DEMO_MOTIONBL_EndReq( FLD_DEMO_MOTIONBL* p_data );
static u32 FLD_DEMO_MOTIONBL_GetState( const FLD_DEMO_MOTIONBL* cp_data );

static void FLD_DEMO_MOTIONBL_GetNowVramBank( GF_BGL_DISPVRAM* p_vrambank );
static void FLD_DEMO_MOTIONBL_SetUpBnk( void );
static void FLD_DEMO_MOTIONBL_SetUpBGIni( GF_BGL_INI* p_bg );
static void FLD_DEMO_MOTIONBL_SetUpBGIni_Field( GF_BGL_INI* p_bg );
static void FLD_DEMO_MOTIONBL_DeleteBGIni( GF_BGL_INI* p_bgini );
static MOTION_BL_PTR FLD_DEMO_MOTIONBL_MotionBlInit( int eva, int evb );
static void FLD_DEMO_MOTIONBL_MotionBlDelete( FLD_DEMO_MOTIONBL* p_data );
static void FLD_DEMO_MOTIONBL_SetUpDrawSystemReq( FLD_DEMO_MOTIONBL* p_data );
static void FLD_DEMO_MOTIONBL_ResetDrawSystemReq( FLD_DEMO_MOTIONBL* p_data );

static void FLD_DEMO_MOTIONBL_MotionBlDeleteTcb( TCB_PTR tcb, void* p_work );
static void FLD_DEMO_MOTIONBL_SetUpDrawSystemTCB( TCB_PTR tcb, void* p_work );
static void FLD_DEMO_MOTIONBL_ResetDrawSystemTCB( TCB_PTR tcb, void* p_work );


//----------------------------------------------------------------------------
/**
 *	@brief	[Vu[
 *
 *	@param	p_data		[N
 *	@param	p_fsys		tB[hVXe
 *	@param	eva			`悳ꂽGuhW
 *	@parem	evb			VRAM_CuhW
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_MOTIONBL_Init( FLD_DEMO_MOTIONBL* p_data, FIELDSYS_WORK* p_fsys, int eva, int evb )
{
	p_data->p_fsys = p_fsys;
	FLD_DEMO_MOTIONBL_GetNowVramBank( &p_data->vrambank );
	p_data->seq = 0;
	p_data->eva = eva;
	p_data->evb = evb;
}

//----------------------------------------------------------------------------
/**
 *	@brief	[Vu[C
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_MOTIONBL_Main( FLD_DEMO_MOTIONBL* p_data )
{
	switch( p_data->seq ){
	case FLD_DEMO_MOTIONBL_SEQ_BGINIT:
		FLD_DEMO_MOTIONBL_SetUpDrawSystemReq( p_data );
		p_data->seq++;
		break;
		
	case FLD_DEMO_MOTIONBL_SEQ_BLINIT:
		p_data->motion_bl = FLD_DEMO_MOTIONBL_MotionBlInit( p_data->eva, p_data->evb );
		p_data->seq++;
		break;
		
	case FLD_DEMO_MOTIONBL_SEQ_ENDWAIT:
		break;
		
	case FLD_DEMO_MOTIONBL_SEQ_BLEND:
		FLD_DEMO_MOTIONBL_MotionBlDelete( p_data );
		p_data->seq++;
		break;
		
	case FLD_DEMO_MOTIONBL_SEQ_BGRESET:
		FLD_DEMO_MOTIONBL_ResetDrawSystemReq( p_data );
		p_data->seq++;
		break;
		
	case FLD_DEMO_MOTIONBL_SEQ_END:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	[Vu[INGXg
 *
 *	@param	p_data	[N
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_MOTIONBL_EndReq( FLD_DEMO_MOTIONBL* p_data )
{
	GF_ASSERT( p_data->seq == FLD_DEMO_MOTIONBL_SEQ_ENDWAIT );
	p_data->seq = FLD_DEMO_MOTIONBL_SEQ_BLEND;
}

//----------------------------------------------------------------------------
/**
 *	@brief	݂̃V[PX擾
 *
 *	@param	cp_data		[N
 *
 *	@return		FLD_DEMO_MOTIONBL_SEQ_BGINIT,
 *	@return     FLD_DEMO_MOTIONBL_SEQ_BLINIT,
 *	@return     FLD_DEMO_MOTIONBL_SEQ_ENDWAIT,
 *	@return     FLD_DEMO_MOTIONBL_SEQ_BLEND,
 *	@return     FLD_DEMO_MOTIONBL_SEQ_BGRESET,
 *	@return     FLD_DEMO_MOTIONBL_SEQ_END,
 */             
//-----------------------------------------------------------------------------
static u32 FLD_DEMO_MOTIONBL_GetState( const FLD_DEMO_MOTIONBL* cp_data )
{
	return cp_data->seq;
}


//----------------------------------------------------------------------------
/**
 *			yfp[Vu[ݒ֐z
 *	@brief	VRAMoNԂ̎擾
 *
 *	@param	p_vrambank	i[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_MOTIONBL_GetNowVramBank( GF_BGL_DISPVRAM* p_vrambank )
{
	p_vrambank->main_bg			= GX_GetBankForBG();
	p_vrambank->main_bg_expltt	= GX_GetBankForBGExtPltt();
	p_vrambank->sub_bg			= GX_GetBankForSubBG();
	p_vrambank->sub_bg_expltt	= GX_GetBankForSubBGExtPltt();
	p_vrambank->main_obj		= GX_GetBankForOBJ();
	p_vrambank->main_obj_expltt	= GX_GetBankForOBJExtPltt();
	p_vrambank->sub_obj			= GX_GetBankForSubOBJ();
	p_vrambank->sub_obj_expltt	= GX_GetBankForSubOBJExtPltt();
	p_vrambank->teximage		= GX_GetBankForTex();
	p_vrambank->texpltt			= GX_GetBankForTexPltt();
}

//----------------------------------------------------------------------------
/**
 *			yfp[Vu[ݒ֐z
 *	@brief	climaxf@oNݒ
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_MOTIONBL_SetUpBnk( void )
{
	GF_BGL_DISPVRAM vramSetTable = {
		GX_VRAM_BG_32_FG,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_32_H,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
		GX_VRAM_OBJ_NONE,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_01_AB,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_0123_E			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &vramSetTable );
}	

//----------------------------------------------------------------------------
/**	
 *			yfp[Vu[ݒ֐z
 *	@brief		BGRg[쐬
 *	@param		BGRg[f[^
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_MOTIONBL_SetUpBGIni( GF_BGL_INI* p_bg )
{
	{
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS,GX_BGMODE_0,GX_BGMODE_0, GX_BG0_AS_3D
		};
		GF_BGL_InitBG(&BGsys_data);
	}

	GF_Disp_GX_VisibleControl(
		GX_PLANEMASK_BG0, VISIBLE_ON );

	{	// MAIN DISPibZ[Wj
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0x4000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_23,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( p_bg, FLD_MBGFRM_FONT, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( FLD_MBGFRM_FONT, 32, 0, USE_HEAPID );
		GF_BGL_ScrClear( p_bg, FLD_MBGFRM_FONT );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	[Vu[ԃZbgNGXg
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_MOTIONBL_SetUpDrawSystemReq( FLD_DEMO_MOTIONBL* p_data )
{
//	VIntrTCB_Add( FLD_DEMO_MOTIONBL_SetUpDrawSystemTCB, p_data, FLD_DEMO_MOTIONBL_DRAWDATA_SETUP_TCB_PRI );
	VWaitTCB_Add( FLD_DEMO_MOTIONBL_SetUpDrawSystemTCB, p_data, FLD_DEMO_MOTIONBL_DRAWDATA_SETUP_TCB_PRI );
}

//----------------------------------------------------------------------------
/**
 *	@brief	[Vu[ԃZbgNGXg
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_MOTIONBL_ResetDrawSystemReq( FLD_DEMO_MOTIONBL* p_data )
{
//	VIntrTCB_Add( FLD_DEMO_MOTIONBL_ResetDrawSystemTCB, p_data, FLD_DEMO_MOTIONBL_DRAWDATA_SETUP_TCB_PRI );
	VWaitTCB_Add( FLD_DEMO_MOTIONBL_ResetDrawSystemTCB, p_data, FLD_DEMO_MOTIONBL_DRAWDATA_SETUP_TCB_PRI );
}

//----------------------------------------------------------------------------
/**
 *			yfp[Vu[ݒ֐z
 *	@brief	`VXeݒ^XN
 *
 *	@param	tcb			^XN[N
 *	@param	p_work		[N
 *	
 *	@return	none
 *
 *	VuNԓōsȂƉʂɂ݂oƎv̂ŁA
 *	^XNŐV`ݒs
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_MOTIONBL_SetUpDrawSystemTCB( TCB_PTR tcb, void* p_work )
{
	FLD_DEMO_MOTIONBL* p_drawsys = p_work;

	// oNݒ
	FLD_DEMO_MOTIONBL_SetUpBnk();

	// BGRg[ݒ
	FLD_DEMO_MOTIONBL_DeleteBGIni(p_drawsys->p_fsys->bgl);
	FLD_DEMO_MOTIONBL_SetUpBGIni( p_drawsys->p_fsys->bgl );

	// j
	TCB_Delete( tcb );
}

//----------------------------------------------------------------------------
/**
 *			yfp[Vu[ݒ֐z
 *	@brief	`VXef[^Ƃɖ߂
 *
 *	@param	tcb		TCB[N
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_MOTIONBL_ResetDrawSystemTCB( TCB_PTR tcb, void* p_work )
{
	FLD_DEMO_MOTIONBL* p_drawsys = p_work;

	// VRAMoNݒ
	GF_Disp_SetBank( &p_drawsys->vrambank );

	// BGRg[č쐬
	FLD_DEMO_MOTIONBL_DeleteBGIni(p_drawsys->p_fsys->bgl);
	FLD_DEMO_MOTIONBL_SetUpBGIni_Field( p_drawsys->p_fsys->bgl );

	TCB_Delete( tcb );
}

//----------------------------------------------------------------------------
/**
 *			yfp[Vu[ݒ֐z
 *	@brief	BGVXe[Nj
 *
 *	@param	p_bgini		BGVXe[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_MOTIONBL_DeleteBGIni( GF_BGL_INI* p_bgini )
{
	Fieldmap_BgExit( p_bgini );
}

//----------------------------------------------------------------------------
/**
 *			yfp[Vu[ݒ֐z
 *	@brief	tB[hpGFRg[ݒ
 *	@param	BGVXe[N
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_MOTIONBL_SetUpBGIni_Field( GF_BGL_INI* p_bg )
{
	Fieldmap_BgSet( p_bg );

	GF_Disp_GX_VisibleControl(
		GX_PLANEMASK_BG0, VISIBLE_ON );
}

//----------------------------------------------------------------------------
/**
 *			yfp[Vu[ݒ֐z
 *	@brief	[Vu[
 *
 *	@param	eva		WA@ݕ`悳ꂽ
 *	@param	evb		WB@VRAMɕۑĂ
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static MOTION_BL_PTR FLD_DEMO_MOTIONBL_MotionBlInit( int eva, int evb )
{
	MOTION_BL_PTR motion_bl;
	
	// [Vu[ݒ
	{
		MOTION_BL_DATA mb = {
			GX_DISPMODE_VRAM_C,
			GX_BGMODE_0,
			GX_BG0_AS_3D,
			
			GX_CAPTURE_SIZE_256x192,
			GX_CAPTURE_MODE_AB,
			GX_CAPTURE_SRCA_2D3D,
			GX_CAPTURE_SRCB_VRAM_0x00000,
			GX_CAPTURE_DEST_VRAM_C_0x00000,
			0,
			0,
			USE_HEAPID
		};
		mb.eva = eva;
		mb.evb = evb;

		motion_bl = MOTION_BL_Init(&mb);
	}	
		

	return motion_bl;
}

//----------------------------------------------------------------------------
/**
 *			yfp[Vu[ݒ֐z
 *	@brief	[Vu[j
 *
 *	@param	data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_MOTIONBL_MotionBlDelete( FLD_DEMO_MOTIONBL* p_data )
{
//	VIntrTCB_Add( FLD_DEMO_MOTIONBL_MotionBlDeleteTcb, p_data, FLD_DEMO_MOTIONBL_DRAWDATA_SETUP_TCB_PRI );
	VWaitTCB_Add( FLD_DEMO_MOTIONBL_MotionBlDeleteTcb, p_data, FLD_DEMO_MOTIONBL_DRAWDATA_SETUP_TCB_PRI );
}

//----------------------------------------------------------------------------
/**
 *			yfp[Vu[ݒ֐z
 *	@brief	[Vu[jTCB
 *
 *	@param	tcb			TCB[N
 *	@param	p_work		[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_MOTIONBL_MotionBlDeleteTcb( TCB_PTR tcb, void* p_work )
{
	FLD_DEMO_MOTIONBL* p_data = p_work;
	
	// ɖ߂
	MOTION_BL_Delete(&p_data->motion_bl, GX_DISPMODE_GRAPHICS, GX_BGMODE_0,GX_BG0_AS_3D);
	TCB_Delete( tcb );
}

//----------------------------------------------------------------------------
/**
 *	@brief	IuWFeONOFF
 *
 *	@param	fsys	tB[hVXe
 *	@param	objid	IuWFID
 *	@param	flg		tO TRUEFOFF@FALSEFON
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_ObjShadowVanish( FIELDSYS_WORK* fsys, u32 objid, BOOL flg )
{
	FIELD_OBJ_PTR fldobj;
	fldobj = FieldOBJSys_OBJIDSearch( fsys->fldobjsys, objid );

	if( flg == TRUE ){
		FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_SHADOW_VANISH );
	}else{
		FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_SHADOW_VANISH );
	}
}





//-----------------------------------------------------------------------------
/**
 *
 *		tB[h}bv^XN
 *
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_SetFieldObjSysOfs( FIELD_OBJ_SYS_PTR fos, const VecFx32 *vec )
{
	int no = 0;
	FIELD_OBJ_PTR fldobj;

	while( FieldOBJSys_FieldOBJSearch( fos, &fldobj, &no, FLDOBJ_STA_BIT_USE ) == TRUE ){
		FieldOBJ_VecDrawOffsOutSideSet( fldobj, vec );
	}
}
static void FLDMAP_DEMO_ReSetFieldObjSysOfs( FIELD_OBJ_SYS_PTR fos )
{
	VecFx32 ofs;
	int no = 0;
	FIELD_OBJ_PTR fldobj;

	ofs.x = 0;
	ofs.y = 0;
	ofs.z = 0;
	while( FieldOBJSys_FieldOBJSearch( fos, &fldobj, &no, FLDOBJ_STA_BIT_USE ) == TRUE ){
		FieldOBJ_VecDrawOffsOutSideSet( fldobj, &ofs );
	}
}


//-------------------------------------
//	nkCxg[N
//=====================================
typedef struct {
	FLD_DEMO_SHAKE_SCRN* p_zishin;
	int wait;
	u32 last_count;
	u32 seq;
} EVENT_ZISHIN_WORK;
#define EVENT_ZISHIN_WIDTH	( FX32_CONST( 2.0f ) )
#define EVENT_ZISHIN_SHAKE_SYNC	( 1 )	// P̂̃VN
#define EVENT_ZISHIN_SHAKE_COUNT	( 16 )	// ꐔ

//----------------------------------------------------------------------------
/**
 *	@brief	nkCxgC
 */
//-----------------------------------------------------------------------------
static BOOL FLD_MAP_DEMO_ZishinEventMain( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_ZISHIN_WORK* p_work = FieldEvent_GetSpecialWork(event);

	switch( p_work->seq ){
	case 0:
		FLD_DEMO_ShakeScrn_Main( p_work->p_zishin );
		if( FLD_DEMO_ShakeScrn_EndCheck( p_work->p_zishin ) == TRUE ){
			p_work->seq ++;
		}
		break;

	case 1:
		FLD_DEMO_ShakeScrn_Free( p_work->p_zishin );	
		sys_FreeMemoryEz( p_work );
		return TRUE;
	}
	return FALSE;
}
//----------------------------------------------------------------------------
/**
 *	@brief	nkCxg
 *
 *	@param	ev	Cxg[N
 *
 *	@retval	TRUE	
 *	@retval	FALSE	s
 */
//-----------------------------------------------------------------------------
void FLD_MAP_DEMO_ZishinEventCall(GMEVENT_CONTROL *event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_ZISHIN_WORK* p_work = sys_AllocMemory( HEAPID_FIELD, sizeof(EVENT_ZISHIN_WORK) );
	memset( p_work, 0, sizeof(EVENT_ZISHIN_WORK) );

	p_work->p_zishin = FLD_DEMO_ShakeScrn_Alloc( HEAPID_FIELD );
	FLD_DEMO_ShakeScrn_Start( p_work->p_zishin, EVENT_ZISHIN_WIDTH, 0, EVENT_ZISHIN_SHAKE_SYNC, EVENT_ZISHIN_SHAKE_COUNT, fsys->camera_ptr );
	
	FieldEvent_Call( event, FLD_MAP_DEMO_ZishinEventMain, p_work );
}


// ~IVeBpnk
#define EVENT_MIO_ZISHIN_WIDTH	( FX32_CONST( 4.0f ) )
#define EVENT_MIO_ZISHIN_SHAKE_SYNC	( 1 )	// P̂̃VN
#define EVENT_MIO_ZISHIN_SHAKE_COUNT	( 24 )	// ꐔ
#define EVENT_MIO_ZISHIN_SHAKE_DIV	( 8*FX32_ONE )
#define EVENT_MIO_BGM_FADE_OUT_SYNC	( 1 )
#define EVENT_MIO_BGM_FADE_IN_SYNC	( 16 )
#define EVENT_MIO_WAIT				( 16 )

enum{
	EVENT_MIO_ZISHIN_FADEOUT,
	EVENT_MIO_ZISHIN_FADEOUT_WAIT,
	EVENT_MIO_ZISHIN_START_WAIT,
	EVENT_MIO_ZISHIN_MAIN,
	EVENT_MIO_ZISHIN_END_WAIT,
	EVENT_MIO_ZISHIN_FADEIN,
	EVENT_MIO_ZISHIN_FADEIN_WAIT,
	EVENT_MIO_ZISHIN_END,
};

static void FLD_MAP_Demo_MioZishinShakeWidthSub( EVENT_ZISHIN_WORK* p_work )
{
	fx32 width = FLD_DEMO_ShakeScrn_GetNowShakeWidth( p_work->p_zishin );
	fx32 set_width;
	u32 count = FLD_DEMO_ShakeScrn_GetNowCount( p_work->p_zishin );

	if( p_work->last_count != count ){
		p_work->last_count = count;

		set_width = FX_Div( width, EVENT_MIO_ZISHIN_SHAKE_DIV );
		set_width = width - set_width;
		FLD_DEMO_ShakeScrn_SetNowShakeWidth( p_work->p_zishin, set_width );
	}
}
//----------------------------------------------------------------------------
/**
 *	@brief	nkCxgC
 */
//-----------------------------------------------------------------------------
static BOOL FLD_MAP_DEMO_MioZishinEventMain( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_ZISHIN_WORK* p_work = FieldEvent_GetSpecialWork(event);

	switch( p_work->seq ){
	case EVENT_MIO_ZISHIN_FADEOUT:		// BGMtF[hAEgiuj
		Snd_BgmFadeOut( 0, EVENT_MIO_BGM_FADE_OUT_SYNC );
		p_work->seq ++;
		break;

	case EVENT_MIO_ZISHIN_FADEOUT_WAIT:
		if( Snd_FadeCheck() == 0 ){
			p_work->seq ++;
			p_work->wait = EVENT_MIO_WAIT;
		}
		break;

	case EVENT_MIO_ZISHIN_START_WAIT:
		p_work->wait --;
		if( p_work->wait <= 0 ){
			p_work->seq ++;	
			Snd_SePlay(	SE_SHAKE );		// ꉹJn
		}
		break;
	
	case EVENT_MIO_ZISHIN_MAIN:
		FLD_DEMO_ShakeScrn_Main( p_work->p_zishin );
		// ꐔςꕝ炷
		FLD_MAP_Demo_MioZishinShakeWidthSub( p_work );
		if( FLD_DEMO_ShakeScrn_EndCheck( p_work->p_zishin ) == TRUE ){
			Snd_SeStopBySeqNo( SE_SHAKE, 0 );	// ꉹ~
			p_work->seq ++;
			p_work->wait = EVENT_MIO_WAIT;
		}
		break;

	case EVENT_MIO_ZISHIN_END_WAIT:
		p_work->wait --;
		if( p_work->wait <= 0 ){
			p_work->seq ++;
		}
		break;

	case EVENT_MIO_ZISHIN_FADEIN:
		Snd_BgmFadeIn( BGM_VOL_MAX, EVENT_MIO_BGM_FADE_IN_SYNC, BGM_FADEIN_START_VOL_MIN );
		p_work->seq ++;
		break;

	case EVENT_MIO_ZISHIN_FADEIN_WAIT:
		if( Snd_FadeCheck() == 0 ){
			p_work->seq ++;
		}
		break;

	case EVENT_MIO_ZISHIN_END:
		FLD_DEMO_ShakeScrn_Free( p_work->p_zishin );	
		sys_FreeMemoryEz( p_work );
		return TRUE;
	}
	return FALSE;
}
//----------------------------------------------------------------------------
/**
 *	@brief	nkCxg
 *
 *	@param	ev	Cxg[N
 *
 *	@retval	TRUE	
 *	@retval	FALSE	s
 */
//-----------------------------------------------------------------------------
void FLD_MAP_DEMO_MioZishinEventCall(GMEVENT_CONTROL *event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_ZISHIN_WORK* p_work = sys_AllocMemory( HEAPID_FIELD, sizeof(EVENT_ZISHIN_WORK) );
	memset( p_work, 0, sizeof(EVENT_ZISHIN_WORK) );

	p_work->p_zishin = FLD_DEMO_ShakeScrn_Alloc( HEAPID_FIELD );
	FLD_DEMO_ShakeScrn_Start( p_work->p_zishin, EVENT_MIO_ZISHIN_WIDTH, 0, EVENT_MIO_ZISHIN_SHAKE_SYNC, EVENT_MIO_ZISHIN_SHAKE_COUNT, fsys->camera_ptr );
	
	// cꐔݒ
	p_work->last_count = FLD_DEMO_ShakeScrn_GetNowCount( p_work->p_zishin );
	FieldEvent_Call( event, FLD_MAP_DEMO_MioZishinEventMain, p_work );
}



//-----------------------------------------------------------------------------
/**
 *		`|Po
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	`|PoV[PX
//=====================================
enum{
	FLDMAP_DEMO_LEGEND_MOTION_BP_SET,
	FLDMAP_DEMO_LEGEND_MOTION_BP_SET_WAIT,
	FLDMAP_DEMO_LEGEND_START,
	FLDMAP_DEMO_LEGEND_EFF_WAIT,
	FLDMAP_DEMO_LEGEND_END_WAIT,
	FLDMAP_DEMO_LEGEND_FLASH,
	FLDMAP_DEMO_LEGEND_MOTION_BP_END,
	FLDMAP_DEMO_LEGEND_MOTION_BP_END_WAIT,
	FLDMAP_DEMO_LEGEND_ARITAMA_ON,
	FLDMAP_DEMO_LEGEND_ARITAMA_SHADOWOFF_WAIT,
	FLDMAP_DEMO_LEGEND_ARITAMA_WAIT,
	FLDMAP_DEMO_LEGEND_END,
};
#define FLDMAP_DEMO_LEGEND_TASK_PRI	( 1024 )
#define FLDMAP_DEMO_LEGEND_OBJID	( D05R0114_SPPOKE_01 )	// oCAGÅǗID
#define FLDMAP_DEMO_LEGEND_EFFSTART	( 240 )		// GtFNgJn

//-------------------------------------
//	΂΂΁`@tbV
//=====================================
typedef struct {
	u32 seq;
	s32 wait;
	FLD_DEMO_FLASH* p_flash;			// FLDMAP_DEMO_LEGEND炤
} FLDMAP_DEMO_LEGEND_BANBANFLASH;
enum{
	FLD_DEMO_LEGEND_BANBANFLASH_FLASHWAIT,
	FLD_DEMO_LEGEND_BANBANFLASH_FLASH00,
	FLD_DEMO_LEGEND_BANBANFLASH_FLASH01,
	FLD_DEMO_LEGEND_BANBANFLASH_FLASH02,
	FLD_DEMO_LEGEND_BANBANFLASH_END,
};

// vg^Cv
static void FLDMAP_DEMO_LegendPokeApp_Eff_BanBanFlash_Init( FLDMAP_DEMO_LEGEND_BANBANFLASH* p_eff, FLD_DEMO_FLASH* p_flash );
static BOOL FLDMAP_DEMO_LegendPokeApp_Eff_BanBanFlash_Main( FLDMAP_DEMO_LEGEND_BANBANFLASH* p_eff );


//-------------------------------------
//	ʗh炵tbVGtFNg
//=====================================
typedef struct {
	u32 seq;
	s32 wait;
	FLD_DEMO_SHAKE_SCRN* p_shake;		// FLDMAP_DEMO_LEGEND炤
	FLD_DEMO_FLASH* p_flash;			// FLDMAP_DEMO_LEGEND炤
	GF_CAMERA_PTR copy_camera;			// J
} FLDMAP_DEMO_LEGEND_SHAKEFLASH;
// V[PX
enum{
	FLD_DEMO_LEGEND_SHAKEFLASH_START,
	FLD_DEMO_LEGEND_SHAKEFLASH_FLASH00,
	FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE_FLASH00,
	FLD_DEMO_LEGEND_SHAKEFLASH_FLASH01,
	FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE00,
	FLD_DEMO_LEGEND_SHAKEFLASH_FLASH02,
	FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE_FLASH01,
	FLD_DEMO_LEGEND_SHAKEFLASH_END,
};
#define FLD_DEMO_LEGEND_SHAKEFLASH_ALPHAMAX	( 13 )	// ől

#define FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE_X	( FX32_CONST( 2.0f ) )	// ꕝ
#define FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE_SYNC	( 1 )	// P̂̃VN
#define FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE_COUNT	( 8 )	// ꐔ

#define FLD_DEMO_LEGEND_SHAKEFLASH_FLASH00_WAIT	( 0 )	// EGCg
#define FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE_FLASH00_WAIT	( 80 )	// EGCg
#define FLD_DEMO_LEGEND_SHAKEFLASH_FLASH01_WAIT	( 32 )	// EGCg
#define FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE00_WAIT	( 60 )	// EGCg
#define FLD_DEMO_LEGEND_SHAKEFLASH_FLASH02_WAIT	( 60 )	// EGCg
#define FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE_FLASH01_WAIT	( 40 )	// EGCg

#define FLD_DEMO_LEGEND_BANBAN_START_WAIT	( 32 )

#define FLD_DEMO_LEGEND_SHADOW_OFF_WAIT	( 72 )

// vg^Cv
static void FLDMAP_DEMO_LegendPokeApp_Eff_ShakeFlash_Init( FLDMAP_DEMO_LEGEND_SHAKEFLASH* p_eff, FLD_DEMO_SHAKE_SCRN* p_shake, FLD_DEMO_FLASH* p_flash, GF_CAMERA_PTR copy_camera );
static BOOL FLDMAP_DEMO_LegendPokeApp_Eff_ShakeFlash_Main( FLDMAP_DEMO_LEGEND_SHAKEFLASH* p_eff );

//-------------------------------------
//	`|Po[N
//=====================================
typedef struct {
	u32 seq;		// V[PX
	s32 count;		// ėp
	
	FLD_DEMO_MOTIONBL motion_bl;		// [Vu[

	FLD_DEMO_LEGENDPOKE_APP* p_legend;
	FLD_DEMO_SHAKE_SCRN* p_shake;
	FLD_DEMO_FLASH* p_flash;
	FLD_DEMO_ARITAMA_START* p_aritama;	// A̗Jn

	FLDMAP_DEMO_LEGEND_SHAKEFLASH shakeflash;	// tbVRg[
	FLDMAP_DEMO_LEGEND_BANBANFLASH banbanflash;	// ΂΂΁`tbV
} FLDMAP_DEMO_LEGEND;

#define FLD_DEMO_LEGEND_MOTIONBL_EVA	( 8 )
#define FLD_DEMO_LEGEND_MOTIONBL_EVB	( 8 )

//----------------------------------------------------------------------------
/**
 *		y`|Poz
 *	@brief	
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_LegendPokeApp_Init(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_LEGEND* p_lgd = p_work;

	memset( p_lgd, 0, sizeof(FLDMAP_DEMO_LEGEND) );

	//	CAGAo
	p_lgd->p_legend = FLD_DEMO_LegendPokeApp_Alloc( USE_HEAPID, p_fsys );
	// nk
	p_lgd->p_shake = FLD_DEMO_ShakeScrn_Alloc( USE_HEAPID );
	// tbV
	p_lgd->p_flash = FLD_DEMO_Flash_Alloc( USE_HEAPID );
	// V[PX
	p_lgd->seq = 0;

#ifdef FIELD_DEMO_DEBUG
	FieldDemoDebugStart();
#endif
}

//----------------------------------------------------------------------------
/**
 *		y`|Poz
 *	@brief	j
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_LegendPokeApp_Delete(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_LEGEND* p_lgd = p_work;

	// CAGAo
	FLD_DEMO_LegendPokeApp_Free( p_lgd->p_legend );
	// A̗
	FLD_DEMO_AriTamaStart_Free( p_lgd->p_aritama );
	// nk
	FLD_DEMO_ShakeScrn_Free( p_lgd->p_shake );
	// tbV
	FLD_DEMO_Flash_Free( p_lgd->p_flash );

#ifdef FIELD_DEMO_DEBUG
	FieldDemoDebugEnd();
#endif
}

//----------------------------------------------------------------------------
/**
 *		y`|Poz
 *	@brief	C
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_LegendPokeApp_Main(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_LEGEND* p_lgd = p_work;
	BOOL check[2];
	BOOL result;

#ifdef FIELD_DEMO_DEBUG
	if( FIELD_DEMO_DEBUG_STOP == 1 ){
		return ;
	}
#endif
	
	// ̕
	switch( p_lgd->seq ){
	case FLDMAP_DEMO_LEGEND_MOTION_BP_SET:	// [Vu[ݒ
		FLD_DEMO_MOTIONBL_Init( &p_lgd->motion_bl, p_fsys, FLD_DEMO_LEGEND_MOTIONBL_EVA, FLD_DEMO_LEGEND_MOTIONBL_EVB );
		
		p_lgd->seq ++;
		break;

	case FLDMAP_DEMO_LEGEND_MOTION_BP_SET_WAIT:
		FLD_DEMO_MOTIONBL_Main( &p_lgd->motion_bl );
		if( FLD_DEMO_MOTIONBL_GetState( &p_lgd->motion_bl ) == FLD_DEMO_MOTIONBL_SEQ_ENDWAIT ){
			p_lgd->seq ++;
		}
		break;

	case FLDMAP_DEMO_LEGEND_START:
		FLD_DEMO_LegendPokeApp_Start( p_lgd->p_legend, FLDMAP_DEMO_LEGEND_OBJID );
		p_lgd->count = FLDMAP_DEMO_LEGEND_EFFSTART;
		p_lgd->seq ++;
		break;

	case FLDMAP_DEMO_LEGEND_EFF_WAIT:
		p_lgd->count--;
		if( p_lgd->count < 0 ){
			FLDMAP_DEMO_LegendPokeApp_Eff_ShakeFlash_Init( &p_lgd->shakeflash, p_lgd->p_shake, p_lgd->p_flash, p_fsys->camera_ptr );
			p_lgd->seq++;
		}
		break;

	case FLDMAP_DEMO_LEGEND_END_WAIT:
		check[0] = FLDMAP_DEMO_LegendPokeApp_Eff_ShakeFlash_Main( &p_lgd->shakeflash );
		check[1] = FLD_DEMO_LegendPokeApp_EndCheck( p_lgd->p_legend );
		// 암
		if( (check[0] == TRUE) && (check[1] == TRUE) ){
			FLDMAP_DEMO_LegendPokeApp_Eff_BanBanFlash_Init( &p_lgd->banbanflash, p_lgd->p_flash );
			p_lgd->seq++;
		}
		break;

	case FLDMAP_DEMO_LEGEND_FLASH:
		check[0] = FLDMAP_DEMO_LegendPokeApp_Eff_BanBanFlash_Main( &p_lgd->banbanflash );

		// ^Ԃł̗ǂݍ
		// eNX`TCY傫Aʂɉeł邽
		if( p_lgd->banbanflash.seq == FLD_DEMO_LEGEND_BANBANFLASH_FLASH02 ){
			if( FLD_DEMO_Flash_GetAlpha( p_lgd->banbanflash.p_flash ) == FLD_DEMO_LEGEND_SHAKEFLASH_ALPHAMAX ){
				// A̗
				p_lgd->p_aritama = FLD_DEMO_AriTamaStart_Alloc( USE_HEAPID, p_fsys );
			}
		}
		
		if( check[0] == TRUE ){
			p_lgd->seq++;
		}
		break;

	case FLDMAP_DEMO_LEGEND_MOTION_BP_END:	// [Vu[j
		FLD_DEMO_MOTIONBL_EndReq( &p_lgd->motion_bl );
		p_lgd->seq ++;
		break;

	case FLDMAP_DEMO_LEGEND_MOTION_BP_END_WAIT:
		FLD_DEMO_MOTIONBL_Main( &p_lgd->motion_bl );

		if( FLD_DEMO_MOTIONBL_GetState( &p_lgd->motion_bl ) == FLD_DEMO_MOTIONBL_SEQ_END ){
			p_lgd->seq ++;
		}
		break;

	case FLDMAP_DEMO_LEGEND_ARITAMA_ON:
		FLD_DEMO_AriTamaStart_Start( p_lgd->p_aritama, FLDMAP_DEMO_LEGEND_OBJID );
		p_lgd->count = FLD_DEMO_LEGEND_SHADOW_OFF_WAIT;
		p_lgd->seq ++;
		break;

	case FLDMAP_DEMO_LEGEND_ARITAMA_SHADOWOFF_WAIT:
		p_lgd->count --;
		if( p_lgd->count <= 0 ){	
			FLD_DEMO_ObjShadowVanish( p_fsys, FLDMAP_DEMO_LEGEND_OBJID, TRUE );
			p_lgd->seq ++;
		}

	case FLDMAP_DEMO_LEGEND_ARITAMA_WAIT:
		result = FLD_DEMO_AriTamaStart_Main( p_lgd->p_aritama );
		if( result == TRUE ){

			FLD_DEMO_ObjShadowVanish( p_fsys, FLDMAP_DEMO_LEGEND_OBJID, FALSE );
			p_lgd->seq ++;
		}
		break;
		
	case FLDMAP_DEMO_LEGEND_END:
		break;


	default:
		break;
	}
	
	FLD_DEMO_LegendPokeApp_Main( p_lgd->p_legend );
	FLD_DEMO_ShakeScrn_Main( p_lgd->p_shake );
	FLD_DEMO_Flash_Main( p_lgd->p_flash );
}

//----------------------------------------------------------------------------
/**
 *		y`|Poz
 *	@brief	`揈
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_LegendPokeApp_Draw(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_LEGEND* p_lgd = p_work;

	FLD_DEMO_LegendPokeApp_Draw( p_lgd->p_legend );
	if( p_lgd->p_aritama ){
		FLD_DEMO_AriTamaStart_Draw( p_lgd->p_aritama );
	}
}

//----------------------------------------------------------------------------
/**
 *		y`|Poz
 *	@brief	`|Po@fJn
 *
 *	@param	fsys	tB[hVXe[N
 *
 *	@return	f[N
 */
//-----------------------------------------------------------------------------
FLDMAPFUNC_WORK* FLDMAP_DEMO_LegendPokeApp_Start( FIELDSYS_WORK* fsys )
{
	static const FLDMAPFUNC_DATA FLDMAP_DEMO_LegendPokeAppData = {
		FLDMAP_DEMO_LEGEND_TASK_PRI,
		sizeof(FLDMAP_DEMO_LEGEND),
		FLDMAP_DEMO_LegendPokeApp_Init,
		FLDMAP_DEMO_LegendPokeApp_Delete,
		FLDMAP_DEMO_LegendPokeApp_Main,
		FLDMAP_DEMO_LegendPokeApp_Draw
	};
	FLDMAPFUNC_WORK* p_fwk;
	
	p_fwk = FLDMAPFUNC_Create( fsys->fldmap->fmapfunc_sys, &FLDMAP_DEMO_LegendPokeAppData );
	return p_fwk;
}

//----------------------------------------------------------------------------
/**
 *		y`|Poz
 *	@brief	`|Po	fI
 *
 *	@param	p_demo	f[N
 *
 *	@return	none
 */	
//-----------------------------------------------------------------------------
void FLDMAP_DEMO_LegendPokeApp_End( FLDMAPFUNC_WORK* p_demo )
{
	FLDMAPFUNC_Delete( p_demo );
}

//----------------------------------------------------------------------------
/**
 *		y`|Poz
 *	@brief	fI`FbN
 *
 *	@param	p_demo 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
BOOL FLDMAP_DEMO_LegendPokeApp_EndCheck( FLDMAPFUNC_WORK* p_demo )
{
	FLDMAP_DEMO_LEGEND* p_lgd = FLDMAPFUNC_GetFreeWork( p_demo );
	if( p_lgd->seq == FLDMAP_DEMO_LEGEND_END ){
		return TRUE;
	}
	return FALSE;
}



//----------------------------------------------------------------------------
/**
 *		y`|Poz
 *	@brief	h炵tbV	
 *
 *	@param	p_eff		GtFNg[N
 *	@param	p_shake		h炵IuWF
 *	@param	p_flash		tbVIuWF
 *	@param	copy_camera	J
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_LegendPokeApp_Eff_ShakeFlash_Init( FLDMAP_DEMO_LEGEND_SHAKEFLASH* p_eff, FLD_DEMO_SHAKE_SCRN* p_shake, FLD_DEMO_FLASH* p_flash, GF_CAMERA_PTR copy_camera )
{
	p_eff->seq	= 0;
	p_eff->wait = 0; 
	p_eff->p_shake = p_shake;
	p_eff->p_flash = p_flash;
	p_eff->copy_camera = copy_camera;
}

//----------------------------------------------------------------------------
/**
 *		y`|Poz
 *	@brief	h炵tbV	C
 *
 *	@param	p_eff	GtFNg[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL FLDMAP_DEMO_LegendPokeApp_Eff_ShakeFlash_Main( FLDMAP_DEMO_LEGEND_SHAKEFLASH* p_eff )
{
	switch( p_eff->seq ){
	case FLD_DEMO_LEGEND_SHAKEFLASH_START:
		p_eff->wait = FLD_DEMO_LEGEND_SHAKEFLASH_FLASH00_WAIT;
		p_eff->seq++;
		break;
		
	case FLD_DEMO_LEGEND_SHAKEFLASH_FLASH00:
		p_eff->wait --;
		if( p_eff->wait < 0 ){
			FLD_DEMO_Flash_Start( p_eff->p_flash, FLD_DEMO_LEGEND_SHAKEFLASH_ALPHAMAX, 4, 16 );
			p_eff->seq++;
			p_eff->wait = FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE_FLASH00_WAIT;
		}
		break;
		
	case FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE_FLASH00:
		p_eff->wait --;
		if( p_eff->wait < 0 ){
			FLD_DEMO_Flash_Start( p_eff->p_flash, FLD_DEMO_LEGEND_SHAKEFLASH_ALPHAMAX, 4, 24 );
			FLD_DEMO_ShakeScrn_Start( p_eff->p_shake, FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE_X, 0, FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE_SYNC, FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE_COUNT, p_eff->copy_camera );
			p_eff->seq++;
			p_eff->wait = FLD_DEMO_LEGEND_SHAKEFLASH_FLASH01_WAIT;
		}
		break;

	case FLD_DEMO_LEGEND_SHAKEFLASH_FLASH01:
		p_eff->wait --;
		if( p_eff->wait < 0 ){
			FLD_DEMO_Flash_Start( p_eff->p_flash, FLD_DEMO_LEGEND_SHAKEFLASH_ALPHAMAX, 4, 27 );
			p_eff->seq++;
			p_eff->wait = FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE00_WAIT;
		}
		break;

	case FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE00:
		p_eff->wait --;
		if( p_eff->wait < 0 ){
			FLD_DEMO_ShakeScrn_Start( p_eff->p_shake, 3*FX32_ONE, 0, FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE_SYNC, 10, p_eff->copy_camera );
			p_eff->seq++;
			p_eff->wait = FLD_DEMO_LEGEND_SHAKEFLASH_FLASH02_WAIT;
		}
		break;

	case FLD_DEMO_LEGEND_SHAKEFLASH_FLASH02:
		p_eff->wait --;
		if( p_eff->wait < 0 ){
			FLD_DEMO_Flash_Start( p_eff->p_flash, FLD_DEMO_LEGEND_SHAKEFLASH_ALPHAMAX, 8, 32 );
			p_eff->seq++;
			p_eff->wait = FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE_FLASH01_WAIT;
		}
		break;
		
	case FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE_FLASH01:
		p_eff->wait --;
		if( p_eff->wait < 0 ){
			FLD_DEMO_Flash_Start( p_eff->p_flash, FLD_DEMO_LEGEND_SHAKEFLASH_ALPHAMAX, 4, 16 );
			FLD_DEMO_ShakeScrn_Start( p_eff->p_shake, 4*FX32_ONE, 0, FLD_DEMO_LEGEND_SHAKEFLASH_SHAKE_SYNC, 12, p_eff->copy_camera );
			p_eff->seq++;
		}
		break;
		
	case FLD_DEMO_LEGEND_SHAKEFLASH_END:
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *		y`|Poz
 *	@brief	ootbV	
 *
 *	@param	p_eff		GtFNg[N
 *	@param	p_flash		tbVIuWF
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_LegendPokeApp_Eff_BanBanFlash_Init( FLDMAP_DEMO_LEGEND_BANBANFLASH* p_eff, FLD_DEMO_FLASH* p_flash )
{
	p_eff->seq	= 0;
	p_eff->wait = FLD_DEMO_LEGEND_BANBAN_START_WAIT; 
	p_eff->p_flash = p_flash;
}

//----------------------------------------------------------------------------
/**
 *		y`|Poz
 *	@brief	ootbV	C
 *
 *	@param	p_eff	GtFNg[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL FLDMAP_DEMO_LegendPokeApp_Eff_BanBanFlash_Main( FLDMAP_DEMO_LEGEND_BANBANFLASH* p_eff )
{
	switch( p_eff->seq ){
	case FLD_DEMO_LEGEND_BANBANFLASH_FLASHWAIT:
		p_eff->wait --;
		if( p_eff->wait < 0 ){
			p_eff->seq ++;
		}
		break;

	case FLD_DEMO_LEGEND_BANBANFLASH_FLASH00:
		FLD_DEMO_Flash_Start( p_eff->p_flash, FLD_DEMO_LEGEND_SHAKEFLASH_ALPHAMAX, 4, 8 );
		p_eff->seq++;
		p_eff->wait = 16;
		break;
		
	case FLD_DEMO_LEGEND_BANBANFLASH_FLASH01:
		p_eff->wait --;
		
		if( p_eff->wait < 0 ){
			FLD_DEMO_Flash_Start( p_eff->p_flash, FLD_DEMO_LEGEND_SHAKEFLASH_ALPHAMAX, 4, 8 );
			p_eff->seq++;
			p_eff->wait = 16;
		}
		break;
		
	case FLD_DEMO_LEGEND_BANBANFLASH_FLASH02:
		p_eff->wait --;
		
		if( p_eff->wait < 0 ){
			FLD_DEMO_Flash_Start( p_eff->p_flash, FLD_DEMO_LEGEND_SHAKEFLASH_ALPHAMAX, 4, 32 );
			p_eff->seq++;
			p_eff->wait = 40;
		}
		break;
		
	case FLD_DEMO_LEGEND_BANBANFLASH_END:
		p_eff->wait --;
		if( p_eff->wait < 0 ){
			return TRUE;
		}
		break;
	}

	return FALSE;
}





//-----------------------------------------------------------------------------
/**
 * 
 *		bJo
 * 
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	bJoV[PX
//=====================================
enum{
	FLDMAP_DEMO_BLACKRING_END,
};
#define FLDMAP_DEMO_BLACKRING_TASK_PRI	( 1024 )
#define FLDMAP_DEMO_BLACKRING_OBJID	( D05R0114_SPPOKE_01 )	// oCAGÅǗID

//-------------------------------------
//	bJo[N
//=====================================
typedef struct {
	FLD_DEMO_BLACK_RING* p_blackring;
} FLDMAP_DEMO_BLACKRING;

//----------------------------------------------------------------------------
/**
 *		ybJoz
 *	@brief	
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_BlackRing_Init(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_BLACKRING* p_br = p_work;
	FIELD_OBJ_PTR fldobj;
	u16 x, y, z;
	
	// CAGA߂
	fldobj = FieldOBJSys_OBJIDSearch( p_fsys->fldobjsys, FLDMAP_DEMO_BLACKRING_OBJID );
	GF_ASSERT( fldobj );
	x = FieldOBJ_NowPosGX_Get( fldobj );
	y = 0;	// 0
	z = FieldOBJ_NowPosGZ_Get( fldobj );

	// bJ
	p_br->p_blackring = FLD_DEMO_BlackRing_Alloc( USE_HEAPID );

	// Ringo
	FLD_DEMO_BlackRing_Start( p_br->p_blackring, x, y, z );
}

//----------------------------------------------------------------------------
/**
 *		ybJoz
 *	@brief	j
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_BlackRing_Delete(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_BLACKRING* p_br = p_work;
	
	// bJ
	FLD_DEMO_BlackRing_Free( p_br->p_blackring );
}

//----------------------------------------------------------------------------
/**
 *		ybJoz
 *	@brief	C
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_BlackRing_Main(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_BLACKRING* p_br = p_work;

	// bJC
	FLD_DEMO_BlackRing_Main( p_br->p_blackring );
}

//----------------------------------------------------------------------------
/**
 *		ybJoz
 *	@brief	`揈
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_BlackRing_Draw(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_BLACKRING* p_br = p_work;

	// bJ`
	FLD_DEMO_BlackRing_Draw( p_br->p_blackring );
}

//----------------------------------------------------------------------------
/**
 *	@brief	bJo@fJn
 *
 *	@param	fsys	tB[hVXe[N
 *
 *	@return	f[N
 */
//-----------------------------------------------------------------------------
FLDMAPFUNC_WORK* FLDMAP_DEMO_BlackRing_Start( FIELDSYS_WORK* fsys )
{
	static const FLDMAPFUNC_DATA FLDMAP_DEMO_Data = {
		FLDMAP_DEMO_BLACKRING_TASK_PRI,
		sizeof(FLDMAP_DEMO_BLACKRING),
		FLDMAP_DEMO_BlackRing_Init,
		FLDMAP_DEMO_BlackRing_Delete,
		FLDMAP_DEMO_BlackRing_Main,
		FLDMAP_DEMO_BlackRing_Draw
	};
	FLDMAPFUNC_WORK* p_fwk;
	p_fwk = FLDMAPFUNC_Create( fsys->fldmap->fmapfunc_sys, &FLDMAP_DEMO_Data );
	return p_fwk;
}

//----------------------------------------------------------------------------
/**
 *	@brief	bJo@fI
 *
 *	@param	p_demo [N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLDMAP_DEMO_BlackRing_End( FLDMAPFUNC_WORK* p_demo )
{
	FLDMAPFUNC_Delete( p_demo );
}

//-----------------------------------------------------------------------------
/**
 * 
 *		̗
 * 
 */
//-----------------------------------------------------------------------------
#define FLDMAP_DEMO_ANTEGG_TASK_PRI	( 1024 )

//-------------------------------------
//	̗[N
//=====================================
typedef struct {
	u32 seq;		// V[PX
	FLD_DEMO_ANTEGG* p_antegg;
	FLD_DEMO_BLACK_RING* p_blackring;
} FLDMAP_DEMO_ANTEGG;

//----------------------------------------------------------------------------
/**
 *		y̗z
 *	@brief	
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_AntEggCut00_Init(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_ANTEGG* p_dwk = p_work;
	VecFx32 matrix;
	CAMERA_ANGLE angle;

#if ( PM_VERSION == VERSION_DIAMOND )

	// Jp[^ݒ
	GFC_SetCameraPerspWay( 0x1701, p_fsys->camera_ptr );	
	GFC_SetCameraDistance( 0xc8a55, p_fsys->camera_ptr );
	matrix.x = 0x2280ef;
	matrix.y = 0xca424;
	matrix.z = 0x268c50;
	GFC_SetLookTarget( &matrix, p_fsys->camera_ptr );
	angle.x = 0x22a2;
	angle.y = 0xf800;
	angle.z = 0;
	GFC_SetCameraAngleRev( &angle, p_fsys->camera_ptr );

	GFC_SetCameraClip( 2*FX32_ONE, 2000*FX32_ONE, p_fsys->camera_ptr );

#elif( PM_VERSION == VERSION_PEARL )

	// Jp[^ݒ
	GFC_SetCameraPerspWay( 0x10c1, p_fsys->camera_ptr );	
	GFC_SetCameraDistance( 0xD5052, p_fsys->camera_ptr );
	matrix.x = 0x1bffbd;
	matrix.y = 0xaa361;
	matrix.z = 0x25dfdc;
	GFC_SetLookTarget( &matrix, p_fsys->camera_ptr );
	angle.x = 0x19a3;
	angle.y = 0x90c;
	angle.z = 0;
	GFC_SetCameraAngleRev( &angle, p_fsys->camera_ptr );

	GFC_SetCameraClip( 14*FX32_ONE, 2031*FX32_ONE, p_fsys->camera_ptr );

#endif


	p_dwk->p_antegg = FLD_DEMO_AntEgg_Cut_Alloc( USE_HEAPID );
	p_dwk->p_blackring = FLD_DEMO_BlackRing_AntEggCat_Alloc( USE_HEAPID );
	matrix = GFC_GetLookTarget( p_fsys->camera_ptr );
	FLD_DEMO_AntEgg_Cut00_Start( p_dwk->p_antegg, matrix.x, matrix.y, matrix.z );
	FLD_DEMO_BlackRing_AntEggCat00_Start( p_dwk->p_blackring, matrix.x, matrix.y, matrix.z );
}
static void FLDMAP_DEMO_AntEggCut01_Init(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_ANTEGG* p_dwk = p_work;
	VecFx32 matrix;
	CAMERA_ANGLE angle;

	// Jp[^ݒ
	GFC_SetCameraPerspWay( 0xf81, p_fsys->camera_ptr );	
	GFC_SetCameraDistance( 0x17e532, p_fsys->camera_ptr );
	matrix.x = 0xf99d58;
	matrix.y = 0xc5502;
	matrix.z = 0x28cf549;
	GFC_SetLookTarget( &matrix, p_fsys->camera_ptr );
	angle.x = 0x642;
	angle.y = 0xeda0;
	angle.z = 0;
	GFC_SetCameraAngleRev( &angle, p_fsys->camera_ptr );
	GFC_SetCameraClip( 88*FX32_ONE, 2000*FX32_ONE, p_fsys->camera_ptr );

	// LIGHTݒύX
	DellLightCont( &p_fsys->light_cont_data );
	p_fsys->light_cont_data = InitLightCont( p_fsys->glst_data, LIGHT_TYPE3 );

	p_dwk->p_antegg = FLD_DEMO_AntEgg_Cut_Alloc( USE_HEAPID );
	p_dwk->p_blackring = FLD_DEMO_BlackRing_AntEggCat_Alloc( USE_HEAPID );
	matrix = GFC_GetLookTarget( p_fsys->camera_ptr );
	FLD_DEMO_AntEgg_Cut01_Start( p_dwk->p_antegg, matrix.x, matrix.y, matrix.z );
	FLD_DEMO_BlackRing_AntEggCat01_Start( p_dwk->p_blackring, matrix.x, matrix.y, matrix.z );
}
static void FLDMAP_DEMO_AntEggCut02_Init(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_ANTEGG* p_dwk = p_work;
	VecFx32 matrix;
	CAMERA_ANGLE angle;

	// Jp[^ݒ
	GFC_SetCameraPerspWay( 0x4c1, p_fsys->camera_ptr );	
	GFC_SetCameraDistance( 0x26bec1, p_fsys->camera_ptr );
	matrix.x = 0x1df5dfd;
	matrix.y = 0x73a0c;
	matrix.z = 0x2b9f4a2;
	GFC_SetLookTarget( &matrix, p_fsys->camera_ptr );
	angle.x = 0x4c2;
	angle.y = 0xa40;
	angle.z = 0;
	GFC_SetCameraAngleRev( &angle, p_fsys->camera_ptr );

	GFC_SetCameraClip( 176*FX32_ONE, 1480*FX32_ONE, p_fsys->camera_ptr );


	// LIGHTݒύX
	DellLightCont( &p_fsys->light_cont_data );
	p_fsys->light_cont_data = InitLightCont( p_fsys->glst_data, LIGHT_TYPE3 );

	p_dwk->p_antegg = FLD_DEMO_AntEgg_Cut_Alloc( USE_HEAPID );
	p_dwk->p_blackring = FLD_DEMO_BlackRing_AntEggCat_Alloc( USE_HEAPID );
	matrix = GFC_GetLookTarget( p_fsys->camera_ptr );
	FLD_DEMO_AntEgg_Cut02_Start( p_dwk->p_antegg, matrix.x, matrix.y, matrix.z );
	FLD_DEMO_BlackRing_AntEggCat02_Start( p_dwk->p_blackring, matrix.x, matrix.y, matrix.z );
}

//----------------------------------------------------------------------------
/**
 *		y̗z
 *	@brief	j
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_AntEgg_Delete(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_ANTEGG* p_dwk = p_work;

	FLD_DEMO_AntEgg_Cut_Free( p_dwk->p_antegg );
	FLD_DEMO_BlackRing_AntEggCat_Free( p_dwk->p_blackring );
}

//----------------------------------------------------------------------------
/**
 *		y̗z
 *	@brief	C
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_AntEgg_Main(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_ANTEGG* p_dwk = p_work;

	FLD_DEMO_AntEgg_Cut_Main( p_dwk->p_antegg );
	FLD_DEMO_BlackRing_AntEggCat_Main( p_dwk->p_blackring );
}

//----------------------------------------------------------------------------
/**
 *		y̗z
 *	@brief	`揈
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_AntEgg_Draw(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_ANTEGG* p_dwk = p_work;

	FLD_DEMO_AntEgg_Cut_Draw( p_dwk->p_antegg );
	FLD_DEMO_BlackRing_AntEggCat_Draw( p_dwk->p_blackring );
}

//----------------------------------------------------------------------------
/**
 *	@brief	̗@fJn
 *
 *	@param	fsys		tB[hVXe[N
 *	@param	cut			Jbg
 *
 *	@return	f[N
 *
 *	FLDMAP_DEMO_ANTEGG_CUT00		Jbg00
 *	FLDMAP_DEMO_ANTEGG_CUT01		Jbg01
 *	FLDMAP_DEMO_ANTEGG_CUT02		Jbg02
 */
//-----------------------------------------------------------------------------
FLDMAPFUNC_WORK* FLDMAP_DEMO_AntEgg_Start( FIELDSYS_WORK* fsys, u32 cut )
{
	static FLDMAPFUNC_DATA FLDMAP_DEMO_Data = {
		FLDMAP_DEMO_ANTEGG_TASK_PRI	,
		sizeof(FLDMAP_DEMO_ANTEGG),
		NULL,
		FLDMAP_DEMO_AntEgg_Delete,
		FLDMAP_DEMO_AntEgg_Main,
		FLDMAP_DEMO_AntEgg_Draw
	};
	static const FLDMAPFUNC_CREATE FLDMAP_DEMO_Create[] = {
		FLDMAP_DEMO_AntEggCut00_Init,
		FLDMAP_DEMO_AntEggCut01_Init,
		FLDMAP_DEMO_AntEggCut02_Init,
	};
	FLDMAPFUNC_WORK* p_fwk;

	FLDMAP_DEMO_Data.create_func = FLDMAP_DEMO_Create[ cut ];
	p_fwk = FLDMAPFUNC_Create( fsys->fldmap->fmapfunc_sys, &FLDMAP_DEMO_Data );
	return p_fwk;
}

//----------------------------------------------------------------------------
/**
 *	@brief	̗@fI
 *
 *	@param	p_demo	f[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLDMAP_DEMO_AntEgg_End( FLDMAPFUNC_WORK* p_demo )
{
	FLDMAPFUNC_Delete( p_demo );
}



//-----------------------------------------------------------------------------
/**
 * 
 *		͕o
 * 
 */
//-----------------------------------------------------------------------------
#define FLDMAP_DEMO_GINGA_TASK_PRI		( 1024 )
#define FLDMAP_DEMO_GINGA_Y_OFS			( FX32_CONST( 0x2 ) )
#define FLDMAP_DEMO_GINGA_DARKOFF_WAIT	( 64 )
//-------------------------------------
//	͕o[N
//=====================================
typedef struct {
	u32 seq;		// V[PX
	u32 wait;		// ҂ԂȂǂɎgp
	FLD_DEMO_GINGA* p_ginga;	//@͕o
	FLD_DEMO_DARKLIGHT* p_dark;	// _[NCg
} FLDMAP_DEMO_GINGA;

//----------------------------------------------------------------------------
/**
 *		y͕oz
 *	@brief	
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_Ginga_Init(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_GINGA* p_dwk = p_work;

	p_dwk->p_ginga = FLD_DEMO_GINGA_Alloc( p_fsys );
	p_dwk->p_dark = FLD_DEMO_DarkLight_Alloc( USE_HEAPID, p_fsys );
	p_dwk->seq		= 0;
}

//----------------------------------------------------------------------------
/**
 *		y͕oz
 *	@brief	j
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_Ginga_Delete(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_GINGA* p_dwk = p_work;
	
	FLD_DEMO_GINGA_Free( p_dwk->p_ginga );
	FLD_DEMO_DarkLight_Free( p_dwk->p_dark );
}

//----------------------------------------------------------------------------
/**
 *		y͕oz
 *	@brief	C
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_Ginga_Main(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_GINGA* p_dwk = p_work;
	u32 result[2];
	VecFx32 matrix;

	switch( p_dwk->seq ){
	case FLDMAP_DEMO_GINGA_SEQ_START:
		matrix = GFC_GetLookTarget( p_fsys->camera_ptr );
		FLD_DEMO_GINGA_Init( p_dwk->p_ginga, matrix.x, matrix.y + FLDMAP_DEMO_GINGA_Y_OFS, matrix.z );
		FLD_DEMO_DarkLight_Start( p_dwk->p_dark );
		p_dwk->seq++;
		break;
		
	case FLDMAP_DEMO_GINGA_SEQ_SCALEUP:
		result[0] = FLD_DEMO_GINGA_GetState( p_dwk->p_ginga );
		result[1] = FLD_DEMO_DarkLight_GetState( p_dwk->p_dark );
		
		if( (result[0] == FLD_DEMO_GINGA_MOTIONBL_REQWAIT) &&
			(result[1] == FLD_DEMO_DARKLIGHT_ENDWAIT)){	
			p_dwk->seq++;
		}
		break;
		
	case FLDMAP_DEMO_GINGA_SEQ_ENDREQ_WAIT:
		break;

	case FLDMAP_DEMO_GINGA_SEQ_ENDREQ:
		FLD_DEMO_GINGA_EndReq( p_dwk->p_ginga );
		p_dwk->wait = FLDMAP_DEMO_GINGA_DARKOFF_WAIT;
		p_dwk->seq++;
		break;
		
	case FLDMAP_DEMO_GINGA_SEQ_SCALEDOWN_DARKOFF_WAIT:
		p_dwk->wait --;
		if( p_dwk->wait <= 0 ){
			FLD_DEMO_DarkLight_EndReq( p_dwk->p_dark );
			p_dwk->seq++;
		}
		break;
		
	case FLDMAP_DEMO_GINGA_SEQ_SCALEDOWN_DARKOFF:
		result[0] = FLD_DEMO_GINGA_GetState( p_dwk->p_ginga );
		result[1] = FLD_DEMO_DarkLight_GetState( p_dwk->p_dark );
		
		if( (result[0] == FLD_DEMO_GINGA_MOTIONBL_END) &&
			(result[1] == FLD_DEMO_DARKLIGHT_END)){	
			p_dwk->seq++;
		}
		break;
		
	case FLDMAP_DEMO_GINGA_SEQ_END:
		break;

	default:
		break;
	}
	
	FLD_DEMO_GINGA_Main( p_dwk->p_ginga );
	FLD_DEMO_DarkLight_Main( p_dwk->p_dark );
}

//----------------------------------------------------------------------------
/**
 *		y͕oz
 *	@brief	`揈
 */
//-----------------------------------------------------------------------------
static void FLDMAP_DEMO_Ginga_Draw(FLDMAPFUNC_WORK * p_fwk, FIELDSYS_WORK * p_fsys, void * p_work)
{
	FLDMAP_DEMO_GINGA* p_dwk = p_work;


	FLD_DEMO_GINGA_Draw( p_dwk->p_ginga );
}


//----------------------------------------------------------------------------
/**
 *	@brief	̓fJn
 *
 *	@param	fsys	tB[hVXe[N
 *
 *	@return	f[N
 */
//-----------------------------------------------------------------------------
FLDMAPFUNC_WORK* FLDMAP_DEMO_Ginga_Start( FIELDSYS_WORK* fsys )
{
	static const FLDMAPFUNC_DATA FLDMAP_DEMO_Data = {
		FLDMAP_DEMO_GINGA_TASK_PRI,
		sizeof(FLDMAP_DEMO_GINGA),
		FLDMAP_DEMO_Ginga_Init,
		FLDMAP_DEMO_Ginga_Delete,
		FLDMAP_DEMO_Ginga_Main,
		FLDMAP_DEMO_Ginga_Draw
	};
	FLDMAPFUNC_WORK* p_fwk;
	p_fwk = FLDMAPFUNC_Create( fsys->fldmap->fmapfunc_sys, &FLDMAP_DEMO_Data );
	return p_fwk;
}

//----------------------------------------------------------------------------
/**
 *	@brief	̓f@I
 *
 *	@param	p_demo	f[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLDMAP_DEMO_Ginga_End( FLDMAPFUNC_WORK* p_demo )
{
	FLDMAPFUNC_Delete( p_demo );
}

//----------------------------------------------------------------------------
/**
 *	@brief	INGXg
 *
 *	@param	p_demo	f[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLDMAP_DEMO_Ginga_EndReq( FLDMAPFUNC_WORK* p_demo )
{
	FLDMAP_DEMO_GINGA* p_dwk = FLDMAPFUNC_GetFreeWork( p_demo );
	p_dwk->seq = FLDMAP_DEMO_GINGA_SEQ_ENDREQ;
}

//----------------------------------------------------------------------------
/**
 *	@brief	݂͂̌̃V[PX擾
 *
 *	@param	p_demo	f[N
 *
 *	@retval	FLDMAP_DEMO_GINGA_SEQ_START,		// GtFNgJn
 *	@retval	FLDMAP_DEMO_GINGA_SEQ_SCALEUP,		// ͊g
 * 	@retval	FLDMAP_DEMO_GINGA_SEQ_ENDREQ_WAIT,	// INGXg҂
 *	@retval	FLDMAP_DEMO_GINGA_SEQ_ENDREQ,		// IGtFNgJn
 *	@retval	FLDMAP_DEMO_GINGA_SEQ_SCALEDOWN_DARKOFF_WAIT,	// ͏k
 *	@retval	FLDMAP_DEMO_GINGA_SEQ_SCALEDOWN_DARKOFF,	// ͏k{邭
 *	@retval	FLDMAP_DEMO_GINGA_SEQ_END			// I
 */         
//-----------------------------------------------------------------------------
u32 FLDMAP_DEMO_Ginga_GetState( FLDMAPFUNC_WORK* p_demo )
{
	FLDMAP_DEMO_GINGA* p_dwk = FLDMAPFUNC_GetFreeWork( p_demo );
	return p_dwk->seq;
}




//-----------------------------------------------------------------------------
/**
 *
 *		́AX̃GtFNgP
 *
 */
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *
 *
 *		ėp
 * 
 */
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	샏[N
//=====================================
typedef struct {
	s32 data;
	s32 s_data;
	s32 add_data;
	s32 count_max;
} FLD_DEMO_MOVE_PARAM;

//-------------------------------------
//	샏[N
//=====================================
typedef struct {
	fx32 data;
	fx32 s_data;
	fx32 add_data;
	s32 count_max;
} FLD_DEMO_MOVE_PARAM_FX;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void FLD_DEMO_MoveInit( FLD_DEMO_MOVE_PARAM* p_data, s32 s_num, s32 e_num, s32 count );
static BOOL FLD_DEMO_MoveMain( FLD_DEMO_MOVE_PARAM* p_data, s32 count );
static void FLD_DEMO_MoveInit_FX( FLD_DEMO_MOVE_PARAM_FX* p_data, fx32 s_num, fx32 e_num, s32 count );
static BOOL FLD_DEMO_MoveMain_FX( FLD_DEMO_MOVE_PARAM_FX* p_data, s32 count );

// f
static void FLD_DEMO_3DObjMdlLoad( FLD_3DOBJ_MDL* p_mdl, u32 arc_idx, u32 data_idx, u32 heap );
static void FLD_DEMO_3DObjMdlDelete( FLD_3DOBJ_MDL* p_mdl );

// Aj
static void FLD_DEMO_3DObjAnmLoad( FLD_3DOBJ_ANM* p_anm, const FLD_3DOBJ_MDL* cp_mdl, u32 arc_idx, u32 data_idx, u32 heap, NNSFndAllocator* pallocator );
static void FLD_DEMO_3DObjAnmDelete( FLD_3DOBJ_ANM* p_anm, NNSFndAllocator* pallocator );
static BOOL FLD_DEMO_3DObjAnmNoLoop( FLD_3DOBJ_ANM* p_anm );
static void FLD_DEMO_3DObjAnmLoop( FLD_3DOBJ_ANM* p_anm );
static void FLD_DEMO_3DObjAnmLoopAdd( FLD_3DOBJ_ANM* p_anm, fx32 add );
static void FLD_DEMO_3DObjAnmSet( FLD_3DOBJ_ANM* p_anm, fx32 num );
static fx32 FLD_DEMO_3DObjAnmGet( const FLD_3DOBJ_ANM* cp_anm );

// `IuWF
static void FLD_DEMO_3DObjDrawInit( FLD_3DOBJ* p_draw, FLD_3DOBJ_MDL* cp_mdl );
static void FLD_DEMO_3DObjDrawAddAnm( FLD_3DOBJ* p_draw, FLD_3DOBJ_ANM* p_anm );
static void FLD_DEMO_3DObjDrawDraw( FLD_3DOBJ* p_draw );
static void FLD_DEMO_3DObjDrawSetDraw( FLD_3DOBJ* p_draw, BOOL flag );
static BOOL FLD_DEMO_3DObjDrawGetDraw( const FLD_3DOBJ* cp_draw );
static void FLD_DEMO_3DObjDrawSetMatrix( FLD_3DOBJ* p_draw, fx32 x, fx32 y, fx32 z );
static void FLD_DEMO_3DObjDrawGetMatrix( FLD_3DOBJ* p_draw, fx32* p_x, fx32* p_y, fx32* p_z );
static void FLD_DEMO_3DObjDrawSetScale( FLD_3DOBJ* p_draw, fx32 x, fx32 y, fx32 z );
static void FLD_DEMO_3DObjDrawGetScale( FLD_3DOBJ* p_draw, fx32* p_x, fx32* p_y, fx32* p_z );
static void FLD_DEMO_3DObjDrawSetRota( FLD_3DOBJ* p_draw, u16 rota, u32 way );
static u16 FLD_DEMO_3DObjDrawGetRota( FLD_3DOBJ* p_draw, u32 way );



//----------------------------------------------------------------------------
/**
 *	@brief	p[^
 *
 *	@param	p_data	[N
 *	@param	s_num	Jnl
 *	@param	e_num	Il
 *	@param	count	őJEg
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_MoveInit( FLD_DEMO_MOVE_PARAM* p_data, s32 s_num, s32 e_num, s32 count )
{
	p_data->data		= s_num;
	p_data->s_data		= s_num;
	p_data->add_data	= e_num - s_num;
	p_data->count_max	= count;
}

//----------------------------------------------------------------------------
/**
 *	@brief	vZ
 *
 *	@param	p_data
 *	@param	count	݃JEg
 *
 *	@retval TRUE	I
 *	@retval	FALSE	傤
 */
//-----------------------------------------------------------------------------
static BOOL FLD_DEMO_MoveMain( FLD_DEMO_MOVE_PARAM* p_data, s32 count )
{
	s32 local_count;
	BOOL ret;
	s32 num;
	
	if( count >= p_data->count_max ){
		local_count = p_data->count_max;
		ret = TRUE;
	}else{
		local_count = count;
		ret = FALSE;
	}

	// vZ
	num = p_data->add_data * local_count;
	num = num / p_data->count_max;
	num += p_data->s_data;

	// ݒ
	p_data->data = num;

	return ret;
}

//----------------------------------------------------------------------------
/**
 *	@brief	FXRQ@ł̔ėpvZ֐
 *
 *	@param	p_data		[N
 *	@param	s_num		Jnl
 *	@param	e_num		Il
 *	@param	count		
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_MoveInit_FX( FLD_DEMO_MOVE_PARAM_FX* p_data, fx32 s_num, fx32 e_num, s32 count )
{
	p_data->data		= s_num;
	p_data->s_data		= s_num;
	p_data->add_data	= e_num - s_num;
	p_data->count_max	= count;
}

//----------------------------------------------------------------------------
/**
 *	@brief	FXRQ@ėp֐C
 *
 *	@param	p_data	[N
 *	@param	count	JEgl
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static BOOL FLD_DEMO_MoveMain_FX( FLD_DEMO_MOVE_PARAM_FX* p_data, s32 count )
{
	s32 local_count;
	BOOL ret;
	fx32 num;
	
	if( count >= p_data->count_max ){
		local_count = p_data->count_max;
		ret = TRUE;
	}else{
		local_count = count;
		ret = FALSE;
	}

	// vZ
	num = FX_Mul( p_data->add_data, local_count << FX32_SHIFT );
	num = FX_Div( num, p_data->count_max << FX32_SHIFT );
	num += p_data->s_data;

	// ݒ
	p_data->data = num;

	return ret;
}

//----------------------------------------------------------------------------
/**
 *	@brief	RDfǂݍ
 *
 *	@param	p_mdl		f[N
 *	@param	arc_idx		A[JCuID
 *	@param	data_idx	f[^IDX
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_3DObjMdlLoad( FLD_3DOBJ_MDL* p_mdl, u32 arc_idx, u32 data_idx, u32 heap )
{
	FLD_3DObjMdlLoad( p_mdl, arc_idx, data_idx, heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	f[Nj
 *
 *	@param	p_mdl f[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_3DObjMdlDelete( FLD_3DOBJ_MDL* p_mdl )
{
	FLD_3DObjMdlDelete( p_mdl );
}

//----------------------------------------------------------------------------
/**
 *	@brief	RDAjf[^ǂݍ
 *
 *	@param	p_anm		Aj[N
 *	@param	cp_mdl		f[N
 *	@param	arc_idx		A[JCut@CID
 *	@param	data_idx	f[^IDX
 *	@param	heap		q[v
 *	@param	pallocator	AP[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_3DObjAnmLoad( FLD_3DOBJ_ANM* p_anm, const FLD_3DOBJ_MDL* cp_mdl, u32 arc_idx, u32 data_idx, u32 heap, NNSFndAllocator* pallocator )
{
	FLD_3DObjAnmLoad( p_anm, cp_mdl, arc_idx, data_idx, heap, pallocator );
}

//----------------------------------------------------------------------------
/**
 *	@brief	RDAjf[^j
 *
 *	@param	p_anm		Aj[N
 *	@param	pallocator	AP[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_3DObjAnmDelete( FLD_3DOBJ_ANM* p_anm, NNSFndAllocator* pallocator )
{
	FLD_3DObjAnmDelete( p_anm, pallocator );
}

//----------------------------------------------------------------------------
/**
 *	@brief	[vĐ
 *
 *	@param	p_anm	AjIuWFNg
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_3DObjAnmLoop( FLD_3DOBJ_ANM* p_anm )
{
	FLD_3DObjAnmLoop( p_anm, FX32_ONE );
}

//----------------------------------------------------------------------------
/**
 *	@brief	[vĐŐi߂lwł
 *
 *	@param	p_anm	AjIuWFNg
 *	@param	add		i߂l
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_3DObjAnmLoopAdd( FLD_3DOBJ_ANM* p_anm, fx32 add )
{
	FLD_3DObjAnmLoop( p_anm, add );
}

//----------------------------------------------------------------------------
/**
 *	@brief	[vȂĐ
 *
 *	@param	p_anm Aj[N
 *
 *	@retval	TRUE	ĐI
 *	@retval	FALSE	Đr
 */
//-----------------------------------------------------------------------------
static BOOL FLD_DEMO_3DObjAnmNoLoop( FLD_3DOBJ_ANM* p_anm )
{
	return FLD_3DObjAnmNoLoop( p_anm, FX32_ONE );
}


//----------------------------------------------------------------------------
/**
 *	@brief	Ajlݒ
 *
 *	@param	p_anm	AjIuWF
 *	@param	num		ݒl
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_3DObjAnmSet( FLD_3DOBJ_ANM* p_anm, fx32 num )
{
	FLD_3DObjAnmSet( p_anm, num );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Ajt[擾
 *
 *	@param	p_anm	AjIuWF
 *
 *	@return	t[
 */
//-----------------------------------------------------------------------------
static fx32 FLD_DEMO_3DObjAnmGet( const FLD_3DOBJ_ANM* cp_anm )
{
	return FLD_3DObjAnmGet( cp_anm );
}

//----------------------------------------------------------------------------
/**
 *	@brief	`IuWFNg
 *
 *	@param	p_draw	[N
 *	@param	p_mdl	f[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_3DObjDrawInit( FLD_3DOBJ* p_draw, FLD_3DOBJ_MDL* p_mdl )
{
	FLD_3DObjInit( p_draw, p_mdl );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Ajf[^N
 *
 *	@param	p_draw	[N
 *	@param	p_anm	Aj[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_3DObjDrawAddAnm( FLD_3DOBJ* p_draw, FLD_3DOBJ_ANM* p_anm )
{
	FLD_3DObjAddAnm( p_draw, p_anm );
}

//----------------------------------------------------------------------------
/**
 *	@brief	f`
 *
 *	@param	p_draw `惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_3DObjDrawDraw( FLD_3DOBJ* p_draw )
{
	FLD_3DObjDraw( p_draw );
}

//----------------------------------------------------------------------------
/**
 *	@brief	`tOݒ
 *
 *	@param	p_draw	[N
 *	@param	flag	tO
 *
 *	@return	none
 *
 *	flag
 *		TRUE	\
 *		FALSE	\
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_3DObjDrawSetDraw( FLD_3DOBJ* p_draw, BOOL flag )
{
	FLD_3DObjSetDraw( p_draw, flag );
}

//----------------------------------------------------------------------------
/**
 *	@brief	`tO擾
 *
 *	@param	cp_draw		[N
 *
 *	@retval	TRUE	\
 *	@retval	FALSE	\
 */
//-----------------------------------------------------------------------------
static BOOL FLD_DEMO_3DObjDrawGetDraw( const FLD_3DOBJ* cp_draw )
{
	return FLD_3DObjGetDraw( cp_draw );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Wݒ
 *	
 *	@param	p_draw		[N
 *	@param	x			W
 *	@param	y			W
 *	@param	z			W
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_3DObjDrawSetMatrix( FLD_3DOBJ* p_draw, fx32 x, fx32 y, fx32 z )
{
	FLD_3DObjSetMatrix( p_draw, x, y, z );
}

//----------------------------------------------------------------------------
/**
 *	@brief	W擾
 *
 *	@param	p_draw	[N
 *	@param	p_x		i[
 *	@param	p_y		i[
 *	@param	p_z		i[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_3DObjDrawGetMatrix( FLD_3DOBJ* p_draw, fx32* p_x, fx32* p_y, fx32* p_z )
{
	FLD_3DObjGetMatrix( p_draw, p_x, p_y, p_z );
}

//----------------------------------------------------------------------------
/**
 *	@brief	gklݒ
 *
 *	@param	p_draw	`惏[N
 *	@param	x		gkl
 *	@param	y		gkl
 *	@param	z 		gkl
 *
 *	@return	noen
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_3DObjDrawSetScale( FLD_3DOBJ* p_draw, fx32 x, fx32 y, fx32 z )
{
	FLD_3DObjSetScale( p_draw, x, y, z );
}

//----------------------------------------------------------------------------
/**
 *	@brief	gkl擾
 *
 *	@param	p_draw	`惏[N
 *	@param	p_x		W擾
 *	@param	p_y		W擾
 *	@param	p_z		W擾
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_3DObjDrawGetScale( FLD_3DOBJ* p_draw, fx32* p_x, fx32* p_y, fx32* p_z )
{
	FLD_3DObjGetScale( p_draw, p_x, p_y, p_z );
}

//----------------------------------------------------------------------------
/**
 *	@brief	]eݒ
 *
 *	@param	p_draw	`惏[N
 *	@param	rota	]p
 *	@param	way		
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_3DObjDrawSetRota( FLD_3DOBJ* p_draw, u16 rota, u32 way )
{
	FLD_3DObjSetRota( p_draw, rota, way );
}

//----------------------------------------------------------------------------
/**
 *	@brief	`惏[N	]p擾
 *	
 *	@param	p_draw	`惏[N
 *	@param	way		
 *
 *	@return	]p
 */
//-----------------------------------------------------------------------------
static u16 FLD_DEMO_3DObjDrawGetRota( FLD_3DOBJ* p_draw, u32 way )
{
	return FLD_3DObjGetRota( p_draw, way );
}








//-----------------------------------------------------------------------------
/**
 *
 *
 *		yʗh炵z
 * 
 */
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	V[PX
//=====================================
enum{
	FLD_DEMO_SHAKE_SCRN_SEQ_LEFTUP_FRONT,
	FLD_DEMO_SHAKE_SCRN_SEQ_LEFTUP_BACK,
	FLD_DEMO_SHAKE_SCRN_SEQ_RIGHTDOWN_FRONT,
	FLD_DEMO_SHAKE_SCRN_SEQ_RIGHTDOWN_BACK,
	FLD_DEMO_SHAKE_SCRN_SEQ_CLEAN,
	FLD_DEMO_SHAKE_SCRN_SEQ_END,
};

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	ʗh炵[N
//=====================================
typedef struct _FLD_DEMO_SHAKE_SCRN{
	GF_CAMERA_PTR p_camera;		// J\
	GF_CAMERA_PTR p_fld_camera;	// tB[hŎgpĂJ\
	FLD_DEMO_MOVE_PARAM_FX move_x;
	FLD_DEMO_MOVE_PARAM_FX move_y;
	VecFx32 target;
	VecFx32 def_mat;
	u32 seq;					// V[PX
	u32 move_count;				// 춳
	u32 shake_count;			// h炵
} ;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void FldScrn_ShakeScrn_Clean( FLD_DEMO_SHAKE_SCRN* p_data );
static BOOL FldScrn_ShakeScrn_Move( FLD_DEMO_SHAKE_SCRN* p_data );
static void FldScrn_ShakeScrn_DataSet( FLD_DEMO_SHAKE_SCRN* p_data, fx32 x, fx32 y );


//----------------------------------------------------------------------------
/**
 *		yʗh炵z
 *	@brief	ʗh炵[N쐬
 *
 *	@param	heapID	q[v
 *
 *	@return	[N|C^
 */
//-----------------------------------------------------------------------------
FLD_DEMO_SHAKE_SCRN* FLD_DEMO_ShakeScrn_Alloc( u32 heapID )
{
	FLD_DEMO_SHAKE_SCRN* p_data;

	p_data = sys_AllocMemory( heapID, sizeof(FLD_DEMO_SHAKE_SCRN) );
	memset( p_data, 0, sizeof(FLD_DEMO_SHAKE_SCRN) );

	// J쐬
	p_data->p_camera = GFC_AllocCamera( heapID );

	// V[PXIɂĂ
	p_data->seq  = FLD_DEMO_SHAKE_SCRN_SEQ_END;
	
	return p_data;
}

//----------------------------------------------------------------------------
/**
 *		yʗh炵z
 *	@brief	ʗh炵[Nj
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_ShakeScrn_Free( FLD_DEMO_SHAKE_SCRN* p_data )
{
	// Jj
	GFC_FreeCamera( p_data->p_camera );
	sys_FreeMemoryEz( p_data );
}

//----------------------------------------------------------------------------
/**
 *		yʗh炵z
 *	@brief	Jh炵Jn
 *
 *	@param	p_data			f[^i[
 *	@param	width			h炵
 *	@param	height			h炵
 *	@param	one_sync		h炵1؂(Owidthړ)
 *	@param	count			h炵
 *	@param	copy_camera		܃tB[hŎgĂJ
 *
 * one_syncɂ
 *	0widthړԂ̃VNłB
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_ShakeScrn_Start( FLD_DEMO_SHAKE_SCRN* p_data, fx32 width, fx32 height, u32 one_sync, u32 count, GF_CAMERA_PTR copy_camera )
{
	// [N
	FldScrn_ShakeScrn_Clean( p_data );

	// Jf[^Rs[
	GFC_CopyCamera( copy_camera, p_data->p_camera );
	// ݂̃^[QbgW擾
	p_data->target = GFC_GetLookTarget( copy_camera );
	p_data->def_mat = p_data->target;
	// ^[QbgWoCh
	GFC_BindCameraTarget( &p_data->target, p_data->p_camera );
	// JL
	GFC_AttachCamera( p_data->p_camera );
	// tB[hŎgpĂJۑ
	p_data->p_fld_camera = copy_camera;
		
	// 샏[Nݒ
	FLD_DEMO_MoveInit_FX( &p_data->move_x, 0, width, one_sync );
	FLD_DEMO_MoveInit_FX( &p_data->move_y, 0, height, one_sync );

	// 
	p_data->shake_count = count;

	// 
	Snd_SePlay( FLD_DEMO_LEGENDEFF_SND_03 );
}

//----------------------------------------------------------------------------
/**
 *		yʗh炵z
 *	@brief	ʗh炵C֐
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_ShakeScrn_Main( FLD_DEMO_SHAKE_SCRN* p_data )
{
	BOOL check;
	
	switch( p_data->seq ){
	case FLD_DEMO_SHAKE_SCRN_SEQ_LEFTUP_FRONT:
		p_data->move_count ++;
		check = FldScrn_ShakeScrn_Move( p_data );
		FldScrn_ShakeScrn_DataSet( p_data, p_data->move_x.data, p_data->move_y.data );
		if( check == TRUE ){
			p_data->seq ++;
		}
		break;
		
	case FLD_DEMO_SHAKE_SCRN_SEQ_LEFTUP_BACK:
		p_data->move_count --;
		FldScrn_ShakeScrn_Move( p_data );
		FldScrn_ShakeScrn_DataSet( p_data, p_data->move_x.data, p_data->move_y.data );
		if( p_data->move_count <= 0 ){
			p_data->seq ++;
		}
		break;
		
	case FLD_DEMO_SHAKE_SCRN_SEQ_RIGHTDOWN_FRONT:
		p_data->move_count ++;
		check = FldScrn_ShakeScrn_Move( p_data );
		FldScrn_ShakeScrn_DataSet( p_data, -p_data->move_x.data, -p_data->move_y.data );
		if( check == TRUE ){
			p_data->seq ++;
		}
		break;
		
	case FLD_DEMO_SHAKE_SCRN_SEQ_RIGHTDOWN_BACK:
		p_data->move_count --;
		FldScrn_ShakeScrn_Move( p_data );
		FldScrn_ShakeScrn_DataSet( p_data, -p_data->move_x.data, -p_data->move_y.data );
		if( p_data->move_count <= 0 ){

			// h炵OɂȂI
			p_data->shake_count --;
			if( p_data->shake_count > 0 ){
				p_data->seq = FLD_DEMO_SHAKE_SCRN_SEQ_LEFTUP_FRONT;
			}else{
				p_data->seq ++;
			}
		}
		break;

	case FLD_DEMO_SHAKE_SCRN_SEQ_CLEAN:
		// Jɖ߂
		GFC_AttachCamera( p_data->p_fld_camera );
		p_data->seq ++;
		break;
		
	case FLD_DEMO_SHAKE_SCRN_SEQ_END:
		break;

	default:
		break;
	}
}


//----------------------------------------------------------------------------
/**
 *		yʗh炵z
 *	@brief	Jh炵I`FbN
 *
 *	@param	p_data	[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL FLD_DEMO_ShakeScrn_EndCheck( FLD_DEMO_SHAKE_SCRN* p_data )
{
	if( p_data->seq == FLD_DEMO_SHAKE_SCRN_SEQ_END ){
		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *		yʗh炵z
 *	@brief	[N̏
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FldScrn_ShakeScrn_Clean( FLD_DEMO_SHAKE_SCRN* p_data )
{
	memset( &p_data->move_x, 0, sizeof(FLD_DEMO_MOVE_PARAM_FX) );
	memset( &p_data->move_y, 0, sizeof(FLD_DEMO_MOVE_PARAM_FX) );
	memset( &p_data->target, 0, sizeof(VecFx32) );
	p_data->seq = 0;					// V[PX
	p_data->move_count = 0;				// 춳
	p_data->shake_count = 0;			// h炵
}

//----------------------------------------------------------------------------
/**
 *		yʗh炵z
 *	@brief	vZ
 *
 *	@param	p_data	[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL FldScrn_ShakeScrn_Move( FLD_DEMO_SHAKE_SCRN* p_data )
{
	BOOL check;
	check = FLD_DEMO_MoveMain_FX( &p_data->move_x, p_data->move_count );
	FLD_DEMO_MoveMain_FX( &p_data->move_y, p_data->move_count );
	return check;
}

//----------------------------------------------------------------------------
/**
 *		yʗh炵z
 *	@brief	[NZ
 *
 *	@param	p_data	[N
 *	@param	x		
 *	@param	y		
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FldScrn_ShakeScrn_DataSet( FLD_DEMO_SHAKE_SCRN* p_data, fx32 x, fx32 y )
{
	p_data->target.x = p_data->def_mat.x + x;
	p_data->target.y = p_data->def_mat.y + y;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ݎcꐔԂ
 *
 *	@param	p_data	[N
 *
 *	@return	cꐔ
 */
//-----------------------------------------------------------------------------
u32 FLD_DEMO_ShakeScrn_GetNowCount( const FLD_DEMO_SHAKE_SCRN* p_data )
{
	return p_data->shake_count;
}

//----------------------------------------------------------------------------
/**
 *	@brief	݂̂ꕝԂ
 *
 *	@param	p_data	[N
 *
 *	@return	ꕝ
 */
//-----------------------------------------------------------------------------
fx32 FLD_DEMO_ShakeScrn_GetNowShakeWidth( const FLD_DEMO_SHAKE_SCRN* p_data )
{
	return p_data->move_x.add_data;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ꕝݒ
 *
 *	@param	p_data	[N
 *	@param	width	ꕝ
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_ShakeScrn_SetNowShakeWidth( FLD_DEMO_SHAKE_SCRN* p_data, fx32 width )
{
	p_data->move_x.add_data = width;
}




//-----------------------------------------------------------------------------
/**
 *
 *
 *		ytbVz
 * 
 */
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	tbVV[PX
//=====================================
enum{
	FLD_DEMO_FLASH_ADD,
	FLD_DEMO_FLASH_SUB,
	FLD_DEMO_FLASH_CLEAN,
	FLD_DEMO_FLASH_END
};

#define FLD_DEMO_FLASH_ALPHASET_TCB	( 1024 )

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	tbV[N
//=====================================
typedef struct _FLD_DEMO_FLASH{
	FLD_DEMO_MOVE_PARAM alpha;	// 
	int count;					// 
	u32 alphamax;				// ől
	u32 in_sync;				// tbVC̃VN
	int seq;
	TCB_PTR	setalpha_tcb;		// lݒ肷TCB
} ;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void FldDemo_FlashSetAlphaTcb( TCB_PTR tcb, void* p_work );

//----------------------------------------------------------------------------
/**
 *		ytbVz
 *	@brief	tbV[Nmہ@OtBbNf[^ݒ
 *
 *	@param	heapID	q[v
 *	@param	p_bgini	BGRg[
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
FLD_DEMO_FLASH* FLD_DEMO_Flash_Alloc( u32 heapID )
{
	FLD_DEMO_FLASH* p_data;

	p_data = sys_AllocMemory( heapID, sizeof(FLD_DEMO_FLASH) );
	memset( p_data, 0, sizeof(FLD_DEMO_FLASH) );

	// V[PXIV[PXɂ
	p_data->seq = FLD_DEMO_FLASH_END;

	return p_data;
}

//----------------------------------------------------------------------------
/**
 *		ytbVz
 *	@brief	tbVj
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_Flash_Free( FLD_DEMO_FLASH* p_data )
{
	if( p_data->setalpha_tcb ){
		TCB_Delete( p_data->setalpha_tcb );
		p_data->setalpha_tcb = NULL;
	} 
	sys_FreeMemoryEz( p_data );
}

//----------------------------------------------------------------------------
/**
 *		ytbVz
 *	@brief	tbVJn
 *
 *	@param	p_data		[N
 *	@param	alphamax	ő僿l
 *	@param	out_sync	tbVAEgVN
 *	@param	out_sync	tbVCVN
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_Flash_Start( FLD_DEMO_FLASH* p_data, u32 alphamax, u32 out_sync, u32 in_sync )
{
	// 쒆̂Ƃ́A^XNj
	if(p_data->seq != FLD_DEMO_FLASH_END){ 
		if( p_data->setalpha_tcb != NULL ){
			TCB_Delete( p_data->setalpha_tcb );
			p_data->setalpha_tcb = NULL;
		} 
	}
	
	FLD_DEMO_MoveInit( &p_data->alpha, 0, alphamax, out_sync );
	p_data->count = 0;
	p_data->seq = FLD_DEMO_FLASH_ADD;
	p_data->in_sync = in_sync;
	p_data->alphamax = alphamax;

	// ϽPx
	GX_SetMasterBrightness( p_data->alpha.data );

	// lݒ^XNo^
//	p_data->setalpha_tcb = VIntrTCB_Add( FldDemo_FlashSetAlphaTcb, p_data, FLD_DEMO_FLASH_ALPHASET_TCB );
	p_data->setalpha_tcb = VWaitTCB_Add( FldDemo_FlashSetAlphaTcb, p_data, FLD_DEMO_FLASH_ALPHASET_TCB );

	// tbVI
	Snd_SePlay( FLD_DEMO_LEGENDEFF_SND_02 );
}

//----------------------------------------------------------------------------
/**
 *		ytbVz
 *	@brief	I`FbN
 *
 *	@param	p_data	[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL FLD_DEMO_Flash_EndCheck( FLD_DEMO_FLASH* p_data )
{
	if( p_data->seq == FLD_DEMO_FLASH_END ){
		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *		ytbVz
 *	@brief	tbVC
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_Flash_Main( FLD_DEMO_FLASH* p_data )
{
	BOOL check;
	
	switch( p_data->seq ){
	case FLD_DEMO_FLASH_ADD:
		p_data->count++;
		check = FLD_DEMO_MoveMain( &p_data->alpha, p_data->count );

		if( check == TRUE ){
			FLD_DEMO_MoveInit( &p_data->alpha, p_data->alphamax, 0, p_data->in_sync );
			p_data->count = 0;
			p_data->seq ++;
		}
		break;
		
	case FLD_DEMO_FLASH_SUB:
		p_data->count++;
		check = FLD_DEMO_MoveMain( &p_data->alpha, p_data->count );
		if( check == TRUE ){
			p_data->seq ++;
		}
		break;

	case FLD_DEMO_FLASH_CLEAN:
		// ݒTCBj
		TCB_Delete( p_data->setalpha_tcb );
		p_data->setalpha_tcb = NULL;

		p_data->seq ++;
		break;
		
	case FLD_DEMO_FLASH_END:
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	̃l擾
 */
//-----------------------------------------------------------------------------
int FLD_DEMO_Flash_GetAlpha( const FLD_DEMO_FLASH* cp_data )
{
	return cp_data->alpha.data;
}

//----------------------------------------------------------------------------
/**
 *		ytbVz
 *	@brief	lVuNԐݒ^XN
 *
 *	@param	tcb		TCB[N
 *	@param	p_work	[N
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FldDemo_FlashSetAlphaTcb( TCB_PTR tcb, void* p_work )
{
	FLD_DEMO_FLASH* p_data = p_work;
	// ݒ
	GX_SetMasterBrightness( p_data->alpha.data );
}





//-----------------------------------------------------------------------------
/**
 *
 *
 *		y̓fz
 * 
 */
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define FLD_DEMO_GINGA_MOTION_BL_EVA	( 8 )
#define FLD_DEMO_GINGA_MOTION_BL_EVB	( 8 )


// `֌W
// \tgEFAXvCg
#define FLD_DEMO_GINGA_SWSP_OBJNUM		(1)		// SWSPIuWFNg
#define FLD_DEMO_GINGA_SWSP_CHARNUM	(1)		// SWSPIuWFNg
#define FLD_DEMO_GINGA_SWSP_PLTTNUM	(1)		// SWSPIuWFNg


//-------------------------------------
//	̓IuWFNgf[^
//=====================================
#define FLD_DEMO_GINGA_OBJ_ROTA_ADD		( FX32_CONST( 2.0f ) )
#define FLD_DEMO_GINGA_OBJ_ROTA_SUB		( -FX32_CONST(0.050f) )
#define FLD_DEMO_GINGA_OBJ_SUB_ROTA_ADD	( -FX32_CONST( 40.0f ) )
#define FLD_DEMO_GINGA_OBJ_SCAL_S	( FX32_CONST( 0.0f ) )
#define FLD_DEMO_GINGA_OBJ_SCAL_E	( FX32_CONST( 1.0f ) )
#define FLD_DEMO_GINGA_OBJ_SCAL_COUNT	( 128 )	// gɂl
#define FLD_DEMO_GINGA_OBJ_SCAL_SUB_COUNT	( 32 )	// kɂl
#define FLD_DEMO_GINGA_OBJ_WAIT_COUNT		( 8 )	// g傩k̎́Aweight
#define FLD_DEMO_GINGA_OBJ_FLASH_S_NUM	( FX32_CONST( 0.40f ) )

enum{
	FLD_DEMO_GINGA_OBJ_SCALE_UP,
	FLD_DEMO_GINGA_OBJ_SCALE_DOWN_WAIT,
	FLD_DEMO_GINGA_OBJ_ROTA_STOP_FLASH,
	FLD_DEMO_GINGA_OBJ_ROTA_STOP,
	FLD_DEMO_GINGA_OBJ_WAIT,
	FLD_DEMO_GINGA_OBJ_SCALE_DOWN,
};

#define FLD_DEMO_GINGA_ANM_NUM	(2)

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	̓IuWFNg
//=====================================
typedef struct {
	FLD_3DOBJ		draw;		// `IuWFNg
	FLD_3DOBJ_MDL	mdl;		// f
	FLD_3DOBJ_ANM	anm[FLD_DEMO_GINGA_ANM_NUM];		// Aj

	FLD_DEMO_FLASH* p_flash;	// tbVIuWFNg

	// p[^
	FLD_DEMO_MOVE_PARAM_FX scale;
	int count;
	int wait;
	TCB_PTR tcb;
	s32 rota_add;
	u16 rota;
	u16 seq;	// V[PX

	fx32 x_scale_way;	// 1or-1
} FLD_DEMO_CLM_GINGA;


//-------------------------------------
//	tB[hOtBbNԕۑ̈
//=====================================
typedef struct _FLD_DEMO_GINGA{
	FIELDSYS_WORK * fsys;			// tB[hVXe
	
	FLD_DEMO_MOTIONBL motion_bl;

	// ̓IuWFNg
	FLD_DEMO_CLM_GINGA ginga;


	// AP[^
	NNSFndAllocator allocator;

	// Xe[^X
	u32 status;

	// [JV[PX
	u32 sub_sequence;

	fx32 x;
	fx32 y;
	fx32 z;
} ;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------

static void FLD_DEMO_GINGA_DeleteReq( FLD_DEMO_GINGA* p_data );


// @j@{^XN
static void FLD_DEMO_CLM_InitDrawSystem( TCB_PTR tcb, void* p_work );
static void FLD_DEMO_CLM_DeleteDrawSystem( TCB_PTR tcb, void* p_work );

// \tgEFAXvCg j
static SWSP_SYS_PTR FLD_DEMO_CLM_InitSwsp( void );
static void FLD_DEMO_CLM_DeleteSwsp( SWSP_SYS_PTR swsp );

// ̓IuWFNg
static void FLD_DEMO_CLM_GingaObjInit( FLD_DEMO_CLM_GINGA* p_obj, NNSFndAllocator* pallocator, u32 heapID, fx32 x, fx32 y, fx32 z );
static void FLD_DEMO_CLM_GingaObjDelete( FLD_DEMO_CLM_GINGA* p_obj, NNSFndAllocator* pallocator );
static BOOL FLD_DEMO_CLM_GingaObjMain( FLD_DEMO_CLM_GINGA* p_obj );
static void FLD_DEMO_CLM_GingaObjEndReq( FLD_DEMO_CLM_GINGA* p_obj );


//----------------------------------------------------------------------------
/**
 *		y̓fz
 *	@brief	̓f[N쐬
 *
 *	@param	heapID	q[v
 *	@param	fsys	tB[hVXe
 *
 *	@return	̓[N
 */
//-----------------------------------------------------------------------------
FLD_DEMO_GINGA* FLD_DEMO_GINGA_Alloc( FIELDSYS_WORK * fsys )
{
	FLD_DEMO_GINGA* p_tmp;
	p_tmp = sys_AllocMemory( USE_HEAPID, sizeof(FLD_DEMO_GINGA) );
	memset( p_tmp, 0, sizeof(FLD_DEMO_GINGA) );

	// FSYSۑ
	p_tmp->fsys = fsys;

	// ԂIɂĂ
	p_tmp->status = FLD_DEMO_GINGA_MOTIONBL_END;

	// AP[^쐬
	sys_InitAllocator( &p_tmp->allocator, USE_HEAPID, 32 );

	return p_tmp;
}

//----------------------------------------------------------------------------
/**
 *		y̓fz
 *	@brief	[Nj
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_GINGA_Free( FLD_DEMO_GINGA* p_data )
{
	// jo܂
	GF_ASSERT( p_data->status == FLD_DEMO_GINGA_MOTIONBL_END );
	sys_FreeMemoryEz( p_data );
}


//----------------------------------------------------------------------------
/**
 *		y̓fz
 *	@brief	
 *
 *	@param	p_data	̓[N
 *	@param	x		W
 *	@param	y		W
 *	@param	z		W
 *
 *	@return	tB[hOtBbNԕۑ̈
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_GINGA_Init( FLD_DEMO_GINGA* p_data, fx32 x, fx32 y, fx32 z )
{
	// Ԑݒ
	p_data->status = FLD_DEMO_GINGA_MOTIONBL_INIT;

	// \Wi[
	p_data->x = x;
	p_data->y = y;
	p_data->z = z;

	// ^XNo^
	TCB_Add( FLD_DEMO_CLM_InitDrawSystem, p_data, FLD_DEMO_GINGA_DRAWSYSTEM_INIT_TCB_PRI );
}

//----------------------------------------------------------------------------
/**
 *	@brief	̓fINGXg
 *
 *	@param	p_data	[N
 *
 *	@return	none
 *
 *	̃NGXgŋ͂ڂŃfI܂
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_GINGA_EndReq( FLD_DEMO_GINGA* p_data )
{
	GF_ASSERT( p_data->status == FLD_DEMO_GINGA_MOTIONBL_REQWAIT );

	p_data->status = FLD_DEMO_GINGA_MOTIONBL_SCALEDOWN;
	FLD_DEMO_CLM_GingaObjEndReq( &p_data->ginga );
}

//----------------------------------------------------------------------------
/**
 *		y̓fz
 *	@brief	̓fj
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_GINGA_DeleteReq( FLD_DEMO_GINGA* p_data )
{
	p_data->sub_sequence = 0;
	p_data->status = FLD_DEMO_GINGA_MOTIONBL_DELETE;

	// j^XNo^
	TCB_Add( FLD_DEMO_CLM_DeleteDrawSystem, p_data, FLD_DEMO_GINGA_DRAWSYSTEM_INIT_TCB_PRI );
}

//----------------------------------------------------------------------------
/**
 *		y̓fz
 *	@brief	݂̏Ԏ擾
 *	
 *	@param	cp_data	[N
 *
 *	@retval	DEMO_GINGA_MOTIONBL_INIT,			// 
 *	@retval	FLD_DEMO_GINGA_MOTIONBL_SCALEUP,	// g咆
 * 	@retval	FLD_DEMO_GINGA_MOTIONBL_REQWAIT,	// kNGXg҂
 *	@retval	FLD_DEMO_GINGA_MOTIONBL_SCALEDOWN,	// k
 *	@retval	DEMO_GINGA_MOTIONBL_DELTE,			// j
 *	@retval	DEMO_GINGA_MOTIONBL_END				// SƏI or O
 */
//-----------------------------------------------------------------------------
u32 FLD_DEMO_GINGA_GetState( const FLD_DEMO_GINGA* cp_data )
{
	return cp_data->status;
}

//----------------------------------------------------------------------------
/**
 *		y̓fz
 *	@brief	[Vu[W̐ݒ
 *
 *	@param	p_data		[N
 *	@param	a			CaptureW
 *	@param	b			CaptureW
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_GINGA_SetMotionBlNum( FLD_DEMO_GINGA* p_data, int a, int b )
{
	MOTION_BL_ParamChg( p_data->motion_bl.motion_bl, a, b );
}


//----------------------------------------------------------------------------
/**
 *		y̓fz
 *	@brief	f`揈
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_GINGA_Draw( FLD_DEMO_GINGA* p_data )
{
	if( (p_data->status == FLD_DEMO_GINGA_MOTIONBL_INIT) ||
		(p_data->status == FLD_DEMO_GINGA_MOTIONBL_DELETE) ||
		(p_data->status == FLD_DEMO_GINGA_MOTIONBL_END) ){
		return ;
	}
	
	// NA
	G3_Identity();	

	NNS_G3dGePushMtx();
	{
		FLD_DEMO_3DObjDrawDraw( &p_data->ginga.draw );
	}
	NNS_G3dGePopMtx(1);
}

//----------------------------------------------------------------------------
/**
 *		y̓fz
 *	@brief	C֐
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_GINGA_Main( FLD_DEMO_GINGA* p_data )
{
	BOOL result;
	
	if( (p_data->status == FLD_DEMO_GINGA_MOTIONBL_INIT) ||
		(p_data->status == FLD_DEMO_GINGA_MOTIONBL_DELETE) ||
		(p_data->status == FLD_DEMO_GINGA_MOTIONBL_END) ){
		return ;
	}
	
	result = FLD_DEMO_CLM_GingaObjMain( &p_data->ginga );

	// ͂̃V[PXFLD_DEMO_GINGA_OBJ_SCALE_DOWN_WAIT
	// ɂȂkNGXg҂
	if( p_data->status == FLD_DEMO_GINGA_MOTIONBL_SCALEUP ){
		if( p_data->ginga.seq == FLD_DEMO_GINGA_OBJ_SCALE_DOWN_WAIT ){
			p_data->status = FLD_DEMO_GINGA_MOTIONBL_REQWAIT;
		}
	}

	// INGXg
	if( result == TRUE ){
		FLD_DEMO_GINGA_DeleteReq( p_data );
	}
}

//----------------------------------------------------------------------------
/**
 *		y̓fz
 *	@brief	`VXe@^XN
 *
 *	@param	tcb		TCB[N
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_CLM_InitDrawSystem( TCB_PTR tcb, void* p_work )
{
	FLD_DEMO_GINGA* p_data = p_work;

	switch( p_data->sub_sequence ){
		
	case 0:
		FLD_DEMO_MOTIONBL_Init( &p_data->motion_bl, p_data->fsys, FLD_DEMO_GINGA_MOTION_BL_EVA, FLD_DEMO_GINGA_MOTION_BL_EVB );
		p_data->sub_sequence ++;
		break;

	case 1:
		FLD_DEMO_MOTIONBL_Main( &p_data->motion_bl );
		if( FLD_DEMO_MOTIONBL_GetState( &p_data->motion_bl ) == FLD_DEMO_MOTIONBL_SEQ_ENDWAIT ){
			p_data->sub_sequence ++;
		}
		break;

	case 2:	// `VXeƃ[N̍쐬
		FLD_DEMO_CLM_GingaObjInit( &p_data->ginga, &p_data->allocator, USE_HEAPID,
			p_data->x, p_data->y, p_data->z	);
		p_data->sub_sequence++;
		break;
		
	case 3:
		p_data->status = FLD_DEMO_GINGA_MOTIONBL_SCALEUP;
		TCB_Delete( tcb );
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *		y̓fz
 *	@brief	`VXe@j^XN
 *
 *	@param	tcb		TCB[N
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_CLM_DeleteDrawSystem( TCB_PTR tcb, void* p_work )
{
	FLD_DEMO_GINGA* p_data = p_work;

	switch( p_data->sub_sequence ){
	case 0:	// OtBbNj
		FLD_DEMO_CLM_GingaObjDelete( &p_data->ginga, &p_data->allocator );
		p_data->sub_sequence++;
		break;

	case 1:	// [Vu[j@ʃZbg
		FLD_DEMO_MOTIONBL_EndReq( &p_data->motion_bl );
		p_data->sub_sequence++;
		break;

	case 2:
		FLD_DEMO_MOTIONBL_Main( &p_data->motion_bl );
		if( FLD_DEMO_MOTIONBL_GetState( &p_data->motion_bl ) == FLD_DEMO_MOTIONBL_SEQ_END ){
			p_data->sub_sequence ++;
		}
		break;
		
	case 3:
		p_data->status = FLD_DEMO_GINGA_MOTIONBL_END;
		TCB_Delete( tcb );
		break;
	}
}


//----------------------------------------------------------------------------
/**
 *		y̓fz
 *	@brief	\tgEFAXvCg
 *
 *	@return	\tgEFAXvCg[N
 */
//-----------------------------------------------------------------------------
static SWSP_SYS_PTR FLD_DEMO_CLM_InitSwsp( void )
{
	SWSP_SYSDATA swsp_sys_data = {
		FLD_DEMO_GINGA_SWSP_OBJNUM,
		FLD_DEMO_GINGA_SWSP_CHARNUM,			
		FLD_DEMO_GINGA_SWSP_PLTTNUM,
		0
	};
	swsp_sys_data.heap = USE_HEAPID;
	return SWSP_SysInit( &swsp_sys_data );
}

//----------------------------------------------------------------------------
/**
 *		y̓fz
 *	@brief	\tgEFAXvCgj
 *
 *	@param	swsp	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_CLM_DeleteSwsp( SWSP_SYS_PTR swsp )
{
	// \tgEFAXvCg
	SWSP_SysDelete( swsp );
}

//----------------------------------------------------------------------------
/**
 *		y̓fz
 *	@brief	̓IuWFNg
 *
 *	@param	p_obj			IuWFNg
 *	@param	pallocator		AP[^
 *	@param	heapID			q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_CLM_GingaObjInit( FLD_DEMO_CLM_GINGA* p_obj, NNSFndAllocator* pallocator, u32 heapID, fx32 x, fx32 y, fx32 z )
{
	int i;


	// tbVIuWFNg쐬
	p_obj->p_flash = FLD_DEMO_Flash_Alloc( USE_HEAPID );
	
	// ff[^ǂݍ
	FLD_DEMO_3DObjMdlLoad( &p_obj->mdl, ARC_FIELD_DEMO_CLI_GRA, NARC_demo_climax_ginga_nsbmd, heapID );

	for( i=0; i<FLD_DEMO_GINGA_ANM_NUM; i++ ){
		// Ajǂݍ
		FLD_DEMO_3DObjAnmLoad( &p_obj->anm[i], &p_obj->mdl, ARC_FIELD_DEMO_CLI_GRA, NARC_demo_climax_ginga_nsbca+i, heapID, pallocator );
	}
	// `惂f
	FLD_DEMO_3DObjDrawInit( &p_obj->draw, &p_obj->mdl );
	for( i=0; i<FLD_DEMO_GINGA_ANM_NUM; i++ ){
		FLD_DEMO_3DObjDrawAddAnm( &p_obj->draw, &p_obj->anm[i] );
	}
	// Ђ傤
	FLD_DEMO_3DObjDrawSetMatrix( &p_obj->draw, x, y, z );
	// キp[^
	FLD_DEMO_MoveInit_FX( &p_obj->scale, FLD_DEMO_GINGA_OBJ_SCAL_S, FLD_DEMO_GINGA_OBJ_SCAL_E, FLD_DEMO_GINGA_OBJ_SCAL_COUNT );
	p_obj->count = 0;
	FLD_DEMO_3DObjDrawSetScale( &p_obj->draw, p_obj->scale.data, p_obj->scale.data, p_obj->scale.data );
	// ]Zl
	p_obj->rota_add  = FLD_DEMO_GINGA_OBJ_ROTA_ADD;
	// V[PX
	p_obj->seq = FLD_DEMO_GINGA_OBJ_SCALE_UP;

	p_obj->x_scale_way = FX32_ONE;
}

//----------------------------------------------------------------------------
/**
 *		y̓fz
 *	@brief	̓IuWFNgj
 *	
 *	@param	p_obj	IuWFNg
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_CLM_GingaObjDelete( FLD_DEMO_CLM_GINGA* p_obj, NNSFndAllocator* pallocator )
{
	int i;
	
	//@fj
	FLD_DEMO_3DObjMdlDelete( &p_obj->mdl );
	
	//@Ajj
	for( i=0; i<FLD_DEMO_GINGA_ANM_NUM; i++ ){
		FLD_DEMO_3DObjAnmDelete( &p_obj->anm[i], pallocator );
	}

	FLD_DEMO_Flash_Free( p_obj->p_flash );

	memset( p_obj, 0, sizeof(FLD_DEMO_CLM_GINGA) );
}

//----------------------------------------------------------------------------
/**
 *		y̓fz
 *	@brief	̓IuWFNgC
 *
 *	@param	p_obj	IuWFNg
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL FLD_DEMO_CLM_GingaObjMain( FLD_DEMO_CLM_GINGA* p_obj )
{
	BOOL result;
	int i;
	
	// gk
	result = FLD_DEMO_MoveMain_FX( &p_obj->scale, p_obj->count );
	FLD_DEMO_3DObjDrawSetScale( &p_obj->draw, FX_Mul( p_obj->scale.data, p_obj->x_scale_way ), FX32_ONE, p_obj->scale.data );

	// Aj
	for( i=0; i<FLD_DEMO_GINGA_ANM_NUM; i++ ){
		FLD_DEMO_3DObjAnmLoopAdd( &p_obj->anm[i], p_obj->rota_add );	
	}

	// tbVC
	FLD_DEMO_Flash_Main( p_obj->p_flash );

	switch( p_obj->seq ){
	case FLD_DEMO_GINGA_OBJ_SCALE_UP:
		if( result != TRUE ){
			p_obj->count ++;
		}else{
			p_obj->seq++;
		}
		break;

	case FLD_DEMO_GINGA_OBJ_SCALE_DOWN_WAIT:
		break;
		
	case FLD_DEMO_GINGA_OBJ_ROTA_STOP_FLASH:
		p_obj->rota_add += FLD_DEMO_GINGA_OBJ_ROTA_SUB;

		if( p_obj->rota_add <= FLD_DEMO_GINGA_OBJ_FLASH_S_NUM ){
			FLD_DEMO_Flash_Start( p_obj->p_flash, 16, 12, 28 );
			p_obj->seq++;
		}
		break;

	case FLD_DEMO_GINGA_OBJ_ROTA_STOP:
		p_obj->rota_add += FLD_DEMO_GINGA_OBJ_ROTA_SUB;

		if( p_obj->rota_add <= 0 ){
			p_obj->seq++;

			// ҂
			p_obj->wait = FLD_DEMO_GINGA_OBJ_WAIT_COUNT;
		}
		break;

	case FLD_DEMO_GINGA_OBJ_WAIT:	// ҂
		p_obj->wait --;
		if( p_obj->wait <= 0 ){
			// ZV[PX
			p_obj->seq++;

			// ]px
			p_obj->rota_add = FLD_DEMO_GINGA_OBJ_SUB_ROTA_ADD;

			// ]
			p_obj->x_scale_way = -FX32_ONE;
			FLD_DEMO_3DObjDrawSetScale( &p_obj->draw, FX_Mul( p_obj->scale.data, p_obj->x_scale_way ), p_obj->scale.data, p_obj->scale.data );

			// キ
			FLD_DEMO_MoveInit_FX( &p_obj->scale, FLD_DEMO_GINGA_OBJ_SCAL_E, FLD_DEMO_GINGA_OBJ_SCAL_S, FLD_DEMO_GINGA_OBJ_SCAL_SUB_COUNT );
			p_obj->count = 0;
		}
		break;
		
	case FLD_DEMO_GINGA_OBJ_SCALE_DOWN:
		if( result != TRUE ){
			p_obj->count ++;
		}else{
			// JEg_EikjresultTUREȂI		
			if( p_obj->seq == FLD_DEMO_GINGA_OBJ_SCALE_DOWN ){
				return TRUE;
			}
		}
		break;
	
	default:
		break;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	INGXg
 *
 *	@param	p_obj	̓IuWFNg
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_CLM_GingaObjEndReq( FLD_DEMO_CLM_GINGA* p_obj )
{
	// ]Xgbv
	p_obj->seq = FLD_DEMO_GINGA_OBJ_ROTA_STOP_FLASH;
}



//-----------------------------------------------------------------------------
/**
 *
 *		yCAEGAoz
 *
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
// f̗
enum{
	FLD_DEMO_LEGENDPOKE_APP_STARTWAIT,
	FLD_DEMO_LEGENDPOKE_APP_EFF_MAIN,
	FLD_DEMO_LEGENDPOKE_APP_POKE_APP_REQ,
	FLD_DEMO_LEGENDPOKE_APP_POKE_APP,
	FLD_DEMO_LEGENDPOKE_APP_CLEAR,
	FLD_DEMO_LEGENDPOKE_APP_END,
};


// `|P萔
#define FLD_DEMO_LEGEND_POKE_OBJ_SCALE_S	( 0 )
#define FLD_DEMO_LEGEND_POKE_OBJ_SCALE_E	( FX32_CONST( 1.50f ) )
#define FLD_DEMO_LEGEND_POKE_OBJ_SCALE_EDOWN	( FX32_CONST( 1 ) )
#define FLD_DEMO_LEGEND_POKE_OBJ_COUNT		( 6 )
#define FLD_DEMO_LEGEND_POKE_OBJ_COUNTDOWN	( 2 )
#define FLD_DEMO_LEGEND_POKE_OBJ_MOVE_Y		( FX32_CONST( 32 ) )
#define FLD_DEMO_LEGEND_POKE_OBJ_MOVE_COUNT	( 44 )
enum{
	FLD_DEMO_LEGENDPOKEOBJ_SEQ_STARTWAIT,
	FLD_DEMO_LEGENDPOKEOBJ_SEQ_SCALE_UP,
	FLD_DEMO_LEGENDPOKEOBJ_SEQ_SCALE_DOWN,
	FLD_DEMO_LEGENDPOKEOBJ_SEQ_MOVE,
	FLD_DEMO_LEGENDPOKEOBJ_SEQ_END,
};

// 3D̪Ē萔
enum{
	FLD_DEMO_LEGENDEFF_ANMOBJ_CA,
	FLD_DEMO_LEGENDEFF_ANMOBJ_MA,
	FLD_DEMO_LEGENDEFF_ANMOBJ_TA,
	FLD_DEMO_LEGENDEFF_ANMOBJ_VA,
	FLD_DEMO_LEGENDEFF_ANMOBJ_NUM,
};
enum{
	FLD_DEMO_LEGENDEFF_SEQ_ANM,
	FLD_DEMO_LEGENDEFF_SEQ_FEDEOUT_WAIT,
	FLD_DEMO_LEGENDEFF_SEQ_FADEOUT,
	FLD_DEMO_LEGENDEFF_SEQ_END,
};

#define FLD_DEMO_LEGENDEFF_MOVE_Y_OFS	( 0x0*FX32_ONE )	// |PYWƑ𒆐Sɂ̂Ń|P̒Sɂł悤ɂ
#define FLD_DEMO_LEGENDEFF_MOVE_Z_OFS	( -0x10*FX32_ONE )	// |PzWƃ|PƂԂ̂ŉɂ
#define FLD_DEMO_LEGENDEFF_MOVE_Y_DIS	( FX32_CONST( 0xF8 ) )
#define FLD_DEMO_LEGENDEFF_MOVE_SYNC	( 84 )
#define FLD_DEMO_LEGENDEFF_MOVE_SYNC_OUT	( 16 )


//-------------------------------------
//	EGCg
//=====================================
#define FLD_DEMO_LEGENDDEFF_SND_00_WAIT	( 82 )
#define FLD_DEMO_LEGENDDEFF_SND_01_WAIT	( 72 )
#define FLD_DEMO_LEGENDDEFF_SND_04_WAIT	( 300 )
#define FLD_DEMO_LEGENDDEFF_SND_05_WAIT	( 132 )



//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	`|P샏[N
//=====================================
typedef struct {
	FIELD_OBJ_PTR p_fldobj;
	FLD_DEMO_MOVE_PARAM_FX scale;
	FLD_DEMO_MOVE_PARAM_FX move;
	int count;
	int seq;
} FLD_DEMO_LEGENDPOKE;

//-------------------------------------
//	`|P̂RD̪ăIuWFNg
//=====================================
typedef struct {
	FLD_3DOBJ		draw;		// `IuWFNg
	FLD_3DOBJ_MDL		mdl;		// f
	FLD_3DOBJ_ANM		anm[FLD_DEMO_LEGENDEFF_ANMOBJ_NUM];	// Aj
	u32 seq;
	FLD_DEMO_MOVE_PARAM_FX scale;
	int count;

	int snd_count;	// JEg
	int snd_seq;

#ifdef FIELD_DEMO_DEBUG
	u32 debug_count;
#endif
} FLD_DEMO_LEGEND3D_EFF;


//-------------------------------------
//	CAGAo@[N
//=====================================
typedef struct _FLD_DEMO_LEGENDPOKE_APP{
	u32 seq;		// V[PX
	FIELDSYS_WORK * fsys;	// tB[hVXe
	FLD_DEMO_LEGENDPOKE legend_poke;// `|P
	FLD_DEMO_LEGEND3D_EFF legend_eff;// 3D̪OBJ
	NNSFndAllocator allocator;
	u32 heapID;

};

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void FldDemo_LegendPokeObjInit( FLD_DEMO_LEGENDPOKE* p_obj, FIELDSYS_WORK * fsys, u32 obj_id );
static void FldDemo_LegendPokeObjStart( FLD_DEMO_LEGENDPOKE* p_obj );
static BOOL FldDemo_LegendPokeObjMain( FLD_DEMO_LEGENDPOKE* p_obj );
static BLACT_WORK_PTR FldDemo_LegendPokeObjFldobjGetActor( FLD_DEMO_LEGENDPOKE* p_obj );
static void FldDemo_LefendPokeObjScaleSet( BLACT_WORK_PTR act, fx32 scale );

static void FldDemo_LegendEffObjAlloc( FLD_DEMO_LEGEND3D_EFF* p_eff, u32 heapID, NNSFndAllocator* p_allocator );
static void FldDemo_LegendEffObjInit( FLD_DEMO_LEGEND3D_EFF* p_eff, fx32 x, fx32 y, fx32 z );
static void FldDemo_LegendEffObjDelete( FLD_DEMO_LEGEND3D_EFF* p_eff, NNSFndAllocator* p_allocator );
static u32 FldDemo_LegendEffObjMain( FLD_DEMO_LEGEND3D_EFF* p_eff );
static void FldDemo_LegendEffObjDraw( FLD_DEMO_LEGEND3D_EFF* p_eff );
static void FldDemo_LegendEffObjEndReq( FLD_DEMO_LEGEND3D_EFF* p_eff );
static void FldDemo_LegendEffObjMoveY( FLD_DEMO_LEGEND3D_EFF* p_eff, fx32 y );

static void FldDemo_LegendEffObjSndMain( FLD_DEMO_LEGEND3D_EFF* p_eff );

//----------------------------------------------------------------------------
/**
 *		yCAEGAoz
 *	@brief	[N쐬
 *
 *	@param	heapID		q[vID
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
FLD_DEMO_LEGENDPOKE_APP* FLD_DEMO_LegendPokeApp_Alloc( u32 heapID, FIELDSYS_WORK * fsys )
{
	FLD_DEMO_LEGENDPOKE_APP* p_data;
	p_data = sys_AllocMemory( heapID, sizeof(FLD_DEMO_LEGENDPOKE_APP) );
	memset( p_data, 0, sizeof(FLD_DEMO_LEGENDPOKE_APP) );
	p_data->fsys = fsys;
	p_data->seq = FLD_DEMO_LEGENDPOKE_APP_STARTWAIT;
	p_data->heapID = heapID;

	// AP[^[쐬
	sys_InitAllocator( &p_data->allocator, heapID, 32 );

	// ̪ăOtBbNt@C
	FldDemo_LegendEffObjAlloc( &p_data->legend_eff, p_data->heapID, &p_data->allocator );
	
	return p_data;
}

//----------------------------------------------------------------------------
/**
 *		yCAEGAoz
 *	@brief	[Nj
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_LegendPokeApp_Free( FLD_DEMO_LEGENDPOKE_APP* p_data )
{
	// ̪Ĕj
	FldDemo_LegendEffObjDelete( &p_data->legend_eff, &p_data->allocator );
	
	sys_FreeMemoryEz( p_data );
}

//----------------------------------------------------------------------------
/**
 *		yCAEGAoz
 *	@brief	fJn
 *
 *	@param	p_data			[N
 *	@param	legendpoke_id	`|PtB[hIuWFǗID
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_LegendPokeApp_Start( FLD_DEMO_LEGENDPOKE_APP* p_data, u32 legendpoke_id )
{
	VecFx32 mat;
	
	// `|P[N쐬
	FldDemo_LegendPokeObjInit( &p_data->legend_poke, p_data->fsys, legendpoke_id );

	// |P̍W擾
	FieldOBJ_VecPosGet( p_data->legend_poke.p_fldobj, &mat );


	// |P̑|P̒S֕\YʒuύX
	mat.y += FLD_DEMO_LEGENDEFF_MOVE_Y_OFS;
	mat.z += FLD_DEMO_LEGENDEFF_MOVE_Z_OFS;
	

	// ̪Ẵ[N쐬
	FldDemo_LegendEffObjInit( &p_data->legend_eff, mat.x, mat.y, mat.z );

	// Jn
	p_data->seq  = FLD_DEMO_LEGENDPOKE_APP_EFF_MAIN;
}

//----------------------------------------------------------------------------
/**
 *		yCAEGAoz
 *	@brief	tB[hIuWFNgI`FbN
 *
 *	@param	p_data	[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL FLD_DEMO_LegendPokeApp_EndCheck( FLD_DEMO_LEGENDPOKE_APP* p_data )
{
	if( (p_data->seq == FLD_DEMO_LEGENDPOKE_APP_STARTWAIT) ||
		(p_data->seq == FLD_DEMO_LEGENDPOKE_APP_END) ){
		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *		yCAEGAoz
 *	@brief	C
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_LegendPokeApp_Main( FLD_DEMO_LEGENDPOKE_APP* p_data )
{
	switch( p_data->seq ){
	case FLD_DEMO_LEGENDPOKE_APP_STARTWAIT:
		break;

	case FLD_DEMO_LEGENDPOKE_APP_EFF_MAIN:
		{
			u32 seq;
			seq = FldDemo_LegendEffObjMain( &p_data->legend_eff );
			if( seq == FLD_DEMO_LEGENDEFF_SEQ_FEDEOUT_WAIT ){
				p_data->seq ++;
			}
		}
		break;

	case FLD_DEMO_LEGENDPOKE_APP_POKE_APP_REQ:
		// |Po
		FldDemo_LegendPokeObjStart( &p_data->legend_poke );
		// ̪ďI
		FldDemo_LegendEffObjEndReq( &p_data->legend_eff );

		FldDemo_LegendEffObjMain( &p_data->legend_eff );
		p_data->seq ++;
		break;
		
	case FLD_DEMO_LEGENDPOKE_APP_POKE_APP:
		FldDemo_LegendEffObjMain( &p_data->legend_eff );
		if( FldDemo_LegendPokeObjMain( &p_data->legend_poke ) ){
			p_data->seq ++;
		}
		break;

	case FLD_DEMO_LEGENDPOKE_APP_CLEAR:
		p_data->seq ++;
		break;
		
	case FLD_DEMO_LEGENDPOKE_APP_END:
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *		yCAEGAoz
 *	@brief	`揈
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */	
//-----------------------------------------------------------------------------
void FLD_DEMO_LegendPokeApp_Draw( FLD_DEMO_LEGENDPOKE_APP* p_data )
{
	if( FLD_DEMO_LegendPokeApp_EndCheck( p_data ) == TRUE ){
		return;
	}
	
	FldDemo_LegendEffObjDraw( &p_data->legend_eff );
}

//----------------------------------------------------------------------------
/**
 *		yCAEGAoz
 *	@brief	`|P[N̏
 *
 *	@param	p_obj	IuWFNg
 *	@param	fsys	tB[hVXe
 *	@param	obj_id	IuWFNgID
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FldDemo_LegendPokeObjInit( FLD_DEMO_LEGENDPOKE* p_obj, FIELDSYS_WORK* fsys, u32 obj_id )
{
	// tB[hIuWFNg擾
	p_obj->p_fldobj = FieldOBJSys_OBJIDSearch( fsys->fldobjsys, obj_id );
	GF_ASSERT( p_obj->p_fldobj );
	
	p_obj->count = 0;
	p_obj->seq = FLD_DEMO_LEGENDPOKEOBJ_SEQ_STARTWAIT;
}

//----------------------------------------------------------------------------
/**
 *		yCAEGAoz
 *	@brief	AjJn
 *
 *	@param	p_obj	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FldDemo_LegendPokeObjStart( FLD_DEMO_LEGENDPOKE* p_obj )
{
	BLACT_WORK_PTR p_act;
	VecFx32 ofs;

	// AN^[[N擾
	p_act = FldDemo_LegendPokeObjFldobjGetActor( p_obj );
	
	// Jn
	p_obj->seq = FLD_DEMO_LEGENDPOKEOBJ_SEQ_SCALE_UP;

	// tB[hIuWFJn
	FieldOBJ_StatusBitSet_Vanish( p_obj->p_fldobj, FALSE );

	// AN^[̊gklݒ
	FldDemo_LefendPokeObjScaleSet( p_act, FLD_DEMO_LEGEND_POKE_OBJ_SCALE_S );

	// gk
	FLD_DEMO_MoveInit_FX( &p_obj->scale, FLD_DEMO_LEGEND_POKE_OBJ_SCALE_S, FLD_DEMO_LEGEND_POKE_OBJ_SCALE_E, FLD_DEMO_LEGEND_POKE_OBJ_COUNT );

	// ړ
	FLD_DEMO_MoveInit_FX( &p_obj->move, FLD_DEMO_LEGEND_POKE_OBJ_MOVE_Y, 0, FLD_DEMO_LEGEND_POKE_OBJ_MOVE_COUNT );

	// WύX
	// YItZbgݒ
	ofs.x = 0;
	ofs.y = p_obj->move.data;
	ofs.z = 0;
	FieldOBJ_VecDrawOffsOutSideSet( p_obj->p_fldobj, &ofs );
}

//----------------------------------------------------------------------------
/**
 *		yCAEGAoz
 *	@brief	`|PC
 *
 *	@param	p_obj	IuWFNg
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	쒆
 */
//-----------------------------------------------------------------------------
static BOOL FldDemo_LegendPokeObjMain( FLD_DEMO_LEGENDPOKE* p_obj )
{
	BLACT_WORK_PTR p_act;	// AN^[[N
	BOOL result;
	VecFx32 ofs;

	// AN^[[N擾
	p_act = FldDemo_LegendPokeObjFldobjGetActor( p_obj );

	switch( p_obj->seq ){
	case FLD_DEMO_LEGENDPOKEOBJ_SEQ_STARTWAIT:
		break;
		
	case FLD_DEMO_LEGENDPOKEOBJ_SEQ_SCALE_UP:
		p_obj->count++;
		result = FLD_DEMO_MoveMain_FX( &p_obj->scale, p_obj->count );
		FldDemo_LefendPokeObjScaleSet( p_act, p_obj->scale.data );
		if( result == TRUE ){
			// gk
			FLD_DEMO_MoveInit_FX( &p_obj->scale, FLD_DEMO_LEGEND_POKE_OBJ_SCALE_E, FLD_DEMO_LEGEND_POKE_OBJ_SCALE_EDOWN, FLD_DEMO_LEGEND_POKE_OBJ_COUNTDOWN );
			p_obj->count = 0;
			p_obj->seq++;
		}
		break;

	case FLD_DEMO_LEGENDPOKEOBJ_SEQ_SCALE_DOWN:
		p_obj->count++;
		result = FLD_DEMO_MoveMain_FX( &p_obj->scale, p_obj->count );
		FldDemo_LefendPokeObjScaleSet( p_act, p_obj->scale.data );
		if( result == TRUE ){
			p_obj->count = 0;
			p_obj->seq++;
		}
		break;

	case FLD_DEMO_LEGENDPOKEOBJ_SEQ_MOVE:
		p_obj->count++;
		result = FLD_DEMO_MoveMain_FX( &p_obj->move, p_obj->count );
		// YItZbgݒ
		ofs.x = 0;
		ofs.y = p_obj->move.data;
		ofs.z = 0;
		FieldOBJ_VecDrawOffsOutSideSet( p_obj->p_fldobj, &ofs );
		if( result == TRUE ){
			p_obj->seq++;
		}
		break;
		
	case FLD_DEMO_LEGENDPOKEOBJ_SEQ_END:
		return TRUE;
	
	default:
		break;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *		yCAEGAoz
 *	@brief	`ۂ񃏁[Nr{[hAN^[擾
 *
 *	@param	p_obj	[N
 *
 *	@return	r{[hAN^[
 */
//-----------------------------------------------------------------------------
static BLACT_WORK_PTR FldDemo_LegendPokeObjFldobjGetActor( FLD_DEMO_LEGENDPOKE* p_obj )
{
	LEGENDPOKE_WORK* p_legend_w;

	p_legend_w = FieldOBJ_DrawLegend_GetWrokPtr( p_obj->p_fldobj );
	return FieldOBJ_DrawLegend_GetBlactPtr( p_legend_w );
}

//----------------------------------------------------------------------------
/**
 *		yCAEGAoz
 *	@brief	gklݒ
 *
 *	@param	act		r{[hAN^[
 *	@param	scale	gkl
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FldDemo_LefendPokeObjScaleSet( BLACT_WORK_PTR act, fx32 scale )
{
	VecFx32	scale_vec;
	scale_vec.x = scale;
	scale_vec.y = FX32_ONE;
	scale_vec.z = FX32_ONE;
	BLACT_ScaleSet( act, &scale_vec );
}


//----------------------------------------------------------------------------
/**
 *		yCAEGAoz
 *	@brief	̪ăIuWF@`揉
 *
 *	@param	p_eff		̪ă[N
 *	@param	heapID		q[vID
 *	@param	p_allocator	AP[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FldDemo_LegendEffObjAlloc( FLD_DEMO_LEGEND3D_EFF* p_eff, u32 heapID, NNSFndAllocator* p_allocator )
{
	int i;
	
	// fǂݍ
	FLD_DEMO_3DObjMdlLoad( &p_eff->mdl, ARC_FIELD_DEMO_CLI_GRA, NARC_demo_climax_kurotama_nsbmd, heapID );	

	// Ajǂݍ
	for( i=0; i<FLD_DEMO_LEGENDEFF_ANMOBJ_NUM; i++ ){
		FLD_DEMO_3DObjAnmLoad( &p_eff->anm[i],
				&p_eff->mdl, ARC_FIELD_DEMO_CLI_GRA,
				NARC_demo_climax_kurotama_nsbca + i, 
				heapID, p_allocator );
	}

	// `IuWFNg쐬
	FLD_DEMO_3DObjDrawInit( &p_eff->draw, &p_eff->mdl );
	for( i=0; i<FLD_DEMO_LEGENDEFF_ANMOBJ_NUM; i++ ){
		FLD_DEMO_3DObjDrawAddAnm( &p_eff->draw, &p_eff->anm[i] );
	}

	// \OFF
	FLD_DEMO_3DObjDrawSetDraw( &p_eff->draw, FALSE );
}

//----------------------------------------------------------------------------
/**
 *		yCAEGAoz
 *	@brief	̪ăIuWFNg
 *
 *	@param	p_eff			̪ăIuWFNg
 *	@param	x				xW
 *	@param	y				yW
 *	@param	z				zW
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FldDemo_LegendEffObjInit( FLD_DEMO_LEGEND3D_EFF* p_eff, fx32 x, fx32 y, fx32 z )
{
	int i;

	// ݒ
	FLD_DEMO_3DObjDrawSetMatrix( &p_eff->draw, x, y, z );

	FLD_DEMO_3DObjDrawSetScale( &p_eff->draw, FX32_ONE, FX32_ONE, FX32_ONE );

	// t[ݒ
	for( i=0; i<FLD_DEMO_LEGENDEFF_ANMOBJ_NUM; i++ ){
		FLD_DEMO_3DObjAnmSet( &p_eff->anm[i], 0 );
	}
	p_eff->count = 0;
	p_eff->seq = 0;
	
	p_eff->snd_count = FLD_DEMO_LEGENDDEFF_SND_00_WAIT;
	p_eff->snd_seq = 0;

#ifdef FIELD_DEMO_DEBUG
	p_eff->debug_count = 0;
#endif

	// \ON
	FLD_DEMO_3DObjDrawSetDraw( &p_eff->draw, TRUE );
}

//----------------------------------------------------------------------------
/**
 *		yCAEGAoz
 *	@brief	̪ăIuWFNgj
 *
 *	@param	p_eff			̪ăIuWFNg
 *	@param	p_allocator		AP[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FldDemo_LegendEffObjDelete( FLD_DEMO_LEGEND3D_EFF* p_eff, NNSFndAllocator* p_allocator )
{
	int i;
	// fj
	FLD_DEMO_3DObjMdlDelete( &p_eff->mdl );

	// Ajj
	for( i=0; i<FLD_DEMO_LEGENDEFF_ANMOBJ_NUM; i++ ){
		FLD_DEMO_3DObjAnmDelete( &p_eff->anm[ i ], p_allocator );
	}
}

//----------------------------------------------------------------------------
/**
 *		yCAEGAoz
 *	@brief	̪ăIuWFNgC֐
 *
 *	@param	p_eff	̪ăIuWFNg
 *
 * @retval	V[PX
 */
//-----------------------------------------------------------------------------
static u32 FldDemo_LegendEffObjMain( FLD_DEMO_LEGEND3D_EFF* p_eff )
{
	BOOL result;
	int i;

#ifdef FIELD_DEMO_DEBUG
	p_eff->debug_count ++;

	if( sys.trg & PAD_BUTTON_L ){
		OS_Printf( "p_eff->debug_count %d\n", p_eff->debug_count );
	}
#endif
	
	switch( p_eff->seq ){
	case FLD_DEMO_LEGENDEFF_SEQ_ANM:		// Aj
		// [vȂAj
		for( i=0; i<FLD_DEMO_LEGENDEFF_ANMOBJ_NUM; i++ ){
			result = FLD_DEMO_3DObjAnmNoLoop( &p_eff->anm[i] );
		}
		
		if( result == TRUE ){
			p_eff->seq ++;
		}
		break;

	case FLD_DEMO_LEGENDEFF_SEQ_FEDEOUT_WAIT:
		break;

	case FLD_DEMO_LEGENDEFF_SEQ_FADEOUT:	// tF[hAEg
		p_eff->count  ++;
		result = FLD_DEMO_MoveMain_FX( &p_eff->scale, p_eff->count );
		FLD_DEMO_3DObjDrawSetScale( &p_eff->draw, p_eff->scale.data, p_eff->scale.data, p_eff->scale.data );
		if( result == TRUE ){
			p_eff->seq++;
			// \OFF
			FLD_DEMO_3DObjDrawSetDraw( &p_eff->draw, FALSE );
		}
		break;
		
	case FLD_DEMO_LEGENDEFF_SEQ_END:
		break;

	defautl:
		break;
	}

	// C
	FldDemo_LegendEffObjSndMain( p_eff );

	return p_eff->seq;
}

//----------------------------------------------------------------------------
/**
 *	@brief	YWݒ֐
 *
 *	@param	p_eff	[N
 *	@param	y		W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FldDemo_LegendEffObjMoveY( FLD_DEMO_LEGEND3D_EFF* p_eff, fx32 y )
{
	VecFx32 matrix;

	// W擾
	FLD_DEMO_3DObjDrawGetMatrix( &p_eff->draw, &matrix.x,  &matrix.y, &matrix.z );
	// ݒ
	matrix.y = y;
	FLD_DEMO_3DObjDrawSetMatrix( &p_eff->draw, matrix.x, matrix.y, matrix.z );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Ɩ炵C
 *
 *	@param	p_eff [N
 */
//-----------------------------------------------------------------------------
static void FldDemo_LegendEffObjSndMain( FLD_DEMO_LEGEND3D_EFF* p_eff )
{
	switch( p_eff->snd_seq ){
	case 0:
		p_eff->snd_count --;
		if( p_eff->snd_count < 0 ){
			Snd_SePlay( FLD_DEMO_LEGENDEFF_SND_00 );
			p_eff->snd_count = FLD_DEMO_LEGENDDEFF_SND_01_WAIT;
			p_eff->snd_seq = 1;
		}
		break;
	
	case 1:
		p_eff->snd_count --;
		if( p_eff->snd_count < 0 ){
			Snd_SePlay( FLD_DEMO_LEGENDEFF_SND_01 );
			p_eff->snd_count = FLD_DEMO_LEGENDDEFF_SND_04_WAIT;
			p_eff->snd_seq = 2;
		}
		break;

	case 2:
		p_eff->snd_count --;
		if( p_eff->snd_count < 0 ){
			Snd_SePlay( FLD_DEMO_LEGENDEFF_SND_04 );
			p_eff->snd_count = FLD_DEMO_LEGENDDEFF_SND_05_WAIT;
			p_eff->snd_seq = 3;
		}
		break;

	case 3:
		p_eff->snd_count --;
		if( p_eff->snd_count < 0 ){
			Snd_SePlay( FLD_DEMO_LEGENDEFF_SND_05 );
			p_eff->snd_seq = 4;
		}
		break;

	case 4:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	̪ďINGXg
 *
 *	@param	p_eff	̪ăIuWF
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FldDemo_LegendEffObjEndReq( FLD_DEMO_LEGEND3D_EFF* p_eff )
{
	p_eff->seq = FLD_DEMO_LEGENDEFF_SEQ_FADEOUT;
	p_eff->count = 0;

	// gkݒ
	FLD_DEMO_MoveInit_FX( &p_eff->scale, FX32_ONE, 0, FLD_DEMO_LEGENDEFF_MOVE_SYNC_OUT );
}

//----------------------------------------------------------------------------
/**
 *	@brief	̪ăIuWFNg`
 *
 *	@param	p_eff ̪ă[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FldDemo_LegendEffObjDraw( FLD_DEMO_LEGEND3D_EFF* p_eff )
{
	FLD_DEMO_3DObjDrawDraw( &p_eff->draw );
}


//-----------------------------------------------------------------------------
/**
 *
 *		yCAEGA𒆐Soz
 * 
 */
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define FLD_DEMO_BLACK_RING_NUM	( 3 )
//-------------------------------------
//	
//=====================================
enum{
	FLD_DEMO_BLACKRING_STANDBY,
	FLD_DEMO_BLACKRING_DO,

	// OIuWFNg
	FLD_DEMO_BLACKRINGOBJ_STANDBY = 0,
	FLD_DEMO_BLACKRINGOBJ_DO,
};

// OtBbNNO
#define FLD_DEMO_BLACK_RING_IMD	( NARC_demo_climax_ring_t_nsbmd )
//int FLD_DEMO_BLACK_RING_IMD	= NARC_demo_climax_ring_h_nsbmd;

// ѕ`Jn^C~O
#define FLD_DEMO_BLACK_RING_START_TIMING	( 64 )

// 1уIuWFNg
#define FLD_DEMO_BLACKRING_OBJ_SSCALE	(0)
#define FLD_DEMO_BLACKRING_OBJ_ESCALE	( FX32_CONST(16) )
#define FLD_DEMO_BLACKRING_OBJ_SYNC		(96)
#define FLD_DEMO_BLACKRING_OBJ_OFS_X	(GRID_HALF_FX32)
#define FLD_DEMO_BLACKRING_OBJ_GRID_Y	(10)
#define FLD_DEMO_BLACKRING_OBJ_GRID_Z	(1)
//int FLD_DEMO_BLACKRING_OBJ_GRID_Y	= 2;
//int FLD_DEMO_BLACKRING_OBJ_GRID_Z	= 1;

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	IuWFNg
//=====================================
typedef struct {
	u32 status;					// Xe[^X
	FLD_3DOBJ draw;	// `惏[N
	FLD_DEMO_MOVE_PARAM_FX scale;	// gkp[^
	int count;
} FLD_DEMO_BLACK_RING_OBJ;


//-------------------------------------
//	CAEGA𒆐Sɂo@[N
//=====================================
typedef struct _FLD_DEMO_BLACK_RING{
	FLD_3DOBJ_MDL mdl;			// f
	FLD_DEMO_BLACK_RING_OBJ blackring[ FLD_DEMO_BLACK_RING_NUM ];
	u32 status;					// Xe[^X
	s32 start_count;
	s32 start_count_max;
	fx32 x;
	fx32 y;
	fx32 z;
	u16 rota_x;
	u16 rota_y;
	u16 rota_z;
};


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static FLD_DEMO_BLACK_RING* FLD_DEMO_BlackRing_Alloc_Core( u32 heapID, u32 dataIdx );
static void FLD_DEMO_BlackRing_Free_Core( FLD_DEMO_BLACK_RING* p_data );
static void FLD_DEMO_BlackRing_Start_Core( FLD_DEMO_BLACK_RING* p_data, fx32 x, fx32 y, fx32 z, s32 start_count, u16 rota_x, u16 rota_y, u16 rota_z );
static void FLD_DEMO_BlackRing_Main_Core( FLD_DEMO_BLACK_RING* p_data );
static void FLD_DEMO_BlackRing_Draw_Core( FLD_DEMO_BLACK_RING* p_data );

static void FLD_DEMO_BlackRingObj_Init( FLD_DEMO_BLACK_RING_OBJ* p_obj, FLD_3DOBJ_MDL* p_mdl );
static void FLD_DEMO_BlackRingObj_Delete( FLD_DEMO_BLACK_RING_OBJ* p_obj );
static void FLD_DEMO_BlackRingObj_Start( FLD_DEMO_BLACK_RING_OBJ* p_obj, fx32 s_scale, fx32 e_scale, int sync, fx32 x, fx32 y, fx32 z, u16 rota_x, u16 rota_y, u16 rota_z );
static void FLD_DEMO_BlackRingObj_Main( FLD_DEMO_BLACK_RING_OBJ* p_obj );
static void FLD_DEMO_BlackRingObj_Draw( FLD_DEMO_BLACK_RING_OBJ* p_obj );
static FLD_DEMO_BLACK_RING_OBJ* FLD_DEMO_BlackRingCleanObjGet( FLD_DEMO_BLACK_RING* p_data );


//----------------------------------------------------------------------------
/**
 *		yOz
 *	@brief	[NmCore
 *
 *	@param	heapID		q[v
 *	@param	dataIdx		f[^IDX
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
static FLD_DEMO_BLACK_RING* FLD_DEMO_BlackRing_Alloc_Core( u32 heapID, u32 dataIdx )
{
	FLD_DEMO_BLACK_RING* p_data;
	int i;

	p_data = sys_AllocMemory( heapID, sizeof(FLD_DEMO_BLACK_RING) );
	memset( p_data, 0, sizeof(FLD_DEMO_BLACK_RING) );
	
	// fǂݍ
	FLD_DEMO_3DObjMdlLoad( &p_data->mdl, ARC_FIELD_DEMO_CLI_GRA, dataIdx, heapID );

	// `揉
	for( i=0; i<FLD_DEMO_BLACK_RING_NUM; i++ ){
		FLD_DEMO_BlackRingObj_Init( &p_data->blackring[i], &p_data->mdl );
	}
	p_data->status = FLD_DEMO_BLACKRING_STANDBY;

	return p_data;
}

//----------------------------------------------------------------------------
/**
 *		yOz
 *	@brief	[Nj
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_BlackRing_Free_Core( FLD_DEMO_BLACK_RING* p_data )
{
	int i;

	// `揉
	for( i=0; i<FLD_DEMO_BLACK_RING_NUM; i++ ){
		FLD_DEMO_BlackRingObj_Delete( &p_data->blackring[i] );
	}
	
	// ff[^j
	FLD_DEMO_3DObjMdlDelete( &p_data->mdl );
	sys_FreeMemoryEz( p_data );
}

//----------------------------------------------------------------------------
/**
 *		yOz
 *	@brief@̪ĊJn
 *
 *	@param	p_data	[N
 *	@param	x		W
 *	@param	y		W
 *	@param	z		W
 *	@param	start_count	JnJEgl
 *	@param	rota_x	y]p
 *	@param	rota_y	y]p
 *	@param	rota_z	z]p
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_BlackRing_Start_Core( FLD_DEMO_BLACK_RING* p_data, fx32 x, fx32 y, fx32 z, s32 start_count, u16 rota_x, u16 rota_y, u16 rota_z )
{
	GF_ASSERT( p_data->status == FLD_DEMO_BLACKRING_STANDBY );

	p_data->start_count = 0;
	p_data->x = x;
	p_data->y = y;
	p_data->z = z;
	p_data->rota_x = rota_x;
	p_data->rota_y = rota_y;
	p_data->rota_z = rota_z;
	p_data->start_count_max = start_count;
	p_data->status = FLD_DEMO_BLACKRING_DO;
}

//----------------------------------------------------------------------------
/**
 *		yOz
 *	@brief	̪ăC
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_BlackRing_Main_Core( FLD_DEMO_BLACK_RING* p_data )
{
	int i;
	FLD_DEMO_BLACK_RING_OBJ* p_obj;
	
	// ˊǗ
	p_data->start_count --;
	if( p_data->start_count < 0 ){
		p_data->start_count = p_data->start_count_max;
	
		p_obj = FLD_DEMO_BlackRingCleanObjGet( p_data );
		GF_ASSERT( p_obj );	// 󂫃IuWFȂ

		// IuWFJn
		FLD_DEMO_BlackRingObj_Start( p_obj, 
				FLD_DEMO_BLACKRING_OBJ_SSCALE,
				FLD_DEMO_BLACKRING_OBJ_ESCALE,
				FLD_DEMO_BLACKRING_OBJ_SYNC,
				p_data->x, 
				p_data->y, 
				p_data->z,
				p_data->rota_x,
				p_data->rota_y,
				p_data->rota_z
				);
	}

	// IuWFNg암
	for( i=0; i<FLD_DEMO_BLACK_RING_NUM; i++ ){
		FLD_DEMO_BlackRingObj_Main( &p_data->blackring[ i ] );
	}
}

//----------------------------------------------------------------------------
/**
 *		yOz
 *	@brief	̪ĕ`
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_BlackRing_Draw_Core( FLD_DEMO_BLACK_RING* p_data )
{
	int i;
	// IuWFNg`敔
	for( i=0; i<FLD_DEMO_BLACK_RING_NUM; i++ ){
		FLD_DEMO_BlackRingObj_Draw( &p_data->blackring[ i ] );
	}
}







//----------------------------------------------------------------------------
/**
 *		yCAEGA𒆐Soz
 *	@brief	[Nm
 *
 *	@param	heapID	q[v
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
FLD_DEMO_BLACK_RING* FLD_DEMO_BlackRing_Alloc( u32 heapID )
{
	return FLD_DEMO_BlackRing_Alloc_Core( heapID, FLD_DEMO_BLACK_RING_IMD );
}

//----------------------------------------------------------------------------
/**
 *		yCAEGA𒆐Soz
 *	@brief	[Nj
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_BlackRing_Free( FLD_DEMO_BLACK_RING* p_data )
{
	FLD_DEMO_BlackRing_Free_Core( p_data );
}

//----------------------------------------------------------------------------
/**
 *		yCAEGA𒆐Soz
 *	@brief	fX^[g
 *
 *	@param	p_data	[N
 *	@param	grid_x	CAGAʒuObh
 *	@param	grid_y	CAGAʒuObh
 *	@param	grid_z	CAGAʒuObh
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_BlackRing_Start( FLD_DEMO_BLACK_RING* p_data, u16 grid_x, u16 grid_y, u16 grid_z )
{
	FLD_DEMO_BlackRing_Start_Core( p_data, 
			GRID_SIZE_FX32( grid_x ) + FLD_DEMO_BLACKRING_OBJ_OFS_X,
			GRID_SIZE_FX32( grid_y ) + GRID_SIZE_FX32( FLD_DEMO_BLACKRING_OBJ_GRID_Y ),
			GRID_SIZE_FX32( grid_z ) + GRID_SIZE_FX32( FLD_DEMO_BLACKRING_OBJ_GRID_Z ),
			FLD_DEMO_BLACK_RING_START_TIMING, 0, 0, 0 );
}

//----------------------------------------------------------------------------
/**
 *		yCAEGA𒆐Soz
 *	@brief	fC
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_BlackRing_Main( FLD_DEMO_BLACK_RING* p_data )
{
	FLD_DEMO_BlackRing_Main_Core( p_data );
}

//----------------------------------------------------------------------------
/**
 *		yCAEGA𒆐Soz
 *	@brief	`
 *
 *	@param	p_data	[N
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_BlackRing_Draw( FLD_DEMO_BLACK_RING* p_data )
{
	FLD_DEMO_BlackRing_Draw_Core( p_data );
}



//----------------------------------------------------------------------------
/**
 *		yCAEGA𒆐Soz
 *	@brief	OIuWFNg
 *
 *	@param	p_obj		[N
 *	@param	p_mdl		f
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_BlackRingObj_Init( FLD_DEMO_BLACK_RING_OBJ* p_obj, FLD_3DOBJ_MDL* p_mdl )
{
	memset( p_obj, 0, sizeof(FLD_DEMO_BLACK_RING_OBJ) );
	
	// IuWFNg
	FLD_DEMO_3DObjDrawInit( &p_obj->draw, p_mdl );
	FLD_DEMO_3DObjDrawSetDraw( &p_obj->draw, FALSE );	// \OFF
	p_obj->status = FLD_DEMO_BLACKRINGOBJ_STANDBY;
}

//----------------------------------------------------------------------------
/**
 *		yCAEGA𒆐Soz
 *	@brief	OIuWFNgj
 *
 *	@param	p_obj	IuWFNg
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_BlackRingObj_Delete( FLD_DEMO_BLACK_RING_OBJ* p_obj )
{
	memset( p_obj, 0, sizeof(FLD_DEMO_BLACK_RING_OBJ) );
}

//----------------------------------------------------------------------------
/**
 *		yCAEGA𒆐Soz
 *	@brief	OIuWFNg@Jn
 *
 *	@param	p_obj		IuWFNg
 *	@param	s_scale		gkJnl
 *	@param	e_scale		gkIl
 *	@param	sync		VN
 *	@param	x			W
 *	@param  y			W
 *	@param	z			W
 *	@param	rota_x		]p
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_BlackRingObj_Start( FLD_DEMO_BLACK_RING_OBJ* p_obj, fx32 s_scale, fx32 e_scale, int sync, fx32 x, fx32 y, fx32 z, u16 rota_x, u16 rota_y, u16 rota_z )
{
	// dĂяo`FbN
	GF_ASSERT( p_obj->status == FLD_DEMO_BLACKRINGOBJ_STANDBY );

	// 쏉
	FLD_DEMO_MoveInit_FX( &p_obj->scale, s_scale, e_scale, sync );

	// `揉
	FLD_DEMO_3DObjDrawSetDraw( &p_obj->draw, TRUE );
	FLD_DEMO_3DObjDrawSetMatrix( &p_obj->draw, x, y, z );
	FLD_DEMO_3DObjDrawSetScale( &p_obj->draw, s_scale, FX32_ONE, s_scale );
	FLD_DEMO_3DObjDrawSetRota( &p_obj->draw, rota_x, FLD_3DROTA_WAY_X );
	FLD_DEMO_3DObjDrawSetRota( &p_obj->draw, rota_y, FLD_3DROTA_WAY_Y );
	FLD_DEMO_3DObjDrawSetRota( &p_obj->draw, rota_z, FLD_3DROTA_WAY_Z );

	p_obj->status = FLD_DEMO_BLACKRINGOBJ_DO;
	p_obj->count = 0;
}

//----------------------------------------------------------------------------
/**
 *		yCAEGA𒆐Soz
 *	@brief	OIuWFNgC
 *
 *	@param	p_obj	IuWFNg[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_BlackRingObj_Main( FLD_DEMO_BLACK_RING_OBJ* p_obj )
{
	BOOL result;

	if( p_obj->status == FLD_DEMO_BLACKRINGOBJ_STANDBY ){
		return ;
	}
	
	// gklύX
	p_obj->count ++;
	result = FLD_DEMO_MoveMain_FX( &p_obj->scale, p_obj->count );
	FLD_DEMO_3DObjDrawSetScale( &p_obj->draw, p_obj->scale.data, FX32_ONE, p_obj->scale.data );

	if( result == TRUE ){
		p_obj->status = FLD_DEMO_BLACKRINGOBJ_STANDBY;
	}
}

//----------------------------------------------------------------------------
/**
 *		yCAEGA𒆐Soz
 *	@brief	OIuWFNg`揈
 *
 *	@param	p_obj	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_BlackRingObj_Draw( FLD_DEMO_BLACK_RING_OBJ* p_obj )
{
	FLD_DEMO_3DObjDrawDraw( &p_obj->draw );
}

//----------------------------------------------------------------------------
/**
 *		yCAEGA𒆐Soz
 *	@brief	󂢂Ă郊OIuWFNg擾
 *
 *	@param	p_data	IuWFNg[N
 *
 *	@return	󂢂ĂIuWFNg[N
 */
//-----------------------------------------------------------------------------
static FLD_DEMO_BLACK_RING_OBJ* FLD_DEMO_BlackRingCleanObjGet( FLD_DEMO_BLACK_RING* p_data )
{
	int i;

	for( i=0; i<FLD_DEMO_BLACK_RING_NUM; i++ ){
		if( p_data->blackring[i].status == FLD_DEMO_BLACKRINGOBJ_STANDBY ){
			return &p_data->blackring[i];
		}
	}
	return NULL;
}





//-----------------------------------------------------------------------------
/**
 *
 *		y̗oz
 * 
 */
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#ifdef PM_DEBUG
//#define FLD_DEMO_ANT_DEBUG
#endif

#ifdef FLD_DEMO_ANT_DEBUG
int FLD_DEMO_ANTEGG_DEBUG_SEQ = 0;

int FLD_DEMO_ANTEGG_CUT00_ROTA_X =	( 62623 );
int FLD_DEMO_ANTEGG_CUT00_ROTA_Y = 	( 32949 );
int FLD_DEMO_ANTEGG_CUT00_ROTA_Z = 	( 32942 );
int FLD_DEMO_ANTEGG_CUT00_OFS_X	 = 	( 170920 );
int FLD_DEMO_ANTEGG_CUT00_OFS_Y	 = 	( -225940 );
int FLD_DEMO_ANTEGG_CUT00_OFS_Z	 =	( -747638 );
#else



#endif


//-------------------------------------
//	V[OO
//=====================================
#if ( PM_VERSION == VERSION_DIAMOND )

#define FLD_DEMO_ANTEGG_CUT00_ROTA_X	( 62623 )
#define FLD_DEMO_ANTEGG_CUT00_ROTA_Y	( 32949 )
#define FLD_DEMO_ANTEGG_CUT00_ROTA_Z	( 32942 )
#define FLD_DEMO_ANTEGG_CUT00_OFS_X		( 170920 )
#define FLD_DEMO_ANTEGG_CUT00_OFS_Y		( -225940 )
#define FLD_DEMO_ANTEGG_CUT00_OFS_Z		( -747638 )

#elif( PM_VERSION == VERSION_PEARL )

#define FLD_DEMO_ANTEGG_CUT00_ROTA_X	( 58983 )
#define FLD_DEMO_ANTEGG_CUT00_ROTA_Y	( 30219 )
#define FLD_DEMO_ANTEGG_CUT00_ROTA_Z	( 34216 )
#define FLD_DEMO_ANTEGG_CUT00_OFS_X		( -307200 )
#define FLD_DEMO_ANTEGG_CUT00_OFS_Y		( -87729 )
#define FLD_DEMO_ANTEGG_CUT00_OFS_Z		( -629017 )

#endif



#define FLD_DEMO_ANTEGG_CUT01_ROTA_X	( 58801 )
#define FLD_DEMO_ANTEGG_CUT01_ROTA_Y	( 49507 )
#define FLD_DEMO_ANTEGG_CUT01_ROTA_Z	( 32760 )
#define FLD_DEMO_ANTEGG_CUT01_OFS_X		( 1141327 )
#define FLD_DEMO_ANTEGG_CUT01_OFS_Y		( 323947 )
#define FLD_DEMO_ANTEGG_CUT01_OFS_Z		( -598296 )

#define FLD_DEMO_ANTEGG_CUT02_ROTA_X	( 59165 )
#define FLD_DEMO_ANTEGG_CUT02_ROTA_Y	( 21301 )
#define FLD_DEMO_ANTEGG_CUT02_ROTA_Z	( 31122 )
#define FLD_DEMO_ANTEGG_CUT02_OFS_X		( -811008 )
#define FLD_DEMO_ANTEGG_CUT02_OFS_Y		( 356351 )
#define FLD_DEMO_ANTEGG_CUT02_OFS_Z		( -2162696 )



#define FLD_DEMO_ANTEGG_ANM_NUM	(3)	// RAj[V

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	̗@[N
//=====================================
typedef struct _FLD_DEMO_ANTEGG {
	FLD_3DOBJ draw;		// `惏[N
	FLD_3DOBJ_MDL mdl;		// f
	FLD_3DOBJ_ANM anm[FLD_DEMO_ANTEGG_ANM_NUM];	// Aj

	NNSFndAllocator allocator;	// AP[^
} ;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static FLD_DEMO_ANTEGG* FLD_DEMO_AntEgg_Alloc( u32 heapID, u32 dataIdx );
static void FLD_DEMO_AntEgg_Free( FLD_DEMO_ANTEGG* p_data );
static void FLD_DEMO_AntEgg_Start( FLD_DEMO_ANTEGG* p_data, fx32 x, fx32 y, fx32 z, u16 rota_x, u16 rota_y, u16 rota_z );
static void FLD_DEMO_AntEgg_Main( FLD_DEMO_ANTEGG* p_data );
static void FLD_DEMO_AntEgg_Draw( FLD_DEMO_ANTEGG* p_data );



//----------------------------------------------------------------------------
/**
 *		y̗oz
 *	@brief	[Nm
 *
 *	@param	heapID	q[vID
 *	@param	dataIdx	f[^CfbNX@A[JCuf[^
 *
 *	@return	[N|C^
 */
//-----------------------------------------------------------------------------
static FLD_DEMO_ANTEGG* FLD_DEMO_AntEgg_Alloc( u32 heapID, u32 dataIdx )
{
	FLD_DEMO_ANTEGG* p_data;
	int i;
	p_data = sys_AllocMemory( heapID, sizeof(FLD_DEMO_ANTEGG) );
	memset( p_data, 0, sizeof(FLD_DEMO_ANTEGG) );

	// AP[^쐬
	sys_InitAllocator( &p_data->allocator, heapID, 32 );	

	// fǂݍ
	FLD_DEMO_3DObjMdlLoad( &p_data->mdl, ARC_FIELD_DEMO_CLI_GRA, dataIdx, heapID );
	for( i=0; i<FLD_DEMO_ANTEGG_ANM_NUM; i++ ){
		FLD_DEMO_3DObjAnmLoad( &p_data->anm[i], &p_data->mdl, ARC_FIELD_DEMO_CLI_GRA, NARC_demo_climax_aritama_nsbta + i, heapID, &p_data->allocator );
	}
	FLD_DEMO_3DObjDrawInit( &p_data->draw, &p_data->mdl );
	for( i=0; i<FLD_DEMO_ANTEGG_ANM_NUM; i++ ){
		FLD_DEMO_3DObjDrawAddAnm( &p_data->draw, &p_data->anm[i] );
	}
	FLD_DEMO_3DObjDrawSetDraw( &p_data->draw, FALSE );

	return p_data;
}

//----------------------------------------------------------------------------
/**
 *		y̗oz
 *	@brief	[Nj
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_AntEgg_Free( FLD_DEMO_ANTEGG* p_data )
{
	int i;

	FLD_DEMO_3DObjMdlDelete( &p_data->mdl );
	for( i=0; i<FLD_DEMO_ANTEGG_ANM_NUM; i++ ){
		FLD_DEMO_3DObjAnmDelete( &p_data->anm[i], &p_data->allocator );
	}
	sys_FreeMemoryEz( p_data );
}

//----------------------------------------------------------------------------
/**
 *		y̗oz
 *	@brief	X^[g
 *
 *	@param	p_data	[N
 *	@param	x		W
 *	@param	y		W
 *	@param	z		W
 *	@param	rota_x	]p
 *	@param	rota_y	]p
 *	@param	rota_z	]p
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_AntEgg_Start( FLD_DEMO_ANTEGG* p_data, fx32 x, fx32 y, fx32 z, u16 rota_x, u16 rota_y, u16 rota_z )
{
	FLD_DEMO_3DObjDrawSetMatrix( &p_data->draw, 
			x, 
			y, 
			z );

	FLD_DEMO_3DObjDrawSetRota( &p_data->draw, rota_x, FLD_3DROTA_WAY_X );
	FLD_DEMO_3DObjDrawSetRota( &p_data->draw, rota_z, FLD_3DROTA_WAY_Z );
	FLD_DEMO_3DObjDrawSetRota( &p_data->draw, rota_y, FLD_3DROTA_WAY_Y );
	

	FLD_DEMO_3DObjDrawSetDraw( &p_data->draw, TRUE );
}

//----------------------------------------------------------------------------
/**
 *		y̗oz
 *	@brief	상C
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_AntEgg_Main( FLD_DEMO_ANTEGG* p_data )
{
	int i;
	
	// Ajǉ\
	for( i=0; i<FLD_DEMO_ANTEGG_ANM_NUM; i++ ){
		FLD_DEMO_3DObjAnmLoop( &p_data->anm[i] );
	}
	
}

//----------------------------------------------------------------------------
/**
 *		y̗oz
 *	@brief	̗`
 *
 *	@param	p_data [N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FLD_DEMO_AntEgg_Draw( FLD_DEMO_ANTEGG* p_data )
{
	FLD_DEMO_3DObjDrawDraw( &p_data->draw );
}

//----------------------------------------------------------------------------
/**
 *		y̗oz
 *	@brief	̗@[N쐬
 *
 *	@param	heapID 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
FLD_DEMO_ANTEGG* FLD_DEMO_AntEgg_Cut_Alloc( u32 heapID )
{
	return FLD_DEMO_AntEgg_Alloc( heapID, NARC_demo_climax_aritama_nsbmd );
}

//----------------------------------------------------------------------------
/**
 *		y̗oz
 *	@brief	̗@[Nj
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_AntEgg_Cut_Free( FLD_DEMO_ANTEGG* p_data )
{
	FLD_DEMO_AntEgg_Free( p_data );
}

//----------------------------------------------------------------------------
/**
 *		y̗oz
 *	@brief	C
 *
 *	@param	p_data @[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_AntEgg_Cut_Main( FLD_DEMO_ANTEGG* p_data )
{
	VecFx32 matrix;

	FLD_DEMO_AntEgg_Main( p_data );

#ifdef FLD_DEMO_ANT_DEBUG
	if( sys.tp_trg ){
		FLD_DEMO_ANTEGG_DEBUG_SEQ = (FLD_DEMO_ANTEGG_DEBUG_SEQ + 1) % 3;
		if( FLD_DEMO_ANTEGG_DEBUG_SEQ == 0 ){
			OS_Printf( "]\n" );
		}else if( FLD_DEMO_ANTEGG_DEBUG_SEQ == 1 ){
			OS_Printf( "W\n" );
		}else if( FLD_DEMO_ANTEGG_DEBUG_SEQ == 2 ){
			OS_Printf( "Ring\n" );
		}
	}

	switch(FLD_DEMO_ANTEGG_DEBUG_SEQ){
	case 0:	
		if( sys.cont & PAD_BUTTON_R ){
			if( sys.cont & PAD_BUTTON_A ){
				FLD_DEMO_ANTEGG_CUT00_ROTA_Y += FX_GET_ROTA_NUM( 1 );
				OS_Printf( "ROTA_Y %d\n", FLD_DEMO_ANTEGG_CUT00_ROTA_Y );
			}else if( sys.cont & PAD_BUTTON_Y ){
				FLD_DEMO_ANTEGG_CUT00_ROTA_Y -= FX_GET_ROTA_NUM( 1 );
				OS_Printf( "ROTA_Y %d\n", FLD_DEMO_ANTEGG_CUT00_ROTA_Y );
			}
			FLD_DEMO_3DObjDrawSetRota( &p_data->draw, FLD_DEMO_ANTEGG_CUT00_ROTA_Y, FLD_3DROTA_WAY_Y );
		}

		if( sys.cont & PAD_BUTTON_L ){
			if( sys.cont & PAD_BUTTON_A ){
				FLD_DEMO_ANTEGG_CUT00_ROTA_Z += FX_GET_ROTA_NUM( 1 );
				OS_Printf( "ROTA_Z %d\n", FLD_DEMO_ANTEGG_CUT00_ROTA_Z );
			}else if( sys.cont & PAD_BUTTON_Y ){

				FLD_DEMO_ANTEGG_CUT00_ROTA_Z -= FX_GET_ROTA_NUM( 1 );
				OS_Printf( "ROTA_Z %d\n", FLD_DEMO_ANTEGG_CUT00_ROTA_Z );
			}
			// PWOx]
			FLD_DEMO_3DObjDrawSetRota( &p_data->draw, FLD_DEMO_ANTEGG_CUT00_ROTA_Z, FLD_3DROTA_WAY_Z );
		}

		if( sys.cont & PAD_BUTTON_START ){
			if( sys.cont & PAD_BUTTON_A ){
				FLD_DEMO_ANTEGG_CUT00_ROTA_X += FX_GET_ROTA_NUM( 1 );
				OS_Printf( "ROTA_X %d\n", FLD_DEMO_ANTEGG_CUT00_ROTA_X );
			}else if( sys.cont & PAD_BUTTON_Y ){

				FLD_DEMO_ANTEGG_CUT00_ROTA_X -= FX_GET_ROTA_NUM( 1 );
				OS_Printf( "ROTA_X %d\n", FLD_DEMO_ANTEGG_CUT00_ROTA_X );
			}
			FLD_DEMO_3DObjDrawSetRota( &p_data->draw, FLD_DEMO_ANTEGG_CUT00_ROTA_X, FLD_3DROTA_WAY_X );
		}
		break;

	case 1:
		FLD_DEMO_3DObjDrawGetMatrix( &p_data->draw, &matrix.x, &matrix.y, &matrix.z );
		if( sys.cont & PAD_BUTTON_R ){
			if( sys.cont & PAD_BUTTON_A ){
				matrix.x += FX32_CONST( 1 );
				FLD_DEMO_ANTEGG_CUT00_OFS_X += FX32_CONST( 1 );
				OS_Printf( "MATRIX_X %d\n", FLD_DEMO_ANTEGG_CUT00_OFS_X );
			}else if( sys.cont & PAD_BUTTON_Y ){

				matrix.x -= FX32_CONST( 1 );
				FLD_DEMO_ANTEGG_CUT00_OFS_X -= FX32_CONST( 1 );
				OS_Printf( "MATRIX_X %d\n", FLD_DEMO_ANTEGG_CUT00_OFS_X );
			}
			FLD_DEMO_3DObjDrawSetMatrix( &p_data->draw, matrix.x, matrix.y, matrix.z );
		}

		if( sys.cont & PAD_BUTTON_L ){
			if( sys.cont & PAD_BUTTON_A ){
				matrix.y += FX32_CONST( 1 );
				FLD_DEMO_ANTEGG_CUT00_OFS_Y += FX32_CONST( 1 );
				OS_Printf( "MATRIX_Y %d\n", FLD_DEMO_ANTEGG_CUT00_OFS_Y );
			}else if( sys.cont & PAD_BUTTON_Y ){

				matrix.y -= FX32_CONST( 1 );
				FLD_DEMO_ANTEGG_CUT00_OFS_Y -= FX32_CONST( 1 );
				OS_Printf( "MATRIX_Y %d\n", FLD_DEMO_ANTEGG_CUT00_OFS_Y );
			}
			FLD_DEMO_3DObjDrawSetMatrix( &p_data->draw, matrix.x, matrix.y, matrix.z );
		}

		if( sys.cont & PAD_BUTTON_START ){
			if( sys.cont & PAD_BUTTON_A ){
				matrix.z += FX32_CONST( 1 );
				FLD_DEMO_ANTEGG_CUT00_OFS_Z += FX32_CONST( 1 );
				OS_Printf( "MATRIX_Z %d\n", FLD_DEMO_ANTEGG_CUT00_OFS_Z );
			}else if( sys.cont & PAD_BUTTON_Y ){

				matrix.z -= FX32_CONST( 1 );
				FLD_DEMO_ANTEGG_CUT00_OFS_Z -= FX32_CONST( 1 );
				OS_Printf( "MATRIX_Z %d\n", FLD_DEMO_ANTEGG_CUT00_OFS_Z );
			}
			FLD_DEMO_3DObjDrawSetMatrix( &p_data->draw, matrix.x, matrix.y, matrix.z );
		}
		break;

	default:
		break;
	}
#endif
}

//----------------------------------------------------------------------------
/**
 *		y̗oz
 *	@brief	`揈
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_AntEgg_Cut_Draw( FLD_DEMO_ANTEGG* p_data )
{
	FLD_DEMO_AntEgg_Draw( p_data );
}


//----------------------------------------------------------------------------
/**
 *		y̗o@JbgOOz
 *	@brief	fJn
 *
 *	@param	p_data	[N
 *	@param	x	Jړ_W
 *	@param	y	Jړ_W
 *	@param	z	Jړ_W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_AntEgg_Cut00_Start( FLD_DEMO_ANTEGG* p_data, fx32 x, fx32 y, fx32 z )
{
	FLD_DEMO_AntEgg_Start( p_data,
			x + FLD_DEMO_ANTEGG_CUT00_OFS_X,
			y + FLD_DEMO_ANTEGG_CUT00_OFS_Y,
			z + FLD_DEMO_ANTEGG_CUT00_OFS_Z,
			FLD_DEMO_ANTEGG_CUT00_ROTA_X,
			FLD_DEMO_ANTEGG_CUT00_ROTA_Y,
			FLD_DEMO_ANTEGG_CUT00_ROTA_Z );
}

//----------------------------------------------------------------------------
/**
 *		y̗o@JbgOPz
 *	@brief	fJn
 *
 *	@param	p_data	[N
 *	@param	x	Jړ_W
 *	@param	y	Jړ_W
 *	@param	z	Jړ_W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_AntEgg_Cut01_Start( FLD_DEMO_ANTEGG* p_data, fx32 x, fx32 y, fx32 z )
{
	FLD_DEMO_AntEgg_Start( p_data,
			x + FLD_DEMO_ANTEGG_CUT01_OFS_X,
			y + FLD_DEMO_ANTEGG_CUT01_OFS_Y,
			z + FLD_DEMO_ANTEGG_CUT01_OFS_Z,
			FLD_DEMO_ANTEGG_CUT01_ROTA_X,
			FLD_DEMO_ANTEGG_CUT01_ROTA_Y,
			FLD_DEMO_ANTEGG_CUT01_ROTA_Z );
}

//----------------------------------------------------------------------------
/**
 *		y̗o@JbgOQz
 *	@brief	fJn
 *
 *	@param	p_data	[N
 *	@param	x	Jړ_W
 *	@param	y	Jړ_W
 *	@param	z	Jړ_W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_AntEgg_Cut02_Start( FLD_DEMO_ANTEGG* p_data, fx32 x, fx32 y, fx32 z )
{
	FLD_DEMO_AntEgg_Start( p_data,
			x + FLD_DEMO_ANTEGG_CUT02_OFS_X,
			y + FLD_DEMO_ANTEGG_CUT02_OFS_Y,
			z + FLD_DEMO_ANTEGG_CUT02_OFS_Z,
			FLD_DEMO_ANTEGG_CUT02_ROTA_X,
			FLD_DEMO_ANTEGG_CUT02_ROTA_Y,
			FLD_DEMO_ANTEGG_CUT02_ROTA_Z );
}



//-----------------------------------------------------------------------------
/**
 *
 *		y̗̎̍O	ReBz
 * 
 */
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *		萔`
 */
//-----------------------------------------------------------------------------

#ifdef FLD_DEMO_ANT_DEBUG
int FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_X =	(0xfffc2000);
int FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_Y =	(0xfffb1000);
int FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_Z =	(0xfff30000);
#else


#endif



// Jړ_̋
#if ( PM_VERSION == VERSION_DIAMOND )

#define FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_X	(0x11000)
#define FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_Y	(0xfff91000)
#define FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_Z	(0xfff35000)

#elif( PM_VERSION == VERSION_PEARL )

#define FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_X	(0xfffc2000)
#define FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_Y	(0xfffb1000)
#define FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_Z	(0xfff30000)

#endif

#define FLD_DEMO_BLACKRING_ANTEGGCUT01_OBJ_OFS_X	(0x252000)
#define FLD_DEMO_BLACKRING_ANTEGGCUT01_OBJ_OFS_Y	(0x43000)
#define FLD_DEMO_BLACKRING_ANTEGGCUT01_OBJ_OFS_Z	(0xfffc8000)

#define FLD_DEMO_BLACKRING_ANTEGGCUT02_OBJ_OFS_X	(0xffeb4000)
#define FLD_DEMO_BLACKRING_ANTEGGCUT02_OBJ_OFS_Y	(0xffff3000)
#define FLD_DEMO_BLACKRING_ANTEGGCUT02_OBJ_OFS_Z	(0xffe3c000)



//----------------------------------------------------------------------------
/**
 *		y̗̎̍O	ReBz
 *	@brief	̗̎̍O
 *
 *	@param	heapID	q[vID
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
FLD_DEMO_BLACK_RING* FLD_DEMO_BlackRing_AntEggCat_Alloc( u32 heapID )
{
	return FLD_DEMO_BlackRing_Alloc_Core( heapID, NARC_demo_climax_ring_t_nsbmd );
}

//----------------------------------------------------------------------------
/**
 *		y̗̎̍O	ReBz
 *	@brief	[Nj
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_BlackRing_AntEggCat_Free( FLD_DEMO_BLACK_RING* p_data )
{
	FLD_DEMO_BlackRing_Free_Core( p_data );

}

//----------------------------------------------------------------------------
/**
 *		y̗̎̍O	ReBz
 *	@brief	̪ăC
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_BlackRing_AntEggCat_Main( FLD_DEMO_BLACK_RING* p_data )
{
	FLD_DEMO_BlackRing_Main_Core( p_data );

#ifdef FLD_DEMO_ANT_DEBUG
	if( FLD_DEMO_ANTEGG_DEBUG_SEQ == 2 ){
		if( sys.cont & PAD_BUTTON_R ){
			if( sys.cont & PAD_BUTTON_A ){
				p_data->y += FX32_ONE;
				FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_Y += FX32_ONE;
				OS_Printf( "MAT_Y %x\n", FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_Y );
			}else if( sys.cont & PAD_BUTTON_Y ){
				p_data->y -= FX32_ONE;
				FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_Y -= FX32_ONE;
				OS_Printf( "MAT_Y %x\n", FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_Y );
			}
		}

		if( sys.cont & PAD_BUTTON_L ){
			if( sys.cont & PAD_BUTTON_A ){
				p_data->z += FX32_ONE;
				FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_Z += FX32_ONE;
				OS_Printf( "MAT_Z %x\n", FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_Z );
			}else if( sys.cont & PAD_BUTTON_Y ){

				p_data->z -= FX32_ONE;
				FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_Z -= FX32_ONE;
				OS_Printf( "MAT_Z %x\n", FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_Z );
			}
		}

		if( sys.cont & PAD_BUTTON_START ){
			if( sys.cont & PAD_BUTTON_A ){
				p_data->x += FX32_ONE;
				FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_X += FX32_ONE;
				OS_Printf( "MAT_X %x\n", FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_X );
			}else if( sys.cont & PAD_BUTTON_Y ){

				p_data->x -= FX32_ONE;
				FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_X -= FX32_ONE;
				OS_Printf( "MAT_X %x\n", FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_X );
			}
		}
	}
#endif
}

//----------------------------------------------------------------------------
/**
 *		y̗̎̍O	ReBz
 *	@brief	̪ĕ`
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_BlackRing_AntEggCat_Draw( FLD_DEMO_BLACK_RING* p_data )
{
	FLD_DEMO_BlackRing_Draw_Core( p_data );
}

//----------------------------------------------------------------------------
/**
 *		y̗̎̍O	ReBz
 *	@brief	̪ĊJn	Jbg00
 *
 *	@param	p_data	[N
 *	@param	x	Jړ_@W
 *	@param	y	Jړ_@W	
 *	@param	z	Jړ_@W 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_BlackRing_AntEggCat00_Start( FLD_DEMO_BLACK_RING* p_data, fx32 x, fx32 y, fx32 z )
{
	FLD_DEMO_BlackRing_Start_Core( p_data, 
			x + FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_X,
			y + FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_Y,
			z + FLD_DEMO_BLACKRING_ANTEGGCUT00_OBJ_OFS_Z,
			FLD_DEMO_BLACK_RING_START_TIMING,
			FLD_DEMO_ANTEGG_CUT00_ROTA_X,
			FLD_DEMO_ANTEGG_CUT00_ROTA_Y,
			FLD_DEMO_ANTEGG_CUT00_ROTA_Z
			);
}

//----------------------------------------------------------------------------
/**
 *		y̗̎̍O	ReBz
 *	@brief	̪ĊJn	Jbg01
 *
 *	@param	p_data	[N
 *	@param	x	Jړ_@W
 *	@param	y	Jړ_@W	
 *	@param	z	Jړ_@W 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_BlackRing_AntEggCat01_Start( FLD_DEMO_BLACK_RING* p_data, fx32 x, fx32 y, fx32 z )
{
	FLD_DEMO_BlackRing_Start_Core( p_data, 
			x + FLD_DEMO_BLACKRING_ANTEGGCUT01_OBJ_OFS_X,
			y + FLD_DEMO_BLACKRING_ANTEGGCUT01_OBJ_OFS_Y,
			z + FLD_DEMO_BLACKRING_ANTEGGCUT01_OBJ_OFS_Z,
			FLD_DEMO_BLACK_RING_START_TIMING,
			FLD_DEMO_ANTEGG_CUT01_ROTA_X,
			FLD_DEMO_ANTEGG_CUT01_ROTA_Y,
			FLD_DEMO_ANTEGG_CUT01_ROTA_Z
			);
}

//----------------------------------------------------------------------------
/**
 *		y̗̎̍O	ReBz
 *	@brief	̪ĊJn	Jbg02
 *
 *	@param	p_data	[N
 *	@param	x	Jړ_@W
 *	@param	y	Jړ_@W	
 *	@param	z	Jړ_@W 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_BlackRing_AntEggCat02_Start( FLD_DEMO_BLACK_RING* p_data, fx32 x, fx32 y, fx32 z )
{
	FLD_DEMO_BlackRing_Start_Core( p_data, 
			x + FLD_DEMO_BLACKRING_ANTEGGCUT02_OBJ_OFS_X,
			y + FLD_DEMO_BLACKRING_ANTEGGCUT02_OBJ_OFS_Y,
			z + FLD_DEMO_BLACKRING_ANTEGGCUT02_OBJ_OFS_Z,
			FLD_DEMO_BLACK_RING_START_TIMING,
			FLD_DEMO_ANTEGG_CUT02_ROTA_X,
			FLD_DEMO_ANTEGG_CUT02_ROTA_Y,
			FLD_DEMO_ANTEGG_CUT02_ROTA_Z
			);
}


//-----------------------------------------------------------------------------
/**
 * 
 *		tB[hŜÂ
 * 
 */
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *		萔`
 */
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *		\̒`
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	x̒ႢLIGHTtB[hŜɂ
//=====================================
typedef struct _FLD_DEMO_DARKLIGHT{
	FIELDSYS_WORK* p_fsys;	// tB[hVXe
	const LIGHT_CONT_DATA* p_lightdata;		// LIGHTf[^
	u32 light_num;			// LIGHTf[^
	u32 light_count;		// LIGHT
	u32 light_set;			// ݒ蒆LIGHTf[^
	u32 status;				// 
};

//-----------------------------------------------------------------------------
/**
 *		vg^Cv錾
 */
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *		O[oϐ
 */
//-----------------------------------------------------------------------------
#define FLD_DEMO_DARKLIGHT_LIGHTDATANUM	( 3 )
static const LIGHT_CONT_DATA FLD_DEMO_DARKLIGHT_LIGHTDATA[ FLD_DEMO_DARKLIGHT_LIGHTDATANUM ] = {
	{
		8,				// LIGHTIl
		0xD,			// LIGHTftO
		{				// LIGHTJ[
			GX_RGB(13, 11, 11),
			GX_RGB(0, 0, 0),
			GX_RGB(10, 3, 0),
			GX_RGB(31, 31, 31),
		},	
		{				// LIGHTxNg
			{-2022,-3561,93},
			{0,0,4096},	
			{0,0,4096},
			{0,0,4096},
		},
		GX_RGB(13, 13, 14),// fBt[Y
		GX_RGB(13, 12, 12),// ArGg
		GX_RGB(13, 11, 14),// XyL[
		GX_RGB(11, 9, 10) // 
	},
	{
		16,				// LIGHTIl
		0xD,			// LIGHTftO
		{				// LIGHTJ[
			GX_RGB(11, 9, 9),
			GX_RGB(0, 0, 0),
			GX_RGB(10, 3, 0),
			GX_RGB(31, 31, 31),
		},	
		{				// LIGHTxNg
			{-2022,-3561,93},
			{0,0,4096},	
			{0,0,4096},
			{0,0,4096},
		},
		GX_RGB(11, 11, 12),// fBt[Y
		GX_RGB(13, 12, 12),// ArGg
		GX_RGB(13, 11, 14),// XyL[
		GX_RGB(11, 9, 10) // 
	},
	{
		24,				// LIGHTIl
		0xD,			// LIGHTftO
		{				// LIGHTJ[
			GX_RGB(9, 8, 8),
			GX_RGB(0, 0, 0),
			GX_RGB(10, 3, 0),
			GX_RGB(31, 31, 31),
		},	
		{				// LIGHTxNg
			{-2022,-3561,93},
			{0,0,4096},	
			{0,0,4096},
			{0,0,4096},
		},
		GX_RGB(10, 9, 9),// fBt[Y
		GX_RGB(11, 10, 10),// ArGg
		GX_RGB(13, 11, 14),// XyL[
		GX_RGB(11, 9, 10) // 
	},
};

//----------------------------------------------------------------------------
/**
 *		ytB[hŜÂz
 *	@brief	[Nm
 *
 *	@param	heapID	q[vID
 *	@param	p_fsys	tB[hVXe 
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
FLD_DEMO_DARKLIGHT* FLD_DEMO_DarkLight_Alloc( u32 heapID, FIELDSYS_WORK* p_fsys )
{
	FLD_DEMO_DARKLIGHT* p_data;

	p_data = sys_AllocMemory( heapID, sizeof(FLD_DEMO_DARKLIGHT) );
	memset( p_data, 0, sizeof(FLD_DEMO_DARKLIGHT) );
	p_data->p_fsys = p_fsys;
	p_data->status = FLD_DEMO_DARKLIGHT_INIT;
	
	return p_data;
}

//----------------------------------------------------------------------------
/**
 *		ytB[hŜÂz
 *	@brief	[Nj
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_DarkLight_Free( FLD_DEMO_DARKLIGHT* p_data )
{
	sys_FreeMemoryEz( p_data );
}

//----------------------------------------------------------------------------
/**
 *		ytB[hŜÂz
 *	@brief	fJn
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_DarkLight_Start( FLD_DEMO_DARKLIGHT* p_data )
{
	p_data->p_lightdata = FLD_DEMO_DARKLIGHT_LIGHTDATA;
	p_data->light_num = FLD_DEMO_DARKLIGHT_LIGHTDATANUM;
	p_data->light_count = 0;
	p_data->light_set = 0;
	p_data->status = FLD_DEMO_DARKLIGHT_FADEOUT;

	// LIGHTf~
	SetLightContReflect( p_data->p_fsys->light_cont_data, FALSE );
}

//----------------------------------------------------------------------------
/**
 *		ytB[hŜÂz
 *	@brief	C֐
 *
 *	@param	p_data [N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_DarkLight_Main( FLD_DEMO_DARKLIGHT* p_data )
{
	switch( p_data->status ){
	case FLD_DEMO_DARKLIGHT_FADEOUT:	// ÂȂĂ܂B
		p_data->light_count ++;
		if( p_data->p_lightdata[ p_data->light_set ].lightEnd <= p_data->light_count ){
			if( (p_data->light_set + 1) >= p_data->light_num ){
				p_data->status++;
			}else{
				p_data->light_set ++;
				DataSetLightCont( &p_data->p_lightdata[ p_data->light_set ], p_data->p_fsys->glst_data );
			}
		}
		break;
		
	case FLD_DEMO_DARKLIGHT_ENDWAIT:	// INGXg҂B
		break;
		
	case FLD_DEMO_DARKLIGHT_FADEIN:	// 邭ȂĂ܂B
		p_data->light_count --;
		
		if( p_data->light_set > 0 ){
			if( p_data->p_lightdata[ p_data->light_set - 1 ].lightEnd > p_data->light_count ){
				p_data->light_set --;
				DataSetLightCont( &p_data->p_lightdata[ p_data->light_set ], p_data->p_fsys->glst_data );
			}
		}else{
			if( 0 >= p_data->light_count ){

				// LIGHTA
				SetLightContReflect( p_data->p_fsys->light_cont_data, TRUE );
				p_data->status++;
			}
		}
		break;
		
	case FLD_DEMO_DARKLIGHT_END:		// SHI
		break;
		
	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *		ytB[hŜÂz
 *	@brief	ݏԎ擾
 *
 *	@param	cp_data	[N
 *	
 *	@retval	FLD_DEMO_DARKLIGHT_INIT,	// 
 *	@retval	FLD_DEMO_DARKLIGHT_FADEOUT,	// ÂȂĂ܂B
 * 	@retval	FLD_DEMO_DARKLIGHT_ENDWAIT,	// INGXg҂B
 * 	@retval	FLD_DEMO_DARKLIGHT_FADEIN,	// 邭ȂĂ܂B
 *	@retval	FLD_DEMO_DARKLIGHT_END,		// SHI
 */
//-----------------------------------------------------------------------------
u32 FLD_DEMO_DarkLight_GetState( const FLD_DEMO_DARKLIGHT* cp_data )
{
	return cp_data->status;
}

//----------------------------------------------------------------------------
/**
 *	@brief	INGXg
 *
 *	@param	p_data	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_DarkLight_EndReq( FLD_DEMO_DARKLIGHT* p_data )
{
	GF_ASSERT_MSG( p_data->status == FLD_DEMO_DARKLIGHT_ENDWAIT, "status %d", p_data->status );
	p_data->status = FLD_DEMO_DARKLIGHT_FADEIN;
}



//-----------------------------------------------------------------------------
/**
 *
 *
 *		Ã^}SoJnf
 *
 */
//-----------------------------------------------------------------------------
enum{
	FLD_DEMO_ARITAMA_ANM_CA,
	FLD_DEMO_ARITAMA_ANM_MA,
	FLD_DEMO_ARITAMA_ANM_TA,
	FLD_DEMO_ARITAMA_ANM_VA,
	FLD_DEMO_ARITAMA_ANM_NUM
};
//-------------------------------------
//	A̗oJnf
//=====================================
typedef struct _FLD_DEMO_ARITAMA_START{
	FLD_3DOBJ draw;		// `惏[N
	FLD_3DOBJ_MDL mdl;		// f
	FLD_3DOBJ_ANM anm[FLD_DEMO_ARITAMA_ANM_NUM];	// Aj
	FIELDSYS_WORK* p_fsys;	// tB[hVXe
	NNSFndAllocator allocator;	// AP[^
};



//----------------------------------------------------------------------------
/**
 *	@brief	A̗Jn@m
 *
 *	@param	heapID		q[vID
 *	@param	p_fsys		tB[hVXe
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
FLD_DEMO_ARITAMA_START* FLD_DEMO_AriTamaStart_Alloc( u32 heapID, FIELDSYS_WORK* p_fsys )
{
	FLD_DEMO_ARITAMA_START * p_work;
	int i;
	p_work = sys_AllocMemory( heapID, sizeof(FLD_DEMO_ARITAMA_START) );
	memset( p_work, 0, sizeof(FLD_DEMO_ARITAMA_START) );

	// fieldsys
	p_work->p_fsys = p_fsys;

	// AP[^쐬
	sys_InitAllocator( &p_work->allocator, heapID, 32 );	

	// fǂݍ
	FLD_DEMO_3DObjMdlLoad( &p_work->mdl, ARC_FIELD_DEMO_CLI_GRA, NARC_demo_climax_ari_start_nsbmd, heapID );
	for( i=0; i<FLD_DEMO_ARITAMA_ANM_NUM; i++ ){
		FLD_DEMO_3DObjAnmLoad( &p_work->anm[i], &p_work->mdl, ARC_FIELD_DEMO_CLI_GRA, NARC_demo_climax_ari_start_nsbca + i, heapID, &p_work->allocator );
	}
	FLD_DEMO_3DObjDrawInit( &p_work->draw, &p_work->mdl );
	for( i=0; i<FLD_DEMO_ARITAMA_ANM_NUM; i++ ){
		FLD_DEMO_3DObjDrawAddAnm( &p_work->draw, &p_work->anm[i] );
	}
	FLD_DEMO_3DObjDrawSetDraw( &p_work->draw, FALSE );

	return p_work;
}

//----------------------------------------------------------------------------
/**
 *	@brief	A̗Jn@[Nj
 *
 *	@param	p_data	[N
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_AriTamaStart_Free( FLD_DEMO_ARITAMA_START* p_data )
{
	int i;

	FLD_DEMO_3DObjMdlDelete( &p_data->mdl );
	for( i=0; i<FLD_DEMO_ARITAMA_ANM_NUM; i++ ){
		FLD_DEMO_3DObjAnmDelete( &p_data->anm[i], &p_data->allocator );
	}
	sys_FreeMemoryEz( p_data );
}

//----------------------------------------------------------------------------
/**
 *	@brief	A̗o	Jn
 *
 *	@param	p_data			[N
 *	@param	legendpoke_id	`|POBJID
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_AriTamaStart_Start( FLD_DEMO_ARITAMA_START* p_data, u32 legendpoke_id )
{
	VecFx32 mat;
	FIELD_OBJ_PTR fldobj;
	fldobj = FieldOBJSys_OBJIDSearch( p_data->p_fsys->fldobjsys, legendpoke_id );
	

	// |P̍W擾
	FieldOBJ_VecPosGet( fldobj, &mat );
	
	FLD_DEMO_3DObjDrawSetMatrix( &p_data->draw, 
			mat.x,
			mat.y,
			mat.z );

	FLD_DEMO_3DObjDrawSetDraw( &p_data->draw, TRUE );
	// vV[
	Snd_SePlay( FLD_DEMO_LEGENDEFF_SND_06 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	A̗oAj@C
 *
 *	@param	p_data	[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL FLD_DEMO_AriTamaStart_Main( FLD_DEMO_ARITAMA_START* p_data )
{
	int i;
	BOOL retval;
	
	// Ajǉ\
	for( i=0; i<FLD_DEMO_ARITAMA_ANM_NUM; i++ ){
		retval = FLD_DEMO_3DObjAnmNoLoop( &p_data->anm[i] );
	}
	return retval;
}

//----------------------------------------------------------------------------
/**
 *	@brief	`揈
 *
 *	@param	p_data	[N
 */
//-----------------------------------------------------------------------------
void FLD_DEMO_AriTamaStart_Draw( FLD_DEMO_ARITAMA_START* p_data )
{
	FLD_DEMO_3DObjDrawDraw( &p_data->draw );
}



#ifdef FIELD_DEMO_DEBUG
static void FieldDemoDebugStart( void )
{
	pFieldDemoDebugTcb = TCB_Add( FieldDemoDebugTcb, NULL, 0 );
}

static void FieldDemoDebugEnd( void )
{
	TCB_Delete( pFieldDemoDebugTcb );
}

static void FieldDemoDebugTcb( TCB_PTR tcb, void* p_work )
{
	// ~
	if( sys.tp_trg ){
		FIELD_DEMO_DEBUG_STOP ^= 1;

		OS_Printf( "~:1 Đ:0 %d\n", FIELD_DEMO_DEBUG_STOP );
	}

	// lύX
	if( sys.cont & PAD_BUTTON_L ){
		if( sys.repeat & PAD_BUTTON_A ){
//			OS_Printf( "%d\n", );
		}
		if( sys.repeat & PAD_BUTTON_Y ){
//			OS_Printf( "%d\n", );
		}
	}
	if( sys.cont & PAD_BUTTON_R ){
		if( sys.repeat & PAD_BUTTON_A ){
//			OS_Printf( "%d\n", );
		}
		if( sys.repeat & PAD_BUTTON_Y ){
//			OS_Printf( "%d\n", );
		}
	}
	if( sys.cont & PAD_BUTTON_START ){
		if( sys.repeat & PAD_BUTTON_A ){
//			OS_Printf( "%d\n", );
		}
		if( sys.repeat & PAD_BUTTON_Y ){
//			OS_Printf( "%d\n", );
		}
	}
}
#endif // FIELD_DEMO_DEBUG
