//==============================================================================
/**
 * @file	field_effect.h
 * @brief	tB[hGtFNg
 * @author	kagaya
 * @data	05.07.13
 */
//==============================================================================
#ifndef FIELD_EFFECT_H_FILE
#define FIELD_EFFECT_H_FILE

//==============================================================================
/*
	tB[hGtFNg֘A@ȈՐ
	
	\[Xt@C
	field_effect.h tB[hGtFNgwb_[
	field_effect.c tB[hGtFNg
	field_effect_data.c@GtFNgo^\[Xt@C
	
	ȉAfield_effect.hinlcudeς
	field_effect_code.h tB[hGtFNgpV{`
	field_effect_subproc.h@GtFNgQƃwb_[@ꗗ
	
	tB[hGtFNgp@A[JCuf[^CfbNXIDt@C
	src\data\mmodel\fldeff.naix
	field_effect.hinlcudeς
	
	VKGtFNg̒ǉ@
	PFFE_SUBPROC_INIT^̃GtFNg֐AFE_SUBPROC_DELETE^̃GtFNg폜֐쐬
	QFVKGtFNg֐Qƃwb_[field_effect_subproc.hinlcude
	RFfield_effect_code.h@ɐVKGtFNgIDǉ
	SFfield_effect_data.c@ɐVKGtFNgIDƂɊ֘AA폜֐`
	TFFE_EffectRegist()ŌĂяoAmF
	UFfield_effect_subproc.h field_effect_code.h field_effect_data.ccommit
	
	tB[hGtFNgpA[JCuf[^̍XV@
	PFsrc\data\mmodel\fldeff_listփA[JCuΏۃt@C`
	QFLfBNgmakesBA[JCu쐬
	RFmF
	SFA[JCuΏۃt@Cfldeff_listcommit
	mmodelfBNgɂmake鎖ŐRo[gf[^t@Ccommit͋֎~
	A[JCut@C(*.narc,*.naix)commit֎~BA[JCut@C͌X̊ōs
	
	GtFNgǉA폜֘A֐
	FE_EffectRegist()
	FE_EffectRegistMore()
	FE_EffectDelete()
	
	GtFNggp[N擾֐
	FE_EffectWorkGet()
	
	tB[hGtFNgpq[v̈֘A֐
	FE_AllocMemory()
	FE_AllocClearMemory()
	FE_FreeMemory()
	
	tB[hGtFNgpA[JCuf[^֘A֐
	FE_ArcDataLoad()
	FE_ArcDataLoadAlloc()
	FE_ArcDataSizeGet()
*/
//==============================================================================

#include "localres.h"					//LRES
#include "eoa.h"						//EOA

#include "field_common.h"				//FIELD COMMON
#include "fieldobj.h"					//FIELD_OBJ

#include "field_effect_code.h"			//GtFNgV{`
#include "..\data\mmodel\fldeff.naix"	//ARC_FLDEFF

#include "field_3dobj.h"

//==============================================================================
//	define
//==============================================================================
//--------------------------------------------------------------
///	r{[h@풓@]
//--------------------------------------------------------------
enum
{
	FE_BLACT_TEX_VRAM = 0,									///<eNX`VRAM풓
	FE_BLACT_TEX_TRANS,										///<eNX`]
};

//==============================================================================
//	typedef struct 
//==============================================================================
//--------------------------------------------------------------
///	FE_SYS\̖`@tB[hGtFNgZ߂
//--------------------------------------------------------------
typedef struct _TAG_FE_SYS FE_SYS;

//--------------------------------------------------------------
///	GtFNg֐^`B
/// FFE_SYS * ߂lF֐Ŏgp郏[N *
//--------------------------------------------------------------
typedef void * (*FE_SUBPROC_INIT)( FE_SYS * );

//--------------------------------------------------------------
///	GtFNg폜֐^`B
/// Fvoid * = FE_SUBPROC_INIT̖߂l
//--------------------------------------------------------------
typedef void (*FE_SUBPROC_DELETE)( void * );

//--------------------------------------------------------------
///	FE_SUBPROC_DATA\ GtFNg֐IDo^f[^
//--------------------------------------------------------------
typedef struct
{
	u32 id;								///<proc_init,proc_delĂяoׂ̎ID
	FE_SUBPROC_INIT proc_init;			///<idw肵ۂɌĂ΂GtFNg֐
	FE_SUBPROC_DELETE proc_del;			///<idw肵ۂɌĂ΂GtFNg폜֐
}FE_SUBPROC_DATA;

#define FE_SUBPROC_DATA_SIZE (sizeof(FE_SUBPROC_DATA))

//==============================================================================
//	OQ
//==============================================================================
extern FE_SYS * FE_Init( FIELDSYS_WORK *fsys, u32 reg_max, u32 heap_id, u32 worksize );
extern void FE_ParamInit_EOA( FE_SYS *fes, u32 eoa_max );
extern void FE_ParamInit_BlAct( FE_SYS *fes, u32 gp_heap_id,  u32 act_max,
		u32 mdl_max, u32 anm_max, u32 tex_max,
		u32 mdl_size, u32 anm_size, u32 tex_size );
extern void FE_EffectRegist( FE_SYS *fes, u32 id );
extern void FE_EffectRegistMore( FE_SYS *fes, const u32 *id_tbl );
extern int FE_EffectRegistCheck( FE_SYS *fes, u32 id );
extern void FE_EffectDelete( FE_SYS *fes, u32 id );
extern void FE_Draw( FE_SYS *fes );
extern void FE_Delete( FE_SYS *fes );

extern void * FE_AllocMemory( const FE_SYS *fes, u32 size, ALLOCTYPE type );
extern void * FE_AllocClearMemory( const FE_SYS *fes, u32 size, ALLOCTYPE type, u32 clear );
extern void FE_FreeMemory( void *alloc );
extern void * FE_EffectWorkGet( FE_SYS *fes, u32 id );
extern FIELDSYS_WORK * FE_FieldSysWorkGet( const FE_SYS *fes );
extern FE_SYS * FE_FieldOBJ_FE_SYS_Get( CONST_FIELD_OBJ_PTR fldobj );

extern u32 FE_ArcDataSizeGet( FE_SYS *fes, u32 datid );
extern void FE_ArcDataLoad( FE_SYS *fes, u32 datid, void *buf );
extern void * FE_ArcDataLoadAlloc( FE_SYS *fes, u32 datid, ALLOCTYPE type );

extern EOA_PTR FE_EoaAddNpp( const FE_SYS *fes, const EOA_H_NPP *head,
		const VecFx32 *mtx, int prm, const void *ptr, int pri );
extern void FE_EoaDelete( EOA_PTR eoa );

extern BLACT_WORK_PTR FE_BlActAdd( FE_SYS *fes, 
		const BLACT_HEADER *head, const VecFx32 *vec );
extern BLACT_WORK_PTR FE_BlActAddID( FE_SYS *fes, u32 id, const VecFx32 *vec );
extern BLACT_HEADER * FE_BlActHeaderManageAdd( FE_SYS *fes, u32 id,
	void *mdl, TEXANM_DATATBL *anm, void *tex, TEXRES_OBJ_PTR tex_key,
	const BLACT_ANIME_TBL *anm_tbl );
extern BLACT_HEADER * FE_BlActHeaderManageAddResmID(
		FE_SYS *fes, u32 id, u32 mdl_id, u32 anm_id, u32 tex_id, int tex_flag,
		const BLACT_ANIME_TBL *anm_tbl );
extern BLACT_HEADER * FE_BlActHeaderManageGet( FE_SYS *fes, u32 id );
extern void FE_BlActHeaderManageFree( FE_SYS *fes, u32 id );

extern void FE_BlActResAdd_Mdl( FE_SYS *fes, u32 id, const void *data, u32 size );
extern void FE_BlActResAdd_MdlArc( FE_SYS *fes, u32 id, u32 datid );
extern void * FE_BlActResGet_Mdl( FE_SYS *fes, u32 id );
extern void FE_BlActResDelete_Mdl( FE_SYS *fes, u32 id );
extern void FE_BlActResAdd_Anm( FE_SYS *fes, u32 id, const void *data, u32 size );
extern void FE_BlActResAdd_AnmArc( FE_SYS *fes, u32 id, u32 datid );
extern void * FE_BlActResGet_Anm( FE_SYS *fes, u32 id );
extern void FE_BlActResDelete_Anm( FE_SYS *fes, u32 id );
extern void FE_BlActResAdd_Tex( FE_SYS *fes, u32 id, void *data, u32 texcut );
extern void FE_BlActResAdd_TexArc( FE_SYS *fes, u32 id, u32 datid, u32 texcut );
extern void * FE_BlActResGet_Tex( FE_SYS *fes, u32 id );
extern void FE_BlActResDelete_Tex( FE_SYS *fes, u32 id );

extern void FE_simple3DModelInitOnly( FE_SYS *fes,
	NNSG3dRenderObj *object_p, NNSG3dResMdl **model, NNSG3dResFileHeader **resFile );
extern void FE_simple3DModelInit( FE_SYS *fes, u32 dataid, ALLOCTYPE type,
	NNSG3dRenderObj *object_p, NNSG3dResMdl **model, NNSG3dResFileHeader **resFile );
extern void FE_3DObjMdlLoad( FE_SYS *fes, FLD_3DOBJ_MDL *p_mdl, u32 dataid, ALLOCTYPE type );
extern void FE_3DObjAnmLoad(
		FE_SYS *fes,
		FLD_3DOBJ_ANM *p_anm,
		const FLD_3DOBJ_MDL *cp_mdl,
		NNSFndAllocator* pallocator,
		u32 dataid, ALLOCTYPE type );
extern void FE_InitAllocator( FE_SYS *fes, NNSFndAllocator *pAllocator );

//==============================================================================
//	field_effect_data.c
//==============================================================================
extern const FE_SUBPROC_DATA DATA_FE_SubProcDataTbl[FE_PROC_MAX+1];
extern const u32 DATA_FE_GroundProcRegistTbl[FE_PROC_MAX+1];
extern const u32 DATA_FE_UnderProcRegistTbl[FE_PROC_MAX+1];

//==============================================================================
//	field_effect.h𗘗p֐include
//==============================================================================
#include "field_effect_subproc.h"

#endif //FIELD_EFFECT_H_FILE
