//============================================================================================
/**
 * @file	field_encount.c
 * @brief	tB[hGJEg`FbNN
 * @date	2005.07.28
 * @author	tamada		plĂ
 *
 * 2005.12.18	GJEg`FbN폜Aencount_set.cɈړ
 */
//============================================================================================

#include "common.h"
#include "fieldsys.h"
#include "field_event.h"

#include "field_encount.h"
#include "eventcmd.h"
#include "encount_effect.h"
#include "encount_set.h"
#include "field_battle.h"

#include "ev_mapchange.h"

#include "system/snd_tool.h"
#include "fld_bgm.h"

#include "sway_grass_enc.h"
#include "system/wipe.h"

#include "poketool/tr_tool.h"

#include "mapdata_warp.h"			//WARPDATA_GetRevivalLocation
#include "situation_local.h"		//Situation_Get`
#include "system/brightness.h"
#include "script.h"
#include "scr_tool.h"
#include "mapdefine.h"
#include "..\fielddata\script\common_scr_def.h"		//SCRID_GAME_OVER_RECOVER_PC
#include "sysflag.h"
#include "communication/communication.h"   // Ƃ蒠ւ̋L^̂
//#include "comm_direct_counter.h"
#include "comm_field_state.h"
#include "b_tower_fld.h"
#include "fld_move_poke.h"
#include "pokepark_sys.h"

#include "battle/trno_def.h"

#include "savedata/tv_work.h"
#include "tv_topic.h"		//TVTOPIC_Entry_Watch_Capture
#include "field/tvtopic_extern.h"
#include "fld_enceff_data.h"
#include "field/b_tower_ev.h"

#include "savedata/record.h"
#include "poketool/poke_number.h"
#include "poketool/status_rcv.h"
#include "syswork.h"

#include "battle/attr_def.h"

//============================================================================================
//============================================================================================
static void AddScoreByBattle(FIELDSYS_WORK * fsys, BATTLE_PARAM *inBattleParam );
static void WriteFNoteByBattle(FIELDSYS_WORK * fsys, BATTLE_PARAM *inBattleParam );

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static inline int DmyEffNo(void)
{
	return gf_mtRand() % ENCOUNT_NUM;
}

//============================================================================================
//
//
//	Cxg[R}hF퓬
//
//
//============================================================================================
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static BOOL GMEVENT_Sub_BattleProc(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	BATTLE_PARAM * battle_param = FieldEvent_GetSpecialWork(event);
	int *seq = FieldEvent_GetSeqWork(event);
	switch (*seq) {
	case 0:
		//퓬vZXo^
		FieldBattle_SetProc(fsys, battle_param);
		(*seq) ++;
		break;
	case 1:
		//TuvZXi퓬jI҂
		if (FieldEvent_Cmd_WaitSubProcEnd(fsys)) {
			break;
		}
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hF퓬Ăяo
 * @param	event			Cxg䃏[Nւ̃|C^
 * @param	battle_param	퓬pp[^ւ̃|C^
 * 
 * ƂĎ󂯎BATTLE_PARAM͉܂B
 * ĂяoŊǗĂB
 */
//-----------------------------------------------------------------------------
void EventCmd_BattleProc(GMEVENT_CONTROL * event, BATTLE_PARAM * battle_param)
{
	FieldEvent_Call(event, GMEVENT_Sub_BattleProc, battle_param);
}


//============================================================================================
//
//
//	CxgR}hF|PGJEgĂяo
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 */
//-----------------------------------------------------------------------------
typedef struct {
	int * winlose_flag;
	int effect_no;
	int bgm_no;
    int netTargetID;
	BATTLE_PARAM	*battle_param;
}EV_BATTLE_WORK;

//-----------------------------------------------------------------------------
/**
 */
//-----------------------------------------------------------------------------
static EV_BATTLE_WORK * EBW_Create(BATTLE_PARAM * btlprm, int effect_no, int bgm_no,
		int * winlose_flag)
{
	EV_BATTLE_WORK * ebw;
	ebw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EV_BATTLE_WORK));
	ebw->winlose_flag = winlose_flag;
	if (winlose_flag != NULL) {
		*winlose_flag = 0;
	}
	ebw->effect_no = effect_no;
	ebw->bgm_no = bgm_no;
	ebw->battle_param = btlprm;
	return ebw;
}

//-----------------------------------------------------------------------------
/**
 */
//-----------------------------------------------------------------------------
static void EBW_Delete(EV_BATTLE_WORK * ebw)
{
	//ogp[^j
	BattleParam_Delete(ebw->battle_param);

	sys_FreeMemoryEz(ebw);
}
#if 0	//<<20060609 del
//-----------------------------------------------------------------------------
/**
 * @brief	FIGHT_TYPEƃg[i[IDBGM肷
 */
//-----------------------------------------------------------------------------
static u16 GetBGMID(const BATTLE_PARAM * bp)
{
	return Snd_BattleBgmGet(bp->fight_type,bp->trainer_id[CLIENT_NO_ENEMY]); 
}
#endif
//-----------------------------------------------------------------------------
/**
 * @brief
 * @param	ebw			퓬V[PX[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static BOOL EBW_CheckResult(EV_BATTLE_WORK * ebw)
{
	BOOL win_flag;

	if (ebw->winlose_flag != NULL) {
		*(ebw->winlose_flag) = ebw->battle_param->win_lose_flag;
	}

	win_flag = BattleParam_IsWinResult(ebw->battle_param->win_lose_flag);
	return win_flag;
}

//-----------------------------------------------------------------------------
/**
 * @brief	og̃p[^f
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	ebw			퓬V[PX[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static void BattleParam_RefrectResult(const BATTLE_PARAM * btlprm, FIELDSYS_WORK * fsys)
{
	if (btlprm->fight_type & FIGHT_TYPE_DEBUG) {
		//fobOΐł͎莝̏Ȃ
		return;
	}
	BattleParam_UpdateGameData(btlprm, fsys);
#if 0
	if (BattleParam_IsWinResult(btlprm->win_lose_flag)) {
		//ꍇ
		BattleParam_UpdateGameData(btlprm, fsys);
	} else {
		//skꍇ
	}
#endif

}

//-----------------------------------------------------------------------------
/**
 * @brief	ʏ퓬CxgV[PX
 * @param	event		Cxg䃏[Nւ̃|C^
 * @retval	TRUE		CxgI
 * @retval	FALSE		Cxgp
 *
 * GJEgGtFNg퓬tB[hAsB
 * Q[I[o[ւ̕i\j
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_NormalBattle(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys;
	EV_BATTLE_WORK * ebw;
	int * seq;
	fsys = FieldEvent_GetFieldSysWork(event);
	ebw = FieldEvent_GetSpecialWork(event);
	seq = FieldEvent_GetSeqWork(event);

    switch (*seq) {
	case 0:
		//nai|[Y
		FieldOBJSys_MovePauseAll( fsys->fldobjsys );
		// CxgR}hFGJEgGtFNgĂяo
		EventCmd_EncountEffect(event, ebw->effect_no, ebw->bgm_no);
		(*seq) ++;
		break;
	case 1:
		//CxgR}hFtB[h}bvvZXI
		EventCmd_FinishFieldMap(event);
		(*seq) ++;
		break;
	case 2:
		//CxgR}hF퓬vZX
		EventCmd_BattleProc(event, ebw->battle_param);
		(*seq) ++;
		break;

	case 3:
		//퓬ʔfiA莝|PԁAetc...)
		BattleParam_RefrectResult(ebw->battle_param, fsys);
		if ( (ebw->battle_param->fight_type == FIGHT_TYPE_1vs1_YASEI)||
			 (ebw->battle_param->fight_type == FIGHT_TYPE_MOVE)||
			 (ebw->battle_param->fight_type == FIGHT_TYPE_2vs2_YASEI) ){			//쐶
			TVTOPIC_Entry_Watch_Capture(fsys,ebw->battle_param->TVWatchBattleWork,
					ebw->battle_param->win_lose_flag);
		}
		//퓬Ȉ
		if (EBW_CheckResult(ebw) == FALSE) {
			//Sł̏ꍇ͂ŏI
			EBW_Delete(ebw);
			return TRUE;
		}

		//A퓬͎莝
		if (SysFlag_PairCheck(SaveData_GetEventWork(fsys->savedata))){
			//AȂ̂Ŏ莝
			PokeParty_RecoverAll(SaveData_GetTemotiPokemon(fsys->savedata));
		}

		//XRAZ
		AddScoreByBattle(fsys, ebw->battle_param);
		//`m[gL
		WriteFNoteByBattle(fsys, ebw->battle_param);
		
		//CxgR}hFtB[h}bvvZXA
		EventCmd_StartFieldMap(event);
		(*seq) ++;
		break;
	case 4:
		//nai|[YNA
		FieldOBJSys_MovePauseAllClear( fsys->fldobjsys );
		//CxgR}hFtF[hC
		EventCmd_FieldFadeIn(event);
		(*seq) ++;
		break;
	case 5:
		EBW_Delete(ebw);
		return TRUE;
		break;
	}
	return FALSE;
}


//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static void EventCmd_NormalBattle(GMEVENT_CONTROL * event,
		BATTLE_PARAM * btlprm, int effect_no, int bgm_no, int * winlose_flag)
{
	EV_BATTLE_WORK * ebw;
	ebw = EBW_Create(btlprm, effect_no, bgm_no, winlose_flag);
	FieldEvent_Call(event, GMEVENT_NormalBattle, ebw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	킢ʂo^
 * @param	status  win_lose_flag
 * @retval	Ȃ
 */
//-----------------------------------------------------------------------------

static void wifiFriendWriteBattleResult(int status,FIELDSYS_WORK* fsys)
{
    switch(status & 0x0f){
      case FIGHT_WIN:		///퓬
      case FIGHT_ENEMY_ESCAPE:		///肪
        CommInfoSetBattleResult(fsys->savedata,1);
        break;
      case FIGHT_LOSE:		///퓬
      case FIGHT_ESCAPE:		///
        CommInfoSetBattleResult(fsys->savedata,-1);
        break;
    }
}

//-----------------------------------------------------------------------------
/**
 * @brief	ʐM퓬CxgV[PX
 * @param	event		Cxg䃏[Nւ̃|C^
 * @retval	TRUE		CxgI
 * @retval	FALSE		Cxgp
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_CommBattle(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys;
	EV_BATTLE_WORK * ebw;
	int * seq;
	fsys = FieldEvent_GetFieldSysWork(event);
	ebw = FieldEvent_GetSpecialWork(event);
	seq = FieldEvent_GetSeqWork(event);

    switch (*seq) {
	case 0:
		// CxgR}hFGJEgGtFNgĂяo
		EventCmd_EncountEffect(event, ebw->effect_no, ebw->bgm_no);
		(*seq) ++;
		break;
	case 1:
		//CxgR}hFtB[h}bvvZXI
		EventCmd_FinishFieldMap(event);
		(*seq) ++;
		break;
	case 2:
		//CxgR}hF퓬vZX
		EventCmd_BattleProc(event, ebw->battle_param);
		(*seq) ++;
		break;

	case 3:
		//퓬Ȉ
        // Ƃ蒠ɏs
        wifiFriendWriteBattleResult(ebw->battle_param->win_lose_flag,fsys);

		//zΐp̃Q[f[^Abvf[giƂj
		BattleParam_UpdateGameDataOfVirtualBattle(ebw->battle_param, fsys);
        {
            RECORD* pRecord = SaveData_GetRecord(fsys->savedata);
            RECORD_Score_Add(pRecord, SCORE_ID_COMM_BATTLE_COUNT);
        }
#if 0
		if (EBW_CheckResult(ebw) == FALSE) {
			/* Ƃ̏ */
		}
#endif

		//CxgR}hFtB[h}bvvZXA
		EventCmd_StartFieldMap(event);
		(*seq) ++;
		break;
	case 4:
		//CxgR}hFtF[hC
//		EventCmd_FieldFadeIn(event);
//		(*seq) ++;
//		break;
	case 5:
		EBW_Delete(ebw);
		return TRUE;
		break;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	WIFI퓬CxgV[PX    k.ohno쐬
 * @param	event		Cxg䃏[Nւ̃|C^
 * @retval	TRUE		CxgI
 * @retval	FALSE		Cxgp
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_WiFiBattle(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys;
	EV_BATTLE_WORK * ebw;
	int * seq;
	fsys = FieldEvent_GetFieldSysWork(event);
	ebw = FieldEvent_GetSpecialWork(event);
	seq = FieldEvent_GetSeqWork(event);

    switch (*seq) {
	case 0:

		Snd_DataSetByScene( SND_SCENE_BATTLE, ebw->bgm_no, 1 );	//ogȍĐ
        
		//CxgR}hF퓬vZX
		EventCmd_BattleProc(event, ebw->battle_param);
		(*seq) ++;
		break;
	case 1:
        {
            // Ƃ蒠ɏs
            wifiFriendWriteBattleResult(ebw->battle_param->win_lose_flag, fsys);

            //zΐp̃Q[f[^Abvf[giƂj
			BattleParam_UpdateGameDataOfVirtualBattle(ebw->battle_param, fsys);

        }
        {
            RECORD* pRecord = SaveData_GetRecord(fsys->savedata);
            RECORD_Score_Add(pRecord, SCORE_ID_COMM_BATTLE_COUNT);
        }
        
#if 0	//ʐMΐȂ̂Ŕsk͂̕Ȃ͂	2006.04.24 tamada
		//퓬Ȉ
		if (EBW_CheckResult(ebw) == FALSE) {

			//Sł̏ꍇ͂ŏI
			EBW_Delete(ebw);
			return TRUE;
		}
		BattleParam_RefrectResult(ebw->battle_param, fsys);
#endif

		(*seq) ++;
		break;
	case 2:
		EBW_Delete(ebw);
		return TRUE;
		break;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	og^[[J퓬CxgV[PX by iwasawa
 * @param	event		Cxg䃏[Nւ̃|C^
 * @retval	TRUE		CxgI
 * @retval	FALSE		Cxgp
 *
 * GJEgGtFNgog^[퓬tB[hAsB
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_TowerLocalBattle(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys;
	EV_BATTLE_WORK * ebw;
	int * seq;
	fsys = FieldEvent_GetFieldSysWork(event);
	ebw = FieldEvent_GetSpecialWork(event);
	seq = FieldEvent_GetSeqWork(event);

    switch (*seq) {
	case 0:
		// CxgR}hFGJEgGtFNgĂяo
		EventCmd_EncountEffect(event, ebw->effect_no, ebw->bgm_no);
		(*seq) ++;
		break;
	case 1:
		//CxgR}hFtB[h}bvvZXI
		EventCmd_FinishFieldMap(event);
		(*seq) ++;
		break;
	case 2:
		//CxgR}hF퓬vZX
		EventCmd_BattleProc(event, ebw->battle_param);
		(*seq) ++;
		break;

	case 3:
		//zΐp̃Q[f[^Abvf[giƂj
		BattleParam_UpdateGameDataOfVirtualBattle(ebw->battle_param, fsys);
		//^[pΐ팋ʃAbvf[g
		BtlTower_BattleRecordUpdate(fsys,&(ebw->battle_param->btr));

		//퓬Ȉ
		if (EBW_CheckResult(ebw) == FALSE) {
			//s폈
		}else{
			
//			UpdateBattleResult(event, ebw);		
		}

		//CxgR}hFtB[h}bvvZXA
		EventCmd_StartFieldMap(event);
		(*seq) ++;
		break;
	case 4:
		//CxgR}hFtF[hC
		EventCmd_FieldFadeIn(event);
		(*seq) ++;
		break;
	case 5:
		EBW_Delete(ebw);
		return TRUE;
	}
	return FALSE;
}

/**
 *	@brief	og^[@[JogCxgo^
 */
static void EventCmd_TowerLocalBattleCall(GMEVENT_CONTROL * event,
		BATTLE_PARAM * param, int effect_no, int bgm_no, int * winlose_flag)
{
	EV_BATTLE_WORK * ebw;
	ebw = EBW_Create(param, effect_no, bgm_no, winlose_flag);
	FieldEvent_Call(event, GMEVENT_TowerLocalBattle, ebw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hFog^[[Jΐ
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	trainer_id	g[i[wf[^
 * @param	fight_type	퓬
 * @param	heapID		q[vID
 * @param	winlose_flag	퓬ʂ󂯎tO
 */
//-----------------------------------------------------------------------------
void EventCmd_TowerLocalBattle(GMEVENT_CONTROL * event,BTOWER_SCRWORK* wk, int * winlose_flag)
{
	EV_BATTLE_WORK * ebw;
	BATTLE_PARAM *param;
	FIELDSYS_WORK * fsys;

	fsys = FieldEvent_GetFieldSysWork(event);

	//ogf[^
	param = BtlTower_CreateBattleParam(wk,fsys);
	
	//ĂяoCxgo^
	EventCmd_TowerLocalBattleCall( event,param,
								   FLD_EncEffSpDataEffectNoPackGet( param ),
								   FLD_EncEffSpDataBgmNoPackGet( param ),
								   winlose_flag);
}





















//============================================================================================
//
//
//				쐶GJEg
//
//
//============================================================================================
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
typedef struct {
	int seq;
	int effect_no;
	int bgm_no;
	int *winlose_flag;
	BATTLE_PARAM	*battle_param;
}EV_WILD_BATTLE_WORK;


static BOOL GMEVENT_NormalWildBattle(GMEVENT_CONTROL * event);
static BOOL GMEVENT_SafariBattle(GMEVENT_CONTROL * event);

//-----------------------------------------------------------------------------
/**
 */
//-----------------------------------------------------------------------------
static EV_WILD_BATTLE_WORK* EWBW_Create( BATTLE_PARAM * btlprm, int effect_no, int bgm_no,
		int * winlose_flag )
{
	EV_WILD_BATTLE_WORK	* ewbw;
	ewbw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EV_WILD_BATTLE_WORK));
	ewbw->winlose_flag = winlose_flag;
	if (winlose_flag != NULL) {
		*winlose_flag = 0;
	}
	ewbw->effect_no = effect_no;
	ewbw->bgm_no = bgm_no;
	ewbw->battle_param = btlprm;
	ewbw->seq = 0;
	return ewbw;
}

//-----------------------------------------------------------------------------
/**
 */
//-----------------------------------------------------------------------------
static void EWBW_Delete(EV_WILD_BATTLE_WORK * ewbw)
{
	//ogp[^j
	BattleParam_Delete(ewbw->battle_param);

	sys_FreeMemoryEz(ewbw);
}

//-----------------------------------------------------------------------------
/**
 * tB[hGJEgCxgZbg
 *
 * @param	fsys			tB[hVXe|C^
 * @param	ioBattleParam	ogp[^
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
void FieldEncount_Set(FIELDSYS_WORK * fsys, BATTLE_PARAM *ioBattleParam)
{

	if ( SysFlag_SafariCheck(SaveData_GetEventWork(fsys->savedata)) ){
		EV_BATTLE_WORK * ebw;
		ebw = EBW_Create(	ioBattleParam,
							FLD_EncEffSpDataEffectNoPackGet( ioBattleParam ),
							FLD_EncEffSpDataBgmNoPackGet( ioBattleParam ),
							NULL );
		FieldEvent_Set(fsys, GMEVENT_SafariBattle,ebw);
	}else{
		EV_WILD_BATTLE_WORK *ewbw;
		
		ewbw = EWBW_Create( ioBattleParam,
							FLD_EncEffSpDataEffectNoPackGet( ioBattleParam ),
							FLD_EncEffSpDataBgmNoPackGet( ioBattleParam ),
							NULL );
		FieldEvent_Set(fsys, GMEVENT_NormalWildBattle,ewbw);
	}
}

//-----------------------------------------------------------------------------
/**
 * tB[hGJEgCxg`FW
 *
 * @param	fsys			tB[hVXe|C^
 * @param	ioBattleParam	ogp[^
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
void FieldEncount_Change(FIELDSYS_WORK * fsys, GMEVENT_CONTROL * event, BATTLE_PARAM *ioBattleParam)
{

	if ( SysFlag_SafariCheck(SaveData_GetEventWork(fsys->savedata)) ){
		EV_BATTLE_WORK * ebw;
		ebw = EBW_Create(	ioBattleParam,
							FLD_EncEffSpDataEffectNoPackGet( ioBattleParam ),
							FLD_EncEffSpDataBgmNoPackGet( ioBattleParam ),
							NULL );
		FieldEvent_Change(event, GMEVENT_SafariBattle,ebw);
	}else{
		EV_WILD_BATTLE_WORK *ewbw;
		ewbw = EWBW_Create( ioBattleParam,
							FLD_EncEffSpDataEffectNoPackGet( ioBattleParam ),
							FLD_EncEffSpDataBgmNoPackGet( ioBattleParam ),
							NULL );
		FieldEvent_Change(event, GMEVENT_NormalWildBattle,ewbw);
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	ʏ쐶CxgV[PX
 * @param	event		Cxg䃏[Nւ̃|C^
 * @retval	TRUE		CxgI
 * @retval	FALSE		Cxgp
 *
 * TuCxgƂāAʏ퓬CxgV[PXR[
 * 
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_NormalWildBattle(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys;
	EV_WILD_BATTLE_WORK *ewbw;
	fsys = FieldEvent_GetFieldSysWork(event);
	ewbw = FieldEvent_GetSpecialWork(event);

	switch (ewbw->seq) {
	case 0:
		//nai|[Y
		FieldOBJSys_MovePauseAll( fsys->fldobjsys );
		//쐶JEgAbv
		RECORD_Inc(SaveData_GetRecord(fsys->savedata), RECID_BTL_ENCOUNT);
		
		// CxgR}hFGJEgGtFNgĂяo
		EventCmd_EncountEffect(event,ewbw->effect_no, ewbw->bgm_no);
		ewbw->seq++;
		break;
	case 1:
		//CxgR}hFtB[h}bvvZXI
		EventCmd_FinishFieldMap(event);
		ewbw->seq++;
		break;
	case 2:
		//CxgR}hF퓬vZX
		EventCmd_BattleProc(event, ewbw->battle_param);
		ewbw->seq++;
		break;

	case 3:
		//퓬ʔfiA莝|PԁAetc...)
		BattleParam_RefrectResult(ewbw->battle_param, fsys);
		TVTOPIC_Entry_Watch_Capture(fsys,ewbw->battle_param->TVWatchBattleWork,
				ewbw->battle_param->win_lose_flag);
		//퓬Ȉ
		if (BattleParam_IsWinResult(ewbw->battle_param->win_lose_flag) == FALSE) {
			//Sł̏ꍇ͂ŏI
			EWBW_Delete(ewbw);
			//hꑐZbg
			SwayGrass_InitSwayGrass(fsys->SwayGrass);
			FieldEvent_Change(event, GMEVENT_NormalGameOver, NULL);
			return FALSE;
		}

		//A퓬͎莝
		if (SysFlag_PairCheck(SaveData_GetEventWork(fsys->savedata))){
			//AȂ̂Ŏ莝
			PokeParty_RecoverAll(SaveData_GetTemotiPokemon(fsys->savedata));
		}

		//XRAZ
		AddScoreByBattle(fsys, ewbw->battle_param);
		//`m[gL
		WriteFNoteByBattle(fsys, ewbw->battle_param);
		
		//퓬Ihꑐp`FbN
		if (SwayGrass_CheckValid( fsys->SwayGrass )){
			if (SwayGrass_IsSwayEncRetern(fsys->SwayGrass)){	//hꑐGJEgA
				if ( ( !(ewbw->battle_param->win_lose_flag==FIGHT_WIN) ) &&
						( !(ewbw->battle_param->win_lose_flag==FIGHT_POKE_GET) ) ){		//
					//hꑐZbg
					SwayGrass_InitSwayGrass(fsys->SwayGrass);
				}
			}else{//ʏ擪ÁAhꑐł~ߕÂƂ
				//hꑐZbg
				SwayGrass_InitSwayGrass(fsys->SwayGrass);
			}
		}
		//CxgR}hFtB[h}bvvZXA
		EventCmd_StartFieldMap(event);
		ewbw->seq++;
		break;
	case 4:
		//ړ|P
		FLD_MP_SetAfferBattle(fsys, ewbw->battle_param);
		//CxgR}hFtF[hC
		EventCmd_FieldFadeIn(event);
		ewbw->seq++;
		break;
	case 5:
		if (SwayGrass_CheckValid( fsys->SwayGrass )){	//hꑐGJEgA
			SwayGrass_SetChain(	fsys, ewbw->battle_param->win_lose_flag, fsys->SwayGrass);
			//Zbg
			SwayGrass_SetSwayGrassAnime(fsys, fsys->SwayGrass);
		}
		ewbw->seq++;
		break;
	case 6:
		if (SwayGrass_CheckSwayGrassAnimeEnd(fsys->SwayGrass)){
			//nai|[YNA
			FieldOBJSys_MovePauseAllClear( fsys->fldobjsys );
			EWBW_Delete(ewbw);
			return TRUE;
		}
		break;
	}
	return FALSE;
}

#include "../fielddata/script/safari_def.h"
//-----------------------------------------------------------------------------
/**
 * @brief	Tt@CxgV[PX
 * @param	event		Cxg䃏[Nւ̃|C^
 * @retval	TRUE		CxgI
 * @retval	FALSE		Cxgp
 *
 * TuCxgƂāATt@CxgV[PXR[
 * 
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_SafariBattle(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys;
	EV_BATTLE_WORK * ebw;
	int * seq;
	u16 *safari_ball;

	fsys = FieldEvent_GetFieldSysWork(event);
	ebw = FieldEvent_GetSpecialWork(event);
	seq = FieldEvent_GetSeqWork(event);
	safari_ball = Situation_GetSafariBallCount(SaveData_GetSituation(fsys->savedata));

    switch (*seq) {
	case 0:
		//nai|[Y
		FieldOBJSys_MovePauseAll( fsys->fldobjsys );
		//쐶JEgAbv
		RECORD_Inc(SaveData_GetRecord(fsys->savedata), RECID_BTL_ENCOUNT);
		// CxgR}hFGJEgGtFNgĂяo
		EventCmd_EncountEffect(event, ebw->effect_no, ebw->bgm_no);
		(*seq) ++;
		break;
	case 1:
		//CxgR}hFtB[h}bvvZXI
		EventCmd_FinishFieldMap(event);
		(*seq) ++;
		break;
	case 2:
		//CxgR}hF퓬vZX
		EventCmd_BattleProc(event, ebw->battle_param);
		(*seq) ++;
		break;

	case 3:
		//퓬ʔfiA莝|PԁAetc...)
		BattleParam_RefrectResult(ebw->battle_param, fsys);
		if (ebw->battle_param->win_lose_flag == FIGHT_POKE_GET) {
			TV_WORK * tvwk = SaveData_GetTvWork(fsys->savedata);
			POKEMON_PARAM * pp = PokeParty_GetMemberPointer(
					ebw->battle_param->poke_party[CLIENT_NO_ENEMY], 0);
			TVTOPIC_SafariTemp_Set(tvwk, pp);
		}

		//A͂Ȃ
		
		//XRAZ
		AddScoreByBattle(fsys, ebw->battle_param);
		
		//퓬Ȉ
		if ((*safari_ball) == 0 && ebw->battle_param->win_lose_flag != FIGHT_POKE_GET){
			//Tt@{[ȂȂTt@Q[g֖߂
			LOCATION_WORK *next;
			next = Situation_GetSpecialLocation(SaveData_GetSituation(fsys->savedata));
			EventCmd_MapChangeByLocation(event, next);
			//Tt@{[Ȃ
///			OS_Printf("Tt@{[ȂȂ܂\n");
		}
		//`m[gLq
		WriteFNoteByBattle( fsys, ebw->battle_param );

		(*seq) ++;
		break;

	case 4:
		//CxgR}hFtB[h}bvvZXA
		EventCmd_StartFieldMap(event);
		(*seq) ++;
		break;
	case 5:
		//nai|[YNA
		FieldOBJSys_MovePauseAllClear( fsys->fldobjsys );
		//CxgR}hFtF[hC
		EventCmd_FieldFadeIn(event);
		(*seq) ++;
		break;
	case 6:
		if ((*safari_ball) == 0){
			if (ebw->battle_param->win_lose_flag == FIGHT_POKE_GET) {
				//tB[hŃAiEXĂQ[gֈړAI
				EventCall_Script(event, SCRID_SAFARI_ANNOUNCE_BALL, NULL, NULL);
			} else {
				//퓬ʓŃAiEXς݂Ȃ̂ŒڃQ[gֈړAI
				EventCall_Script(event, SCRID_SAFARI_END_GATE, NULL, NULL);
			}
		} else {
			BOX_DATA * box = SaveData_GetBoxData(fsys->savedata);
			POKEPARTY * party = SaveData_GetTemotiPokemon(fsys->savedata);
			if (BOXDAT_GetEmptyTrayNumber(box) == BOXDAT_TRAYNUM_ERROR
					&& PokeParty_GetPokeCount(party) == 6) {
				EventCall_Script(event, SCRID_SAFARI_ANNOUNCE_BOX_FULL, NULL, NULL);
			}
		}
		(*seq) ++;
		break;
	case 7:
		EBW_Delete(ebw);
		return TRUE;
		break;
	}
	return FALSE;
}

//============================================================================================
//
//
//				hGJEg
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hFhGJEg
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	winlose_flag	퓬ʂ󂯎tO
 */
//-----------------------------------------------------------------------------
void EventCmd_HoneyTreeBattle(GMEVENT_CONTROL * event, int * winlose_flag)
{
	EV_BATTLE_WORK * ebw;
	BATTLE_PARAM *btlprm;
	FIELDSYS_WORK * fsys;

	fsys = FieldEvent_GetFieldSysWork(event);

	//hꑐZbg
	SwayGrass_InitSwayGrass(fsys->SwayGrass);
	
	//ogp[^̃AP[Vƃ|Pp[eB̏
	btlprm = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_1vs1_YASEI);
	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(btlprm, fsys);

	btlprm->bg_id = BG_ID_BASIC;		//{wiw
	btlprm->ground_id = GROUND_ID_GRAVEL;	//{nʎw
	//hGJEgf[^Zbg
	SetHoneyTreeEncountData(fsys, btlprm);
	
	//쐶JEgAbv
	RECORD_Inc(SaveData_GetRecord(fsys->savedata), RECID_BTL_ENCOUNT);

	EventCmd_NormalBattle( event, btlprm,
						   FLD_EncEffSpDataEffectNoPackGet( btlprm ),
						   FLD_EncEffSpDataBgmNoPackGet( btlprm ),
						   winlose_flag);
}


//============================================================================================
//
//
//				|Pio[ƃxw肵Ė쐶(XNvgŎgp)
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hF|Pio[ƃxw肵Ė쐶
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	monsno		|Pio[
 * @param	level		x
 * @param	winlose_flag	퓬ʂ󂯎tO
 * @param	densetsu		`|PGJEgǂ̃tO
 *
 * densetsutOTRUEnƃGJEgbZ[W
 * uяovł͂ȂuꂽvɂȂ܂
 */
//-----------------------------------------------------------------------------
void EventCmd_WildBattle(GMEVENT_CONTROL * event, u16 monsno, u8 level, int * winlose_flag,BOOL densetsu)
{
	EV_BATTLE_WORK * ebw;
	BATTLE_PARAM *btlprm;
	FIELDSYS_WORK * fsys;

	fsys = FieldEvent_GetFieldSysWork(event);

	//hꑐZbg
	SwayGrass_InitSwayGrass(fsys->SwayGrass);

	//ogp[^̃AP[Vƃ|Pp[eB̏
	btlprm = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_1vs1_YASEI);

	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(btlprm, fsys);

	//GJEgf[^Zbg
	SetWildEncountData(fsys, monsno, level, btlprm);

	/*
	//@battle_status_flag
	//	ɃZbg悤ɂI
	*/
	if(densetsu){
		//`|PGJEgȂtO𗧂ĂăGJEgbZ[Wς
		btlprm->battle_status_flag |= BATTLE_STATUS_FLAG_DENSETSU_BATTLE;
	}
	/*
		ACe̎w肪KvH
	*/

	//쐶JEgAbv
	RECORD_Inc(SaveData_GetRecord(fsys->savedata), RECID_BTL_ENCOUNT);
	
	EventCmd_NormalBattle(event, btlprm, FLD_EncEffSpDataEffectNoPackGet( btlprm ), FLD_EncEffSpDataBgmNoPackGet( btlprm ), winlose_flag);
}

//============================================================================================
//============================================================================================
#include "../fielddata/script/d10r0101_def.h"		//SCRID_D10R0101_FINISH
//-----------------------------------------------------------------------------
/**
 * @brief		CxgF|Pp[N퓬
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_PokeParkBattle(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys;
	EV_BATTLE_WORK * ebw;
	int * seq;

	fsys = FieldEvent_GetFieldSysWork(event);
	ebw = FieldEvent_GetSpecialWork(event);
	seq = FieldEvent_GetSeqWork(event);

    switch (*seq) {
	case 0:
		//nai|[Y
		FieldOBJSys_MovePauseAll( fsys->fldobjsys );
		//쐶JEgAbv
		RECORD_Inc(SaveData_GetRecord(fsys->savedata), RECID_BTL_ENCOUNT);
		// CxgR}hFGJEgGtFNgĂяo
		EventCmd_EncountEffect(event, ebw->effect_no, ebw->bgm_no);
		(*seq) ++;
		break;
	case 1:
		//CxgR}hFtB[h}bvvZXI
		EventCmd_FinishFieldMap(event);
		(*seq) ++;
		break;
	case 2:
		//CxgR}hF퓬vZX
		EventCmd_BattleProc(event, ebw->battle_param);
		(*seq) ++;
		break;

	case 3:
		//퓬ʔfiA莝|PԁAetc...)
		BattleParam_RefrectResult(ebw->battle_param, fsys);
		//|Pp[Np̐퓬ʔf
		PokeParkSys_ReflectBattleResult(fsys, ebw->battle_param);
		
		//A͂Ȃ
		
		//XRAZ
		AddScoreByBattle(fsys, ebw->battle_param);
		//퓬Ȉ
		(*seq) ++;
		break;

	case 4:
		//CxgR}hFtB[h}bvvZXA
		EventCmd_StartFieldMap(event);
		(*seq) ++;
		break;
	case 5:
		//nai|[YNA
		FieldOBJSys_MovePauseAllClear( fsys->fldobjsys );
		//CxgR}hFtF[hC
		EventCmd_FieldFadeIn(event);
		(*seq) ++;
		break;
	case 6:
		EBW_Delete(ebw);
		if (PokeParkSys_GetBallCount(fsys) == 0) {
			EventChange_Script(event, SCRID_D10R0101_FINISH, NULL);
			return FALSE;
		} else {
			return TRUE;
		}
		break;
	}
	return FALSE;

}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
void EventSet_PokeParkBattle(FIELDSYS_WORK * fsys, BATTLE_PARAM * btlprm)
{
	EV_BATTLE_WORK * ebw;
	ebw = EBW_Create( btlprm,
				      FLD_EncEffSpDataEffectNoPackGet( btlprm ),
					  FLD_EncEffSpDataBgmNoPackGet(btlprm),
					  NULL);
	FieldEvent_Set(fsys, GMEVENT_PokeParkBattle, ebw);
}


//============================================================================================
//
//
//						ŏ̃Cxg(XNvgŎgp)
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hFŏ̃Cxg
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	monsno		|Pio[
 * @param	level		x
 */
//-----------------------------------------------------------------------------
void EventCmd_FirstBattle(GMEVENT_CONTROL * event, u16 monsno, u8 level)
{
	BATTLE_PARAM *btlprm;
	FIELDSYS_WORK * fsys;

	fsys = FieldEvent_GetFieldSysWork(event);

	//ogp[^̃AP[Vƃ|Pp[eB̏
	btlprm = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_1vs1_YASEI);

	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(btlprm, fsys);

	//GJEgf[^Zbg
	SetWildEncountData(fsys, monsno, level, btlprm);

	//퓬ptO
	btlprm->battle_status_flag = BATTLE_STATUS_FLAG_FIRST_BATTLE;

	/*
		ACe̎w肪KvH
	*/

	//쐶JEgAbv
	RECORD_Inc(SaveData_GetRecord(fsys->savedata), RECID_BTL_ENCOUNT);

	EventCmd_NormalBattle( event, btlprm,
						   FLD_EncEffSpDataEffectNoPackGet( btlprm ),
						   FLD_EncEffSpDataBgmNoPackGet( btlprm ),
						   NULL);
}

//============================================================================================
//
//
//			ߊlf
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	CxgFߊlf
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_CaptureDemo(GMEVENT_CONTROL * event)
{
	EV_BATTLE_WORK * ebw = FieldEvent_GetSpecialWork(event);
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	int * seq = FieldEvent_GetSeqWork(event);
	switch (*seq) {
	case 0:
		//nai|[Y
		FieldOBJSys_MovePauseAll( fsys->fldobjsys );
		// CxgR}hFGJEgGtFNgĂяo
		EventCmd_EncountEffect(event, ebw->effect_no, ebw->bgm_no);
		(*seq) ++;
		break;
	case 1:
		//CxgR}hFtB[h}bvvZXI
		EventCmd_FinishFieldMap(event);
		(*seq) ++;
		break;
	case 2:
		//CxgR}hF퓬vZX
		EventCmd_BattleProc(event, ebw->battle_param);
		(*seq) ++;
		break;

	case 3:
		//퓬ʔfiA莝|PԁAetc...)
		//ȂɂfȂB
		(*seq) ++;
		break;

	case 4:
		//CxgR}hFtB[h}bvvZXA
		EventCmd_StartFieldMap(event);
		(*seq) ++;
		break;
	case 5:
		//nai|[YNA
		FieldOBJSys_MovePauseAllClear( fsys->fldobjsys );
		//CxgR}hFtF[hC
		EventCmd_FieldFadeIn(event);
		(*seq) ++;
		break;
	case 6:
		EBW_Delete(ebw);
		return TRUE;
		break;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	TuCxgĂяoFߊlf
 * @param	fsys			tB[hVXe|C^
 */
//-----------------------------------------------------------------------------
void EventCmd_CaptureDemo(GMEVENT_CONTROL * event)
{
	EV_BATTLE_WORK * ebw;
	BATTLE_PARAM * btlprm;
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);

	btlprm = BattleParam_CreateForGetDemo(HEAPID_WORLD, fsys);
	ebw = EBW_Create( btlprm,
				      FLD_EncEffSpDataEffectNoPackGet( btlprm ),
					  FLD_EncEffSpDataBgmNoPackGet(btlprm),
					  NULL);
	FieldEvent_Call(event, GMEVENT_CaptureDemo, ebw);
}

//============================================================================================
//
//
//				g[i[ΐ
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hFg[i[ΐ
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	trainer_id	g[i[wf[^
 * @param	fight_type	퓬
 * @param	heapID		q[vID
 * @param	winlose_flag	퓬ʂ󂯎tO
 */
//-----------------------------------------------------------------------------
void EventCmd_TrainerBattle(GMEVENT_CONTROL * event, int tr_id_0, int tr_id_1, int partner_id,
		 int heapID, int * winlose_flag)
{
	u32 fight_type;
	EV_BATTLE_WORK * ebw;
	BATTLE_PARAM *btlprm;
	FIELDSYS_WORK * fsys;

	fsys = FieldEvent_GetFieldSysWork(event);

	if( (tr_id_1 != 0) && (tr_id_0 != tr_id_1) ){
		if (partner_id == 0) {
			fight_type = FIGHT_TYPE_TAG_BATTLE;
		} else {
		//AȂAKAI}`
			fight_type = FIGHT_TYPE_AI_MULTI;
		}

	//_u
	}else if( tr_id_0 == tr_id_1 ){
		fight_type = FIGHT_TYPE_2vs2_TRAINER;

	}else{
		fight_type = FIGHT_TYPE_TRAINER;
	}
	//hꑐZbg
	SwayGrass_InitSwayGrass(fsys->SwayGrass);

	/* g[i[Ȃ̂Ŗ쐶̃p[^ŐFX㏑ */

	//ogp[^̃AP[Vƃ|Pp[eB̏
	btlprm = BattleParam_Create(HEAPID_WORLD, fight_type);

	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(btlprm, fsys);

	btlprm->trainer_id[CLIENT_NO_ENEMY] = tr_id_0;
	btlprm->trainer_id[CLIENT_NO_ENEMY2] = tr_id_1;
	btlprm->trainer_id[CLIENT_NO_MINE2] = partner_id;

	//g[i[f[^
	TT_EncountTrainerDataMake( btlprm, fsys->savedata, heapID );

	//g[i[JEgAbv
	RECORD_Inc(SaveData_GetRecord(fsys->savedata), RECID_BTL_TRAINER);

	EventCmd_NormalBattle(event, btlprm, FLD_EncEffSpDataEffectNoPackGet( btlprm ), FLD_EncEffSpDataBgmNoPackGet( btlprm ), winlose_flag);
}

//============================================================================================
//
//
//				ʐMΐ
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	ʐMΐCxgZbg
 * @param	event
 */
//-----------------------------------------------------------------------------
void EventCmd_CommBattle(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EV_BATTLE_WORK * ebw;
	BATTLE_PARAM *btlprm;
	//ogp[^̃AP[Vƃ|Pp[eB̏

    btlprm = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_1vs1_SIO);
	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(btlprm, fsys);

	ebw = EBW_Create( btlprm,
					  FLD_EncEffSpDataEffectNoPackGet( btlprm ),
					  FLD_EncEffSpDataBgmNoPackGet( btlprm ),
					  NULL);
	FieldEvent_Call(event, GMEVENT_CommBattle, ebw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	키莝̔zΐCxgZbg
 * @param	event
 */
//-----------------------------------------------------------------------------
void EventCmd_TemotiListBattle(GMEVENT_CONTROL * event,const u8* temotiList, int fightType)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EV_BATTLE_WORK * ebw;
	BATTLE_PARAM *btlprm;
	//ogp[^̃AP[Vƃ|Pp[eB̏

    btlprm = BattleParam_Create(HEAPID_WORLD, fightType);
	//莝|PȂǃZbg
	BattleParam_SetTemotiListParamGameData(btlprm, fsys, temotiList);

	ebw = EBW_Create( btlprm,
					  FLD_EncEffSpDataEffectNoPackGet( btlprm ),
					  FLD_EncEffSpDataBgmNoPackGet( btlprm ),
					  NULL);
	FieldEvent_Call(event, GMEVENT_CommBattle, ebw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	WIFIʐMΐCxgZbg
 * @param	event
 */
//-----------------------------------------------------------------------------
void EventCmd_WifiBattle(GMEVENT_CONTROL * event,int targetID, int lvLimit,BOOL bSingle)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EV_BATTLE_WORK * ebw;
	BATTLE_PARAM *btlprm;
	//ogp[^̃AP[Vƃ|Pp[eB̏
    if(bSingle){
        btlprm = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_1vs1_SIO);
    }
    else{
        btlprm = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_2vs2_SIO);
    }
	//莝|PȂǃZbg
	BattleParam_SetParamByWiFiGameData(btlprm, fsys, lvLimit);

	ebw = EBW_Create( btlprm,
					  FLD_EncEffSpDataEffectNoPackGet( btlprm ),
					  FLD_EncEffSpDataBgmNoPackGet( btlprm ),
					  NULL);
    ebw->netTargetID = targetID;
	FieldEvent_Call(event, GMEVENT_WiFiBattle, ebw);
}


//-----------------------------------------------------------------------------
/**
 * @brief	ʐMΐ핔ł̑ΐCxg
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_CommDirectBattle(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EV_BATTLE_WORK * ebw = FieldEvent_GetSpecialWork(event);
	int * seq = FieldEvent_GetSeqWork(event);

	switch (*seq) {
	case 0:
		FieldEvent_Call(event, GMEVENT_CommBattle, ebw);
		(*seq) ++;
		break;
	case 1:
		CommFieldStateEnterBattleRoom( fsys );
		return TRUE;
	}
	return FALSE;
}
//-----------------------------------------------------------------------------
/**
 * @brief	ʐMΐ핔ł̑ΐCxgN
 * @param	fsys
 * @param	temotilist
 * @param	fightType
 */
//-----------------------------------------------------------------------------
void EventSet_CommDirectBattle(FIELDSYS_WORK * fsys, const u8 * temotiList, int fightType)
{
	EV_BATTLE_WORK * ebw;
	BATTLE_PARAM *btlprm;
	//ogp[^̃AP[Vƃ|Pp[eB̏

    btlprm = BattleParam_Create(HEAPID_WORLD, fightType);
	//莝|PȂǃZbg
	BattleParam_SetTemotiListParamGameData(btlprm, fsys, temotiList);

	ebw = EBW_Create( btlprm,
					  FLD_EncEffSpDataEffectNoPackGet( btlprm ),
					  FLD_EncEffSpDataBgmNoPackGet( btlprm ),
					  NULL);
	FieldEvent_Set(fsys, GMEVENT_CommDirectBattle, ebw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	ʐMΐ핔ł̑ΐCxgNiCӂPOKEPARTYZbgłj
 *
 * @param	fsys
 * @param	temotilist
 * @param	fightType
 */
//-----------------------------------------------------------------------------
void EventSet_CommDirectMixBattle(FIELDSYS_WORK * fsys, const POKEPARTY* party, int fightType)
{
	EV_BATTLE_WORK * ebw;
	BATTLE_PARAM *btlprm;
	//ogp[^̃AP[Vƃ|Pp[eB̏

    btlprm = BattleParam_Create(HEAPID_WORLD, fightType);

	//莝|PȂǃZbg
	BattleParam_SetCommBattle( btlprm, fsys, party, NULL );

	ebw = EBW_Create( btlprm,
					  FLD_EncEffSpDataEffectNoPackGet( btlprm ),
					  FLD_EncEffSpDataBgmNoPackGet( btlprm ),
					  NULL);
	FieldEvent_Set(fsys, GMEVENT_CommDirectBattle, ebw);
}

//-----------------------------------------------------------------------------
/**
 * 퓬XRAZ(^[EʐMΉ)
 * 
 * @param	fsys			tB[hVXe|C^
 * @param	inBattleParam	ogp
 * 
 * @return	none
 * 
 */
//-----------------------------------------------------------------------------
static void AddScoreByBattle(FIELDSYS_WORK * fsys, BATTLE_PARAM *inBattleParam )
{
	POKEMON_PARAM * pp;
	u32 fight_type = inBattleParam->fight_type;
	int win_lose_flg = inBattleParam->win_lose_flag;
	
	if (fight_type&FIGHT_TYPE_SIO){
		return;
	}

	if (fight_type&FIGHT_TYPE_TOWER){
		return;
	}

	if ( (fight_type == FIGHT_TYPE_1vs1_YASEI)||
		 (fight_type == FIGHT_TYPE_MOVE)||
		 (fight_type == FIGHT_TYPE_2vs2_YASEI) ){			//쐶
		if (win_lose_flg == FIGHT_WIN){	//Ƃ
			//XRAZF쐶폟
			RECORD_Score_Add( SaveData_GetRecord(fsys->savedata), SCORE_ID_WILD_BATTLE_WIN );
		}else if(win_lose_flg == FIGHT_POKE_GET){		//߂܂Ƃ
			pp = PokeParty_GetMemberPointer(
					inBattleParam->poke_party[CLIENT_NO_ENEMY], 0);
			
			//VIE}Ӄ|PH
			if ( PMNumber_GetPokeNumber( PM_NUMBER_SHINOU, PokeParaGet(pp,ID_PARA_monsno,0) ) ){
				//XRAZFVIE}Ӄ|PQbg
				RECORD_Score_Add( SaveData_GetRecord(fsys->savedata), SCORE_ID_POKE_GET_SINOU );
			}else{
				//XRAZFVIE}ӊO|PQbg
				RECORD_Score_Add( SaveData_GetRecord(fsys->savedata), SCORE_ID_POKE_GET_WORLD );
			}
		}
	}else if ( (fight_type&FIGHT_TYPE_TRAINER)||
			   (fight_type&FIGHT_TYPE_TAG) ){			//g[i[
		//Z
		if (win_lose_flg == FIGHT_WIN){
			//XRAZFg[i[폟
			RECORD_Score_Add( SaveData_GetRecord(fsys->savedata), SCORE_ID_TRAINER_BATTLE_WIN );
		}
	}else if ( (fight_type&FIGHT_TYPE_SAFARI)||
			   (fight_type&FIGHT_TYPE_POKE_PARK) ){	//Tt@E|Pp[N
		//߂܂Z
		if (win_lose_flg == FIGHT_POKE_GET){
			pp = PokeParty_GetMemberPointer(
					inBattleParam->poke_party[CLIENT_NO_ENEMY], 0);
			//VIE}Ӄ|PH
			if ( PMNumber_GetPokeNumber( PM_NUMBER_SHINOU, PokeParaGet(pp,ID_PARA_monsno,0) ) ){
				//XRAZFVIE}Ӄ|PQbg
				RECORD_Score_Add( SaveData_GetRecord(fsys->savedata), SCORE_ID_POKE_GET_SINOU );
			}else{
				//XRAZFVIE}ӊO|PQbg
				RECORD_Score_Add( SaveData_GetRecord(fsys->savedata), SCORE_ID_POKE_GET_WORLD );
			}
		}
	}
}

//-----------------------------------------------------------------------------
/**
 * 퓬`m[gL(^[EʐME|Pp[NΉ)
 *
 * @param	fsys			tB[hVXe|C^
 * @param	inBattleParam	ogp
 * 
 * @return	none
 * 
 */
//-----------------------------------------------------------------------------
static void WriteFNoteByBattle(FIELDSYS_WORK * fsys, BATTLE_PARAM *inBattleParam )
{
	POKEMON_PARAM * pp;
	u32 fight_type = inBattleParam->fight_type;
	int win_lose_flg = inBattleParam->win_lose_flag;
	
	if (fight_type&FIGHT_TYPE_SIO){
		return;
	}

	if (fight_type&FIGHT_TYPE_TOWER){
		return;
	}

	if ( fight_type&FIGHT_TYPE_POKE_PARK ){
		return;
	}

	if ( (fight_type == FIGHT_TYPE_1vs1_YASEI)||
		 (fight_type == FIGHT_TYPE_MOVE)||
		 (fight_type == FIGHT_TYPE_2vs2_YASEI)||
		 (fight_type == FIGHT_TYPE_SAFARI)){			//쐶
		FNOTE_WK_POKE *wk;
		if (win_lose_flg == FIGHT_WIN){	//Ƃ
			//JEgAbv
			fsys->encount.WinPokeCount++;//l̐U؂͉ĂȂł
			//5CȏŃm[gL
			if (fsys->encount.WinPokeCount >= 5){
				pp = PokeParty_GetMemberPointer(
					inBattleParam->poke_party[CLIENT_NO_ENEMY], 0);
				wk = FNOTE_PokemonDownDataMake(
						SaveData_GetPlayTime(fsys->savedata),
						PokeParaGet(pp,ID_PARA_monsno,0),
						PokeParaGet(pp,ID_PARA_sex,0),
						inBattleParam->time_zone, HEAPID_WORLD );
/*
				wk = FNOTE_PokemonDownDataMake( PokeParaGet(pp,ID_PARA_monsno,0),
									    		PokeParaGet(pp,ID_PARA_sex,0),
											    inBattleParam->time_zone, HEAPID_WORLD );
*/
				FNOTE_DataSave( fsys->fnote, wk, FNOTE_TYPE_POKEMON );
			}
		}else if(win_lose_flg == FIGHT_POKE_GET){		//߂܂Ƃ
			int client;
			//߂܂|P̈ʒu擾
			client = inBattleParam->get_pokemon_client;
			pp = PokeParty_GetMemberPointer(
					inBattleParam->poke_party[client], 0);
			//m[gL
			wk = FNOTE_PokemonGetDataMake(
					SaveData_GetPlayTime(fsys->savedata),
					PokeParaGet(pp,ID_PARA_monsno,0),
					PokeParaGet(pp,ID_PARA_sex,0),
					inBattleParam->time_zone, HEAPID_WORLD );
//
/*
			wk = FNOTE_PokemonGetDataMake( PokeParaGet(pp,ID_PARA_monsno,0),
				    					   PokeParaGet(pp,ID_PARA_sex,0),
										   inBattleParam->time_zone, HEAPID_WORLD );
*/
			FNOTE_DataSave( fsys->fnote, wk, FNOTE_TYPE_POKEMON );
		}
	}else if ( (fight_type&FIGHT_TYPE_TRAINER)||
			   (fight_type&FIGHT_TYPE_TAG) ){			//g[i[
		if (win_lose_flg == FIGHT_WIN){
			//m[gL
			FNOTE_DataMakeSaveTrainer(
				fsys->fnote,
				fsys->location->zone_id,
				inBattleParam->trainer_id[CLIENT_NO_ENEMY],
				HEAPID_WORLD );
/*
			FNOTE_WK_TRAINER *wk;
			wk = FNOTE_TrainerDataMake( fsys->location->zone_id,
										inBattleParam->trainer_id[CLIENT_NO_ENEMY],
										HEAPID_WORLD );
			FNOTE_DataSave( fsys->fnote, wk, FNOTE_TYPE_TRAINER );
*/
		}
	}

}

#ifdef PM_DEBUG

//============================================================================================
//
//
//			fobOp
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 *	fobOp
 */
//-----------------------------------------------------------------------------
BOOL DebugFieldEncount(FIELDSYS_WORK * fsys)
{
	BATTLE_PARAM *btlprm;
	//ogp[^̃AP[Vƃ|Pp[eB̏
	btlprm = BattleParam_Create(HEAPID_EVENT, FIGHT_TYPE_DEBUG|FIGHT_TYPE_1vs1);
	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(btlprm, fsys);
	
	//ɒnGJEgf[^Zbg
	DebugSetEncountData( NULL, GROUND_ENCOUNT, btlprm );
	
	FieldEncount_Set(fsys, btlprm);

	return TRUE;
}
//-----------------------------------------------------------------------------
/**
 *	fobOp
 */
//-----------------------------------------------------------------------------
BOOL DebugFieldEncount2vs2(FIELDSYS_WORK * fsys)
{
	BATTLE_PARAM *btlprm;
	//ogp[^̃AP[Vƃ|Pp[eB̏
	btlprm = BattleParam_Create(HEAPID_EVENT, FIGHT_TYPE_2vs2_TRAINER|FIGHT_TYPE_DEBUG);
	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(btlprm, fsys);

	btlprm->trainer_id[CLIENT_NO_ENEMY]=gf_rand()%16+1;
	//g[i[f[^
	TT_EncountTrainerDataMake(btlprm,fsys->savedata,HEAPID_WORLD);

	FieldEncount_Set(fsys, btlprm);

	return TRUE;
}
//-----------------------------------------------------------------------------
/**
 *	fobOp
 */
//-----------------------------------------------------------------------------
BOOL DebugFieldTrainerEncount(FIELDSYS_WORK * fsys)
{
	BATTLE_PARAM *btlprm;
	//ogp[^̃AP[Vƃ|Pp[eB̏
	btlprm = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_TRAINER|FIGHT_TYPE_DEBUG);
	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(btlprm, fsys);
	
	btlprm->trainer_id[CLIENT_NO_ENEMY]=gf_rand()%247+1;
	//g[i[f[^
	TT_EncountTrainerDataMake(btlprm,fsys->savedata,HEAPID_WORLD);
	
	FieldEncount_Set(fsys, btlprm);

	return TRUE;
}

#endif	//PM_DEBUG

