//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		field_glb_state.c
 *@brief	tB[hIuWFɉe^f[^S
 *@author	tomoya takahashi
 *@data		2005.06.07
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "common.h"
#include "field_glb_state.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
 */
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
 */
//-----------------------------------------------------------------------------


//----------------------------------------------------------------------------
/**
 *					vg^Cv錾
 */
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
/**
 *					O[oϐ錾
 */
//-----------------------------------------------------------------------------


//----------------------------------------------------------------------------
/**
 *
 *@brief	CgE}eÃO[oXe[gf[^
 *			ۑ̈쐬
 *
 *@param	none
 *
 *@return	GLST_DATA*	쐬āAf[^
 *
 *
 */
//-----------------------------------------------------------------------------
GLST_DATA_PTR GLST_Init(void)
{
	GLST_DATA* p_data;
	p_data = sys_AllocMemory(HEAPID_FIELD, sizeof(GLST_DATA));
	MI_CpuClear32(p_data, sizeof(GLST_DATA));

	return p_data;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	CgE}eÃO[oXe[gf[^
 *			ۑ̈J
 *
 *@param	pGLST_Data		ۑ̈̃|C^i[Ăϐ̃AhX
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void GLST_Delete(GLST_DATA_PTR* pGLST_Data)
{
	sys_FreeMemory(HEAPID_FIELD, *pGLST_Data);
	*pGLST_Data = NULL;
}


//-----------------------------------------------------------------------------
//
//	f[^̔f֐S
//
//=============================================================================
//----------------------------------------------------------------------------
/**
 *
 *@brief	ݒO[oXe[gɐݒ
 *
 *@param	GLDT_Data	O[oȏ
 *@param	flag		𔽉f̂
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void GLST_Reflect(GLST_DATA_PTR GLST_Data, int flag)
{
	int i;		// [vp
	
	// Cg
	for(i=0;i<4;i++){
		if(flag & (1<<i)){		// tOĂ邩`FbN
			NNS_G3dGlbLightVector(i,
					GLST_Data->lightVec[i].x,
					GLST_Data->lightVec[i].y,
					GLST_Data->lightVec[i].z);
		}
		if(flag & (1<<(i+4))){	// tOĂ邩`FbN
			NNS_G3dGlbLightColor(i,
					GLST_Data->Color[i]);
		}
	}
	// }eA
	if(flag & (GLST_DIFF | GLST_AMB)){
		NNS_G3dGlbMaterialColorDiffAmb(
				GLST_Data->Diff,
				GLST_Data->Amb,
				GLST_Data->IsSetVtxColor);
	}
	if(flag & (GLST_SPEC | GLST_EMI)){
		NNS_G3dGlbMaterialColorSpecEmi(
				GLST_Data->Spec,
				GLST_Data->Emi,
				GLST_Data->IsShininess);
	}
	// |SAgr[g
	if(flag >= GLST_LIGHT_FLAG){
		NNS_G3dGlbPolygonAttr( GLST_Data->LightFlag,
				GLST_Data->polyMode,
				GLST_Data->cullMode,
				GLST_Data->polygonID,
				GLST_Data->alpha,
				GLST_Data->misc);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ݒf\[Xɐݒ
 *
 *@param	GLDT_Data	O[oȏ
 *@param	pMdl	f\[X
 *@param	flag	𔽉f̂
 *
 * CgiO`Rj̐ݒ͍sȂ̂ŒӂĂB
 * 
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void GLST_ReflectMdl(GLST_DATA_PTR GLST_Data, NNSG3dResMdl* pMdl, int flag)
{
	int i;		// [vp
	
	// }eA
	if(flag & GLST_DIFF){
		NNS_G3dMdlSetMdlDiffAll(pMdl, GLST_Data->Diff);
	}
	if(flag & GLST_AMB){
		NNS_G3dMdlSetMdlAmbAll(pMdl, GLST_Data->Amb);
	}
	if(flag & GLST_SPEC){
		NNS_G3dMdlSetMdlSpecAll(pMdl, GLST_Data->Spec);
	}
	if(flag & GLST_EMI){
		NNS_G3dMdlSetMdlEmiAll(pMdl, GLST_Data->Emi);
	}
	// |SAgr[g
	if(flag & GLST_LIGHT_FLAG){
		NNS_G3dMdlSetMdlLightEnableFlagAll(pMdl, GLST_Data->LightFlag);
	}
	if(flag & GLST_POLYGON_MODE){
		NNS_G3dMdlSetMdlPolygonModeAll(pMdl, GLST_Data->polyMode);
	}
	if(flag & GLST_CULL_MODE){
		NNS_G3dMdlSetMdlCullModeAll(pMdl, GLST_Data->cullMode);
	}
	if(flag & GLST_POLYGON_ID){
		NNS_G3dMdlSetMdlPolygonIDAll(pMdl, GLST_Data->polygonID);
	}
	if(flag & GLST_ALPHA){
		NNS_G3dMdlSetMdlAlphaAll(pMdl, GLST_Data->alpha);
	}
	if(flag & GLST_FOG){
		NNS_G3dMdlSetMdlFogEnableFlagAll(pMdl, GLST_Data->misc & GX_POLYGON_ATTR_MISC_FOG);
	}
	if(flag & GLST_DEPTH_TEST){
		NNS_G3dMdlSetMdlDepthTestCondAll(pMdl, GLST_Data->misc & GX_POLYGON_ATTR_MISC_DEPTHTEST_DECAL);
	}
	if(flag & GLST_1DOT){
		NNS_G3dMdlSetMdl1DotAll(pMdl, GLST_Data->misc & GX_POLYGON_ATTR_MISC_DISP_1DOT);
	}
	if(flag & GLST_FAR_CLIP){
		NNS_G3dMdlSetMdlFarClipAll(pMdl, GLST_Data->misc & GX_POLYGON_ATTR_MISC_FAR_CLIPPING);
	}
	if(flag & GLST_XLDEPTH_UPDATE){
		NNS_G3dMdlSetMdlXLDepthUpdateAll(pMdl, GLST_Data->misc & GX_POLYGON_ATTR_MISC_XLU_DEPTH_UPDATE);
	}
}

//-----------------------------------------------------------------------------
//
//	f[^̎擾֐S
//
//=============================================================================
//----------------------------------------------------------------------------
/**
 *
 *@brief	GXRgbԗΐɕ
 *
 *@param	GLDT_Data	O[oȏ
 *@param	rgb			f[^
 *@param	r,g,b		Fi[|C^
 *
 *@return none
 *
 */
//-----------------------------------------------------------------------------
void GLST_GetRGB(GXRgb dat, u8* r, u8* g, u8* b)
{
	*r = (dat >> 10)&0x1f;
	*g = (dat >> 5)&0x1f;
	*b = (dat >> 0)&0x1f;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	CgxNgf[^擾
 *
 *@param	GLST_Data	ۑ̈|C^
 *@param	lightID		擾郉CgID
 *
 *@return	VecFx16		xNgf[^
 *
 *
 */
//-----------------------------------------------------------------------------
VecFx16 GLST_GetLightVector(GLST_DATA_PTR GLST_Data, int lightID)
{
	return GLST_Data->lightVec[lightID];
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	CgJ[f[^擾
 *
 *@param	GLST_Data	ۑ̈|C^
 *@param	lightID		擾郉CgID
 *
 *@return	GXRgb	Ff[^
 *
 *
 */
//-----------------------------------------------------------------------------
GXRgb GLST_GetLightColor(GLST_DATA_PTR GLST_Data, int lightID)
{
	return GLST_Data->Color[lightID];
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	fBt[YF擾
 *
 *@param	GLST_Data	ۑ̈|C^
 *
 *@return	GXRgb	Ff[^	
 *
 *
 */
//-----------------------------------------------------------------------------
GXRgb GLST_GetMaterialDiff(GLST_DATA_PTR GLST_Data)
{
	return GLST_Data->Diff;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	fBt[YF𒸓_J[ɎgpĂ邩擾
 *
 *@param	GLST_Data	ۑ̈|C^
 *
 *@return	BOOL		gp:TRUE	sgp:FALSE
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL GLST_GetMaterialDiffVtxColor(GLST_DATA_PTR GLST_Data)
{
	return GLST_Data->IsSetVtxColor;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ArGgF擾
 *
 *@param	GLST_Data	ۑ̈|C^
 *
 *@return	GXRgb	Ff[^
 *
 *
 */
//-----------------------------------------------------------------------------
GXRgb GLST_GetMaterialAmb(GLST_DATA_PTR GLST_Data)
{
	return GLST_Data->Amb;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XyL[F擾
 *
 *@param	GLST_Data	ۑ̈|C^
 *
 *@return	GXRgb	Ff[^
 *
 *
 */
//-----------------------------------------------------------------------------
GXRgb GLST_GetMaterialSpec(GLST_DATA_PTR GLST_Data)
{
	return GLST_Data->Spec;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ʔˋPxe[ugp邩
 *
 *@param	GLST_Data	ۑ̈|C^
 *
 *@return	BOOL		gp:TRUE	sgp:FALSE
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL GLST_GetMaterialSpecShininess(GLST_DATA_PTR GLST_Data)
{
	return GLST_Data->IsShininess;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	G~bVF擾
 *
 *@param	GLST_Data	ۑ̈|C^
 *
 *@return	GXRgb	Ff[^
 *
 *
 */
//-----------------------------------------------------------------------------
GXRgb GLST_GetMaterialEmi(GLST_DATA_PTR GLST_Data)
{
	return GLST_Data->Emi;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ǂ̃Cg𔽉f邩ʂtO擾
 *
 *@param	GLST_Data	ۑ̈|C^
 *
 *@return	int	CgtO	(P`Srbg̃I/ItŃ`FbN)
 *
 *
 */
//-----------------------------------------------------------------------------
int GLST_GetMdlLightFlag(GLST_DATA_PTR GLST_Data)
{
	return GLST_Data->LightFlag;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	|S[h擾
 *
 *@param	GLST_Data		ۑ̈|C^
 *
 *@return	GXPolygonMode	|S[h
 *
 *
 */
//-----------------------------------------------------------------------------
GXPolygonMode GLST_GetMdlPolyMode(GLST_DATA_PTR GLST_Data)
{
	return GLST_Data->polyMode;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	JO[h擾
 *
 *@param	GLST_Data		ۑ̈|C^
 *
 *@return	GXCull			JO[h
 *
 *
 */
//-----------------------------------------------------------------------------
GXCull GLST_GetMdlCullMode(GLST_DATA_PTR GLST_Data)
{
	return GLST_Data->cullMode;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	|SID擾
 *
 *@param	GLST_Data		ۑ̈|C^
 *
 *@return	int				|SID
 *
 *
 */
//-----------------------------------------------------------------------------
int GLST_GetMdlPolyID(GLST_DATA_PTR GLST_Data)
{
	return GLST_Data->polygonID;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	l擾
 *
 *@param	GLST_Data		ۑ̈|C^
 *
 *@return	int				l
 *
 *
 */
//-----------------------------------------------------------------------------
int GLST_GetMdlAlpha(GLST_DATA_PTR GLST_Data)
{
	return GLST_Data->alpha;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	̑tO擾
 *
 *@param	GLST_Data		ۑ̈|C^
 *
 *@return	int				misc	̑̃tO
 *
 *
 */
//-----------------------------------------------------------------------------
int GLST_GetMdlMisc(GLST_DATA_PTR GLST_Data)
{
	return GLST_Data->misc;
}
//-----------------------------------------------------------------------------
//
//	f[^̐ݒ֐S
//
//=============================================================================
//----------------------------------------------------------------------------
/**
 *
 *@brief	CgxNgݒ	
 *
 *@param	GLDT_Data	O[oȏ
 *@param	lightID		Cgԍ	(0`3)
 *@param	x,y,z		xNg̒l
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void GLST_LightVector(GLST_DATA_PTR GLST_Data, int lightID, fx16 x, fx16 y, fx16 z)
{
	GLST_Data->lightVec[lightID].x = x;
	GLST_Data->lightVec[lightID].y = y;
	GLST_Data->lightVec[lightID].z = z;

	// f
	NNS_G3dGlbLightVector(lightID,
					GLST_Data->lightVec[lightID].x,
					GLST_Data->lightVec[lightID].y,
					GLST_Data->lightVec[lightID].z);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	CgJ[ݒ	
 *
 *@param	GLDT_Data	O[oȏ
 *@param	lightID		Cgԍ	(0`3)
 *@param	rgb			Cg̒l
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void GLST_LightColor(GLST_DATA_PTR GLST_Data, int lightID, GXRgb rgb)
{
	GLST_Data->Color[lightID] = rgb;
	
	// f
	NNS_G3dGlbLightColor(lightID,
			GLST_Data->Color[lightID]);
			
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	fBt[Yݒ	
 *
 *@param	GLDT_Data	O[oȏ
 *@param	rgb				F
 *@param	IsSetVtxColor	_J[ƂĂ悤邩
 *@param	setDiffAmb		f邩	TRUE:f
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void GLST_MaterialDiff(GLST_DATA_PTR GLST_Data, GXRgb rgb, BOOL IsSetVtxColor, BOOL setDiffAmb)
{
	GLST_Data->Diff=rgb;
	GLST_Data->IsSetVtxColor = IsSetVtxColor;

	if(setDiffAmb == TRUE){
		GLST_Reflect(GLST_Data, GLST_DIFF);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ArGgݒ	
 *
 *@param	GLDT_Data	O[oȏ
 *@param	rgb				F
 *@param	setDiffAmb		f邩	TRUE:f
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void GLST_MaterialAmb(GLST_DATA_PTR GLST_Data, GXRgb rgb, BOOL setDiffAmb)
{
	GLST_Data->Amb = rgb;

	if(setDiffAmb == TRUE){
		GLST_Reflect(GLST_Data, GLST_AMB);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	XyL[ݒ	
 *
 *@param	GLDT_Data	O[oȏ
 *@param	rgb				F
 *@param	IsShininess		ʔˋPxe[ũfBZ[u/Cl[utO
 *@param	setSpecEmi		f邩	TRUE:f
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void GLST_MaterialSpec(GLST_DATA_PTR GLST_Data, GXRgb rgb, BOOL IsShininess, BOOL setSpecEmi)
{
	GLST_Data->Spec = rgb;
	GLST_Data->IsShininess = IsShininess;

	if(setSpecEmi == TRUE){
		GLST_Reflect(GLST_Data, GLST_SPEC);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	G~bVݒ	
 *
 *@param	GLDT_Data	O[oȏ
 *@param	rgb				F
 *@param	setSpecEmi		f邩	TRUE:f
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void GLST_MaterialEmi(GLST_DATA_PTR GLST_Data, GXRgb rgb, BOOL setSpecEmi)
{
	GLST_Data->Emi = rgb;

	if(setSpecEmi == TRUE){
		GLST_Reflect(GLST_Data, GLST_EMI);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	CgtOݒ	
 *
 *@param	GLDT_Data	O[oȏ
 *@param	light			ǂ̃Cg̐ݒ肩
 *@param	on_off			Cg_:TRUE	Cg:FALSE
 *@param	setPolyAttr		f邩	TRUE:f
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void GLST_MdlLightFlag(GLST_DATA_PTR GLST_Data, int light, BOOL on_off, BOOL setPolyAttr)
{
	if(on_off == TRUE){
		if(GLST_Data->LightFlag & light){
			return;
		}
	}else{
		if(!(GLST_Data->LightFlag & light)){
			return;
		}
	}
	
	GLST_Data->LightFlag ^= light;

	if(setPolyAttr == TRUE){
		GLST_Reflect(GLST_Data, GLST_LIGHT_FLAG);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	|S[hݒ	
 *
 *@param	GLDT_Data	O[oȏ
 *@param	polyMode		|S[h
 *@param	setPolyAttr		f邩	TRUE:f
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void GLST_MdlPolyMode(GLST_DATA_PTR GLST_Data, GXPolygonMode polyMode, BOOL setPolyAttr)
{
	GLST_Data->polyMode = polyMode;

	if(setPolyAttr == TRUE){
		GLST_Reflect(GLST_Data, GLST_POLYGON_MODE);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	JO[hݒ	
 *
 *@param	GLDT_Data	O[oȏ
 *@param	cullMode		JO[h
 *@param	setPolyAttr		f邩	TRUE:f
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void GLST_MdlCullMode(GLST_DATA_PTR GLST_Data, GXCull cullMode, BOOL setPolyAttr)
{
	GLST_Data->cullMode = cullMode;

	if(setPolyAttr == TRUE){
		GLST_Reflect(GLST_Data, GLST_CULL_MODE);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	|SIDݒ	
 *
 *@param	GLDT_Data	O[oȏ
 *@param	polygonID		|SID
 *@param	setPolyAttr		f邩	TRUE:f
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void GLST_MdlPolyID(GLST_DATA_PTR GLST_Data, int polygonID, BOOL setPolyAttr)
{
	GLST_Data->polygonID = polygonID;

	if(setPolyAttr == TRUE){
		GLST_Reflect(GLST_Data, GLST_POLYGON_ID);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	At@ݒ	
 *
 *@param	GLDT_Data	O[oȏ
 *@param	alpha			l
 *@param	setPolyAttr		f邩	TRUE:f
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void GLST_MdlAlpha(GLST_DATA_PTR GLST_Data, int alpha, BOOL setPolyAttr)
{
	GLST_Data->alpha = alpha;

	if(setPolyAttr == TRUE){
		GLST_Reflect(GLST_Data, GLST_ALPHA);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	̑̃tOݒ	
 *
 *@param	GLDT_Data	O[oȏ
 *@param	flag			tO̒lietO̘_aj
 *@param	on_off			tO𗧂Ă̂(TRUE)A낷̂(FALSE)
 *@param	setPolyAttr		f邩	TRUE:f
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void GLST_MdlMisc(GLST_DATA_PTR GLST_Data, int flag, BOOL on_off, BOOL setPolyAttr)
{
	if(on_off == TRUE){
		if(GLST_Data->misc & flag){
			return;
		}
	}else{
		if(!(GLST_Data->misc & flag)){
			return;
		}
	}

	GLST_Data->misc ^= flag;

	if(setPolyAttr == TRUE){
		GLST_Reflect(GLST_Data, GLST_LIGHT_FLAG);
	}
}
