//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		field_hblank.c
 *	@brief		tB[hHBlankVXe
 *	@author		tomoya takahashi
 *	@data		2006.04.10
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include <string.h>

#define	__FIELD_HBLANK_H_GLOBAL
#include "field_hblank.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//
//	HuNԓɓ삷IuWFNg
//
//=====================================
#define FIELD_HBLANK_WORK_NUM	 ( 2 )

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	HuNԃ[N
//=====================================
typedef struct _FIELD_HBLANK_OBJ{
	u32	status;
	void* p_work;
	FLDHBLANK_FUNC func;
};

//-------------------------------------
//	HuNԊǗVXe
//=====================================
typedef struct _FIELD_HBLANK_SYS{
	u32	status;
	FIELD_HBLANK_OBJ work[ FIELD_HBLANK_WORK_NUM ];
} ;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void FldHblank_InitSys( FIELD_HBLANK_SYS* p_sys );
static void FldHblank_InitObj( FIELD_HBLANK_OBJ* p_obj );
static void Field_Sys_HBlank( void* p_work );
static void Field_Sys_DummyCallBack( FIELD_HBLANK_OBJ* p_obj, void* p_work );

static FIELD_HBLANK_OBJ* FldHblank_GetCleanObj( FIELD_HBLANK_SYS* p_sys );

//----------------------------------------------------------------------------
/**
 *	@brief	yǗVXez֐
 *	@param	heap 
 *	@return	쐬yǗVXez
 */
//-----------------------------------------------------------------------------
FIELD_HBLANK_SYS* FLDHBLANK_SYS_Init( u32 heap )
{
	FIELD_HBLANK_SYS* p_sys;

	// m
	p_sys = sys_AllocMemory( heap, sizeof(FIELD_HBLANK_SYS) );
	FldHblank_InitSys( p_sys );

	return p_sys;
}

//----------------------------------------------------------------------------
/**
 *	@brief	yǗVXezj
 *	@param	p_sys	yǗVXez
 */
//-----------------------------------------------------------------------------
void FLDHBLANK_SYS_Delete( FIELD_HBLANK_SYS* p_sys )
{
	if( p_sys == NULL ){ return ; }
	
	// HBlank荞݂̉
	if( p_sys->status == FIELD_HBLANK_STATE_DO ){
		FLDHBLANK_SYS_Stop( p_sys );
	}

	// Ǘf[^N[
	FldHblank_InitSys( p_sys );
	
	// S̃[Nj
	sys_FreeMemoryEz( p_sys );
}

//----------------------------------------------------------------------------
/**
 *	@brief	yǗVXezHBlank	X^[g@HBLANK荞ݐݒ
 *	@param	p_sys	yǗVXez
 */
//-----------------------------------------------------------------------------
void FLDHBLANK_SYS_Start( FIELD_HBLANK_SYS* p_sys )
{
	BOOL result;
	result = sys_HBlankIntrSet( Field_Sys_HBlank, p_sys );
	// ݒ莸s
	GF_ASSERT( result == TRUE );

	p_sys->status = FIELD_HBLANK_STATE_DO;
}

//----------------------------------------------------------------------------
/**
 *	@brief	yǗVXezHBlankI	HBLANK荞݂̉
 *	@param	p_sys	yǗVXez
 */
//-----------------------------------------------------------------------------
void FLDHBLANK_SYS_Stop( FIELD_HBLANK_SYS* p_sys )
{
	BOOL result;
	result = sys_HBlankIntrSet( NULL, NULL );
	// ݒ莸s
	GF_ASSERT( result == TRUE );

	p_sys->status = FIELD_HBLANK_STATE_STANDBY;
}

//----------------------------------------------------------------------------
/**
 *	@brief	yǗVXez̏Ԃ擾
 *	@param	cp_sys	yǗVXez
 *
 *	@return	FIELD_HBLANK_STATE_STANDBY	Jn҂
 *	@return	FIELD_HBLANK_STATE_DO		s
 */
//-----------------------------------------------------------------------------
u32 FLDHBLANK_SYS_GetState( const FIELD_HBLANK_SYS* cp_sys )
{
	return cp_sys->status;
}

//-----------------------------------------------------------------------------
/**
 *					yIuWFNgzvg^Cv錾
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	yIuWFNgzo^
 *	@param	p_sys		yǗVXez
 *	@param	func		R[obN֐
 *	@param	p_work		[N
 *
 *	@return	쐬ꂽyIuWFNgz	NULL̎siő吔o^ς݁j
 */
//-----------------------------------------------------------------------------
FIELD_HBLANK_OBJ* FLDHBLANK_OBJ_Add( FIELD_HBLANK_SYS* p_sys, FLDHBLANK_FUNC func, void* p_work )
{
	FIELD_HBLANK_OBJ* p_obj;
	p_obj = FldHblank_GetCleanObj( p_sys );
	// o^s@@ő吔𒴂o^悤Ƃ܂
	GF_ASSERT( p_obj );
	if( p_obj ){
		p_obj->p_work	= p_work;
		p_obj->func		= func;
		p_obj->status	= FIELD_HBLANK_STATE_DO;
	}
	return p_obj;
}

//----------------------------------------------------------------------------
/**
 *	@brief	yIuWFNgzj
 *	@param	p_obj	yIuWFNgz
 */
//-----------------------------------------------------------------------------
void FLDHBLANK_OBJ_Delete( FIELD_HBLANK_OBJ* p_obj )
{
	FldHblank_InitObj( p_obj );
}



//-----------------------------------------------------------------------------
/**
 *		[J֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	VXe[N
 *	@param	p_sys	ǗVXe
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FldHblank_InitSys( FIELD_HBLANK_SYS* p_sys )
{
	int i;
	memset( p_sys, 0, sizeof(FIELD_HBLANK_SYS) );
	p_sys->status = FIELD_HBLANK_STATE_STANDBY;
	for( i=0; i<FIELD_HBLANK_WORK_NUM; i++ ){
		FldHblank_InitObj( &p_sys->work[i] );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	IuWFNg[N
 *	@param	p_obj	IuWFNg
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void FldHblank_InitObj( FIELD_HBLANK_OBJ* p_obj )
{
	// ̏sĂƂHuNԂ邱Ƃl
	// [N̏ԉɂ
	p_obj->status = FIELD_HBLANK_STATE_STANDBY;
	p_obj->func	  = Field_Sys_DummyCallBack;
	p_obj->p_work = NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief	HuN֐
 *	@param	p_work	[N
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void Field_Sys_HBlank( void* p_work )
{
	int i;
	FIELD_HBLANK_SYS* p_sys = p_work;

	for( i=0; i<FIELD_HBLANK_WORK_NUM; i++ ){
		p_sys->work[i].func( &p_sys->work[i], p_sys->work[i].p_work );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	R[obN֐p@_~[R[obN
 *	@param	p_obj		IuWF
 *	@param	p_work		[N
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void Field_Sys_DummyCallBack( FIELD_HBLANK_OBJ* p_obj, void* p_work )
{
}

//----------------------------------------------------------------------------
/**
 *	@brief	󂢂ĂIuWFNg[N擾
 *
 *	@param	p_sys	VXe[N
 *
 *	@return	IuWFNg[N	NULL@ő吔gp
 */
//-----------------------------------------------------------------------------
static FIELD_HBLANK_OBJ* FldHblank_GetCleanObj( FIELD_HBLANK_SYS* p_sys )
{
	int i;
	for( i=0; i<FIELD_HBLANK_WORK_NUM; i++ ){
		if( p_sys->work[i].status == FIELD_HBLANK_STATE_STANDBY ){
			return &p_sys->work[i];
		}
	}
	return NULL;
}

