//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		field_light.c
 *@brief	CgRg[
 *@author	tomoya takahashi
 *@data		2005.04.01
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include "common.h"
#define __LIGHT_CONT_H_GLOBAL
#include "field_light.h"
#include "field_glb_state.h"

#include "system/pm_rtc.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
 */
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
 */
//-----------------------------------------------------------------------------

//-------------------------------------
//	
//	P\Zbg	
//	
//=====================================
typedef struct _LIGHT_CONT_SET{
	u32		DataNum;				// f[^
	LIGHT_CONT_DATA* pDataTbl;		// f[^e[u
	int Light_Num;					// LIGHTio[
	GLST_DATA_PTR	Glb;			// O[oXe[g̏ԕۑ̈
	BOOL reflect;					// ftO	TRUEf
} LIGHT_CONT_SET;


//----------------------------------------------------------------------------
/**
 *					vg^Cv錾
 */
//-----------------------------------------------------------------------------
static void DataSetLightContPack(LIGHT_CONT_SET* cont);			// ̃Cgf[^𔽉f

static u32 loadLightData( const char* str, LIGHT_CONT_DATA** ppData );			// Cgf[^ǂݍ
static void dellLightData(LIGHT_CONT_DATA** ppData);						// Cgf[^j
static char* GetLightData( char* buff, GXRgb* Color, VecFx16* Vector );		// lightf[^擾
static char* GetRgbData( char* buff, GXRgb* Color );						// Ff[^擾
//----------------------------------------------------------------------------
/**
 *					O[oϐ錾
 */
//-----------------------------------------------------------------------------
//A[JCusv
static const char *const Path[ LIGHT_TYPE_MAX ] =
{
	{"data/area00light.txt"},
	{"data/area01light.txt"},
	{"data/area02light.txt"},
};

//----------------------------------------------------------------------------
/**
 *
 *@brief	CgVXe
 *		
 *@param	glb			O[oXe[g̏ԕۑ̈
 *@param	path		Cge[upX
 *
 *@return	LIGHT_CONT_PTR	쐬CgVXef[^
 *
 */
//-----------------------------------------------------------------------------
LIGHT_CONT_PTR InitLightCont(GLST_DATA_PTR glb, const u8 light_index/*const char* path*/)
{
	int		i;	// [vp
	LIGHT_CONT_PTR data;
	int light_movecount;
	
	GF_ASSERT(light_index<LIGHT_TYPE_MAX && "CgCfbNXI[o[");

	data = sys_AllocMemory(HEAPID_FIELD, sizeof(LIGHT_CONT_SET));
	
	data->Glb = glb;		// O[oXe[g̏ԕۑ̈ۑ
#ifdef DEBUG_ONLY_FOR_saitou
	OS_Printf("local_print light = %s\n",Path[light_index]);
#endif	
	// ǂݍ
	data->DataNum = loadLightData(Path[light_index], &data->pDataTbl);
	data->Light_Num = 0;

	// RTC猻ݎԂ̎擾Ȃ܂B
	light_movecount = GF_RTC_GetTimeBySecond() / 2;

	// ̎Ԃ͂ǂ̃Cg`FbN
	// ͎Ԃe[u𓮂lē܂B
	for(i = 0;i < data->DataNum; i++){
		if(data->pDataTbl[i].lightEnd > light_movecount){
			data->Light_Num = i;				// Cgݒ
			break;
		}
	}

	// f
	data->reflect = TRUE;

	DataSetLightContPack(data);

	return data;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	CgRg[VXej
 *
 *@param	pLight		CgVXef[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void DellLightCont( LIGHT_CONT_PTR* pLight )
{
	GF_ASSERT(pLight);
	
	dellLightData(&(*pLight)->pDataTbl);	// f[^j
	
	sys_FreeMemory(HEAPID_FIELD, *pLight);
	*pLight = NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Cgf[^𓮂
 *
 *@param	Light		CgRg[f[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void MainLightCont(LIGHT_CONT_PTR Light)
{
	u32 num;
	int i;		// [vp
	int light_min;	// ̃e[ũCgJE^ŏ
	int light_max;	// ̃e[ũCgJE^ő
	int light_movecount;
	
	GF_ASSERT(Light);
	
	// RTC猻ݎԂ̎擾Ȃ܂B
	light_movecount = GF_RTC_GetTimeBySecond() / 2;

	// Cge[uPȂύX͂Ȃ
	if( Light->DataNum > 1 ){

		// ̃Cge[u̍ŏJEgl@őJEglݒ
		if( (Light->Light_Num - 1) >= 0 ){
			light_min = Light->pDataTbl[ Light->Light_Num - 1 ].lightEnd;
		}else{
			light_min = 0;
			
		}
		light_max = Light->pDataTbl[ Light->Light_Num ].lightEnd;

	
		// JE^̃^C~OɂȂ
		// f\̂ύX
		if( ( light_movecount >= light_max ) ||		// JEgl͈͊ÔƂLight_NumJEgAbv
			( light_movecount < light_min ) ){		// JEgl͈͓̃e[uT

			Light->Light_Num++;	// ݒ肷f[^̃io[擾
			if( Light->Light_Num >= Light->DataNum ){	// f[^ȏɂȂJE^
				Light->Light_Num = 0;
			}

			if( Light->reflect ){
				DataSetLightContPack(Light);
			}
		}
	}

}

//----------------------------------------------------------------------------
/**
 *	@brief	Cgf[^ftOݒ
 *
 *	@param	Light		Cg[N
 *	@param	reflect		ftO
 *	
 *	@return	none
 *	reflect 
 *		TRUE	f
 *		FALSE	fȂ
 */
//-----------------------------------------------------------------------------
void SetLightContReflect( LIGHT_CONT_PTR Light, BOOL reflect )
{
	Light->reflect = reflect;

	// fɂꍇ̎_ŁA1xf[^ݒ肷
	if( Light->reflect ){
		DataSetLightContPack(Light);
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	Cgf[^ftOԎ擾
 *
 *	@param	Light	CgRg[
 *
 *	@retval	TRUE	f
 *	@retval	FALSE	fĂȂ
 */
//-----------------------------------------------------------------------------
BOOL GetLightContReflect( CONST_LIGHT_CONT_PTR Light )
{
	return Light->reflect;
}

//----------------------------------------------------------------------------
/**
 *	@brief	1Cgf[^ݒ
 *
 *	@param	move	[N
 *	@param	pGlst	O[oXe[gf[^
 *	
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
void DataSetLightCont( const LIGHT_CONT_DATA* move, GLST_DATA_PTR pGlst )
{
	int i;		// [vp
	
	// Cgݒ
	for(i=0;i<4;i++){
		int check = 	(1<<i);
		if((move->lightFlag & check) != 0){
			GLST_LightVector(pGlst, i, move->lightVec[i].x, move->lightVec[i].y, move->lightVec[i].z);
			GLST_LightColor(pGlst, i,move->lightColor[i]);
		}else{
			GLST_LightVector(pGlst, i, 0, 0, 0);
			GLST_LightColor(pGlst, i,GX_RGB(0,0,0));		// Cg
		}
	}
	// fBt[YAArGgAXyL[Aˌ
	GLST_MaterialDiff(pGlst, move->diffuse,FALSE,FALSE);
	GLST_MaterialAmb(pGlst, move->ambient,TRUE);
	GLST_MaterialSpec(pGlst, move->specular,FALSE,FALSE);
	GLST_MaterialEmi(pGlst, move->emission,TRUE);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	̃Cgf[^𔽉f
 *
 *@param	cont		CgRg[Zbg	
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void DataSetLightContPack(LIGHT_CONT_SET* cont)
{
	LIGHT_CONT_DATA* move = &cont->pDataTbl[cont->Light_Num];
	
	DataSetLightCont( move, cont->Glb );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	邩`FbN
 *
 *	@param	cont	CgRg[VXe
 *
 *	@retval	TRUE	
 *	@retval	FALSE	
 *
 *
 */
//-----------------------------------------------------------------------------
//BOOL GetLightNight( LIGHT_CONT_SET* cont )
BOOL GetLightNight( void )
{
	int light_movecount;
	light_movecount = GF_RTC_GetTimeBySecond() / 2;
	
//	if( (cont->Light_Num >= 12) || (cont->Light_Num <= 2) ){
	if( (light_movecount >= 34200) || (light_movecount < 7200) ){
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	fCgA}eÃf[^̓O[oXe[g
 *			gp悤ɕύX
 *
 *@param	Mdl		Zbg郂f
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void SetGlbLightMdl(NNSG3dResMdl* Mdl)
{
	// CgA}eA̓O[oXe[g̒lgp
	NNS_G3dMdlUseGlbDiff(Mdl);				// fBt[Y
	NNS_G3dMdlUseGlbAmb(Mdl);				// ArGg
	NNS_G3dMdlUseGlbSpec(Mdl);				// XyL[
	NNS_G3dMdlUseGlbEmi(Mdl);				// G~bV
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	fCgA}eÃf[^̓O[oXe[g
 *			gpȂ悤ɕύX
 *
 *@param	Mdl		Zbg郂f
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void RemGlbLightMdl(NNSG3dResMdl* Mdl)
{
	// CgA}eA̓flgp
	NNS_G3dMdlUseMdlDiff(Mdl);				// fBt[Y
	NNS_G3dMdlUseMdlAmb(Mdl);				// ArGg
	NNS_G3dMdlUseMdlSpec(Mdl);				// XyL[
	NNS_G3dMdlUseMdlEmi(Mdl);				// G~bV
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	Cgf[^ǂݍ
 *
 *@param	str		t@CpX
 *@param	ppData	i[
 *
 *@return	Cgf[^
 *
 *
 */
//-----------------------------------------------------------------------------
static u32 loadLightData( const char* str, LIGHT_CONT_DATA** ppData )
{
	int   i,j;			// [vp
	int	  data_num;		// f[^
	void* filep;		// t@C|C^
	void* tmp;			// 폜pt@C|C^ۑ
	char  buff[256];	// ǂݍ݂悤
	char* buff_work;	// obt@p
	char r_b[256];		// [JƗpobt@
	LIGHT_CONT_DATA* pDataWork;	// i[Ɨp

	
	tmp = sys_LoadFile(HEAPID_FIELD,str);		// t@CI[v
	filep = tmp;				// Ɨpϐɑ
	
	data_num = 0;
	do
	{
		filep = StrTok(filep,buff,RETURN_CODE);
		if(!((buff[0] == 'E') &&
		   (buff[1] == 'O') &&
		   (buff[2] == 'F'))){
			
			filep = StrTok(filep,buff,RETURN_CODE);
			filep = StrTok(filep,buff,RETURN_CODE);
			filep = StrTok(filep,buff,RETURN_CODE);
			filep = StrTok(filep,buff,RETURN_CODE);
			filep = StrTok(filep,buff,RETURN_CODE);
			filep = StrTok(filep,buff,RETURN_CODE);
			filep = StrTok(filep,buff,RETURN_CODE);
			filep = StrTok(filep,buff,RETURN_CODE);
			filep = StrTok(filep,buff,RETURN_CODE);
			data_num++;
		}
	}while(!((buff[0] == 'E') &&
		   (buff[1] == 'O') &&
		   (buff[2] == 'F')));

	// f[^̗̈m
	*ppData = sys_AllocMemory(HEAPID_FIELD, sizeof(LIGHT_CONT_DATA)*data_num);
	MI_CpuClear8(*ppData, sizeof(LIGHT_CONT_DATA)*data_num);

	// f[^i[
	filep = tmp;
	for(i=0;i<data_num;i++){

		// i[Zbg
		pDataWork = &((*ppData)[i]);

		// ^C~O
		filep = StrTok(filep,buff,RETURN_CODE);
		buff_work = buff;
		buff_work = StrTok(buff_work,r_b,',');
		pDataWork->lightEnd = AtoI(r_b);
		
		// light
		for(j=0;j<4;j++){
			// lightf[^擾
			filep = GetLightData(filep, &pDataWork->lightColor[j], &pDataWork->lightVec[j]);
			if(pDataWork->lightColor[j] != 0xffff){		// lightgp̂`FbN
				pDataWork->lightFlag |= 1 << j;
			}else{
				pDataWork->lightColor[j] = 0;
			}
		}

		// F
		filep = GetRgbData(filep, &pDataWork->diffuse);	// fBt[Y
		filep = GetRgbData(filep, &pDataWork->ambient);	// ArGg
		filep = GetRgbData(filep, &pDataWork->specular);	// XyL[
		filep = GetRgbData(filep, &pDataWork->emission);	// G~bV	


		// s
		filep = StrTok(filep,buff,RETURN_CODE);
	}

	sys_FreeMemory(HEAPID_FIELD,tmp);		// t@Cj

	return data_num;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Cgf[^j
 *
 *@param	str		t@CpX
 *@param	ppData	i[
 *
 *@return	Cgf[^
 *
 *
 */
//-----------------------------------------------------------------------------
static void dellLightData(LIGHT_CONT_DATA** ppData)
{
	sys_FreeMemory(HEAPID_FIELD, *ppData);
	*ppData = NULL;
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	eCgf[^ǂݍ
 *
 *@param	buff		ǂݍݐ
 *@param	Color		Cg̐Fݐ
 *@param	Vector		Cg̃xNgݐ
 *
 *@return	̓Ǎ
 *
 *
 */
//-----------------------------------------------------------------------------
static char* GetLightData( char* buff, GXRgb* Color, VecFx16* Vector )		// lightf[^擾
{
	char work[256];			// ǂݍ݂悤
	char work2[256];		// ؂p
	char* data_work;		// f[^[N
	u32	flag;				// lightL`FbNp
	int	i;					// [vp
	u16	rgb[3];				// Fi[p
	s32	vec[3];				// Wi[p
 
	
	// light
	buff = StrTok(buff,work,RETURN_CODE);
	data_work = work;
	data_work = StrTok(data_work,work2,',');
	flag = AtoI(work2);
	if(flag == 1){
		// F
		for(i=0;i<3;i++){
			data_work = StrTok(data_work,work2,',');
			rgb[i] = AtoI(work2);
		}

		// Fݒ
		*Color = GX_RGB(rgb[0],rgb[1],rgb[2]);
		
		// xNg
		for(i=0;i<3;i++){
			data_work = StrTok(data_work,work2,',');
			vec[i] = AtoI(work2);
		}

		// xNgݒ
		Vector->x = vec[0];
		Vector->y = vec[1];
		Vector->z = vec[2];

		if(Vector->x > FX16_ONE){
			Vector->x = FX16_ONE;
		}
		if(Vector->x < -FX16_ONE){
			Vector->x = -FX16_ONE;
		}
		if(Vector->y > FX16_ONE){
			Vector->y = FX16_ONE;
		}
		if(Vector->y < -FX16_ONE){
			Vector->y = -FX16_ONE;
		}
		if(Vector->z > FX16_ONE){
			Vector->z = FX16_ONE;
		}
		if(Vector->z < -FX16_ONE){
			Vector->z = -FX16_ONE;
		}
		
	}else{

		// _~[f[^Zbg
		*Color = 0xffff;
	}

	return buff;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	eFf[^ǂݍ
 *
 *@param	buff		ǂݍݐ
 *@param	Color		Cg̐Fݐ
 *
 *@return	̓Ǎ
 *
 *
 */
//-----------------------------------------------------------------------------
static char* GetRgbData( char* buff, GXRgb* Color )
{
	char work[256];			// ǂݍ݂悤
	char work2[256];		// ؂p
	char* data_work;		// Ɨp
	int i;
	u16	rgb[3];				// Fi[p
	
	buff = StrTok(buff,work,RETURN_CODE);
	data_work = work;
	
	// F
	for(i=0;i<3;i++){
		data_work = StrTok(data_work,work2,',');
		rgb[i] = AtoI(work2);
	}

	// Fݒ
	*Color = GX_RGB(rgb[0],rgb[1],rgb[2]);

	return buff;
}
