//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		field_trade.c
 *	@brief		Q[
 *	@author		tomoya takahashi
 *	@data		2006.05.15
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "common.h"
#include "system/arc_util.h"
#include "include/msgdata/msg_fld_trade.h"
#include "include/msgdata/msg.naix"
#include "include/gflib/strbuf_family.h"
#include "fieldsys.h"
#include "field_event.h"
#include "ev_mapchange.h"
#include "ev_time.h"
#include "savedata/zukanwork.h"
#include "savedata/get_poke.h"
#include "include/poketool/poke_memo.h"
#include "zonedata.h"

#define  __FIELD_TRADE_H_GLOBAL
#include "field_trade.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define FLD_TRADE_GET_POKE_GMM(x)	(x)
#define FLD_TRADE_GET_OYA_GMM(x)	(TRADE_OYA_00+x)


//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	|Pf[^
//=====================================
typedef struct {
	u32 monsno;			// X^[io[
	u32 hp_rnd;			// HP
	u32 at_rnd;			// U
	u32 df_rnd;			// h䗐
	u32 sp_rnd;			// 
	u32 sa_rnd;			// U
	u32 sd_rnd;			// h
	u32 speabino;		// \
	u32	mons_id;		// ID
	u32 style;			// 悳
	u32 beautiful;		// 
	u32 cute;			// 킢
	u32 clever;			// 
	u32 strong;			// ܂
	u32 mons_rnd;		// ő̗
	u32 item;			// ACe
	u32 oya_sex;		// e
	u32 fur;			// щ
	u32 world_code;		// e̍R[h
	u32 change_monsno;	// 郂X^[io[
} FLD_TRADE_POKEDATA;


typedef struct _FLD_TRADE_WORK {
	FLD_TRADE_POKEDATA* p_pokedata;		// |Pf[^

	POKEMON_PARAM*		p_pp;			// |P
	MYSTATUS*			p_myste;		// p[^
	u32 trade_no;						// io[
	u32 heapID;
};

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static STRBUF* FLD_TradeGetGmm( u32 heapID, u32 idx );
static void FLD_TradeSetPokeParam( POKEMON_PARAM* p_pp, FLD_TRADE_POKEDATA* p_data, u32 lev, u32 trade_no, u32 heapID, u32 zone_id );



//----------------------------------------------------------------------------
/**
 *	@brief	[Nm
 *
 *	@param	heapID		q[vID
 *	@param	trade_no	ԍ
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
FLD_TRADE_WORK* FLD_TradeAlloc( u32 heapID, u32 trade_no )
{
	FLD_TRADE_WORK* p_work;
	STRBUF* str;
	STRCODE str_arry[ 128 ];

	GF_ASSERT( trade_no < FLD_TRADE_NUM );
	
	p_work = sys_AllocMemory( heapID, sizeof(FLD_TRADE_WORK) );
	memset( p_work, 0, sizeof(FLD_TRADE_WORK) );

	// f[^ǂݍ
	p_work->p_pokedata = ArcUtil_Load( ARC_FIELD_TRADE_POKE, trade_no, FALSE, heapID, ALLOC_TOP );

	
	p_work->heapID = heapID;
	p_work->trade_no = trade_no;

	// |Pf[^쐬
	p_work->p_pp = PokemonParam_AllocWork( heapID );

	// ef[^쐬
	p_work->p_myste = MyStatus_AllocWork( heapID );
	MyStatus_Init( p_work->p_myste );
	str = FLD_TradeGetGmm( heapID, FLD_TRADE_GET_OYA_GMM( trade_no ) );
	STRBUF_GetStringCode( str, str_arry, 128 );
	STRBUF_Delete(str);
	MyStatus_SetMyName( p_work->p_myste, str_arry );
	MyStatus_SetMySex( p_work->p_myste, p_work->p_pokedata->oya_sex );
	
	return p_work;
}

//----------------------------------------------------------------------------
/**
 *	@brief	[Nj
 *
 *	@param	p_work		
 */
//-----------------------------------------------------------------------------
void FLD_TradeDelete( FLD_TRADE_WORK* p_work )
{
	sys_FreeMemoryEz( p_work->p_pokedata );
	sys_FreeMemoryEz( p_work->p_pp );
	sys_FreeMemoryEz( p_work->p_myste );
	sys_FreeMemoryEz( p_work );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pio[擾
 *
 *	@param	cp_work		[N
 *
 *	@return	|Pio[
 */
//-----------------------------------------------------------------------------
u32 FLD_TradeMonsno( const FLD_TRADE_WORK* cp_work )
{
	return cp_work->p_pokedata->monsno;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ɕKvȃ|Pio[擾
 *
 *	@param	cp_work		[N
 *
 *	@return	|Pio[
 */
//-----------------------------------------------------------------------------
u32 FLD_TradeChangeMonsno( const FLD_TRADE_WORK* cp_work )
{
	return cp_work->p_pokedata->change_monsno;
}

//----------------------------------------------------------------------------
/**
 *	@brief	eʁ@擾
 *
 *	@param	cp_work		[N
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
u32 FLD_TradeOyaSex( const FLD_TRADE_WORK* cp_work )
{
	return cp_work->p_pokedata->oya_sex;
}

//----------------------------------------------------------------------------
/**
 *	@brief	
 *
 *	@param	p_fsys		tB[hVXe
 *	@param	p_work		[N
 *	@param	party_pos	p[eB[|WV
 */
//-----------------------------------------------------------------------------
void FLD_Trade( FIELDSYS_WORK * p_fsys, FLD_TRADE_WORK* p_work, int party_pos )
{
	POKEPARTY * party = SaveData_GetTemotiPokemon( p_fsys->savedata );

	// s
	PokeParty_SetMemberData( party, party_pos, p_work->p_pp );

	// }ӂɓo^
	SaveData_GetPokeRegister( p_fsys->savedata, p_work->p_pp );
}

void FLD_TradeDemoDataMake( FIELDSYS_WORK * p_fsys, FLD_TRADE_WORK* p_work, int party_pos, DEMO_TRADE_PARAM* p_demo, POKEMON_PARAM* sendPoke, POKEMON_PARAM* recvPoke )
{
	POKEPARTY * party = SaveData_GetTemotiPokemon( p_fsys->savedata );
	POKEMON_PARAM* p_chg_poke;
	STRBUF* str;
	u32 lev;		// x
	int time_zone;

	// |P
	p_chg_poke = PokeParty_GetMemberPointer( party, party_pos );
	lev = PokeParaGet( p_chg_poke, ID_PARA_level, NULL );
	
	// |P̍쐬
	FLD_TradeSetPokeParam( p_work->p_pp, p_work->p_pokedata, lev, p_work->trade_no, p_work->heapID, p_fsys->location->zone_id );

	// fp̃|Pp[^Ɋi[
	PokeCopyPPtoPP( p_chg_poke, sendPoke );
	PokeCopyPPtoPP( p_work->p_pp, recvPoke );

	// ff[^쐬
	p_demo->sendPoke	= PPPPointerGet( sendPoke );
	p_demo->recvPoke	= PPPPointerGet( recvPoke );
	p_demo->partner	= p_work->p_myste;
	p_demo->seqFlag	= DEMO_TRADE_SEQ_FULL;
	p_demo->config		= SaveData_GetConfig( p_fsys->savedata );
	time_zone = EVTIME_GetTimeZone( p_fsys );
	if( (time_zone == TIMEZONE_MORNING) || 
		(time_zone == TIMEZONE_NOON) ){
		p_demo->bgType		= DEMO_TRADE_BGTYPE_MORNING;
	}else if( time_zone == TIMEZONE_EVENING ){
		p_demo->bgType		= DEMO_TRADE_BGTYPE_EVENING;
	}else{
		p_demo->bgType		= DEMO_TRADE_BGTYPE_NIGHT;
	}
}




//----------------------------------------------------------------------------
/**
 *	@brief	bZ[W擾
 *	jKv
 */
//-----------------------------------------------------------------------------
static STRBUF* FLD_TradeGetGmm( u32 heapID, u32 idx )
{
	STRBUF* str;
	
	MSGDATA_MANAGER* msg_data = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_fld_trade_dat, heapID);
	str = MSGMAN_AllocString(msg_data, idx);
	MSGMAN_Delete(msg_data);
	return str;
}


//----------------------------------------------------------------------------
/**
 *	@brief	|PpɃf[^̐ݒ
 *
 *	@param	p_pp		|Pp
 *	@param	p_data		f[^
 *	@param	lev			x
 *	@param	trade_no	tradeio[
 */
//-----------------------------------------------------------------------------
static void FLD_TradeSetPokeParam( POKEMON_PARAM* p_pp, FLD_TRADE_POKEDATA* p_data, u32 lev, u32 trade_no, u32 heapID, u32 zone_id )
{
	STRBUF* str;
	u8 nickname_flg;
	u32 placeid;

	
	// X^[io[@x@ő̗@IDݒ
	PokeParaSet( p_pp, 
			p_data->monsno,
			lev, POW_RND, 
			RND_SET, p_data->mons_rnd,
			ID_SET, p_data->mons_id );

	// jbNl[
	str = FLD_TradeGetGmm( heapID, FLD_TRADE_GET_POKE_GMM(trade_no) );
	PokeParaPut( p_pp, ID_PARA_nickname_buf, str );
	STRBUF_Delete(str);

	// jbNl[tO
	nickname_flg = 1;
	PokeParaPut( p_pp, ID_PARA_nickname_flag, &nickname_flg );

	// e헐ݒ
	PokeParaPut( p_pp, ID_PARA_hp_rnd, &p_data->hp_rnd );
	PokeParaPut( p_pp, ID_PARA_pow_rnd, &p_data->at_rnd );
	PokeParaPut( p_pp, ID_PARA_def_rnd, &p_data->df_rnd );
	PokeParaPut( p_pp, ID_PARA_agi_rnd, &p_data->sp_rnd );
	PokeParaPut( p_pp, ID_PARA_spepow_rnd, &p_data->sa_rnd );
	PokeParaPut( p_pp, ID_PARA_spedef_rnd, &p_data->sd_rnd );

	// 
//	PokeParaPut( p_pp, ID_PARA_speabino, &p_data->speabino );

	// 悳Ȃ
	PokeParaPut( p_pp, ID_PARA_style, &p_data->style );
	PokeParaPut( p_pp, ID_PARA_beautiful, &p_data->beautiful );
	PokeParaPut( p_pp, ID_PARA_cute, &p_data->cute );
	PokeParaPut( p_pp, ID_PARA_clever, &p_data->clever );
	PokeParaPut( p_pp, ID_PARA_strong, &p_data->strong );
	
	// ACe
	PokeParaPut( p_pp, ID_PARA_item, &p_data->item );

	// e̖O
	str = FLD_TradeGetGmm( heapID, FLD_TRADE_GET_OYA_GMM(trade_no) );
	PokeParaPut( p_pp, ID_PARA_oyaname_buf, str );
	STRBUF_Delete(str);

	// e̐	
	PokeParaPut( p_pp, ID_PARA_oyasex, &p_data->oya_sex );

	// R[h
	PokeParaPut( p_pp, ID_PARA_country_code, &p_data->world_code );

	// g[i[ݒ
	placeid = ZoneData_GetPlaceNameID( zone_id );
	TrainerMemoSetPP( p_pp, NULL, TRMEMO_OFFTRADE_PLACESET, placeid, heapID );

	// vZȂ
	PokeParaCalc( p_pp );

	// AɂȂȂ悤ɂ
	GF_ASSERT( PokeRareGet( p_pp ) == FALSE );
}
