//******************************************************************************
/**
 * 
 * @file	fieldobj.c
 * @brief	tB[hIuWFNg
 * @author	kagaya
 * @data	05.07.13
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "fieldobj.h"

#include "script.h"
#include "map_tool.h"

//==============================================================================
//	define
//==============================================================================
//--------------------------------------------------------------
//	ł΂
//--------------------------------------------------------------
#ifdef PM_DEBUG
//#define DEBUG_OBJID_SAM_CHECK		//`OBJ ID`FbN
//#define DEBUG_PRINT_FLDOBJ_COUNT	//`OBJݐo
#endif //PM_DEBUG

//--------------------------------------------------------------
///	GCAXV{
//--------------------------------------------------------------
enum
{
	RET_ALIES_NOT = 0,	//GCAXł͂Ȃ
	RET_ALIES_EXIST,	//GCAXƂĊɑ݂Ă
	RET_ALIES_CHANGE,	//GCAXύXKvł
};

//==============================================================================
//	struct
//==============================================================================
//--------------------------------------------------------------
///	FIELD_OBJ_SYS\
//--------------------------------------------------------------
typedef struct _TAG_FIELD_OBJ_SYS
{
	u32 status_bit;											///<Xe[^Xrbg
	int fldobj_max;											///<FIELD_OBJő吔
	int fldobj_count;										///<tB[hOBJݐ
	int tcb_pri;											///<TCBvCIeB
	int blact_idx;											///<r{[hAN^[CfbNX
	ARCHANDLE *archandle;									///<A[JCunh
	FIELD_OBJ_BLACT_CONT blact_cont;						///<FIELD_OBJ_BLACT_CONT
	FIELD_OBJ_RENDER_CONT_PTR render_cont;					///<FIELD_OBJ_RENDER_CONT
	FIELD_OBJ_PTR fldobj_work;								///<FIELD_OBJ[N *
	FIELDSYS_WORK *fieldsys;								///<FIELDSYS_WORK *
}FIELD_OBJ_SYS;

#define FIELD_OBJ_SYS_SIZE (sizeof(FIELD_OBJ_SYS))			///<FIELD_OBJ_SYSTCY

//--------------------------------------------------------------
///	FIELD_OBJ\
//--------------------------------------------------------------
typedef struct _TAG_FIELD_OBJ
{
	u32 status_bit;											///<Xe[^Xrbg
	u32 move_bit;											///<rbg
	u32 obj_id;												///<OBJ ID
	u32 zone_id;											///<][ ID
	u32 obj_code;											///<OBJR[h
	u32 move_code;											///<R[h
	u32 event_type;											///<Cxg^Cv
	u32 event_flag;											///<CxgtO
	u32 event_id;											///<CxgID
	int dir_head;											///<FIELD_OBJ_Hw
	int dir_disp;											///<݌Ă
	int dir_move;											///<ݓĂ
	int dir_disp_old;										///<ߋ̓Ă
	int dir_move_old;										///<ߋ̓Ă
	int param0;												///<wb_wp^
	int param1;												///<wb_wp^
	int param2;												///<wb_wp^
	int move_limit_x;										///<Xړ
	int move_limit_z;										///<Zړ
	int gx_init;											///<ObhX
	int gy_init;											///<ObhY
	int gz_init;											///<ObhZ
	int gx_old;												///<ߋObhX
	int gy_old;												///<ߋObhY
	int gz_old;												///<ߋObhZ
	int gx_now;												///<݃ObhX
	int gy_now;												///<݃ObhY
	int gz_now;												///<݃ObhZ
	VecFx32 vec_pos_now;									///<ݎW
	VecFx32 vec_draw_offs;									///<\WItZbg
	VecFx32 vec_draw_offs_outside;							///<Ow\WItZbg
	VecFx32 vec_attr_offs;								///<Agr[gɂWItZbg
	u32 draw_status;										///<`Xe[^X
	int acmd_code;											///<Aj[VR}hR[h
	int acmd_seq;											///<Aj[VR}hV[PX
	u16 now_attr;											///<݂̃}bvAgr[g
	u16 old_attr;											///<ߋ̃}bvAgr[g
	
	TCB_PTR tcb;											///<֐TCB*
	CONST_FIELD_OBJ_SYS_PTR fldobj_sys;						///<FIELD_OBJ_SYSւ *
	
	FIELD_OBJ_MOVE_PROC_INIT move_init_proc;				///<֐
	FIELD_OBJ_MOVE_PROC move_proc;							///<֐
	FIELD_OBJ_MOVE_PROC_DEL move_delete_proc;				///<폜֐
	FIELD_OBJ_DRAW_PROC_INIT draw_init_proc;				///<`揉֐
	FIELD_OBJ_DRAW_PROC draw_proc;							///<`֐
	FIELD_OBJ_DRAW_PROC_DEL draw_delete_proc;				///<`폜֐
	FIELD_OBJ_DRAW_PROC_PUSH draw_push_proc;				///<`ޔ֐
	FIELD_OBJ_DRAW_PROC_POP draw_pop_proc;					///<`敜A֐
	
	u8 move_proc_work[FLDOBJ_MOVE_WORK_SIZE];				///<֐p[N
	u8 move_sub_proc_work[FLDOBJ_MOVE_SUB_WORK_SIZE];		///<Tu֐p[N
	u8 move_cmd_proc_work[FLDOBJ_MOVE_CMD_WORK_SIZE];		///<R}hp[N
	u8 draw_proc_work[FLDOBJ_DRAW_WORK_SIZE];				///<`֐p[N
}FIELD_OBJ;

#define FIELD_OBJ_SIZE (sizeof(FIELD_OBJ))					///<FIELD_OBJTCY

//--------------------------------------------------------------
///	FIELD_OBJ_H_LOAD_FILE\
//--------------------------------------------------------------
typedef struct
{
	int zone;
	int add_max;											//o^ő吔
	int add_count;											//ǉ
	CONST_FIELD_OBJ_SYS_PTR sys;							//FIELD_OBJ_SYS_PTR 
	FIELD_OBJ_H *head;										//wb_[
}FIELD_OBJ_H_LOAD_FILE;
															///FIELD_OBJ_H_LOAD_FILETCY
#define FIELD_OBJ_H_LOAD_FILE_SIZE (sizeof(FIELD_OBJ_H_LOAD_FILE))

//==============================================================================
//	vg^Cv
//==============================================================================
static FIELD_OBJ_SYS_PTR  FldOBJSys_AllocMemory( int max );

static void FldOBJ_SaveDataSave( FIELDSYS_WORK *fsys, FIELD_OBJ_PTR fldobj, FIELD_OBJ_SAVE_DATA_PTR save );
static void FldOBJ_SaveDataLoad( FIELD_OBJ_PTR fldobj, FIELD_OBJ_SAVE_DATA_PTR save );
static void FldOBJ_DataLoadRecover( CONST_FIELD_OBJ_SYS_PTR fos, FIELD_OBJ_PTR fldobj );
static void FldOBJ_DataLoadStatusBitRecover( FIELD_OBJ_PTR fldobj );
static void FldOBJ_DataLoadPosRecover( FIELD_OBJ_PTR fldobj );

static void FldOBJ_AddFileProc( FIELD_OBJ_H_LOAD_FILE *work );

static FIELD_OBJ_PTR  FldOBJ_SpaceSearch( CONST_FIELD_OBJ_SYS_PTR sys );
static FIELD_OBJ_PTR  FldOBJ_AliesSearch( CONST_FIELD_OBJ_SYS_PTR fos, int obj_id,int zone_id );
static void FldOBJ_MoveTcbAdd( CONST_FIELD_OBJ_SYS_PTR sys, FIELD_OBJ_PTR fldobj );
static void FldOBJ_AddHeaderSet(
		FIELD_OBJ_PTR fldobj, const FIELD_OBJ_H *head, FIELDSYS_WORK *fsys );
static void FldOBJ_AddHeaderPosInit( FIELD_OBJ_PTR fldobj, const FIELD_OBJ_H *head );
static void FldOBJ_WorkInit( FIELD_OBJ_PTR fldobj, CONST_FIELD_OBJ_SYS_PTR sys );
static void FldOBJ_WorkInit_MoveProcInit( FIELD_OBJ_PTR fldobj );
static void FldOBJ_WorkInit_DrawProcInit( FIELD_OBJ_PTR fldobj );
static void FldOBJ_WorkClear( FIELD_OBJ_PTR fldobj );
static int FldOBJ_HeaderAliesCheck(
		CONST_FIELD_OBJ_PTR fldobj, int h_zone_id, int max, const FIELD_OBJ_H *head );
static FIELD_OBJ_PTR FldOBJ_OBJIDZoneIDSearch(
		CONST_FIELD_OBJ_SYS_PTR fos, int obj_id, int zone_id );
static void FldOBJ_DeleteAll_OldZoneID( FIELD_OBJ_SYS_PTR fos, u32 zone_id );
static void FldOBJ_DrawInitStatusSet( FIELD_OBJ_PTR fldobj );
static void FldOBJ_DrawEffectFlagInit( FIELD_OBJ_PTR fldobj );
static void FldOBJ_DrawDeleteStatusSet( FIELD_OBJ_PTR fldobj );
static int FldOBJ_OBJCodeWkOBJCodeConv( FIELDSYS_WORK *fsys, int code );
static void FldOBJ_HeightNeedCheckInit( FIELD_OBJ_PTR fldobj );
static void FldOBJ_MoveWorkInit( FIELD_OBJ_PTR fldobj );
static void FldOBJ_DrawWorkInit( FIELD_OBJ_PTR fldobj );
static void FldOBJ_AliesOBJChange( FIELD_OBJ_PTR fldobj, const FIELD_OBJ_H *head, int zone_id );
static void FldOBJ_OBJAliesChange( FIELD_OBJ_PTR fldobj, int zone_id, const FIELD_OBJ_H *head );

static void FldOBJ_TCB_MoveProc( TCB_PTR tcb, void *work );
static void FldOBJ_TCB_DrawProc( FIELD_OBJ_PTR fldobj );

static FIELD_OBJ_SYS_PTR  FldOBJ_ConstSysLocalGet( CONST_FIELD_OBJ_SYS_PTR sys );
static void FldOBJSys_OBJCountInc( FIELD_OBJ_SYS_PTR sys );
static void FldOBJSys_OBJCountDec( FIELD_OBJ_SYS_PTR sys );
static void FldOBJSys_OBJCountSet( FIELD_OBJ_SYS_PTR sys, int count );
static FIELD_OBJ_PTR FldOBJSys_FieldOBJWorkGet( CONST_FIELD_OBJ_SYS_PTR sys );

static FIELD_OBJ_SYS_PTR  FldOBJ_FieldOBJSysGet( CONST_FIELD_OBJ_PTR fldobj );

static const FIELD_OBJ_H * FldOBJ_H_OBJIDSearch( int id, int max, const FIELD_OBJ_H *head );
static int FldOBJ_H_AliesCheck( const FIELD_OBJ_H *head );
static int FldOBJ_H_AliesZoneIDGet( const FIELD_OBJ_H *head );

static const FIELD_OBJ_MOVE_PROC_LIST * FldOBJ_MoveProcListGet( u32 code );
static FIELD_OBJ_MOVE_PROC_INIT FldOBJ_MoveProcList_InitGet(
		const FIELD_OBJ_MOVE_PROC_LIST *list );
static FIELD_OBJ_MOVE_PROC FldOBJ_MoveProcList_MoveGet(
		const FIELD_OBJ_MOVE_PROC_LIST *list );
static FIELD_OBJ_MOVE_PROC_DEL FldOBJ_MoveProcList_DeleteGet(
		const FIELD_OBJ_MOVE_PROC_LIST *list );
static FIELD_OBJ_DRAW_PROC_PUSH FldOBJ_DrawProcList_PushGet(
		const FIELD_OBJ_DRAW_PROC_LIST *list );
static FIELD_OBJ_DRAW_PROC_POP FldOBJ_DrawProcList_PopGet(
		const FIELD_OBJ_DRAW_PROC_LIST *list );

static FIELD_OBJ_DRAW_PROC_INIT FldOBJ_DrawProcList_InitGet(
	const FIELD_OBJ_DRAW_PROC_LIST *list );
static FIELD_OBJ_DRAW_PROC FldOBJ_DrawProcList_DrawGet( const FIELD_OBJ_DRAW_PROC_LIST *list );
static FIELD_OBJ_DRAW_PROC_DEL FldOBJ_DrawProcList_DeleteGet(
		const FIELD_OBJ_DRAW_PROC_LIST *list );
static const FIELD_OBJ_DRAW_PROC_LIST * FldOBJ_DrawProcListGet( u32 code );

//==============================================================================
//	tB[hOBJ	VXe
//==============================================================================
//--------------------------------------------------------------
/**
 * FIELD OBJ VXe
 * @param		fsys			FIELDSYS_WORK *
 * @param		max 			OBJő吔
 * @param		pri				tB[hOBJ̊{TCBvCIeB
 * @retval		FIELD_OBJ_SYS*	ǉꂽtB[hOBJ*
 */
//--------------------------------------------------------------
FIELD_OBJ_SYS_PTR FieldOBJSys_Init( FIELDSYS_WORK *fsys, int max, int pri )
{
	FIELD_OBJ_SYS_PTR fos;
	
	fos = FldOBJSys_AllocMemory( max );
	FieldOBJSys_FieldSysWorkSet( fos, fsys );
	FieldOBJSys_OBJMaxSet( fos, max );
	FieldOBJSys_TCBStandardPrioritySet( fos, pri );
	
//	OS_Printf( "OLD FIELD_OBJ_SAVE_DATA_SIZE %x\n", FIELD_OBJ_SAVE_DATA_OLD_SIZE );
//	OS_Printf( "NEW FIELD_OBJ_SAVE_DATA_SIZE %x\n", FIELD_OBJ_SAVE_DATA_SIZE );
	
	return( fos );
}

//--------------------------------------------------------------
/**
 * FIELD OBJ VXe폜
 * @param	fos		FIELD_OBJ_SYS_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_Delete( FIELD_OBJ_SYS_PTR fos )
{
	sys_FreeMemory( HEAPID_WORLD, FieldOBJSys_FldOBJWorkGet(fos) );
	sys_FreeMemory( HEAPID_WORLD, fos );
}

//--------------------------------------------------------------
/**
 * FIELD OBJ@SĂ폜
 * @param	fos		FIELD_OBJ_SYS_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_DeleteAll( FIELD_OBJ_SYS_PTR fos )
{
	FieldOBJ_DeleteAll( fos );
	FieldOBJSys_DrawDelete( fos );
	FieldOBJSys_Delete( fos );
	
	OS_Printf( "tB[hOBJ SĂ폜܂\n" );
}

//--------------------------------------------------------------
/**
 * FIELD OBJ@][XV̍폜
 * @param	sys		FIELD_OBJ_SYS_PTR 
 * @param	old_zone	Â][ID
 * @param	new_zone	V][ID
 * @param	head_max	headvf
 * @param	head	Ṽ][ɔzuFIELD_OBJ_H *
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_ZoneUpdateDelete( FIELD_OBJ_SYS_PTR fos,
		int old_zone, int new_zone, int head_max, const FIELD_OBJ_H *head )
{
	int ret,max = FieldOBJSys_OBJMaxGet( fos );
	FIELD_OBJ_PTR fldobj = FieldOBJSys_FldOBJWorkGet( fos );
	
	OS_Printf( "ÂZoneɔzuꂽtB[hOBJ@폜Jn\n" );
	
	while( max ){
		if( FieldOBJ_StatusBitCheck_Use(fldobj) == TRUE ){
			ret = FldOBJ_HeaderAliesCheck( fldobj, new_zone, head_max, head );
			
			switch( ret ){
			case RET_ALIES_NOT:
				if( FieldOBJ_ZoneIDGet(fldobj) != new_zone ){
					if( FieldOBJ_StatusBit_CheckEasy(
							fldobj,FLDOBJ_STA_BIT_ZONE_DEL_NOT) == FALSE ){
						FieldOBJ_Delete( fldobj );
					}
				}
				
				break;
			case RET_ALIES_CHANGE:
				OS_Printf(
					"GCAXΏۂOBJ OBJ_ID=%d ZONE_ID=%d GRID X=%d,GRID Z=%d \n",
					FieldOBJ_OBJIDGet(fldobj),
					new_zone,
					FieldOBJ_NowPosGX_Get(fldobj), FieldOBJ_NowPosGZ_Get(fldobj) );
				break;
			case RET_ALIES_EXIST:
				OS_Printf( "GCAXΏۂOBJɃGCAXĂ܂ " );
				OS_Printf( "OBJ_ID=%d ", FieldOBJ_OBJIDGet(fldobj) );
				OS_Printf( "ZONE_ID=%d ", FieldOBJ_ZoneIDGetAlies(fldobj) );
				OS_Printf( "ǉ̃][ID=%d ", new_zone );
				OS_Printf( "GRID X=%d, ", FieldOBJ_NowPosGX_Get(fldobj) );
				OS_Printf( "GRID Z=%d\n", FieldOBJ_NowPosGZ_Get(fldobj) );
				break;
			}
		}
		
		fldobj++;
		max--;
	}
	
	FieldOBJ_BlActCont_ResmGuestDeleteAll( fos, FieldOBJSys_BlActContGet(fos) );
	OS_Printf( "ÂZoneɔzuꂽtB[hOBJ@폜\n" );
}

//==============================================================================
//	tB[hOBJVXe@p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * FIELD OBJ Ɨ̈m
 * @param	max				OBJő吔
 * @retval	FIELD_OBJ_SYS	mۂ̈*
 */
//--------------------------------------------------------------
static FIELD_OBJ_SYS_PTR FldOBJSys_AllocMemory( int max )
{
	int size;
	FIELD_OBJ_PTR fldobj;
	FIELD_OBJ_SYS_PTR fos;
	
	fos = sys_AllocMemory( HEAPID_WORLD, FIELD_OBJ_SYS_SIZE );
	
	GF_ASSERT( fos != NULL && "fldobj sys alloc memory error" );
	memset( fos, 0, FIELD_OBJ_SYS_SIZE );
	
	size = FIELD_OBJ_SIZE * max;
	fldobj = sys_AllocMemory( HEAPID_WORLD, size );
	
	GF_ASSERT( fldobj != NULL && "fldobj alloc memory error" );
	memset( fldobj, 0, size );
	
	FieldOBJSys_FieldOBJWorkSet( fos, fldobj );
	
	return( fos );
}

//==============================================================================
//	tB[hOBJ
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hOBJǉ wb_[
 * @param	fos			FIELD_OBJ_SYS_PTR 
 * @param	head		ǉZ߂FIELD_OBJ_H *
 * @param	zone_id		][ID
 * @retval	FIELD_OBJ	ǉꂽFIELD_OBJ_PTR BNULL=ǉs
 */
//--------------------------------------------------------------
FIELD_OBJ_PTR FieldOBJ_AddH( CONST_FIELD_OBJ_SYS_PTR fos, const FIELD_OBJ_H *head, int zone_id )
{
	FIELD_OBJ_PTR fldobj;
	
	{
		int obj_id = FieldOBJ_H_IDGet( head );
		
		if( FldOBJ_H_AliesCheck(head) == FALSE ){				//GCAXł͂Ȃ
			fldobj = FldOBJ_AliesSearch( fos, obj_id, zone_id );
			
			if( fldobj != NULL ){								//GCAXŊɑ݂Ă
				FldOBJ_AliesOBJChange( fldobj, head, zone_id );	//GCAXtB[hOBJ
				OS_Printf( "GCAX -> tB[hOBJ OBJ_ID %d ", obj_id );
				OS_Printf( "GIRD X=%d ", FieldOBJ_H_PosXGet(head) );
				OS_Printf( "GIRD Z=%d\n", FieldOBJ_H_PosZGet(head) );
				return( fldobj );
			}
		}else{													//GCAXł
			fldobj = FldOBJ_OBJIDZoneIDSearch( fos, obj_id, FldOBJ_H_AliesZoneIDGet(head) );
			
			if( fldobj != NULL ){								//ɃtB[hOBJ݂
				FldOBJ_OBJAliesChange( fldobj, zone_id, head );	//tB[hOBJGCAX
				OS_Printf( "tB[hOBJ -> GCAX OBJ_ID %d ", obj_id );
				OS_Printf( "GIRD X=%d ", FieldOBJ_H_PosXGet(head) );
				OS_Printf( "GIRD Z=%d\n", FieldOBJ_H_PosZGet(head) );
				return( fldobj );
			}
			
			OS_Printf( "GCAXzu܂ " );
			OS_Printf( "ZONE_ID %d, OBJ_ID %d ", obj_id, FldOBJ_H_AliesZoneIDGet(head) );
			OS_Printf( "GIRD X=%d ", FieldOBJ_H_PosXGet(head) );
			OS_Printf( "GIRD Z=%d\n", FieldOBJ_H_PosZGet(head) );
		}
	}
	
	fldobj = FldOBJ_SpaceSearch( fos );
	
	if( fldobj == NULL ){
		return( fldobj );
	}
	
	FldOBJ_AddHeaderSet( fldobj, head, FieldOBJSys_FieldSysWorkGet(fos) );
	FldOBJ_WorkInit( fldobj, fos );
	FieldOBJ_ZoneIDSet( fldobj, zone_id );
	
	FldOBJ_MoveWorkInit( fldobj );
	FldOBJ_DrawWorkInit( fldobj );
	
	FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_MOVE_START );
	
	FldOBJ_MoveTcbAdd( fos, fldobj );
	FldOBJSys_OBJCountInc( FldOBJ_ConstSysLocalGet(fos) );
	
	return( fldobj );
}

//--------------------------------------------------------------
/**
 * tB[hOBJǉBŒKvȏ񂩂wb_[쐬ĒǉB
 * Ȃ0ŃNAĂBKvΒǉɊeŎRɐݒB
 * @param	fos			FIELD_OBJ_SYS_PTR 
 * @param	x			ObhWX
 * @param	z			ObhWZ
 * @param	dir			BDIR_UP
 * @param	obj			OBJR[hBHERO
 * @param	move		R[hBMV_RND
 * @param	zone_id		][ID ZONE_ID_NOTHING
 * @retval	FIELD_OBJ	ǉꂽFIELD_OBJ_PTR BNULL=ǉs
 */
//--------------------------------------------------------------
FIELD_OBJ_PTR FieldOBJ_AddHMake(
		CONST_FIELD_OBJ_SYS_PTR fos, int x, int z, int dir, int obj, int move, int zone_id )
{
	FIELD_OBJ_H head;
	FIELD_OBJ_PTR fldobj;
	
	FieldOBJ_H_IDSet( &head, 0 );
	FieldOBJ_H_OBJCodeSet( &head, obj );
	FieldOBJ_H_MoveCodeSet( &head, move );
	FieldOBJ_H_EventTypeSet( &head, 0 );
	FieldOBJ_H_EventFlagSet( &head, 0 );
	FieldOBJ_H_EventIDSet( &head, 0 );
	FieldOBJ_H_DirSet( &head, dir );
	FieldOBJ_H_ParamSet( &head, 0, FLDOBJ_PARAM_0 );
	FieldOBJ_H_ParamSet( &head, 0, FLDOBJ_PARAM_1 );
	FieldOBJ_H_ParamSet( &head, 0, FLDOBJ_PARAM_2 );
	FieldOBJ_H_MoveLimitXSet( &head, 0 );
	FieldOBJ_H_MoveLimitZSet( &head, 0 );
	FieldOBJ_H_PosXSet( &head, x );
	FieldOBJ_H_PosZSet( &head, z );
	FieldOBJ_H_PosYSet( &head, 0 );
	
	fldobj = FieldOBJ_AddH( fos, &head, zone_id );
	
	return( fldobj );
}

//--------------------------------------------------------------
/**
 * FIELD_OBJ_He[uwIDOBJǉ
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	id		ǉheadID
 * @param	zone	ǉ̍ۂɎw肷][ID
 * @param	max		headvf
 * @param	head	FIELD_OBJ_H *
 * @retval	FIELD_OBJ_PTR	ǉꂽFIELD_OBJ_PTR NULL=idY
 */
//--------------------------------------------------------------
FIELD_OBJ_PTR FieldOBJ_AddHEvent(
		CONST_FIELD_OBJ_SYS_PTR fos, int id, int max, int zone, const FIELD_OBJ_H *head )
{
	FIELD_OBJ_PTR fldobj = NULL;
	const FIELD_OBJ_H *hit_head = FldOBJ_H_OBJIDSearch( id, max, head );
	
	if( hit_head != NULL ){
		int flag = FieldOBJ_H_EventFlagGet( hit_head );
		FIELDSYS_WORK *fsys = FieldOBJSys_FieldSysWorkGet( fos );
		
		if( CheckEventFlag(fsys,flag) == FALSE ){
			fldobj = FieldOBJ_AddH( fos, hit_head, zone );
		}
	}
	
	return( fldobj );
}

//--------------------------------------------------------------
/**
 * FIELD OBJ@\n̂ݍĐݒ@폜͍sȂ
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	code	OBJR[h HERO
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawResetAlone( FIELD_OBJ_PTR fldobj, int code )
{
#ifdef PM_DEBUG
	{	//`VXeĂȂ
		CONST_FIELD_OBJ_SYS_PTR fos = FieldOBJ_FieldOBJSysGet( fldobj );
		GF_ASSERT( FieldOBJSys_DrawInitCompCheck(fos) != FALSE &&
			"FieldOBJ_DrawReset() DRAW SYS NOT INIT" );
	}
#endif
	
	FieldOBJ_OBJCodeSet( fldobj, code );
	FldOBJ_DrawInitStatusSet( fldobj );
	FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_DRAW_PROC_INIT_COMP );
	FldOBJ_DrawWorkInit( fldobj );
}

//--------------------------------------------------------------
/**
 * FIELD OBJ@݂̕`֐폜čĐݒ
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	code	OBJR[h HERO
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawReset( FIELD_OBJ_PTR fldobj, int code )
{
	if( FieldOBJ_StatusBit_DrawInitCompCheck(fldobj) == TRUE ){
		FieldOBJ_DrawDelete( fldobj );
	}
	
	FieldOBJ_DrawResetAlone( fldobj, code );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ폜
 * @param	fldobj		폜FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_Delete( FIELD_OBJ_PTR fldobj )
{
	CONST_FIELD_OBJ_SYS_PTR fos;
	
	fos = FieldOBJ_FieldOBJSysGet( fldobj );
	
	if( FieldOBJSys_DrawInitCompCheck(fos) == TRUE ){
		FieldOBJ_DrawDeleteProcCall( fldobj );
	}
	
	FieldOBJ_MoveDeleteProcCall( fldobj );
	FieldOBJ_MoveTcbDelete( fldobj );
	FldOBJSys_OBJCountDec( FldOBJ_FieldOBJSysGet(fldobj) );
	FldOBJ_WorkClear( fldobj );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ폜@XNvgOBJ폜tOONɂ
 * @param	fldobj		폜FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DeleteEvent( FIELD_OBJ_PTR fldobj )
{
	int ev;
	
	ev = FieldOBJ_EventFlagGet( fldobj );
	SetEventFlag( FieldOBJ_FieldSysWorkGet(fldobj), ev );
	FieldOBJ_Delete( fldobj );
}

//--------------------------------------------------------------
/**
 * FIELD OBJ@\n̂ݍ폜
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawDelete( FIELD_OBJ_PTR fldobj )
{
	CONST_FIELD_OBJ_SYS_PTR fos;
	
	fos = FieldOBJ_FieldOBJSysGet( fldobj );
	
	if( FieldOBJSys_DrawInitCompCheck(fos) == TRUE ){
		if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_DRAW_PROC_INIT_COMP) ){
			FieldOBJ_DrawDeleteProcCall( fldobj );
		}
		
		FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_DRAW_PROC_INIT_COMP );
	}
	
	FieldOBJ_OBJCodeSet( fldobj, OBJCODEMAX );
	
	FieldOBJ_DrawInitProcSet( fldobj, FieldOBJ_DrawInitProcDummy );
	FieldOBJ_DrawProcSet( fldobj, FieldOBJ_DrawProcDummy );
	FieldOBJ_DrawDeleteProcSet( fldobj, FieldOBJ_DrawProcDummy );
	FieldOBJ_DrawPushProcSet( fldobj, FieldOBJ_DrawPushProcDummy );
	FieldOBJ_DrawPopProcSet( fldobj, FieldOBJ_DrawPopProcDummy );
}

//--------------------------------------------------------------
/**
 * ݔĂtB[hOBJSč폜
 * @param	fldobj		폜FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DeleteAll( FIELD_OBJ_SYS_PTR fos )
{
	int i,max;
	FIELD_OBJ_PTR fldobj;
	
	i = 0;
	max = FieldOBJSys_OBJMaxGet( fos );
	fldobj = FieldOBJSys_FldOBJWorkGet( fos );
	
	do{
		if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_USE) ){
			FieldOBJ_Delete( fldobj );
		}
		
		fldobj++;
		i++;
	}while( i < max );
}

//--------------------------------------------------------------
/**
 * ݔĂtB[hOBJSĂޔ
 * @param	fldobj		폜FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_PushAll( FIELD_OBJ_SYS_PTR fos )
{
	int i,max;
	FIELD_OBJ_PTR fldobj;
	
	i = 0;
	max = FieldOBJSys_OBJMaxGet( fos );
	fldobj = FieldOBJSys_FldOBJWorkGet( fos );
	
	do{
		if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_USE) ){
			if( FieldOBJ_StatusBitCheck_DrawProcInitComp(fldobj) == TRUE ){
				FieldOBJ_DrawPushProcCall( fldobj );
			}
		}
		
		fldobj++;
		i++;
	}while( i < max );
}

//--------------------------------------------------------------
/**
 * ݔĂtB[hOBJSĂɂĕ`揈̑ޔs
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawProcPushAll( FIELD_OBJ_SYS_PTR fos )
{
	GF_ASSERT( FieldOBJSys_DrawInitCompCheck(fos) == TRUE &&
		"FLDOBJ `揈݂ĂȂ̂FieldOBJ_DrawProcPushAll()Ă΂Ă܂" );
	
	{
		int i,max;
		FIELD_OBJ_PTR fldobj;
	
		i = 0;
		max = FieldOBJSys_OBJMaxGet( fos );
		fldobj = FieldOBJSys_FldOBJWorkGet( fos );
	
		do{
			if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_USE) ){
				if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_DRAW_PROC_INIT_COMP) ){
					FieldOBJ_DrawPushProcCall( fldobj );
					FldOBJ_DrawDeleteStatusSet( fldobj );
				}
			}
		
			fldobj++;
			i++;
		}while( i < max );
	}
	
	OS_Printf( "tB[hOBJ `ޔ܂\n" );
}

//--------------------------------------------------------------
/**
 * ݔĂtB[hOBJSĂ𕜋A
 * @param	fldobj		폜FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_PopAll( FIELD_OBJ_SYS_PTR fos )
{
	int i,max;
	FIELD_OBJ_PTR fldobj;
	
	i = 0;
	max = FieldOBJSys_OBJMaxGet( fos );
	fldobj = FieldOBJSys_FldOBJWorkGet( fos );
	
	do{
		if( FieldOBJ_StatusBitCheck_Use(fldobj) == TRUE ){
			if( FieldOBJ_StatusBitCheck_DrawProcInitComp(fldobj) == TRUE ){
				FieldOBJ_DrawPopProcCall( fldobj );
			}
		}
	
		fldobj++;
		i++;
	}while( i < max );
}

//--------------------------------------------------------------
/**
 * ݔĂtB[hOBJSĂɑ΂ĕ`揈A
 * @param	fldobj		폜FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawProcPopAll( FIELD_OBJ_SYS_PTR fos )
{
	GF_ASSERT( FieldOBJSys_DrawInitCompCheck(fos) == TRUE &&
		"FLDOBJ `揈ŕ`敜AĂ΂Ă܂" );
	
	{
		int i = 0;
		int max = FieldOBJSys_OBJMaxGet( fos );
		FIELD_OBJ_PTR fldobj = FieldOBJSys_FldOBJWorkGet( fos );
	
		do{
			if( FieldOBJ_StatusBitCheck_Use(fldobj) == TRUE ){
				if( FieldOBJ_StatusBitCheck_DrawProcInitComp(fldobj) == TRUE ){
					FieldOBJ_DrawPopProcCall( fldobj );
				}else{
					FldOBJ_DrawWorkInit( fldobj );
				}
				
				FldOBJ_DrawInitStatusSet( fldobj );
			}
		
			fldobj++;
			i++;
		}while( i < max );
	}
	
	OS_Printf( "tB[hOBJ `𕜋A܂\n" );
}

//==============================================================================
//	tB[hOBJ Z[u
//==============================================================================
//--------------------------------------------------------------
/**
 * ݔĂtB[hOBJSĂZ[uf[^ɕۑ
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	save	ۑFIELD_OBJ_SAVE_DATA_PTR
 * @param	max		save̗vf
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_DataSaveAll(
		FIELDSYS_WORK *fsys, CONST_FIELD_OBJ_SYS_PTR fos, FIELD_OBJ_SAVE_DATA_PTR save, int max )
{
	int no = 0;
	FIELD_OBJ_PTR fldobj;
	
	while( FieldOBJSys_FieldOBJSearch(fos,&fldobj,&no,FLDOBJ_STA_BIT_USE) ){
		FldOBJ_SaveDataSave( fsys, fldobj, save );
		save++; max--;
		GF_ASSERT( max > 0 && "FieldOBJSys_DataSaveAll()ُ" );
	}
	
	if( max ){
		memset( save, 0, max * FIELD_OBJ_SAVE_DATA_SIZE );
	}
}

//--------------------------------------------------------------
/**
 * Z[uf[^[h
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	save	ۑf[^i[ꂽFIELD_OBJ_SAVE_DATA_PTR
 * @param	max		save̗vf
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_DataLoadAll(
		CONST_FIELD_OBJ_SYS_PTR fos, FIELD_OBJ_SAVE_DATA_PTR save, int max )
{
	int i = 0;
	FIELD_OBJ_PTR fldobj;
	
	while( max ){
		if( (save->status_bit & FLDOBJ_STA_BIT_USE) ){
			fldobj = FldOBJ_SpaceSearch( fos );
			GF_ASSERT( fldobj != NULL && "FieldOBJSys_DataLoadAll()ُ" );
		
			FldOBJ_SaveDataLoad( fldobj, save );
			FldOBJ_DataLoadRecover( fos, fldobj );
		}
		
		save++;
		max--;
	}
}

//--------------------------------------------------------------
/**
 * tB[hOBJ̏Z[uf[^ɃZbg
 * @param	fldobj		FIELD_OBJ_PTR
 * @param	save		FIELD_OBJ_SAVE_DATA_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_SaveDataSave( FIELDSYS_WORK *fsys, FIELD_OBJ_PTR fldobj, FIELD_OBJ_SAVE_DATA_PTR save )
{
	save->status_bit = FieldOBJ_StatusBit_Get( fldobj );
	save->move_bit = FieldOBJ_MoveBit_Get( fldobj );
	save->obj_id = FieldOBJ_OBJIDGet( fldobj );
	save->zone_id = FieldOBJ_ZoneIDGet( fldobj );
	save->obj_code = FieldOBJ_OBJCodeGet( fldobj );
	save->move_code = FieldOBJ_MoveCodeGet( fldobj );
	save->event_type = FieldOBJ_EventTypeGet( fldobj );
	save->event_flag = FieldOBJ_EventFlagGet( fldobj );
	save->event_id = FieldOBJ_EventIDGet( fldobj );
	save->dir_head = FieldOBJ_DirHeaderGet( fldobj );
	save->dir_disp = FieldOBJ_DirDispGet( fldobj );
	save->dir_move = FieldOBJ_DirMoveGet( fldobj );
	save->param0 = FieldOBJ_ParamGet( fldobj, FLDOBJ_PARAM_0 );
	save->param1 = FieldOBJ_ParamGet( fldobj, FLDOBJ_PARAM_1 );
	save->param2 = FieldOBJ_ParamGet( fldobj, FLDOBJ_PARAM_2 );
	save->move_limit_x = FieldOBJ_MoveLimitXGet( fldobj );
	save->move_limit_z = FieldOBJ_MoveLimitZGet( fldobj );
	save->gx_init = FieldOBJ_InitPosGX_Get( fldobj );
	save->gy_init = FieldOBJ_InitPosGY_Get( fldobj );
	save->gz_init = FieldOBJ_InitPosGZ_Get( fldobj );
	save->gx_now = FieldOBJ_NowPosGX_Get( fldobj );
	save->gy_now = FieldOBJ_NowPosGY_Get( fldobj );
	save->gz_now = FieldOBJ_NowPosGZ_Get( fldobj );

	//̕ۑ
#if 0
	{
		HEIGHT_TYPE flag;
		fx32 x,y,z;
		VecFx32 vec_pos;
		//ObhFX32^ɂ(Obh̒SW)
		x = save->gx_now * 16 * FX32_ONE+(8*FX32_ONE);
		z = save->gz_now * 16 * FX32_ONE+(8*FX32_ONE);
		FieldOBJ_VecPosGet( fldobj, &vec_pos );

		y = GetHeightPack( fsys, vec_pos.y, x, z, &flag );
		
		if( flag == HEIGHT_FAIL ){
			save->fx32_y = save->gy_now * 8 * FX32_ONE;
//			OS_Printf("height_FAIL:%x\n",save->fx32_y);
		}else{
			save->fx32_y = y;
//			OS_Printf("height_SAC:%x\n",save->fx32_y);
		}
	}
#else
	{
		VecFx32 vec;
		int flag,eflag;
		
		FieldOBJTool_GridCenterPosGet( save->gx_now, save->gz_now, &vec );
		vec.y = FieldOBJ_VecPosYGet( fldobj );
		
		eflag = FieldOBJ_StatusBitCheck_HeightExpand( fldobj );
		flag = FieldOBJTool_GetHeightExpand( fsys, &vec, eflag );
		
		if( flag == FALSE ){
			#if 0
			//ꂾƍ擾sA܂ŐɎ擾Ă𖳎ăObhPʂ
			//WɕϊĂ܂A΂ߓ̒[ƂȂĂ܂B
			save->fx32_y = H_GRID_SIZE_FX32( save->gy_now );
			#else
			save->fx32_y = FieldOBJ_VecPosYGet( fldobj );	
			#endif
		}else{
			save->fx32_y = vec.y;
		}
	}
#endif
	
	memcpy( save->move_proc_work,
			FieldOBJ_MoveProcWorkGet(fldobj), FLDOBJ_MOVE_WORK_SIZE );
	memcpy( save->move_sub_proc_work,
			FieldOBJ_MoveSubProcWorkGet(fldobj), FLDOBJ_MOVE_SUB_WORK_SIZE );
}

//--------------------------------------------------------------
/**
 * Z[uf[^̏tB[hOBJɃZbg
 * @param	fldobj		FIELD_OBJ_PTR
 * @param	save		FIELD_OBJ_SAVE_DATA_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_SaveDataLoad( FIELD_OBJ_PTR fldobj, FIELD_OBJ_SAVE_DATA_PTR save )
{
	FieldOBJ_StatusBit_Init( fldobj, save->status_bit );
	FieldOBJ_MoveBit_Init( fldobj, save->move_bit );
	FieldOBJ_OBJIDSet( fldobj,  save->obj_id );
	FieldOBJ_ZoneIDSet( fldobj, save->zone_id );
	FieldOBJ_OBJCodeSet( fldobj, save->obj_code );
	FieldOBJ_MoveCodeSet( fldobj, save->move_code );
	FieldOBJ_EventTypeSet( fldobj, save->event_type );
	FieldOBJ_EventFlagSet( fldobj, save->event_flag );
	FieldOBJ_EventIDSet( fldobj, save->event_id );
	FieldOBJ_DirHeaderSet( fldobj, save->dir_head );
	FieldOBJ_DirDispSetForce( fldobj, save->dir_disp );
	FieldOBJ_DirMoveSet( fldobj, save->dir_move );
	FieldOBJ_ParamSet( fldobj, save->param0, FLDOBJ_PARAM_0 );
	FieldOBJ_ParamSet( fldobj, save->param1, FLDOBJ_PARAM_1 );
	FieldOBJ_ParamSet( fldobj, save->param2, FLDOBJ_PARAM_2 );
	FieldOBJ_MoveLimitXSet( fldobj, save->move_limit_x );
	FieldOBJ_MoveLimitZSet( fldobj, save->move_limit_z );
	FieldOBJ_InitPosGX_Set( fldobj, save->gx_init );
	FieldOBJ_InitPosGY_Set( fldobj, save->gy_init );
	FieldOBJ_InitPosGZ_Set( fldobj, save->gz_init );
	FieldOBJ_NowPosGX_Set( fldobj, save->gx_now );
	FieldOBJ_NowPosGY_Set( fldobj, save->gy_now );
	FieldOBJ_NowPosGZ_Set( fldobj, save->gz_now );

	//A
	{
		VecFx32 vec = {0,0,0};
		vec.y = save->fx32_y;
		FieldOBJ_VecPosSet( fldobj, &vec );
	}
	
	memcpy( FieldOBJ_MoveProcWorkGet(fldobj),
			save->move_proc_work, FLDOBJ_MOVE_WORK_SIZE );
	memcpy( FieldOBJ_MoveSubProcWorkGet(fldobj),
			save->move_sub_proc_work, FLDOBJ_MOVE_SUB_WORK_SIZE );
}

//--------------------------------------------------------------
/**
 * f[^[h̕A
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_DataLoadRecover( CONST_FIELD_OBJ_SYS_PTR fos, FIELD_OBJ_PTR fldobj )
{
	FldOBJ_DataLoadStatusBitRecover( fldobj );
	FldOBJ_DataLoadPosRecover( fldobj );
	
	FieldOBJ_FieldOBJSysSet( fldobj, fos );
	
	FldOBJ_WorkInit_MoveProcInit( fldobj );						//֐̏̂
	FieldOBJ_AcmdFree( fldobj );
	FldOBJ_DrawWorkInit( fldobj );
	
	FldOBJ_MoveTcbAdd( fos, fldobj );
	FieldOBJ_MoveReturnProcCall( fldobj );
	FldOBJSys_OBJCountInc( FldOBJ_ConstSysLocalGet(fos) );
}

//--------------------------------------------------------------
/**
 * f[^[h̃Xe[^XrbgA
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_DataLoadStatusBitRecover( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_StatusBit_ON( fldobj,
			FLDOBJ_STA_BIT_USE |
//			FLDOBJ_STA_BIT_HEIGHT_GET_NEED |					//Z[u̍Mp
			FLDOBJ_STA_BIT_MOVE_START );
	
	FieldOBJ_StatusBit_OFF( fldobj,
			FLDOBJ_STA_BIT_PAUSE_MOVE |
			FLDOBJ_STA_BIT_VANISH |
			FLDOBJ_STA_BIT_DRAW_PROC_INIT_COMP |
			FLDOBJ_STA_BIT_JUMP_START |
			FLDOBJ_STA_BIT_JUMP_END |
			FLDOBJ_STA_BIT_MOVE_END |
			FLDOBJ_STA_BIT_FELLOW_HIT_NON |
			FLDOBJ_STA_BIT_TALK_OFF |
			FLDOBJ_STA_BIT_DRAW_PUSH |
			FLDOBJ_STA_BIT_BLACT_ADD_PRAC |
			FLDOBJ_STA_BIT_HEIGHT_GET_OFF );
	
	FldOBJ_DrawEffectFlagInit( fldobj );
}

//--------------------------------------------------------------
/**
 * f[^[h̍WA
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_DataLoadPosRecover( FIELD_OBJ_PTR fldobj )
{
	int pos;
	VecFx32 vec;
	
	FieldOBJ_VecPosGet( fldobj, &vec );

//	OS_Printf("recover_y:%x\n",vec.y);
	
	pos = FieldOBJ_NowPosGX_Get( fldobj );
	vec.x = GRID_SIZE_FX32( pos ) + FLDOBJ_VEC_X_GRID_OFFS_FX32;
	FieldOBJ_OldPosGX_Set( fldobj, pos );

	pos = FieldOBJ_NowPosGY_Get( fldobj );
//	vec.y = H_GRID_SIZE_FX32( pos ) + FLDOBJ_VEC_Y_GRID_OFFS_FX32;	<<[hɒlZbgĂ͂
	FieldOBJ_OldPosGY_Set( fldobj, pos );
	
	pos = FieldOBJ_NowPosGZ_Get( fldobj );
	vec.z = GRID_SIZE_FX32( pos ) + FLDOBJ_VEC_Z_GRID_OFFS_FX32;
	FieldOBJ_OldPosGZ_Set( fldobj, pos );
	
	FieldOBJ_VecPosSet( fldobj, &vec );
}

//==============================================================================
//	tB[hOBJ o^
//==============================================================================
#if 0	//p

//--------------------------------------------------------------
///	FieldOBJ_AddFile()Ńt@Cǂݍ݂Ŏgpobt@TCY
//--------------------------------------------------------------
#define FLDOBJ_FILE_1LINE_BUF (96)

//--------------------------------------------------------------
/**
 * tB[hOBJ@t@Cwɂ镡o^
 * @param	sys			FIELD_OBJ_SYS_PTR 
 * @param	zone		ǉ][ID
 * @param	name		FIELD_OBJ_HLqꂽt@C
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_AddFile( CONST_FIELD_OBJ_SYS_PTR sys, int zone, const char *name )
{
	int i,max;
	char *file,*f_pos;
	char buf[FLDOBJ_FILE_1LINE_BUF];
	FIELD_OBJ_H *head;
	FIELD_OBJ_H_LOAD_FILE *load;
	
	if( name == NULL ){
		return;
	}
	
	file = sys_LoadFile( HEAPID_WORLD, name );
	GF_ASSERT( file != NULL && "fieldobj add file alloc error" );
	
	StrTok( file, buf, ',' );								//o^
	max = AtoI( buf );
	
	OS_Printf( "fieldobj add file load %d\n", max );
	
	head = sys_AllocMemoryLo( HEAPID_WORLD, FIELD_OBJ_H_SIZE * max );
	GF_ASSERT( head != NULL && "fieldobj add file head alloc error" );
	
	f_pos = StrTok( file, buf, RETURN_CODE );				//1s΂
	f_pos = StrTok( f_pos, buf, RETURN_CODE );				//i΂
	
	for( i = 0; i < max; i++ ){
		f_pos = StrTok( f_pos, buf, ',' );					//ID擾
		FieldOBJ_H_IDSet( &head[i], AtoI(buf) );
		f_pos = StrTok( f_pos, buf, RETURN_CODE );			//1s΂
		
		f_pos = StrTok( f_pos, buf, ',' );					//OBJR[h擾
		FieldOBJ_H_OBJCodeSet( &head[i], AtoI(buf) );
		f_pos = StrTok( f_pos, buf, RETURN_CODE );			//1s΂
		
		f_pos = StrTok( f_pos, buf, ',' );					//R[h擾
		FieldOBJ_H_MoveCodeSet( &head[i], AtoI(buf) );
		f_pos = StrTok( f_pos, buf, RETURN_CODE );			//1s΂
		
		f_pos = StrTok( f_pos, buf, ',' );					//Cxg^Cv擾
		FieldOBJ_H_EventTypeSet( &head[i], AtoI(buf) );
		f_pos = StrTok( f_pos, buf, RETURN_CODE );			//1s΂
		
		f_pos = StrTok( f_pos, buf, ',' );					//CxgtO擾
		FieldOBJ_H_EventFlagSet( &head[i], AtoI(buf) );
		f_pos = StrTok( f_pos, buf, RETURN_CODE );			//1s΂
		
		f_pos = StrTok( f_pos, buf, ',' );					//CxgID擾
		FieldOBJ_H_EventIDSet( &head[i], AtoI(buf) );
		f_pos = StrTok( f_pos, buf, RETURN_CODE );			//1s΂
		
		f_pos = StrTok( f_pos, buf, ',' );					//擾
		FieldOBJ_H_DirSet( &head[i], AtoI(buf) );
		f_pos = StrTok( f_pos, buf, RETURN_CODE );			//1s΂
		
		f_pos = StrTok( f_pos, buf, ',' );					//p^擾
		FieldOBJ_H_ParamSet( &head[i], AtoI(buf) );
		f_pos = StrTok( f_pos, buf, RETURN_CODE );			//1s΂
		
		f_pos = StrTok( f_pos, buf, ',' );					//ړX擾
		FieldOBJ_H_MoveLimitXSet( &head[i], AtoI(buf) );
		
		f_pos = StrTok( f_pos, buf, ',' );					//ړZ擾
		FieldOBJ_H_MoveLimitZSet( &head[i], AtoI(buf) );
		f_pos = StrTok( f_pos, buf, RETURN_CODE );			//1s΂
		
		f_pos = StrTok( f_pos, buf, ',' );					//XW擾
		FieldOBJ_H_PosXSet( &head[i], AtoI(buf) );
		
		f_pos = StrTok( f_pos, buf, ',' );					//ZW擾
		FieldOBJ_H_PosZSet( &head[i], AtoI(buf) );
		f_pos = StrTok( f_pos, buf, RETURN_CODE );			//1s΂
		
		f_pos = StrTok( f_pos, buf, ',' );					//YW擾
		FieldOBJ_H_PosYSet( &head[i], AtoI(buf) );
		f_pos = StrTok( f_pos, buf, RETURN_CODE );			//s΂
		
		f_pos = StrTok( f_pos, buf, RETURN_CODE );			//i΂
	}
	
	sys_FreeMemory( HEAPID_WORLD, file );
	
	load = sys_AllocMemoryLo( HEAPID_WORLD, FIELD_OBJ_H_LOAD_FILE_SIZE );
	GF_ASSERT( load != NULL && "fieldobj add file work alloc error" );
	
	load->zone = zone;
	load->add_max = max;
	load->add_count = 0;
	load->sys = sys;
	load->head = head;
	
	FldOBJ_AddFileProc( load );
	
	OS_Printf( "fieldobj add file load OK\n" );
}
#endif

//--------------------------------------------------------------
/**
 * tB[hOBJ@oCiwɂ镡o^
 * @param	sys			FIELD_OBJ_SYS_PTR 
 * @param	zone		ǉ][ID
 * @param	max			ǉő吔
 * @param	bin			ǉFIELD_OBJ_HzuĂoCi*
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_AddBin( CONST_FIELD_OBJ_SYS_PTR sys, int zone, int max, const FIELD_OBJ_H *bin )
{
	int size;
	FIELD_OBJ_H *head;
	FIELD_OBJ_H_LOAD_FILE *load;
	
	OS_Printf( "tB[hOBJ ꊇo^Jn zu %d\n", max );
	GF_ASSERT( max && "FieldOBJ_AddBin()@wő吔ُ" );
	
	size = FIELD_OBJ_H_SIZE *max;
	head = sys_AllocMemoryLo( HEAPID_WORLD, size );
	GF_ASSERT( head != NULL && "fieldobj add bin head alloc error" );
	memcpy( head, bin, size );
	
	load = sys_AllocMemoryLo( HEAPID_WORLD, FIELD_OBJ_H_LOAD_FILE_SIZE );
	GF_ASSERT( load != NULL && "fieldobj add file work alloc error" );
	
	load->zone = zone;
	load->add_max = max;
	load->add_count = 0;
	load->sys = sys;
	load->head = head;
	
	FldOBJ_AddFileProc( load );
	
	OS_Printf( "tB[hOBJ ꊇo^I\n" );
}

//--------------------------------------------------------------
/**
 * tB[hOBJꊇo^
 * @param	work	FIELD_OBJ_H_LOAD_FILE
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_AddFileProc( FIELD_OBJ_H_LOAD_FILE *work )
{
	FIELD_OBJ_PTR fldobj;
	FIELDSYS_WORK *fsys;
	const FIELD_OBJ_H *head;
	
	fsys = FieldOBJSys_FieldSysWorkGet( work->sys );
	head = work->head;
	
	do{
		if( FldOBJ_H_AliesCheck(head) == TRUE ||
			CheckEventFlag(fsys,head->event_flag) == FALSE ){
			fldobj = FieldOBJ_AddH( work->sys, head, work->zone );
			GF_ASSERT( fldobj != NULL && "tB[hOBJ̈ꊇo^Ɏs܂\n" );
		}
#ifdef PM_DEBUG
		else{
			OS_Printf( "tB[hOBJꊇo^cCxgtOFALSËׁA" );
			OS_Printf( "OBJ ID=%d,",FieldOBJ_H_IDGet(head) );
			OS_Printf( "GIRD X=%d,",FieldOBJ_H_PosXGet(head) );
			OS_Printf( "GIRD Z=%d",FieldOBJ_H_PosZGet(head) );
			OS_Printf( "ɔzuOBJ̒ǉ𖳎܂\n" );
		}
#endif
		head++;
		work->add_count++;
	}while( work->add_count < work->add_max );
	
	sys_FreeMemory( HEAPID_WORLD, work->head );
	sys_FreeMemory( HEAPID_WORLD, work );
}

#if 0	//Ł@GCAXł̃oO
static void FldOBJ_AddFileProc( FIELD_OBJ_H_LOAD_FILE *work )
{
	FIELD_OBJ_PTR fldobj;
	FIELDSYS_WORK *fsys;
	const FIELD_OBJ_H *head;
	
	fsys = FieldOBJSys_FieldSysWorkGet( work->sys );
	head = work->head;
	
	do{
		if( CheckEventFlag(fsys,head->event_flag) == FALSE ){
			fldobj = FieldOBJ_AddH( work->sys, head, work->zone );
			GF_ASSERT( fldobj != NULL && "tB[hOBJ̈ꊇo^Ɏs܂\n" );
		}else{
			OS_Printf( "tB[hOBJꊇo^cCxgtOFALSËׁA" );
			OS_Printf( "OBJ ID=%d,",FieldOBJ_H_IDGet(head) );
			OS_Printf( "GIRD X=%d,",FieldOBJ_H_PosXGet(head) );
			OS_Printf( "GIRD Z=%d",FieldOBJ_H_PosZGet(head) );
			OS_Printf( "ɔzuOBJ̒ǉ𖳎܂\n" );
		}
	
		head++;
		work->add_count++;
	}while( work->add_count < work->add_max );
	
	sys_FreeMemory( HEAPID_WORLD, work->head );
	sys_FreeMemory( HEAPID_WORLD, work );
}
#endif

//==============================================================================
//	tB[hOBJ@p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hOBJ̋󂫂T
 * @param	sys			FIELD_OBJ_SYS_PTR 
 * @retval	FIELD_OBJ	󂫂FIELD_OBJ*@󂫂ꍇNULL
 */
//--------------------------------------------------------------
static FIELD_OBJ_PTR  FldOBJ_SpaceSearch( CONST_FIELD_OBJ_SYS_PTR sys )
{
	int i,max;
	FIELD_OBJ_PTR fldobj;
	
	i = 0;
	max = FieldOBJSys_OBJMaxGet( sys );
	fldobj = FieldOBJSys_FldOBJWorkGet( sys );
	
	do{
		if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_USE) == 0 ){
			return( fldobj );
		}
		
		fldobj++;
		i++;
	}while( i < max );
	
	return( NULL );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ@GCAXT
 * @param	fos			FIELD_OBJ_SYS_PTR
 * @param	obj_id		vOBJ ID
 * @param	zone_id		vZONE ID
 * @retval	FIELD_OBJ	vFIELD_OBJ*@v=NULL
 */
//--------------------------------------------------------------
static FIELD_OBJ_PTR FldOBJ_AliesSearch( CONST_FIELD_OBJ_SYS_PTR fos, int obj_id, int zone_id )
{
	int no = 0;
	FIELD_OBJ_PTR fldobj;
	
	while( FieldOBJSys_FieldOBJSearch(fos,&fldobj,&no,FLDOBJ_STA_BIT_USE) == TRUE ){
		if( FieldOBJ_StatusBitCheck_Alies(fldobj) == TRUE ){
			if( FieldOBJ_OBJIDGet(fldobj) == obj_id ){
				if( FieldOBJ_ZoneIDGetAlies(fldobj) == zone_id ){
					return( fldobj );
				}
			}
		}
	}
	
	return( NULL );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ@TCB֐ǉ
 * @param	sys		FIELD_OBJ_SYS*
 * @param	fldobj	FIELD_OBJ*
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_MoveTcbAdd( CONST_FIELD_OBJ_SYS_PTR sys, FIELD_OBJ_PTR fldobj )
{
	int pri,code;
	TCB_PTR tcb;
	
	pri = FieldOBJSys_TCBStandardPriorityGet( sys );
	code = FieldOBJ_MoveCodeGet( fldobj );
	
	if( code == MV_PAIR || code == MV_TR_PAIR ){
		pri += FLDOBJ_TCBPRI_OFFS_AFTER;
	}
	
	tcb = TCB_Add( FldOBJ_TCB_MoveProc, fldobj, pri );
	GF_ASSERT( tcb != NULL && "fldobj tcb not add error" );
	
	FieldOBJ_MoveTcbPtrSet( fldobj, tcb );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ@wb_[񔽉f
 * @param	fldobj		ݒ肷FIELD_OBJ_PTR 
 * @param	head		fZ߂FIELD_OBJ_H *
 * @param	fsys		FIELDSYS_WORK *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_AddHeaderSet(
		FIELD_OBJ_PTR fldobj, const FIELD_OBJ_H *head, FIELDSYS_WORK *fsys )
{
	FieldOBJ_OBJIDSet( fldobj, FieldOBJ_H_IDGet(head) );
	FieldOBJ_OBJCodeSet( fldobj,FldOBJ_OBJCodeWkOBJCodeConv(fsys,FieldOBJ_H_OBJCodeGet(head)) );
	FieldOBJ_MoveCodeSet( fldobj, FieldOBJ_H_MoveCodeGet(head) );
	FieldOBJ_EventTypeSet( fldobj, FieldOBJ_H_EventTypeGet(head) );
	FieldOBJ_EventFlagSet( fldobj, FieldOBJ_H_EventFlagGet(head) );
	FieldOBJ_EventIDSet( fldobj, FieldOBJ_H_EventIDGet(head) );
	FieldOBJ_DirHeaderSet( fldobj, FieldOBJ_H_DirGet(head) );
	FieldOBJ_ParamSet( fldobj, FieldOBJ_H_ParamGet(head,FLDOBJ_PARAM_0), FLDOBJ_PARAM_0 );
	FieldOBJ_ParamSet( fldobj, FieldOBJ_H_ParamGet(head,FLDOBJ_PARAM_1), FLDOBJ_PARAM_1 );
	FieldOBJ_ParamSet( fldobj, FieldOBJ_H_ParamGet(head,FLDOBJ_PARAM_2), FLDOBJ_PARAM_2 );
	FieldOBJ_MoveLimitXSet( fldobj, FieldOBJ_H_MoveLimitXGet(head) );
	FieldOBJ_MoveLimitZSet( fldobj, FieldOBJ_H_MoveLimitZGet(head) );
	
	FldOBJ_AddHeaderPosInit( fldobj, head );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ@Wn
 * @param	fldobj		FIELD_OBJ_PTR 
 * @param	head		fZ߂FIELD_OBJ_H *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_AddHeaderPosInit( FIELD_OBJ_PTR fldobj, const FIELD_OBJ_H *head )
{
	int pos;
	VecFx32 vec;
	
	pos = FieldOBJ_H_PosXGet( head );
	vec.x = GRID_SIZE_FX32( pos ) + FLDOBJ_VEC_X_GRID_OFFS_FX32;
	FieldOBJ_InitPosGX_Set( fldobj, pos );
	FieldOBJ_OldPosGX_Set( fldobj, pos );
	FieldOBJ_NowPosGX_Set( fldobj, pos );
	
	pos = FieldOBJ_H_PosYGet( head );							//posݒfx32^ŗB
	vec.y = (fx32)pos;
	pos = SIZE_H_GRID_FX32( pos );
	FieldOBJ_InitPosGY_Set( fldobj, pos );
	FieldOBJ_OldPosGY_Set( fldobj, pos );
	FieldOBJ_NowPosGY_Set( fldobj, pos );
	
	pos = FieldOBJ_H_PosZGet( head );
	vec.z = GRID_SIZE_FX32( pos ) + FLDOBJ_VEC_Z_GRID_OFFS_FX32;
	FieldOBJ_InitPosGZ_Set( fldobj, pos );
	FieldOBJ_OldPosGZ_Set( fldobj, pos );
	FieldOBJ_NowPosGZ_Set( fldobj, pos );
	
	FieldOBJ_VecPosSet( fldobj, &vec );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ@[N
 * @param	fldobj		FIELD_OBJ_PTR 
 * @param	sys			FIELD_OBJ_SYS_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_WorkInit( FIELD_OBJ_PTR fldobj, CONST_FIELD_OBJ_SYS_PTR sys )
{
	FieldOBJ_StatusBit_ON( fldobj,
			FLDOBJ_STA_BIT_USE |							//gp
			FLDOBJ_STA_BIT_HEIGHT_GET_ERROR |				//擾Kvł
			FLDOBJ_STA_BIT_ATTR_GET_ERROR );				//Agr[g擾Kvł
	
	if( FieldOBJ_EventIDAliesCheck(fldobj) == TRUE ){
		FieldOBJ_StatusBitSet_Alies( fldobj, TRUE );
	}
	
	FieldOBJ_FieldOBJSysSet( fldobj, sys );
	FieldOBJ_DirDispSetForce( fldobj, FieldOBJ_DirHeaderGet(fldobj) );
	FieldOBJ_DirMoveSet( fldobj, FieldOBJ_DirHeaderGet(fldobj) );
	FieldOBJ_AcmdFree( fldobj );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ ֐
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_WorkInit_MoveProcInit( FIELD_OBJ_PTR fldobj )
{
	const FIELD_OBJ_MOVE_PROC_LIST *list;
	
	list = FldOBJ_MoveProcListGet( FieldOBJ_MoveCodeGet(fldobj) );
	FieldOBJ_MoveInitProcSet( fldobj, FldOBJ_MoveProcList_InitGet(list) );
	FieldOBJ_MoveProcSet( fldobj, FldOBJ_MoveProcList_MoveGet(list) );
	FieldOBJ_MoveDeleteProcSet( fldobj, FldOBJ_MoveProcList_DeleteGet(list) );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ `֐
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_WorkInit_DrawProcInit( FIELD_OBJ_PTR fldobj )
{
	const FIELD_OBJ_DRAW_PROC_LIST *list;
	u32 code = FieldOBJ_OBJCodeGet( fldobj );
	
	if( code == NONDRAW ){
		list = &DATA_FieldOBJDraw_Non;
	}else{
		list = FldOBJ_DrawProcListGet( code );
	}
	
	FieldOBJ_DrawInitProcSet( fldobj, FldOBJ_DrawProcList_InitGet(list) );
	FieldOBJ_DrawProcSet( fldobj, FldOBJ_DrawProcList_DrawGet(list) );
	FieldOBJ_DrawDeleteProcSet( fldobj, FldOBJ_DrawProcList_DeleteGet(list) );
	FieldOBJ_DrawPushProcSet( fldobj, FldOBJ_DrawProcList_PushGet(list) );
	FieldOBJ_DrawPopProcSet( fldobj, FldOBJ_DrawProcList_PopGet(list) );
}

//--------------------------------------------------------------
/**
 * [N
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_WorkClear( FIELD_OBJ_PTR fldobj )
{
	memset( fldobj, 0, FIELD_OBJ_SIZE );
}

//--------------------------------------------------------------
/**
 * w肳ꂽtB[hOBJGCAXw肩ǂ`FbN
 * @param	fldobj		FIELD_OBJ_PTR
 * @param	h_zone_id	headǂݍރ][ID
 * @param	max			headvf
 * @param	head		FIELD_OBJ_H
 * @retval	int			RET_ALIES_NOT
 */
//--------------------------------------------------------------
static int FldOBJ_HeaderAliesCheck(
		CONST_FIELD_OBJ_PTR fldobj, int h_zone_id, int max, const FIELD_OBJ_H *head )
{
	int obj_id;
	int zone_id;
	
	while( max ){
		obj_id = FieldOBJ_H_IDGet( head );
		
		if( FieldOBJ_OBJIDGet(fldobj) == obj_id ){					//IDv
			if( FldOBJ_H_AliesCheck(head) == TRUE ){				//GCAXwb_[
				zone_id = FldOBJ_H_AliesZoneIDGet( head );			//GCAX̐K][ID
				
				if( FieldOBJ_StatusBitCheck_Alies(fldobj) == TRUE ){	//ΏۃGCAX
					if( FieldOBJ_ZoneIDGetAlies(fldobj) == zone_id ){
						return( RET_ALIES_EXIST );						//AliesƂĊɑ
					}
				}else if( FieldOBJ_ZoneIDGet(fldobj) == zone_id ){
					return( RET_ALIES_CHANGE );							//AliesΏۂł
				}
			}else{														//ʏwb_[
				if( FieldOBJ_StatusBitCheck_Alies(fldobj) == TRUE ){
					if( FieldOBJ_ZoneIDGetAlies(fldobj) == h_zone_id ){	//GCAXƈv
						return( RET_ALIES_CHANGE );
					}
				}
			}
		}
		
		max--;
		head++;
	}
	
	return( RET_ALIES_NOT );
}

//--------------------------------------------------------------
/**
 * w肳ꂽ][IDOBJ IDFIELD_OBJ_PTR擾B
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	obj_id	OBJ ID
 * @param	zone_id	][ID
 * @retval	FIELD_OBJ_PTR FIELD_OBJ_PTR
 */
//--------------------------------------------------------------
static FIELD_OBJ_PTR FldOBJ_OBJIDZoneIDSearch(
		CONST_FIELD_OBJ_SYS_PTR fos, int obj_id, int zone_id )
{
	int no = 0;
	FIELD_OBJ_PTR fldobj;
	
	while( FieldOBJSys_FieldOBJSearch(fos,&fldobj,&no,FLDOBJ_STA_BIT_USE) == TRUE ){
		if( FieldOBJ_OBJIDGet(fldobj) == obj_id && FieldOBJ_ZoneIDGet(fldobj) == zone_id ){
			return( fldobj );
		}
	}
	
	return( NULL );
}

//--------------------------------------------------------------
/**
 * w肳ꂽ][ID̈ȊOSč폜
 * @param	fos			FIELD_OBJ_SYS_PTR
 * @param	zone_id		폜Ȃ][ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_DeleteAll_OldZoneID( FIELD_OBJ_SYS_PTR fos, u32 zone_id )
{
	u32 ret;
	int max = FieldOBJSys_OBJMaxGet( fos );
	FIELD_OBJ_PTR fldobj = FieldOBJSys_FldOBJWorkGet( fos );
	
	do{
		if( FieldOBJ_StatusBitCheck_Use(fldobj) == TRUE ){
			if( FieldOBJ_ZoneIDGet(fldobj) != zone_id ){
				if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_ZONE_DEL_NOT) == FALSE ){
					FieldOBJ_Delete( fldobj );
				}
			}
		}
		
		fldobj++;
		max--;
	}while( max );
}

//--------------------------------------------------------------
/**
 * OBJ IDɈvFIELD_OBJ_PTR
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	id		OBJ ID
 * @retval	FIELD_OBJ_PTR	NULL=݂Ȃ
 */
//--------------------------------------------------------------
FIELD_OBJ_PTR FieldOBJSys_OBJIDSearch( CONST_FIELD_OBJ_SYS_PTR fos, int id )
{
	int max;
	FIELD_OBJ_PTR fldobj;
	
	GF_ASSERT( fos != NULL && "FieldOBJSys_OBJIDSearch() NULLwł" );
	
	max = FieldOBJSys_OBJMaxGet( fos );
	fldobj = FldOBJSys_FieldOBJWorkGet( fos );
	
	do{
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_USE) == TRUE ){
			if( FieldOBJ_StatusBitCheck_Alies(fldobj) == FALSE ){
				if( FieldOBJ_OBJIDGet(fldobj) == id ){
					return( fldobj );
				}
			}
		}
		
		fldobj++;
		max--;
	}while( max > 0 );
	
	return( NULL );
}

//--------------------------------------------------------------
/**
 * R[hɈvFIELD_OBJ_PTR
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	mv_code		铮R[h
 * @retval	FIELD_OBJ_PTR	NULL=݂Ȃ
 */
//--------------------------------------------------------------
FIELD_OBJ_PTR FieldOBJSys_MoveCodeSearch( CONST_FIELD_OBJ_SYS_PTR fos, int mv_code )
{
	int max;
	FIELD_OBJ_PTR fldobj;
	
	max = FieldOBJSys_OBJMaxGet( fos );
	fldobj = FldOBJSys_FieldOBJWorkGet( fos );
	
	do{
		if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_USE) == TRUE ){
			if( FieldOBJ_MoveCodeGet(fldobj) == mv_code ){
				return( fldobj );
			}
		}
		
		fldobj++;
		max--;
	}while( max > 0 );
	
	return( NULL );
}

FIELD_OBJ_PTR FieldOBJSys_OBJIDMoveCodeSearch( CONST_FIELD_OBJ_SYS_PTR fos, int o, int m )
{
	return( NULL );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ[N
 * @param	fos			FIELD_OBJ_SYS_PTR
 * @param	fldobj		YFIELD_OBJ_PTRi[
 * @param	no			Jn[NnoB̊֐߂ہAʒu+1̒lɂȂ
 * @param	check_bit	Xe[^XrbgBFLDOBJ_STA_BIT_USE
 * @retval	int			TRUE=v FALSE=vȂ
 */
//--------------------------------------------------------------
int FieldOBJSys_FieldOBJSearch(
	CONST_FIELD_OBJ_SYS_PTR fos, FIELD_OBJ_PTR *fldobj, int *no, u32 check_bit )
{
	int max;
	FIELD_OBJ_PTR check_obj;
	
	max = FieldOBJSys_OBJMaxGet( fos );
	
	if( (*no) >= max ){
		return( FALSE );
	}
	
	check_obj = FldOBJSys_FieldOBJWorkGet( fos );
	check_obj = &check_obj[(*no)];
	
	do{
		(*no)++;
		
		if( FieldOBJ_StatusBit_Check(check_obj,check_bit) == check_bit ){
			*fldobj = check_obj;
			return( TRUE );
		}
		
		check_obj++;
	}while( (*no) < max );
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ`揉ɍs
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_DrawInitStatusSet( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_MOVE_START );
	FldOBJ_DrawEffectFlagInit( fldobj );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ֘AGtFNg̃tOB
 * GtFNg֘ÃtO܂Ƃ߂
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_DrawEffectFlagInit( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_StatusBit_OFF( fldobj,
		FLDOBJ_STA_BIT_SHADOW_SET		|
		FLDOBJ_STA_BIT_SHADOW_VANISH	|
		FLDOBJ_STA_BIT_EFFSET_SHOAL		|
		FLDOBJ_STA_BIT_REFLECT_SET );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ`폜ɍs
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_DrawDeleteStatusSet( FIELD_OBJ_PTR fldobj )
{
}

//--------------------------------------------------------------
/**
 * w肳ꂽOBJR[h[NQƌ^Ȃ΃[NOBJR[hɕύXB
 * Ⴄꍇ͂̂܂܂ŕԂB
 * @param	fsys	FIELDSYS_WORK *
 * @param	code	OBJR[hBHERO
 * @retval	int		`FbNꂽOBJR[h
 */
//--------------------------------------------------------------
static int FldOBJ_OBJCodeWkOBJCodeConv( FIELDSYS_WORK *fsys, int code )
{
	if( code >= WKOBJCODE_ORG && code <= WKOBJCODE_END ){
		code -= WKOBJCODE_ORG;
		code = GetEvDefineObjCode( fsys, code );
	}
	
	return( code );
}

//--------------------------------------------------------------
/**
 * ݔĂtB[hOBJOBJR[hQ
 * @param	fldobj		FIELD_OBJ_PTR 
 * @param	code		`FbNR[hBHERO
 * @retval	int			TRUE=fldobjȊOɂcodeĂz
 */
//--------------------------------------------------------------
int FieldOBJ_OBJCodeUseSearch( CONST_FIELD_OBJ_PTR fldobj, int code )
{
	CONST_FIELD_OBJ_SYS_PTR fos = FieldOBJ_FieldOBJSysGet( fldobj );
	int check_code,i = FieldOBJSys_OBJMaxGet( fos );
	CONST_FIELD_OBJ_PTR fieldobj = FieldOBJSys_FieldOBJWorkGet( fos );
	
	do{
		if( fieldobj != fldobj ){
			if( FieldOBJ_StatusBitCheck_Use(fieldobj) == TRUE ){
				check_code = FieldOBJ_OBJCodeGet( fieldobj );
					
				if( FieldOBJ_OBJCodeSeedCheck(check_code) == TRUE ){
					check_code = FieldOBJ_OBJCodeSeedGet( fieldobj );
				}
				
				if( check_code != OBJCODEMAX && check_code == code ){
					return( TRUE );
				}
			}
		}
		
		FieldOBJSys_FieldOBJWorkInc( &fieldobj );
		i--;
	}while( i );
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 *  FLDOBJ_STA_BIT_HEIGHT_GET_ERROROFF̏ꍇ͏Ȃ
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_HeightNeedCheckInit( FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_HEIGHT_GET_ERROR) ){
		FieldOBJ_VecPosNowHeightGetSet( fldobj );
	}
}

//--------------------------------------------------------------
/**
 * 쏉ɍsZ
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_MoveWorkInit( FIELD_OBJ_PTR fldobj )
{
	FldOBJ_WorkInit_MoveProcInit( fldobj );
	FieldOBJ_MoveInit( fldobj );
}

//--------------------------------------------------------------
/**
 * `揉ɍsZ
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_DrawWorkInit( FIELD_OBJ_PTR fldobj )
{
	CONST_FIELD_OBJ_SYS_PTR fos = FieldOBJ_FieldOBJSysGet( fldobj );
	
	if( FieldOBJSys_DrawInitCompCheck(fos) == FALSE ){		//`VXeĂȂ
		return;
	}
	
	FldOBJ_HeightNeedCheckInit( fldobj );
	FieldOBJ_DrawStatusSet( fldobj, 0 );
	FieldOBJ_BlActAddPracFlagSet( fldobj, FALSE );
	
	if( FieldOBJ_StatusBitCheck_DrawProcInitComp(fldobj) == FALSE ){
		FldOBJ_WorkInit_DrawProcInit( fldobj );
		FieldOBJ_DrawInitProcCall( fldobj );
		FieldOBJ_StatusBitON_DrawProcInitComp( fldobj );
	}
}

//--------------------------------------------------------------
/**
 * CxgIDGCAXǂ`FbN
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	int			TRUE=GCAXIDł FALSE=Ⴄ
 */
//--------------------------------------------------------------
int FieldOBJ_EventIDAliesCheck( CONST_FIELD_OBJ_PTR fldobj )
{
	u16 id = (u16)FieldOBJ_EventIDGet( fldobj );
	
	if( id == SP_SCRID_ALIES ){
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ@GCAX琳KOBJւ̕ύX
 * @param	fldobj		FIELD_OBJ_PTR 
 * @param	head		ΏۂFIELD_OBJ_H
 * @param	zone_id		K̃][ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_AliesOBJChange( FIELD_OBJ_PTR fldobj, const FIELD_OBJ_H *head, int zone_id )
{
	GF_ASSERT( FieldOBJ_StatusBitCheck_Alies(fldobj) == TRUE &&
			"FldOBJ_AliesOBJChange()aliesł͂Ȃ" );
	
	FieldOBJ_StatusBitSet_Alies( fldobj, FALSE );
	FieldOBJ_ZoneIDSet( fldobj, zone_id );
	FieldOBJ_EventIDSet( fldobj, FieldOBJ_H_EventIDGet(head) );
	FieldOBJ_EventFlagSet( fldobj, FieldOBJ_H_EventFlagGet(head) );
}	

//--------------------------------------------------------------
/**
 * tB[hOBJ@KOBJGCAXւ̕ύX
 * @param	fldobj		FIELD_OBJ_PTR 
 * @param	head		ΏۂFIELD_OBJ_H
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_OBJAliesChange( FIELD_OBJ_PTR fldobj, int zone_id, const FIELD_OBJ_H *head )
{
	GF_ASSERT( FldOBJ_H_AliesCheck(head) == TRUE && "FldOBJ_OBJAliesChange()aliesł͂Ȃ" );
	
	FieldOBJ_StatusBitSet_Alies( fldobj, TRUE );
	FieldOBJ_EventIDSet( fldobj, FieldOBJ_H_EventIDGet(head) );
	FieldOBJ_EventFlagSet( fldobj, FldOBJ_H_AliesZoneIDGet(head) );
	FieldOBJ_ZoneIDSet( fldobj, zone_id );
}

//--------------------------------------------------------------
/**
 * FIELD_OBJ_PTRTCBX^_[hvCIeB𒲐Ď擾
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	offset	X^_[hvCIeBɉZl
 * @retval	int		߂ꂽvCIeB
 */
//--------------------------------------------------------------
int FieldOBJ_TCBPriGet( CONST_FIELD_OBJ_PTR fldobj, int offset )
{
	int pri;
	
	pri = FieldOBJ_TCBStandardPriorityGet( fldobj );
	pri += offset;
	
	return( pri );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ̓`FbNB
 * SAւ肪Ă邩`FbNB
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	obj_id	Ƃ݂ȂOBJ ID
 * @param	zone_id	Ƃ݂ȂZONE ID
 * @retval	int		TRUE=BFALSE=ł͂Ȃ
 */
//--------------------------------------------------------------
int FieldOBJ_CheckSameID( CONST_FIELD_OBJ_PTR fldobj, int obj_id, int zone_id )
{
	if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_USE) == FALSE ){
		return( FALSE );
	}
	
	if( FieldOBJ_OBJIDGet(fldobj) != obj_id ){
		return( FALSE );
	}
	
	if( FieldOBJ_ZoneIDGet(fldobj) != zone_id ){
		if( FieldOBJ_StatusBitCheck_Alies(fldobj) == FALSE ){
			return( FALSE );
		}
		
		if( FieldOBJ_ZoneIDGetAlies(fldobj) != zone_id ){
			return( FALSE );
		}
	}
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ̓`FbNBOBJR[h܂
 * SAւ肪Ă邩`FbNB
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	code	Ƃ݂ȂOBJR[h
 * @param	obj_id	Ƃ݂ȂOBJ ID
 * @param	zone_id	Ƃ݂ȂZONE ID
 * @retval	int		TRUE=BFALSE=ł͂Ȃ
 */
//--------------------------------------------------------------
int FieldOBJ_CheckSameIDOBJCodeIn(
		CONST_FIELD_OBJ_PTR fldobj, int code, int obj_id, int zone_id )
{
	if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_USE) == FALSE ){
		return( FALSE );
	}
	
	{
		int ret = FieldOBJ_OBJCodeGetSeedIn( fldobj );
		
		if( ret != code ){
			return( FALSE );
		}
	}
	
	return( FieldOBJ_CheckSameID(fldobj,obj_id,zone_id) );
}

//==============================================================================
//	֐
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hOBJ TCB ֐
 * @param	tcb		TCB_PTR
 * @param	work	tcb work
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_TCB_MoveProc( TCB_PTR tcb, void *work )
{
	FIELD_OBJ_PTR fldobj = (FIELD_OBJ_PTR)work;
	
	FieldOBJ_Move( fldobj );
	
	if( FieldOBJ_StatusBitCheck_Use(fldobj) == FALSE ){
		return;
	}
	
	FldOBJ_TCB_DrawProc( fldobj );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ TCB ֐Ă΂`֐
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_TCB_DrawProc( FIELD_OBJ_PTR fldobj )
{
	CONST_FIELD_OBJ_SYS_PTR fos = FieldOBJ_FieldOBJSysGet(fldobj);
	
	if( FieldOBJSys_DrawInitCompCheck(fos) == TRUE ){
		FieldOBJ_Draw( fldobj );
	}
}

//==============================================================================
//	tB[hOBJVXe@Q
//==============================================================================
//--------------------------------------------------------------
/**
 * const FIELD_OBJ_SYSFIELD_OBJ_SYS
 * @param	sys		FIELD_OBJ_SYS_PTR 
 * @retval	FIELD_OBJ_SYS	FIELD_OBJ_SYS_PTR 
 */
//--------------------------------------------------------------
static FIELD_OBJ_SYS_PTR  FldOBJ_ConstSysLocalGet( CONST_FIELD_OBJ_SYS_PTR sys )
{
	return( (FIELD_OBJ_SYS_PTR )sys );
}

//--------------------------------------------------------------
/**
 * OBJo^\ő吔Zbg
 * @param	sys		FIELD_OBJ_SYS_PTR 
 * @param	max		ő吔
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_OBJMaxSet( FIELD_OBJ_SYS_PTR sys, int max )
{
	sys->fldobj_max = max;
}

//--------------------------------------------------------------
/**
 * OBJo^\ő吔擾
 * @param	sys		FIELD_OBJ_SYS_PTR 
 * @retval	int		OBJő吔
 */
//--------------------------------------------------------------
int FieldOBJSys_OBJMaxGet( CONST_FIELD_OBJ_SYS_PTR sys )
{
	return( sys->fldobj_max );
}

//--------------------------------------------------------------
/**
 * ݑ݂ĂOBJ̐1
 * @param	sys		FIELD_OBJ_SYS_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJSys_OBJCountInc( FIELD_OBJ_SYS_PTR sys )
{
	sys->fldobj_count++;
#ifdef DEBUG_PRINT_FLDOBJ_COUNT
	OS_Printf( "FIELD OBJ ADD, COUNT=0x%x\n", sys->fldobj_count );
#endif
}

//--------------------------------------------------------------
/**
 * ݑ݂ĂOBJ̐1炷
 * @param	sys		FIELD_OBJ_SYS_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJSys_OBJCountDec( FIELD_OBJ_SYS_PTR sys )
{
	sys->fldobj_count--;
#ifdef DEBUG_PRINT_FLDOBJ_COUNT
	OS_Printf( "FIELD OBJ DEL, COUNT=0x%x\n", sys->fldobj_count );
#endif
}

//--------------------------------------------------------------
/**
 * ݑ݂ĂOBJ̐Zbg
 * @param	sys		FIELD_OBJ_SYS_PTR 
 * @param	count	Zbg鐔
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJSys_OBJCountSet( FIELD_OBJ_SYS_PTR sys, int count )
{
	sys->fldobj_count = count;
}

//--------------------------------------------------------------
/**
 * ݑ݂ĂOBJ̐擾
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @retval	int		ݑ݂ĂOBJ̐
 */
//--------------------------------------------------------------
int FieldOBJSys_OBJCountGet( CONST_FIELD_OBJ_SYS_PTR fos )
{
	return( fos->fldobj_count );
}

//--------------------------------------------------------------
/**
 * VXe@Xe[^Xrbg
 * @param	sys		FIELD_OBJ_SYS_PTR 
 * @param	bit		lBFLDOBJSYS_STA_BIT_NON
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_StatusBit_Init( FIELD_OBJ_SYS_PTR sys, u32 bit )
{
	sys->status_bit = bit;
}

//--------------------------------------------------------------
/**
 * VXe@Xe[^Xrbg ON
 * @param	sys		FIELD_OBJ_SYS_PTR 
 * @param	bit		ONɂrbgBFLDOBJSYS_STA_BIT_NON
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_StatusBit_ON( FIELD_OBJ_SYS_PTR sys, u32 bit )
{
	sys->status_bit |= bit;
}

//--------------------------------------------------------------
/**
 * VXe@Xe[^Xrbg OFF
 * @param	sys		FIELD_OBJ_SYS_PTR 
 * @param	bit		OFFɂrbgBFLDOBJSYS_STA_BIT_NON
 * @retval	int		ǉĂOBJ
 */
//--------------------------------------------------------------
void FieldOBJSys_StatusBit_OFF( FIELD_OBJ_SYS_PTR sys, u32 bit )
{
	sys->status_bit &= ~bit;
}

//--------------------------------------------------------------
/**
 * VXe@Xe[^Xrbg `FbN
 * ߂l̓Xe[^Xrbgƃ`FbNrbgandlԂB
 * FΏ FIDOBJSYS_STR_BIT_DRAW_INIT_COMPȊOOFFB
 * `FbNrbgFLDOBJSYS_STA_BIT_DRAW_INIT_COMP|FLDOBJSYS_STA_BIT_MOVE_PROC_STOP
 * ߂lFLDOBJSYS_STA_BIT_DRAW_PROC_INITԂB
 * @param	sys				FIELD_OBJ_SYS_PTR 
 * @param	bit				`FbNrbgBFLDOBJ_STA_BIT_USE
 * @retval	u32				`FbÑrbg
 */
//--------------------------------------------------------------
u32 FieldOBJSys_StatusBit_Check( CONST_FIELD_OBJ_SYS_PTR sys, u32 bit )
{
	return( (sys->status_bit&bit) );
}

//--------------------------------------------------------------
/**
 * TCB{vCIeBZbg
 * @param	sys				FIELD_OBJ_SYS_PTR 
 * @param	pri				TCB{vCIeB
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_TCBStandardPrioritySet( FIELD_OBJ_SYS_PTR sys, int pri )
{
	sys->tcb_pri = pri;
}

//--------------------------------------------------------------
/**
 * TCB{vCIeB擾
 * @param	sys			FIELD_OBJ_SYS_PTR 
 * @retval	u32			TCBvCIeB
 */
//--------------------------------------------------------------
int FieldOBJSys_TCBStandardPriorityGet( CONST_FIELD_OBJ_SYS_PTR sys )
{
	return( sys->tcb_pri );
}

//--------------------------------------------------------------
/**
 * FIELD_OBJ_BLACT_CONT *擾
 * @param	sys		FIELD_OBJ_SYS_PTR 
 * @retval	FIELD_OBJ_BLACT_CONT	FIELD_OBJ_BLACT_CONT *
 */
//--------------------------------------------------------------
FIELD_OBJ_BLACT_CONT * FieldOBJSys_BlActContGet( CONST_FIELD_OBJ_SYS_PTR sys )
{
	return( &(((FIELD_OBJ_SYS_PTR)sys)->blact_cont) );
}

//--------------------------------------------------------------
/**
 * FIELD_OBJ_RENDER_CONT_PTRZbg
 * @param	sys		FIELD_OBJ_SYS_PTR 
 * @param	render	FIELD_OBJ_RENDER_CONT_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_RenderContSet( FIELD_OBJ_SYS_PTR sys, FIELD_OBJ_RENDER_CONT_PTR render )
{
	sys->render_cont = render;
}

//--------------------------------------------------------------
/**
 * FIELD_OBJ_RENDER_CONT_PTR 擾
 * @param	sys		FIELD_OBJ_SYS_PTR 
 * @retval	FIELD_OBJ_RENDER_CONT_PTR FIELD_OBJ_RENDER_CONT_PTR
 */
//--------------------------------------------------------------
FIELD_OBJ_RENDER_CONT_PTR FieldOBJSys_RenderContGet( CONST_FIELD_OBJ_SYS_PTR sys )
{
	return( sys->render_cont );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ[NZbg
 * @param	sys		FIELD_OBJ_SYS_PTR 
 * @param	ptr		FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_FieldOBJWorkSet( FIELD_OBJ_SYS_PTR sys, FIELD_OBJ_PTR ptr )
{
	sys->fldobj_work = ptr;
}

//--------------------------------------------------------------
/**
 * tB[hOBJ[N擾
 * @param	sys			FIELD_OBJ_SYS_PTR 
 * @retval	FIELD_OBJ	FIELD_OBJ_PTR 
 */
//--------------------------------------------------------------
CONST_FIELD_OBJ_PTR  FieldOBJSys_FieldOBJWorkGet( CONST_FIELD_OBJ_SYS_PTR sys )
{
	return( sys->fldobj_work );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ[N擾@[J
 * @param	sys			FIELD_OBJ_SYS_PTR 
 * @retval	FIELD_OBJ	FIELD_OBJ_PTR 
 */
//--------------------------------------------------------------
static FIELD_OBJ_PTR FldOBJSys_FieldOBJWorkGet( CONST_FIELD_OBJ_SYS_PTR sys )
{
	return( sys->fldobj_work );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ[N擾@FIELD OBJ[Jp
 * constBtB[hOBJȊO͎gp֎~
 * @param	sys			FIELD_OBJ_SYS_PTR 
 * @retval	FIELD_OBJ	FIELD_OBJ_PTR 
 */
//--------------------------------------------------------------
FIELD_OBJ_PTR  FieldOBJSys_FldOBJWorkGet( CONST_FIELD_OBJ_SYS_PTR sys )
{
	return( sys->fldobj_work );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ[NisB
 * FieldOBJSys_FieldOBJWorkGet()Ŏ擾|C^Pi߂B
 * @param	FIELD_OBJ	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_FieldOBJWorkInc( CONST_FIELD_OBJ_PTR *fldobj )
{
	(*fldobj)++;
}

//--------------------------------------------------------------
/**
 * tB[hOBJ[NisBconst
 * FieldOBJSys_FieldOBJWorkGet()Ŏ擾|C^Pi߂B
 * @param	FIELD_OBJ	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_FldOBJWorkInc( FIELD_OBJ_PTR *fldobj )
{
	(*fldobj)++;
}

//--------------------------------------------------------------
/**
 * FIELDSYS_WORK *Zbg
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	fsys	FIELDSYS_WORK *
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_FieldSysWorkSet( FIELD_OBJ_SYS_PTR fos, FIELDSYS_WORK *fsys )
{
	fos->fieldsys = fsys;
}

//--------------------------------------------------------------
/**
 * FIELDSYS_WORK *擾
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @retval	FIELDSYS_WORK	FIELDSYS_WORK *
 */
//--------------------------------------------------------------
FIELDSYS_WORK * FieldOBJSys_FieldSysWorkGet( CONST_FIELD_OBJ_SYS_PTR fos )
{
	return( fos->fieldsys );
}

//--------------------------------------------------------------
/**
 * A[JCunhZbg
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	handle	ARCHANDLE *
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_ArcHandleSet( FIELD_OBJ_SYS_PTR fos, ARCHANDLE *handle )
{
	fos->archandle = handle;
}

//--------------------------------------------------------------
/**
 * A[JCunh擾
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @retval	ARCHANDLE*@ARCHANDLE *
 */
//--------------------------------------------------------------
ARCHANDLE * FieldOBJSys_ArcHandleGet( CONST_FIELD_OBJ_SYS_PTR fos )
{
	GF_ASSERT( fos->archandle != NULL && "FieldOBJSys_ArcHandleGet()nh" );
	return( ((FIELD_OBJ_SYS_PTR)fos)->archandle );
}

//==============================================================================
//	tB[hOBJ@Q
//==============================================================================
//--------------------------------------------------------------
/**
 * Xe[^Xrbg
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	bit				lBFLDOBJ_STA_BIT_USE
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBit_Init( FIELD_OBJ_PTR fldobj, u32 bit )
{
	fldobj->status_bit = bit;
}

//--------------------------------------------------------------
/**
 * Xe[^Xrbg擾
 * @param	fldobj			FIELD_OBJ_PTR 
 * @retval	u32				Xe[^Xrbg
 */
//--------------------------------------------------------------
u32 FieldOBJ_StatusBit_Get( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->status_bit );
}

//--------------------------------------------------------------
/**
 * Xe[^Xrbg ON
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	bit				ONɂrbgBFLDOBJ_STA_BIT_USE
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBit_ON( FIELD_OBJ_PTR fldobj, u32 bit )
{
	fldobj->status_bit |= bit;
}

//--------------------------------------------------------------
/**
 * Xe[^Xrbg OFF
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	bit				OFFɂrbgBFLDOBJ_STA_BIT_USE
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBit_OFF( FIELD_OBJ_PTR fldobj, u32 bit )
{
	fldobj->status_bit &= ~bit;
}

//--------------------------------------------------------------
/**
 * Xe[^Xrbg `FbN
 * ߂l̓Xe[^Xrbgƃ`FbNrbgandlԂB
 * 
 * FΏOBJ̃Xe[^XrbgFIDOBJ_STR_BIT_USEȊOOFFB
 * `FbNrbgFLDOBJ_STA_BIT_USE|FLDOBJ_STA_BIT_MOVE_STARTB
 * ߂lFLDOBJ_STA_BIT_USEԂB
 * 
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	bit				`FbNrbgBFLDOBJ_STA_BIT_USE
 * @retval	u32				`FbÑrbg
 */
//--------------------------------------------------------------
u32 FieldOBJ_StatusBit_Check( CONST_FIELD_OBJ_PTR fldobj, u32 bit )
{
	return( fldobj->status_bit & bit );
}

//--------------------------------------------------------------
/**
 * Xe[^Xrbg ȈՃ`FbN
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	bit				`FbNrbgBFLDOBJ_STA_BIT_USE
 * @retval	u32				TRUE=bit̂ǂꂩYBFALSE=Y
 */
//--------------------------------------------------------------
u32 FieldOBJ_StatusBit_CheckEasy( CONST_FIELD_OBJ_PTR fldobj, u32 bit )
{
	if( (fldobj->status_bit&bit) ){
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * rbg@
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	bit		rbg FLDOBJ_MOVE_BIT_NON
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveBit_Init( FIELD_OBJ_PTR fldobj, u32 bit )
{
	fldobj->move_bit = bit;
}

//--------------------------------------------------------------
/**
 * rbg@擾
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	u32		rbg
 */
//--------------------------------------------------------------
u32 FieldOBJ_MoveBit_Get( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->move_bit );
}

//--------------------------------------------------------------
/**
 * rbg@ON
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	bit		Ărbg FLDOBJ_MOVE_BIT_NON
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveBit_ON( FIELD_OBJ_PTR fldobj, u32 bit )
{
	fldobj->move_bit |= bit;
}

//--------------------------------------------------------------
/**
 * rbg@OFF
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	bit		낷rbg FLDOBJ_MOVE_BIT_NON
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveBit_OFF( FIELD_OBJ_PTR fldobj, u32 bit )
{
	fldobj->move_bit &= ~bit;
}

//--------------------------------------------------------------
/**
 * rbg@`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	bit		`FbNrbg FLDOBJ_MOVE_BIT_NON
 * @retval	nothing
 */
//--------------------------------------------------------------
u32 FieldOBJ_MoveBit_Check( CONST_FIELD_OBJ_PTR fldobj, u32 bit )
{
	return( (fldobj->move_bit & bit) );
}

//--------------------------------------------------------------
/**
 * OBJ IDZbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	id		obj id
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_OBJIDSet( FIELD_OBJ_PTR fldobj, u32 obj_id )
{
	fldobj->obj_id = obj_id;
}

//--------------------------------------------------------------
/**
 * OBJ ID擾
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	u32		OBJ ID
 */
//--------------------------------------------------------------
u32 FieldOBJ_OBJIDGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->obj_id );
}

//--------------------------------------------------------------
/**
 * ZONE IDZbg
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	zone_id	][ID
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_ZoneIDSet( FIELD_OBJ_PTR fldobj, int zone_id )
{
	fldobj->zone_id = zone_id;
}

//--------------------------------------------------------------
/**
 * ZONE ID擾
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		ZONE ID
 */
//--------------------------------------------------------------
int FieldOBJ_ZoneIDGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->zone_id );
}

//--------------------------------------------------------------
/**
 * OBJR[hZbg
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	code			ZbgR[h
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_OBJCodeSet( FIELD_OBJ_PTR fldobj, u32 code )
{
	fldobj->obj_code = code;
}

//--------------------------------------------------------------
/**
 * OBJR[h擾
 * @param	fldobj			FIELD_OBJ_PTR 
 * @retval	u32				OBJR[h
 */
//--------------------------------------------------------------
u32 FieldOBJ_OBJCodeGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->obj_code );
}

//--------------------------------------------------------------
/**
 * OBJR[h擾@`FbN
 * @param	fldobj			FIELD_OBJ_PTR 
 * @retval	u32				OBJR[h
 */
//--------------------------------------------------------------
u32 FieldOBJ_OBJCodeGetSeedIn( CONST_FIELD_OBJ_PTR fldobj )
{
	u32 code = FieldOBJ_OBJCodeGet( fldobj );
	
	if( FieldOBJ_OBJCodeSeedCheck(code) == TRUE ){
		code = FieldOBJ_OBJCodeSeedGet( fldobj );
	}
	
	return( code );
}

//--------------------------------------------------------------
/**
 * R[hZbg
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	code			R[h
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveCodeSet( FIELD_OBJ_PTR fldobj, u32 code )
{
	fldobj->move_code = code;
}

//--------------------------------------------------------------
/**
 * R[h擾
 * @param	fldobj			FIELD_OBJ_PTR 
 * @retval	u32				R[h
 */
//--------------------------------------------------------------
u32 FieldOBJ_MoveCodeGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->move_code );
}

//--------------------------------------------------------------
/**
 * Cxg^CvZbg
 * @param	fldobj		FIELD_OBJ_PTR 
 * @param	type		Event Type
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_EventTypeSet( FIELD_OBJ_PTR fldobj, u32 type )
{
	fldobj->event_type = type;
}

//--------------------------------------------------------------
/**
 * Cxg^Cv擾
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	u32			Event Type
 */
//--------------------------------------------------------------
u32 FieldOBJ_EventTypeGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->event_type );
}

//--------------------------------------------------------------
/**
 * CxgtOZbg
 * @param	fldobj		FIELD_OBJ_PTR 
 * @param	flag		Event Flag
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_EventFlagSet( FIELD_OBJ_PTR fldobj, u32 flag )
{
	fldobj->event_flag = flag;
}

//--------------------------------------------------------------
/**
 * CxgtO擾
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	u32			Event Flag
 */
//--------------------------------------------------------------
u32 FieldOBJ_EventFlagGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->event_flag );
}

//--------------------------------------------------------------
/**
 * CxgIDZbg
 * @param	fldobj		FIELD_OBJ_PTR 
 * @param	id			Event ID
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_EventIDSet( FIELD_OBJ_PTR fldobj, u32 id )
{
	fldobj->event_id = id;
}

//--------------------------------------------------------------
/**
 * CxgID擾
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	u32			Event ID
 */
//--------------------------------------------------------------
u32 FieldOBJ_EventIDGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->event_id );
}

//--------------------------------------------------------------
/**
 * wb_[wZbg
 * @param	fldobj		FIELD_OBJ_PTR 
 * @param	dir			DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DirHeaderSet( FIELD_OBJ_PTR fldobj, int dir )
{
	fldobj->dir_head = dir;
}

//--------------------------------------------------------------
/**
 * wb_[w擾
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	u32			DIR_UP
 */
//--------------------------------------------------------------
u32 FieldOBJ_DirHeaderGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->dir_head );
}

//--------------------------------------------------------------
/**
 * \Zbg@
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	dir				DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DirDispSetForce( FIELD_OBJ_PTR fldobj, int dir )
{
	fldobj->dir_disp_old = fldobj->dir_disp;
	fldobj->dir_disp = dir;
}

//--------------------------------------------------------------
/**
 * \Zbg@FLDOBJ_STA_BIT_PAUSE_DIR`FbN
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	dir				DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DirDispCheckSet( FIELD_OBJ_PTR fldobj, int dir )
{
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_PAUSE_DIR) == 0 ){
		fldobj->dir_disp_old = fldobj->dir_disp;
		fldobj->dir_disp = dir;
	}
}

//--------------------------------------------------------------
/**
 * \擾
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	dir				DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
int FieldOBJ_DirDispGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->dir_disp );
}

//--------------------------------------------------------------
/**
 * ߋ\擾
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	dir				DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
int FieldOBJ_DirDispOldGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->dir_disp_old );
}

//--------------------------------------------------------------
/**
 * ړZbg
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	dir				DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DirMoveSet( FIELD_OBJ_PTR fldobj, int dir )
{
	fldobj->dir_move_old = fldobj->dir_move;
	fldobj->dir_move = dir;
}

//--------------------------------------------------------------
/**
 * ړ擾
 * @param	fldobj			FIELD_OBJ_PTR 
 * @retval	dir				DIR_UP
 */
//--------------------------------------------------------------
int FieldOBJ_DirMoveGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->dir_move );
}

//--------------------------------------------------------------
/**
 * ߋړ擾
 * @param	fldobj			FIELD_OBJ_PTR 
 * @retval	dir				DIR_UP
 */
//--------------------------------------------------------------
int FieldOBJ_DirMoveOldGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->dir_move_old );
}

//--------------------------------------------------------------
/**
 * \AړZbg@FLDOBJ_STA_BIT_PAUSE_DIR`FbN
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	dir				DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DirMoveDispCheckSet( FIELD_OBJ_PTR fldobj, int dir )
{
	FieldOBJ_DirDispCheckSet( fldobj, dir );
	FieldOBJ_DirMoveSet( fldobj, dir );
}

//--------------------------------------------------------------
/**
 * wb_[wp^Zbg
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	param			p^
 * @param	no				Zbgp^ԍ@FLDOBJ_PARAM_0
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_ParamSet( FIELD_OBJ_PTR fldobj, int param, FLDOBJ_H_PARAM no )
{
	switch( no ){
	case FLDOBJ_PARAM_0: fldobj->param0 = param; break;
	case FLDOBJ_PARAM_1: fldobj->param1 = param; break;
	case FLDOBJ_PARAM_2: fldobj->param2 = param; break;
	default: GF_ASSERT( 0 && "FieldOBJ_ParamSet()sȈ" );
	}
}

//--------------------------------------------------------------
/**
 * wb_[wp^擾
 * @param	fldobj			FIELD_OBJ_PTR
 * @param	param			FLDOBJ_PARAM_0
 * @retval	int				p^
 */
//--------------------------------------------------------------
int FieldOBJ_ParamGet( CONST_FIELD_OBJ_PTR fldobj, FLDOBJ_H_PARAM param )
{
	switch( param ){
	case FLDOBJ_PARAM_0: return( fldobj->param0 );
	case FLDOBJ_PARAM_1: return( fldobj->param1 );
	case FLDOBJ_PARAM_2: return( fldobj->param2 );
	}
	
	GF_ASSERT( 0 && "FieldOBJ_ParamGet()sȈ" );
	return( 0 );
}

//--------------------------------------------------------------
/**
 * ړXZbg
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	x				ړ
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveLimitXSet( FIELD_OBJ_PTR fldobj, int x )
{
	fldobj->move_limit_x = x;
}

//--------------------------------------------------------------
/**
 * ړX擾
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	int			ړX
 */
//--------------------------------------------------------------
int FieldOBJ_MoveLimitXGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->move_limit_x );
}

//--------------------------------------------------------------
/**
 * ړZZbg
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	y				ړ
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveLimitZSet( FIELD_OBJ_PTR fldobj, int z )
{
	fldobj->move_limit_z = z;
}

//--------------------------------------------------------------
/**
 * ړZ擾
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	int			ړz
 */
//--------------------------------------------------------------
int FieldOBJ_MoveLimitZGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->move_limit_z );
}

//--------------------------------------------------------------
/**
 * `Xe[^XZbg
 * @param	fldobj		FIELD_OBJ_PTR 
 * @param	st			DRAW_STA_STOP
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawStatusSet( FIELD_OBJ_PTR fldobj, u32 st )
{
	fldobj->draw_status = st;
}

//--------------------------------------------------------------
/**
 * `Xe[^X擾
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	u32			DRAW_STA_STOP
 */
//--------------------------------------------------------------
u32 FieldOBJ_DrawStatusGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->draw_status );
}

//--------------------------------------------------------------
/**
 * TCB*Zbg
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	tcb				TCB_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveTcbPtrSet( FIELD_OBJ_PTR fldobj, TCB_PTR tcb )
{
	fldobj->tcb = tcb;
}

//--------------------------------------------------------------
/**
 * TCB*擾
 * @param	fldobj			FIELD_OBJ_PTR 
 * @retval	TCB_PTR			TCB_PTR
 */
//--------------------------------------------------------------
TCB_PTR FieldOBJ_MoveTcbPtrGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->tcb );
}

//--------------------------------------------------------------
/**
 * TCB*폜
 * @param	fldobj			FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveTcbDelete( CONST_FIELD_OBJ_PTR fldobj )
{
	TCB_Delete( FieldOBJ_MoveTcbPtrGet(fldobj) );
}

//--------------------------------------------------------------
/**
 * FIELD_OBJ_SYS_PTR Zbg
 * @param	fldobj			FIELD_OBJ_PTR 
 * @param	sys				FIELD_OBJ_SYS_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_FieldOBJSysSet( FIELD_OBJ_PTR fldobj, CONST_FIELD_OBJ_SYS_PTR sys )
{
	fldobj->fldobj_sys = sys;
}

//--------------------------------------------------------------
/**
 * FIELD_OBJ_SYS_PTR 擾
 * @param	fldobj			FIELD_OBJ_PTR 
 * @retval	FIELD_OBJ_SYS	FIELD_OBJ_SYS_PTR 
 */
//--------------------------------------------------------------
CONST_FIELD_OBJ_SYS_PTR FieldOBJ_FieldOBJSysGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->fldobj_sys );
}

//--------------------------------------------------------------
/**
 * FIELD_OBJ_SYS_PTR  擾 not const
 * @param	fldobj			FIELD_OBJ_PTR 
 * @retval	FIELD_OBJ_SYS	FIELD_OBJ_SYS_PTR 
 */
//--------------------------------------------------------------
static FIELD_OBJ_SYS_PTR FldOBJ_FieldOBJSysGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( FldOBJ_ConstSysLocalGet(fldobj->fldobj_sys) );
}

//--------------------------------------------------------------
/**
 * ֐p[NB
 * size[NTCY𒴂ĂꍇAASSERTB
 * p[NsizeA0ŏB
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	size	Kvȃ[NTCY
 * @retval	void*	ꂽ[N
 */
//--------------------------------------------------------------
void * FieldOBJ_MoveProcWorkInit( FIELD_OBJ_PTR fldobj, int size )
{
	void *work;
	
	GF_ASSERT( size <= FLDOBJ_MOVE_WORK_SIZE && "fldobj move work size over" );
	
	work = FieldOBJ_MoveProcWorkGet( fldobj );
	memset( work, 0, size );
	
	return( work );
}

//--------------------------------------------------------------
/**
 * ֐p[N擾B
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	void*	[N
 */
//--------------------------------------------------------------
void * FieldOBJ_MoveProcWorkGet( FIELD_OBJ_PTR fldobj )
{
	return( fldobj->move_proc_work );
}

//--------------------------------------------------------------
/**
 * ⏕֐p[NB
 * size[NTCY𒴂ĂꍇAASSERTB
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	size	Kvȃ[NTCY
 * @retval	void*	ꂽ[N
 */
//--------------------------------------------------------------
void * FieldOBJ_MoveSubProcWorkInit( FIELD_OBJ_PTR fldobj, int size )
{
	u8 *work;
	
	GF_ASSERT( size <= FLDOBJ_MOVE_SUB_WORK_SIZE &&
			"tB[hOBJ ⏕[NTCYI[o[" );
	
	work = FieldOBJ_MoveSubProcWorkGet( fldobj );
	memset( work, 0, size );
	
	return( work );
}

//--------------------------------------------------------------
/**
 * ⏕֐p[N擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	void*	[N*
 */
//--------------------------------------------------------------
void * FieldOBJ_MoveSubProcWorkGet( FIELD_OBJ_PTR fldobj )
{
	return( fldobj->move_sub_proc_work );
}

//--------------------------------------------------------------
/**
 * ⏕֐p[NB
 * size[NTCY𒴂ĂꍇAASSERTB
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	size	Kvȃ[NTCY
 * @retval	void*	ꂽ[N
 */
//--------------------------------------------------------------
void * FieldOBJ_MoveCmdWorkInit( FIELD_OBJ_PTR fldobj, int size )
{
	u8 *work;
	
	GF_ASSERT( size <= FLDOBJ_MOVE_CMD_WORK_SIZE &&
			"tB[hOBJ R}h[NTCYI[o[" );
	
	work = FieldOBJ_MoveCmdWorkGet( fldobj );
	memset( work, 0, size );
	
	return( work );
}

//--------------------------------------------------------------
/**
 * R}hp[N擾
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	void*	[N*
 */
//--------------------------------------------------------------
void * FieldOBJ_MoveCmdWorkGet( FIELD_OBJ_PTR fldobj )
{
	return( fldobj->move_cmd_proc_work );
}

//--------------------------------------------------------------
/**
 * `֐p[NB
 * size[NTCY𒴂ĂꍇAASSERTB
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	size	Kvȃ[NTCY
 * @retval	void*	ꂽ[N
 */
//--------------------------------------------------------------
void * FieldOBJ_DrawProcWorkInit( FIELD_OBJ_PTR fldobj, int size )
{
	u8 *work;
	
	GF_ASSERT( size <= FLDOBJ_DRAW_WORK_SIZE && "fldobj draw work size over" );
	
	work = FieldOBJ_DrawProcWorkGet( fldobj );
	memset( work, 0, size );
	
	return( work );
}

//--------------------------------------------------------------
/**
 * `֐p[N擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	void*	[N
 */
//--------------------------------------------------------------
void * FieldOBJ_DrawProcWorkGet( FIELD_OBJ_PTR fldobj )
{
	return( fldobj->draw_proc_work );
}

//--------------------------------------------------------------
/**
 * ֐Zbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	init	֐
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveInitProcSet( FIELD_OBJ_PTR fldobj, FIELD_OBJ_MOVE_PROC_INIT init )
{
	fldobj->move_init_proc = init;
}

//--------------------------------------------------------------
/**
 * ֐s
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveInitProcCall( FIELD_OBJ_PTR fldobj )
{
	fldobj->move_init_proc( fldobj );
}

//--------------------------------------------------------------
/**
 * ֐Zbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	move	֐
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveProcSet( FIELD_OBJ_PTR fldobj, FIELD_OBJ_MOVE_PROC move )
{
	fldobj->move_proc = move;
}

//--------------------------------------------------------------
/**
 * ֐s
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveProcCall( FIELD_OBJ_PTR fldobj )
{
	fldobj->move_proc( fldobj );
}

//--------------------------------------------------------------
/**
 * 폜֐o^
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	del		֐
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveDeleteProcSet( FIELD_OBJ_PTR fldobj, FIELD_OBJ_MOVE_PROC_DEL del )
{
	fldobj->move_delete_proc = del;
}

//--------------------------------------------------------------
/**
 * 폜֐s
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveDeleteProcCall( FIELD_OBJ_PTR fldobj )
{
	fldobj->move_delete_proc( fldobj );
}

#if 0
//--------------------------------------------------------------
/**
 * A֐o^
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	del		֐
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveReturnProcSet( FIELD_OBJ_PTR fldobj, FIELD_OBJ_MOVE_PROC_RET ret )
{
	GF_ASSERT( 0 );
//	fldobj->move_return_proc = ret;
}
#endif

//--------------------------------------------------------------
/**
 * A֐s
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveReturnProcCall( FIELD_OBJ_PTR fldobj )
{
#if 0
	fldobj->move_return_proc( fldobj );
#else
	const FIELD_OBJ_MOVE_PROC_LIST *list =
		FldOBJ_MoveProcListGet( FieldOBJ_MoveCodeGet(fldobj) );
	list->return_proc( fldobj );
#endif
}

//--------------------------------------------------------------
/**
 * `揉֐o^
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	init	֐
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawInitProcSet( FIELD_OBJ_PTR fldobj, FIELD_OBJ_DRAW_PROC_INIT init )
{
	fldobj->draw_init_proc = init;
}

//--------------------------------------------------------------
/**
 * `揉֐s
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawInitProcCall( FIELD_OBJ_PTR fldobj )
{
	fldobj->draw_init_proc( fldobj );
}

//--------------------------------------------------------------
/**
 * `֐o^
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	draw	`֐
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawProcSet( FIELD_OBJ_PTR fldobj, FIELD_OBJ_DRAW_PROC draw )
{
	fldobj->draw_proc = draw;
}

//--------------------------------------------------------------
/**
 * `֐s
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawProcCall( FIELD_OBJ_PTR fldobj )
{
	fldobj->draw_proc( fldobj );
}

//--------------------------------------------------------------
/**
 * `폜֐o^
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	del		폜֐
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawDeleteProcSet( FIELD_OBJ_PTR fldobj, FIELD_OBJ_DRAW_PROC_DEL del )
{
	fldobj->draw_delete_proc = del;
}

//--------------------------------------------------------------
/**
 * `폜֐s
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawDeleteProcCall( FIELD_OBJ_PTR fldobj )
{
	fldobj->draw_delete_proc( fldobj );
}

//--------------------------------------------------------------
/**
 * `ޔ֐o^
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	push	ޔ֐
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawPushProcSet( FIELD_OBJ_PTR fldobj, FIELD_OBJ_DRAW_PROC_PUSH push )
{
	fldobj->draw_push_proc = push;
}

//--------------------------------------------------------------
/**
 * `ޔ֐s
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawPushProcCall( FIELD_OBJ_PTR fldobj )
{
	fldobj->draw_push_proc( fldobj );
}

//--------------------------------------------------------------
/**
 * `敜A֐o^
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	pop		ޔ֐
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawPopProcSet( FIELD_OBJ_PTR fldobj, FIELD_OBJ_DRAW_PROC_POP pop )
{
	fldobj->draw_pop_proc = pop;
}

//--------------------------------------------------------------
/**
 * `敜A֐s
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawPopProcCall( FIELD_OBJ_PTR fldobj )
{
	fldobj->draw_pop_proc( fldobj );
}

//--------------------------------------------------------------
/**
 * Aj[VR}hR[hZbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	code	AC_DIR_U
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_AcmdCodeSet( FIELD_OBJ_PTR fldobj, int code )
{
	fldobj->acmd_code = code;
}

//--------------------------------------------------------------
/**
 * Aj[VR}hR[h擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	int		AC_DIR_U
 */
//--------------------------------------------------------------
int FieldOBJ_AcmdCodeGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->acmd_code );
}

//--------------------------------------------------------------
/**
 * Aj[VR}hV[PXZbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	no		V[PX
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_AcmdSeqSet( FIELD_OBJ_PTR fldobj, int no )
{
	fldobj->acmd_seq = no;
}

//--------------------------------------------------------------
/**
 * Aj[VR}hV[PX
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_AcmdSeqInc( FIELD_OBJ_PTR fldobj )
{
	fldobj->acmd_seq++;
}

//--------------------------------------------------------------
/**
 * Aj[VR}hV[PX擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	int		V[PX
 */
//--------------------------------------------------------------
int FieldOBJ_AcmdSeqGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->acmd_seq );
}

//--------------------------------------------------------------
/**
 * ݂̃}bvAgr[gZbg
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	attr	ZbgAgr[g
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_NowMapAttrSet( FIELD_OBJ_PTR fldobj, u32 attr )
{
	fldobj->now_attr = attr;
}

//--------------------------------------------------------------
/**
 * ݂̃}bvAgr[g擾
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	u32		}bvAgr[g
 */
//--------------------------------------------------------------
u32 FieldOBJ_NowMapAttrGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->now_attr );
}

//--------------------------------------------------------------
/**
 * ߋ̃}bvAgr[gZbg
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	attr	ZbgAgr[g
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_OldMapAttrSet( FIELD_OBJ_PTR fldobj, u32 attr )
{
	fldobj->old_attr = attr;
}

//--------------------------------------------------------------
/**
 * ߋ̃}bvAgr[g擾
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	u32		}bvAgr[g
 */
//--------------------------------------------------------------
u32 FieldOBJ_OldMapAttrGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->old_attr );
}

//--------------------------------------------------------------
/**
 * FIELDSYS_WORK擾
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	FIELDSYS_WORK	FIELDSYS_WORK *
 */
//--------------------------------------------------------------
FIELDSYS_WORK * FieldOBJ_FieldSysWorkGet( CONST_FIELD_OBJ_PTR fldobj )
{
	FIELD_OBJ_SYS_PTR fos;
	
	fos = FldOBJ_FieldOBJSysGet( fldobj );
	return( FieldOBJSys_FieldSysWorkGet(fos) );
}

//--------------------------------------------------------------
/**
 * TCB{vCIeB擾
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TCB{vCIeB
 */
//--------------------------------------------------------------
int FieldOBJ_TCBStandardPriorityGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( FieldOBJSys_TCBStandardPriorityGet(FieldOBJ_FieldOBJSysGet(fldobj)) );
}

//--------------------------------------------------------------
/**
 * GCAX̃][ID擾BGCAX̓CxgtOw][ID
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		][ID
 */
//--------------------------------------------------------------
int FieldOBJ_ZoneIDGetAlies( CONST_FIELD_OBJ_PTR fldobj )
{
	GF_ASSERT( FieldOBJ_StatusBitCheck_Alies(fldobj) == TRUE &&
			"FieldOBJ_ZoneIDGetAlies()aliesł͖" );
	return( FieldOBJ_EventFlagGet(fldobj) );
}

//==============================================================================
//	tB[hOBJVXe@Xe[^XrbgȈ
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hOBJŜ̓S~B
 * 쏈A`揈S~BAj[VR}hɂȂB
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_MoveStopAll( FIELD_OBJ_SYS_PTR fos )
{
	FieldOBJSys_StatusBit_ON( fos,
		FLDOBJSYS_STA_BIT_MOVE_PROC_STOP | FLDOBJSYS_STA_BIT_DRAW_PROC_STOP );
	
	OS_Printf( "tB[hOBJŜ̓~܂\n" );
}

//--------------------------------------------------------------
/**
 * tB[hOBJŜ̓슮S~
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_MoveStopAllClear( FIELD_OBJ_SYS_PTR fos )
{
	FieldOBJSys_StatusBit_OFF( fos,
		FLDOBJSYS_STA_BIT_MOVE_PROC_STOP | FLDOBJSYS_STA_BIT_DRAW_PROC_STOP );
	
	OS_Printf( "tB[hOBJŜ̓~܂\n" );
}

//--------------------------------------------------------------
/**
 * tB[hOBJŜ̓ꎞ~
 * ŗL̓쏈i_ړjꎞ~B
 * Aj[VR}hɂ͔B
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_MovePauseAll( FIELD_OBJ_SYS_PTR fos )
{
	int max = FieldOBJSys_OBJMaxGet( fos );
	FIELD_OBJ_PTR fldobj = FieldOBJSys_FldOBJWorkGet( fos );
	
	do{
		if( FieldOBJ_StatusBitCheck_Use(fldobj) ){
			FieldOBJ_MovePause( fldobj );
		}
		
		fldobj++;
		max--;
	}while( max );
	
	OS_Printf( "tB[hOBJS̓|[Y܂\n" );
}

//--------------------------------------------------------------
/**
 * tB[hOBJS̓ꎞ~
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_MovePauseAllClear( FIELD_OBJ_SYS_PTR fos )
{
	int max = FieldOBJSys_OBJMaxGet( fos );
	FIELD_OBJ_PTR fldobj = FieldOBJSys_FldOBJWorkGet( fos );
	
	do{
		if( FieldOBJ_StatusBitCheck_Use(fldobj) ){
			FieldOBJ_MovePauseClear( fldobj );
		}
		
		fldobj++;
		max--;
	}while( max );
	
	OS_Printf( "tB[hOBJS̓|[Y܂\n" );
}

//--------------------------------------------------------------
/**
 * `揈Ă邩ǂ`FbN
 * @param	fos				FIELD_OBJ_SYS_PTR
 * @retval	int				TRUE=Ă
 */
//--------------------------------------------------------------
int FieldOBJSys_DrawInitCompCheck( CONST_FIELD_OBJ_SYS_PTR fos )
{
	if( FieldOBJSys_StatusBit_Check(fos,FLDOBJSYS_STA_BIT_DRAW_INIT_COMP) ){
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * tB[hOBJtB[hOBJVXẽrbg`FbN
 * @param	fldobj		FIELD_OBJ_PTR
 * @param	bit			FLDOBJSYS_STA_BIT_DRAW_INIT_COMP
 * @retval	u32			0ȊO bitqbg
 */
//--------------------------------------------------------------
u32 FieldOBJ_FieldOBJSysStatusBitCheck( CONST_FIELD_OBJ_PTR fldobj, u32 bit )
{
	CONST_FIELD_OBJ_SYS_PTR fos = FieldOBJ_FieldOBJSysGet( fldobj );
	return( FieldOBJSys_StatusBit_Check(fos,bit) );
}

//--------------------------------------------------------------
/**
 * etAtȂ̃Zbg
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	flag	TRUE=et FALSE=etȂ
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJSys_ShadowJoinSet( FIELD_OBJ_SYS_PTR fos, int flag )
{
	if( flag == FALSE ){
		FieldOBJSys_StatusBit_ON( fos, FLDOBJSYS_STA_BIT_SHADOW_JOIN_NOT );
	}else{
		FieldOBJSys_StatusBit_OFF( fos, FLDOBJSYS_STA_BIT_SHADOW_JOIN_NOT );
	}
}

//--------------------------------------------------------------
/**
 * etAtȂ̃`FbN
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @retval	int		FALSE=tȂ
 */
//--------------------------------------------------------------
int FieldOBJSys_ShadowJoinCheck( CONST_FIELD_OBJ_SYS_PTR fos )
{
	if( FieldOBJSys_StatusBit_Check(fos,FLDOBJSYS_STA_BIT_SHADOW_JOIN_NOT) ){
		return( FALSE );
	}
	
	return( TRUE );
}

//==============================================================================
//	tB[hOBJ Xe[^XrbgȈ
//==============================================================================
//--------------------------------------------------------------
/**
 * gp`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=gp
 */
//--------------------------------------------------------------
int FieldOBJ_StatusBitCheck_Use( CONST_FIELD_OBJ_PTR fldobj )
{
	return( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_USE) );
}

//--------------------------------------------------------------
/**
 * ړ쒆ɂ
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitON_Move( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_MOVE );
}

//--------------------------------------------------------------
/**
 * ړ쒆
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitOFF_Move( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_MOVE );
}

//--------------------------------------------------------------
/**
 * ړ쒆`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=쒆
 */
//--------------------------------------------------------------
int FieldOBJ_StatusBitCheck_Move( CONST_FIELD_OBJ_PTR fldobj )
{
	return( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_MOVE) );
}

//--------------------------------------------------------------
/**
 * ړJnɂ
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitON_MoveStart( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_MOVE_START );
}

//--------------------------------------------------------------
/**
 * ړJn
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitOFF_MoveStart( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_MOVE_START );
}

//--------------------------------------------------------------
/**
 * ړJn`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=ړJn
 */
//--------------------------------------------------------------
int FieldOBJ_StatusBitCheck_MoveStart( CONST_FIELD_OBJ_PTR fldobj )
{
	return( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_MOVE_START) );
}

//--------------------------------------------------------------
/**
 * ړIɂ
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitON_MoveEnd( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_MOVE_END );
}

//--------------------------------------------------------------
/**
 * ړI
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitOFF_MoveEnd( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_MOVE_END );
}

//--------------------------------------------------------------
/**
 * ړI`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=ړI
 */
//--------------------------------------------------------------
int FieldOBJ_StatusBitCheck_MoveEnd( CONST_FIELD_OBJ_PTR fldobj )
{
	return( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_MOVE_END) );
}

//--------------------------------------------------------------
/**
 * `揉ɂ
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitON_DrawProcInitComp( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_DRAW_PROC_INIT_COMP );
}

//--------------------------------------------------------------
/**
 * `揉
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitOFF_DrawProcInitComp( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_DRAW_PROC_INIT_COMP );
}

//--------------------------------------------------------------
/**
 * `揉`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=`揉
 */
//--------------------------------------------------------------
int FieldOBJ_StatusBitCheck_DrawProcInitComp( CONST_FIELD_OBJ_PTR fldobj )
{
	return( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_DRAW_PROC_INIT_COMP) );
}

//--------------------------------------------------------------
/**
 * \tO`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	flag	TRUE=\@FALSE=\
 * @retval	nothing
 */
//--------------------------------------------------------------
int FieldOBJ_StatusBitCheck_Vanish( CONST_FIELD_OBJ_PTR fldobj )
{
	return( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_VANISH) );
}

//--------------------------------------------------------------
/**
 * \tOݒ
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	flag	TRUE=\@FALSE=\
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitSet_Vanish( FIELD_OBJ_PTR fldobj, int flag )
{
	if( flag == TRUE ){
		FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_VANISH );
	}else{
		FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_VANISH );
	}
}

//--------------------------------------------------------------
/**
 * OBJm̓蔻tOݒ
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	flag	TRUE=qbgA@FALSE=qbgiV
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitSet_FellowHit( FIELD_OBJ_PTR fldobj, int flag )
{
	if( flag == TRUE ){
		FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_FELLOW_HIT_NON );
	}else{
		FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_FELLOW_HIT_NON );
	}
}

//--------------------------------------------------------------
/**
 * 쒆tÕZbg
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	flag	TRUE=쒆@FALSE=~
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitSet_Move( FIELD_OBJ_PTR fldobj, int flag )
{
	if( flag == TRUE ){
		FieldOBJ_StatusBitON_Move( fldobj );
	}else{
		FieldOBJ_StatusBitOFF_Move( fldobj );
	}
}

//--------------------------------------------------------------
/**
 * b\`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=\ FALSE=s
 */
//--------------------------------------------------------------
int FieldOBJ_StatusBitCheck_Talk( FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_TALK_OFF) == TRUE ){
		return( FALSE );
	}
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * bstOZbg
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	flag	TRUE=s FALSE=\
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitSet_TalkOFF( FIELD_OBJ_PTR fldobj, int flag )
{
	if( flag == TRUE ){
		FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_TALK_OFF );
	}else{
		FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_TALK_OFF );
	}
}

//--------------------------------------------------------------
/**
 * |[Y
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MovePause( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_PAUSE_MOVE );
}

//--------------------------------------------------------------
/**
 * |[Y
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MovePauseClear( FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_PAUSE_MOVE );
}

//--------------------------------------------------------------
/**
 * |[Y`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=|[Y
 */
//--------------------------------------------------------------
int FieldOBJ_MovePauseCheck( CONST_FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_PAUSE_MOVE) == TRUE ){
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * Xe[^Xrbg `揈`FbN
 * @param	fldobj		FIELD_OBJ_PTR
 * @retval	int			TRUE=BFALSE=܂
 */
//--------------------------------------------------------------
int FieldOBJ_StatusBit_DrawInitCompCheck( CONST_FIELD_OBJ_PTR fldobj )
{
	CONST_FIELD_OBJ_SYS_PTR fos;
	
	fos = FieldOBJ_FieldOBJSysGet( fldobj );
	
	if( FieldOBJSys_DrawInitCompCheck(fos) == FALSE ){
		return( FALSE );
	}
	
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_DRAW_PROC_INIT_COMP) == 0 ){
		return( FALSE );
	}
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * 擾֎~
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	int		TRUE=擾OFF FALSE=ON
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitSet_HeightGetOFF( FIELD_OBJ_PTR fldobj, int flag )
{
	if( flag == TRUE ){
		FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_HEIGHT_GET_OFF );
	}else{
		FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_HEIGHT_GET_OFF );
	}
}

//--------------------------------------------------------------
/**
 * 擾֎~Ă邩`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=֎~
 */
//--------------------------------------------------------------
int FieldOBJ_HeightOFFCheck( CONST_FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_HEIGHT_GET_OFF) ){
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * ][؂ւ̍폜֎~
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	flag	TRUE=֎~ FALSE=֎~Ȃ
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_NotZoneDeleteSet( FIELD_OBJ_PTR fldobj, int flag )
{
	if( flag == TRUE ){
		FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_ZONE_DEL_NOT );
	}else{
		FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_ZONE_DEL_NOT );
	}
}

//--------------------------------------------------------------
/**
 * GCAXtOZbg
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	flag	TRUE=GCAX FALSE=Ⴄ
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitSet_Alies( FIELD_OBJ_PTR fldobj, int flag )
{
	if( flag == TRUE ){
		FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_ALIES );
	}else{
		FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_ALIES );
	}
}

//--------------------------------------------------------------
/**
 * GCAXtO`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	flag	TRUE=GCAX FALSE=Ⴄ
 */
//--------------------------------------------------------------
int FieldOBJ_StatusBitCheck_Alies( CONST_FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_ALIES) ){
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * 󐣃GtFNgZbgtOZbg
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	flag	TRUE=Zbg@FALSE=NA
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitSet_ShoalEffectSet( FIELD_OBJ_PTR fldobj, int flag )
{
	if( flag == TRUE ){
		FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_EFFSET_SHOAL );
	}else{
		FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_EFFSET_SHOAL );
	}
}

//--------------------------------------------------------------
/**
 * 󐣃GtFNgZbgtO`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	flag	TRUE=Zbg@FALSE=Ⴄ
 */
//--------------------------------------------------------------
int FieldOBJ_StatusBitCheck_ShoalEffectSet( CONST_FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_EFFSET_SHOAL) ){
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * Agr[gItZbgݒOFFZbg
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	flag	TRUE=Zbg@FALSE=NA
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitSet_AttrOffsOFF( FIELD_OBJ_PTR fldobj, int flag )
{
	if( flag == TRUE ){
		FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_ATTR_OFFS_OFF );
	}else{
		FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_ATTR_OFFS_OFF );
	}
}

//--------------------------------------------------------------
/**
 * Agr[gItZbgݒOFF`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	flag	TRUE=OFF@FALSE=Ⴄ
 */
//--------------------------------------------------------------
int FieldOBJ_StatusBitCheck_AttrOffsOFF( CONST_FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_ATTR_OFFS_OFF) ){
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * ړtOZbg
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	flag	TRUE=Zbg@FALSE=NA
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitSet_Bridge( FIELD_OBJ_PTR fldobj, int flag )
{
	if( flag == TRUE ){
		FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_BRIDGE );
	}else{
		FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_BRIDGE );
	}
}

//--------------------------------------------------------------
/**
 * ړtO`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	flag	TRUE=@FALSE=Ⴄ
 */
//--------------------------------------------------------------
int FieldOBJ_StatusBitCheck_Bridge( CONST_FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_BRIDGE) ){
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * f肱݃tOZbg
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	flag	TRUE=Zbg@FALSE=NA
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitSet_Reflect( FIELD_OBJ_PTR fldobj, int flag )
{
	if( flag == TRUE ){
		FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_REFLECT_SET );
	}else{
		FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_REFLECT_SET );
	}
}

//--------------------------------------------------------------
/**
 * f肱݃tO`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	flag	TRUE=Zbg@FALSE=
 */
//--------------------------------------------------------------
int FieldOBJ_StatusBitCheck_Reflect( CONST_FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_REFLECT_SET) ){
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * Aj[VR}h`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	flag	TRUE=R}hA@FALSE=
 */
//--------------------------------------------------------------
int FieldOBJ_StatusBitCheck_Acmd( CONST_FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_ACMD) ){
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * gtOZbg
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	flag	TRUE=Zbg@FALSE=NA
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_StatusBitSet_HeightExpand( FIELD_OBJ_PTR fldobj, int flag )
{
	if( flag == TRUE ){
		FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_HEIGHT_EXPAND );
	}else{
		FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_HEIGHT_EXPAND );
	}
}

//--------------------------------------------------------------
/**
 * gtO`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	flag	TRUE=gɔ@FALSE=
 */
//--------------------------------------------------------------
int FieldOBJ_StatusBitCheck_HeightExpand( CONST_FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_HEIGHT_EXPAND) ){
		return( TRUE );
	}
	
	return( FALSE );
}

//==============================================================================
//	WnQ
//==============================================================================
//--------------------------------------------------------------
/**
 * W XW擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	int		XW
 */
//--------------------------------------------------------------
int FieldOBJ_InitPosGX_Get( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->gx_init );
}

//--------------------------------------------------------------
/**
 * W XWZbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	x		ZbgW
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_InitPosGX_Set( FIELD_OBJ_PTR fldobj, int x )
{
	fldobj->gx_init = x;
}

//--------------------------------------------------------------
/**
 * W YW擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	int		Y
 */
//--------------------------------------------------------------
int FieldOBJ_InitPosGY_Get( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->gy_init );
}

//--------------------------------------------------------------
/**
 * W YWZbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	y		ZbgW
 * @retval	int		yW
 */
//--------------------------------------------------------------
void FieldOBJ_InitPosGY_Set( FIELD_OBJ_PTR fldobj, int y )
{
	fldobj->gy_init = y;
}

//--------------------------------------------------------------
/**
 * W zW擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	int		zW
 */
//--------------------------------------------------------------
int FieldOBJ_InitPosGZ_Get( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->gz_init );
}

//--------------------------------------------------------------
/**
 * W zWZbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	z		ZbgW
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_InitPosGZ_Set( FIELD_OBJ_PTR fldobj, int z )
{
	fldobj->gz_init = z;
}

//--------------------------------------------------------------
/**
 * ߋW@XW擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	int		XW
 */
//--------------------------------------------------------------
int FieldOBJ_OldPosGX_Get( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->gx_old );
}

//--------------------------------------------------------------
/**
 * ߋW XWZbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	x		ZbgW
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_OldPosGX_Set( FIELD_OBJ_PTR fldobj, int x )
{
	fldobj->gx_old = x;
}

//--------------------------------------------------------------
/**
 * ߋW YW擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	int		Y
 */
//--------------------------------------------------------------
int FieldOBJ_OldPosGY_Get( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->gy_old );
}

//--------------------------------------------------------------
/**
 * ߋW YWZbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	y		ZbgW
 * @retval	int		yW
 */
//--------------------------------------------------------------
void FieldOBJ_OldPosGY_Set( FIELD_OBJ_PTR fldobj, int y )
{
	fldobj->gy_old = y;
}

//--------------------------------------------------------------
/**
 * ߋW zW擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	int		zW
 */
//--------------------------------------------------------------
int FieldOBJ_OldPosGZ_Get( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->gz_old );
}

//--------------------------------------------------------------
/**
 * ߋW zWZbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	z		ZbgW
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_OldPosGZ_Set( FIELD_OBJ_PTR fldobj, int z )
{
	fldobj->gz_old = z;
}

//--------------------------------------------------------------
/**
 * ݍW XW擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	int		XW
 */
//--------------------------------------------------------------
int FieldOBJ_NowPosGX_Get( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->gx_now );
}

//--------------------------------------------------------------
/**
 * ݍW XWZbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	x		ZbgW
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_NowPosGX_Set( FIELD_OBJ_PTR fldobj, int x )
{
	fldobj->gx_now = x;
}

//--------------------------------------------------------------
/**
 * ݍW XW
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	x		l
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_NowPosGX_Add( FIELD_OBJ_PTR fldobj, int x )
{
	fldobj->gx_now += x;
}

//--------------------------------------------------------------
/**
 * ݍW YW擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	int		Y
 */
//--------------------------------------------------------------
int FieldOBJ_NowPosGY_Get( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->gy_now );
}

//--------------------------------------------------------------
/**
 * ݍW YWZbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	y		ZbgW
 * @retval	int		yW
 */
//--------------------------------------------------------------
void FieldOBJ_NowPosGY_Set( FIELD_OBJ_PTR fldobj, int y )
{
	fldobj->gy_now = y;
}

//--------------------------------------------------------------
/**
 * ݍW YW
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	y		l
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_NowPosGY_Add( FIELD_OBJ_PTR fldobj, int y )
{
	fldobj->gy_now += y;
}

//--------------------------------------------------------------
/**
 * ߋW zW擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	int		zW
 */
//--------------------------------------------------------------
int FieldOBJ_NowPosGZ_Get( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->gz_now );
}

//--------------------------------------------------------------
/**
 * ݍW zWZbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	z		ZbgW
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_NowPosGZ_Set( FIELD_OBJ_PTR fldobj, int z )
{
	fldobj->gz_now = z;
}

//--------------------------------------------------------------
/**
 * ݍW zW
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	z		l
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_NowPosGZ_Add( FIELD_OBJ_PTR fldobj, int z )
{
	fldobj->gz_now += z;
}

//--------------------------------------------------------------
/**
 * W擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	vec		Wi[
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_VecPosGet( CONST_FIELD_OBJ_PTR fldobj, VecFx32 *vec )
{
	*vec = fldobj->vec_pos_now;
}

//--------------------------------------------------------------
/**
 * WZbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	vec		ZbgW
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_VecPosSet( FIELD_OBJ_PTR fldobj, const VecFx32 *vec )
{
	fldobj->vec_pos_now = *vec;
}

//--------------------------------------------------------------
/**
 * W|C^擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	VecFx32	W|C^
 */
//--------------------------------------------------------------
const VecFx32 * FieldOBJ_VecPosPtrGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( &fldobj->vec_pos_now );
}

//--------------------------------------------------------------
/**
 * WYl擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	fx32	
 */
//--------------------------------------------------------------
fx32 FieldOBJ_VecPosYGet( CONST_FIELD_OBJ_PTR fldobj )
{
	return( fldobj->vec_pos_now.y );
}

//--------------------------------------------------------------
/**
 * \WItZbg擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	vec		ZbgW
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_VecDrawOffsGet( CONST_FIELD_OBJ_PTR fldobj, VecFx32 *vec )
{
	*vec = fldobj->vec_draw_offs;
}

//--------------------------------------------------------------
/**
 * \WItZbgZbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	vec		ZbgW
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_VecDrawOffsSet( FIELD_OBJ_PTR fldobj, const VecFx32 *vec )
{
	fldobj->vec_draw_offs = *vec;
}

//--------------------------------------------------------------
/**
 * \WItZbg|C^擾
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	VecFx32		ItZbg|C^
 */
//--------------------------------------------------------------
VecFx32 * FieldOBJ_VecDrawOffsPtrGet( FIELD_OBJ_PTR fldobj )
{
	return( &fldobj->vec_draw_offs );
}

//--------------------------------------------------------------
/**
 * Ow\WItZbg擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	vec		ZbgW
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_VecDrawOffsOutSideGet( CONST_FIELD_OBJ_PTR fldobj, VecFx32 *vec )
{
	*vec = fldobj->vec_draw_offs_outside;
}

//--------------------------------------------------------------
/**
 * Ow\WItZbgZbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	vec		ZbgW
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_VecDrawOffsOutSideSet( FIELD_OBJ_PTR fldobj, const VecFx32 *vec )
{
	fldobj->vec_draw_offs_outside = *vec;
}

//--------------------------------------------------------------
/**
 * Agr[gωWItZbg擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	vec		ZbgW
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_VecAttrOffsGet( CONST_FIELD_OBJ_PTR fldobj, VecFx32 *vec )
{
	*vec = fldobj->vec_attr_offs;
}

//--------------------------------------------------------------
/**
 * Agr[gωWItZbgZbg
 * @param	fldobj	FIELD_OBJ_PTR 
 * @param	vec		ZbgW
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_VecAttrOffsSet( FIELD_OBJ_PTR fldobj, const VecFx32 *vec )
{
	fldobj->vec_attr_offs = *vec;
}

//--------------------------------------------------------------
/**
 * (ObhP)擾
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		BH_GRIDP
 */
//--------------------------------------------------------------
int FieldOBJ_HeightGridGet( CONST_FIELD_OBJ_PTR fldobj )
{
	fx32 y = FieldOBJ_VecPosYGet( fldobj );
	int gy = SIZE_H_GRID_FX32( y );
	return( gy );
}

//==============================================================================
//	FIELD_OBJ_H	Q
//==============================================================================
//--------------------------------------------------------------
/**
 * ID Zbg
 * @param	head	FIELD_OBJ_H
 * @param	id		OBJ ID
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_H_IDSet( FIELD_OBJ_H *head, int id )
{
	head->id = id;
}

//--------------------------------------------------------------
/**
 * ID 擾
 * @param	head	FIELD_OBJ_H
 * @retval	u32		ID
 */
//--------------------------------------------------------------
int FieldOBJ_H_IDGet( const FIELD_OBJ_H *head )
{
	return( head->id );
}

//--------------------------------------------------------------
/**
 * OBJR[hZbg
 * @param	head	FIELD_OBJ_H
 * @param	code	HERO
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_H_OBJCodeSet( FIELD_OBJ_H *head, int code )
{
	head->obj_code = code;
}

//--------------------------------------------------------------
/**
 * OBJR[h擾
 * @param	head	FIELD_OBJ_H
 * @retval	int		OBJR[h
 */
//--------------------------------------------------------------
int FieldOBJ_H_OBJCodeGet( const FIELD_OBJ_H *head )
{
	return( head->obj_code );
}

//--------------------------------------------------------------
/**
 * R[hZbg
 * @param	head	FIELD_OBJ_H
 * @param	code	MV_DIR_RND
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_H_MoveCodeSet( FIELD_OBJ_H *head, int code )
{
	head->move_code = code;
}

//--------------------------------------------------------------
/**
 * R[h擾
 * @param	head	FIELD_OBJ_H
 * @retval	int		R[h
 */
//--------------------------------------------------------------
int FieldOBJ_H_MoveCodeGet( const FIELD_OBJ_H *head )
{
	return( head->move_code );
}

//--------------------------------------------------------------
/**
 * Cxg^CvZbg
 * @param	head	FIELD_OBJ_H
 * @param	type	Cxg^Cv
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_H_EventTypeSet( FIELD_OBJ_H *head, int type )
{
	head->event_type = type;
}

//--------------------------------------------------------------
/**
 * Cxg^Cv擾
 * @param	head	FIELD_OBJ_H
 * @retval	int		Cxg^Cv
 */
//--------------------------------------------------------------
int FieldOBJ_H_EventTypeGet( const FIELD_OBJ_H *head )
{
	return( head->event_type );
}

//--------------------------------------------------------------
/**
 * CxgtOZbg
 * @param	head	FIELD_OBJ_H
 * @param	flag	CxgtO
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_H_EventFlagSet( FIELD_OBJ_H *head, int flag )
{
	head->event_flag = flag;
}

//--------------------------------------------------------------
/**
 * CxgtO擾
 * @param	head	FIELD_OBJ_H
 * @retval	int		CxgtO
 */
//--------------------------------------------------------------
int FieldOBJ_H_EventFlagGet( const FIELD_OBJ_H *head )
{
	return( head->event_flag );
}

//--------------------------------------------------------------
/**
 * CxgIDZbg
 * @param	head	FIELD_OBJ_H
 * @param	id		CxgID
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_H_EventIDSet( FIELD_OBJ_H *head, int id )
{
	head->event_id = id;
}

//--------------------------------------------------------------
/**
 * CxgID擾
 * @param	head	FIELD_OBJ_H
 * @retval	int		CxgtO
 */
//--------------------------------------------------------------
int FieldOBJ_H_EventIDGet( const FIELD_OBJ_H *head )
{
	return( head->event_id );
}

//--------------------------------------------------------------
/**
 * Zbg
 * @param	head	FIELD_OBJ_H
 * @param	dir		DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_H_DirSet( FIELD_OBJ_H *head, int dir )
{
	head->dir = dir;
}

//--------------------------------------------------------------
/**
 * 擾
 * @param	head	FIELD_OBJ_H
 * @retval	int		
 */
//--------------------------------------------------------------
int FieldOBJ_H_DirGet( const FIELD_OBJ_H *head )
{
	return( head->dir );
}

//--------------------------------------------------------------
/**
 * wp^Zbg
 * @param	head	FIELD_OBJ_H
 * @param	param	wp^
 * @param	no		FLDOBJ_PARAM_0
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_H_ParamSet( FIELD_OBJ_H *head, int param, FLDOBJ_H_PARAM no )
{
	switch( no ){
	case FLDOBJ_PARAM_0: head->param0 = param; break;
	case FLDOBJ_PARAM_1: head->param1 = param; break;
	case FLDOBJ_PARAM_2: head->param2 = param; break;
	default: GF_ASSERT( 0 && "FieldOBJ_H_ParamSet()sȈ" );
	}
}

//--------------------------------------------------------------
/**
 * wp^擾
 * @param	head	FIELD_OBJ_H
 * @param	no		擾p^BFLDOBJ_PARAM_0
 * @retval	int		p^
 */
//--------------------------------------------------------------
int FieldOBJ_H_ParamGet( const FIELD_OBJ_H *head, FLDOBJ_H_PARAM no )
{
	switch( no ){
	case FLDOBJ_PARAM_0: return( head->param0 );
	case FLDOBJ_PARAM_1: return( head->param1 );
	case FLDOBJ_PARAM_2: return( head->param2 );
	}
	
	GF_ASSERT( 0 && "FieldOBJ_H_ParamGet()sȈ" );
	return( 0 );
}

//--------------------------------------------------------------
/**
 * ړXZbg
 * @param	head	FIELD_OBJ_H
 * @param	x		ړX
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_H_MoveLimitXSet( FIELD_OBJ_H *head, int x )
{
	head->move_limit_x = x;
}

//--------------------------------------------------------------
/**
 * ړX擾
 * @param	head	FIELD_OBJ_H
 * @retval	int		ړX
 */
//--------------------------------------------------------------
int FieldOBJ_H_MoveLimitXGet( const FIELD_OBJ_H *head )
{
	return( head->move_limit_x );
}

//--------------------------------------------------------------
/**
 * ړZZbg
 * @param	head	FIELD_OBJ_H
 * @param	z		ړZ
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_H_MoveLimitZSet( FIELD_OBJ_H *head, int z )
{
	head->move_limit_z = z;
}

//--------------------------------------------------------------
/**
 * ړZ擾
 * @param	head	FIELD_OBJ_H
 * @retval	int		ړY
 */
//--------------------------------------------------------------
int FieldOBJ_H_MoveLimitZGet( const FIELD_OBJ_H *head )
{
	return( head->move_limit_z );
}

//--------------------------------------------------------------
/**
 * XWZbg
 * @param	head	FIELD_OBJ_H
 * @param	x		XW
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_H_PosXSet( FIELD_OBJ_H *head, int x )
{
	head->gx = x;
}

//--------------------------------------------------------------
/**
 * XW擾
 * @param	head	FIELD_OBJ_H
 * @retval	int		XW
 */
//--------------------------------------------------------------
int FieldOBJ_H_PosXGet( const FIELD_OBJ_H *head )
{
	return( head->gx );
}

//--------------------------------------------------------------
/**
 * YWZbg
 * @param	head	FIELD_OBJ_H
 * @param	y		yW
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_H_PosYSet( FIELD_OBJ_H *head, int y )
{
	head->gy = y;
}

//--------------------------------------------------------------
/**
 * YW擾
 * @param	head	FIELD_OBJ_H
 * @retval	int		YW
 */
//--------------------------------------------------------------
int FieldOBJ_H_PosYGet( const FIELD_OBJ_H *head )
{
	return( head->gy );
}

//--------------------------------------------------------------
/**
 * ZWZbg
 * @param	head	FIELD_OBJ_H
 * @param	z		ZW
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_H_PosZSet( FIELD_OBJ_H *head, int z )
{
	head->gz = z;
}

//--------------------------------------------------------------
/**
 * ZW擾
 * @param	head	FIELD_OBJ_H
 * @retval	int		YW
 */
//--------------------------------------------------------------
int FieldOBJ_H_PosZGet( const FIELD_OBJ_H *head )
{
	return( head->gz );
}

//--------------------------------------------------------------
/**
 * tB[hOBJwb_[z񂩂wIDwb_[
 * @param	id		wb_[ID
 * @param	max		headvf
 * @param	head	tB[hOBJwb_[e[u
 * @retval	FIELD_OBJ_H idhead|C^BNULL=v
 */
//--------------------------------------------------------------
static const FIELD_OBJ_H * FldOBJ_H_OBJIDSearch( int id, int max, const FIELD_OBJ_H *head )
{
	int i = 0;
	
	do{
		if( FldOBJ_H_AliesCheck(&head[i]) == FALSE ){
			if( FieldOBJ_H_IDGet(&head[i]) == id ){
				return( &head[i] );
			}
		}
		
		i++;
	}while( i < max );
	
	return( NULL );
}

//--------------------------------------------------------------
/**
 * tB[hOBJwb_[@GCAX`FbN
 * @param	head	FIELD_OBJ_H
 * @retval	int		TRUE=GCAX@FALSE=Ⴄ
 */
//--------------------------------------------------------------
static int FldOBJ_H_AliesCheck( const FIELD_OBJ_H *head )
{
	u16 id = (u16)FieldOBJ_H_EventIDGet( head );
	if( id == SP_SCRID_ALIES ){ return( TRUE ); }
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * tB[hOBJwb_[@GCAX̃][ID擾B
 * GCAX̓CxgtO][IDɂȂ
 * @param	head	FIELD_OBJ_H
 * @retval	int		][ID
 */
//--------------------------------------------------------------
static int FldOBJ_H_AliesZoneIDGet( const FIELD_OBJ_H *head )
{
	GF_ASSERT( FldOBJ_H_AliesCheck(head) == TRUE && "FldOBJ_H_AliesZoneIDGet()aliesł͂Ȃ" );
	return( FieldOBJ_H_EventFlagGet(head) );
}

//==============================================================================
//	FIELD_OBJ_MOVE_PROC Q
//==============================================================================
//--------------------------------------------------------------
/**
 * e[uw̃Xgo
 * @param	nothing
 * @retval	FIELD_OBJ_MOVE_PROC_LIST	FIELD_OBJ_MOVE_PROC_LISTe[u
 */
//--------------------------------------------------------------
static const FIELD_OBJ_MOVE_PROC_LIST * FldOBJ_MoveProcListGet( u32 code )
{
	GF_ASSERT( code < MV_CODE_MAX );
	return( DATA_FieldOBJMoveProcListTbl[code] );
}

//--------------------------------------------------------------
/**
 * R[h擾
 * @param	list 		FIELD_OBJ_MOVE_PROC_LIST
 * @retval	u32			MV_PLAYER
 */
//--------------------------------------------------------------
static u32 FldOBJ_MoveProcList_MoveCodeGet( const FIELD_OBJ_MOVE_PROC_LIST *list )
{
	return( list->move_code );
}

//--------------------------------------------------------------
/**
 * ֐擾
 * @param	list FIELD_OBJ_MOVE_PROC_LIST
 * @retval	FIELD_OBJ_MOVE_PROC_INIT list̏֐
 */
//--------------------------------------------------------------
static FIELD_OBJ_MOVE_PROC_INIT FldOBJ_MoveProcList_InitGet(
		const FIELD_OBJ_MOVE_PROC_LIST *list )
{
	return( list->init_proc );
}

//--------------------------------------------------------------
/**
 * ֐擾
 * @param	list FIELD_OBJ_MOVE_PROC_LIST
 * @retval	FIELD_OBJ_MOVE_PROC list̓֐
 */
//--------------------------------------------------------------
static FIELD_OBJ_MOVE_PROC FldOBJ_MoveProcList_MoveGet( const FIELD_OBJ_MOVE_PROC_LIST *list )
{
	return( list->move_proc );
}

//--------------------------------------------------------------
/**
 * 폜֐擾
 * @param	list FIELD_OBJ_MOVE_PROC_LIST
 * @retval	FIELD_OBJ_MOVE_PROC_DEL list̓֐
 */
//--------------------------------------------------------------
static FIELD_OBJ_MOVE_PROC_DEL FldOBJ_MoveProcList_DeleteGet(
		const FIELD_OBJ_MOVE_PROC_LIST *list )
{
	return( list->delete_proc );
}

//==============================================================================
//	FIELD_OBJ_DRAW_PROC_LIST FIELD_OBJ_DRAW_PROC_LIST_REGQ
//==============================================================================
//--------------------------------------------------------------
/**
 * ֐擾
 * @param	list	FIELD_OBJ_DRAW_PROC_LIST *
 * @retval	FIELD_OBJ_DRAW_PROC_INIT	FIELD_OBJ_DRAW_PROC_INIT *
 */
//--------------------------------------------------------------
static FIELD_OBJ_DRAW_PROC_INIT FldOBJ_DrawProcList_InitGet(
	const FIELD_OBJ_DRAW_PROC_LIST *list )
{
	return( list->init_proc );
}

//--------------------------------------------------------------
/**
 * `֐擾
 * @param	list	FIELD_OBJ_DRAW_PROC_LIST *
 * @retval	FIELD_OBJ_DRAW_PROC		FIELD_OBJ_DRAW_PROC *
 */
//--------------------------------------------------------------
static FIELD_OBJ_DRAW_PROC FldOBJ_DrawProcList_DrawGet( const FIELD_OBJ_DRAW_PROC_LIST *list )
{
	return( list->draw_proc );
}

//--------------------------------------------------------------
/**
 * 폜֐擾
 * @param	list	FIELD_OBJ_DRAW_PROC_LIST *
 * @retval	FIELD_OBJ_DRAW_PROC_DEL		FIELD_OBJ_DRAW_PROC_DEL *
 */
//--------------------------------------------------------------
static FIELD_OBJ_DRAW_PROC_DEL FldOBJ_DrawProcList_DeleteGet(
		const FIELD_OBJ_DRAW_PROC_LIST *list )
{
	return( list->delete_proc );
}

//--------------------------------------------------------------
/**
 * ޔ֐擾
 * @param	list	FIELD_OBJ_DRAW_PROC_LIST *
 * @retval	FIELD_OBJ_DRAW_PROC_PUSH		FIELD_OBJ_DRAW_PROC_PUSH *
 */
//--------------------------------------------------------------
static FIELD_OBJ_DRAW_PROC_PUSH FldOBJ_DrawProcList_PushGet(
		const FIELD_OBJ_DRAW_PROC_LIST *list )
{
	return( list->push_proc );
}

//--------------------------------------------------------------
/**
 * A֐擾
 * @param	list	FIELD_OBJ_DRAW_PROC_LIST *
 * @retval	FIELD_OBJ_DRAW_PROC_PUSH		FIELD_OBJ_DRAW_PROC_PUSH *
 */
//--------------------------------------------------------------
static FIELD_OBJ_DRAW_PROC_POP FldOBJ_DrawProcList_PopGet(
		const FIELD_OBJ_DRAW_PROC_LIST *list )
{
	return( list->pop_proc );
}

//--------------------------------------------------------------
/**
 * e[uw̃Xgo
 * @param	code	HERO
 * @retval	list	codeɑΉFIELD_OBJ_DRAW_PROC_LIST *
 */
//--------------------------------------------------------------
static const FIELD_OBJ_DRAW_PROC_LIST * FldOBJ_DrawProcListGet( u32 code )
{
	const FIELD_OBJ_DRAW_PROC_LIST_REG *tbl = DATA_FieldOBJDrawProcListRegTbl;
	
	do{
		if( tbl->code == code ){
			return( tbl->list );
		}
		
		tbl++;
	}while( tbl->code != OBJCODEMAX );
	
	GF_ASSERT( 0 && "FldOBJ_DrawProcListGet()sȃR[h" );
	return( NULL );
}

//==============================================================================
//	tB[hOBJ c[
//==============================================================================
//--------------------------------------------------------------
/**
 * w肳ꂽObhX,ZWɂOBJ擾
 * @param	sys			FIELD_OBJ_SYS_PTR 
 * @param	x			ObhX
 * @param	z			ObhZ
 * @retval	FIELD_OBJ	x,zʒuɂFIELD_OBJ_PTR BNULL=̍WOBJ͂Ȃ
 */
//--------------------------------------------------------------
FIELD_OBJ_PTR  FieldOBJ_SearchGPos( CONST_FIELD_OBJ_SYS_PTR sys, int x, int z )
{
	int max;
	FIELD_OBJ_PTR fldobj;
	
	max = FieldOBJSys_OBJMaxGet( sys );
	fldobj = FieldOBJSys_FldOBJWorkGet( sys );
	
	do{
		if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_USE) ){
			if( FieldOBJ_NowPosGX_Get(fldobj) == x && FieldOBJ_NowPosGZ_Get(fldobj) == z ){
				return( fldobj );
			}
		}
		
		fldobj++;
		max--;
	}while( max );
	
	return( NULL );
}

//--------------------------------------------------------------
/**
 * WABfx32^
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	vec		W
 * @param	dir		 DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_VecPosDirInit( FIELD_OBJ_PTR fldobj, const VecFx32 *vec, int dir )
{
	int gx,gy,gz;
	
	gx = SIZE_GRID_FX32( vec->x );
	FieldOBJ_NowPosGX_Set( fldobj, gx );
	
	gy = SIZE_H_GRID_FX32( vec->y );
	FieldOBJ_NowPosGY_Set( fldobj, gy );
	
	gz = SIZE_GRID_FX32( vec->z );
	FieldOBJ_NowPosGZ_Set( fldobj, gz );
	
	FieldOBJ_VecPosSet( fldobj, vec );
	FieldOBJ_GPosUpdate( fldobj );
	
	FieldOBJ_DirDispSetForce( fldobj, dir );
	
//	ȂłĂ̂
//	FldOBJ_WorkInit_MoveProcInit( fldobj );
//	FldOBJ_WorkInit_DrawProcInit( fldobj );
	
	FieldOBJ_AcmdFree( fldobj );
	FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_MOVE_START );
	FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_MOVE | FLDOBJ_STA_BIT_MOVE_END );
}

//--------------------------------------------------------------
/**
 * WABObhW^
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	x		ObhXW
 * @param	y		ObhYW
 * @param	z		ObhZW
 * @param	dir		 DIR_UP
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_GPosDirInit( FIELD_OBJ_PTR fldobj, int x, int y, int z, int dir )
{
	VecFx32 vec;
	
	vec.x = GRID_SIZE_FX32( x ) + FLDOBJ_VEC_X_GRID_OFFS_FX32;
	FieldOBJ_NowPosGX_Set( fldobj, x );
	
	vec.y = H_GRID_SIZE_FX32( y ) + FLDOBJ_VEC_Y_GRID_OFFS_FX32;
	FieldOBJ_NowPosGY_Set( fldobj, y );
	
	vec.z = GRID_SIZE_FX32( z ) + FLDOBJ_VEC_Z_GRID_OFFS_FX32;
	FieldOBJ_NowPosGZ_Set( fldobj, z );
	
	FieldOBJ_VecPosSet( fldobj, &vec );
	FieldOBJ_GPosUpdate( fldobj );
	
	FieldOBJ_DirDispSetForce( fldobj, dir );
	
//	ȂłĂ̂
//	FldOBJ_WorkInit_MoveProcInit( fldobj );
//	FldOBJ_WorkInit_DrawProcInit( fldobj );

//	͈̒lMp
//	FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_MOVE_START | FLDOBJ_STA_BIT_HEIGHT_GET_NEED );
	FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_MOVE_START );
	FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_MOVE | FLDOBJ_STA_BIT_MOVE_END );
	
	FieldOBJ_AcmdFree( fldobj );
}

//--------------------------------------------------------------
/**
 * R[hύX
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	code	MV_RND
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveCodeChange( FIELD_OBJ_PTR fldobj, u32 code )
{
	FieldOBJ_MoveDeleteProcCall( fldobj );
	FieldOBJ_MoveCodeSet( fldobj, code );
	FldOBJ_WorkInit_MoveProcInit( fldobj );
	FieldOBJ_MoveInit( fldobj );
}

//--------------------------------------------------------------
/**
 * OBJ IDύX
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	id		OBJ ID
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_OBJIDChange( FIELD_OBJ_PTR fldobj, int id )
{
	FieldOBJ_OBJIDSet( fldobj, id );
		
	FieldOBJ_StatusBitON_MoveStart( fldobj );
	FldOBJ_DrawEffectFlagInit( fldobj );
}

//==============================================================================
//	֐_~[
//==============================================================================
//--------------------------------------------------------------
/**
 * 쏉֐_~[
 * @param	FIELD_OBJ	FIELD_OBJ_PTR 
 * @retval	int			TRUE=
 */
//--------------------------------------------------------------
void FieldOBJ_MoveInitProcDummy( FIELD_OBJ_PTR fldobj )
{
}

//--------------------------------------------------------------
/**
 * ֐_~[
 * @param	FIELD_OBJ	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveProcDummy( FIELD_OBJ_PTR fldobj )
{
}

//--------------------------------------------------------------
/**
 * 폜֐_~[
 * @param	FIELD_OBJ	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveDeleteProcDummy( FIELD_OBJ_PTR fldobj )
{
}

//--------------------------------------------------------------
/**
 * 앜A֐_~[
 * @param	FIELD_OBJ_PTR	FIELD_OBJ_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_MoveReturnProcDummy( FIELD_OBJ_PTR fldobj )
{
}

//==============================================================================
//	`֐_~[
//==============================================================================
//--------------------------------------------------------------
/**
 * `揉֐_~[
 * @param	FIELD_OBJ	FIELD_OBJ_PTR 
 * @retval	int			TRUE=
 */
//--------------------------------------------------------------
void FieldOBJ_DrawInitProcDummy( FIELD_OBJ_PTR fldobj )
{
}

//--------------------------------------------------------------
/**
 * `֐_~[
 * @param	FIELD_OBJ	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawProcDummy( FIELD_OBJ_PTR fldobj )
{
}

//--------------------------------------------------------------
/**
 * `폜֐_~[
 * @param	FIELD_OBJ	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawDeleteProcDummy( FIELD_OBJ_PTR fldobj )
{
}

//--------------------------------------------------------------
/**
 * `ޔ֐_~[
 * @param	FIELD_OBJ	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawPushProcDummy( FIELD_OBJ_PTR fldobj )
{
}

//--------------------------------------------------------------
/**
 * `敜A֐_~[
 * @param	FIELD_OBJ	FIELD_OBJ_PTR 
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_DrawPopProcDummy( FIELD_OBJ_PTR fldobj )
{
}
