//==============================================================================
/**
 *
 * @file	fieldobj_debug.c
 * @brief	tB[hOBJ@fobO
 * @author	kagaya
 * @data	2005.07.11
 *
 */
//==============================================================================
//----
#ifdef PM_DEBUG
//----
#include "common.h"
#include "fieldobj.h"

#include "..\fielddata\maptable\zone_id.h"

//==============================================================================
//	GCAXeXg
//==============================================================================
#ifdef DEBUG_ALIES

const FIELD_OBJ_H DATA_DebugFldOBJHeaderR202A[2] =
{
	{
		128,		///<ID
		BOY1,		///<\OBJR[h
		MV_DMY,	///<R[h
		0,			///<Cxg^Cv
		ZONE_ID_C01,///<CxgtO
		SCRID_ALIES,///<CxgID
		DIR_DOWN,	///<w
		0,	///<wp^ 0
		0,	///<wp^ 1
		0,	///<wp^ 2
		1,	///<Xړ
		1,///<Zړ
		171,///<ObhX
		798,///<ObhZ
		0,	///<Yl
	},
	{
		129,		///<ID
		BOARD_A,	///<\OBJR[h
		MV_DMY,	///<R[h
		0,			///<Cxg^Cv
		ZONE_ID_C01,///<CxgtO
		SCRID_ALIES,///<CxgID
		DIR_DOWN,	///<w
		0,	///<wp^ 0
		0,	///<wp^ 1
		0,	///<wp^ 2
		1,	///<Xړ
		1,///<Zړ
		170,///<ObhX
		798,///<ObhZ
		0,	///<Yl
	},
};

const FIELD_OBJ_H DATA_DebugFldOBJHeaderC01[2] =
{
	{
		128,		///<ID
		BOY1,		///<\OBJR[h
		MV_DMY,	///<R[h
		0,			///<Cxg^Cv
		0,///<CxgtO
		0,///<CxgID
		DIR_DOWN,	///<w
		0,	///<wp^ 0
		0,	///<wp^ 1
		0,	///<wp^ 2
		1,	///<Xړ
		1,///<Zړ
		171,///<ObhX
		798,///<ObhZ
		0,	///<Yl
	},
	{
		129,		///<ID
		BOARD_A,		///<\OBJR[h
		MV_DMY,	///<R[h
		0,			///<Cxg^Cv
		0,///<CxgtO
		0,///<CxgID
		DIR_DOWN,	///<w
		0,	///<wp^ 0
		0,	///<wp^ 1
		0,	///<wp^ 2
		1,	///<Xړ
		1,///<Zړ
		170,///<ObhX
		798,///<ObhZ
		0,	///<Yl
	},
};

//--------------------------------------------------------------
/**
 * GCAXeXg@Â][OBJ폜̃eXg
 * @param
 * @retval
 */
//--------------------------------------------------------------
FIELD_OBJ_H * DEBUG_FieldOBJ_ZoneUpdateDeleteAliesHeader(
		int new_zone_id, int *head_max, const FIELD_OBJ_H *head )
{
	int max;
	FIELD_OBJ_H *debughead;
	
	max = *head_max;
	
	if( new_zone_id == ZONE_ID_C01 ){
		debughead = sys_AllocMemoryLo( HEAPID_FIELD, FIELD_OBJ_H_SIZE*(max+2) );
		memcpy( debughead, head, FIELD_OBJ_H_SIZE*max );
		debughead[max] = DATA_DebugFldOBJHeaderC01[0];
		debughead[max+1] = DATA_DebugFldOBJHeaderC01[1];
		max += 2;
		OS_Printf( "tB[hOBJ ][XV폜ɂăGCAXeXg@C01\n" );
	}else if( new_zone_id == ZONE_ID_R202 ){
		debughead = sys_AllocMemoryLo( HEAPID_FIELD, FIELD_OBJ_H_SIZE*(max+2) );
		memcpy( debughead, head, FIELD_OBJ_H_SIZE*max );
		debughead[max] = DATA_DebugFldOBJHeaderR202A[0];
		debughead[max+1] = DATA_DebugFldOBJHeaderR202A[1];
		max += 2;
		OS_Printf( "tB[hOBJ ][XV폜ɂăGCAXeXg@R202\n" );
	}else{
		debughead = sys_AllocMemoryLo( HEAPID_FIELD, FIELD_OBJ_H_SIZE*(max) );
		memcpy( debughead, head, FIELD_OBJ_H_SIZE*max );
	}
	
	*head_max = max;
	return( debughead );
}

void DEBUG_FieldOBJ_ZoneUpdateDeleteAliesHeaderDelete( FIELD_OBJ_H *head )
{
	sys_FreeMemory( HEAPID_FIELD, head );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ AddBin()GCAXp
 * @param
 * @retval
 */
//--------------------------------------------------------------
FIELD_OBJ_H * DEBUG_FieldOBJ_AddBinHeaderAlies(
		int zone_id, int *head_max, const FIELD_OBJ_H *head )
{
	int max = *head_max;
	FIELD_OBJ_H *debughead;
	
	if( zone_id == ZONE_ID_C01 ){
		debughead = sys_AllocMemoryLo( HEAPID_WORLD, FIELD_OBJ_H_SIZE*(max+2) );
		memcpy( debughead, head, FIELD_OBJ_H_SIZE*max );
		debughead[max] = DATA_DebugFldOBJHeaderC01[0];
		debughead[max+1] = DATA_DebugFldOBJHeaderC01[1];
		max += 2;
		OS_Printf( "tB[hOBJ ꊇǉɂăGCAXeXg@C01\n" );
	}else if( zone_id == ZONE_ID_R202 ){
		debughead = sys_AllocMemoryLo( HEAPID_WORLD, FIELD_OBJ_H_SIZE*(max+2) );
		memcpy( debughead, head, FIELD_OBJ_H_SIZE*max );
		debughead[max] = DATA_DebugFldOBJHeaderR202A[0];
		debughead[max+1] = DATA_DebugFldOBJHeaderR202A[1];
		max += 2;
		OS_Printf( "tB[hOBJ ꊇǉɂăGCAXeXg@C01\n" );
	}else{
		debughead = sys_AllocMemoryLo( HEAPID_WORLD, FIELD_OBJ_H_SIZE*max );
		memcpy( debughead, head, FIELD_OBJ_H_SIZE*max );
	}

	*head_max = max;
	return( debughead );
}

void DEBUG_FieldOBJ_AddBinHeaderAliesDelete( FIELD_OBJ_H *head )
{
	sys_FreeMemory( HEAPID_WORLD, head );
}
#endif	//DEBUG_ALIES

//----
#endif	//PM_DEBUG
//----
