//******************************************************************************
/**
 * 
 * @file	fieldobj_render.c
 * @brief	tB[hOBJ̃_OBJǗ
 * @author	kagaya
 * @data	05.07.13
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "fieldobj.h"

//==============================================================================
//	define
//==============================================================================

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	RDOBJDATA\
//--------------------------------------------------------------
typedef struct
{
	int code;
	NNSG3dRenderObj render;
	NNSG3dResMdl *model;
	NNSG3dResFileHeader *res_file;
}RDOBJDATA;

#define RDOBJDATA_SIZE (sizeof(RDOBJDATA))

//--------------------------------------------------------------
///	FLDOBJ_rdcont\
//--------------------------------------------------------------
typedef struct _TAG_FIELD_OBJ_RENDER_CONT
{
	int heap_id;
	int obj_max;
	CONST_FIELD_OBJ_SYS_PTR fos;
	RDOBJDATA *rdobjdata;
}FIELD_OBJ_RENDER_CONT;

#define FIELD_OBJ_RENDER_CONT_SIZE (sizeof(FIELD_OBJ_RENDER_CONT)) 

//==============================================================================
//	vg^Cv
//==============================================================================
static FIELD_OBJ_RENDER_CONT_PTR FldOBJRdC_AllocMemory( int heap_id );
static void FldOBJRdC_FreeMemory( FIELD_OBJ_RENDER_CONT_PTR rdcont );

static void FldOBJRdC_GraphicInit( FIELD_OBJ_RENDER_CONT_PTR rdcont );
static void FldOBJRdC_GraphicDelete( FIELD_OBJ_RENDER_CONT_PTR rdcont );

static RDOBJDATA * RdC_SpaceSearch( RDOBJDATA *data, int max );
static RDOBJDATA * RdC_CodeSearch( RDOBJDATA *data, int code, int max );
static void RdC_Delete( RDOBJDATA *data );

//==============================================================================
//	_OBJǗ@VXe
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hOBJ_OBJǗ
 * @param	fes		SYS_PTR
 * @param	heap_id	q[vID
 * @retval	FIELD_OBJ_RENDER_CONT_PTR ꂽFIELD_OBJ_RENDER_CONT_PTR
 */
//--------------------------------------------------------------
FIELD_OBJ_RENDER_CONT_PTR FieldOBJ_RenderCont_Init( CONST_FIELD_OBJ_SYS_PTR fos, u32 heap_id )
{
	FIELD_OBJ_RENDER_CONT_PTR rdcont;
	
	rdcont = FldOBJRdC_AllocMemory( heap_id );
	rdcont->heap_id = heap_id;
	rdcont->fos = fos;
	
	FldOBJRdC_GraphicInit( rdcont );
	
	return( rdcont );
}

//--------------------------------------------------------------
/**
 * _OBJǗ폜
 * @param	rdcont		FIELD_OBJ_RENDER_CONT_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_RenderCont_Delete( FIELD_OBJ_RENDER_CONT_PTR rdcont )
{
	FldOBJRdC_GraphicDelete( rdcont );
	FldOBJRdC_FreeMemory( rdcont );
}

//==============================================================================
//	_OBJǗ	p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * _OBJǗm
 * @param	heap_id		q[vID
 * @retval	FIELD_OBJ_RENDER_CONT_PTR	mۂFIELD_OBJ_RENDER_CONT_PTR
 */
//--------------------------------------------------------------
static FIELD_OBJ_RENDER_CONT_PTR FldOBJRdC_AllocMemory( int heap_id )
{
	FIELD_OBJ_RENDER_CONT_PTR rdcont = sys_AllocMemory( heap_id, FIELD_OBJ_RENDER_CONT_SIZE );
	GF_ASSERT( rdcont != NULL && "FldOBJrdcont_AllocMemory()mێs" );
	memset( rdcont, 0, FIELD_OBJ_RENDER_CONT_SIZE );
	return( rdcont );
}

//--------------------------------------------------------------
/**
 * _OBJǗ폜
 * @param	rdcont		FIELD_OBJ_RENDER_CONT_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJRdC_FreeMemory( FIELD_OBJ_RENDER_CONT_PTR rdcont )
{
	sys_FreeMemory( rdcont->heap_id, rdcont );
}

//==============================================================================
//	_OBJǗ@OtBbN
//==============================================================================
//--------------------------------------------------------------
/**
 * _OBJǗ OtBbN
 * @param	rdcont		FIELD_OBJ_RENDER_CONT_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJRdC_GraphicInit( FIELD_OBJ_RENDER_CONT_PTR rdcont )
{
}

//--------------------------------------------------------------
/**
 * _OBJǗ@OtBbN폜
 * @param	rdcont		FIELD_OBJ_RENDER_CONT_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJRdC_GraphicDelete( FIELD_OBJ_RENDER_CONT_PTR rdcont )
{
	if( rdcont->obj_max && rdcont->rdobjdata != NULL ){
		RDOBJDATA *data = rdcont->rdobjdata;
		
		do{
			if( data->res_file != NULL ){
				RdC_Delete( data );
			}
			
			data++;
			rdcont->obj_max--;
		}while( rdcont->obj_max );
		
		sys_FreeMemory( rdcont->heap_id, rdcont->rdobjdata );
	}
}

//==============================================================================
//	_OBJǗ@Ǘ
//==============================================================================
//--------------------------------------------------------------
/**
 * _OBJǗ@Ǘ
 * @param	fes		SYS_PTR
 * @param	max		OBJǗő吔
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_RenderCont_RegistInit( FIELD_OBJ_RENDER_CONT_PTR rdcont, int max )
{
	rdcont->obj_max = max;
	max *= RDOBJDATA_SIZE;
	rdcont->rdobjdata = sys_AllocMemory( rdcont->heap_id, max );
	GF_ASSERT( rdcont->rdobjdata != NULL && "FieldOBJ_RenderContRegistInit()mێs" );
	memset( rdcont->rdobjdata, NULL, max );
}

//--------------------------------------------------------------
/**
 * _OBJǗ@simple_3DModelSetResFileAlready()ɂOBJo^
 * @param	fes		SYS_PTR
 * @param	max		OBJǗő吔
 * @retval	int		TRUE=o^ FALSE=o^łȂ
 */
//--------------------------------------------------------------
int FieldOBJ_RenderCont_OBJRegSimple( FIELD_OBJ_RENDER_CONT_PTR rdcont, 
		int code, ARCHANDLE *handle, u32 data_id, u32 heap_id )
{
	RDOBJDATA *data = RdC_SpaceSearch( rdcont->rdobjdata, rdcont->obj_max );
	data->res_file = ArchiveDataLoadAllocByHandle( handle, data_id, heap_id );
	simple_3DModelSetResFileAlready( &data->render, &data->model, &data->res_file );
	
	data->code = code;
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * _OBJǗ@w肳ꂽcode폜
 * @param	fes		SYS_PTR
 * @param	max		OBJǗő吔
 * @retval	int		TRUE=o^ FALSE=o^łȂ
 */
//--------------------------------------------------------------
void FieldOBJ_RenderCont_OBJRegFree( FIELD_OBJ_RENDER_CONT_PTR rdcont, int code )
{
	RDOBJDATA *data = RdC_CodeSearch( rdcont->rdobjdata, code, rdcont->obj_max );
	RdC_Delete( data );
}

//--------------------------------------------------------------
/**
 * _OBJǗ@w肳ꂽcodẽ_擾
 * @param	fes		SYS_PTR
 * @param	max		OBJǗő吔
 * @retval	int		TRUE=o^ FALSE=o^łȂ
 */
//--------------------------------------------------------------
NNSG3dRenderObj * FieldOBJ_RenderCont_OBJRenderGet( FIELD_OBJ_RENDER_CONT_PTR rdcont, int code )
{
	RDOBJDATA *data = RdC_CodeSearch( rdcont->rdobjdata, code, rdcont->obj_max );
	return( &data->render );
}

//--------------------------------------------------------------
/**
 * _OBJǗ@w肳ꂽcodẽf擾
 * @param	fes		SYS_PTR
 * @param	max		OBJǗő吔
 * @retval	int		TRUE=o^ FALSE=o^łȂ
 */
//--------------------------------------------------------------
NNSG3dResMdl * FldOBJrdcont_OBJModelGet( FIELD_OBJ_RENDER_CONT_PTR rdcont, int code )
{
	RDOBJDATA *data = RdC_CodeSearch( rdcont->rdobjdata, code, rdcont->obj_max );
	return( data->model );
}

//==============================================================================
//	_OBJ@p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * _OBJǗ@Xy[XT
 * @param	data	RDOBJDATA
 * @param	max		datavf
 * @retval	RDOBJDATA*	RDOBJDATA *
 */
//--------------------------------------------------------------
static RDOBJDATA * RdC_SpaceSearch( RDOBJDATA *data, int max )
{
	int i = 0;
	while( i < max ){ if(data->res_file == NULL){return(data);} i++; data++; }
	GF_ASSERT( 0 && "rdcont_SpaceSeach()󂫂Ȃ" );
	return( NULL );
}

//--------------------------------------------------------------
/**
 * _OBJǗ@R[hT
 * @param	data	RDOBJDATA
 * @param	code	R[h
 * @param	max		datavf
 * @retval	RDOBJDATA*	codeɈvRDOBJDATA *
 */
//--------------------------------------------------------------
static RDOBJDATA * RdC_CodeSearch( RDOBJDATA *data, int code, int max )
{
	int i = 0;
	while( i < max ){ if(data->code == code){return(data);} i++; data++; }
	GF_ASSERT( 0 && "rdcont_CodeSearch()o^ĂȂR[hł" );
	return( NULL );
}

//--------------------------------------------------------------
/**
 * _OBJǗ@폜
 * @param	data	폜RDOBJDATA
 * @retval	nothing
 */
//--------------------------------------------------------------
static void RdC_Delete( RDOBJDATA *data )
{
	sys_FreeMemoryEz( data->res_file );
	memset( data, NULL, RDOBJDATA_SIZE );
}

//==============================================================================
//	tB[hOBJ _OBJ
//==============================================================================

