//===========================================================================
/**
 * @file	fieldsys.c
 * @brief	Q[C
 * @author	tamada	GAME FREAK Inc.
 *
 */
//===========================================================================
#include "common.h"

#define __FIELDSYS_H_GLOBAL__
#include "fieldsys.h"

#include "field/field.h"
#include "system/main.h"
#include "system\render_oam.h"

#include "fieldmap.h"
#include "fieldmap_work.h"

#include "field_event.h"

#include "system/savedata.h"

#include "ev_mapchange.h"		//EventSet_FirstMapIn

#include "zonedata.h"
#include "fielddata/maptable/zone_id.h"

#include "system/pm_overlay.h"
#include "field/situation.h"
#include "field/situation_local.h"

#include "communication/communication.h"  // ʐM̂
#include "comm_player.h"  // ʐM̂
#include "comm_field_state.h"// ʐM̂

#include "ev_check.h"		//EV_REQUEST

#include "demo/title.h"


#include "field_poketch.h"
#include "eventdata.h"

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/25
// ؍łł͂łƂ\Eɋo^
#if PM_LANG == LANG_KOREA
#include "savedata/wifihistory.h"
#endif
// ----------------------------------------------------------------------------


#ifdef PM_DEBUG

#define WORLD_HEAP_LEAK_CHECK	//[hq[v[N`FbNp
#define	EVENT_HEAP_LEAK_CHECK	//Cxgq[v[N`FbNp
#define	SYSTEM_HEAP_LEAK_CHECK	//VXeq[v[N`FbNp

static u32 SystemHeapFreeSize = 0;
static u32 WorldHeapFreeSize = 0;
static u32 EventHeapFreeSize = 0;

#endif


FS_EXTERN_OVERLAY( title );
FS_EXTERN_OVERLAY( fieldmap );
//FS_EXTERN_OVERLAY( fieldmap2 );

static FIELDSYS_WORK * GameSystem_Init(PROC * proc);
static BOOL GameSystem_Main(FIELDSYS_WORK * fsys);
static void GameSystem_End(PROC * proc);


static void FieldMap_Control(FIELDSYS_WORK * fsys);
/*---------------------------------------------------------------------------*
 *---------------------------------------------------------------------------*/

//------------------------------------------------------------------
/**
 * @brief	䃏[Np\̒`
 */
//------------------------------------------------------------------
typedef struct _CONTROL_WORK{
	PROC * mainproc;		///<CvZXێ[N
	PROC * subproc;			///<TuvZXێ[N
	BOOL pause_flag;		///<|[YtOifobOpj
	BOOL end_flag;			///<ItOifobOpHj
};

//------------------------------------------------------------------
/**
 * @brief	C䃏[N
 */
//------------------------------------------------------------------
static FIELDSYS_WORK	* FieldSysWork;


//===========================================================================
//
//
//		Q[CvZX֐
//
//
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	Q[CvZXFFReBj[
 */
//------------------------------------------------------------------
static PROC_RESULT ContinueGameMainProc_Init(PROC * proc, int * seq)
{
	MAINWORK * main = PROC_GetParentWork(proc);

	FieldSysWork = GameSystem_Init(proc);
	if (main->comm_error_flag) {
		EventSet_ErrorContinueMapIn(FieldSysWork);
	} else {
		EventSet_ContinueMapIn(FieldSysWork);
	}
	main->comm_error_flag = FALSE;
	return PROC_RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	Q[CvZXFF傩
 */
//------------------------------------------------------------------
static PROC_RESULT FirstGameMainProc_Init(PROC * proc, int * seq)
{
	FieldSysWork = GameSystem_Init(proc);
	EventSet_FirstMapIn(FieldSysWork);
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/25
// ؍łł͂łƂ\Eɋo^
#if PM_LANG == LANG_KOREA
	WIFIHISTORY_SetMyNationArea(
		SaveData_GetWifiHistory(FieldSysWork->savedata),
		WIFI_NATION_KOREA, 0
	);
#endif
// ----------------------------------------------------------------------------
	return PROC_RES_FINISH;
}


//------------------------------------------------------------------
/**
 * @brief	Q[CvZXFC
 */
//------------------------------------------------------------------
static PROC_RESULT GameMainProc_Main(PROC * proc, int * seq)
{
	FIELDSYS_WORK * fsys = PROC_GetWork(proc);

	if (GameSystem_Main(fsys)) {
		return PROC_RES_FINISH;
	} else {
		return PROC_RES_CONTINUE;
	}
}
//------------------------------------------------------------------
/**
 * @brief	Q[CvZXFI
 *
 * ۂɂ͌Ă΂邱Ƃ͂Ȃƍl
 */
//------------------------------------------------------------------
static PROC_RESULT GameMainProc_End(PROC * proc, int * seq)
{
	GameSystem_End(proc);
	Main_SetNextProc(FS_OVERLAY_ID(title), &TitleProcData);
	return PROC_RES_FINISH;
}

//------------------------------------------------------------------
//------------------------------------------------------------------
const PROC_DATA FirstGameProcData = {
	FirstGameMainProc_Init,
	GameMainProc_Main,
	GameMainProc_End,
	NO_OVERLAY_ID
};

//------------------------------------------------------------------
//------------------------------------------------------------------
const PROC_DATA ContinueGameProcData = {
	ContinueGameMainProc_Init,
	GameMainProc_Main,
	GameMainProc_End,
	NO_OVERLAY_ID
};
//===========================================================================
//
//	֐
//
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	tB[h}bvC
 * @param	fsys	tB[h䃏[Nւ̃|C^
 */
//------------------------------------------------------------------
void GameSystem_CreateFieldProc(FIELDSYS_WORK * fsys)
{
	GF_ASSERT(fsys->ctrl->subproc == NULL);
	GF_ASSERT(fsys->ctrl->mainproc == NULL);
	Overlay_Load( FS_OVERLAY_ID( fieldmap ), OVERLAY_LOAD_NOT_SYNCHRONIZE );
	//Overlay_Load( FS_OVERLAY_ID( fieldmap2 ), OVERLAY_LOAD_NOT_SYNCHRONIZE );
	fsys->main_mode_flag = FALSE;
	fsys->ctrl->pause_flag = FALSE;
	fsys->ctrl->mainproc = PROC_Create(&FieldProcData, fsys, HEAPID_WORLD);
}

//------------------------------------------------------------------
/**
 * @brief	tB[h}bvCINGXg
 * @param	fsys	tB[h䃏[Nւ̃|C^
 */
//------------------------------------------------------------------
void GameSystem_FinishFieldProc(FIELDSYS_WORK * fsys)
{
	fsys->main_mode_flag = FALSE;
}
//------------------------------------------------------------------
/**
 * @brief	tB[h}bvC̑݃`FbN
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @retval	TRUE	tB[h}bvC݂Ă
 * @retval	FALSE	tB[h}bvC݂͑ĂȂ
 */
//------------------------------------------------------------------
BOOL GameSystem_CheckFieldProcExists(FIELDSYS_WORK * fsys)
{
	return (fsys->ctrl->mainproc != NULL);
}

//------------------------------------------------------------------
/**
 * @brief	tB[h}bvC`FbN
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @retval	TRUE	tB[h}bvC삵Ă
 * @retval	FALSE	tB[h}bvC͓삵ĂȂ
 *					iTuvZX쒆AEIj
 */
//------------------------------------------------------------------
BOOL GameSystem_CheckFieldMain(FIELDSYS_WORK * fsys)
{
	if (fsys->ctrl->mainproc != NULL && fsys->main_mode_flag) {
		return TRUE;
	} else {
		return FALSE;
	}
}

//------------------------------------------------------------------
/**
 * @brief	tB[hTuvZX̑݃`FbN
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @retval	TRUE	tB[hTuvZX݂Ă
 * @retval	FALSE	tB[hTuvZX݂͑ĂȂ
 */
//------------------------------------------------------------------
BOOL GameSystem_CheckSubProcExists(FIELDSYS_WORK * fsys)
{
	return (fsys->ctrl->subproc != NULL);
}

//------------------------------------------------------------------
/**
 * @brief	tB[hTuvZX̐
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	pdata	vZXf[^
 * @param	param	vZXɓnp[^
 */
//------------------------------------------------------------------
void GameSystem_StartSubProc(FIELDSYS_WORK * fsys, const PROC_DATA * pdata, void * param)
{
	GF_ASSERT(fsys->ctrl->subproc == NULL);
	GameSystem_FinishFieldProc(fsys);
	fsys->ctrl->subproc = PROC_Create(pdata, param, HEAPID_WORLD);
}

//------------------------------------------------------------------
/**
 * @brief	Q[C̏I
 * @param	fsys	tB[h䃏[Nւ̃|C^
 */
//------------------------------------------------------------------
void GameSystem_FinishGame(FIELDSYS_WORK * fsys)
{
	fsys->ctrl->end_flag = TRUE;
}

//===========================================================================
//
//
//		֐
//
//
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	Q[
 * @param	proc		vZXւ̃|C^
 * @return	FIELDSYS_WORK	tB[hC䃏[Nւ̃|C^
 */
//------------------------------------------------------------------
static FIELDSYS_WORK * GameSystem_Init(PROC * proc)
{
	MAINWORK * main;
	FIELDSYS_WORK * fsys;

	//[hq[vm(mۂςȂ)
	//sys_CreateHeap( HEAPID_BASE_APP, HEAPID_WORLD, 0x20000 );
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_WORLD, 0x1c000 );
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_EVENT, 0x04000 );
	sys_CreateHeap( HEAPID_BASE_SYSTEM, HEAPID_COMMICON, 0x300 );

	//tB[hC䃏[Nm
	fsys = PROC_AllocWork(proc, sizeof(FIELDSYS_WORK), HEAPID_WORLD);
	MI_CpuClear8(fsys, sizeof(FIELDSYS_WORK));

	//tB[hp[Nm
	fsys->ctrl = sys_AllocMemory(HEAPID_WORLD, sizeof(CONTROL_WORK));
	fsys->ctrl->mainproc = NULL;
	fsys->ctrl->subproc = NULL;
	fsys->ctrl->pause_flag = FALSE;
	fsys->ctrl->end_flag = FALSE;

	//Z[uf[^ւ̃|C^蓖
	main = PROC_GetParentWork(proc);
	fsys->savedata = main->savedata;

	fsys->event = NULL;

	fsys->location = Situation_GetNowLocation(SaveData_GetSituation(fsys->savedata));

	//Q[p̃[Nm
	//Q[AɊmۂĂ郏[N͂Ŋmۂ
	fsys->World = WorldMapInit();								//[h}bv\̊m
	EventData_Sys_Create(fsys, HEAPID_WORLD);					//Cxgf[^䐶
	fsys->bag_cursor = MyItem_BagCursorAlloc(HEAPID_WORLD);		//obÕJ[\
	fsys->SwayGrass = SwayGrass_AllocSwayGrass(HEAPID_WORLD);	//hꑐ\̃m
	SwayGrass_InitSwayGrass(fsys->SwayGrass);	//hꑐ
	fsys->p_zukandata = ZKN_DW_Alloc( HEAPID_WORLD );	// }ӃXgʒuۑ̈


	return fsys;
}

//===========================================================================
//
//
//		I֐
//
//
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	Q[I
 * @param	proc		vZXւ̃|C^
 */
//------------------------------------------------------------------
static void GameSystem_End(PROC * proc)
{
	FIELDSYS_WORK * fsys = PROC_GetWork(proc);

	//Q[p̃[N
	//Q[AɊmۂĂ郏[N͂ŉ
	WorldMapRelease(fsys->World);				// [h}bv\̉
	EventData_Sys_Delete(fsys);					// Cxgf[^
	sys_FreeMemoryEz(fsys->bag_cursor);			// obÕJ[\
	SwayGrass_FreeSwayGrass(fsys->SwayGrass);	//hꑐ[N
	ZKN_DW_Free( fsys->p_zukandata );			// }ӃXgʒuۑ̈

	sys_FreeMemoryEz(fsys->ctrl);
	PROC_FreeWork(proc);
	sys_DeleteHeap(HEAPID_COMMICON);
	sys_DeleteHeap(HEAPID_WORLD);
	sys_DeleteHeap(HEAPID_EVENT);
}


//===========================================================================
/**
 * 
 * C֐
 *
 */
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	TuvZXĂяo
 * @param	proc	TuvZX|C^ێ郏[Nւ̃|C^
 */
//------------------------------------------------------------------
static void ProcCall(PROC ** proc)
{
	if (*proc) {
		if (ProcMain(*proc)) {
			PROC_Delete(*proc);
			*proc = NULL;
		}
	}
}
//------------------------------------------------------------------
/**
 * @brief	Q[C
 * @param	fsys	tB[hC䃏[Nւ̃|C^
 * @retval	TRUE	I
 * @retval	FALSE	p
 */
//------------------------------------------------------------------
BOOL GameSystem_Main(FIELDSYS_WORK * fsys)
{
	BOOL event_end;

    FieldMap_Control(fsys);
	event_end = FieldEvent_Control(fsys);
	if(event_end == TRUE && fsys->fldmap != NULL)
	{
		//|Pb`X[v
		Field_SendPoketchInfo( fsys, POKETCH_SEND_SLEEP, FALSE );
	}


	if (fsys->ctrl->mainproc) {
		ProcCall(&fsys->ctrl->mainproc);
		if (fsys->ctrl->mainproc == NULL) {
			Overlay_UnloadID( FS_OVERLAY_ID(fieldmap) );
			//Overlay_UnloadID( FS_OVERLAY_ID(fieldmap2) );
		}
	} else if (fsys->ctrl->subproc) {
		ProcCall(&fsys->ctrl->subproc);
	}

	if (fsys->ctrl->end_flag && !fsys->event
			&& !fsys->ctrl->mainproc && !fsys->ctrl->subproc) {
		//INGXgACxgTuvZXCvZX
		//ȂΏI
		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * @ACxg`FbN
 *
 * @param	fsys		FIELDSYS_WORK
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void FieldMap_Control(FIELDSYS_WORK * fsys)
{
	int map_mode;
	EV_REQUEST	req;
    BOOL bMoveControl = FALSE;

    //|[YԂłȂA
    //tB[hC삵Ă
    //CxgĂȂꍇA
    //	e폈s
    if (!fsys->ctrl->pause_flag
        && fsys->main_mode_flag
        && FieldEvent_Check(fsys) == FALSE) {
        bMoveControl = TRUE;
    }

#ifdef	PM_DEBUG
	if (bMoveControl) {
		if (MAP_MODE_GROUND == fsys->MapMode){
#ifdef SYSTEM_HEAP_LEAK_CHECK
			if (SystemHeapFreeSize == 0) {
				SystemHeapFreeSize = sys_GetHeapFreeSize(HEAPID_BASE_SYSTEM);
			} else if (SystemHeapFreeSize != sys_GetHeapFreeSize(HEAPID_BASE_SYSTEM)) {
				sys_DeleteHeap(HEAPID_BASE_SYSTEM);
				GF_ASSERT_MSG(0, "SYSTEM HEAP SIZE %d < %d\n",
						SystemHeapFreeSize, sys_GetHeapFreeSize(HEAPID_BASE_SYSTEM));
			}
#endif

#ifdef WORLD_HEAP_LEAK_CHECK		
			if (WorldHeapFreeSize == 0) {
				WorldHeapFreeSize = sys_GetHeapFreeSize(HEAPID_WORLD);
			} else if (WorldHeapFreeSize != sys_GetHeapFreeSize(HEAPID_WORLD)){
				bMoveControl = FALSE;
			}
#endif	//WORLD_HEAP_LEAK_CHECK

#ifdef	EVENT_HEAP_LEAK_CHECK
			if (EventHeapFreeSize == 0) {
				EventHeapFreeSize = sys_GetHeapFreeSize(HEAPID_EVENT);
			} else if (EventHeapFreeSize != sys_GetHeapFreeSize(HEAPID_EVENT)) {
				bMoveControl = FALSE;
			}
#endif	//EVENT_HEAP_LEAK_CHECK

			if (bMoveControl == FALSE) {
				//q[ṽ[No^Cgɖ߂
				//^CgŃq[vĴŃ[Nӏ킩
				EventSet_ReturnToTitle(fsys);
			}
		}
	}
#endif

    if(bMoveControl){
		Player_MoveStateUpdate( fsys->player );
        SetRequest( &req, fsys, sys.trg, sys.cont );
    }
	map_mode = fsys->MapMode;

	if(fsys->location->zone_id == ZONE_ID_D31R0201){
		//^[t̃}bv[hMAP_MODE_BTOWER
		//Cxg`FbN̓m[}ɍs
		map_mode = MAP_MODE_GROUND;
	}
    switch(map_mode){
      case MAP_MODE_UNDER:
        if(bMoveControl){
            if(CommPlayerIsControl()){
                if( CheckRequestUG( &req, fsys ) == TRUE ){  // Yz
                }
            }
        }
        CommPlayersMove(fsys, bMoveControl);  // ʐMړ
        break;
      case MAP_MODE_COLOSSEUM:
        if(bMoveControl){
            if(CommPlayerIsControl()){
                if( CheckRequestVSRoom( &req, fsys ) == TRUE ){  // ΐ핔
                    bMoveControl = FALSE;
                }
            }
            else{
                bMoveControl = FALSE;
            }
        }
        CommPlayersMove(fsys, bMoveControl);  // ʐMړ
        break;
      case MAP_MODE_UNION:
        if(bMoveControl){
            if( CheckRequestUnion( &req, fsys ) == TRUE ){
                //CxgNȀɓ
            }else{
                Player_MoveControl( fsys->player,
						fsys->map_cont_dat,DIR_NOT, req.trg, req.cont, FALSE );
            }
        }
        break;
	  case MAP_MODE_BTOWER:
        if(bMoveControl){
            if( CheckRequestBTower( &req, fsys ) == TRUE ){
                StopPlaceName(fsys->fldmap->place_name_cont);	//n\LZ
                BoardSetDirect( fsys, BOARD_REQ_DEL );	// Ŕjij
				Player_EventPoketchCancel( fsys->player );	//@|Pb`ԃLZ
                //|Pb`X[v
                Field_SendPoketchInfo( fsys, POKETCH_SEND_SLEEP, TRUE );
            }
            else{
                //CxgȂĂA{^n\̓LZ
                if (sys.trg & PAD_BUTTON_DECIDE){
                    StopPlaceName(fsys->fldmap->place_name_cont);	//n\LZ
                }
				
				{
					BOOL touch = FALSE;
					POKETCH_WORK *poketch = GetPoketchMainWorkPtr();
					if( poketch != NULL ){ touch = Poketch_CheckTouch( poketch ); }
					
                	Player_MoveControl(
						fsys->player, fsys->map_cont_dat, DIR_NOT, req.trg, req.cont, touch );
				}
            }
        }
		break;
      default: // ʐMĂȂʂ̏
        if(bMoveControl){
            if( CheckRequest( &req, fsys ) == TRUE ){
                StopPlaceName(fsys->fldmap->place_name_cont);	//n\LZ
                BoardSetDirect( fsys, BOARD_REQ_DEL );	// Ŕjij
				Player_MoveStateClear( fsys->player );	//@ԁi]ԑxȂǁjNA
				Player_EventPoketchCancel( fsys->player );	//@|Pb`ԃLZ
                //|Pb`X[v
                Field_SendPoketchInfo( fsys, POKETCH_SEND_SLEEP, TRUE );
            }
            else{
                //CxgȂĂA{^n\̓LZ
                if (sys.trg & PAD_BUTTON_DECIDE){
                    StopPlaceName(fsys->fldmap->place_name_cont);	//n\LZ
                }
				
				{
					BOOL touch = FALSE;
					POKETCH_WORK *poketch = GetPoketchMainWorkPtr();
					if( poketch != NULL ){ touch = Poketch_CheckTouch( poketch ); }
					
                	Player_MoveControl(
						fsys->player, fsys->map_cont_dat, DIR_NOT, req.trg, req.cont, touch );
				}
            }
        }
        break;
    }
}

//===========================================================================
/**
 * 
 * Av^XNݒ(tB[h̓z[hԂɂȂ)
 *
 */
//===========================================================================
void FieldSystemProc_SeqHold(void)
{
	FieldSysWork->ctrl->pause_flag = TRUE;
    CommDisableSendMoveData();  // ړ֎~
}


//===========================================================================
/**
 * 
 * Av^XNI(tB[hA)
 *
 */
//===========================================================================
void FieldSystemProc_SeqHoldEnd(void)
{
	FieldSysWork->ctrl->pause_flag = FALSE;
    CommEnableSendMoveData();  //ړ
}


//===========================================================================
//
// |Pb`֘A
//
//===========================================================================

struct _POKETCH_WORK* GetPoketchMainWorkPtr(void)
{
	if (FieldSysWork->fldmap == NULL) {
		return NULL;
	}
	return FieldSysWork->fldmap->poketch;
}


//===========================================================================
//
//
//
//===========================================================================
//------------------------------------------------------------------
//------------------------------------------------------------------
GF_BGL_INI * FieldBglIniGet( void * fsys )
{
	FIELDSYS_WORK * wk = (FIELDSYS_WORK *)fsys;

	return wk->bgl;
}

//------------------------------------------------------------------
/**
 * @brief	Z[uf[^ւ̃|C^擾
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @return	SAVEDATA	Z[uf[^ւ̃|C^
 */
//------------------------------------------------------------------
SAVEDATA * GameSystem_GetSaveData(void * fsys)
{
	return ((FIELDSYS_WORK *)fsys)->savedata;
}

