//=============================================================================
/**
 * @file	fieldsys.h	
 * @brief	tB[h}bvVXe
 * @author	GAME FREAK inc.
 */
//=============================================================================
#ifndef	__FIELDSYS_H__
#define	__FIELDSYS_H__

//==============================================================================
//	include
//==============================================================================
#include "field_common.h"

#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂
#include "system/pms_data.h"
#include "worldmap_def.h"
#include "mapresource_def.h"

#include "field_glb_state.h"
#include "fog_sys.h"
#include "field_light.h"
#include "weather_sys_def.h"
#include "field_anime_def.h"

#include "system\procsys.h"

#include "fieldobj.h"
#include "player.h"
#include "field/poketch.h"

#include "field_3d_anime.h"
#include "div_map.h"
#include "map_tool.h"
#include "ug_radar.h"

#include "place_name.h"

#include "field_effect.h"
#include "board.h"
#include "comm_union.h"
#include "comm_union_view.h"

#include "union_board.h"

#include "sway_grass_enc.h"

#include "field/location.h"

#include "application\tradelist.h"

#include "sp_attribute_def.h"
#include "floor_touch.h"
#include "honey_tree_enc.h"
#include "savedata/fnote_mem.h"

#include "itemtool/myitem.h"

#include "savedata/b_tower.h"
#include "b_tower_scr.h"

#include "savedata/regulation.h"

#include "map_mode.h"

#include "application/zukanlist/zkn_data_work.h"

//--------------------------------------------------------------
//	extern
//--------------------------------------------------------------
#undef GLOBAL
#ifdef __FIELDSYS_H_GLOBAL__
#define GLOBAL /*	*/
#else
#define GLOBAL extern
#endif

//==============================================================================
//	define
//==============================================================================
//--------------------------------------------------------------
//	r{[hAN^
//--------------------------------------------------------------
enum
{
	FIELDSYS_BLACTSET_FIELD_OBJ = 0,	///<tB[hOBJ add kaga
	FIELDSYS_BLACTSET_DEBUG_KUSA,		///<p add kaga
	FIELDSYS_BLACTSET_COMM,				///<ʐMGtFNg add ohno
	FIELDSYS_BLACTSET_FIELD_EFFECT,		///<tB[hGtFNg add kaga
	
	FIELDSYS_BLACTSET_NUM,				///<r{[hAN^[Zbgo^
};

//--------------------------------------------------------------
//	tB[hGtFNg
//--------------------------------------------------------------
#define FE_EFFECT_MAX			(FE_PROC_MAX)
#define FE_HEAP_SIZE			(0x18000)
//#define FE_EOA_MAX				(64)	///<tB[hGtFNg@EOAő吔
#define FE_EOA_MAX				(80)	///<tB[hGtFNg@EOAő吔
#define FE_BLACT_MAX			(32)	///<tB[hGtFNg@r{[hő吔
#define FE_BLACT_MDL_MAX		(32)
#define FE_BLACT_MDL_HEAP_SIZE	(0x0500*(FE_BLACT_MDL_MAX/2))
#define FE_BLACT_ANM_MAX		(32)
#define FE_BLACT_ANM_HEAP_SIZE	(0x0080*(FE_BLACT_ANM_MAX/2))
#define FE_BLACT_TEX_MAX		(32)
#define FE_BLACT_TEX_HEAP_SIZE	(0x0800*FE_BLACT_TEX_MAX)

//------------------------------------------------------------------
///	Tuʂ̎
//------------------------------------------------------------------
typedef enum {
	FIELD_SUBSCRN_POKETCH = 1,		///<ʏi|Pb`j
	FIELD_SUBSCRN_UNDER,			///<Yzi[_[ʁj
	FIELD_SUBSCRN_UNION,			///<jI[ (f)
	FIELD_SUBSCRN_NO_POKETCH,		///<|Pb`ȂA{[̂݉

	FIELD_SUBSCRN_MAX,
}FIELD_SUBSCRN_TYPE;

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	䃏[Np`
//--------------------------------------------------------------
typedef struct _CONTROL_WORK CONTROL_WORK;

//--------------------------------------------------------------
///	ENCOUNT_CHECK\
//--------------------------------------------------------------
typedef struct {
	u16	walk_count;		// JE^
//	u16	before_attr;	// ÕAgr[g
//	u16	plus_per;		// mvXl
	u16	WinPokeCount;
}ENCOUNT_CHECK;

//--------------------------------------------------------------
///EVENTDATA\̂ւ̃|C^
//--------------------------------------------------------------
typedef struct EVENT_DATA EVENT_DATA;

//--------------------------------------------------------------
//--------------------------------------------------------------
typedef struct MMDL_WORK MMDL_WORK;

//--------------------------------------------------------------
/**
 * @brief	tB[h}bv胏[N
 *
 * FIELDSYS_WORK̃o̒ŁAtB[h}bvł
 * ANZXȂ̂͂ֈڂƁB
 */
//--------------------------------------------------------------
typedef struct FIELDMAP_WORK FIELDMAP_WORK;

//--------------------------------------------------------------
///VXeRg[[N\
//--------------------------------------------------------------
struct _FIELDSYS_WORK	{

	CONTROL_WORK * ctrl;	///<p[N

	FIELDMAP_WORK * fldmap;

	GF_BGL_INI * bgl;		///<BGLf[^

	SAVEDATA * savedata;	///<Z[uQ[isf[^

	GMEVENT_CONTROL * event;	///<Cxg

	EVENT_DATA * eventdata;		///<][Cxgf[^

	FIELD_SUBSCRN_TYPE subscreen;	///<Tuʂ̎ގw
	//fldmapɈړ	POKETCH_WORK * poketch;

	LOCATION_WORK * location;		///<ʒu

	GF_CAMERA_PTR	camera_ptr;		//J|C^
	DMC_PTR	map_cont_dat;	//[h\̂̌oRQƗp|C^
	
	WORLD_MAP_PTR World;

	MAP_RESOURCE_PTR MapResource;	//tB[h\\[XQƗp|C^
	MMDL_WORK * mmdl;			///<GAʓ샂fXgf[^ւ̃|C^
	
	///PCD_PTR player_cont_dat;//@W\̂̌oRQƗp|C^
	FIELD_OBJ_SYS_PTR fldobjsys;	//tB[hOBJQ*
	PLAYER_STATE_PTR player;	//@Qƃ|C^
	
	FE_SYS *fes;				//tB[hGtFNgQƃ|C^
	
	GLST_DATA_PTR		glst_data;		// CgE}eȀԕۑ̈
	FOG_DATA_PTR		fog_data;		// tHȌԕۑ̈
	LIGHT_CONT_PTR		light_cont_data;// P\CgE}eAf[^
	//fldmapɈړ	WEATHER_MANAGER_PTR weather_data;	// VCf[^
	//fldmapɈړ	FIELD_ANIME_PTR		field_trans_anime;	// ]AjVXe
	FLD_3D_ANM_MNG_PTR		field_3d_anime;
	ANIME_CONT_MNG_PTR	AnimeContMng;
	SMD_PTR				SpMatData;
	MTL_CONST_PTR		map_tool_list;
///	DFL_CONST_PTR		div_func_list;
	DIV_MAP_MODE		DivMapMode;
	//fldmapɈړ	PNC_PTR				place_name_cont;//n\

	BOARD_WORK * board;		// Ŕ\
	
	BOOL	main_mode_flag;

	UG_RADAR_WORK    *UnderGroundRadar;		// Yz[_[[NQƗp|C^
	MAP_MODE MapMode;		//nォn𔻕ʂ̂Ɏgp
	const MAP_MODE_DATA * MapModeData;

	ENCOUNT_CHECK	encount;	// GJEg`FbNp[N
	COMM_UNIONROOM_WORK *union_work;			// jI[p[N|C^
	COMM_UNIONROOM_VIEW *union_view;			// jI[`揈p[N
	UNION_BOARD_WORK    *union_board;			// jI[fiTuʁj[N
	TRADELIST_WORK      *tradelist_work;

	TP_TO_3D_PTR		TpTo3DPtr;				//3DʂƂ̃^b`p

	int	startmenu_pos;					//tB[h/ñj[̃J[\ʒu

	SWAY_GRASS_PTR SwayGrass;
	BAG_CURSOR * bag_cursor;			//obÕJ[\
	FNOTE_DATA * fnote;					//Ώۖ`m[gy[Wւ̃|C^
	EHL_PTR	ExHeightList;
	M3DOL_PTR Map3DObjExp;			//gzuf

	HTD_PTR HoneyTreePtr;			//hp

	BTOWER_SCRWORK*	btower_wk;		///<og^[p[N|C^
    const REGULATION* regulation;     ///< Kp郌M[V|C^
	ZKN_DATA_WORK*	p_zukandata;	///<}ӃO[of[^
	BOOL scope_mode_flag;				///<][htO
};



//==============================================================================
//	OQ
//==============================================================================
GLOBAL void FieldSystemProc_SeqHold(void);
GLOBAL void FieldSystemProc_SeqHoldEnd(void);


extern const PROC_DATA FieldProcData;

extern BOOL GameSystem_CheckSubProcExists(FIELDSYS_WORK * fsys);
extern void GameSystem_StartSubProc(FIELDSYS_WORK * fsys, const PROC_DATA * proc, void * param);

extern BOOL GameSystem_CheckFieldProcExists(FIELDSYS_WORK * fsys);
extern BOOL GameSystem_CheckFieldMain(FIELDSYS_WORK * fsys);
extern void GameSystem_CreateFieldProc(FIELDSYS_WORK * fsys);
extern void GameSystem_FinishFieldProc(FIELDSYS_WORK * fsys);

//ԂfobOłgpȂ
extern void GameSystem_FinishGame(FIELDSYS_WORK * fsys);


GLOBAL struct _POKETCH_WORK* GetPoketchMainWorkPtr(void);

extern GF_BGL_INI * FieldBglIniGet( void * fsys );
extern SAVEDATA * GameSystem_GetSaveData(void * fsys);


#undef GLOBAL


//TuvZX̎QƐ錾͂̒Ɂc
#include "field_subproc.h"

#endif	/* __FIELDSYS_H__ */
