//==============================================================================================
/**
 * @file	fld_bgm.c
 * @brief	tB[hTEh
 * @author	Satoshi Nohara
 * @date	2005.10.14
 */
//==============================================================================================
#include "common.h"
#include "fieldsys.h"
#include "system/snd_tool.h"
#include "system/gamedata.h"		//POKE_NUM_MAX
#include "system/pm_rtc.h"			//GF_RTC_IsNightTime
#include "mapdefine.h"				//ZONE_ID_C01
#include "zonedata.h"				//ZoneData_GetBGMID
#include "player.h"					//HERO_FORM_SWIM
#include "sway_grass_enc.h"
#include "fld_bgm.h"
#include "field/situation_local.h"

#include "battle/battle_common.h"	//CN[hɕKv
#include "poketool/tr_tool.h"
#include "battle/trtype_def.h"

#include "tr_bgm.dat"
#include "sysflag.h"


//==============================================================================================
//
//	ϐ
//
//==============================================================================================


//==============================================================================================
//
//	vg^Cv錾
//
//==============================================================================================
void Snd_GameOverSet();
void Snd_RestartSet( FIELDSYS_WORK* fsys );

//tB[hBGMio[擾
u16 Snd_FieldBgmNoGet( FIELDSYS_WORK* fsys, int zone_id );

//tB[hBGMio[擾(BASIC_BANK)
u16 Snd_FieldBgmNoGetNonBasicBank( FIELDSYS_WORK* fsys, int zone_id );

//"][܂p"tF[hAEg  BGMĐ(tB[hp)
BOOL Snd_FadeOutNextPlayCall( FIELDSYS_WORK* fsys, u16 seq_no, int mode );

//"}bvJڐp"@tF[hAEg  BGMĐ(tB[hp)
static BOOL Snd_MapChangeFadeOutNextPlayCall( FIELDSYS_WORK* fsys, u16 seq_no, int mode );

//ev_mapchange.cp̊֐
BOOL Snd_MapChangeFadeOutNextPlaySub( FIELDSYS_WORK* fsys, int zone_id, int mode );

//[J֐
static void Snd_BgmFadeOutTimeGet( FIELDSYS_WORK* fsys, int mode, int* frame, int* next_wait );

//BGMio[擾
u16 Snd_EyeBgmGet( int tr_id );
u16 Snd_BattleBgmGet( u32 fight_type, int tr_id );
u16 Snd_ZoneDataBgmNoGet( int zone_id );


//==============================================================================================
//
//	֐
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	Q[I[o[ɂ鏈(field_encount.cĂ΂)
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_GameOverSet()
{
	//SĂ̍Đ̃V[PX~
	Snd_Stop();

	//SẴ|[YtONA
	Snd_PauseClearAll();

	//tB[hV[tB[hV[̃[ĥŁA
	//xV[NAĂAtB[hf[^[h֐i
	Snd_SceneSet( SND_SCENE_DUMMY );

	return;
}

//--------------------------------------------------------------
/**
 * @brief	Q[I[o[ɍĊJ鎞̏(field_encount.cĂ΂)
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @retval	none
 *
 * gpI
 */
//--------------------------------------------------------------
void Snd_RestartSet( FIELDSYS_WORK* fsys )
{
	u16 bgm_no;

	//tB[hV[tB[hV[̃[ĥŁA
	//xV[NAĂAtB[hf[^[h֐i
	Snd_SceneSet( SND_SCENE_DUMMY );

	//tB[hf[^[h
	bgm_no = Snd_FieldBgmNoGet( fsys, fsys->location->zone_id );
	Snd_DataSetByScene( SND_SCENE_FIELD, bgm_no, 1 );

	//tF[hC
	Snd_BgmFadeIn(BGM_VOL_MAX, BGM_FADEIN_RESTART_TIME, BGM_FADEIN_START_VOL_MIN);

	return;
}

//--------------------------------------------------------------
/**
 * @brief	BGMwZbg
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	bgm_no	BGMio[
 *
 * @retval	none
 *
 * }bvBGMw肪Zbg
 * ]BGM̐ȂǂɎgp
 */
//--------------------------------------------------------------
void Snd_FieldBgmSetSpecial( FIELDSYS_WORK* fsys, u16 bgm_no )
{
	u16* situation_bgm	= Situation_GetBGMWork( SaveData_GetSituation(fsys->savedata) );
	*situation_bgm		= bgm_no;
	return;
}

//--------------------------------------------------------------
/**
 * @brief	BGMwQbg
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @retval	"BGMio["
 *
 * }bvBGMw肪Zbg
 * ]BGM̐ȂǂɎgp
 */
//--------------------------------------------------------------
u16 Snd_FieldBgmGetSpecial( FIELDSYS_WORK* fsys )
{
	u16* situation_bgm	= Situation_GetBGMWork( SaveData_GetSituation(fsys->savedata) );
	return (*situation_bgm);
}

//--------------------------------------------------------------
/**
 * @brief	BGMwNA
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @retval	none
 *
 * }bvBGMw肪NA
 * ]BGM̐ȂǂɎgp
 */
//--------------------------------------------------------------
void Snd_FieldBgmClearSpecial( FIELDSYS_WORK* fsys )
{
	u16* situation_bgm	= Situation_GetBGMWork( SaveData_GetSituation(fsys->savedata) );
	*situation_bgm		= 0;
	return;
}

//--------------------------------------------------------------
/**
 * @brief	tB[hBGMio[擾
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	zone_id	][ID
 *
 * @retval	"tB[hBGMio["
 *
 * }bvǗ\͒ڌȂŁÅ֐ʂBGMio[擾
 */
//--------------------------------------------------------------
u16 Snd_FieldBgmNoGet( FIELDSYS_WORK* fsys, int zone_id )
{
	PLAYER_STATE_PTR player;
	int status;
	u16 bgm_no,ret;

	player = fsys->player;
	status = Player_FormGet(player);

	//g蒆`FbN
	if( status == HERO_FORM_SWIM ){
		return SEQ_NAMINORI;
	}

	//ꑐ`FbN
	if( SwayGrass_CheckValid(fsys->SwayGrass) == TRUE ){
		return SEQ_KUSAGASA;
	}

	//tB[hBGMio[擾(BASIC_BANK)
	bgm_no = Snd_FieldBgmNoGetNonBasicBank( fsys, zone_id );

	/*
	INIT_CHANGEŁABmgSpecialSetĂяoāA
	CxgȐ؂ւ𔽉f悤ƎvA
	̃][̋ȃtF[hCA
	̃][INIT_CHANGEɂ邽ߏoȂI
	Ȃ̂ŁÃ][ID͎擾łĂ̂ŁA
	ŃCxgtOăCxgȂɐ؂ւI(06.06.17)
	*/

	//BGMw肪ZbgĂ(]ԂȂ)
	if( Snd_FieldBgmGetSpecial(fsys) != 0 ){
		bgm_no = Snd_FieldBgmGetSpecial( fsys );
	}

	return bgm_no;
}

//--------------------------------------------------------------
/**
 * @brief	tB[hBGMio[擾(BASIC_BANK)
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	zone_id	][ID
 *
 * @retval	"tB[hBGMio["
 *
 * }bvJڂ̎́ABASIC_BANKɂȂ̂܂߂Ȃ
 * }bvJڂ̎́Aw̓`FbNKvȂ
 * }bvJڂ̎́A]ԁAȂ݂͈̂pƂ͂Ȃ
 */
//--------------------------------------------------------------
u16 Snd_FieldBgmNoGetNonBasicBank( FIELDSYS_WORK* fsys, int zone_id )
{
	u16 bgm_no,ret;

	//}bvǗ\BGMio[Ԃ
	if( GF_RTC_IsNightTime() == FALSE ){			//FALSE=ATRUE=
		bgm_no = ZoneData_GetDayBGMID( zone_id );
	}else{
		bgm_no = ZoneData_GetNightBGMID( zone_id );
	}

	//CxgBGM؂ւ
	ret = SysFlag_EventBgmGet( SaveData_GetEventWork(fsys->savedata), zone_id );
	if( ret != 0 ){
		bgm_no = ret;
	}

	return bgm_no;
}

//--------------------------------------------------------------
/**
 * @brief	"][܂p"@tF[hAEg  BGMĐ(tB[hp)
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	seq_no	V[PXio[
 * @param	mode	[h(fld_bgm.hQ)
 *
 * @retval	"0=ȂA1=Jn"
 *
 * tB[hȊÓÅ֐gpĉI
 * Snd_BgmFadeOutNextPlaySet(...);
 *
 * ][܂płBHÃ][܂Ɏgp܂B
 * }bvJڂɂ͎gpł܂B
 */
//--------------------------------------------------------------
BOOL Snd_FadeOutNextPlayCall( FIELDSYS_WORK* fsys, u16 seq_no, int mode )
{
	PLAYER_STATE_PTR player;
	int frame,next_wait,status;

	player = fsys->player;
	status = Player_FormGet(player);

	//tB[hBGMŒɂtO`FbN(Z[u͂Ȃ)
	if( Snd_CtrlBgmFlagCheck() == 1 ){
		return 0;		//Ȃ
	}

	//ύXBGMio[ABGMio[Ɠ`FbN
	if( seq_no == Snd_NowBgmNoGet(fsys) ){
		return 0;		//Ȃ
	}

	//CxgŁAABGMPLAYER_BGMŖ炵ȂA}bvJڂƁA
	//PLAYER_FIELD|[YԂ̂܂܂ɂȂĂI
	//][؂ւ̓|[YSăNAĂȂ͂I
	
	//SẴ|[YtONA
	Snd_PauseClearAll();

	//̏o肩A][܂ɂāAtF[hAEgԂςI
	Snd_BgmFadeOutTimeGet( fsys, mode, &frame, &next_wait );

	if( (status == HERO_FORM_CYCLE_R) || (status == HERO_FORM_CYCLE_D) ){
		//]ԂɏĂ鎞̓tF[hAEgtF[hC(oN̂܂܌p)
		Snd_FadeOutNextFadeInSet(SND_SCENE_FIELD, seq_no, frame, next_wait, 
									BGM_FADEIN_CYCLE_TIME, SND_BANK_CONTINUE, NULL);
	}else{
		//ʏ̓tF[hAEgJn(oN̂܂܌p)
		Snd_FadeOutNextPlaySet(SND_SCENE_FIELD, seq_no, frame, next_wait, SND_BANK_CONTINUE, NULL);
	}

	return 1;
}

//--------------------------------------------------------------
/**
 * @brief	"}bvJڐp"@tF[hAEg  BGMĐ(tB[hp)
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	seq_no	V[PXio[
 * @param	mode	[h(fld_bgm.hQ)
 *
 * @retval	"0=ȂA1=Jn"
 *
 * }bvJڐpłBA_Wɓ鎞Ɏgp܂B
 * HÃ][܂ɂ͎gpł܂B
 */
//--------------------------------------------------------------
static BOOL Snd_MapChangeFadeOutNextPlayCall( FIELDSYS_WORK* fsys, u16 seq_no, int mode )
{
	int frame,next_wait;

	/*

	//}bv`FW̃R}hŁA
	//
	//PABGMύX邩`FbN
	//QAύX鎞́A
	//RAtF[hAEg
	//SAtF[hAEg҂
	//܂ł
	//PABGM[hčĐ
	//ɕƃ^C~O₷B
	//A̓^C~OĂB

	//ƁAFLAG_CHANGEŃTEh[ÑNGXgBGMBGMio[āA
	//ɒlĂABGM点悤ɂĂƂ悢B
	//Snd_FieldBgmNoGetŁACxg̃`FbNAXNvgőSĂ悤ɂȂ̂ŁB
	
	*/

	//tB[hBGMŒɂtO`FbN(Z[u͂Ȃ)
	if( Snd_CtrlBgmFlagCheck() == 1 ){
		return 0;		//Ȃ
	}

	//ύXBGMio[ABGMio[Ɠ`FbN
	if( seq_no == Snd_NowBgmNoGet(fsys) ){
		return 0;		//Ȃ
	}

	//CxgŁAABGMPLAYER_BGMŖ炵ȂA}bvJڂƁA
	//PLAYER_FIELD|[YԂ̂܂܂ɂȂĂI
	//][؂ւ̓|[YSăNAĂȂ͂I
	
	//SẴ|[YtONA
	Snd_PauseClearAll();

	//̏o肩A][܂ɂāAtF[hAEgԂςI
	Snd_BgmFadeOutTimeGet( fsys, mode, &frame, &next_wait );

	//tF[hAEgJn(oN؂ւ)
	Snd_FadeOutNextPlaySet(SND_SCENE_FIELD, seq_no, frame, next_wait, SND_BANK_CHANGE, NULL);
	
	return 1;
}

//--------------------------------------------------------------
/**
 * @brief	"}bvJڐp"@ev_mapchange.cp̊֐
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	zone_id	][ID
 * @param	mode	[h(fld_bgm.hQ)
 *
 * @retval	"0=ȂA1=Jn"
 *
 * }bvJڐpłBA_Wɓ鎞Ɏgp܂B
 * HÃ][܂ɂ͎gpł܂B
 */
//--------------------------------------------------------------
BOOL Snd_MapChangeFadeOutNextPlaySub( FIELDSYS_WORK* fsys, int zone_id, int mode )
{
	u16 bgm_no = Snd_FieldBgmNoGet( fsys, zone_id );
	Snd_ZoneBgmSet( Snd_ZoneDataBgmNoGet(zone_id) );				//][̋ȂZbg
	return Snd_MapChangeFadeOutNextPlayCall( fsys, bgm_no, mode );
}


//==============================================================================================
//
//	[J֐
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	tF[hAEgԎ擾
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	mode		[h(fld_bgm.hQ)
 * @param	frame		tF[hAEgt[i[|C^
 * @param	next_wait	BGM炷܂ł̃t[i[|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void Snd_BgmFadeOutTimeGet( FIELDSYS_WORK* fsys, int mode, int* frame, int* next_wait )
{
	//}bvǗ\ŁA][̃^Cv(AtB[hAAȂ)
	//ʂł悤ɂȂÃ[h͂ȂH

	//̏o肩A][܂ɂāAtF[hAEgԂςI
	
	switch( mode ){

	//̏o
	case BGM_FADE_ROOM_MODE:
		*frame		= BGM_FADE_ROOM_TIME;
		*next_wait	= 0;
		break;

	//tB[h̐؂ւ
	case BGM_FADE_FIELD_MODE:
		*frame		= BGM_FADE_FIELD_TIME;
		*next_wait	= 0;
		break;

	//Ȁo
	case BGM_FADE_CAVE_MODE:
		*frame		= BGM_FADE_CAVE_TIME;
		*next_wait	= BGM_NEXT_WAIT_CAVE_TIME;
		break;

	//̑
	case BGM_FADE_OTHERS_MODE:
		*frame		= BGM_FADE_OTHERS_TIME;
		*next_wait	= 0;
		break;
	};

	return;
}

//--------------------------------------------------------------
/**
 * @brief	g[i[BGM擾(XNvgĂ΂)
 *
 * @param	tr_id	g[i[ID
 *
 * @retval	none
 */
//--------------------------------------------------------------
u16 Snd_EyeBgmGet( int tr_id )
{
	u8 type;
	u16 bgm,i;

	type = (u8)TT_TrainerDataParaGet( tr_id, ID_TD_tr_type );

	bgm = SEQ_EYE_KID;	//ی

	for( i=0; i < TRTYPE_BGM_TBL_MAX ;i++ ){

		if( trtype_bgm_tbl[i][0] == type ){
			bgm = trtype_bgm_tbl[i][1];
			break;
		}
	}

	return bgm;
}

//--------------------------------------------------------------
/**
 * @brief	퓬BGM擾
 *
 * @param	fight_type	퓬ʃtO
 * @param	tr_id		g[i[ID
 *
 * @retval	none
 */
//--------------------------------------------------------------
u16 Snd_BattleBgmGet( u32 fight_type, int tr_id )
{
	u8 type;
	u16 bgm = SEQ_BA_POKE;

	//쐶nqTt@   k.ohno ʐMΐŎ~܂̂ŏC

    //g[i[
	if(fight_type == FIGHT_TYPE_TRAINER){

		type = (u8)TT_TrainerDataParaGet( tr_id, ID_TD_tr_type );

		switch( type ){

		//W
		case TRTYPE_LEADER1:
		case TRTYPE_LEADER2:
		case TRTYPE_LEADER3:
		case TRTYPE_LEADER4:
		case TRTYPE_LEADER5:
		case TRTYPE_LEADER6:
		case TRTYPE_LEADER7:
		case TRTYPE_LEADER8:
			bgm = SEQ_BA_GYM;
			break;

		//MKc
		case TRTYPE_GINGAM:
		case TRTYPE_GINGAW:
			bgm = SEQ_BA_GINGA;
			break;

		//MKc{X
		case TRTYPE_GINGALEADER1:
		case TRTYPE_GINGALEADER2:
		case TRTYPE_GINGALEADER3:
			bgm = SEQ_BA_AKAGI;
			break;

		//g[i[
		default:
			bgm = SEQ_BA_TRAIN;
			break;
		}
	}

	return bgm;
}

//--------------------------------------------------------------
/**
 * @brief	][f[^BGMio[擾
 *
 * @param	zone_id	][ID
 *
 * @retval	"BGMio["
 */
//--------------------------------------------------------------
u16 Snd_ZoneDataBgmNoGet( int zone_id )
{
	u16 bgm_no;

	//}bvǗ\BGMio[Ԃ
	if( GF_RTC_IsNightTime() == FALSE ){			//FALSE=ATRUE=
		bgm_no = ZoneData_GetDayBGMID( zone_id );
	}else{
		bgm_no = ZoneData_GetNightBGMID( zone_id );
	}

	return bgm_no;
}


//==============================================================================================
//
//	}bvJڗp(܂͎gpsI)
//
//	ev_mapchange.c
//	map_jump.c
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	}bvJځF][؂ւ鎞ɃtF[hAEg
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	zone_id		][ID
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_EvMapChangeBgmFadeCheck( FIELDSYS_WORK* fsys, int zone_id )
{
	//tB[hBGMŒɂtO`FbN(Z[u͂Ȃ)
	if( Snd_CtrlBgmFlagCheck() == 1 ){
		return;
	}

	//tB[hBGMio[擾(BASIC_BANK)
	if( Snd_NowBgmNoGet() != Snd_FieldBgmNoGetNonBasicBank(fsys,zone_id) ){
		Snd_BgmFadeOut( 0, BGM_FADE_MAPJUMP_TIME );
	}
	return;
}

//--------------------------------------------------------------
/**
 * @brief	}bvJځF][؂ւ鎞BGMĐ
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	zone_id		][ID
 *
 * @retval	none
 */
//--------------------------------------------------------------
void Snd_EvMapChangeBgmPlay( FIELDSYS_WORK* fsys, int zone_id )
{
	u16 bgm_no;

	//tB[hBGMŒɂtO`FbN(Z[u͂Ȃ)
	if( Snd_CtrlBgmFlagCheck() == 1 ){
		return;
	}

	Snd_SceneSet( SND_SCENE_DUMMY );

	//tB[hBGMio[擾(BASIC_BANK)
	bgm_no = Snd_FieldBgmNoGetNonBasicBank( fsys, zone_id );

	Snd_ZoneBgmSet( bgm_no );		//][ȃZbg

	Snd_DataSetByScene( SND_SCENE_FIELD, bgm_no, 1 );
	return;
}


//==============================================================================================
//
//	tB[hp
//
//	fieldmap.c
//	fld_menu.c(i̕AɎgp)
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	tB[hFTEhf[^Zbg
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	zone_id		][ID
 *
 * @retval	none
 *
 * V[ύXȂ͉ȂI
 */
//--------------------------------------------------------------
void Snd_FieldMapInitBgmPlay( FIELDSYS_WORK* fsys, int zone_id )
{
	u16 bgm_no;

	bgm_no = Snd_FieldBgmNoGet( fsys, zone_id );	//]BGMŕA邱Ƃ肦I

	Snd_ZoneBgmSet( Snd_FieldBgmNoGetNonBasicBank(fsys,zone_id) );	//][ȃZbg

	//TEhf[^Zbg(V[ύXȂ͉Ȃ)
	Snd_DataSetByScene( SND_SCENE_FIELD, bgm_no, 1 );
	return;
}


