//==============================================================================================
/**
 * @file	fld_bgm.h
 * @brief	tB[hTEh
 * @author	Satoshi Nohara
 * @date	2005.10.14
 */
//==============================================================================================
#ifndef __FLD_BGM_H__
#define __FLD_BGM_H__

#include "field_common.h"


//==============================================================================================
//
//	extern錾
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	Q[I[o[ɂ鏈(field_encount.cĂ΂)
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_GameOverSet();

//--------------------------------------------------------------
/**
 * @brief	Q[I[o[ɍĊJ鎞̏(field_encount.cĂ΂)
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_RestartSet( FIELDSYS_WORK* fsys );

//--------------------------------------------------------------
/**
 * @brief	BGMwZbg
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	bgm_no	BGMio[
 *
 * @retval	none
 *
 * }bvBGMw肪Zbg
 * ]BGM̐ȂǂɎgp
 */
//--------------------------------------------------------------
extern void Snd_FieldBgmSetSpecial( FIELDSYS_WORK* fsys, u16 bgm_no );

//--------------------------------------------------------------
/**
 * @brief	BGMwQbg
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @retval	"BGMio["
 *
 * }bvBGMw肪Zbg
 * ]BGM̐ȂǂɎgp
 */
//--------------------------------------------------------------
extern u16 Snd_FieldBgmGetSpecial( FIELDSYS_WORK* fsys );

//--------------------------------------------------------------
/**
 * @brief	BGMwNA
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @retval	none
 *
 * }bvBGMw肪NA
 * ]BGM̐ȂǂɎgp
 */
//--------------------------------------------------------------
extern void Snd_FieldBgmClearSpecial( FIELDSYS_WORK* fsys );

//--------------------------------------------------------------
/**
 * @brief	tB[hBGMio[擾
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	zone_id	][ID
 *
 * @retval	"tB[hBGMio["
 */
//--------------------------------------------------------------
extern u16 Snd_FieldBgmNoGet( FIELDSYS_WORK* fsys, int zone_id );

//--------------------------------------------------------------
/**
 * @brief	tB[hBGMio[擾(BASIC_BANK)
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	zone_id	][ID
 *
 * @retval	"tB[hBGMio["
 *
 * ʏ͎gpȂI
 */
//--------------------------------------------------------------
extern u16 Snd_FieldBgmNoGetNonBasicBank( FIELDSYS_WORK* fsys, int zone_id );

//--------------------------------------------------------------
/**
 * @brief	"][܂p"@tF[hAEg  BGMĐ(tB[hp)
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	seq_no	V[PXio[
 * @param	mode	[h(fld_bgm.hQ)
 *
 * @retval	"0=ȂA1=Jn"
 *
 * tB[hȊÓÅ֐gpĉI
 * Snd_BgmFadeOutNextPlaySet(...);
 *
 * ][܂płBHÃ][܂Ɏgp܂B
 * }bvJڂɂ͎gpł܂B
 */
//--------------------------------------------------------------
extern BOOL Snd_FadeOutNextPlayCall( FIELDSYS_WORK* fsys, u16 seq_no, int mode );

//--------------------------------------------------------------
/**
 * @brief	"}bvJڐp"@tF[hAEg  BGMĐ(tB[hp)
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	seq_no	V[PXio[
 * @param	mode	[h(fld_bgm.hQ)
 *
 * @retval	"0=ȂA1=Jn"
 *
 * }bvJڐpłBA_Wɓ鎞Ɏgp܂B
 * HÃ][܂ɂ͎gpł܂B
 */
//--------------------------------------------------------------
//extern BOOL Snd_MapChangeFadeOutNextPlayCall( FIELDSYS_WORK* fsys, u16 seq_no, int mode );

//--------------------------------------------------------------
/**
 * @brief	"}bvJڐp"@ev_mapchange.cp̊֐
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	zone_id	][ID
 * @param	mode	[h(fld_bgm.hQ)
 *
 * @retval	"0=ȂA1=Jn"
 *
 * }bvJڐpłBA_Wɓ鎞Ɏgp܂B
 * HÃ][܂ɂ͎gpł܂B
 */
//--------------------------------------------------------------
extern BOOL Snd_MapChangeFadeOutNextPlaySub( FIELDSYS_WORK* fsys, int zone_id, int mode );

//--------------------------------------------------------------
/**
 * @brief	g[i[BGM擾(XNvgĂ΂)
 *
 * @param	tr_id	g[i[ID
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern u16 Snd_EyeBgmGet( int tr_id );

//--------------------------------------------------------------
/**
 * @brief	퓬BGM擾
 *
 * @param	fight_type	퓬ʃtO
 * @param	tr_id	g[i[ID
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern u16 Snd_BattleBgmGet( u32 fight_type, int tr_id );

//--------------------------------------------------------------
/**
 * @brief	][f[^BGMio[擾
 *
 * @param	zone_id	][ID
 *
 * @retval	"BGMio["
 */
//--------------------------------------------------------------
extern u16 Snd_ZoneDataBgmNoGet( int zone_id );


//==============================================================================================
//
//	}bvJڗp(܂͎gpsI)
//
//	ev_mapchange.c
//	map_jump.c
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	}bvJځF][؂ւ鎞ɃtF[hAEg
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	zone_id		][ID
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_EvMapChangeBgmFadeCheck( FIELDSYS_WORK* fsys, int zone_id );

//--------------------------------------------------------------
/**
 * @brief	}bvJځF][؂ւ鎞BGMĐ
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	zone_id		][ID
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_EvMapChangeBgmPlay( FIELDSYS_WORK* fsys, int zone_id );


//==============================================================================================
//
//	tB[hp
//
//	fieldmap.c
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	tB[hFTEhf[^Zbg
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	zone_id		][ID
 *
 * @retval	none
 */
//--------------------------------------------------------------
extern void Snd_FieldMapInitBgmPlay( FIELDSYS_WORK* fsys, int zone_id );


#endif


