/**
 *	@file	fld_bmp.h
 *	@brief	tB[hbZ[W&j[\Rg[
 *	@author	GameFreak Inc.
 *	@date	04/12/17
 */

#ifndef _H_FLD_BMP_H_
#define _H_FLD_BMP_H_

///	afpbg` 2005/09/15
//
//	0 ` 5  : tB[h}bvafp
//  6       : V
//  7       : nEChE
//  8       : ŔEChEi}bvAWȂǁj
//  9       : ŔEChEigAtHgj
//  10      : bZ[WEChE
//  11      : j[EChE
//  12      : bZ[WtHg
//  13      : VXetHg
//	14		: gpi[JCYpj
//	15		: fobOpiiłł͖gpj
#define FLD_WEATHER_PAL      (  6 )			//  V
#define FLD_PLACENAME_PAL    (  7 )         //  nEChE
#define FLD_BOARD1FRAME_PAL  (  8 )         //  ŔEChEi}bvAWȂǁj
#define FLD_BOARD2FRAME_PAL  (  9 )         //  ŔEChEigAtHgj
#define FLD_MESFRAME_PAL     ( 10 )         //  bZ[WEChE
#define FLD_MENUFRAME_PAL    ( 11 )         //  j[EChE
#define FLD_MESFONT_PAL      ( 12 )         //  bZ[WtHg
#define FLD_SYSFONT_PAL	     ( 13 )         //  VXetHg
#define FLD_LOCALIZE_PAL     ( 14 )         //	gpi[JCYpj
#define FLD_DEBUG_PAL        ( 15 )         //	fobOpiiłł͖gpj

/*********************************************************************************************
	CʂCGXU		2006/01/12

		EBhEg	F	409 - 511
			bAj[AnAŔ

		BMPEBhEP	F	297 - 408
			biőjAŔAc{[

		BMPEBhEQ	F	55 - 296
			j[iőjA͂/An

*********************************************************************************************/

/*********************************************************************************************
	EBhEg
*********************************************************************************************/
// bEBhEL
#define	TALK_WIN_CGX_SIZE	( 18+12 )
#define	TALK_WIN_CGX_NUM	( 1024 - TALK_WIN_CGX_SIZE )
#define	TALK_WIN_PAL		( 10 )

// j[EBhEL
#define	MENU_WIN_CGX_SIZE	( 9 )
#define	MENU_WIN_CGX_NUM	( TALK_WIN_CGX_NUM - MENU_WIN_CGX_SIZE )
#define	MENU_WIN_PAL		( 11 )

// nEBhEL
#define	PLACE_WIN_CGX_SIZE	( 10 )
#define	PLACE_WIN_CGX_NUM	( MENU_WIN_CGX_NUM - PLACE_WIN_CGX_SIZE )
#define	PLACE_WIN_PAL		( 7 )

// ŔEBhEL
#define	BOARD_WIN_CGX_SIZE	( 18+12 + 24 )
#define	BOARD_WIN_CGX_NUM	( PLACE_WIN_CGX_NUM - BOARD_WIN_CGX_SIZE )
#define	BOARD_WIN_PAL		( FLD_BOARD2FRAME_PAL )

/*********************************************************************************************
	BMPEBhE
*********************************************************************************************/
// bEBhEiCj
#define	FLD_MSG_WIN_PX		( 2 )
#define	FLD_MSG_WIN_PY		( 19 )
#define	FLD_MSG_WIN_SX		( 27 )
#define	FLD_MSG_WIN_SY		( 4 )
#define	FLD_MSG_WIN_PAL		( FLD_MESFONT_PAL )
#define	FLD_MSG_WIN_CGX		( BOARD_WIN_CGX_NUM - ( FLD_MSG_WIN_SX * FLD_MSG_WIN_SY ) )

// ŔEBhEiCjibƓʒuib菬jj
#define	FLD_BOARD_WIN_PX	( 9 )
#define	FLD_BOARD_WIN_PY	( 19 )
#define	FLD_BOARD_WIN_SX	( 20 )
#define	FLD_BOARD_WIN_SY	( 4 )
#define	FLD_BOARD_WIN_PAL	( FLD_BOARD2FRAME_PAL )
#define	FLD_BOARD_WIN_CGX	( FLD_MSG_WIN_CGX )

// c{[ibƓʒuib菬jj
#define	FLD_BALL_WIN_PX		( 1 )
#define	FLD_BALL_WIN_PY		( 1 )
#define	FLD_BALL_WIN_SX		( 12 )
#define	FLD_BALL_WIN_SY		( 4 )
#define	FLD_BALL_WIN_PAL	( FLD_SYSFONT_PAL )
#define	FLD_BALL_WIN_CGX	( FLD_MSG_WIN_CGX )

// j[EBhEiCj
#define	FLD_MENU_WIN_PX		( 20 )
#define	FLD_MENU_WIN_PY		( 1 )
#define	FLD_MENU_WIN_SX		( 11 )
#define	FLD_MENU_WIN_SY		( 22 )
#define	FLD_MENU_WIN_PAL	( FLD_SYSFONT_PAL )
#define	FLD_MENU_WIN_CGX	( FLD_MSG_WIN_CGX - ( FLD_MENU_WIN_SX * FLD_MENU_WIN_SY ) )

// ͂/EBhEiCjij[Ɠʒuij[菬jj
#define	FLD_YESNO_WIN_PX	( 25 )
#define	FLD_YESNO_WIN_PY	( 13 )
#define	FLD_YESNO_WIN_SX	( 6 )
#define	FLD_YESNO_WIN_SY	( 4 )
#define	FLD_YESNO_WIN_PAL	( FLD_SYSFONT_PAL )
#define	FLD_YESNO_WIN_CGX	( FLD_MSG_WIN_CGX - ( FLD_YESNO_WIN_SX * FLD_YESNO_WIN_SY ) )

// nEBhEij[Ɠʒuij[菬jj
#define FLD_PLACE_WIN_PX	( 0 )
#define FLD_PLACE_WIN_PY	( 0 )
#define	FLD_PLACE_WIN_SX	( 32 )
#define	FLD_PLACE_WIN_SY	( 3 )
#define	FLD_PLACE_WIN_CGX	( FLD_MSG_WIN_CGX - ( FLD_PLACE_WIN_SX * FLD_PLACE_WIN_SY ) )



// bZ[WEBhEiTuj
#define	FLD_MSG_WIN_S_PX	( 2  )
#define	FLD_MSG_WIN_S_PY	( 19 )
#define	FLD_MSG_WIN_S_PAL	( FLD_MESFONT_PAL )
//#define	FLD_MSG_WIN_S_CGX	( MENU_WIN_CGX_NUM - ( FLD_MSG_WIN_SX * FLD_MSG_WIN_SY ) )
#define	FLD_MSG_WIN_S_CGX	( 512 - ( FLD_MSG_WIN_SX * FLD_MSG_WIN_SY ) )

// ŔEBhEiTuj
#define	FLD_BOARD_WIN_S_PX	( 9 )
#define	FLD_BOARD_WIN_S_PY	( 19 )
#define	FLD_BOARD_WIN_S_SX	( 21 )
#define	FLD_BOARD_WIN_S_SY	( 4 )
#define	FLD_BOARD_WIN_S_PAL	( FLD_BOARD2FRAME_PAL )
#define	FLD_BOARD_WIN_S_CGX	( FLD_MSG_WIN_S_CGX )

// j[EBhEiTuj
#define	FLD_MENU_WIN_S_PX	( 25 )
#define	FLD_MENU_WIN_S_PY	( 1 )
#define	FLD_MENU_WIN_S_SX	( 6 )
#define	FLD_MENU_WIN_S_SY	( 16 )
#define	FLD_MENU_WIN_S_PAL	( FLD_SYSFONT_PAL )
#define	FLD_MENU_WIN_S_CGX	( MENU_WIN_CGX_NUM - ( FLD_MENU_WIN_SX * FLD_MENU_WIN_SY ) )



///	rbg}bv]֐p`
//------------------------------------------------------------------
#define	FBMP_TRANS_OFF	(0)
#define	FBMP_TRANS_ON	(1)
///	\]֐p`
//------------------------------------------------------------------
#define	FBMPMSG_WAITON_SKIPOFF	(0)
#define	FBMPMSG_WAITON_SKIPON	(1)
#define	FBMPMSG_WAITOFF			(2)

//-------------------------------------------------------------------------
///	\F`(default)	-> gflib/fntsys.hֈړ
//------------------------------------------------------------------

#define WINCLR_COL(col)	(((col)<<4)|(col))

//-------------------------------------------------------------------------
///	\Xs[h`(default)
//------------------------------------------------------------------
#define	FBMP_MSG_SPEED_SLOW		(8)
#define	FBMP_MSG_SPEED_NORMAL	(4)
#define	FBMP_MSG_SPEED_FAST		(1)


#endif	//_H_FLD_BMP_H_
