//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		fld_encount_data.c
 *	@brief		tB[hGJEgf[^
 *	@author		tomoya takahashi
 *	@data		2006.06.08
 *	
 *	ogp[^
 *	GJEgGtFNg@BGMĂ郋[`
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "common.h"

#include "fieldsys.h"

#include "encount_effect.h"
#include "ev_pokemon.h"
#include "poketool/poke_tool.h"
#include "poketool/tr_tool.h"
#include "poketool/monsno.h"

#include "battle/trtype_def.h"

#include "system/snd_tool.h"
#include "field/fld_bgm.h"

#define __FIELD_ENCEFF_DATA_H_GLOBAL
#include "fld_enceff_data.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	GJEg^Cv萔
//
//	ʏGJEg
//		tB[hAg[i[ȊO
//		Ǝ̃GtFNggpGtFNg
//=====================================
enum{
	// GYM
	FLD_ENCEFF_SP_GYM_KUROGANE,			// NKlW
	FLD_ENCEFF_SP_GYM_HAKUTAI,			// nN^CW
	FLD_ENCEFF_SP_GYM_NOMOSE,			// mZW
	FLD_ENCEFF_SP_GYM_TOBARI,			// goW
	FLD_ENCEFF_SP_GYM_YOSUGA,			// XKgW
	FLD_ENCEFF_SP_GYM_KISSAKI,			// LbTLW
	FLD_ENCEFF_SP_GYM_MIO,				// ~IW
	FLD_ENCEFF_SP_GYM_NAGISA,			// iMTW
	// lV
	FLD_ENCEFF_SP_BIGFOUR_00,
	FLD_ENCEFF_SP_BIGFOUR_01,
	FLD_ENCEFF_SP_BIGFOUR_02,
	FLD_ENCEFF_SP_BIGFOUR_03,
	// `sI
	FLD_ENCEFF_SP_CHANPION,
	// Co
	FLD_ENCEFF_SP_RIVAL,
	// |P
	FLD_ENCEFF_SP_LEGEND_POKE00,	// VFC~
	FLD_ENCEFF_SP_PACKAGE_POKE00,	// CAAGA
	FLD_ENCEFF_SP_REIHAI_POKE00,	// C@nC
	FLD_ENCEFF_SP_AI_POKE00,		// AC
	FLD_ENCEFF_SP_ARUSEUSU,			// AZEX
	FLD_ENCEFF_SP_LEGEND_POKE01,	// ڼ޷޶޽Aq[hAL}CA_[炢
	FLD_ENCEFF_SP_LEGEND_POKE02,	// NZA
	
	// ͒c
	FLD_ENCEFF_SP_GINGA_NORMAL,		// ʏ탁o[
	FLD_ENCEFF_SP_GINGA_SPECIAL,	// NX
	FLD_ENCEFF_SP_GINGA_BOSU,	// {X
	// ̑og
	FLD_ENCEFF_SP_BATTLE_TOWER,		// og^[
	FLD_ENCEFF_SP_BATTLE_COMMU,		// ʐMog
	FLD_ENCEFF_SP_BATTLE_DOUBLE,		// _uogg[i[
	FLD_ENCEFF_SP_BATTLE_DOUBLE_YASEI,	// _uog₹
	FLD_ENCEFF_SP_BATTLE_TOWER_TAIKUUN,	// ^[^CN[

	// m[}	
	FLD_ENCEFF_SP_NORMAL_TRAINER,	// g[i[
	FLD_ENCEFF_SP_NORMAL_FIELD,		// 쐶

	FLD_ENCEFF_SP_MAX,	// GJEg
};



//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	GJEgf[^[N
//=====================================
typedef struct {
	u16 effect_no;
	u16 bgm_no;
} FLD_ENCEFF_SP_DATA;


//-----------------------------------------------------------------------------
/**
 *		GJEgGtFNge[u
 *			yGJEg^Cv萔ẑȂт
 *			킹Kv܂B
*/
//-----------------------------------------------------------------------------
// GJEgGtFNgogp[^SEARCH
#define ENCOUNT_EFFECT_SEARCH	( 0xffff )


static const FLD_ENCEFF_SP_DATA FLD_EncEffSpData[ FLD_ENCEFF_SP_MAX ] = {
	// GYM
	{ ENCOUNT_SPTR_KUROGANE_GYM,	SEQ_BA_GYM },	// NKlW
	{ ENCOUNT_SPTR_HAKUTAI_GYM,		SEQ_BA_GYM },	// nN^CW
	{ ENCOUNT_SPTR_NOMOSE_GYM,		SEQ_BA_GYM },	// mZW
	{ ENCOUNT_SPTR_TOBARI_GYM,		SEQ_BA_GYM },	// goW
	{ ENCOUNT_SPTR_YOSUGA_GYM,		SEQ_BA_GYM },	// XKgW
	{ ENCOUNT_SPTR_KISSAKI_GYM,		SEQ_BA_GYM },	// LbTLW
	{ ENCOUNT_SPTR_MIO_GYM,			SEQ_BA_GYM },	// ~IW
	{ ENCOUNT_SPTR_NAGISA_GYM,		SEQ_BA_GYM },	// iMTW
	// lV
	{ ENCOUNT_SPTR_SITEN_00,	SEQ_BA_TENNO },
	{ ENCOUNT_SPTR_SITEN_01,	SEQ_BA_TENNO },
	{ ENCOUNT_SPTR_SITEN_02,	SEQ_BA_TENNO },
	{ ENCOUNT_SPTR_SITEN_03,	SEQ_BA_TENNO },
	// `sI
	{ ENCOUNT_SPTR_CHANPION,	SEQ_BA_CHANP },
	// Co
	{ ENCOUNT_EFFECT_SEARCH,	SEQ_BA_RIVAL },
	// |P
	{ ENCOUNT_LEGEND_NORMAL,	SEQ_BA_POKE },	// VFC~
	{ ENCOUNT_LEGEND_PACKAGE,	SEQ_BA_DPOKE2 },	// CAAGA
	{ ENCOUNT_LEGEND_PACKAGE,	SEQ_BA_DPOKE1 },	// C@nC@
	{ ENCOUNT_EFFECT_SEARCH,	SEQ_BA_DPOKE1 },	// AC
	{ ENCOUNT_LEGEND_PACKAGE,	SEQ_BA_SECRET1 },	// AZEX
	{ ENCOUNT_LEGEND_NORMAL,	SEQ_BA_SECRET2 },	// WMKXAq[hAL}C
	{ ENCOUNT_EFFECT_SEARCH,	SEQ_BA_POKE },	// NZA

	// ͒c
	{ ENCOUNT_GINGA_NORMAL,		SEQ_BA_GINGA },	// ʏ탁o[
	{ ENCOUNT_GINGA_SPECIAL,	SEQ_BA_GINGA3},	// NX
	{ ENCOUNT_GINGA_SPECIAL,	SEQ_BA_AKAGI },	// {X
	// ̑og
	{ ENCOUNT_SPECIAL_TOWER,	SEQ_BA_TRAIN },	// og^[
	{ ENCOUNT_SPECIAL_TOWER,	SEQ_BA_TRAIN },	// ʐMog
	{ ENCOUNT_SPECIAL_DOUBLE,	SEQ_BA_TRAIN },	// _uog
	{ ENCOUNT_SPECIAL_DOUBLE,	SEQ_BA_POKE },	// _uog₹
	{ ENCOUNT_SPECIAL_TOWER,	SEQ_BA_CHANP },	// og^[^CN[
	// m[}
	{ ENCOUNT_EFFECT_SEARCH,	SEQ_BA_TRAIN },	// g[i[
	{ ENCOUNT_EFFECT_SEARCH,	SEQ_BA_POKE },	// 쐶

//	{ GtFNg,BGM },	
};


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static u32 FLD_EncEffSpDataTypeGetTrainer( u32 tr_type );
static u32 FLD_EncEffSpDataTypeGetPokemon( POKEPARTY* p_poke_party );

static u32 FLD_EncEffSpDataTypeGet( const BATTLE_PARAM* p_bp );
static u32 FLD_EncEffSpDataEffectNoGet( u32 type, const BATTLE_PARAM* p_bp );
static u32 FLD_EncEffSpDataBgmNoGet( u32 type, const BATTLE_PARAM* p_bp );




//----------------------------------------------------------------------------
/**
 *	@brief	GJEg^Cv@擾
 *	
 *	@param	BATTLE_PARAM* p_bp 
 *	@retval	GJEge[u
 *	@retval	FLD_ENCEFF_SP_MAX	e[uɂȂ
 *
 *	* D揇
 *		g[i[
 *		|Ṕ@og^[@ʐM@_uł
 *		oĂȂƍlč쐬
 */
//-----------------------------------------------------------------------------
static u32 FLD_EncEffSpDataTypeGet( const BATTLE_PARAM* p_bp )
{
	u32 fight_type = p_bp->fight_type;
	u32 trainer_sp;
	u32 mons_sp;
	

	// g[i[`FbN
	if( (fight_type & FIGHT_TYPE_TRAINER) ){

		// g[i[`FbN
		trainer_sp = FLD_EncEffSpDataTypeGetTrainer( p_bp->trainer_data[ CLIENT_NO_ENEMY ].tr_type );

		// og^[́Ag[i[IDȂ̂
		// ɔf
		if( fight_type & FIGHT_TYPE_TOWER ){

			// ^[^CN[ŗD
			if( trainer_sp == FLD_ENCEFF_SP_BATTLE_TOWER_TAIKUUN ){
				return trainer_sp;
			}

			// _uog`FbN
			if( fight_type & FIGHT_TYPE_2vs2 ){
				return FLD_ENCEFF_SP_BATTLE_DOUBLE;
			}
			return FLD_ENCEFF_SP_BATTLE_TOWER;
		}

		// ͒cD悷
		if( (trainer_sp == FLD_ENCEFF_SP_GINGA_NORMAL) || 
			(trainer_sp == FLD_ENCEFF_SP_GINGA_SPECIAL) ||
			(trainer_sp == FLD_ENCEFF_SP_GINGA_BOSU) ){
			return trainer_sp;
		}

		// _uog`FbN
		if( fight_type & FIGHT_TYPE_2vs2 ){
			return FLD_ENCEFF_SP_BATTLE_DOUBLE;
		}

		// ʐMog`FbN
		if( fight_type & FIGHT_TYPE_SIO ){
			return FLD_ENCEFF_SP_BATTLE_COMMU;
		}

		return trainer_sp;
	}

	// |P`FbN
	mons_sp = FLD_EncEffSpDataTypeGetPokemon( p_bp->poke_party[ CLIENT_NO_ENEMY ] );

	// tB[hȉ̓|PȂԂ
	if( mons_sp < FLD_ENCEFF_SP_NORMAL_FIELD ){
		return mons_sp;
	}

	// _uog`FbN
	if( fight_type & FIGHT_TYPE_2vs2 ){
		return FLD_ENCEFF_SP_BATTLE_DOUBLE_YASEI;
	}

	// 쐶
	return mons_sp;
}


//----------------------------------------------------------------------------
/**
 *	@brief	GJEgGtFNgio[̎擾
 *	@param	type	yGJEg^Cv萔z
 *	@param	p_bp	ogp[^
 *	@return	GJEgGtFNgio[
 */
//-----------------------------------------------------------------------------
static u32 FLD_EncEffSpDataEffectNoGet( u32 type, const BATTLE_PARAM* p_bp )
{
	GF_ASSERT( type < FLD_ENCEFF_SP_MAX );
	
	if( FLD_EncEffSpData[ type ].effect_no == ENCOUNT_EFFECT_SEARCH ){
		// xȂǂČ߂
		return ENCEFF_GetEffectNo( p_bp );
	}else{

		return FLD_EncEffSpData[ type ].effect_no;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGMio[̎擾
 *	@param	type	yGJEg^Cv萔z
 *	@param	p_bp	ogp[^
 *	@return	BGMio[
 */
//-----------------------------------------------------------------------------
static u32 FLD_EncEffSpDataBgmNoGet( u32 type, const BATTLE_PARAM* p_bp )
{
	GF_ASSERT( type < FLD_ENCEFF_SP_MAX );
	return FLD_EncEffSpData[ type ].bgm_no;
}

//----------------------------------------------------------------------------
/**
 *	[type ̎擾͓ōs]
 *	@brief	GJEgGtFNgio[̎擾
 *	@param	p_bp	ogp[^
 *	@return	GJEgGtFNgio[
 */
//-----------------------------------------------------------------------------
u32 FLD_EncEffSpDataEffectNoPackGet( const BATTLE_PARAM* p_bp )
{
	u32 type;
	type = FLD_EncEffSpDataTypeGet( p_bp );
	return FLD_EncEffSpDataEffectNoGet( type, p_bp );
}

//----------------------------------------------------------------------------
/**
 *	[type ̎擾͓ōs]
 *	@brief	BGMio[̎擾
 *	@param	p_bp	ogp[^
 *	@return	BGMio[
 */
//-----------------------------------------------------------------------------
u32 FLD_EncEffSpDataBgmNoPackGet( const BATTLE_PARAM* p_bp )
{
	u32 type;
	type = FLD_EncEffSpDataTypeGet( p_bp );
	return FLD_EncEffSpDataBgmNoGet( type, p_bp );
}



//-----------------------------------------------------------------------------
/**
 *			vCx[g֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	GJEgGtFNgf[^擾
 *
 *	@param	p_data		f[^i[
 *	@param	type		yGJEg^Cv萔z
 */
//-----------------------------------------------------------------------------
static void FLD_EncEffSpDataGet( FLD_ENCEFF_SP_DATA* p_data, u32 type )
{
	// ^Cvs
	GF_ASSERT( type < FLD_ENCEFF_SP_MAX );
	*p_data = FLD_EncEffSpData[ type ];
}


//----------------------------------------------------------------------------
/**
 *	@brief	g[i[GJEg^CvIo
 *
 *	@param	tr_type	g[i[TYPE
 *
 *	@retval	GJEge[u
 *	@retval	FLD_ENCEFF_SP_MAX	e[uɂȂ
 */
//-----------------------------------------------------------------------------
static u32 FLD_EncEffSpDataTypeGetTrainer( u32 tr_type )
{
	u32 retval = FLD_ENCEFF_SP_NORMAL_TRAINER;
	
	
	// tr_typeƘAԂŕłȂ̂
	// ScasełƂKv
	switch( tr_type ){
	// GYM
	case TRTYPE_LEADER1:		// NKlW
		retval = FLD_ENCEFF_SP_GYM_KUROGANE;
		break;
	case TRTYPE_LEADER2:		// nN^CW
		retval = FLD_ENCEFF_SP_GYM_HAKUTAI;
		break;
	case TRTYPE_LEADER3:		// mZW
		retval = FLD_ENCEFF_SP_GYM_NOMOSE;
		break;
	case TRTYPE_LEADER4:		// goW
		retval = FLD_ENCEFF_SP_GYM_TOBARI;
		break;
	case TRTYPE_LEADER5:		// XKgW
		retval = FLD_ENCEFF_SP_GYM_YOSUGA;
		break;
	case TRTYPE_LEADER6:		// LbTLW
		retval = FLD_ENCEFF_SP_GYM_KISSAKI;
		break;
	case TRTYPE_LEADER7:		// ~IW
		retval = FLD_ENCEFF_SP_GYM_MIO;
		break;
	case TRTYPE_LEADER8:		// iMTW
		retval = FLD_ENCEFF_SP_GYM_NAGISA;
		break;
		
	// lV
	case TRTYPE_BIGFOUR1:
		retval = FLD_ENCEFF_SP_BIGFOUR_00;
		break;
	case TRTYPE_BIGFOUR2:
		retval = FLD_ENCEFF_SP_BIGFOUR_01;
		break;
	case TRTYPE_BIGFOUR3:
		retval = FLD_ENCEFF_SP_BIGFOUR_02;
		break;
	case TRTYPE_BIGFOUR4:
		retval = FLD_ENCEFF_SP_BIGFOUR_03;
		break;
		
	// `sI
	case TRTYPE_CHAMPION:
		retval = FLD_ENCEFF_SP_CHANPION;
		break;

	// Co
	case TRTYPE_RIVAL:
		retval = FLD_ENCEFF_SP_RIVAL;
		break;
		
	// ͒c
	case TRTYPE_GINGALBOSS:
		retval = FLD_ENCEFF_SP_GINGA_BOSU;
		break;
		
	case TRTYPE_GINGALEADER1:
	case TRTYPE_GINGALEADER2:
	case TRTYPE_GINGALEADER3:
		retval = FLD_ENCEFF_SP_GINGA_SPECIAL;
		break;
	case TRTYPE_GINGAM:
	case TRTYPE_GINGAW:
		retval = FLD_ENCEFF_SP_GINGA_NORMAL;
		break;

	// og^[
	case TRTYPE_KUROTUGU:
		retval = FLD_ENCEFF_SP_BATTLE_TOWER_TAIKUUN;
		break;

	default:
		break;
	}

	return retval;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P@`FbN
 *
 *	@param	p_poke_party	|Pp[eB
 *
 *	@retval	GJEge[u
 *	@retval	FLD_ENCEFF_SP_MAX	e[uɂȂ
 */
//-----------------------------------------------------------------------------
static u32 FLD_EncEffSpDataTypeGetPokemon( POKEPARTY* p_poke_party )
{
	POKEMON_PARAM* p_enemy_poke;
	u32 monsno;
	u32 retval = FLD_ENCEFF_SP_NORMAL_FIELD;

	// |Pp[^擾
	p_enemy_poke = EvPoke_GetLivingPokemonTop( p_poke_party );
	monsno = PokeParaGet( p_enemy_poke, ID_PARA_monsno, NULL );

	switch( monsno ){
	case MONSNO_EURISU:	// VFC~A
		retval = FLD_ENCEFF_SP_LEGEND_POKE00;
		break;

	case MONSNO_MUUBASU:	// NZA
		retval = FLD_ENCEFF_SP_LEGEND_POKE02;
		break;

		
	case MONSNO_REZIKINGU:	// WMKX@q[h@L}C@_[NC
	case MONSNO_KIMAIRAN:
	case MONSNO_HIIDORAN:
	case MONSNO_DAAKU:
	case MONSNO_PURAZUMA:
		retval = FLD_ENCEFF_SP_LEGEND_POKE01;
		break;
		
	case MONSNO_AI:	// AC
		retval = FLD_ENCEFF_SP_AI_POKE00;
		break;

	case MONSNO_REI:	// C@nC
	case MONSNO_HAI:
		retval = FLD_ENCEFF_SP_REIHAI_POKE00;
		break;
		
	case MONSNO_IA:	// CAAGAAAEX
	case MONSNO_EA:
		retval = FLD_ENCEFF_SP_PACKAGE_POKE00;
		break;

	case MONSNO_AUSU:	// AZEX
		retval = FLD_ENCEFF_SP_ARUSEUSU;
		break;

	default:
		break;
	}
	return retval;
}
