//============================================================================================
/**
 * @file	fld_flg_init.c
 * @brief	tB[hړł̃tOItElNAƂiCtƂ܂j
 * @date	2006.05.23
 * @author	Nozomu Saito
 *
 */
//============================================================================================
#include "common.h"
#include "savedata/savedata.h"
#include "savedata/encount.h"
#include "savedata/vidro_type.h"
#include "sysflag.h"
#include "fieldsys.h"
#include "mapdata_warp.h"
#include "move_pokemon.h"
#include "zonedata.h"
#include "situation_local.h"
#include "sysflag.h"
#include "syswork.h"

#include "fld_flg_init.h"


static BOOL FldFlgInit_FnoteTownDataSet( FIELDSYS_WORK * fsys );
static BOOL FldFlgInit_FnoteMapChgDataSet( FIELDSYS_WORK * fsys );

//----------------------------------------------------------------------------
/**
 * @brief	][h̃Zbg
 * @param	fsys		tB[hVXe|C^
 * @param	flag		TRUÊƂA][hɃZbg
 *
 * }bv瑼̃}bv̏ꍇ̂ƂɁA
 * etO̍XVtbNKvB̏ꍇ́A
 * CxgJnɂ̊֐gĖ][hɈڍsA
 * }bvJڂI][hIB
 */
//----------------------------------------------------------------------------
void FldFlg_SetScopeMode(FIELDSYS_WORK * fsys, BOOL flag)
{
	fsys->scope_mode_flag = flag;
}

//----------------------------------------------------------------------------
/**
 * @brief	tOFă][܂ƂiKĂ΂j
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @return	none
 *
 */
//-----------------------------------------------------------------------------
void FldFlgInit_Walk(FIELDSYS_WORK * fsys)
{
	//--`m[gpXV
	FldFlgInit_FnoteTownDataSet( fsys );

	//肫tÕNA
	SysFlag_KairikiReset( SaveData_GetEventWork(fsys->savedata) );
	//tÕZbg
	ARRIVEDATA_SetArriveFlag(fsys, fsys->location->zone_id);
	//r[hNA
	EncDataSave_SetVidro( EncDataSave_GetSaveDataPtr(fsys->savedata), VIDRO_NONE );
	//GJEgNA
	fsys->encount.walk_count = 0;
	//Tt@ɂȂƂ̏
	if ( !SysFlag_SafariCheck(SaveData_GetEventWork(fsys->savedata)) ){
		//ړ|P(Tt@][؂ւ̂Ƃ͗ς܂Ȃ)
		ENC_SV_PTR data;
		data = EncDataSave_GetSaveDataPtr(fsys->savedata);
		MP_UpdatePlayerZoneHist(data, fsys->location->zone_id);		//][XV
		//Ĉړꍇ͈ړ|P̈ړ
		MP_MovePokemonNeighboring(data);//ړ|Pאڈړ
	}
}

//----------------------------------------------------------------------------
/**
 * @brief	tOFCv̂͂}bvWv̂Ƃ(KĂ΂)
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @return	none
 *
 */
//-----------------------------------------------------------------------------
void FldFlgInit_MapJump(FIELDSYS_WORK * fsys)
{
	if (fsys->scope_mode_flag == TRUE) {
		//][h̏ꍇ͍XVsȂ
		return;
	}

	//--`m[gpXV
	if( FldFlgInit_FnoteTownDataSet( fsys ) == FALSE ){
		FldFlgInit_FnoteMapChgDataSet( fsys );
	}

	//TCNO[h[h̃NA
	SysFlag_CyclingRoadReset( SaveData_GetEventWork(fsys->savedata) );
	//肫tÕNA
	SysFlag_KairikiReset( SaveData_GetEventWork(fsys->savedata) );
	//tÕZbg
	ARRIVEDATA_SetArriveFlag(fsys, fsys->location->zone_id);
	//r[hNA
	EncDataSave_SetVidro( EncDataSave_GetSaveDataPtr(fsys->savedata), VIDRO_NONE );
	//GJEgNA
	fsys->encount.walk_count = 0;
	//ړ|P
	{
		ENC_SV_PTR data;
		data = EncDataSave_GetSaveDataPtr(fsys->savedata);
		MP_UpdatePlayerZoneHist(data, fsys->location->zone_id);		//][XV
	}
	//_WłȂꍇAtbVԃtOƖԃtONA
	if (!ZoneData_IsDungeon(fsys->location->zone_id)) {
		EVENTWORK * ev = SaveData_GetEventWork(fsys->savedata);
		SysFlag_FlashReset(ev);
		SysFlag_KiribaraiReset(ev);
	}
	//@Ԃ̐ݒ
	{
		PLAYER_SAVE_DATA * jikisave = Situation_GetPlayerSaveData(SaveData_GetSituation(fsys->savedata));
		if (jikisave->form == HERO_FORM_CYCLE
				&& ZoneData_GetEnableBicycleFlag(fsys->location->zone_id) == FALSE) {
			jikisave->form = HERO_FORM_NORMAL;
		} else if (jikisave->form == HERO_FORM_SWIM) {
			jikisave->form = HERO_FORM_NORMAL;
		}
	}

	//--^E}bv
	if (ZoneData_IsSinouField(fsys->location->zone_id)) {
		//tB[hȊOł͑Ղ̍XV͂ȂI
		TOWN_MAP_FOOTMARK * footmark;
		footmark = Situation_GetTMFootMark(SaveData_GetSituation(fsys->savedata));
		TMFootMark_SetNoDir(footmark, fsys->location->grid_x, fsys->location->grid_z);
	}
}

//----------------------------------------------------------------------------
/**
 * @brief	tOFԂgƂŗLōs
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @return	none
 *
 */
//-----------------------------------------------------------------------------
void FldFlgInit_FlySky(FIELDSYS_WORK * fsys)
{
	//Tt@tONA
	SysFlag_SafariReset( SaveData_GetEventWork(fsys->savedata) );
	//ړ|PSWv
	MP_JumpMovePokemonAll(EncDataSave_GetSaveDataPtr(fsys->savedata));
}

//----------------------------------------------------------------------------
/**
 * @brief	tOFe|[ggƂŗLōs
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @return	none
 *
 */
//-----------------------------------------------------------------------------
void FldFlgInit_Teleport(FIELDSYS_WORK * fsys)
{
	//Tt@tONA
	SysFlag_SafariReset( SaveData_GetEventWork(fsys->savedata) );
	//ړ|PSWv
	MP_JumpMovePokemonAll(EncDataSave_GetSaveDataPtr(fsys->savedata));
}

//----------------------------------------------------------------------------
/**
 * @brief	tOFȂʂ̂ЂEȂقgƂŗLōs
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @return	none
 *
 */
//-----------------------------------------------------------------------------
void FldFlgInit_Escape(FIELDSYS_WORK * fsys)
{
	//Tt@tONA
	SysFlag_SafariReset( SaveData_GetEventWork(fsys->savedata) );
}

//----------------------------------------------------------------------------
/**
 * @brief	tOFQ[I[o[
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @return	none
 *
 */
//-----------------------------------------------------------------------------
void FldFlgInit_GameOver(FIELDSYS_WORK * fsys)
{
	EVENTWORK* ev = SaveData_GetEventWork( fsys->savedata );

	//AtOAg[i[IDi[[ÑNA
	SysFlag_PairReset( ev );
	SysWork_PairTrainerIDSet( ev, 0 );
}

//----------------------------------------------------------------------------
/**
 * @brief	tOFReBj[
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @return	none
 *
 */
//-----------------------------------------------------------------------------
void FldFlgInit_Continue(FIELDSYS_WORK * fsys)
{
	//ړ|PSWv
	MP_JumpMovePokemonAll(EncDataSave_GetSaveDataPtr(fsys->savedata));
}

//----------------------------------------------------------------------------
/**
 * @brief	tOFnւ
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @return	none
 *
 */
//-----------------------------------------------------------------------------
void FldFlgInit_UnderGround(FIELDSYS_WORK * fsys)
{
	;
}


//----------------------------------------------------------------------------
/**
 * @brief	`m[g쐬Fɓ
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @retval	"TURE = 쐬ꂽ"
 * @retval	"FALSE = 쐬Ȃ"
 *
 */
//-----------------------------------------------------------------------------
static BOOL FldFlgInit_FnoteTownDataSet( FIELDSYS_WORK * fsys )
{
	int warp_id = WARPDATA_SearchByFieldID( fsys->location->zone_id );

	if( warp_id != 0 && ARRIVEDATA_GetArriveFlag( fsys, warp_id ) == FALSE ){
		FNOTE_DataMakeSaveCity( fsys->fnote, fsys->location->zone_id, HEAPID_EVENT );
		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 * @brief	`m[g쐬F}bv؂ւ
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @retval	"TURE = 쐬ꂽ"
 * @retval	"FALSE = 쐬Ȃ"
 *
 */
//-----------------------------------------------------------------------------
static BOOL FldFlgInit_FnoteMapChgDataSet( FIELDSYS_WORK * fsys )
{
	LOCATION_WORK * before = Situation_GetBeforeLocation( SaveData_GetSituation(fsys->savedata) );

	if( before->zone_id != fsys->location->zone_id ){
		FNOTE_DataMakeSaveMapChg(
			SaveData_GetMyStatus( fsys->savedata ),
			fsys->fnote, fsys->location->zone_id, before->zone_id, HEAPID_EVENT );
		return TRUE;
	}
	return FALSE;
}
