//============================================================================================
/**
 * @file	fld_menu.h
 * @brief	tB[hj[pwb_
 * @author	Hiroyuki Nakamura
 */
//============================================================================================
#ifndef FLD_MENU_H
#define FLD_MENU_H

#include "field/itemuse.h"
#include "field/field_skill.h"
#include "field_skill_local.h"

#undef GLOBAL
#ifdef FLD_MENU_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


//============================================================================================
//	萔`
//============================================================================================
#define	FIELD_MENU_MAX		( 7 )					// ڍő吔
#define	FLDMENU_CLACT_MAX	( FIELD_MENU_MAX + 1 )	// ZAN^[ő吔iځ{J[\j

#define FLD_MENU_VANISH_ZUKAN	( 0x00000001 )		// }ӂB
#define FLD_MENU_VANISH_PLIST	( 0x00000002 )		// |PXgB
#define FLD_MENU_VANISH_BAG		( 0x00000004 )		// obOB
#define FLD_MENU_VANISH_TRCARD	( 0x00000008 )		// g[i[J[hB
#define FLD_MENU_VANISH_REPORT	( 0x00000010 )		// |[gB
#define FLD_MENU_VANISH_CONFIG	( 0x00000020 )		// ݒB
#define FLD_MENU_VANISH_CLOSE	( 0x00000040 )		// uvB
#define FLD_MENU_VANISH_CHAT	( 0x00000080 )		// `bgB
#define FLD_MENU_VANISH_RETIRE	( 0x00000100 )		// ^CAB


// tB[hj[[N
typedef struct {
	GF_BGL_BMPWIN	win;		// BMPEBhEij[j
	GF_BGL_BMPWIN	ball_win;	// BMPEBhEi{[j

	BMPMENU_WORK * mw;
	BMP_MENULIST_DATA * ld;	// BMPXgf[^
	u16	pos;				// j[ʒu
	u16	seq;				// V[PX
	u32	ret;				// ߂l

	u8	list[ FIELD_MENU_MAX ];		// j[Xg

	FIELD_CLACT	fcat;		// ZAN^[ݒf[^
	CATS_ACT_PTR	cap[FLDMENU_CLACT_MAX];
	u32	clact_max;			// ZAN^[o^

	u32	ev_flg;				// j[tO
	u32	union_flg;			// jI[tO

	GMEVENT_FUNC	app_func;

	ITEMCHECK_WORK	item_check;		// ACegp`FbN[N
	SKILLCHECK_WORK	skill_check;	// Zgp`FbN[N

	void * app_wk;			// ėp[N|C^
	void * tmp_wk;			// ėp[N|C^QieʂsꍇɎgpj
}FLD_MENU;

// tB[hj[V[PX
enum {
	FLD_MENU_SEQ_INIT = 0,		// 
	FLD_MENU_SEQ_SELECT,		// j[I

	FLD_MENU_SEQ_APP_CALL,		// AvĂяo
	FLD_MENU_SEQ_APP_WAIT,		// AvI҂

	FLD_MENU_SEQ_REPORT_CALL,
	FLD_MENU_SEQ_REPORT_WAIT,

	FLD_MENU_SEQ_SHINKA_INIT,	// iʌĂяo
	FLD_MENU_SEQ_SHINKA_MAIN,	// iʑ҂

	FLD_MENU_SEQ_BLACK_IN_END,
	FLD_MENU_SEQ_BLACK_IN_END_WAIT,

	FLD_MENU_SEQ_BLACK_IN_EVCHG,
	FLD_MENU_SEQ_BLACK_IN_EVCHG_WAIT,

	FLD_MENU_SEQ_AGAIN,
	FLD_MENU_SEQ_END,
	FLD_MENU_SEQ_WAIT_BLACK_IN,
	FLD_MENU_SEQ_END_NOMENU,
};


// [ʂ̃[h
#define	FM_MAIL_MODE_VIEW		( 3 )		// [
#define	FM_MAIL_MODE_READ		( 2 )		// [ǂ
#define	FM_MAIL_MODE_MAKE_LIST	( 0 )		// [i|PXgj
#define	FM_MAIL_MODE_MAKE_BAG	( 1 )		// [iobOj


//============================================================================================
//	vg^Cv錾
//============================================================================================

// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
// Ȃ̂΂Ńj[JȂ悤

//--------------------------------------------------------------------------------------------
/**
 * tB[hj[N`FbN
 *
 * @param	repw	tB[h[N
 *
 * @retval	"TRUE = N"
 * @retval	"FALSE = Ns"
 *
 * @li	uȂ̂΂vŃj[JȂ悤ɂ`FbN
 *
 *	2006/10/24 by nakahiro
 */
//--------------------------------------------------------------------------------------------
GLOBAL BOOL FieldMenuCallCheck( FIELDSYS_WORK * repw );

// ----------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------
/**
 * tB[hj[Niʏj
 *
 * @param	repw	tB[h[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void FieldMenuInit( struct _FIELDSYS_WORK * repw );

//--------------------------------------------------------------------------------------------
/**
 * tB[hj[NijI[pj
 *
 * @param	repw	tB[h[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void FieldMenuInitUnion( struct _FIELDSYS_WORK * repw );

//--------------------------------------------------------------------------------------------
/**
 * tB[hj[Niΐ핔pj
 *
 * @param	repw	tB[h[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void FieldMenuInitVS( FIELDSYS_WORK * repw );

//--------------------------------------------------------------------------------------------
/**
 * tB[hj[N荞ݏiʏj
 *
 * @param	repw	tB[h[N
 *
 * @return	none
 *
 *	ŔȂǂ̏𒆒fČĂяo
 */
//--------------------------------------------------------------------------------------------
GLOBAL void FieldMenuEvChg( FIELDSYS_WORK * repw );

//--------------------------------------------------------------------------------------------
/**
 * tB[hj[N荞ݏijI[pj
 *
 * @param	repw	tB[h[N
 *
 * @return	none
 *
 *	ŔȂǂ̏𒆒fČĂяo
 */
//--------------------------------------------------------------------------------------------
GLOBAL void FieldMenuEvChgUnion( FIELDSYS_WORK * repw );

//--------------------------------------------------------------------------------------------
/**
 * AvI҂Zbg
 *
 * @param	wk		[N
 * @param	func	I҂
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void FldMenu_AppWaitFuncSet( FLD_MENU * wk, void * func );

//--------------------------------------------------------------------------------------------
/**
 * |PXgI
 *
 * @param	event	tB[hCxgpp[^
 *
 * @return	0
 */
//--------------------------------------------------------------------------------------------
GLOBAL BOOL FldMenu_PokeListEnd( GMEVENT_CONTROL * event );

//--------------------------------------------------------------------------------------------
/**
 * [[N쐬
 *
 * @param	item		ACeԍ
 * @param	mode		[h
 * @param	poke_pos	莝|P̉CڂɎ邩
 *
 * @return	擾[[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * FieldMenu_MailWorkMake( u16 item, u8 mode, u8 poke_pos );

//--------------------------------------------------------------------------------------------
/**
 * [ʏI
 *
 * @param	event	tB[hCxgpp[^
 *
 * @return	0
 */
//--------------------------------------------------------------------------------------------
GLOBAL BOOL FldMenu_MailEnd( GMEVENT_CONTROL * event );

//--------------------------------------------------------------------------------------------
/**
 * ^E}bvIiʏj
 *
 * @param	event	tB[hCxgpp[^
 *
 * @return	0
 */
//--------------------------------------------------------------------------------------------
GLOBAL BOOL FldMenu_TownMapEnd( GMEVENT_CONTROL * event );

//--------------------------------------------------------------------------------------------
/**
 * `m[gI
 *
 * @param	event	tB[hCxgpp[^
 *
 * @return	0
 */
//--------------------------------------------------------------------------------------------
GLOBAL BOOL FldMenu_FantasyNoteEnd( GMEVENT_CONTROL * event );

//--------------------------------------------------------------------------------------------
/**
 * |gP[XI
 *
 * @param	event	tB[hCxgpp[^
 *
 * @return	0
 */
//--------------------------------------------------------------------------------------------
GLOBAL BOOL FldMenu_PorutoCaseEnd( GMEVENT_CONTROL * event );

//--------------------------------------------------------------------------------------------
/**
 * FB蒠I
 *
 * @param	event	tB[hCxgpp[^
 *
 * @return	0
 */
//--------------------------------------------------------------------------------------------
GLOBAL BOOL FldMenu_FriendBookEnd( GMEVENT_CONTROL * event );

//--------------------------------------------------------------------------------------------
/**
 * ^E}bvIiԁj
 *
 * @param	event	tB[hCxgpp[^
 *
 * @return	0
 */
//--------------------------------------------------------------------------------------------
GLOBAL BOOL FldMenu_SorawotobuEnd( GMEVENT_CONTROL * event );


//==============================================================================
//	f[^
//==============================================================================
GLOBAL const u8 PST_PageTbl_Normal[];


#undef GLOBAL
#endif	/* FLD_MENU_H */
