//============================================================================================
/**
 * @file	fld_move_poke.c
 * @bfief	tB[hړ|P֘A
 * @author	Nozomu Saito
 * @date	06.05.13
 */
//============================================================================================
#include "savedata/encount.h"
#include "common.h"
#include "fieldsys.h"
#include "move_pokemon_def.h"
#include "move_pokemon.h"

#include "debug_saito.h"

#include "fld_move_poke.h"

static void MovePokeLocation(ENC_SV_PTR inEncData);
static void JumpMovePokeAffterBattle(ENC_SV_PTR inEncData, const int inZoneID);
static MPD_PTR GetMovePokeDataByMondNo(ENC_SV_PTR inEncData, const int inMonsNo);

//-----------------------------------------------------------------------------
/**
 * 퓬̏
 *
 * @param	
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
void FLD_MP_SetAfferBattle(FIELDSYS_WORK * fsys, BATTLE_PARAM *inBattleParam)
{
	u16 hp;
	u8 cond;
	int monsno;
	
	ENC_SV_PTR data;
	MPD_PTR mpd;
	POKEPARTY *poke_party;
	POKEMON_PARAM *poke_param;
	
	//ړ|PƐ퓬`FbN
	poke_party = inBattleParam->poke_party[POKEPARTY_ENEMY];
	poke_param = PokeParty_GetMemberPointer(poke_party, 0);

	data = EncDataSave_GetSaveDataPtr(fsys->savedata);
	monsno = PokeParaGet(poke_param, ID_PARA_monsno, NULL);
	mpd = GetMovePokeDataByMondNo(data, monsno);
	
	if(mpd != NULL){			//ړ|PƃGJEg
		hp = (u16)(PokeParaGet(poke_param,ID_PARA_hp, NULL));
		cond = (u8)(PokeParaGet(poke_param,ID_PARA_condition, NULL));
		//Ăgo0͕ߊlH
		if ( ((inBattleParam->win_lose_flag==FIGHT_WIN)&&(hp == 0)) ||
			 (inBattleParam->win_lose_flag==FIGHT_POKE_GET) ) {
			//GJEgړ|Pf[^NA
			EncDataSave_ClearMovePokeData(&mpd);
		}else{
			//p[^̔f
			EncDataSave_SetMovePokeDataParam(mpd, MP_PARAM_HP, hp);
			EncDataSave_SetMovePokeDataParam(mpd, MP_PARAM_COND, cond);
		}
		//3C̈ړ|P̃Wv
		JumpMovePokeAffterBattle(data, fsys->location->zone_id);

	}else{			//ʏ|PƃGJEg
		//30̊mŁA3C̈ړ|P̃Wv
		if ( gf_p_rand(100)<30 ){
			JumpMovePokeAffterBattle(data, fsys->location->zone_id);
		}
	}
}

//-----------------------------------------------------------------------------
/**
 * 퓬̈ړ|PWv
 *
 * @param	
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
static void JumpMovePokeAffterBattle(ENC_SV_PTR inEncData, const int inZoneID)
{
	int zone;
	u8 i;
	for(i=0;i<MOVE_POKE_MAX;i++){
		//ړŁAAlƓ][ɂ邩H
		if ( EncDataSave_IsMovePokeValid(inEncData, i) ){
			zone = MP_GetMovePokeZone(EncDataSave_GetMovePokeZoneIdx(inEncData, i));
			if (inZoneID == zone){
				//Wv
				MP_JumpMovePokemon(inEncData, i);
			}
		}
	}
}

//-----------------------------------------------------------------------------
/**
 * X^[io[ړ|Pf[^擾
 *
 * @param	inMonsNo	X^[io[
 *
 * @return	MPD_PTR		ړ|Pf[^|C^ ȂꍇNULLԂ
 *
*/ 
//-----------------------------------------------------------------------------
static MPD_PTR GetMovePokeDataByMondNo(ENC_SV_PTR inEncData, const int inMonsNo)
{
	u8 i;
	MPD_PTR mpd;
	for(i=0;i<MOVE_POKE_MAX;i++){
		if ( EncDataSave_IsMovePokeValid(inEncData, i) ){
			mpd = EncDataSave_GetMovePokeDataPtr(inEncData, i);
			if (inMonsNo == EncDataSave_GetMovePokeDataParam(mpd, MP_PARAM_MONSNO)){
				return mpd;
			}
		}
	}
	return NULL;
}
