/**
 *	@file	fld_nmixer.c
 *	@brief	tB[hp@ibc~LT[\[X
 *	@author	Miyuki Iwasawa
 *	@date	06.04.06
 */

#include "common.h"
#include "system/procsys.h"
#include "system/snd_tool.h"
#include "system/fontproc.h"
#include "system/pm_str.h"
#include "system/buflen.h"
#include "system/palanm.h"
#include "system/savedata.h"
#include "itemtool/itemsym.h"
#include "itemtool/item.h"
#include "gflib/strbuf_family.h"

#define __FIELDSYS_H_GLOBAL__
#include "fieldsys.h"

#include "application/nutmixer.h"

///vg^Cv
NUTMIXER_PARAM* NutMixer_CreateCallWork(int mode,SAVEDATA* savedata,int heapID, FNOTE_DATA * fnote);
NUTMIXER_PARAM* FieldNutMixer_InitCall(FIELDSYS_WORK* fsys,int mode,int heapID);

/**
 *	@brief	ibc~LT[Ăяo[Nf[^쐬
 *
 *	@param	mode	NUTMIXER_CALL_LOCAL:0	lvC[h
 *					NUTMIXER_CALL_COMM:1	ʐM[h
 */
NUTMIXER_PARAM* NutMixer_CreateCallWork(int mode,SAVEDATA* savedata,int heapID, FNOTE_DATA * fnote)
{
	NUTMIXER_PARAM* wk;
	
	wk = sys_AllocMemory(heapID,sizeof(NUTMIXER_PARAM));
	MI_CpuClear8(wk,sizeof(NUTMIXER_PARAM));

	//Z[uf[^ubN擾
	wk->SaveData = savedata;
	wk->poruSave = SaveData_GetPorutoBlock(savedata);
	wk->mySave = SaveData_GetMyStatus(savedata);
	wk->itemSave = SaveData_GetMyItem(savedata);
	wk->configSave = SaveData_GetConfig(savedata);
	wk->fnote = fnote;

	//샂[h擾
	wk->sys_mode = mode;

	return wk;
}

//-----------------------------------------------------------------------------
/**
*	ibc~LT[֘A
*/
//-----------------------------------------------------------------------------
/**
 *	@brief	ibc~LT[TuvZXo^
 */
static void NutMixer_SetProc(FIELDSYS_WORK* fsys,NUTMIXER_PARAM* np)
{
	GameSystem_StartSubProc(fsys, &NutMixerProcData,np);
}

/**
 *	@brief	ibc~LT[Ăяo
 *
 *	@param	mode	NUTMIXER_CALL_LOCAL:0	lvC[h
 *					NUTMIXER_CALL_COMM:1	ʐM[h
 */
NUTMIXER_PARAM* FieldNutMixer_InitCall(FIELDSYS_WORK* fsys,int mode,int heapID)
{
	NUTMIXER_PARAM* np;
	
	np = NutMixer_CreateCallWork(mode,GameSystem_GetSaveData(fsys),heapID,fsys->fnote);	
	NutMixer_SetProc(fsys,np);
	
	return np;
}

