//============================================================================================
/**
 * @file	hill_back_poke.c
 * @brief	RGJEg|P֘A
 * @author	Nozomu Saito
 * @date	2006.05.25
 */
//============================================================================================
#include "common.h"
#include "savedata/encount.h"
#include "arc/encdata_ex.naix"
#include "encount_define.h"

#include "system/arc_tool.h"

#include "hill_back_poke.h"

//------------------------------------------------------------------
/**
 * @brief	R|P̃Zbg(oŃZbg)
 * @param	sv		Z[uf[^|C^	
 * @return	none
 */
//------------------------------------------------------------------
void HillBack_SetEncPokemon(SAVEDATA* sv)
{
	u16 idx;
	u16 idx1,idx2;
	int monsno[2];
	int *tbl;

	//RGJEge[u擾
	tbl = ArchiveDataLoadMallocLo(ARC_ENCDATA_EX, NARC_encdata_ex_mnt_af_bin, HEAPID_FIELD);
	//g|PCfbNX擾i2́j
	EncDataSave_GetHillBackPokeIdx(sv, &idx1, &idx2);
	//CfbNXƃe[u|P擾
	if (idx1 != HILL_BACK_POKE_NONE){
		monsno[0] = tbl[idx1];
	}else{
		monsno[0] = 0;
	}
	if (idx2 != HILL_BACK_POKE_NONE){
		monsno[1] = tbl[idx2];
	}else{
		monsno[1] = 0;
	}

	while(1){
		//|P_Io
		idx = gf_p_rand(HILL_BACK_ENC_MONS_MAX);
				
		//Io|P͓gɓo^ς݂H
		if ( (monsno[0]!=tbl[idx])&&
			 (monsno[1]!=tbl[idx]) ){
			//o^ς݂łȂ΁Aoœo^
			EncDataSave_SetHillBackPokeIdx(sv, idx);
			break;
		}
	}
	sys_FreeMemoryEz(tbl);
}

//------------------------------------------------------------------
/**
 * @brief	bɏoĂ|P̃X^[io[Ԃ
 * @param	sv		Z[uf[^|C^
 * @return	int		X^[io[
 */
//------------------------------------------------------------------
int HillBack_GetMonsNo(SAVEDATA* sv)
{
	int monsno;
	int *tbl;
	u16 idx1,idx2;
	EncDataSave_GetHillBackPokeIdx(sv, &idx1, &idx2);

	GF_ASSERT(idx1!=HILL_BACK_POKE_NONE);

	//RGJEge[u擾
	tbl = ArchiveDataLoadMallocLo(ARC_ENCDATA_EX, NARC_encdata_ex_mnt_af_bin, HEAPID_FIELD);
	monsno = tbl[idx1];

	sys_FreeMemoryEz(tbl);

	return monsno;
}
