//******************************************************************************
/**
 *
 * @file	localres.c
 * @brief	mۂ\[ẌXɔzčėp܂B
 * @author	kagaya
 * @data	05.07.25
 *
 */
//******************************************************************************
#include "common.h"
#include "localres.h"

//==============================================================================
//	define
//==============================================================================
#define LRES_SEEK_SIZE (sizeof(u32))

//==============================================================================
//	typedef
//==============================================================================
//--------------------------------------------------------------
///	LRESID`
//--------------------------------------------------------------
typedef struct _RESID		RESID;

//--------------------------------------------------------------
///	LRES\
//--------------------------------------------------------------
typedef struct _LRES
{
	u32 main_heap_id;								//mۂHEAP ID
	u32 reg_heap_id;								//o^HEAP ID
	u32 resid_max;									//IDo^ő吔
	u32 total_size;									//mۂTCY
	u32 resid_total_size;							//[J\[XǗp[NőTCY
	RESID *resid_ptr;								//[J\[XǗ[N *
};

#define LRES_SIZE (sizeof(LRES))	//LRESTCY

//--------------------------------------------------------------
///	RESID\
//--------------------------------------------------------------
typedef struct _RESID
{
	void *alloc_ptr;								//mۂĂ郊\[X *@m=NULL
	u32 alloc_id;									//o^ID
};

#define RESID_SIZE (sizeof(RESID))	//RESIDTCY

//==============================================================================
//	vg^Cv
//==============================================================================
static void * lRes_AllocHeap( LRES *lres, u32 size, ALLOCTYPE type );
static void lRes_FreeHeap( void *alloc );
static RESID * lRes_IDSearch( LRES *lres, u32 id );
static RESID * lRes_IDSpaceSearch( LRES *lres );
static RESID * lRes_IDAllocSearch( LRES *lres, void *alloc );
static void lRes_ResIDInit( RESID *resid, u32 id, void *alloc );
static void lRes_ResIDDelete( RESID *resid );

#ifdef PM_DEBUG
#endif

//==============================================================================
//	local resource
//==============================================================================
//--------------------------------------------------------------
/**
 * LRES
 * @param	main_heap_id	mۂHEAP ID
 * @param	reg_heap_id		mۂ̈ʂHEAP ID
 * @param	size			mۂTCY
 * @param	regid_max		o^IDő吔BIDǗvȂꍇ0w
 * @retval	LRES*			mۂLRES *
 */
//--------------------------------------------------------------
LRES * LRes_Init( u32 main_heap_id, u32 reg_heap_id, u32 size, u32 resid_max )
{
	u32 resid_size,total_size;
	LRES *lres;
	
	resid_size = RESID_SIZE * resid_max;
	total_size = size + resid_size + LRES_SIZE;
	
	{
		BOOL ret = sys_CreateHeap( main_heap_id, reg_heap_id, total_size );
		GF_ASSERT( ret == TRUE && "LRes_Init()̈mێs" );
	}
	
	size = total_size - size;
	lres = sys_AllocMemory( reg_heap_id, size );
	GF_ASSERT( lres != NULL && "LRes_Init()̈mێs" );
	memset( lres, 0, size );
	
	lres->main_heap_id = main_heap_id;
	lres->reg_heap_id = reg_heap_id;
	lres->resid_max = resid_max;
	lres->total_size = total_size;
	lres->resid_total_size = resid_size;
	lres->resid_ptr = (void*)((u32)lres + LRES_SIZE);
	
	return( lres );
}

//--------------------------------------------------------------
/**
 * LRES폜
 * @param	lres	LRES *
 * @retval	nothing
 */
//--------------------------------------------------------------
void LRes_Delete( LRES *lres )
{
	{
		u32 max = lres->resid_max;
		RESID *resid = lres->resid_ptr;
	
		while( max ){
			if( resid->alloc_ptr != NULL ){
				LRes_FreeID( lres, resid->alloc_id );
			}
			
			max--; resid++;
		}
	}
	
	{
		u32 reg_heap_id = lres->reg_heap_id;
		sys_FreeMemoryEz( lres );
		sys_DeleteHeap( reg_heap_id );
	}
}

//--------------------------------------------------------------
/**
 * LRES ̈m
 * @param	lres	LRES *
 * @param	size	mۂTCY
 * @param	type	ALLOCTYPE
 * @retval	void*	mۂ̈ NULL=mۏoȂB mۏoȂꍇAASSERT
 */
//--------------------------------------------------------------
void * LRes_Alloc( LRES *lres, u32 size, ALLOCTYPE type )
{
	void *alloc = lRes_AllocHeap( lres, size, type );
	return( alloc );
}

//--------------------------------------------------------------
/**
 * LRES ̈mہ@IDo^A
 * @param	lres	LRES *
 * @param	id		o^ID
 * @param	size	mۂTCY
 * @param	type	ALLOCTYPE
 * @retval	void*	mۂ̈ NULL=mۏoȂB mۏoȂꍇAASSERT
 */
//--------------------------------------------------------------
void * LRes_AllocID( LRES *lres, u32 id, u32 size, ALLOCTYPE type )
{
	RESID *resid = lRes_IDSpaceSearch( lres );
	GF_ASSERT( resid != NULL && "LRes_AllocID()o^ő\n" );
	
	{
		void *alloc = lRes_AllocHeap( lres, size, type );
		lRes_ResIDInit( resid, id, alloc );
		return( alloc );
	}
}

//--------------------------------------------------------------
/**
 * LRES ̈JBallocIDo^ĂꍇAID폜
 * @param	lres		LRES
 * @param	alloc		LRes_AllocŊmۂ̈
 * @retval	nothing
 */
//--------------------------------------------------------------
void LRes_Free( LRES *lres, void *alloc )
{
	RESID *resid = lRes_IDAllocSearch( lres, alloc );
	if( resid != NULL ){ lRes_ResIDDelete( resid ); }
	lRes_FreeHeap( alloc );
}

//--------------------------------------------------------------
/**
 * LRES ̈J ID
 * @param	lres		LRES
 * @param	id			LRes_AllocIDŎw肵ID
 * @retval	nothing
 */
//--------------------------------------------------------------
void LRes_FreeID( LRES *lres, u32 id )
{
	RESID *resid = lRes_IDSearch( lres, id );
	GF_ASSERT( resid != NULL && "LRes_FreeID()ido^\n" );
	lRes_FreeHeap( resid->alloc_ptr );
	lRes_ResIDDelete( resid );
}

//--------------------------------------------------------------
/**
 * LRES IDẅ擾B
 * @param	lres		LRES *
 * @param	id			LRes_AllocIDŎw肵ID
 * @retval	void*		LRes_AllocID(id)Ŏ擾̈
 */
//--------------------------------------------------------------
void * LRes_IDResGet( LRES *lres, u32 id )
{
	RESID *resid = lRes_IDSearch( lres, id );
	GF_ASSERT( resid != NULL && "LRes_IDResGet()ido^\n" );
	return( resid->alloc_ptr );
}

//--------------------------------------------------------------
/**
 * LRES IDo^ς݃`FbN
 * @param	lres		LRES
 * @param	id			LRes_AllocIDŎw肵ID
 * @retval	int			TRUE=o^ς݁@FALSE=o^ĂȂ
 */
//--------------------------------------------------------------
int LRes_IDResCheck( LRES *lres, u32 id )
{
	RESID *resid = lRes_IDSearch( lres, id );
	if( resid != NULL ){ return( TRUE ); }
	return( FALSE );
}

//==============================================================================
//	LRES c[
//==============================================================================
//--------------------------------------------------------------
/**
 * LRES_Alloc()+ArchiveDataLoadByHandle()B
 * LRES_Alloc()Ŋmۂ̈փA[JCuf[^]B
 * datId̃TCYAmۂB
 * @param	lres		LRES *
 * @param	handle		ARCHANDLE*
 * @param	datId		f[^CfbNXID
 * @param	type		ALLOCTYPE
 * @retval	void*		mہAf[^]ς݂̗̈
 */
//--------------------------------------------------------------
void * LResUtil_AllocArcLoad( LRES *lres, ARCHANDLE *handle, u32 datId, ALLOCTYPE type )
{
	u32 size = ArchiveDataSizeGetByHandle( handle, datId );
	void *alloc = LRes_Alloc( lres, size, type );
	ArchiveDataLoadByHandle( handle, datId, alloc );
	return( alloc );
}

//--------------------------------------------------------------
/**
 * LRES_AllocID()+ArchiveDataLoadByHandle()B
 * LRES_AllocID()Ŋmۂ̈փA[JCuf[^]B
 * datId̃TCYAmۂB
 * @param	lres		LRES *
 * @param	id			o^ID
 * @param	handle		ARCHANDLE*
 * @param	datId		f[^CfbNXID
 * @param	type		ALLOCTYPE
 * @retval	void*		mہAf[^]ς݂̗̈
 */
//--------------------------------------------------------------
void * LResUtil_AllocIDArcLoad(
		LRES *lres, u32 id, ARCHANDLE *handle, u32 datId, ALLOCTYPE type )
{
	u32 size = ArchiveDataSizeGetByHandle( handle, datId );
	void *alloc = LRes_AllocID( lres, id, size, type );
	ArchiveDataLoadByHandle( handle, datId, alloc );
	return( alloc );
}

//==============================================================================
//	p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * ̈m
 * @param	lress		LRES *
 * @param	size		mۂTCY
 * @param	type		ALLOCTYPE
 * @retval	void*		mۂ̈
 */
//--------------------------------------------------------------
static void * lRes_AllocHeap( LRES *lres, u32 size, ALLOCTYPE type )
{
	void *alloc;
	
	if( type == ALLOC_FR ){ alloc = sys_AllocMemory( lres->reg_heap_id, size ); }
	else{ alloc = sys_AllocMemoryLo( lres->reg_heap_id, size ); }
	
	GF_ASSERT( alloc != NULL && "lRes_AllocHeap()mێs\n" );
	return( alloc );
}

//--------------------------------------------------------------
/**
 * ̈J
 * @param	lress		LRES *
 * @param	alloc		lRes_AllocHeap()Ŋmۂ̈
 * @retval	nothing
 */
//--------------------------------------------------------------
static void lRes_FreeHeap( void *alloc )
{
	sys_FreeMemoryEz( alloc );
}

//--------------------------------------------------------------
/**
 * ID
 * @param	lres		LRES *
 * @param	id			ID
 * @retval	RESID*		vRESID *@vȂ=NULL
 */
//--------------------------------------------------------------
static RESID * lRes_IDSearch( LRES *lres, u32 id )
{
	u32 max = lres->resid_max;
	RESID *resid = lres->resid_ptr;
	
	while( max ){
		if( resid->alloc_ptr != NULL && resid->alloc_id == id ){
			return( resid );
		}
		
		resid++; max--;
	};
	
	return( NULL );
}

//--------------------------------------------------------------
/**
 * RESID󂫒T
 * @param	lres		LRES *
 * @retval	RESID*		RESID@󂫖=NULL
 */
//--------------------------------------------------------------
static RESID * lRes_IDSpaceSearch( LRES *lres )
{
	u32 max = lres->resid_max;
	RESID *resid = lres->resid_ptr;
	
	while( max ){
		if( resid->alloc_ptr == NULL ){
			return( resid );
		}
		
		resid++; max--;
	}
	
	return( NULL );
}

//--------------------------------------------------------------
/**
 * RESID@w肳ꂽ̈悪o^Ă邩
 * @param	lres		LRES *
 * @param	alloc		mۂ̈
 * @retval	RESID*		YRESID@Y=NULL
 */
//--------------------------------------------------------------
static RESID * lRes_IDAllocSearch( LRES *lres, void *alloc )
{
	u32 max = lres->resid_max;
	RESID *resid = lres->resid_ptr;
	
	while( max ){
		if( resid->alloc_ptr == alloc ){
			return( resid );
		}
		
		resid++; max--;
	}
	
	return( NULL );
}

//--------------------------------------------------------------
/**
 * RESID
 * @param	resid		RESID *
 * @param	id			o^ID
 * @param	alloc		mۂĂ̈
 * @retval	nothing
 */
//--------------------------------------------------------------
static void lRes_ResIDInit( RESID *resid, u32 id, void *alloc )
{
	resid->alloc_ptr = alloc;
	resid->alloc_id = id;
}

//--------------------------------------------------------------
/**
 * RESID폜
 * @param	resid		폜RESID *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void lRes_ResIDDelete( RESID *resid )
{
	resid->alloc_ptr = NULL;
	resid->alloc_id = 0;
}

//==============================================================================
//	fobO
//==============================================================================
//----
#ifdef PM_DEBUG
//----
//----
#endif //PM_DEBUG
//----
