//=============================================================================
/**
 * @file	map_attr.c
 * @brief	}bvAgr[g
 * @date	2005.12.15
 * @author	tamada GAME FREAK inc.
 */
//=============================================================================

#include <nitro.h>
#include "map_attr.h"

#include "gflib/assert.h"

//=============================================================================
//=============================================================================
//}bvAgr[gǗ\玩`e[u
//e\[Xł̎QƂ͋֎~B
#include "../fielddata/mapattr/map_attr.h"

//}bvAgr[gǗ\玩锻pe[u
//e\[Xł̎QƂ͋֎~B
#include "../fielddata/mapattr/map_attr.dat"

//=============================================================================
//
//		Agr[g֐`
//
//
//	xlăCC֐`̂B
//=============================================================================
//--------------------------------------------------------------
///	}bvAgr[g`FbNF
//--------------------------------------------------------------
BOOL MATR_IsGrass(MATR matr)
{
	return (matr == MATTR_E_KUSA_1);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF
//--------------------------------------------------------------
BOOL MATR_IsLongGrass(MATR matr)
{
	return (matr == MATTR_E_KUSA_2);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFJE^[
//--------------------------------------------------------------
BOOL MATR_IsCounter(MATR matr)
{
	return (matr == MATTR_COUNTER_1);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFhA
//--------------------------------------------------------------
BOOL MATR_IsDoor(MATR matr)
{
	return (matr == MATTR_MAT_10);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFE}bg
//--------------------------------------------------------------
BOOL MATR_IsRightMat(MATR matr)
{
	return (matr == MATTR_MAT_03);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF}bg
//--------------------------------------------------------------
BOOL MATR_IsLeftMat(MATR matr)
{
	return (matr == MATTR_MAT_04);
}
 
//--------------------------------------------------------------
///	}bvAgr[g`FbNF}bg
//--------------------------------------------------------------
BOOL MATR_IsUpMat(MATR matr)
{
	return (matr == MATTR_MAT_05);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF}bg
//--------------------------------------------------------------
BOOL MATR_IsDownMat(MATR matr)
{
	return (matr == MATTR_MAT_06);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFE}bgi󖳂j
//--------------------------------------------------------------
BOOL MATR_IsRightNoArrowMat(MATR matr)
{
	return (matr == MATTR_MAT_13);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF}bgi󖳂j
//--------------------------------------------------------------
BOOL MATR_IsLeftNoArrowMat(MATR matr)
{
	return (matr == MATTR_MAT_14);
}
 
//--------------------------------------------------------------
///	}bvAgr[g`FbNF}bgi󖳂j
//--------------------------------------------------------------
BOOL MATR_IsUpNoArrowMat(MATR matr)
{
	return (matr == MATTR_MAT_15);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF}bgi󖳂j
//--------------------------------------------------------------
BOOL MATR_IsDownNoArrowMat(MATR matr)
{
	return (matr == MATTR_MAT_16);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF
//--------------------------------------------------------------
BOOL MATR_IsWater(MATR matr)
{
	return (MapAttributeData[matr] & MATTR_WATER_MASK) != 0;
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFl
//--------------------------------------------------------------
BOOL MATR_IsSand(MATR matr)
{
	return (matr == MATTR_SUNA_01);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF
//--------------------------------------------------------------
BOOL MATR_IsShoal(MATR matr)
{
	return (matr == MATTR_ASASE_01);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFɃWv
//--------------------------------------------------------------
BOOL MATR_IsJumpUp(MATR matr)
{
	return (matr == MATTR_JUMP_03);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFɃWv
//--------------------------------------------------------------
BOOL MATR_IsJumpDown(MATR matr)
{
	return (matr == MATTR_JUMP_04);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFɃWv
//--------------------------------------------------------------
BOOL MATR_IsJumpLeft(MATR matr)
{
	return (matr == MATTR_JUMP_02);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFEɃWv
//--------------------------------------------------------------
BOOL MATR_IsJumpRight(MATR matr)
{
	return (matr == MATTR_JUMP_01);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFp\R
//--------------------------------------------------------------
BOOL MATR_IsPC(MATR matr)
{
	return	(matr == MATTR_PC_1);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF^E}bv
//--------------------------------------------------------------
BOOL MATR_IsMap(MATR matr)
{
	return	(matr == MATTR_MAP_1);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF0Œʂ
//--------------------------------------------------------------
BOOL MATR_IsWaterHeightLv1(MATR matr)
{
	return (matr == MATTR_WATER_GYM_HEIGHT01);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF2Œʂ
//--------------------------------------------------------------
BOOL MATR_IsWaterHeightLv2(MATR matr)
{
	return (matr == MATTR_WATER_GYM_HEIGHT02);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF4Œʂ
//--------------------------------------------------------------
BOOL MATR_IsWaterHeightLv3(MATR matr)
{
	return (matr == MATTR_WATER_GYM_HEIGHT03);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFȂȂ
//--------------------------------------------------------------
BOOL MATR_IsWaterNoIn(MATR matr)
{
	return (matr == MATTR_WATER_NO_IN);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFGXJ[^[@܂Ԃ
//--------------------------------------------------------------
BOOL MATR_IsEscalator(MATR matr)
{
	return (matr == MATTR_MAT_11);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFGXJ[^[@܂ԂȂ
//--------------------------------------------------------------
BOOL MATR_IsEscalatorNonRet(MATR matr)
{
	return (matr == MATTR_MAT_12);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFKi(E)
//--------------------------------------------------------------
BOOL MATR_IsRightStairs(MATR matr)
{
	return (matr == MATTR_MAT_17);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFKi()
//--------------------------------------------------------------
BOOL MATR_IsLeftStairs(MATR matr)
{
	return (matr == MATTR_MAT_18);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFX
//--------------------------------------------------------------
BOOL MATR_IsIce(MATR matr)
{
	return (matr == MATTR_ICE_01);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFǁi㉺j
//--------------------------------------------------------------
BOOL MATR_IsRockClimV(MATR matr)
{
	return (matr == MATTR_ROCKCLIM_01);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFǁiEj
//--------------------------------------------------------------
BOOL MATR_IsRockClimH(MATR matr)
{
	return (matr == MATTR_ROCKCLIM_02);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF{I1
//--------------------------------------------------------------
BOOL MATR_IsLittleBookRack01(MATR matr)
{
	return (matr == MATTR_LITTLERACK_01);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF{I2
//--------------------------------------------------------------
BOOL MATR_IsLittleBookRack02(MATR matr)
{
	return (matr == MATTR_LITTLERACK_02);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF傫{IP
//--------------------------------------------------------------
BOOL MATR_IsBookRack01(MATR matr)
{
	return (matr == MATTR_BOOKRACK_01);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF傫{IQ
//--------------------------------------------------------------
BOOL MATR_IsBookRack02(MATR matr)
{
	return (matr == MATTR_BOOKRACK_02);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF
//--------------------------------------------------------------
BOOL MATR_IsPot(MATR matr)
{
	return (matr == MATTR_POT_01);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFS~
//--------------------------------------------------------------
BOOL MATR_IsTrashBox(MATR matr)
{
	return (matr == MATTR_TRASHBOX_01);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFVbvIP
//--------------------------------------------------------------
BOOL MATR_IsShopBookRack01(MATR matr)
{
	return (matr == MATTR_SHOPRACK_01);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFVbvIQ
//--------------------------------------------------------------
BOOL MATR_IsShopBookRack02(MATR matr)
{
	return (matr == MATTR_SHOPRACK_02);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFVbvIR
//--------------------------------------------------------------
BOOL MATR_IsShopBookRack03(MATR matr)
{
	return (matr == MATTR_SHOPRACK_03);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF݌v}
//--------------------------------------------------------------
BOOL MATR_IsBluePrint(MATR matr)
{
	return (matr == MATTR_BLUEPRINT_01);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF
//--------------------------------------------------------------
BOOL MATR_IsSwamp(MATR matr)
{
	return (matr == MATTR_SWAMP_01 || matr == MATTR_SWAMP_02);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF[
//--------------------------------------------------------------
BOOL MATR_IsSwampDeep(MATR matr)
{
	return (matr == MATTR_SWAMP_02);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF
//--------------------------------------------------------------
BOOL MATR_IsSwampGrass(MATR matr)
{
	return (matr == MATTR_SWAMPGRASS_01 || matr == MATTR_SWAMPGRASS_02);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF[
//--------------------------------------------------------------
BOOL MATR_IsSwampGrassDeep(MATR matr)
{
	return (matr == MATTR_SWAMPGRASS_02);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF
//--------------------------------------------------------------
BOOL MATR_IsSnow(MATR matr)
{
	return (matr == MATTR_SNOW_01 || matr == MATTR_SNOW_02 || matr == MATTR_SNOW_03 || matr == MATTR_SNOW_04);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFƂ󂢐
//--------------------------------------------------------------
BOOL MATR_IsMostShallowSnow(MATR matr)
{
	return (matr == MATTR_SNOW_04 );
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF󂢐
//--------------------------------------------------------------
BOOL MATR_IsShallowSnow(MATR matr)
{
	return (matr == MATTR_SNOW_01);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF[
//--------------------------------------------------------------
BOOL MATR_IsSnowDeep(MATR matr)
{
	return (matr == MATTR_SNOW_02);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFƐ[
//--------------------------------------------------------------
BOOL MATR_IsSnowDeepMost(MATR matr)
{
	return (matr == MATTR_SNOW_03);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF
//--------------------------------------------------------------
BOOL MATR_IsShiftingSand(MATR matr)
{
	return (matr == MATTR_SLOPE_01 || matr == MATTR_SLOPE_02);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFiij
//--------------------------------------------------------------
BOOL MATR_IsShiftingSandUpper(MATR matr)
{
	return (matr == MATTR_SLOPE_01);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFiij
//--------------------------------------------------------------
BOOL MATR_IsShiftingSandLower(MATR matr)
{
	return (matr == MATTR_SLOPE_02);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF]ԃWvij
//--------------------------------------------------------------
BOOL MATR_IsTakeOffLeft(MATR matr)
{
	return (matr == MATTR_TAKEOFF_01);
}
//--------------------------------------------------------------
///	}bvAgr[g`FbNF]ԃWviEj
//--------------------------------------------------------------
BOOL MATR_IsTakeOffRight(MATR matr)
{
	return (matr == MATTR_TAKEOFF_02);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbN:A
//--------------------------------------------------------------
BOOL MATR_IsDunFloor(MATR matr)
{
	return (matr == MATTR_E_ZIMEN_01);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbN:
//--------------------------------------------------------------
BOOL MATR_IsWaterFall(MATR matr)
{
	return (matr == MATTR_WATERFALL_01);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbN:Ԏ~
//--------------------------------------------------------------
BOOL MATR_IsBumpPost(MATR matr)
{
	return (matr == MATTR_BUMPPOST_01);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFֈړs
//--------------------------------------------------------------
BOOL MATR_IsBadMoveUpCheck(MATR matr)
{
	return (matr == MATTR_IDOHUKA_03 || matr == MATTR_IDOHUKA_05 ||
			matr == MATTR_IDOHUKA_06 || matr == MATTR_IDOHUKA_09 );
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFֈړs
//--------------------------------------------------------------
BOOL MATR_IsBadMoveDownCheck(MATR matr)
{
	return (matr == MATTR_IDOHUKA_04 || matr == MATTR_IDOHUKA_07 ||
			matr == MATTR_IDOHUKA_08 || matr == MATTR_IDOHUKA_09 );
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFֈړs
//--------------------------------------------------------------
BOOL MATR_IsBadMoveLeftCheck(MATR matr)
{
	return (matr == MATTR_IDOHUKA_02 || matr == MATTR_IDOHUKA_06 ||
			matr == MATTR_IDOHUKA_08 || matr == MATTR_IDOHUKA_10 );
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFEֈړs
//--------------------------------------------------------------
BOOL MATR_IsBadMoveRightCheck(MATR matr)
{
	return (matr == MATTR_IDOHUKA_01 || matr == MATTR_IDOHUKA_05 ||
			matr == MATTR_IDOHUKA_07 || matr == MATTR_IDOHUKA_10 );
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF܂
//--------------------------------------------------------------
BOOL MATR_IsPoolCheck(MATR matr)
{
	return (matr == MATTR_POOL_01 );
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFGJEgAgr[g
//--------------------------------------------------------------
BOOL MATR_IsEncount(MATR matr)
{
	if ((MapAttributeData[matr] & MATTR_ENCOUNT_MASK) != 0){
		return TRUE;
	} else {
		return FALSE;
	}
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFGJEgAgr[g
//--------------------------------------------------------------
BOOL MATR_IsWaterEnc(MATR matr)
{
	return TRUE;
}


//--------------------------------------------------------------
///	}bvAgr[g`FbNFTV
//--------------------------------------------------------------
BOOL MATR_IsTV(MATR matr)
{
	return (matr == MATTR_TV_1);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFf肱ݑΏۃAgr[g
//--------------------------------------------------------------
BOOL MATR_IsReflect(MATR matr)
{
	return (matr == MATTR_POOL_01||matr == MATTR_POOL_02);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFE֋ړ
//--------------------------------------------------------------
BOOL MATR_IsForceMoveRight(MATR matr)
{
	return (matr == MATTR_IDO_01);
}
//--------------------------------------------------------------
///	}bvAgr[g`FbNF֋ړ
//--------------------------------------------------------------
BOOL MATR_IsForceMoveLeft(MATR matr)
{
	return (matr == MATTR_IDO_02);
}
//--------------------------------------------------------------
///	}bvAgr[g`FbNF֋ړ
//--------------------------------------------------------------
BOOL MATR_IsForceMoveUp(MATR matr)
{
	return (matr == MATTR_IDO_03);
}
//--------------------------------------------------------------
///	}bvAgr[g`FbNF֋ړ
//--------------------------------------------------------------
BOOL MATR_IsForceMoveDown(MATR matr)
{
	return (matr == MATTR_IDO_04);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF[v|Cg
//--------------------------------------------------------------
BOOL MATR_IsWarpPoint(MATR matr)
{
	return (matr == MATTR_MAT_08);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFtO
//--------------------------------------------------------------
BOOL MATR_IsBridgeFlag(MATR matr)
{
	return (matr == MATTR_BRIDGE);
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF֘AAgr[g
//--------------------------------------------------------------
BOOL MATR_IsBridge(MATR matr)
{
	return( matr == MATTR_BRIDGE_GROUND ||
		matr == MATTR_BRIDGE_GROUND_E ||
		matr == MATTR_BRIDGE_WATER ||
		matr == MATTR_BRIDGE_SAND ||
		matr == MATTR_BRIDGE_SNOW ||
		matr == MATTR_BRIDGEV_GROUND ||
		matr == MATTR_BRIDGEV_GROUND_E ||
		matr == MATTR_BRIDGEV_WATER ||
		matr == MATTR_BRIDGEV_SAND ||
		matr == MATTR_BRIDGEH_GROUND ||
		matr == MATTR_BRIDGEH_GROUND_E ||
		matr == MATTR_BRIDGEH_WATER ||
		matr == MATTR_BRIDGEH_SAND );
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF{n
//--------------------------------------------------------------
BOOL MATR_IsBridgeGround(MATR matr)
{
	return( matr == MATTR_BRIDGE_GROUND ||
		matr == MATTR_BRIDGE_GROUND_E ||
		matr == MATTR_BRIDGEV_GROUND ||
		matr == MATTR_BRIDGEV_GROUND_E ||
		matr == MATTR_BRIDGEH_GROUND ||
		matr == MATTR_BRIDGEH_GROUND_E );
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF{C
//--------------------------------------------------------------
BOOL MATR_IsBridgeWater(MATR matr)
{
	return( matr == MATTR_BRIDGE_WATER ||
		matr == MATTR_BRIDGEV_WATER ||
		matr == MATTR_BRIDGEH_WATER );
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF{
//--------------------------------------------------------------
BOOL MATR_IsBridgeSand(MATR matr)
{
	return( matr == MATTR_BRIDGE_SAND ||
		matr == MATTR_BRIDGEV_SAND ||
		matr == MATTR_BRIDGEH_SAND );
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF{󂢐
//--------------------------------------------------------------
BOOL MATR_IsBridgeSnowShallow(MATR matr)
{
	return( matr == MATTR_BRIDGE_SNOW );
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF{c
//--------------------------------------------------------------
BOOL MATR_IsBridgeV(MATR matr)
{
	return(
		matr == MATTR_BRIDGEV_GROUND ||
		matr == MATTR_BRIDGEV_GROUND_E ||
		matr == MATTR_BRIDGEV_WATER ||
		matr == MATTR_BRIDGEV_SAND );
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNF{
//--------------------------------------------------------------
BOOL MATR_IsBridgeH(MATR matr)
{
	return(
		matr == MATTR_BRIDGEH_GROUND ||
		matr == MATTR_BRIDGEH_GROUND_E ||
		matr == MATTR_BRIDGEH_WATER ||
		matr == MATTR_BRIDGEH_SAND );
}

//--------------------------------------------------------------
///	}bvAgr[g`FbNFAgr[g擾s
//--------------------------------------------------------------
BOOL MATR_IsNotAttr(MATR matr)
{
	return( matr == MATTR_NO_ATTR );
}
