//============================================================================================
/**
 * @file	map_jump.c
 * @brief	}bvWv
 * @date	2006.02.07
 * @author	Nozomu Saito
 */
//============================================================================================
#include "common.h"
#include "fieldsys.h"
#include "field_event.h"
#include "field/location.h"
#include "ev_mapchange.h"
#include "field_3d_anime_ev.h"
#include "system/snd_tool.h"		//ꂪȂƁAfld_bgm.hŃG[o
#include "system/wipe.h"
#include "fld_bgm.h"

#include "map_jump_def.h"
#include "map_jump.h"

#include "fieldmap.h"		//for FieldFadeWipeSet

#include "map_attr.h"		//for attribute

#include "fieldmap_work.h"	//for hblamk wipe
#include "field_hblank.h"	//for hblank wipe

#include "zonedata.h"

#include "fld_flg_init.h"

static BOOL MJUMPEVT_Wipe(GMEVENT_CONTROL * event);

static BOOL MJUMPEVT_MapChangeParent(GMEVENT_CONTROL * event);

static BOOL MJUMPEVT_MapFadeOutMat(GMEVENT_CONTROL * event);
static BOOL MJUMPEVT_MapFadeOutDoor(GMEVENT_CONTROL * event);
static BOOL MJUMPEVT_MapFadeOutEsca(GMEVENT_CONTROL * event);
static BOOL MJUMPEVT_MapFadeOutStairs(GMEVENT_CONTROL * event);
static BOOL MJUMPEVT_MapFadeOutDunIn(GMEVENT_CONTROL * event);
static BOOL MJUMPEVT_MapFadeOutDunOut(GMEVENT_CONTROL * event);

static BOOL MJUMPEVT_MapFadeInDoor(GMEVENT_CONTROL * event);
static BOOL MJUMPEVT_MapFadeInBlack(GMEVENT_CONTROL * event);
static BOOL MJUMPEVT_MapFadeInEsca(GMEVENT_CONTROL * event);
static BOOL MJUMPEVT_MapFadeInStairs(GMEVENT_CONTROL * event);
static BOOL MJUMPEVT_MapFadeInDunOut(GMEVENT_CONTROL * event);

static void SetEscalatorIOPos(FIELDSYS_WORK *fsys);
static void SetStairsIOPos(FIELDSYS_WORK *fsys);
//tF[hAEgGtFNgXg
		//Ki
static const MAP_JUMP_FUNC MapJumpFadeOutFuncTbl[MAP_JUMP_TYPE_MAX] = {
	MJUMPEVT_MapFadeOutMat,		//O
	MJUMPEVT_MapFadeOutDoor,	//hAiOj
	MJUMPEVT_MapFadeOutEsca,	//GXJ[^[
	MJUMPEVT_MapFadeOutStairs,	//Ki
	MJUMPEVT_MapFadeOutDunIn,	//_W
	MJUMPEVT_MapFadeOutDunOut,	//_WzCgAEg
	MJUMPEVT_MapFadeOutMat,		//O}bg
};

//tF[hCGtFNgXg
		//Ki
static const MAP_JUMP_FUNC MapJumpFadeInFuncTbl[MAP_JUMP_TYPE_MAX] = {
	MJUMPEVT_MapFadeInDoor,		//O
	MJUMPEVT_MapFadeInBlack,	//hAiOj
	MJUMPEVT_MapFadeInEsca,		//GXJ[^[
	MJUMPEVT_MapFadeInStairs,	//Ki
	MJUMPEVT_MapFadeInBlack,	//_W
	MJUMPEVT_MapFadeInDunOut,	//_WzCgC
	MJUMPEVT_MapFadeInBlack,	//O}bg
};

//}bvWvʕ\ʒu␳֐Q
static const MAP_JUMP_POS_SET MapJumpPosSetFuncTbl[MAP_JUMP_TYPE_MAX] = {
	NULL,						//O
	NULL,						//hAiOj
	SetEscalatorIOPos,			//GXJ[^[
	SetStairsIOPos,				//Ki
	NULL,						//_W
	NULL,						//_Wo
	NULL,						//O}bg
};

typedef struct {
	int seq;							///<V[PXێ[N
	int call_seq;						///<R[V[PX[N
	LOCATION_WORK next;					///<}bvJڐwp[N
	///FLD_3D_ANIME_WORK_PTR DoorAnimeWork;
	void	*JumpEffectWork;
	int JumpType;
}EVENT_MAPCHG_WORK;


typedef struct WIPE_PARAM_tag
{
	int Seq;
	int Pattern;
	int Main;
	int Sub;
	u16 Col;
	int Div;
	int Sync;
	int Heap;
}WIPE_PARAM;

//-----------------------------------------------------------------------------
/**
 * @brief	CvCxgR[(X^ƂgCv̂Ƃ)
 * HuN荞݂~ACvIŁAuNăX^[g܂
 * @param	event		Cxg|C^
 * @param	inPattern	؂ւp^[ԍ
 * @param	inMain		Cv@CʃCvp^[
 * @param	inSub		Cv@TuʃCvp^[
 * @param	inCol		Cv̐F	
 * @param	inDiv		eCv̕	(1.2.3.4.....)
 * @param	inSync		eCv̏𕪊PЂ̃VN	(1.2.3.4.....)
 * @param	inHeap		gpq[v
 *
 * @return none
 */
//-----------------------------------------------------------------------------
void MJUMP_RequestWipe(	GMEVENT_CONTROL * event,
						int inPattern, int inMain,
						int inSub, u16 inCol,
						int inDiv, int inSync,
						int inHeap)
{
	WIPE_PARAM *wp = sys_AllocMemory(inHeap, sizeof(WIPE_PARAM));
	wp->Pattern = inPattern;
	wp->Main = inMain;
	wp->Sub = inSub;
	wp->Col = inCol;
	wp->Div = inDiv;
	wp->Sync = inSync;
	wp->Heap = inHeap;
	wp->Seq = 0;

	FieldEvent_Call(event, MJUMPEVT_Wipe, wp);
}

//-----------------------------------------------------------------------------
/**
 * @brief	CvCxg
 * @param	event	Cxg|C^
 * 
 * @return  BOOL	TRUE:I@FALSE:p
 */
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_Wipe(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	WIPE_PARAM *wp = FieldEvent_GetSpecialWork(event);
	switch (wp->Seq) {
	case 0:
		FLDHBLANK_SYS_Stop( fsys->fldmap->hblanksys );
		//CvX^[g
		WIPE_SYS_Start(	wp->Pattern, wp->Main, wp->Sub,
				wp->Col,wp->Div,wp->Sync,wp->Heap );
		wp->Seq++;
		break;
	case 1:
		if ( WIPE_SYS_EndCheck() ){
			FLDHBLANK_SYS_Start(fsys->fldmap->hblanksys);
			sys_FreeMemoryEz(wp);
			return TRUE;
		}
	}

	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	}bvJڃCxgZbg(hAAj)
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	zone		Jڐ}bṽ][w
 * @param	door_id		Jڐ}bvł̏oow
 * @param	inX			Jڐ}bvłXObhʒu
 * @param	inZ			Jڐ}bvłYObhʒu
 * @param	inDir		Jڐ}bvł̏
 * @param	inType		Wv^Cv
 *
 * Jڐ}bv̂ǂɏo邩͎̏̃}bvǂݍނ܂ł͂킩Ȃ͂Ȃ̂
 * {͍Ww͖ʂȂǁAÔ߁B܂GAƃ][̊֌W͍čl̂
 * GAwȂȂ\B
 */
//-----------------------------------------------------------------------------
void MJUMP_ChangeMap(FIELDSYS_WORK * fsys, const int zone, const int door_id,
						const int inX, const int inZ, const int inDir, const int inType )
{
	EVENT_MAPCHG_WORK * emw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_MAPCHG_WORK));
	emw->seq = 0;
	emw->call_seq = 0;
	//P[Vf[^쐬
	SetLocation(&emw->next, zone, door_id, inX, inZ, inDir);

	//Wv^CvZbg
	emw->JumpType = inType;

	//}bvWvCxg쐬
	FieldEvent_Set(fsys, MJUMPEVT_MapChangeParent, emw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	}bvJڃCxgZbg(}bv^CvQƂ)
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	zone		Jڐ}bṽ][w
 * @param	door_id		Jڐ}bvł̏oow
 * @param	inX			Jڐ}bvłXObhʒu
 * @param	inZ			Jڐ}bvłYObhʒu
 * @param	inDir			Jڐ}bvł̏
 *
 * Jڐ}bv̂ǂɏo邩͎̏̃}bvǂݍނ܂ł͂킩Ȃ͂Ȃ̂
 * {͍Ww͖ʂȂǁAÔ߁B܂GAƃ][̊֌W͍čl̂
 * GAwȂȂ\B
 */
//-----------------------------------------------------------------------------
void MJUMP_ChangeMapByLocation(FIELDSYS_WORK * fsys, const int zone, const int door_id,
						const int inX, const int inZ, const int inDir)
{
	int now_zone;
	int type;
	EVENT_MAPCHG_WORK * emw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_MAPCHG_WORK));
	
	emw->seq = 0;
	emw->call_seq = 0;
	//P[Vf[^쐬
	SetLocation(&emw->next, zone, door_id, inX, inZ, inDir);

	//݃}bvނ𒲂ׂ
	now_zone = fsys->location->zone_id;
	type = 0;
	if (ZoneData_IsDungeon(now_zone)){		//݃_W
		//ѐ𒲂ׂ
		if (ZoneData_IsDungeon(zone)){
			type = M_JUMP_MATIN;			//_WԈړ(ɓ̂Ɠ)
		}else if (ZoneData_IsOutDoor(zone)){
			type = M_JUMP_DUNOUT;			//_WO
		}else if (ZoneData_IsRoom(zone)){
			type = M_JUMP_MATIN;			//̒
		}else{
			GF_ASSERT(0);
		}
	}else if (ZoneData_IsOutDoor(now_zone)){//݉O
		//ѐ𒲂ׂ
		if (ZoneData_IsDungeon(zone)){
			type = M_JUMP_DUNIN;			//_W̒
		}else if (ZoneData_IsRoom(zone)){
			type = M_JUMP_MATIN;			//̒
		}else{
			GF_ASSERT(0);
		}
	}else if (ZoneData_IsRoom(now_zone)){	//ݎ
		//ѐ𒲂ׂ
		if (ZoneData_IsOutDoor(zone)){
			type = M_JUMP_MATOUT;			//O
		}else if(ZoneData_IsRoom(zone)){
			type = M_JUMP_MATIN;			//̈ړiɓ̂Ɠj
		}else if (ZoneData_IsDungeon(zone)){
			type = M_JUMP_MATOUT;			//_WցiOւł̂Ɠ)
		}else{
			GF_ASSERT(0);
		}
	}else{
		GF_ASSERT(0);
	}

	//Wv^CvZbg
	emw->JumpType = type;

	//}bvWvCxg쐬
	FieldEvent_Set(fsys, MJUMPEVT_MapChangeParent, emw);
}

//-----------------------------------------------------------------------------
/**
* @brief	}bvJڃCxg
*	
* @param	event	Cxg|C^
*
* @return  BOOL	TRUE:I@FALSE:p
*/ 
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapChangeParent(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	LOCATION_WORK* location = &emw->next;

	switch (emw->seq) {
	case 0:		//Wv^CvʂɃtF[hAEg̃CxgR[
		emw->call_seq = 0;

		//tB[hBGMtF[hAEg
		Snd_EvMapChangeBgmFadeCheck( fsys, location->zone_id );

		FieldEvent_Call(event, MapJumpFadeOutFuncTbl[emw->JumpType], emw);
		(emw->seq) ++;
		break;
	case 1:	//tB[hvZXI
		EventCmd_FinishFieldMap(event);
		(emw->seq) ++;
		break;
	case 2:	//ۂɃf[^V}bvɏ
		EventCmd_MapChangeByLocation(event, &emw->next);
		(emw->seq) ++;
		break;
	case 3:	//tB[hvZXJn
#if 0
		//ړ|Pאڈړ
		MP_MovePokemonNeighboring(EncDataSave_GetSaveDataPtr(fsys->savedata));
#endif
		EventCmd_StartFieldMap(event);
		(emw->seq) ++;
		break;
	case 4:
		//Wv^CvʂɁA@̏\WɃItZbg
		if (MapJumpPosSetFuncTbl[emw->JumpType] != NULL){
			MapJumpPosSetFuncTbl[emw->JumpType](fsys);
		}
		(emw->seq) ++;
		break;
	case 5:	//Wv^CvʂɃtF[hC̃CxgR[
		if( Snd_FadeCheck() != 0 ){								//TEhtF[h
			break;
		}
		Snd_EvMapChangeBgmPlay( fsys, location->zone_id );		//tB[hBGMĐ

		//n\NGXg
		PlaceNameRequestByFsys(fsys);

		emw->call_seq = 0;
		FieldEvent_Call(event, MapJumpFadeInFuncTbl[emw->JumpType], emw);
		(emw->seq) ++;
		break;
	case 6:	//I
		sys_FreeMemoryEz(emw);
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
* @brief	0:}bgtF[hAEg}bvJڃCxg(CxgR[)
*	
* @param	event	Cxg|C^
*
* @return  BOOL	TRUE:I@FALSE:p
*/
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeOutMat(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);

	switch (emw->call_seq) {
	case 0:
		Snd_SePlay( SEQ_SE_DP_KAIDAN2 );
/**
		//"}bvJڐp"tF[hAEg  BGMĐ
		{
			LOCATION_WORK* location = &emw->next;
			Snd_MapChangeFadeOutNextPlaySub( fsys, location->zone_id, BGM_FADE_ROOM_MODE );
		}
*/		
		EventCmd_FieldFadeOut(event);
		(emw->call_seq) ++;
		break;
	case 1:
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
* @brief	1:hAtF[hAEg}bvJڃCxg(CxgR[)
*	
* @param	event	Cxg|C^
*
* @return  BOOL	TRUE:I@FALSE:p
*/
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeOutDoor(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	FLD_3D_ANIME_WORK_PTR	anime_work;
	switch (emw->call_seq) {
	case 0:	//hAAj[Nm
		emw->JumpEffectWork = Fld3DAnm_AllocEvent3DAnimeWork();
		anime_work = (FLD_3D_ANIME_WORK_PTR)emw->JumpEffectWork;
		Fld3DAnm_EventSetGrid(	Player_NowGPosXGet( fsys->player ),
								Player_NowGPosZGet( fsys->player ),
								anime_work	);
		(emw->call_seq) ++;
		break;
	case 1:	//hAAj
		anime_work = (FLD_3D_ANIME_WORK_PTR)emw->JumpEffectWork;
		if ( Fld3DAnm_EventDoorInAnime(fsys, anime_work) ){
			Fld3DAnm_FreeEvent3DAnimeWork(emw->JumpEffectWork);	//hAAj[N
			(emw->call_seq) ++;
		}
		break;		
	case 2:
/**		
		//"}bvJڐp"tF[hAEg  BGMĐ
		{
			LOCATION_WORK* location = &emw->next;
			Snd_MapChangeFadeOutNextPlaySub( fsys, location->zone_id, BGM_FADE_ROOM_MODE );
		}
*/		
		EventCmd_FieldFadeOut(event);
		(emw->call_seq) ++;
		break;
	case 3:		//I
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
* @brief	2:GXJ[^[tF[hAEg}bvJڃCxg(CxgR[)
*	
* @param	event	Cxg|C^
*
* @return  BOOL	TRUE:I@FALSE:p
*/
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeOutEsca(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	FLD_3D_ANIME_WORK_PTR	anime_work;
	switch (emw->call_seq) {
	case 0:	//Aj[Nm
		emw->JumpEffectWork = Fld3DAnm_AllocEvent3DAnimeWork();
		anime_work = (FLD_3D_ANIME_WORK_PTR)emw->JumpEffectWork;
		Fld3DAnm_EventSetGrid(	Player_NowGPosXGet( fsys->player ),
								Player_NowGPosZGet( fsys->player ),
								anime_work	);
		(emw->call_seq)++;
		break;
	case 1:	//GXJ[^[Aj@
		anime_work = (FLD_3D_ANIME_WORK_PTR)emw->JumpEffectWork;
		if ( Fld3DAnm_EventEscalatorInAnime(fsys, anime_work,Player_DirGet( fsys->player )) ){
			Fld3DAnm_FreeEvent3DAnimeWork(emw->JumpEffectWork);	//Aj[N
			(emw->call_seq)++;
		}
		break;		
	case 2:		//I	
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
* @brief	3:KitF[hAEg}bvJڃCxg(CxgR[)
*	
* @param	event	Cxg|C^
*
* @return  BOOL	TRUE:I@FALSE:p
*/
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeOutStairs(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	FIELD_OBJ_PTR fop;
	switch (emw->call_seq) {
	case 0:	//@ړ
		{
			int dir = Player_DirGet( fsys->player );
			fop = Player_FieldOBJGet( fsys->player );
		
			if (dir == DIR_LEFT){	//
				FieldOBJ_AcmdSet(fop,AC_WALK_L_16F);
			}else if (dir == DIR_RIGHT){	//E
				FieldOBJ_AcmdSet(fop,AC_WALK_R_16F);
			}else{
				GF_ASSERT(0&&"@̌s");
			}
		}
		(emw->call_seq) ++;
		break;
	case 1:
		fop = Player_FieldOBJGet( fsys->player );
		if( FieldOBJ_AcmdEndCheck(fop) == TRUE ){	//AjI`FbN
			FieldOBJ_AcmdEnd(fop); //AjI	
			(emw->call_seq) ++;
		}
		break;
	case 2:
		//鉹
		Snd_SePlay( SEQ_SE_DP_KAIDAN2 );
		//tF[hAEgJn
		FieldFadeWipeSet(FLD_DISP_BRIGHT_BLACKOUT);
		
		(emw->call_seq) ++;
		break;
	case 3:	
		if (WIPE_SYS_EndCheck()) {
/**			
			//"}bvJڐp"tF[hAEg  BGMĐ
			{
				LOCATION_WORK* location = &emw->next;
				Snd_MapChangeFadeOutNextPlaySub( fsys, location->zone_id, BGM_FADE_ROOM_MODE );
			}
			(emw->call_seq) ++;
*/			
			return TRUE;
		}
		break;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
* @brief	4:_WtF[hAEg}bvJڃCxg(CxgR[)
*	
* @param	event	Cxg|C^
*
* @return  BOOL	TRUE:I@FALSE:p
*/
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeOutDunIn(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	FIELD_OBJ_PTR player = Player_FieldOBJGet( fsys->player );
	switch (emw->call_seq) {
	case 0:
		{
			FMJ_WORK_PTR work;
			work = MapJump_AllocWork();
			FieldEvent_Call(event, MapJump_EventFadeOutHole, work);
			emw->call_seq++;
		}
		break;
	case 1:
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
* @brief	5:_WotF[hAEg}bvJڃCxg(CxgR[)
*	
* @param	event	Cxg|C^
*
* @return  BOOL	TRUE:I@FALSE:p
*/
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeOutDunOut(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	FIELD_OBJ_PTR player = Player_FieldOBJGet( fsys->player );
	switch (emw->call_seq) {
	case 0:
		{
			FMJ_WORK_PTR work;
			work = MapJump_AllocWork();
			FieldEvent_Call(event, MapJump_EventFadeOutWhite, work);
			emw->call_seq++;
		}
		break;
	case 1:
		return TRUE;
	}
/**	
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	switch (emw->call_seq) {
	case 0:
		//Y[
		//JY[
		(emw->call_seq) ++;
		break;
	case 1:	//JY[҂
		if(1){
			FIELD_OBJ_PTR fop;
			fop = Player_FieldOBJGet( fsys->player );
			//l
			FieldOBJ_StatusBitSet_Vanish( fop, TRUE );
			//鉹
			Snd_SePlay( SEQ_SE_DP_KAIDAN2 );
			//CvX^[g	zCgAEg
			WIPE_SYS_Start(	WIPE_PATTERN_WMS, WIPE_TYPE_FADEOUT,
							WIPE_TYPE_FADEOUT,0x7fff,COMM_BRIGHTNESS_SYNC,1,HEAPID_WORLD );
			(emw->call_seq) ++;
		}
		break;
	case 2:	//CvI҂
		if ( WIPE_SYS_EndCheck() ){
			//"}bvJڐp"tF[hAEg  BGMĐ
			LOCATION_WORK* location = &emw->next;
			Snd_MapChangeFadeOutNextPlaySub( fsys, location->zone_id, BGM_FADE_ROOM_MODE );
			(emw->call_seq) ++;
		}
		break;
	case 3:		//I
		return TRUE;
	}
*/	
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
* @brief	0:OɏoƂtF[hC}bvJڃCxg(CxgR[)
*	
* @param	event	Cxg|C^
*
* @return  BOOL	TRUE:I@FALSE:p
*/
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeInDoor(GMEVENT_CONTROL * event)
{
	FIELD_OBJ_PTR fop;
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	FLD_3D_ANIME_WORK_PTR	anime_work;
	switch (emw->call_seq) {
	case 0:
		{
			u8 attr;
			FIELD_OBJ_PTR player = Player_FieldOBJGet( fsys->player );
			attr = GetAttributeLSB( fsys,
									Player_NowGPosXGet( fsys->player ),
									Player_NowGPosZGet( fsys->player ) );
			if (MATR_IsDoor(attr)){
				//@\
				FieldOBJ_StatusBitSet_Vanish( player, TRUE );
				(emw->call_seq) = 1;
			}else{
				FMJ_WORK_PTR work;
				work = MapJump_AllocWork();
				FieldEvent_Call(event, MapJump_EventFadeInShutSlide, work);
				(emw->call_seq) = 3;
			}
		}
		break;
	case 1:
		//hAAj[Nm
		emw->JumpEffectWork = (FLD_3D_ANIME_WORK_PTR)Fld3DAnm_AllocEvent3DAnimeWork();
		anime_work = (FLD_3D_ANIME_WORK_PTR)emw->JumpEffectWork;
		Fld3DAnm_EventSetGrid(	Player_NowGPosXGet( fsys->player ),
								Player_NowGPosZGet( fsys->player ),
								anime_work	);
		(emw->call_seq) ++;
		break;
	case 2:			//hAAj
		anime_work = (FLD_3D_ANIME_WORK_PTR)emw->JumpEffectWork;
		if ( Fld3DAnm_EventDoorOutAnime(fsys, anime_work) ){
			Fld3DAnm_FreeEvent3DAnimeWork(anime_work);	//hAAj[N
			{
				FIELD_OBJ_PTR player = Player_FieldOBJGet( fsys->player );
				//@\
				FieldOBJ_StatusBitSet_Vanish( player, FALSE );
			}
			return TRUE;		//I
		}
		break;
	case 3:
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
* @brief	1,4:A_WƂubNC}bvJڃCxg(CxgR[)
*	
* @param	event	Cxg|C^
*
* @return  BOOL	TRUE:I@FALSE:p
*/
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeInBlack(GMEVENT_CONTROL * event)
{
	FIELD_OBJ_PTR fop;
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	FLD_3D_ANIME_WORK_PTR	anime_work;
	switch (emw->call_seq) {
	case 0:
		{
			//ɃhA肷̂œꏈ
			u8 attr;
			FIELD_OBJ_PTR player = Player_FieldOBJGet( fsys->player );
			attr = GetAttributeLSB( fsys,
									Player_NowGPosXGet( fsys->player ),
									Player_NowGPosZGet( fsys->player ) );
			if (MATR_IsDoor(attr)){	//hA
				//@\
				FieldOBJ_StatusBitSet_Vanish( player, TRUE );
				emw->call_seq = 1;		//R[̃CxgV[PX1X^[g
				FieldEvent_Change(event,MJUMPEVT_MapFadeInDoor,emw);
			}else{					//hAȂ
				FMJ_WORK_PTR work;
				//tF[hCJn
				work = MapJump_AllocWork();
				FieldEvent_Call(event, MapJump_EventFadeInBlack, work);
				(emw->call_seq) ++;
			}
		}
		break;
	case 1:
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
* @brief	2:GXJ[^[tF[hC}bvJڃCxg(CxgR[)
*	
* @param	event	Cxg|C^
*
* @return  BOOL	TRUE:I@FALSE:p
*/
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeInEsca(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	FLD_3D_ANIME_WORK_PTR	anime_work;
	switch (emw->call_seq) {
	case 0:	//Aj[Nm
		emw->JumpEffectWork = Fld3DAnm_AllocEvent3DAnimeWork();
		anime_work = (FLD_3D_ANIME_WORK_PTR)emw->JumpEffectWork;
		Fld3DAnm_EventSetGrid(	Player_NowGPosXGet( fsys->player ),
								Player_NowGPosZGet( fsys->player ),
								anime_work	);
		(emw->call_seq)++;
		break;
	case 1:	//GXJ[^[Aj	~
		anime_work = (FLD_3D_ANIME_WORK_PTR)emw->JumpEffectWork;
		if ( Fld3DAnm_EventEscalatorOutAnime(fsys, anime_work,Player_DirGet( fsys->player )) ){
			Fld3DAnm_FreeEvent3DAnimeWork(emw->JumpEffectWork);	//Aj[N
			(emw->call_seq)++;
		}
		break;
	case 2:			//I
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
* @brief	3:KitF[hC}bvJڃCxg(CxgR[)
*	
* @param	event	Cxg|C^
*
* @return  BOOL	TRUE:I@FALSE:p
*/
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeInStairs(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	FIELD_OBJ_PTR fop;
	switch (emw->call_seq) {
	case 0:	//@ړ
		//tF[hCJn
		FieldFadeWipeSet(FLD_DISP_BRIGHT_BLACKIN);
		fop = Player_FieldOBJGet( fsys->player );
		
		if( /*FieldOBJ_AcmdSetCheck(fop) == TRUE*/1 ){	//AjZbgł邩?
			int dir;
			dir = Player_DirGet( fsys->player );
			if (dir == DIR_LEFT){	//
				FieldOBJ_AcmdSet(fop,AC_WALK_L_16F);	//oBCӂ̃AjZbg
			}else if (dir == DIR_RIGHT){	//E
				FieldOBJ_AcmdSet(fop,AC_WALK_R_16F);	//oBCӂ̃AjZbg
			}else{
				GF_ASSERT(0&&"@̌s");
			}
		}else{
			GF_ASSERT(0&&"Ajo^łȂ");
		}
		(emw->call_seq) ++;
		break;
	case 1:	
		fop = Player_FieldOBJGet( fsys->player );
		if( FieldOBJ_AcmdEndCheck(fop) == TRUE ){	//AjI`FbN
			FieldOBJ_AcmdEnd(fop); //AjI	
			(emw->call_seq) ++;
		}
		break;
	case 2:	
		if (WIPE_SYS_EndCheck()) {
			(emw->call_seq) ++;
		}
		break;
	case 3:		//I
		return TRUE;
	}
	return FALSE;

}

//-----------------------------------------------------------------------------
/**
* @brief	5:_WotF[hC}bvJڃCxg(CxgR[)
*	
* @param	event	Cxg|C^
*
* @return  BOOL	TRUE:I@FALSE:p
*/
//-----------------------------------------------------------------------------
static BOOL MJUMPEVT_MapFadeInDunOut(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * emw = FieldEvent_GetSpecialWork(event);
	FIELD_OBJ_PTR player = Player_FieldOBJGet( fsys->player );
	switch (emw->call_seq) {
	case 0:
		{
			FMJ_WORK_PTR work;
			work = MapJump_AllocWork();
			FieldEvent_Call(event, MapJump_EventFadeInWhite, work);
			emw->call_seq++;
		}
		break;
	case 1:
		return TRUE;
/**		
		//@\
		FieldOBJ_StatusBitSet_Vanish( player, TRUE );
		(emw->call_seq)++;
		break;
	case 1:
		//CvX^[g	zCgC
		WIPE_SYS_Start(	WIPE_PATTERN_WMS, WIPE_TYPE_FADEIN,
						WIPE_TYPE_FADEIN,0x7fff,COMM_BRIGHTNESS_SYNC,1,HEAPID_WORLD );
		(emw->call_seq) ++;
		break;
	case 2:	//@\āAʂ1Oi
		FieldOBJ_StatusBitSet_Vanish( player, FALSE );
		(emw->call_seq) ++;
		break;
	case 3:
		{
			FIELD_OBJ_PTR fop;
			fop = Player_FieldOBJGet( fsys->player );
			if( FieldOBJ_AcmdEndCheck(fop) == TRUE ){	//AjI`FbN
				FieldOBJ_AcmdEnd(fop); //AjI	
				(emw->call_seq) ++;
			}
		}
		break;
	case 4:
		if (WIPE_SYS_EndCheck()) {
			return TRUE;
		}
*/		
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
* @brief 2:WvAGXJ[^[Aj[VlA@̏ʒuύX
*	
* @param	fsys	tB[hVXe|C^
*
* @return	none
*/
//-----------------------------------------------------------------------------
static void SetEscalatorIOPos(FIELDSYS_WORK *fsys)
{
	int dir;
	VecFx32 vec;
	
	//}bvoʒu獶EPObh̏ꏊɎ@o
	//@̍W,擾
	dir = Player_DirGet( fsys->player );
	Player_VecPosGet( fsys->player, &vec );
	if (dir == DIR_RIGHT){
		vec.x -= (FX32_ONE*16);
	}else{	//(dir == DIR_LEFT)
		vec.x += (FX32_ONE*16);
	}
	//擾
	vec.y = GetHeightPack(	fsys, vec.y, vec.x, vec.z, NULL);

	//WZbg
	Player_VecPosInit( fsys->player, &vec, dir );
	//@Wړ̂ŃoChȂ
	GFC_ReSetCameraTarget(Player_VecPosPtrGet(fsys->player), fsys->camera_ptr);
	GFC_BindCameraTarget(Player_VecPosPtrGet(fsys->player), fsys->camera_ptr);
}

//-----------------------------------------------------------------------------
/**
* @brief 3:WvAKiAj[VlA@̏ʒuύX
*	
* @param	fsys	tB[hVXe|C^
*
* @return	none
*/
//-----------------------------------------------------------------------------
static void SetStairsIOPos(FIELDSYS_WORK *fsys)
{
	int x,z,dir;
	VecFx32 vec;
	u8 attr;
	//@݂̌āA}bvoʒu獶EPObhꂽꏊɎ@o
	//@̍W,擾
	dir = Player_DirGet( fsys->player );
	Player_VecPosGet( fsys->player, &vec );
	
	x = Player_NowGPosXGet( fsys->player );
	z = Player_NowGPosZGet( fsys->player );
	
	attr = GetAttributeLSB( fsys, x, z );
	if (MATR_IsRightStairs(attr)){//EKȉꍇ
		vec.x += (FX32_ONE*16);	//EւPObh
		dir = DIR_LEFT;
	}else if(MATR_IsLeftStairs(attr)){	//Kȉꍇ
		vec.x -= (FX32_ONE*16);	//ւPObh
		dir = DIR_RIGHT;
	}else{
		//GF_ASSERT(0&&"KiAgr[g͂Ă܂");
		OS_Printf("KiAgr[g͂Ă܂\n");
	}
	
	//擾
	vec.y = GetHeightPack(	fsys, vec.y, vec.x, vec.z, NULL);
	//WZbg
	Player_VecPosInit( fsys->player, &vec, dir );
	//@Wړ̂ŃoChȂ
	GFC_ReSetCameraTarget(Player_VecPosPtrGet(fsys->player), fsys->camera_ptr);
	GFC_BindCameraTarget(Player_VecPosPtrGet(fsys->player), fsys->camera_ptr);
}

