//============================================================================================
/**
 * @file	map_tool.c
 * @bfief	tB[h}bvc[
 * @author	Nozomu Saitou
 *
 */
//============================================================================================
#include "map_tool.h"
#include "worldmap.h"
#include "div_map.h"
#include "fieldsys.h"
#include "field_gimmick.h"

#include "fielddata/mapattr/map_attr.h"

#include "debug_saito.h"

#define HIT_ATTR_MASK	(0x1)
#define LSB_MASK		(0xff)

#define MOVE_HEIGHT_DEF	(20*FX32_ONE)	//20jbg (1.5Obh24jbgƁA덷oƂɑΉ̂ŁA؂l߂܂)
//static BOOL GetGroundMapHeight(FIELDSYS_WORK *fsys, VecFx32 *ioPos);
//static BOOL GetUnderMapHeight(FIELDSYS_WORK *fsys, VecFx32 *ioPos);
static const fx32 GetGroundMapHeight(	const FIELDSYS_WORK *fsys,
										const fx32 inNowHeight, const fx32 inX, const fx32 inZ,
										u8 *outCode);
static const fx32 GetUnderMapHeight(	const FIELDSYS_WORK *fsys,
										const fx32 inNowHeight, const fx32 inX, const fx32 inZ,
										u8 *outCode);
static BOOL GetGroundAttribute(const FIELDSYS_WORK *fsys, const int inX, const int inZ, u16 *outAttr);
static BOOL GetUnderAttribute(const FIELDSYS_WORK *fsys, const int inX, const int inZ, u16 *outAttr);
static int CheckHeightMove(	const FIELDSYS_WORK *fsys,
							const VecFx32 *inVec,
							const int inGridX,
							const int inGridZ,
							u8 *outCode);

//typedef BOOL (*GET_HEIGHT_FUNC)(FIELDSYS_WORK *fsys, VecFx32 *ioPos);
typedef const fx32 (*GET_HEIGHT_FUNC)(	const FIELDSYS_WORK *fsys,
										const fx32 inNowHeight, const fx32 inX, const fx32 inZ,
										u8 *outCode);
typedef BOOL (*GET_ATTR_FUNC)(const FIELDSYS_WORK *fsys, const int inX, const int inZ, u16 *outAttr);

typedef struct MAP_TOOL_LIST_tag
{
	GET_HEIGHT_FUNC	GetHeightFunc;
	GET_ATTR_FUNC	GetAttributeFunc;
}MAP_TOOL_LIST;

static const MAP_TOOL_LIST GroundMapToolList =
{
	GetGroundMapHeight,
	GetGroundAttribute
};

static const MAP_TOOL_LIST UnderMapToolList =
{
	GetUnderMapHeight,
	GetUnderAttribute
};

//==============================================================================
/**
 * 2̒l̍Ԃ(l)
 *
 * @param   inVal1	l1
 * @param	inVal2	l2
 *
 * @retval  fx32	l
 */
//==============================================================================
static fx32 GetSubVal(const fx32 inVal1, const fx32 inVal2)
{
	fx32 val;
	if (inVal1 >=inVal2){
		val = inVal1 - inVal2;
	}else{
		val = inVal2 - inVal1;
	}

	return val;
}

//==============================================================================
/**
 * n㍂擾
 *
 * @param   fsys		tB[hVXe|C^
 * @param	inNowHeight	ݍ
 * @param	inX			wW
 * @param	inZ			yW
 * @param	outCode		^CviʏEgj
 *
 * @retval  fx32		擾
 */
//==============================================================================
static const fx32 GetGroundMapHeight(	const FIELDSYS_WORK *fsys,
										const fx32 inNowHeight, const fx32 inX, const fx32 inZ,
										u8 *outCode)
{
	BOOL ex_rc,normal_rc;
	u8 code;
	u32	grid_x,grid_z;
	u32 block_x,block_z;
	u32 block_index;
	u32 local_index;

	u32 grid_no;
	u8 pos_in_block;
	
	VecFx32 target;

	fx32 x_ofs,z_ofs;
	u8 index;

	fx32 height;

	ex_rc = FALSE;
	normal_rc = FALSE;
	
	height = 0;
	target.x =inX;
	target.z =inZ;
	target.y =0;
	
	{
		int map_w;
		int map_grid_w;
		
		DMC_CONST_PTR map_data_ptr = (DMC_CONST_PTR)fsys->map_cont_dat;
		map_w = GetWorldMapMatrixW(fsys->World);
		map_grid_w = map_w*BLOCK_GRID_W;
		
		//݃ubNvZ
		grid_x = inX/(16*FX32_ONE);
		grid_z = inZ/(16*FX32_ONE);

		//gf[^𒲂ׂ
		ex_rc = EXH_HitCheckExHeight(grid_x, grid_z, fsys->ExHeightList, &index);

		block_x = grid_x / BLOCK_GRID_W;
		block_z = grid_z / BLOCK_GRID_H;
		block_index = block_x+block_z*map_w;
	
		//@WɃubNItZbgZ
		x_ofs = ((block_x*BLOCK_GRID_W)+(BLOCK_GRID_W/2))*16*FX32_ONE;
		z_ofs = ((block_z*BLOCK_GRID_H)+(BLOCK_GRID_H/2))*16*FX32_ONE;
		target.x = inX - x_ofs;
		target.z = inZ - z_ofs;
	
		grid_no = grid_x+grid_z*map_grid_w;
		pos_in_block = CalcPositionInBlockFromGridNo(grid_no,map_grid_w);
		local_index = CalcLocalIdxFromBlockIdx(block_index,pos_in_block,map_data_ptr);
		if (local_index>3){
			normal_rc = FALSE;
		}else{
			//擾
			{
				MHI_CONST_PTR  height_info = GetDivMapHeightInfo(map_data_ptr,local_index);
				///OS_Printf_saitou("local_idx=%d\n",local_index);
				normal_rc = GetHeightForBlock(inNowHeight, target.x, target.z, height_info, &target.y);
			}
		}
	}

	if (ex_rc){
		fx32 ex_height;
		//gf[^擾
		ex_height = EXH_GetExHeight(index, fsys->ExHeightList);
		if (normal_rc){
			OS_Printf_saitou("local_print ex_nor=%x,%x\n",ex_height,target.y);
			//ǂ̗p邩`FbN
			//ق𒲂ׂ
			if (ex_height<=target.y){
				//ʏ̕ꍇ̗͂p
///				rc = TRUE;
///				ioPos->y = target.y;
				code = HEIGHT_NORMAL;
				height = target.y;
			}else{
				fx32 sub1,sub2;
				OS_Printf_saitou("local_print ex,target,now=%x,%x,%x\n",ex_height,target.y,height);
				//g̕ꍇ͎w荂ɋ߂ق̗p
				sub1 = GetSubVal(target.y, inNowHeight);	//ʏ퍂ƌݒl̍
				sub2 = GetSubVal(ex_height, inNowHeight);	//gƌݒl̍
				OS_Printf_saitou("local_print %x,%x\n",sub1,sub2);
				if (sub1 <= sub2){
					//ʏ퍂̗p
///					ioPos->y = target.y;
					height = target.y;
					code = HEIGHT_NORMAL;
				}else{
					//g̗p
				OS_Printf_saitou("local_print g̗p\n");
///					ioPos->y = ex_height;
					height = ex_height;
					code = HEIGHT_EXPAND;
				}
///				rc = TRUE;
			}
		}else{
			//gf[^݂̂Ƀqbg
///			rc = TRUE;
///			ioPos->y = ex_height;
			code = HEIGHT_EXPAND;
			height = ex_height;
		}
	}else{
		if (normal_rc){
///			rc = TRUE;
///			ioPos->y = target.y;
			code = HEIGHT_NORMAL;
			height = target.y;
		}else{
///			rc = FALSE;
			code = HEIGHT_FAIL;
		}
	}
	
///	return rc;
	if (outCode != NULL){
		*outCode = code;
	}
	return height;
}

//==============================================================================
/**
 * n擾
 *
 * @param   fsys		tB[hVXe|C^
 * @param	inNowHeight	ݍ
 * @param	inX			wW
 * @param	inZ			yW
 * @param	outCode		^CviʏEgj
 *
 * @retval  fx32		擾
 */
//==============================================================================
static const fx32 GetUnderMapHeight(	const FIELDSYS_WORK *fsys,
										const fx32 inNowHeight, const fx32 inX, const fx32 inZ,
										u8 *outCode)
{
	BOOL rc;
	int grid_x,grid_z;
	fx32 height;
	u8 code;
	
	//Obhɕϊ
	grid_x = inX / (16*FX32_ONE);
	grid_z = inZ / (16*FX32_ONE);

	rc = CheckFourBlockIO(	fsys->map_cont_dat,
							grid_x,
							grid_z,
							NULL);
	if (rc){
		code = HEIGHT_NORMAL;
	}else{
		code = HEIGHT_FAIL;
	}

	if (outCode != NULL){
		*outCode = code;
	}
	
	//͂OZbg
	height = 0;
	return height;
}

//==============================================================================
/**
 * nAgr[g擾
 *
 * @param   fsys		tB[hVXe|C^
 * @param	inX			ObhXW
 * @param	inZ			ObhZW
 * @param	outAttr		Agr[g
 *
 * @retval  BOOL		TRUE:擾		FALSE:擾s
 */
//==============================================================================
static BOOL GetGroundAttribute(const FIELDSYS_WORK *fsys, const int inX, const int inZ, u16 *outAttr)
{
	BOOL rc;
	u32 block_x,block_z;
	u32 block_index;
	u8 local_index;

	u32 grid_no;
	u8 pos_in_block;

	{
		BOOL rc;
		DMC_CONST_PTR map_data_ptr = fsys->map_cont_dat;
		rc = CheckFourBlockIO(	map_data_ptr,
								inX,
								inZ,
								&local_index);
		if (rc == FALSE){
			(*outAttr) = MATTR_NO_ATTR;
			return FALSE;
		}
/**		
		int map_w;
		int map_grid_w;
		DMC_CONST_PTR map_data_ptr = fsys->map_cont_dat;
		map_w = GetWorldMapAreaW(fsys->world);
		map_grid_w = map_w*BLOCK_GRID_W;
		block_x = inX / BLOCK_GRID_W;
		block_z = inZ / BLOCK_GRID_H;

		block_index = block_x+block_z*map_w;
	
		grid_no = inX+inZ*map_grid_w;
		pos_in_block = CalcPositionInBlockFromGridNo(grid_no,map_grid_w);
		local_index = CalcLocalIdxFromBlockIdx(block_index,pos_in_block,map_data_ptr);
		if (local_index>3){
			return FALSE;
		}
*/
		{
			u32 local_grid_index;	//0`1023
			u16 const *attribute;
			local_grid_index = (inZ % BLOCK_GRID_H)*BLOCK_GRID_W+(inX % BLOCK_GRID_W);
			
			//OS_Printf_saitou("local_grid_index = %d\n",local_grid_index);
			//Agr[g擾
			attribute = GetDivMapAttribute(map_data_ptr, local_index);
			*outAttr = attribute[local_grid_index];
			return TRUE;
		}
	}
}

//==============================================================================
/**
 * nAgr[g擾
 *
 * @param   fsys		tB[hVXe|C^
 * @param	inX			ObhXW
 * @param	inZ			ObhZW
 * @param	outAttr		Agr[g
 *
 * @retval  BOOL	KTRUE܂
 */
//==============================================================================
static BOOL GetUnderAttribute(const FIELDSYS_WORK *fsys, const int inX, const int inZ, u16 *outAttr)
{
	BOOL rc;
	u32 block_x,block_z;
	u32 block_index;
	u32 local_index;

	u32 grid_no;
	u8 pos_in_block;

	//u8 under_index;

	{
		int map_w;
		int map_grid_w;
		DMC_CONST_PTR map_data_ptr = fsys->map_cont_dat;
		map_w = GetWorldMapMatrixW(fsys->World);
		map_grid_w = map_w*BLOCK_GRID_W;
		block_x = inX / BLOCK_GRID_W;
		block_z = inZ / BLOCK_GRID_H;

		block_index = block_x+block_z*map_w;
	
		//grid_no = inX+inZ*map_grid_w;

		//fsysɂԂ牺n}bsOf[^i3030jɃObhio[𓊂āBO`PX̑ΉCfbNX炤
		//under_index = fsys->under_map[grid_no];
		{
			u32 local_grid_index;	//0`1023
			u16 const *block_attr;
			local_grid_index = (inZ % BLOCK_GRID_H)*BLOCK_GRID_W+(inX % BLOCK_GRID_W);
			///OS_Printf_saitou("local_=%d",local_grid_index);
			///block_attr = (u16 const *)&(fsys->GroundAttr[BLOCK_ATTR_SIZE*under_index]);
			block_attr = SPATTR_GetSpBlockAttribute(block_index, fsys->SpMatData);
			*outAttr = block_attr[local_grid_index];
			return TRUE;
		}
	}
}

//==============================================================================
/**
 * }bvc[Xg̃Zbg
 *
 * @param   outMapToolList	}bvc[Xg|C^
 * @param	inMapMode		}bv[h
 *
 * @retval  none
 */
//==============================================================================
void SetUpMapToolList(MTL_CONST_PTR *outMapToolList, MAP_TOOL_MODE inMapMode)
{
	if (inMapMode == MAP_TOOL_MODE_GROUND){
		*outMapToolList = &GroundMapToolList;
	}else if (inMapMode == MAP_TOOL_MODE_UNDER){
		*outMapToolList = &UnderMapToolList;
	}else{
		GF_ASSERT( 0 && "Mapmode unknown " );
	}
}

//==============================================================================
/**
 * 茟o
 *
 * @param   fsys	tB[hVXe|C^
 * @param	inX	ObhXW
 * @param	inZ	ObhZW
 *
 * @retval  BOOL	TRUE:is	FALSE:i
 */
//==============================================================================
BOOL GetHitAttr(const FIELDSYS_WORK *fsys, const int inX, const int inZ)
{
	BOOL rc;
	u16 attribute;
	rc = fsys->map_tool_list->GetAttributeFunc(fsys, inX, inZ, &attribute);
	
	if(rc){
		u8 atr;
		
		atr = (u8)(attribute>>15);
		atr &= HIT_ATTR_MASK;
///		OS_Printf_saitou("idx,x,y,atr = %d,%d,%d\n",inX,inZ,atr);
		if (atr == 1){
			return TRUE;
		}
	}
	
	return FALSE;
}

//==============================================================================
/**
 * Agr[g擾(2oCg)
 *
 * @param	*fsys	tB[hVXe|C^
 * @param	inX		XObhW
 * @param	inZ		ZObhW
 *
 * @return	attrbute	Agr[g@s̏ꍇ0Ԃ
 */
//==============================================================================
u16 GetAttribute(const FIELDSYS_WORK *fsys, const int inX, const int inZ)
{
	BOOL rc;
	u16 attribute;
	rc = fsys->map_tool_list->GetAttributeFunc(fsys, inX, inZ, &attribute);
	
	if(rc){
		return attribute;
	}
	//擾s
	return 0;
}

//==============================================================================
/**
 * Agr[g擾(1oCg)
 *
 * @param	*fsys	tB[hVXe|C^
 * @param	inX		XObhW
 * @param	inZ		ZObhW
 *
 * @return	attrbute	Agr[g@s̏ꍇ0Ԃ
 */
//==============================================================================
MATR GetAttributeLSB(const FIELDSYS_WORK *fsys, const int inX, const int inZ)
{
	BOOL rc;
	u16 attribute;

	rc = fsys->map_tool_list->GetAttributeFunc(fsys, inX, inZ, &attribute);
	
	if(rc){
		u8 atr;
		atr = attribute;
		atr &= LSB_MASK;
		return atr;
	}
	//擾s
	return MATTR_NO_ATTR;
}

//==============================================================================
/**
 * Agr[g擾(1oCg)
 *
 * @param	*fsys	tB[hVXe|C^
 * @param	inX		XObhW
 * @param	inZ		ZObhW
 *
 * @return	attrbute	Agr[g@s̏ꍇ0Ԃ
 */
//==============================================================================
u8 GetAttributeHSB(const FIELDSYS_WORK *fsys, const int inX, const int inZ)
{
	BOOL rc;
	u16 attribute;
	rc = fsys->map_tool_list->GetAttributeFunc(fsys, inX, inZ, &attribute);
	
	if(rc){
		u8 atr;
		atr = (u8)(attribute>>15);
		atr &= LSB_MASK;
		return atr;
	}
	//擾s
	return 0;
}



//==============================================================================
/**
 * 擾
 *
 * @param	fsys			tB[hVXe|C^	
 * @param	inNowHeight		ݍ
 * @param	inX				wW
 * @param	inZ				yW
 * @param	outCode			^Cv(ʏEg)
 *
 * @return	fx32	擾
 */
//==============================================================================
const fx32 GetHeightPack(	const FIELDSYS_WORK *fsys,
							const fx32 inNowHeight, const fx32 inX, const fx32 inZ,
							HEIGHT_TYPE *outCode)
{
	BOOL rc;
	fx32 height;
	height = fsys->map_tool_list->GetHeightFunc(fsys, inNowHeight, inX, inZ, outCode);
	//OS_Printf_saitou("GetHeight=%x:%x,%x\n",height,inX,inZ);	
	return height;
}
#if 0
//==============================================================================
/**
 * 擾
 *
 * @param	*ioHeroPoint	@W
 *
 * @return	none
 */
//==============================================================================
BOOL GetHeightPack_old(	FIELDSYS_WORK *fsys, VecFx32 *ioVec)
{
	BOOL rc;
	HEIGHT_TYPE code;
	ioVec->y = fsys->map_tool_list->GetHeightFunc(fsys, ioVec->y, ioVec->x, ioVec->z, &code);
	if (code != HEIGHT_FAIL){
		return TRUE;
	}else{
		return FALSE;
	}
}
#endif
#if 0
//==============================================================================
/**
 * 擾
 *
 * @param	*ioHeroPoint	@W
 *
 * @return	none
 */
//==============================================================================
const fx32 GetHeightPackEx(	FIELDSYS_WORK *fsys,
									const fx32 inNowY, const fx32 inX, const fx32 inZ,
									u8 *outCode)
{
	u8 code;
	fx32 return_height;
	fx32 height;
	
	height = fsys->map_tool_list->GetHeightFunc(fsys, inNowY, inX, inZ, outCode);
	
	{
		fx32 ex_height;
		BOOL ex_rc;
		u8 index;
		u32	grid_x,grid_z;
		//݃ubNvZ
		grid_x = inX/(16*FX32_ONE);
		grid_z = inZ/(16*FX32_ONE);
		
		//gf[^𒲂ׂ
		ex_rc = EXH_HitCheckExHeight(grid_x, grid_z, fsys->ExHeightList, &index);

		if (ex_rc){
			//gf[^擾
			ex_height = EXH_GetExHeight(index, fsys->ExHeightList);
			OS_Printf_saitou("local_print ex_nor=%x,%x\n",ex_height,height);
			//ǂ̗p邩`FbN
			//ق𒲂ׂ
			if (ex_height<=height){
				//ʏ̕ꍇ̗͂p
				code = HEIGHT_NORMAL;
				return_height = height;
			}else{
				fx32 sub1,sub2;
				OS_Printf_saitou("local_print ex,target,now=%x,%x,%x\n",ex_height,height,inNowY);
				//g̕ꍇ͎w荂ɋ߂ق̗p
				sub1 = GetSubVal(height, inNowY);	//ʏ퍂ƌݒl̍
				sub2 = GetSubVal(ex_height, inNowY);	//gƌݒl̍
				OS_Printf_saitou("local_print %x,%x\n",sub1,sub2);
				if (sub1 <= sub2){
					//ʏ퍂̗p
					return_height = height;
					code = HEIGHT_NORMAL;
				}else{
					//g̗p
				OS_Printf_saitou("local_print g̗p\n");
					return_height = ex_height;
					code = HEIGHT_EXPAND;
				}
			}
		}else{
			//gf[^݂̂Ƀqbg
			code = HEIGHT_EXPAND;
			return_height = ex_height;
		}
	}
	
	if (outCode != NULL){
		*outCode = code;
	}
	return return_height;
}
#endif
//==============================================================================
/**
 * ݂̍Ǝw̍ił邩𒲂ׂ
 *
 * @param	fsys		tB[hVXe|C^	
 * @param	inVec		ݍW
 * @param	inGridX		wObhWX
 * @param	inGridZ		wObhWZ
 * @param	outCode		ǂ̍f[^Ƀqbg̃`FbNpiʏAgAȂj
 *
 * @return	1:	-1:Ⴂ		0:
 */
//==============================================================================
static int CheckHeightMove(	const FIELDSYS_WORK *fsys,
							const VecFx32 *inVec, const int inGridX, const int inGridZ,
							HEIGHT_TYPE *outCode)
{
	int rc;
	fx32 y_high,y_low;
	
	fx32 x,z;
	fx32 height;
	
	//wObh̍擾
	//ObhFX32^ɂ(Obh̒SW)
	x = inGridX * 16 * FX32_ONE+(8*FX32_ONE);
	z = inGridZ * 16 * FX32_ONE+(8*FX32_ONE);
	height = 0;

	height = GetHeightPack(fsys, inVec->y, x, z, outCode);
#if 0
	{
		VecFx32 vec;
		OS_Printf_saitou("check_height=%x,%x\n",height,inVec->y);
		Player_VecPosGet( fsys->player, &vec );
		OS_Printf_saitou("player=%x,%x,%x\n",vec.x,vec.y,vec.z);
		OS_Printf_saitou("target=%x,%x,%x\n",x,height,z);
	}
#endif
	//݂̍Ɣr
	if(height < inVec->y){		//wObĥقႢ
		y_high = inVec->y;
		y_low = height;
		rc = HIT_RES_TOO_LOW;
	}else if(height > inVec->y){	//wObĥق
		y_high = height;
		y_low = inVec->y;
		rc = HIT_RES_TOO_HEIGH;
	}else{							//
		rc = HIT_RES_EQUAL;
		return rc;
	}

	//iƂ݂Ȃ邩𔻒
	if (y_high-y_low >= MOVE_HEIGHT_DEF){
		GF_ASSERT(rc!=0 && "߂ls");
		//KlȊOȂ̂ŁAiƂ݂Ȃ
	}else{
		rc = HIT_RES_EQUAL;			//KlȓȂ̂ŁAiƂ݂͂ȂȂ
	}
	
	return rc;
}

//==============================================================================
/**
 * qbg
 *
 * @param	fsys		tB[hVXe|C^	
 * @param	inVec		ݍW
 * @param	inGridX		wObhWX
 * @param	inGridZ		wObhWZ
 * @param	outFlg		茋ʂi[obt@
 *
 * @return	BOOL	TRUE:is@FALSE:i
 */
//==============================================================================
BOOL MPTL_CheckHitWall(	const FIELDSYS_WORK *fsys,
						const VecFx32 *inVec,
						const int inGridX,
						const int inGridZ,
						s8 *outFlg)
{	
	int check;
	HEIGHT_TYPE code;
	check = CheckHeightMove(fsys, inVec, inGridX, inGridZ, &code);
	if (outFlg != NULL){
		*outFlg = check;
	}
		
	if (check == HIT_RES_EQUAL){
		BOOL hit;
		//i\Ȃ΁AAgr[gɂqbgs
		hit = GetHitAttr(fsys, inGridX, inGridZ);
		if ((!hit)&&(code==HEIGHT_EXPAND)){
			//Agr[gqbgłi\AAgf[^擾ꍇ
			//ȂȂ`FbNs
			MATR attr = GetAttributeLSB( fsys, inGridX, inGridZ );
			if (MATR_IsWaterNoIn(attr)){	//gŁAȂȂAgr[ĝƂ
				return TRUE;//is
			}
		}
		return hit;
	}else{
		return TRUE;		//ABis
	}
}

//==============================================================================
/**
 * qbg@O蔻s
 *
 * @param	fsys		tB[hVXe|C^	
 * @param	inVec		ݍW
 * @param	inGridX		wObhWX
 * @param	inGridZ		wObhWZ
 * @param	outFlg		茋ʂi[obt@
 *
 * @return	BOOL	TRUE:is@FALSE:i
 */
//==============================================================================
BOOL MPTL_CheckHitWallEx(	FIELDSYS_WORK *fsys,
							const VecFx32 *inVec,
							const int inGridX,
							const int inGridZ,
							s8 *outFlg)
{	
	int check;
	HEIGHT_TYPE code;
	check = CheckHeightMove(fsys, inVec, inGridX, inGridZ, &code);
	if (outFlg != NULL){
		*outFlg = check;
	}
		
	//i\Ȃ΁AAgr[gɂqbgs
	if (check == HIT_RES_EQUAL){
		BOOL hit;
		BOOL ex_rc;
		//n߂ɊO蔻s
		ex_rc = FLDGMK_FieldGimmickHitCheck(fsys, inGridX, inGridZ,
											inVec->y, &hit);
		//O蔻sȂƂ̂ݒʏ픻Ɉڍs
		if (!ex_rc){	
			hit = GetHitAttr(fsys, inGridX, inGridZ);
			if ((!hit)&&(code==HEIGHT_EXPAND)){
				//Agr[gqbgłi\AAgf[^擾ꍇ
				//ȂȂ`FbNs
				MATR attr = GetAttributeLSB( fsys, inGridX, inGridZ );
				if (MATR_IsWaterNoIn(attr)){	//gŁAȂȂAgr[ĝƂ
					return TRUE;//is
				}
			}
			return hit;
		}else{
			return hit;
		}
	}else{
		return TRUE;		//ABis
	}
}


//==============================================================================
/**
 * wObhW̏UObh̋`̍AEWZo
 *
 * @param	inGridX		wObhXW
 * @param	inGridZ		wObhZW
 * @param	inDir		
 * @param	outRect		`f[^
 *
 * @return	none
 */
//==============================================================================
void MPTL_GetTargetRect(const int inGridX, const int inGridZ,
						const int inDir, TARGET_RECT *outRect )
{
	int grid_x1,grid_z1,grid_x2,grid_z2;
///	switch(inDir){
///	case 0:					//
		//ΏۍObh
		grid_x1 = inGridX-1;
		grid_z1 = inGridZ-2;
		//ΏۉEObh
		grid_x2 = inGridX+1;
		grid_z2 = inGridZ;
///		break;
///	default:
///		break;
///	}

	if (grid_x1<0 || grid_z1<0 || grid_x2<0 || grid_z2<0){
		GF_ASSERT(0&&"ERROR:Obhl}CiX");
	}
	//Obhfx32^ɕύX
	outRect->X1 = grid_x1*16*FX32_ONE;
	outRect->Z1 = grid_z1*16*FX32_ONE;
	outRect->X2 = (grid_x2+1)*16*FX32_ONE;
	outRect->Z2 = (grid_z2+1)*16*FX32_ONE;
}

//==============================================================================
/**
 * wObhW_ƂāA`쐬
 *
 * @param	inGridX		wObhXW
 * @param	inGridZ		wObhZW
 * @param	inOfsX		_̃ItZbg@`XWiJnj
 * @param	inOfsZ		_̃ItZbg@`ZWiJnj
 * @param	inW			`
 * @param	inH			`c
 * @param	outRect		`f[^
 *
 * @return	none
 */
//==============================================================================
void MPTL_MakeTargetRect(	const int inGridX,const int inGridZ, 
							const int inOfsX, const inOfsZ,
							const u32 inW, const u32 inH,
							TARGET_RECT *outRect )
{
	int grid_x1,grid_z1,grid_x2,grid_z2;
	//ΏۍObh
	grid_x1 = inGridX+inOfsX;
	grid_z1 = inGridZ+inOfsZ;
	//ΏۉEObh
	grid_x2 = grid_x1+inW;
	grid_z2 = grid_z1+inH;

	if (grid_x1<0 || grid_z1<0 || grid_x2<0 || grid_z2<0){
		GF_ASSERT(0&&"ERROR:Obhl}CiX");
	}
	//Obhfx32^ɕύX
	outRect->X1 = grid_x1*16*FX32_ONE;
	outRect->Z1 = grid_z1*16*FX32_ONE;
	outRect->X2 = grid_x2*16*FX32_ONE;
	outRect->Z2 = grid_z2*16*FX32_ONE;
}

//==============================================================================
/**
 * wnaif[^̍WƁA`r
 *
 * @param	inObjPtr	3DIuWFNgf[^
 * @param	inRect		`f[^
 * @param	inTrans		ItZbg
 *
 * @return	BOOL	TRUE:HIT@FALSE:NO HIT
 */
//==============================================================================
BOOL MPTL_Check3DObjIO(	const M3DO_CONST_PTR inObjPtr,
						const TARGET_RECT *inRect,
						const VecFx32 *inTrans)
{
	VecFx32 vec;
	
	vec = M3DO_GetGlobalVec(inObjPtr);
	vec.x += inTrans->x;
	vec.z += inTrans->z;
	if ( (inRect->X1<=vec.x) && (vec.x<=inRect->X2) &&
			(inRect->Z1<=vec.z) && (vec.z<=inRect->Z2) ){
		return TRUE;
	}
	return FALSE;
}

//==============================================================================
/**
 * w`ɎwOBJ邩𔻒
 *
 * @param fsys				tB[hVXe|C^
 * @param inTargetObjID		OBJID
 * @param inRect			`
 * @param outObjData		qbgOBJiNULLj	
 *
 * @return	BOOL	TRUE:HIT@FALSE:NO HIT
 */
//==============================================================================
BOOL MPTL_CheckMap3DObjInRect(	const FIELDSYS_WORK *fsys,
								const int inTargetObjID,
								const TARGET_RECT *inRect,
								M3DO_PTR *outObjData)
{
	u8 idx;
	M3DOL_PTR obj_data_list;

	for(idx=0;idx<4;idx++){
	
	//[JCfbNX擾
//	idx = GetNowLocalIndex(fsys->map_cont_dat);
		//naiXg擾
		Get3DObjListFromLocalIdx(idx, fsys->map_cont_dat, &obj_data_list);
		//`
		{
			u8 i;
			VecFx32 trans;
			int block_idx;
			int map_w;
			BOOL rc;
			//block_idx = GetNowBlockIndex(fsys->map_cont_dat);
			block_idx = GetBlockIndexFromLocalIndex(fsys->map_cont_dat, idx);
			map_w = GetWorldMapMatrixW(fsys->World);
		
			MPTL_CalcMapOffset(block_idx, map_w, &trans);
			for(i=0;i<MAP_READ_OBJ_3D_MAX;i++){
				M3DO_PTR ptr;
				ptr = M3DO_GetMap3DObjData(obj_data_list, i);
				rc = MPTL_Check3DObjIO(	ptr,
										inRect,
										&trans);
				if (rc){
					int id;
					id = M3DO_GetObjID(ptr);
					if (id == inTargetObjID){
						if (outObjData != NULL)
						{
							*outObjData = ptr;
						}
						return TRUE;
					}
				}
			}//end for
		}
	}//end for
	return FALSE;
}

//==============================================================================
/**
 * w`ɕwOBJ邩𔻒
 *
 * @param fsys				tB[hVXe|C^
 * @param inTargetObjIDList	OBJIDXg
 * @param inListNum			Xgvf
 * @param inRect			`
 * @param outObjData		qbgOBJ	(NULLj
 * @param outObjID			qbgOBJ̊i[ꏊiNULLj
 * 
 * @return	BOOL	TRUE:HIT@FALSE:NO HIT
 */
//==============================================================================
BOOL MPTL_CheckPluralMap3DObjInRect(	const FIELDSYS_WORK *fsys,
										const int* inTargetObjIDList,
										const u8 inListNum,
										const TARGET_RECT *inRect,
										M3DO_PTR *outObjData,
										int *outObjID)
{
	u8 idx;
	M3DOL_PTR obj_data_list;

	for(idx=0;idx<4;idx++){
	
///	//[JCfbNX擾
///	idx = GetNowLocalIndex(fsys->map_cont_dat);
		//naiXg擾
		Get3DObjListFromLocalIdx(idx, fsys->map_cont_dat, &obj_data_list);
		//`
		{
			u8 i;
			VecFx32 trans;
			int block_idx;
			int map_w;
			BOOL rc;
			//block_idx = GetNowBlockIndex(fsys->map_cont_dat);
			block_idx = GetBlockIndexFromLocalIndex(fsys->map_cont_dat, idx);
			map_w = GetWorldMapMatrixW(fsys->World);
		
			MPTL_CalcMapOffset(block_idx, map_w, &trans);
			for(i=0;i<MAP_READ_OBJ_3D_MAX;i++){
				M3DO_PTR ptr;
				ptr = M3DO_GetMap3DObjData(obj_data_list, i);
				rc = MPTL_Check3DObjIO(	ptr,
										inRect,
										&trans);
				if (rc){
					u8 j;
					int id;
					id = M3DO_GetObjID(ptr);
					for(j=0;j<inListNum;j++){
						if (id == inTargetObjIDList[j]){
							if (outObjData != NULL){
								(*outObjData) = ptr;
							}
							if (outObjID != NULL){
								*outObjID = id;
							}
							return TRUE;
						}
					}
				}
			}//end for
		}
	}//end for
	return FALSE;
}

//==============================================================================
/**
 * wOBJ邩𔻒
 * 
 * @param fsys				tB[hVXe|C^
 * @param inTargetObjID		OBJID
 * @param outObjData		Ԏn߂ɃqbgOBJiNULLj
 * @param outBlockIdx		Ԏn߂ɃqbgOBĴubNCfbNXiNULLj
 * 
 * @return	BOOL	TRUE:HIT@FALSE:NO HIT
 */
//==============================================================================
BOOL MPTL_CheckMap3DObj(const FIELDSYS_WORK *fsys,
						const int inTargetObjID,
						M3DO_PTR *outObjData,
						int *outBlockIdx)
{
	u8 idx;
	M3DOL_PTR obj_data_list;

	for(idx=0;idx<4;idx++){
		//naiXg擾
		Get3DObjListFromLocalIdx(idx, fsys->map_cont_dat, &obj_data_list);
		{
			u8 i;
			for(i=0;i<MAP_READ_OBJ_3D_MAX;i++){
				M3DO_PTR ptr;
				ptr = M3DO_GetMap3DObjData(obj_data_list, i);
				{
					u8 j;
					int id;
					id = M3DO_GetObjID(ptr);
					if (id == inTargetObjID){
						if (outObjData != NULL){
							(*outObjData) = ptr;
						}
						if (outBlockIdx != NULL){
							(*outBlockIdx) = 
								GetBlockIndexFromLocalIndex(fsys->map_cont_dat, idx);
						}
						return TRUE;
					}
				}
			}//end for
		}
	}//end for
	return FALSE;
}

//==============================================================================
/**
 * wOBJ邩𔻒
 *
 * @param fsys				tB[hVXe|C^
 * @param inTargetObjIDList	OBJIDXg
 * @param inListNum			Xgvf
 * @param outObjData		qbgOBJ	(NULLj
 * @param outObjID			qbgOBJ̊i[ꏊiNULLj
 * 
 * @return	BOOL	TRUE:HIT@FALSE:NO HIT
 */
//==============================================================================
BOOL MPTL_CheckPluralMap3DObj(	const FIELDSYS_WORK *fsys,
								const int* inTargetObjIDList,
								const u8 inListNum,
								M3DO_PTR *outObjData,
								int *outObjID)
{
	u8 idx;
	M3DOL_PTR obj_data_list;

	for(idx=0;idx<4;idx++){
		//naiXg擾
		Get3DObjListFromLocalIdx(idx, fsys->map_cont_dat, &obj_data_list);
		{
			u8 i;
			for(i=0;i<MAP_READ_OBJ_3D_MAX;i++){
				M3DO_PTR ptr;
				ptr = M3DO_GetMap3DObjData(obj_data_list, i);
				{
					u8 j;
					int id;
					id = M3DO_GetObjID(ptr);
					for(j=0;j<inListNum;j++){
						if (id == inTargetObjIDList[j]){
							if (outObjData != NULL){
								(*outObjData) = ptr;
							}
							if (outObjID != NULL){
								*outObjID = id;
							}
							return TRUE;
						}
					}
				}
			}//end for
		}
	}//end for
	return FALSE;
}

//==============================================================================
/**
 * ubNCfbNXn`ItZbgvZ
 *
 * @param   inBlockIndex	ubNCfbNX
 * @param   inMapW			}bv
 * @param   outTrans		擾W
 *
 * @return	none
 */
//==============================================================================
void MPTL_CalcMapOffset(const int inBlockIndex,
						const int inMapW,
						VecFx32 *outTrans)
{
	u16 x_ofs;
	u16 z_ofs;
	outTrans->x = (BLOCK_GRID_W/2)*ONE_GRID_SIZE*FX32_ONE;
	outTrans->z = (BLOCK_GRID_H/2)*ONE_GRID_SIZE*FX32_ONE;	
	x_ofs = inBlockIndex % inMapW;
	z_ofs = inBlockIndex / inMapW;
	outTrans->x += x_ofs*BLOCK_GRID_W*ONE_GRID_SIZE*FX32_ONE;
	outTrans->z += z_ofs*BLOCK_GRID_H*ONE_GRID_SIZE*FX32_ONE;
}
