//============================================================================================
/**
 * @file	mapdata_warp.c
 * @brief	[vpf[^֘A\[X
 * @date	2005.12.19
 */
//============================================================================================

#include "common.h"

#include "fieldsys.h"
#include "field_common.h"
#include "mapdata_warp.h"

#include "mapdefine.h"
#include "fieldobj_code.h"		//DIR_UP DIR_DOWN
#include "ev_mapchange.h"		//DOOR_ID_JUMP_CODE

#include "sysflag.h"			//SysFlag_ArriveSet

//͂̃V{`
#include "../fielddata/warpdata/warpdata.h"

//============================================================================================
//============================================================================================
//------------------------------------------------------------------
//------------------------------------------------------------------
typedef struct {
	u16 room_id, room_gx, room_gz;
	u16 fld_id, fld_gx, fld_gz;
	u8 IsTeleportPos;
	u8 AutoSetArriveFlag;
	u16 arrive_id;
}WARPDATA;

//͂̃f[^`
#include "../fielddata/warpdata/warpdata.c"


//============================================================================================
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	[vID̐K
 * @param	warp_id		[vID
 * @return	int			K[vID
 *
 * sȒl͕ϊB1IW0IWɕϊB
 */
//------------------------------------------------------------------
static int RegulateWarpID(int warp_id)
{
	if(warp_id <= 0 || warp_id > NELEMS(WarpData)) {
		GF_ASSERT_MSG(0, "sȃ[vIDi%djłB\n", warp_id);
		warp_id = 1;		//iłł͕sȒlł삷悤ɕ␳
	}
	warp_id --;		//1 origin --> 0 origin
	return warp_id;
}

//------------------------------------------------------------------
/**
 * @brief	[vID̏l擾
 */
//------------------------------------------------------------------
int WARPDATA_GetInitializeID(void)
{
	return 1;
}

//------------------------------------------------------------------
/**
 * @brief	[vꏊ̎擾
 * @param	warp_id		[vID
 * @param	loc			ꏊ󂯎LOCATION_WORKւ̃|C^
 */
//------------------------------------------------------------------
void WARPDATA_GetWarpLocation(int warp_id, LOCATION_WORK * loc)
{
	warp_id = RegulateWarpID(warp_id);

	loc->zone_id = WarpData[warp_id].fld_id;
	loc->door_id = DOOR_ID_JUMP_CODE;
	loc->grid_x = WarpData[warp_id].fld_gx;
	loc->grid_z = WarpData[warp_id].fld_gz;
	loc->dir = DIR_DOWN;
}

//------------------------------------------------------------------
/**
 * @brief	ꏊ̎擾
 * @param	warp_id		[vID
 * @param	loc			ꏊ󂯎LOCATION_WORKւ̃|C^
 */
//------------------------------------------------------------------
void WARPDATA_GetRevivalLocation(int warp_id, LOCATION_WORK * loc)
{
	warp_id = RegulateWarpID(warp_id);

	loc->zone_id = WarpData[warp_id].room_id;
	loc->door_id = DOOR_ID_JUMP_CODE;
	loc->grid_x = WarpData[warp_id].room_gx;
	loc->grid_z = WarpData[warp_id].room_gz;
	loc->dir = DIR_UP;
}

//------------------------------------------------------------------
/**
 * @brief	[vID̎擾
 * @param	zone_id		鉮̃][ID
 * @retval	int			[vIDiPIWj
 * @retval	0			Ȃ
 */
//------------------------------------------------------------------
int WARPDATA_SearchByRoomID(int zone_id)
{
	int i;
	for (i = 0; i < NELEMS(WarpData); i++) {
		if (WarpData[i].room_id == zone_id
				&& WarpData[i].IsTeleportPos) {
			return i + 1;
		}
	}
	return 0;
}

//------------------------------------------------------------------
/**
 * @brief	[vID̎擾
 * @param	zone_id		tB[h̃][ID
 * @retval	int			[vIDiPIWj
 * @retval	0			Ȃ
 */
//------------------------------------------------------------------
int WARPDATA_SearchByFieldID(int zone_id)
{
	int i;
	for (i = 0; i < NELEMS(WarpData); i++) {
		if (WarpData[i].fld_id == zone_id
				&& WarpData[i].IsTeleportPos) {
			return i + 1;
		}
	}
	return 0;
}

//------------------------------------------------------------------
/**
 * @brief	[vID̎擾iuƂԁvpj
 * @param	zone_id		tB[h̃][ID
 * @param	gx			XʒuiObhPʁj
 * @param	gz			YʒuiObhPʁj
 * @retval	int			[vIDiPIWj
 * @retval	0			Ȃ
 *
 * ][ɓӏuƂԁv̔ѐ悪̂ŁA
 * ^E}bvԂubNPʂ̑Iʒuɂ𔻕
 * ł悤ɂĂB
 */
//------------------------------------------------------------------
int WARPDATA_SearchForFly(int zone_id, int gx, int gz)
{
	int i;
	int blk_x = gx / 32;
	int blk_z = gz / 32;
	int id = 0;
	for (i = 0; i < NELEMS(WarpData); i++) {
		if (WarpData[i].fld_id == zone_id) {
			id = i + 1;
			if (blk_x == WarpData[i].fld_gx / 32 && blk_z == WarpData[i].fld_gz / 32) {
				return id;
			}
		}
	}
	return id;
}

//============================================================================================
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	tÕZbg
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	zone_id		Zbgꏊ̃][ID
 */
//------------------------------------------------------------------
void ARRIVEDATA_SetArriveFlag( FIELDSYS_WORK * fsys, int zone_id)
{
	int i;
	for (i = 0; i < NELEMS(WarpData); i++) {
		if (WarpData[i].fld_id == zone_id && WarpData[i].AutoSetArriveFlag) {
			SysFlag_ArriveSet(SaveData_GetEventWork(fsys->savedata), WarpData[i].arrive_id);
			return;
		}
	}
}

//------------------------------------------------------------------
/**
 * @brief	tOQƂ
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	warp_id		ΏۂƂȂ}bṽ[vID
 * @retval	BOOL		TRUÊƂAƂ
 */
//------------------------------------------------------------------
BOOL ARRIVEDATA_GetArriveFlag(FIELDSYS_WORK * fsys, int warp_id)
{
	int reg_id = RegulateWarpID(warp_id);
	return SysFlag_ArriveGet(SaveData_GetEventWork(fsys->savedata), WarpData[reg_id].arrive_id);
}

