//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		poison_effect.c
 *	@brief		Ŵ̪
 *	@author		tomoya takahashi
 *	@data		2006.04.10
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "common.h"
#include "include/system/laster.h"
#include "include/system/snd_tool.h"

#define	__POISON_EFFECT_H_GLOBAL
#include "poison_effect.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define POISON_COUNT		( 3 )		// 춳

#ifdef PM_DEBUG
static int POISON2_X = (3);	// ̒l炷
static int POISON2_Y = (10);	// ꂢP
void DEBUG_Poison( void );
#else
#define POISON2_X (3)	// ̒l炷
#define POISON2_Y (10)	// ꂢP
#endif
//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	[N	
//=====================================
typedef struct _POISON_EFFECT_WORK{
	u32		status;
	int		count;
	int		seq;
	u16		HblBuff0[ 192 ];
	u16		HblBuff1[ 192 ];
	LASTER_SYS_PTR p_laster;
	FIELD_HBLANK_SYS* p_hblanksys;
	FIELD_HBLANK_OBJ* p_hblank;
	BOOL	HblRef;		// HBLANKŒlݒ肷邩
	TCB_PTR	do_tcb;
	TCB_PTR vblank_tcb;
	TCB_PTR vwaitblank_tcb;
} ;

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void PoisonEffTcb( TCB_PTR tcb, void* p_work );
static void PoisonEffVblankTcb( TCB_PTR tcb, void* p_work );
static void PoisonEffVWaitblankTcb( TCB_PTR tcb, void* p_work );
static void PoisonEffHBlank( POISON_EFFECT_WORK* p_poison );
static void PoisonMakeBuff( u16* buff, int key, int key_max );
static void PoisonEffeHBlankCallBack( FIELD_HBLANK_OBJ* p_obj, void* p_work );
static void POISON_EFFE_HBlank( POISON_EFFECT_WORK* p_poison );
static void POISON_EFFE_VBlank( POISON_EFFECT_WORK* p_poison );
static void PoisonWorkDoEnd( POISON_EFFECT_WORK* p_poison );

//----------------------------------------------------------------------------
/**
 *	@brief	Ŵ̪ă[N쐬
 *
 *	@param	heap	q[v
 *	@param	p_sys	tB[hHuNǗVXe
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
POISON_EFFECT_WORK* POISON_EFFE_Init( u32 heap, FIELD_HBLANK_SYS* p_sys )
{
	POISON_EFFECT_WORK* p_poison;

	p_poison = sys_AllocMemory( heap, sizeof(POISON_EFFECT_WORK) );
	memset( p_poison, 0, sizeof(POISON_EFFECT_WORK) );

	// STANDBY
	p_poison->status = POISON_EFFE_STANDBY;

	// X^[[N쐬
	p_poison->p_laster = LASTER_Init( heap, p_poison->HblBuff0, p_poison->HblBuff1 );

	// HuNVXe[Nێ
	p_poison->p_hblanksys = p_sys;

	return p_poison;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Ŵ̪ă[Nj
 *
 *	@param	p_poison	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void POISON_EFFE_Delete( POISON_EFFECT_WORK* p_poison )
{
	// TCBj
	if( p_poison->status == POISON_EFFE_DO ){
		PoisonWorkDoEnd( p_poison );
	}

	// X^[j
	LASTER_Delete( p_poison->p_laster );

	// j
	sys_FreeMemoryEz( p_poison );
}
//----------------------------------------------------------------------------
/**
 *	@brief	Ŵ̪ăX^[g
 *	
 *	@param	p_poison	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void POISON_EFFE_Start( POISON_EFFECT_WORK* p_poison )
{
	// dĂяo`FbN
	GF_ASSERT( p_poison->status == POISON_EFFE_STANDBY );

	// HuN	
	p_poison->p_hblank = FLDHBLANK_OBJ_Add( p_poison->p_hblanksys, PoisonEffeHBlankCallBack, p_poison );
	
	// ^XNĂяo
	// obt@Ȃf[^^XN
	p_poison->do_tcb = TCB_Add( PoisonEffTcb, p_poison, POISON_TCB_PRI );
	// obt@fXCb`^XN	VuN
	p_poison->vblank_tcb = VIntrTCB_Add( PoisonEffVblankTcb, p_poison, POISON_TCB_PRI );
	//	_uobt@XCb`^XN	VuNԏI
	p_poison->vwaitblank_tcb = VIntrTCB_Add( PoisonEffVWaitblankTcb, p_poison, POISON_TCB_PRI );

	// 
	memset( p_poison->HblBuff0, 0, sizeof(u16) * 192 );
	memset( p_poison->HblBuff1, 0, sizeof(u16) * 192 );
	p_poison->status = POISON_EFFE_DO;
	p_poison->seq = 0;

	// Đ
	Snd_SePlay( SE_POISON );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Ŵ̪ďԎ擾
 *
 *	@param	cp_poison [N
 *
 *	@retval	POISON_EFFE_STANDBY		Jn҂
 *	@retval	POISON_EFFE_DO			s
 */         
//-----------------------------------------------------------------------------
u32 POISON_EFFE_GetStatus( const POISON_EFFECT_WORK* cp_poison )
{
	return cp_poison->status;
}


//----------------------------------------------------------------------------
/**
 *	@brief	^XN[N
 *
 *	@param	tcb		TCBf[^
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PoisonEffTcb( TCB_PTR tcb, void* p_work )
{
	POISON_EFFECT_WORK* data = p_work;
	u16* buff;


	
	switch( data->seq ){
	case 0:		// 
		data->count = POISON_COUNT;
		data->seq++;
		break;

	case 1:		// Z
		data->count --;
		buff = LASTER_GetWriteBuff( data->p_laster );
		PoisonMakeBuff( buff, POISON_COUNT - data->count, POISON_COUNT );
		if( data->count <= 0 ){
			data->count = POISON_COUNT;
			data->seq++;
		}
		break;
	
	case 2:		// Z
		data->count --;
		buff = LASTER_GetWriteBuff( data->p_laster );
		PoisonMakeBuff( buff, data->count, POISON_COUNT );
		if( data->count <= 0 ){
			data->seq++;
		}
		break;

	// I
	case 3:
		PoisonWorkDoEnd( data );
		// BG0ʂHXN[ݒ
		G3X_SetHOffset( 0 );
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	HBlank
 *
 *	@param	p_poison [N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PoisonEffHBlank( POISON_EFFECT_WORK* p_poison )
{
	const u16* cp_buff;
	int count;
	count = GX_GetVCount();
	cp_buff = LASTER_GetReadBuff( p_poison->p_laster );
	if( count < 192 ){
		count++;	// ̍̃f[^ݒ
		if( count >= 192 ){
			count -= 192;
		}
		
		// BG0ʂHXN[ݒ
		if( GX_IsHBlank() ){
			G3X_SetHOffset( cp_buff[ count ] );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	keyɑΉlobt@ɒǉ
 *
 *	@param	buff		obt@
 *	@param	key			L[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PoisonMakeBuff( u16* buff, int key, int key_max )
{
	int i;
	int calc_x;
	BOOL switch_f = TRUE;


	calc_x = POISON2_X * key;
	calc_x = calc_x / key_max;

	for( i=0; i<192; i++ ){

		if( (i % POISON2_Y) == 0 ){
			switch_f ^= 1;
		}

		if( switch_f ){
			buff[ i ] = calc_x;
		}else{
			buff[ i ] = -calc_x;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	VBlankTCB
 *
 *	@param	tcb		TCB[N
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PoisonEffVblankTcb( TCB_PTR tcb, void* p_work )
{
	POISON_EFFECT_WORK* data = p_work;

	// ̎_1񔽉f̂
	// 1VN͔fȂ
	data->HblRef = FALSE;

	// BG0ʂHXN[ݒ
	G3X_SetHOffset( 0 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	HuN
 *
 *	@param	p_obj		HuNIuWFNg
 *	@param	p_work		[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PoisonEffeHBlankCallBack( FIELD_HBLANK_OBJ* p_obj, void* p_work )
{
	POISON_EFFECT_WORK* p_poison = p_work;
	POISON_EFFE_HBlank( p_poison );
}
//----------------------------------------------------------------------------
/**
 *	@brief	HuNԏ
 *
 *	@param	p_poison Ń[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void POISON_EFFE_HBlank( POISON_EFFECT_WORK* p_poison )
{
	if( p_poison->status == POISON_EFFE_DO ){

		// f1VNɂ
		// ۂȂʂ_
		if( p_poison->HblRef == TRUE ){
			PoisonEffHBlank( p_poison );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	VuN҂^XN
 *
 *	@param	tcb		^XN[N
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PoisonEffVWaitblankTcb( TCB_PTR tcb, void* p_work )
{
	POISON_EFFECT_WORK* p_poison = p_work;
	POISON_EFFE_VBlank( p_poison );
}
//----------------------------------------------------------------------------
/**
 *	@brief	VuNԏ
 *
 *	@param	p_poison	Ń[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void POISON_EFFE_VBlank( POISON_EFFECT_WORK* p_poison )
{
	if( p_poison->status == POISON_EFFE_DO ){
		LASTER_VBlank( p_poison->p_laster );
		p_poison->HblRef = TRUE;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	Ŵ̪ĎsԃNA
 *
 *	@param	p_poison	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PoisonWorkDoEnd( POISON_EFFECT_WORK* p_poison )
{
	// HuNj
	FLDHBLANK_OBJ_Delete( p_poison->p_hblank );
	p_poison->p_hblank = NULL;
	
	TCB_Delete( p_poison->do_tcb );
	p_poison->do_tcb = NULL;
	TCB_Delete( p_poison->vblank_tcb );
	p_poison->vblank_tcb = NULL;
	TCB_Delete( p_poison->vwaitblank_tcb );
	p_poison->vwaitblank_tcb = NULL;
	p_poison->status = POISON_EFFE_STANDBY;

}


#ifdef PM_DEBUG
void DEBUG_Poison( void )
{
	if( sys.cont & PAD_BUTTON_R ){
		if( sys.trg & PAD_BUTTON_Y ){
			POISON2_X --;
			OS_Printf( "x %d \n", POISON2_X );
		}else if( sys.trg & PAD_BUTTON_A ){
			POISON2_X ++;
			OS_Printf( "x %d \n", POISON2_X );
		}
	}
	if( sys.cont & PAD_BUTTON_L ){
		if( sys.trg & PAD_BUTTON_Y ){
			POISON2_Y --;
			OS_Printf( "y %d \n", POISON2_Y );
		}else if( sys.trg & PAD_BUTTON_A ){
			POISON2_Y ++;
			OS_Printf( "y %d \n", POISON2_Y );
		}
	}
}
#endif

