//============================================================================================
/**
 * @file	poketch_a10c.c
 * @bfief	|Pb`iAvNo10Fvj@Rg[
 * @author	taya GAME FREAK inc.
 */
//============================================================================================
#include <nitro/sinit.h>
#include "common.h"
#include "system\lib_pack.h"

#include "poketch_a10.h"
#include "poketch_prv.h"
#include "poketch_button.h"

//==============================================================
// Work
//==============================================================
typedef struct {
	u8        main_seq;
	u8        seq;

	u8        quit_req_flag;

	VIEWPARAM  vpara;
	VIEWWORK*  vwk;
	CONTACT_WORK*  conwk;

	POKETCH_BUTTON_MAN*  button;
	u32                  button_event;

	POKETCH_DATA*        savedata;

}APPWORK;

//==============================================================
// V[PX
//==============================================================
enum {
	SEQ_INIT,
	SEQ_IDLE,
	SEQ_QUIT,
};

//==============================================================
// Prototype
//==============================================================
static void NitroStaticInit(void);
static BOOL Poketch_A10_Init(void **wk_ptr, CONTACT_WORK* conwk, GF_BGL_INI* bgl, u32 param);
static BOOL SetupWork( APPWORK *wk, CONTACT_WORK* conwk, GF_BGL_INI* bgl, u32 param );
static void BmnCallBack( u32 idx, u32 event, u32 touch_event, void* wk_adrs );
static void CleanupWork( APPWORK *wk );
static void Poketch_A10_Main(TCB_PTR tcb, void *wk_adrs);
static void Poketch_A10_Quit(void *wk_adrs);
static void ChangeSeq(APPWORK *wk, u32 seq);
static BOOL SeqInit(APPWORK *wk);
static BOOL SeqIdle(APPWORK *wk);
static BOOL SeqQuit(APPWORK *wk);



//------------------------------------------------------------------
/**
 * Av̐֐AhXCRg[ɓn
 */
//------------------------------------------------------------------
static void NitroStaticInit(void)
{
	PoketchSetAppProc(Poketch_A10_Init, Poketch_A10_Quit);
}

//------------------------------------------------------------------
/**
 * Av֐
 *
 * @param   wk_ptr		[NAhXۑ|C^̃AhX
 * @param   conwk		Av{̂擾ۂɕKvƂȂ郏[NiAvւ͔Jj
 * @param   bgl			BGLW[wb_
 * @param   param		J[EmNȂǓ^CviAvˑj
 */
//------------------------------------------------------------------
static BOOL Poketch_A10_Init(void **wk_ptr, CONTACT_WORK* conwk, GF_BGL_INI* bgl, u32 param)
{
	APPWORK* wk = (APPWORK*)sys_AllocMemory( POKETCH_APP_CTRL_HEAPID, sizeof(APPWORK));

	if(wk != NULL)
	{
		if(SetupWork( wk, conwk, bgl, param ))
		{
			if( TCB_Add(Poketch_A10_Main, wk, POKETCH_APP_TASKPRI) != NULL )
			{
				*wk_ptr = wk;
				return TRUE;
			}
		}
		sys_FreeMemoryEz( wk );
	}

	return FALSE;
}
//------------------------------------------------------------------
/**
 * [ÑZbgAbv
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static BOOL SetupWork( APPWORK *wk, CONTACT_WORK* conwk, GF_BGL_INI* bgl, u32 param )
{
	static const TP_HIT_TBL ButtonHitData[] = {
		{
			BUTTON_CENTER_Y-(BUTTON_HEIGHT/2), BUTTON_CENTER_Y+(BUTTON_HEIGHT/2),
			BUTTON_CENTER_X-(BUTTON_WIDTH/2),  BUTTON_CENTER_X+(BUTTON_WIDTH/2),
		},
		
	};

	wk->conwk = conwk;
	wk->savedata = PoketchGetSaveData(conwk);
	wk->vpara.button_state = BUTTON_STATE_FREE;
	wk->vpara.counter = PoketchData_GetPedometer( wk->savedata );


	if( Poketch_A10_SetViewWork( &(wk->vwk), &(wk->vpara), bgl ) )
	{
		wk->main_seq = SEQ_INIT;
		wk->seq = 0;
		wk->quit_req_flag = FALSE;

		wk->button =  PBTN_Create( ButtonHitData, NELEMS(ButtonHitData), BmnCallBack, wk, POKETCH_APP_CTRL_HEAPID );
		wk->button_event = BMN_EVENT_NULL;


		return TRUE;
	}

	return FALSE;
}



//------------------------------------------------------------------
/**
 * {^Ǘ}l[W̃R[obN֐
 *
 * @param   idx		
 * @param   event		
 * @param   touch_event		
 * @param   wk_adrs		
 *
 */
//------------------------------------------------------------------
static void BmnCallBack( u32 idx, u32 event, u32 touch_event, void* wk_adrs )
{
	APPWORK *wk = (APPWORK*)wk_adrs;

	if( idx == 0 )
	{
		wk->button_event = event;
	}
}


//------------------------------------------------------------------
/**
 * [ÑN[Abv
 *
 * @param   wk		[N|C^
 *
 */
//------------------------------------------------------------------
static void CleanupWork( APPWORK *wk )
{
	PBTN_Delete( wk->button );
	Poketch_A10_DeleteViewWork( wk->vwk );
	sys_FreeMemoryEz( wk );
}
//------------------------------------------------------------------
/**
 * AvC֐
 *
 * @param   wk_adrs		[NAhX
 *
 */
//------------------------------------------------------------------
static void Poketch_A10_Main(TCB_PTR tcb, void *wk_adrs)
{
	static BOOL (* const seqtbl[])(APPWORK*) = {
		SeqInit,
		SeqIdle,
		SeqQuit,
	};

	APPWORK *wk = (APPWORK*)wk_adrs;

	if( wk->main_seq < NELEMS(seqtbl) )
	{
		PoketchButtonMainCall( wk->conwk, wk->button );

		if( seqtbl[wk->main_seq](wk) )
		{
			CleanupWork( wk );
			TCB_Delete(tcb);
			PoketchNoticeAppEnd( wk->conwk );
		}
	}
	else
	{
		SDK_ASSERT(0);
	}
}
//------------------------------------------------------------------
/**
 * AvI֐
 *
 * @param   wk_adrs		[NAhX
 *
 */
//------------------------------------------------------------------
static void Poketch_A10_Quit(void *wk_adrs)
{
	((APPWORK*)wk_adrs)->quit_req_flag = TRUE;
}

//------------------------------------------------------------------
/**
 * V[PXύX
 *
 * @param   wk		[N|C^
 * @param   seq		ύX̃V[PXio[
 *
 */
//------------------------------------------------------------------
static void ChangeSeq(APPWORK *wk, u32 seq)
{
	if(wk->quit_req_flag == FALSE)
	{
		wk->main_seq = seq;
	}
	else
	{
		wk->main_seq = SEQ_QUIT;
	}
	wk->seq = 0;
}


//------------------------------------------------------------------
/**
 * V[PXFʍ\z
 *
 * @param   wk			[N|C^
 *
 * @retval  BOOL		TRUEŃAvI
 */
//------------------------------------------------------------------
static BOOL SeqInit(APPWORK *wk)
{
	switch(wk->seq){
	case 0:
		Poketch_A10_SetViewCommand( wk->vwk, CMD_INIT );
		wk->seq++;
		break;

	case 1:
		if(Poketch_A10_WaitViewCommand( wk->vwk, CMD_INIT ))
		{
			PoketchNoticeAppStart( wk->conwk );
			ChangeSeq( wk, SEQ_IDLE );
		}
		break;
	}
	return FALSE;
}
//------------------------------------------------------------------
/**
 * V[PXF͑҂
 *
 * @param   wk		[N|C^
 *
 * @retval  BOOL		TRUEŃAvI
 */
//------------------------------------------------------------------
static BOOL SeqIdle(APPWORK *wk)
{
	VIEWPARAM* vpara = &(wk->vpara);

	if(wk->quit_req_flag)
	{
		ChangeSeq( wk, SEQ_QUIT );
		return FALSE;
	}

	switch( wk->seq ){
	case 0:
		if( wk->button_event == BMN_EVENT_TOUCH )
		{
			vpara->button_state = BUTTON_STATE_TOUCH;
			Poketch_A10_SetViewCommand( wk->vwk, CMD_BUTTON_UPDATE );
			wk->button_event = BMN_EVENT_NULL;
			wk->seq++;
			break;
		}

		if( PoketchGetPedometerUpdateFlag( wk->conwk ) )
		{
			vpara->counter = PoketchData_GetPedometer( wk->savedata );
			Poketch_A10_SetViewCommand( wk->vwk, CMD_COUNTER_UPDATE );
			break;
		}
		break;

	case 1:
		if( wk->button_event == BMN_EVENT_OUT )
		{
			vpara->button_state = BUTTON_STATE_FREE;
			Poketch_A10_SetViewCommand( wk->vwk, CMD_BUTTON_UPDATE );
			wk->button_event = BMN_EVENT_NULL;
			wk->seq = 0;
			break;
		}

		if( wk->button_event == BMN_EVENT_TAP )
		{
			vpara->button_state = BUTTON_STATE_FREE;
			vpara->counter = 0;
			PoketchData_SetPedometer( wk->savedata, 0 );
			Poketch_A10_SetViewCommand( wk->vwk, CMD_BUTTON_UPDATE );
			Poketch_A10_SetViewCommand( wk->vwk, CMD_COUNTER_UPDATE );
			wk->button_event = BMN_EVENT_NULL;
			wk->seq = 0;
			break;
		}

		break;
	}

	return FALSE;
}

//------------------------------------------------------------------
/**
 * V[PXFI
 *
 * @param   wk		[N|C^
 *
 * @retval  BOOL		TRUEŃAvI
 */
//------------------------------------------------------------------
static BOOL SeqQuit(APPWORK *wk)
{
	switch(wk->seq){
	case 0:
		Poketch_A10_SetViewCommand( wk->vwk, CMD_QUIT );
		wk->seq++;
		break;

	case 1:
		if(Poketch_A10_WaitViewCommandAll( wk->vwk ))
		{
			return TRUE;
		}
		break;
	}

	return FALSE;
}
