//============================================================================================
/**
 * @file	poketch_work.c
 * @bfief	|Pb`itB[h <->  ؂ւ莞ɂeAv̏󋵂LĂ̈j
 * @author	taya GAME FREAK inc.
 */
//============================================================================================
#include "common.h"
#include "field\poketch.h"
#include "poketch_prv.h"

enum {
	APPNUMBER_NULL = 0xffffffff,
	POKETCH_WORK_SIZE = 0x3000,
};

static int ReserveAppNumber = APPNUMBER_NULL;
static u8 PoketchWork[ POKETCH_WORK_SIZE ];



//------------------------------------------------------------------
/**
 * Av؂ւɌĂ΂A\AvԍZbg
 */
//------------------------------------------------------------------
void PoketchWork_Reset( void )
{
	ReserveAppNumber = APPNUMBER_NULL;
}


//------------------------------------------------------------------
/**
 * |Pb`[NGAփAv̔CӃf[^ۑ
 *
 * @param   appNumber	Avio[
 * @param   dat			ۑf[^|C^
 * @param   size		f[^TCY
 *
 */
//------------------------------------------------------------------
void PoketchWork_Save( u32 appNumber, const void* dat, u32 size )
{
	if( size < POKETCH_WORK_SIZE )
	{
		MI_CpuCopy32( dat, PoketchWork, size );
		ReserveAppNumber = appNumber;
	}
	else
	{
		GF_ASSERT(0);
	}
}


//------------------------------------------------------------------
/**
 * |Pb`[NGA璼OɃZ[uAvf[^Rs[
 *
 * @param   appNumber	Avio[ivȂ΃Rs[Ȃj
 * @param   buf			f[^Rs[obt@
 * @param   size		f[^TCY
 *
 * @retval  BOOL		Rs[ꂽTRUEԂ
 */
//------------------------------------------------------------------
BOOL PoketchWork_Load( u32 appNumber, void* buf, u32 size )
{
	if( size < POKETCH_WORK_SIZE )
	{
		if( appNumber == ReserveAppNumber )
		{
			MI_CpuCopy32( PoketchWork, buf, size );
			return TRUE;
		}
	}
	else
	{
		GF_ASSERT(0);
	}
	return FALSE;
}


//------------------------------------------------------------------
/**
 * |Pb`[NGAփAv̔CӃf[^ۑiŁj
 *
 * @param   appNumber	Avio[
 * @param   dat			ۑf[^|C^
 * @param   size		f[^TCY
 *
 */
//------------------------------------------------------------------
void PoketchWork_SaveFast( u32 appNumber, const void* dat, u32 size )
{
	if( size < POKETCH_WORK_SIZE )
	{
		MI_CpuCopyFast( dat, PoketchWork, size );
		ReserveAppNumber = appNumber;
	}
	else
	{
		GF_ASSERT(0);
	}
}
//------------------------------------------------------------------
/**
 * |Pb`[NGA璼OɃZ[uAvf[^Rs[iŁj
 *
 * @param   appNumber	Avio[ivȂ΃Rs[Ȃj
 * @param   buf			f[^Rs[obt@
 * @param   size		f[^TCY
 *
 * @retval  BOOL		Rs[ꂽTRUEԂ
 */
//------------------------------------------------------------------
BOOL PoketchWork_LoadFast( u32 appNumber, void* buf, u32 size )
{
	if( size < POKETCH_WORK_SIZE )
	{
		if( appNumber == ReserveAppNumber )
		{
			MI_CpuCopyFast( PoketchWork, buf, size );
			return TRUE;
		}
	}
	else
	{
		GF_ASSERT(0);
	}
	return FALSE;
}
