//============================================================================================
/**
 * @file	poketch_data.c
 * @bfief	|Pb`f[^ANZXp\[X
 * @author	taya GAME FREAK inc.
 * @date	2005.10.27
 */
//============================================================================================

#include "system/savedata_def.h"	//SAVEDATAQƂ̂

#include "common.h"
#include "gflib/system.h"
#include "system/savedata.h"
#include "poketool\pokeicon.h"

#include "field/poketch_data.h"



//============================================================================================
//============================================================================================
enum {
	APP_REGIST_MAX = 32,	///< Av̍ő吔ƍȂAZ[uf[^TCY肽Ȃ̂ł̂܂
	POKETCH_DEFAULT_APPNO = POKETCH_APPID_DWATCH,	// ftHgœo^ĂAv
};


//============================================================================================
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	|Pb`f[^p\̒`
 */
//----------------------------------------------------------
struct _POKETCH_DATA {
	u8		get_flag : 1;		///< |Pb`擾tO
	u8		pedometer_flag : 1;	///< Avwvx擾tO
	u8		dotart_modified_flag : 1;	///< AvwhbgA[gxҏWtO
	u8		color_type : 3;		///< J[^Cvi0`7j
	u8		 : 2;

	s8		app_count;			///< o^ĂAv
	s8		app_index;			///< ݕ\̃Avio^e[uCfbNXj


	u8		app_flag[APP_REGIST_MAX];	///< 擾AvIDo^e[u

	u32		pedometer;			///< wvx

	u16		alarm_switch : 1;		///< AvwA[vxXCb`
	u16		alarm_hour   : 5;		///< AvwA[vx
	u16		alarm_minute : 6;		///< AvwA[vx
	u16		 : 4;

	//-------------------
	u8		dotart_data[POKETCH_DOTART_DATA_BYTESIZE];	///< whbgA[gxۑf[^

	//-------------------
	u32		calendar_markbit;	///< wJ_[x}[NrbgtO
	u8		calendar_month;		///< wJ_[x}[N

	//-------------------
	struct {
		u8   x;
		u8   y;
	}mark_map_pos[ POKETCH_MAP_MARK_MAX ];	///< w}bv}[LOx}[Nʒu

	//--------------------
	struct {
		u16  monsno;
		u16  iconPattern;
	}poke_history[ POKETCH_POKE_HISTORY_COUNT_MAX ];

};

//============================================================================================
//	Z[uf[^VXeˑ֐
//============================================================================================

//------------------------------------------------------------------
/**
 * [NTCY擾
 *
 * @retval  int		[NTCY
 */
//------------------------------------------------------------------
int PoketchData_GetWorkSize(void)
{
	return sizeof(POKETCH_DATA);
}
//------------------------------------------------------------------
/**
 * [NpAP[gĕԂ
 *
 * @param   heapID		AP[gpq[vhc
 *
 * @retval  POKETCH_DATA *		ς݃[N̈̃|C^
 */
//------------------------------------------------------------------
POKETCH_DATA * PoketchData_AllocWork(u32 heapID)
{
	POKETCH_DATA * pk;
	pk = sys_AllocMemory(heapID, sizeof(POKETCH_DATA));
	PoketchData_Init( pk );
	return pk;
}

//============================================================================================
//	POKETCH_DATÂ߂̊֐
//============================================================================================

//------------------------------------------------------------------
/**
 * [N̈揉
 *
 * @param   poketch_data		[N|C^
 *
 */
//------------------------------------------------------------------
void PoketchData_Init(POKETCH_DATA* poketch_data)
{
	enum {
		DEFAULT_APPNO = POKETCH_APPID_DWATCH,
	};

	int i;

	for(i=0; i<APP_REGIST_MAX; i++)
	{
		poketch_data->app_flag[i] = 0;
	}
	poketch_data->app_count = 0;
	poketch_data->app_index = 0;
	poketch_data->get_flag = FALSE;
	poketch_data->color_type = POKETCH_COLOR_TYPE0;

	// v
	poketch_data->pedometer_flag = FALSE;
	poketch_data->pedometer = 0;

	// A[v
	poketch_data->alarm_switch = FALSE;
	poketch_data->alarm_hour = 0;
	poketch_data->alarm_minute = 0;

	// J_[
	poketch_data->calendar_month = 1;
	poketch_data->calendar_markbit = 0;

	// }[LO}bv
	{
		static const struct {
			u8  x;
			u8  y;
		}initialPos[POKETCH_MAP_MARK_MAX] = {
			{ 104, 152 }, { 120, 152 }, { 136, 152 },
			{ 152, 152 }, { 168, 152 }, { 184, 152 },
		};
		for(i=0; i<POKETCH_MAP_MARK_MAX; i++)
		{
			poketch_data->mark_map_pos[i].x = initialPos[i].x;
			poketch_data->mark_map_pos[i].y = initialPos[i].y;
		}
	}

	// |PqXg[
	for(i=0; i<POKETCH_POKE_HISTORY_COUNT_MAX; i++)
	{
		poketch_data->poke_history[i].monsno = 0;
		poketch_data->poke_history[i].iconPattern = 0;
	}

	// hbgA[g
	poketch_data->dotart_modified_flag = 0;



	PoketchData_AddApplication(poketch_data, DEFAULT_APPNO);
}
//------------------------------------------------------------------
/**
 * |Pb`ɓꂽtOZbg
 *
 * @param   poketch_data		[N|C^
 *
 */
//------------------------------------------------------------------
void PoketchData_SetPoketchGetFlag( POKETCH_DATA* poketch_data )
{
	poketch_data->get_flag = TRUE;
}
//------------------------------------------------------------------
/**
 * |Pb`ɓꂽtO擾
 *
 * @param   poketch_data		[N|C^
 *
 */
//------------------------------------------------------------------
BOOL PoketchData_GetPoketchGetFlag( POKETCH_DATA* poketch_data )
{
	return poketch_data->get_flag;
}
//------------------------------------------------------------------
/**
 * o^ĂAvP[V̐擾
 *
 * @param   poketch_data		[N|C^
 *
 * @retval  int		o^ĂAvP[V̐
 */
//------------------------------------------------------------------
int PoketchData_GetApplicationCount(const POKETCH_DATA * poketch_data)
{
	return poketch_data->app_count;
}
//------------------------------------------------------------------
/**
 * ƂAvo^ł邩擾
 *
 * @param   poketch_data		[N|C^
 *
 * @retval  int		o^ł邩
 */
//------------------------------------------------------------------
int PoketchData_GetRestApplicationSpace( POKETCH_DATA* poketch_data )
{
	return POKETCH_APPID_MAX - poketch_data->app_count;
}
//------------------------------------------------------------------
/**
 * łɃAvo^Ă邩`FbN
 *
 * @param   poketch_data	[N|C^
 * @param   app_id			AvP[VID
 *
 * @retval  BOOL	TRUEœo^ς
 */
//------------------------------------------------------------------
BOOL PoketchData_CheckApplicationRegisterd( POKETCH_DATA* poketch_data, int app_id )
{
	return poketch_data->app_flag[app_id];
}
//------------------------------------------------------------------
/**
 * VAvP[Vǉ
 *
 * @param   poketch_data		[N|C^
 * @param   app_id				AvP[VID
 *
 * @retval  BOOL		TRUEœo^^FALSEŎsiςj
 */
//------------------------------------------------------------------
BOOL PoketchData_AddApplication(POKETCH_DATA * poketch_data, int app_id)
{
	GF_ASSERT( app_id >= 0 && app_id < POKETCH_APPID_MAX );

	if( poketch_data->app_count < POKETCH_APPID_MAX )
	{
		if( poketch_data->app_flag[ app_id ] == FALSE )
		{
			poketch_data->app_flag[ app_id ] = TRUE;
			poketch_data->app_count++;

			if( app_id == POKETCH_APPID_PEDOMETER )
			{
				poketch_data->pedometer_flag = TRUE;
			}

			return TRUE;
		}
	}
	return FALSE;
}
//------------------------------------------------------------------
/**
 * ݕ\̃AvP[VID擾
 *
 * @param   poketch_data		[N|C^
 *
 * @retval  int		AvP[VID
 *
 * AvP[VID = vAAAv̎ނʂID.
 */
//------------------------------------------------------------------
int PoketchData_GetNowApplication(const POKETCH_DATA* poketch_data)
{
	return poketch_data->app_index;
}
//------------------------------------------------------------------
/**
 * \AvPO֐؂ւ
 *
 * @param   poketch_data		[N|C^
 *
 * @retval  int		؂ւ̃AvP[Vԍ
 */
//------------------------------------------------------------------
int PoketchData_SetApplicationPosNext( POKETCH_DATA* poketch_data )
{
	int  i = poketch_data->app_index;

	while(1)
	{
		if( ++i >= POKETCH_APPID_MAX )
		{
			i = 0;
		}
		if( i == poketch_data->app_index )
		{
			break;
		}
		if( poketch_data->app_flag[i] )
		{
			break;
		}
	}
	poketch_data->app_index = i;
	return poketch_data->app_index;
}
//------------------------------------------------------------------
/**
 * \AvP֐؂ւ
 *
 * @param   poketch_data		[N|C^
 *
 * @retval  int		؂ւ̃AvP[Vԍ
 */
//------------------------------------------------------------------
int PoketchData_SetApplicationPosPrev( POKETCH_DATA* poketch_data )
{
	int  i = poketch_data->app_index;

	while(1)
	{
		if( --i < 0 )
		{
			i = POKETCH_APPID_MAX - 1;
		}
		if( i == poketch_data->app_index )
		{
			break;
		}
		if( poketch_data->app_flag[i] )
		{
			break;
		}
	}
	poketch_data->app_index = i;
	return poketch_data->app_index;
}
//------------------------------------------------------------------
/**
 * \Avwo^ԍ̕ɐ؂ւ
 *
 * @param   poketch_data	[N|C^
 * @param   pos				o^ԍ
 *
 */
//------------------------------------------------------------------
void PoketchData_SetApplicationPos( POKETCH_DATA* poketch_data, int pos )
{
	if( pos >= 0 && pos < poketch_data->app_count )
	{
		int i;
		for(i=0; i<POKETCH_APPID_MAX; i++)
		{
			if( poketch_data->app_flag[i] )
			{
				if( pos == 0 )
				{
					poketch_data->app_index = i;
					break;
				}
				else
				{
					pos--;
				}
			}
		}
		
	}
	else
	{
		GF_ASSERT(0);
	}
}

//------------------------------------------------------------------
/**
 * J[^Cv擾
 *
 * @param   poketch_data		[N|C^
 *
 * @retval  u32		J[^Cv
 */
//------------------------------------------------------------------
u32 PoketchData_GetColorType( const POKETCH_DATA* poketch_data )
{
	GF_ASSERT(poketch_data);
	return poketch_data->color_type;
}
//------------------------------------------------------------------
/**
 * J[^Cvݒ
 *
 * @param   poketch_data		[N|C^
 */
//------------------------------------------------------------------
void PoketchData_SetColorType( POKETCH_DATA* poketch_data, u32 color_type )
{
	GF_ASSERT(poketch_data);
	GF_ASSERT(color_type < POKETCH_COLOR_TYPE_MAX);
	poketch_data->color_type = color_type;
}

//==============================================================================================
//==============================================================================================

//------------------------------------------------------------------
/**
 * wvx̕擾
 *
 * @param   poketch_data		[N|C^
 *
 * @retval  u32		v
 */
//------------------------------------------------------------------
u32 PoketchData_GetPedometer( const POKETCH_DATA* poketch_data )
{
	return poketch_data->pedometer;
}
//------------------------------------------------------------------
/**
 * wvx̕Zbg
 *
 * @param   poketch_data		[N|C^
 * @param   pos					Zbg
 */
//------------------------------------------------------------------
void PoketchData_SetPedometer( POKETCH_DATA* poketch_data, u32 count )
{
	if( poketch_data->pedometer_flag )
	{
		poketch_data->pedometer = count;
	}
}

//==============================================================================================
//==============================================================================================

//------------------------------------------------------------------
/**
 * wA[vx̃XCb`I^IttO擾
 *
 * @param   poketch_data		[N|C^
 *
 * @retval  BOOL			
 */
//------------------------------------------------------------------
BOOL PoketchData_GetAlarmSwitchFlag( const POKETCH_DATA* poketch_data )
{
	return poketch_data->alarm_switch;
}
//------------------------------------------------------------------
/**
 * wA[vx̐ݒ莞擾
 *
 * @param   poketch_data		[N|C^
 * @param   hour				ݒ莞ij󂯎ϐ̃|C^
 * @param   min					ݒ莞ij󂯎ϐ̃|C^
 *
 */
//------------------------------------------------------------------
void PoketchData_GetAlarmTime( const POKETCH_DATA* poketch_data, u32* hour, u32* min )
{
	*hour = poketch_data->alarm_hour;
	*min = poketch_data->alarm_minute;
}
//------------------------------------------------------------------
/**
 * wA[vx̐ݒXV
 *
 * @param   poketch_data	[N|C^
 * @param   switch_flag		XCb`I^IttO
 * @param   hour			ݒ莞ij
 * @param   min				ݒ莞ij
 *
 */
//------------------------------------------------------------------
void PoketchData_SetAlarm( POKETCH_DATA* poketch_data, BOOL switch_flag, u32 hour, u32 min )
{
	poketch_data->alarm_switch = switch_flag;
	poketch_data->alarm_hour = hour;
	poketch_data->alarm_minute = min;
}

//==============================================================================================
//==============================================================================================

//------------------------------------------------------------------
/**
 * J_[̓trbgZbg
 *
 * @param   poketch_data	|Pb`f[^|C^
 * @param   month			Zbg錎
 * @param   day				Zbg
 *
 */
//------------------------------------------------------------------
void PoketchData_Calendar_SetMark( POKETCH_DATA* poketch_data, u32 month, u32 day )
{
	if( poketch_data->calendar_month == month )
	{
		poketch_data->calendar_markbit |= (1 << (day-1));
	}
	else
	{
		poketch_data->calendar_month = month;
		poketch_data->calendar_markbit = (1 << (day-1));
	}
}
//------------------------------------------------------------------
/**
 * J_[̓trbgNA
 *
 * @param   poketch_data	|Pb`f[^|C^
 * @param   month			NA錎
 * @param   day				NA
 *
 */
//------------------------------------------------------------------
void PoketchData_Calendar_ClearMark( POKETCH_DATA* poketch_data, u32 month, u32 day )
{
	if( poketch_data->calendar_month == month )
	{
		poketch_data->calendar_markbit &= ~(1 << (day-1));
	}
	else
	{
		poketch_data->calendar_month = month;
		poketch_data->calendar_markbit = 0;
	}
}
//------------------------------------------------------------------
/**
 * J_[̓trbg擾
 *
 * @param   poketch_data	|Pb`f[^|C^
 * @param   month			
 * @param   day				
 *
 * @retval  BOOL		TRUEȂrbgON
 */
//------------------------------------------------------------------
BOOL PoketchData_Calendar_GetMark( const POKETCH_DATA* poketch_data, u32 month, u32 day )
{
	if( poketch_data->calendar_month == month )
	{
		return (poketch_data->calendar_markbit >> (day-1)) & 1;
	}
	else
	{
		return FALSE;
	}
}


//==============================================================================================
//==============================================================================================

void PoketchData_MarkMap_SetMarkPos( POKETCH_DATA* poketch_data, int id, u8 x, u8 y )
{
	GF_ASSERT(id < POKETCH_MAP_MARK_MAX);

	poketch_data->mark_map_pos[id].x = x;
	poketch_data->mark_map_pos[id].y = y;
}
void PoketchData_MarkMap_GetMarkPos( const POKETCH_DATA* poketch_data, int id, u8* x, u8* y )
{
	GF_ASSERT(id < POKETCH_MAP_MARK_MAX);

	*x = poketch_data->mark_map_pos[id].x;
	*y = poketch_data->mark_map_pos[id].y;
}

//==============================================================================================
//==============================================================================================

//------------------------------------------------------------------
/**
 * AvwhbgA[gx@xłeҏWꂽƂ邩H
 *
 * @param   poketch_data		|Pb`f[^|C^
 *
 * @retval  BOOL		TRUEŕҏWꂽƂ
 */
//------------------------------------------------------------------
BOOL PoketchData_DotArt_GetModifiedFlag( const POKETCH_DATA* poketch_data )
{
	return poketch_data->dotart_modified_flag;
}
//------------------------------------------------------------------
/**
 * AvwhbgA[gx	rbgf[^擾
 *
 * @param   poketch_data		|Pb`f[^|C^
 * @param   dst					f[^擾obt@
 *
 */
//------------------------------------------------------------------
void PoketchData_DotArt_GetBitData( const POKETCH_DATA* poketch_data, u8* dst )
{
	if( poketch_data->dotart_modified_flag )
	{
		MI_CpuCopy8( poketch_data->dotart_data, dst, POKETCH_DOTART_DATA_BYTESIZE );
	}
}
//------------------------------------------------------------------
/**
 * AvwhbgA[gx	ҏWrbgf[^ۑ
 *
 * @param   poketch_data		|Pb`f[^|C^
 * @param   src					rbgf[^AhX
 *
 */
//------------------------------------------------------------------
void PoketchData_DotArt_SetBitData( POKETCH_DATA* poketch_data, const u8* src )
{
	MI_CpuCopy8( src, poketch_data->dotart_data, POKETCH_DOTART_DATA_BYTESIZE );
	poketch_data->dotart_modified_flag = 1;
}



//==============================================================================================
// |PqXg[iɓꂽ|PL^j
//==============================================================================================


//------------------------------------------------------------------
/**
 * w|PqXg[xL^ǉ
 *
 * @param   poketch_data		|Pb`f[^|C^
 * @param   ppp					|Pp[^
 *
 */
//------------------------------------------------------------------
void PoketchData_PokeHistory_Add( POKETCH_DATA* poketch_data, const POKEMON_PASO_PARAM* ppp )
{
	int max;

	max = PoketchData_PokeHistory_GetRecordCount( poketch_data );
	if( max >= POKETCH_POKE_HISTORY_COUNT_MAX )
	{
		int i;
		for(i=0; i<(POKETCH_POKE_HISTORY_COUNT_MAX-1); i++)
		{
			poketch_data->poke_history[i] = poketch_data->poke_history[i+1];
		}
		max = POKETCH_POKE_HISTORY_COUNT_MAX - 1;
	}

	poketch_data->poke_history[max].monsno = PokePasoParaGet((POKEMON_PASO_PARAM*)ppp, ID_PARA_monsno, NULL);
	poketch_data->poke_history[max].iconPattern = PokeIconCgxPatternGet( ppp );
}

//------------------------------------------------------------------
/**
 * w|PqXg[xL^Ԃ
 *
 * @param   poketch_data		|Pb`f[^|C^
 *
 * @retval  int		L^
 */
//------------------------------------------------------------------
int PoketchData_PokeHistory_GetRecordCount( const POKETCH_DATA* poketch_data )
{
	int i;
	for(i=0; i<POKETCH_POKE_HISTORY_COUNT_MAX; i++)
	{
		if( poketch_data->poke_history[i].monsno == 0 )
		{
			return i;
		}
	}
	return i;
}

//------------------------------------------------------------------
/**
 * w|PqXg[xL^ꂽf[^擾
 *
 * @param   poketch_data	|Pb`f[^|C^
 * @param   index			 0origin CfbNX
 * @param   monsno			[out]X^[io[󂯎
 * @param   iconPattern		[out]ACRp^[io[󂯎
 *
 */
//------------------------------------------------------------------
void PoketchData_PokeHistory_GetRecord( const POKETCH_DATA* poketch_data, int index, int* monsno, int* iconPattern )
{
	GF_ASSERT(index<POKETCH_POKE_HISTORY_COUNT_MAX);
	GF_ASSERT(poketch_data->poke_history[index].monsno);

	*monsno = poketch_data->poke_history[index].monsno;
	*iconPattern = poketch_data->poke_history[index].iconPattern;
}



//============================================================================================
//	Z[uf[^擾̂߂̊֐
//============================================================================================
POKETCH_DATA * SaveData_GetPoketchData(SAVEDATA * sv)
{
	POKETCH_DATA * pk;
	pk = SaveData_Get(sv, GMDATA_ID_POKETCH_DATA);
	return pk;
}



//============================================================================================
//	fobOp
//============================================================================================
#ifdef PM_DEBUG
void PoketchData_AddAllApplication( POKETCH_DATA* poketch_data )
{
	#if 1
	int i;
	for(i=0; i<POKETCH_APPID_MAX; i++)
	{
		if(i == POKETCH_DEFAULT_APPNO)
		{
			continue;
		}
		PoketchData_AddApplication(poketch_data, i);
	}
	#else
	PoketchData_AddApplication(poketch_data, POKETCH_APPID_POKELIST);
	PoketchData_AddApplication(poketch_data, POKETCH_APPID_KITCHEN_TIMER);
	PoketchData_AddApplication(poketch_data, POKETCH_APPID_PEDOMETER );
	#endif
}
#endif
