//=============================================================================
/**
 * @file	rah_cylinder_anm.c
 * @bfief	CEACEnC̃V_[Aj
 * @author	Nozomu Saito
 *
 */
//=============================================================================
#include "common.h"
#include "fieldsys.h"
#include "field_3d_anime.h"
#include "fielddata/build_model/build_model_id.h"
#include "field\sysflag.h"

#include "rah_cylinder_anm.h"

static BOOL AnimeEvent(GMEVENT_CONTROL * event);

//--------------------------------------------------------------
/**
 * 
 *
 * @param	fsys			tB[hVXe|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
void RAH_CYL_ANM_Setup(FIELDSYS_WORK *fsys)
{
	FLD_3D_ANM_DAT_PTR anime;
	//~oCxgtOɂĕ
	if ( !SysFlag_ReiAiHaiCheck( SaveData_GetEventWork(fsys->savedata) ) ){
		//~oO
		//1ԃAjJnt[Œ~ [v1ɃZbg
		anime = F3DA_GetFld3DAnmPtr( BMID_D26_O02, 1, fsys->field_3d_anime );
		F3DA_SetAnimeLoopMax(anime, 1);
		F3DA_SetStopFlg(anime, TRUE);
	}else{
		//~o
		//0ԃAj~@1ԃAjŏIt[Œ~
		anime = F3DA_GetFld3DAnmPtr( BMID_D26_O02, 0, fsys->field_3d_anime );
		F3DA_SetStopFlg(anime, TRUE);
		anime = F3DA_GetFld3DAnmPtr( BMID_D26_O02, 1, fsys->field_3d_anime );
		F3DA_SetLastFrame(anime);
		F3DA_SetStopFlg(anime, TRUE);
	}
}

//--------------------------------------------------------------
/**
 * V_[~oAjJn
 *
 * @param	fsys			tB[hVXe|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
void RAH_CYL_ANM_StartFreeEvent(FIELDSYS_WORK *fsys)
{
	//AjCxgR[
	FieldEvent_Call(fsys->event, AnimeEvent, NULL);
}

//--------------------------------------------------------------
/**
 * V_[~oAjCxg
 *
 * @param	event	Cxg|C^
 *
 * @retval	BOOL	TRUE:CxgI	FALSE:Cxgp
 */
//--------------------------------------------------------------
static BOOL AnimeEvent(GMEVENT_CONTROL * event)
{
	int *seq;
	FLD_3D_ANM_DAT_PTR anime;
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	
	seq  = FieldEvent_GetSeqWork(event);
	switch(*seq){
	case 0: //0ԃAj̍ŏIt[҂
		//Aj
		anime = F3DA_GetFld3DAnmPtr( BMID_D26_O02, 0, fsys->field_3d_anime );
		if ( F3DA_IsLastFrame(anime) ){
			F3DA_SetStopFlg(anime, TRUE);		//~
			(*seq)++;
		}
		break;
	case 1: //1ԃAjX^[g
		//Aj
		anime = F3DA_GetFld3DAnmPtr( BMID_D26_O02, 1, fsys->field_3d_anime );
		F3DA_SetStopFlg(anime, FALSE);		//Đ
		(*seq)++;
		break;
	case 2:	//1ԃAj҂
		anime = F3DA_GetFld3DAnmPtr( BMID_D26_O02, 1, fsys->field_3d_anime );
		if ( F3DA_IsAnimeEnd(anime) ){
			return TRUE;
		}
		break;
	}
	return FALSE;
}
