//============================================================================================
/**
 * @file	safari_enc.c
 * @brief	Tt@GJEg֘A
 * @author	saitou
 *
 */
//============================================================================================
#include "common.h"
#include "system/arc_tool.h"
#include "fielddata/maptable/zone_id.h"
#include "arc/encdata_ex.naix"

#include "encount_define.h"

#include "safari_enc.h"

#define SAFARI_BIT_SHIFT	(5)

static u8 GetSafariArea( const int inZoneID );

//-----------------------------------------------------------------------------
/**
 * Tt@GJEge[uւ
 *
 * @param	inRandomSeed		_̎
 * @param	inBookGet			S}ӓtO
 * @param	inZoneID			][hc
 * @param	*outSafEncMonsNo1	GJEg|P1̖
 * @param	*outSafEncMonsNo2	GJEg|P2̖
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
void SafariEnc_SetSafariEnc(	const int inRandomSeed, const BOOL inBookGet,
								const int inZoneID,
								int *outSafEncMonsNo1, int *outSafEncMonsNo2)
{
	int *tbl;
	int arc_idx;
	u8 tblno;
	u8 area = GetSafariArea( inZoneID );
	
	//S}ӊǂŁAe[uς
	if(inBookGet){
		arc_idx = NARC_encdata_ex_safari_af_bin;
	}else{
		arc_idx = NARC_encdata_ex_safari_bef_bin;
	}
	//Tt@GJEge[u擾
	tbl = ArchiveDataLoadMallocLo(ARC_ENCDATA_EX, arc_idx, HEAPID_FIELD);
	//_̎ɃTt@GJEge[u|PIo
	
	/* ---Io@--- */
	/*Tt@_̎5rbgʃrbg6B2rbg͎gȂ*/
	/*Tt@GAԍi0`5jAgrbgQ*/
	/*0ȂA5rbgB1Ȃ玟5rbgEEE*/
	/*w5rbgŌ肳鐔i0`31jTt@e[uŎw肳CfbNXƂȂ*/
	/*̃CfbNXŌ肷|Pio[gɓ*/
	/*g2ɂ͓|Pio[*/
	
	tblno = ( (inRandomSeed >> (SAFARI_BIT_SHIFT*area)) & 0x1f );

	tblno %= SAFARI_TBL_MAX;//<<Ô߃e[uő吔̗]̗plƂ

	(*outSafEncMonsNo1) = tbl[tblno];
	(*outSafEncMonsNo2) = tbl[tblno];

	sys_FreeMemoryEz(tbl);
}

//-----------------------------------------------------------------------------
/**
 * ][hcTt@GAԍi0`5jԂ
 * 0F	EEE@5FE
 *
 * @param	inZoneID		][hc
 *
 * @return	u8				Tt@GAԍ(0`5)
 */
//-----------------------------------------------------------------------------
static u8 GetSafariArea( const int inZoneID )
{
	u8 area = 0;

	switch(inZoneID){
	case ZONE_ID_D06R0201:
		area = 0;
		break;
	case ZONE_ID_D06R0202:
		area = 1;
		break;
	case ZONE_ID_D06R0203:
		area = 2;
		break;
	case ZONE_ID_D06R0204:
		area = 3;
		break;
	case ZONE_ID_D06R0205:
		area = 4;
		break;
	case ZONE_ID_D06R0206:
		area = 5;
		break;
	default:
		GF_ASSERT(0&&"Tt@][ł͂Ȃ");
	}
	
	return area;
}


#ifdef PM_DEBUG
//Tt@e[uZo
void SafariEnc_DebugGetSafariTbl(	const int inRandomSeed, const BOOL inBookGet,
									const u8 inArea,
									int *outSaf, int *outSafEncMonsNo)
{
	int *tbl;
	int arc_idx;
	u8 tblno;
	u8 area = inArea;
	
	//S}ӊǂŁAe[uς
	if(inBookGet){
		arc_idx = NARC_encdata_ex_safari_af_bin;
	}else{
		arc_idx = NARC_encdata_ex_safari_bef_bin;
	}
	//Tt@GJEge[u擾
	tbl = ArchiveDataLoadMallocLo(ARC_ENCDATA_EX, arc_idx, HEAPID_FIELD);
	//_̎ɃTt@GJEge[u|PIo
	
	/* ---Io@--- */
	/*Tt@_̎5rbgʃrbg6B2rbg͎gȂ*/
	/*Tt@GAԍi0`5jAgrbgQ*/
	/*0ȂA5rbgB1Ȃ玟5rbgEEE*/
	/*w5rbgŌ肳鐔i0`31jTt@e[uŎw肳CfbNXƂȂ*/
	/*̃CfbNXŌ肷|Pio[gɓ*/
	/*g2ɂ͓|Pio[*/
	
	tblno = ( (inRandomSeed >> (SAFARI_BIT_SHIFT*area)) & 0x1f );

	tblno %= SAFARI_TBL_MAX;//<<Ô߃e[uő吔̗]̗plƂ

	(*outSaf) = tblno;
	(*outSafEncMonsNo) = tbl[tblno];

	sys_FreeMemoryEz(tbl);
}

#endif
