//===========================================================================
/**
 * @file	safari_scope_calc.c
 * @brief	Tt@]
 * @author	Nozomu Saito
 * @date	2006.04.24
 * 
 */
//===========================================================================
#include "common.h"
#include "fieldsys.h"
#include "encount_dat.h"
#include "eventdata.h"
#include "ev_mapchange.h"
#include "zonedata.h"
#include "system/arc_tool.h"
#include "system/timezone.h"
#include "system/zukanwork.h"
#include "safari_scope_common.h"
#include "safari_scope_calc.h"
#include "enc_tbl_change_def.h"
#include "encount_set.h"
#include "savedata/encount.h"

#include "fielddata/mapmatrix/map_matrix_id.h"
#include "arc/encdata_ex.naix"

#include "safari_enc.h"
#include "agb_slot_enc.h"

#define SPOT_LIST_MAX	(36)

typedef struct SCOPE_WIEWSPOT_tag
{
	u16 X;
	u16 Z;
}SCOPE_VIEWSPOT;

typedef struct SCOPE_DATA_tag
{
	SCOPE_VIEWSPOT Spot[SCOPE_DISP_CNT+1];
	LOCATION_WORK Next;
	FIELDSYS_WORK * fsys;
	int ReturnZoneID;
}SCOPE_DATA;

//--------------------------------------------------------------------------------------------
/**
 * ]ɏo|P̌
 *
 * @param	fsys	tB[hVXe|C^
 *
 * @return	int		X^[io[
 */
//--------------------------------------------------------------------------------------------
int SSC_GetSafScpMons(FIELDSYS_WORK * fsys)
{
	u8 i;
	BOOL book_get;
	int monsno[ENC_MONS_NUM_NORMAL];
	ENCOUNT_DATA *data;
	//fsysGJEgf[^擾
	data = (ENCOUNT_DATA*)EventData_GetEncountData(fsys);

	for(i=0;i<ENC_MONS_NUM_NORMAL;i++){
		monsno[i] = data->NormalEnc[i].MonsterNo;
	}

	book_get = ZukanWork_GetZenkokuZukanFlag(SaveData_GetZukanWork(GameSystem_GetSaveData(fsys)));

	//Tt@gZbg
	SafariEnc_SetSafariEnc(	EncDataSave_GetRandSeed(
								EncDataSave_GetSaveDataPtr(fsys->savedata), ENC_RND_SEED_SAFARI),
							book_get,
							fsys->location->zone_id,
							&monsno[SP_ENC_1], &monsno[SP_ENC_2]);
	//e[uւ
	EncSet_SetTimeZoneEnc(data, &monsno[TIME_ENC_1], &monsno[TIME_ENC_2]);	
	
	//`faXbge[uւ
	AgbSlotEnc_SetAgbSlotEnc(data, book_get, &monsno[AGB_ENC_1], &monsno[AGB_ENC_2]);
	
	//_1CIo
	return monsno[gf_p_rand(ENC_MONS_NUM_NORMAL)];
}

//--------------------------------------------------------------------------------------------
/**
 * ]_Xg쐬
 *
 * @param	inHeapID	q[vhc
 * @param	fsys		tB[hVXe|C^
 * 
 * @return	ptr			f[^|C^
 */
//--------------------------------------------------------------------------------------------
SSC_SD_PTR SSC_CreateScopePointList(const int inHeapID, FIELDSYS_WORK * fsys)
{
	u8 i;
	SSC_SD_PTR ptr;
	ptr = sys_AllocMemoryLo(inHeapID, sizeof(SCOPE_DATA));
	ptr->fsys = fsys;
	//f[^[h
	{
		u8 no;
		SCOPE_VIEWSPOT *spot;
		spot = ArchiveDataLoadMallocLo(ARC_ENCDATA_EX, NARC_encdata_ex_safari_scope_bin, HEAPID_FIELD);
//		spot = sys_LoadFile(HEAPID_FIELD,"data/safari_scope.bin" );
		//_5ӏ擾
		for(i=0;i<SCOPE_DISP_CNT;i++){
			no = gf_p_rand(SPOT_LIST_MAX);
			ptr->Spot[i].X = spot[no].X;
			ptr->Spot[i].Z = spot[no].Z;
//			OS_Printf("xz=%d,%d\n",spot[no].X,spot[no].Z);
		}
		//6ڂ͖]̏ꏊi߂Ăʒuj
		{
			ptr->Spot[SCOPE_DISP_CNT].X = Player_NowGPosXGet( fsys->player );
			ptr->Spot[SCOPE_DISP_CNT].Z = Player_NowGPosZGet( fsys->player );
			ptr->ReturnZoneID = fsys->location->zone_id;
		}
		//f[^
		sys_FreeMemoryEz(spot);
	}
	
	return ptr;
}

//--------------------------------------------------------------------------------------------
/**
 * ]_Xgj
 *
 * @param	ptr	]f[^|C^
 * 
 * @return	none	
 */
//--------------------------------------------------------------------------------------------
void SSC_RereaseScopePointList(SSC_SD_PTR ptr)
{
	sys_FreeMemoryEz(ptr);
}

//--------------------------------------------------------------------------------------------
/**
 * P[VZbg
 *
 * @param	inNo	]
 * @param	ptr		]f[^|C^
 * 
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void SSC_SetNextLocation(const u8 inNo, SSC_SD_PTR ptr)
{
	int zone_id;
	int block_x,block_z;

	if (inNo == 0){
		int matrix_id;
		matrix_id = MATRIX_ID_DUN0602;	///Tt@
		block_x = ptr->Spot[inNo].X/32;
		block_z = ptr->Spot[inNo].Z/32;
		zone_id = GetZoneIDFromMatID(matrix_id, block_x, block_z );
	}else if (inNo == SCOPE_DISP_CNT){
		zone_id = ptr->ReturnZoneID;
	}else{
		block_x = ptr->Spot[inNo].X/32;
		block_z = ptr->Spot[inNo].Z/32;
		zone_id = World_GetZoneIDFromMatrixXZ(ptr->fsys->World, block_x, block_z);
	}
	SetLocation(&ptr->Next, zone_id, DOOR_ID_JUMP_CODE, ptr->Spot[inNo].X, ptr->Spot[inNo].Z, DIR_UP);
}

//--------------------------------------------------------------------------------------------
/**
 * Wv
 *
 * @param		event	Cxg|C^
 * @param		ptr		]f[^|C^
 * @return		none
 */
//--------------------------------------------------------------------------------------------
void SSC_JumpMap(GMEVENT_CONTROL * event, SSC_SD_PTR ptr)
{
	EventCmd_MapChangeByLocation(event, &ptr->Next);
}

//--------------------------------------------------------------------------------------------
/**
 * ̃[ƃVf[^̃|C^Ԃ
 *
 * @param		ptr					]f[^|C^
 * @return		LOCATION_WORK *		P[Vf[^|C^
 */
//--------------------------------------------------------------------------------------------
LOCATION_WORK *SSC_GetNextLocaton(SSC_SD_PTR ptr)
{
	return &ptr->Next;
}



