//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		scr_hideneff.c
 *	@brief		qfZGtFNgXNvgǗ
 *	@author		tomoya takahshi
 *	@data		2006.06.27
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "common.h"
#include "fieldsys.h"
#include "fieldmap_work.h"
#include "field_hideneff.h"

#define __FIELD_HIDENEFF_H_GLOBAL
#include "scr_hideneff.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	qfZǗ[N
//=====================================
typedef struct {
	FLDMAPFUNC_WORK* p_work;
	u16* p_retwk;
	u32 seq;
	u32 effect_type;
} FLD_HIDENEFF_CONT;

typedef FLDMAPFUNC_WORK* (*pInitFunc)( FIELDSYS_WORK* fsys );
typedef void (*pDeleteFunc)( FLDMAPFUNC_WORK* p_demo );
typedef BOOL (*pEndCheckFunc)( FLDMAPFUNC_WORK* p_demo );


static const pInitFunc	HideInitFunc[ SCR_HIDENEFF_NUM ] = {
	FLD_HIDENEFF_Iaigiri_Start,
	FLD_HIDENEFF_Iwakudaki_Start,
	FLD_HIDENEFF_Iwakudaki_KuroganeL_Start,
};

static const pDeleteFunc	HideDeleteFunc[ SCR_HIDENEFF_NUM ] = {
	FLD_HIDENEFF_Iaigiri_End,
	FLD_HIDENEFF_Iwakudaki_End,
	FLD_HIDENEFF_Iwakudaki_End,
};

static const pEndCheckFunc	HideEndCheckFunc[ SCR_HIDENEFF_NUM ] = {
	FLD_HIDENEFF_Iaigiri_EndCheck,
	FLD_HIDENEFF_Iwakudaki_EndCheck,
	FLD_HIDENEFF_Iwakudaki_EndCheck,
};

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	qfZIǗ^XN
 */
//-----------------------------------------------------------------------------
static void ScrCmd_HidenEffContTask( TCB_PTR tcb, void* p_work )
{
	FLD_HIDENEFF_CONT* p_cont = p_work;

	switch( p_cont->seq ){
	case 0:
		if( HideEndCheckFunc[ p_cont->effect_type ]( p_cont->p_work ) == TRUE ){
			p_cont->seq ++;
		}
		break;
	
	case 1:
		HideDeleteFunc[ p_cont->effect_type ]( p_cont->p_work );
		*p_cont->p_retwk = 1;
		sys_FreeMemoryEz( p_cont );
		TCB_Delete( tcb );
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	qfGtFNgǗ^XN
 *
 *	@param	p_retwk			tOݒ
 *	@param	effect_type		GtFNg^Cv
 *
 *	effect_type
 *		SCR_HIDENEFF_IAIGIRI
 *      SCR_HIDENEFF_IWAKUDAKI
 */
//-----------------------------------------------------------------------------
void ScrCmd_HidenEffContStart( FIELDSYS_WORK* fsys, u16* p_retwk, u32 effect_type, u32 heap )
{
	FLD_HIDENEFF_CONT* p_cont = sys_AllocMemory( heap, sizeof(FLD_HIDENEFF_CONT) );
	memset( p_cont, 0, sizeof(FLD_HIDENEFF_CONT) );
	p_cont->p_work = HideInitFunc[ effect_type ]( fsys );
	p_cont->p_retwk = p_retwk;
	p_cont->effect_type = effect_type;
	*p_retwk = 0;
	TCB_Add( ScrCmd_HidenEffContTask, p_cont, 0 );
}

