//============================================================================================
/**
 * @file	scr_poke.c
 * @bfief	XNvgR}hF|P֘A
 * @author	Tomomichi Ohta
 * @date	06.06.26
 */
//============================================================================================
#include "common.h"

#include <nitro/code16.h> 
#include "system/pm_str.h"
#include "system\msgdata.h"			//MSGMAN_GetString
#include "system/brightness.h"		//ChangeBrightnessRequest
#include "system\wordset.h"			//WordSet_RegistPlayerName
#include "system/bmp_menu.h"
#include "system/bmp_list.h"
#include "system/get_text.h"
#include "system/window.h"
#include "system/fontproc.h"
#include "system/pms_data.h"
#include "system/wipe.h"
#include "system/placename.h"

#include "system/lib_pack.h"
#include "fieldsys.h"

#include "script.h"
#include "scrcmd_def.h"
#include "field/eventflag.h"
#include "field/evwkdef.h"
#include "sysflag.h"
#include "syswork.h"

#include "poketool/boxdata.h"

#include "..\application\p_status\ribbon.h"

#include "vm.h"
#include "scrcmd.h"
#include "script.h"
#include "scr_tool.h"
#include "ev_win.h"
#include "ev_time.h"

#include "battle/attr_def.h"
#include "zonedata.h"

#include "d_print.h"
#include "sodateya.h"

#include "ev_pokemon.h"				//EvPoke_Add
#include "poketool/poke_memo.h"

#include "scr_poke.h"
#include "msgdata/msg_place_name_tokusyu.h"
#include "itemtool/itemsym.h"
#include "itemtool/itemequip.h"
#include "itemtool/item.h"


//============================================================================================
//
//	R}h
//
//============================================================================================
//--------------------------------------------------------------------------------------------
/**
 * |P莝ɉ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdAddPokemon(VM_MACHINE * core)
{
	int place_id = ZoneData_GetPlaceNameID(core->fsys->location->zone_id);
	int ground_id = GROUND_ID_ALL;
	POKEPARTY * temoti;
	FIELDSYS_WORK * fsys	= core->fsys;
	u16 monsno				= VMGetWorkValue(core);
	u16 lv					= VMGetWorkValue(core);
	u16 itemno				= VMGetWorkValue(core);
	u16* ret_wk				= VMGetWork( core );

	//06.05.19
	//AGB̃|Pǉ́A莝ς̎́A{bNXɓ]悤ɂȂĂāA
	//ǂɒǉ(ǉłȂ)߂lɂȂĂ

	temoti = SaveData_GetTemotiPokemon(fsys->savedata);
	*ret_wk = EvPoke_Add(HEAPID_WORLD, fsys->savedata, monsno, lv, itemno, place_id, ground_id);

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 *	莝̈ʒuio[A|Pԍ֕ϊ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdTemotiMonsNo(VM_MACHINE * core)
{
	FIELDSYS_WORK * fsys	= core->fsys;
	POKEMON_PARAM * poke;
	u16* in_wk				= VMGetWork( core );
	u16* out_wk				= VMGetWork( core );

	//|Pւ̃|C^擾
	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), *in_wk);

	//X^[ԍ擾
	if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) == 0 ){
		*out_wk = PokeParaGet(poke,ID_PARA_monsno,NULL);
	}else{	//^}S
		*out_wk = 0;
	}

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 *	莝|P̂ll`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdMonsOwnChk(VM_MACHINE * core)
{
	FIELDSYS_WORK * fsys	= core->fsys;
	POKEMON_PARAM * poke;
	MYSTATUS* my		= SaveData_GetMyStatus( GameSystem_GetSaveData(core->fsys) );
	u16* in_wk				= VMGetWork( core );
	u16* out_wk				= VMGetWork( core );
	u16 poke_id,my_id;

	//|Pւ̃|C^擾
	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), *in_wk);

	//|PID
	poke_id = PokeParaGet( poke, ID_PARA_id_no, NULL );

	my_id = MyStatus_GetID(my);

	if(poke_id == my_id){	//v
		*out_wk = 0;
	}else{					//sv
		*out_wk = 1;
	}

	return 0;
}


//--------------------------------------------------------------------------------------------
/**
 * ^}S莝ɉ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdAddTamago(VM_MACHINE * core)
{
	int index;
	u8	max;
	BOOL result;
	POKEPARTY * temoti;
	POKEMON_PARAM* poke_param;
	FIELDSYS_WORK * fsys	= core->fsys;
	MYSTATUS	  * my      = SaveData_GetMyStatus(fsys->savedata);
	u16 monsno				= VMGetWorkValue(core);
	u16 msgid				= VMGetWorkValue(core);

	temoti = SaveData_GetTemotiPokemon(fsys->savedata);

	max = PokeParty_GetPokeCount(temoti);
	if(max<6){		//Ô߁B|Pő吔̂ƂɌĂ΂Ă΂Ȃ悤
		poke_param = PokemonParam_AllocWork(HEAPID_WORLD);
		PokeParaInit(poke_param);

		index = PlaceName_IndexToParamNumber( PLACENAME_TYPE_GAME_EVENT, msgid );
		OS_Printf( "msgid = %d\n", msgid );
		OS_Printf( "index = %d\n", index );
		PokemonTamagoSet_forEvent(poke_param,monsno,1, my, TRMEMO_SODATEYA_PLACESET, index);

		result = PokeParty_Add(temoti, poke_param);
		sys_FreeMemoryEz(poke_param);
	}
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * 莝|P̋Zu
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdChgPokeWaza( VM_MACHINE * core )
{
	u16 poke_pos, waza_pos, waza_no;
	poke_pos = VMGetWorkValue(core);
	waza_pos = VMGetWorkValue(core);
	waza_no = VMGetWorkValue(core);
	EvPoke_ChangeWaza(SaveData_GetTemotiPokemon(core->fsys->savedata),
			poke_pos, waza_pos, waza_no);

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * 莝|Pw肳ꂽZoĂ邩`FbNiṔj
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdChkPokeWaza( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys	= core->fsys;
	POKEMON_PARAM * poke;
	u16* ret_wk	= VMGetWork( core );
	u16 waza	= VMGetWorkValue(core);
	u16 tno		= VMGetWorkValue(core);
	u16 my_waza;

	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), tno);

	*ret_wk = 0;
	//܂`FbN
	if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) != 0 ){
		return 0;
	}

	//UXg`FbN
	if( (PokeParaGet( poke, ID_PARA_waza1, NULL ) == waza) ||(PokeParaGet( poke, ID_PARA_waza2, NULL ) == waza) ||(PokeParaGet( poke, ID_PARA_waza3, NULL ) == waza) ||(PokeParaGet( poke, ID_PARA_waza4, NULL ) == waza) ){
		*ret_wk = 1;
	}

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * 莝|Pw肳ꂽZoĂ邩`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdChkPokeWazaGroup( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys	= core->fsys;
	POKEMON_PARAM * poke;
	u16* ret_wk	= VMGetWork( core );
	u16 waza	= VMGetWorkValue(core);
	u16 my_waza;
	u8	i,max;

	max = PokeParty_GetPokeCount(SaveData_GetTemotiPokemon(fsys->savedata));

	for( i=0, *ret_wk=6 ; i<max; i++ ){
		poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), i);

		//܂`FbN
		if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) != 0 ){
			continue;
		}

		//UXg`FbN
		if( (PokeParaGet( poke, ID_PARA_waza1, NULL ) == waza) ||(PokeParaGet( poke, ID_PARA_waza2, NULL ) == waza) ||(PokeParaGet( poke, ID_PARA_waza3, NULL ) == waza) ||(PokeParaGet( poke, ID_PARA_waza4, NULL ) == waza) ){
			*ret_wk = i;		//Ă|P̃Xg̕тԂ
			break;
		}

	}

	return	0;
}

//--------------------------------------------------------------------------------------------
/**
 * |PłŎ񂾂ǂ̔F
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdApprovePoisonDead(VM_MACHINE * core)
{
	POKEMON_PARAM * pp;
	u16 num;
	u16 * ret_wk;
	ret_wk = VMGetWork(core);
	num = VMGetWorkValue(core);
	pp = PokeParty_GetMemberPointer(SaveData_GetTemotiPokemon(core->fsys->savedata), num);
	*ret_wk = EvPoke_ApprovePoisonDead(pp);
	OS_Printf("POS:%d RESULT:%d\n",num, *ret_wk);
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 *	莝|P̃x`FbNi̐)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdPokeLevelChk(VM_MACHINE * core)
{
	FIELDSYS_WORK* fsys = core->fsys;
	POKEMON_PARAM * poke;
	u16* ret_wk			= VMGetWork( core );
	u16 level			= VMGetWorkValue( core );
	u8 i,max,ct;

	max = PokeParty_GetPokeCount(SaveData_GetTemotiPokemon(fsys->savedata));

	*ret_wk = 0;
	for(i=0,ct=0;i<max;i++){
		poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), i);

		//X^[ԍ擾(0ȊOȂ^}Sj
		if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) == 0 ){

			//ȉ̃|P邩`FbN
			if( PokeParaGet( poke, ID_PARA_level, NULL ) <= level ){
				ct++;
			}

		}
	}

	*ret_wk = ct;

	return 0;

}

//--------------------------------------------------------------------------------------------
/**
 *	莝|P̃x擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdPokeLevelGet(VM_MACHINE * core)
{
	FIELDSYS_WORK* fsys = core->fsys;
	POKEMON_PARAM * poke;
	u16* ret_wk			= VMGetWork( core );
	u16 tno			= VMGetWorkValue( core );

	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), tno);

	*ret_wk = 0;
	if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) == 0 ){
		*ret_wk = PokeParaGet( poke, ID_PARA_level, NULL );
	}

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * iQbg
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdGetPokeSeikaku(VM_MACHINE * core)
{
	FIELDSYS_WORK * fsys	= core->fsys;
	POKEMON_PARAM * poke;
	u16* ret_wk	= VMGetWork( core );
	u16 tno	= VMGetWorkValue(core);
	u8 max;

	max = PokeParty_GetPokeCount(SaveData_GetTemotiPokemon(fsys->savedata));

	if(tno >= max) {		//Ă|Pȏ̔ԍ̂Ƃ
		*ret_wk = 0;
		return 0;
	}

	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), tno);

	//^}S`FbN
	if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) != 0 ){
		*ret_wk = 0;
		return 0;
	}

	//i擾
	*ret_wk = PokeSeikakuGet(poke);

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ̐ĩ|P邩`FbN
 * 0xff:Ȃ 0`5:莝ԍ
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdChkPokeSeikakuAll(VM_MACHINE * core)
{
	FIELDSYS_WORK * fsys	= core->fsys;
	POKEMON_PARAM * poke;
	u16* ret_wk	= VMGetWork( core );
	u16 seikaku_no	= VMGetWorkValue(core);
	u8 max,i;

	max = PokeParty_GetPokeCount(SaveData_GetTemotiPokemon(fsys->savedata));

	*ret_wk = 0xff;
	for(i=0;i<max;i++){
		poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), i);

		//^}SłȂƂ̂݃`FbN
		if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) == 0 ){
			//i`FbN
			if(PokeSeikakuGet(poke) == seikaku_no){
				*ret_wk = i;
				break;
			}
		}

	}

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * Ȃx̎擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdGetNatsuki( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	POKEMON_PARAM * poke;
	u16* ret_wk			= VMGetWork( core );
	u16 tno	= VMGetWorkValue(core);

	//|Pւ̃|C^擾
	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), tno);

	//|P̂Ȃx擾
	*ret_wk = PokeParaGet( poke, ID_PARA_friend, NULL );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * Ȃx𑝂₷
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdAddNatsuki( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	POKEMON_PARAM * poke;
	u16 add_value			= VMGetWorkValue( core );
	u16 tno	= VMGetWorkValue(core);
	u16 value;
	u32 place_id = ZoneData_GetPlaceNameID(core->fsys->location->zone_id);

	//|Pւ̃|C^擾
	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), tno);

	//|P̂Ȃx擾
	value = PokeParaGet( poke, ID_PARA_friend, NULL );

#if 0
	value += add_value;
	if(value > 255) {			//ȂxMax=255
		value = 255;
	}
#else
	if( add_value > 0 ){
		// 
		if( ItemParamGet(PokeParaGet(poke,ID_PARA_item,NULL),ITEM_PRM_EQUIP,HEAPID_WORLD) == SOUBI_NATUKIDOUP ){
			add_value = add_value * 150 / 100;
		}
		// ߊl{[
		if( PokeParaGet( poke, ID_PARA_get_ball, NULL ) == ITEM_GOOZYASUBOORU ){
			add_value++;
		}
		// ߊlꏊ
		if( PokeParaGet( poke, ID_PARA_get_place, NULL ) == place_id ){
			add_value++;
		}
	}

	value += add_value;
	if( value > FRIEND_MAX ){
		value = FRIEND_MAX;
	}
#endif

	//|P̂ȂxZbg
	PokeParaPut( poke, ID_PARA_friend, &value );
	return 0;
}


//--------------------------------------------------------------------------------------------
/**
 * Ȃx炷
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdSubNatsuki( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	POKEMON_PARAM * poke;
	u16 sub_value			= VMGetWorkValue( core );
	u16 tno	= VMGetWorkValue(core);
	u16 value;

	//|Pւ̃|C^擾
	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), tno);

	//|P̂Ȃx擾
	value = PokeParaGet( poke, ID_PARA_friend, NULL );

	if(sub_value > value) {
		value = 0;
	}else{
		value -= sub_value;
	}

	//|P̂ȂxZbg
	PokeParaPut( poke, ID_PARA_friend, &value );
	return 0;
}


//--------------------------------------------------------------------------------------------
/**
 * 莝|P̃ReXgXe[^X擾(悳A킢)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdTemotiPokeContestStatusGet( VM_MACHINE * core )
{
	POKEMON_PARAM * poke;
	u16 pos		= VMGetWorkValue( core );
	u16 con_type = VMGetWorkValue( core );
	u16* ret_wk	= VMGetWork( core );

	//|Pւ̃|C^擾
	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(core->fsys->savedata), pos );

	*ret_wk = PokeParaGet(poke, ID_PARA_style + con_type, NULL);
	return 0;
}

//-----------------------------------------------------------------------------
/**
 *	擪̃|PԂi^}S𔲂j
 */
//-----------------------------------------------------------------------------
BOOL EvCmdFrontPokemon(VM_MACHINE * core)
{
	u16* ret_wk			= VMGetWork( core );

	*ret_wk = GetFrontPokemon(core->fsys->savedata);

	return 0;
}

//-----------------------------------------------------------------------------
/**
 *	莝|P̃^Cv擾
 */
//-----------------------------------------------------------------------------
BOOL EvCmdTemotiPokeType(VM_MACHINE * core)
{
	FIELDSYS_WORK * fsys	= core->fsys;
	POKEMON_PARAM * poke;
	u16* ret_wk1				= VMGetWork( core );
	u16* ret_wk2				= VMGetWork( core );
	u16 tno		= VMGetWorkValue(core);

	//|Pւ̃|C^擾
	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), tno);

	*ret_wk1 = PokeParaGet( poke, ID_PARA_type1, NULL );
	*ret_wk2 = PokeParaGet( poke, ID_PARA_type2, NULL );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * |P擾
 * @brief   莝̃|P𒲂ׂĕԂ
 * 
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdGetPokeCount( VM_MACHINE * core )
{
	int max;
	POKEMON_PARAM * poke;
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= VMGetWork( core );

	max = PokeParty_GetPokeCount(SaveData_GetTemotiPokemon(fsys->savedata));

	//A^}Sɂďo͂𕪂邩

	*ret_wk = max;

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * |P擾(^}Sj
 * @brief   莝̃|P𒲂ׂĕԂ
 * 
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdGetPokeCount2( VM_MACHINE * core )
{
	int max,poke_max,i;
	POKEMON_PARAM * poke;
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= VMGetWork( core );

	max = PokeParty_GetPokeCount(SaveData_GetTemotiPokemon(fsys->savedata));

	for(i=0,poke_max=0;i<max;i++){
		poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), i);

		//X^[ԍ擾(0ȊOȂ^}SȂj
		if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) == 0 ){
			poke_max++;
		}
	}

	*ret_wk = poke_max;

	return 0;
}


//--------------------------------------------------------------------------------------------
/**
 * |P擾(^}Sƕmj
 * @brief   莝̃|P𒲂ׂĕԂ(퓬\ȃ|P)
 *	no = 莝ԍ(6:ȂA0`5)
 * 
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdGetPokeCount3( VM_MACHINE * core )
{
	int max,poke_max,i;
	POKEMON_PARAM * poke;
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= VMGetWork( core );
	u16 no			= VMGetWorkValue( core );

	max = PokeParty_GetPokeCount(SaveData_GetTemotiPokemon(fsys->savedata));

	for(i=0,poke_max=0;i<max;i++){
		if(i==no) continue;
		poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), i);
		//X^[ԍ擾(0ȊOȂ^}SȂj
		if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) == 0 ){
			//mO`FbN(0==m)
			if( PokeParaGet( poke,ID_PARA_hp , NULL ) != 0 ){
				poke_max++;
			}
		}
	}

	*ret_wk = poke_max;

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * |Pi莝{{bNXj擾(^}SƁA莝̕mj
 *
 * ݎgpĂ܂
 * 
 * @brief   莝̃|P𒲂ׂĕԂ
 * 
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdGetPokeCount4( VM_MACHINE * core )
{
	int max,poke_max,i;
	POKEMON_PARAM * poke;
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= VMGetWork( core );
	BOX_DATA* boxDat = SaveData_GetBoxData( fsys->savedata );

	max = PokeParty_GetPokeCount(SaveData_GetTemotiPokemon(fsys->savedata));

	for(i=0,poke_max=0;i<max;i++){
		poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), i);

		//X^[ԍ擾(0ȊOȂ^}SȂj
		if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) == 0 ){
			//mO`FbN(0==m)
			if( PokeParaGet( poke,ID_PARA_hp , NULL ) != 0 ){
				poke_max++;
			}
		}
	}

	poke_max += BOXDAT_GetPokeExistCount2Total( boxDat );

	*ret_wk = poke_max;

	return 0;
}


//--------------------------------------------------------------------------------------------
/**
 * ^}S擾
 * @brief   莝̃|P𒲂ׂĕԂ
 * 
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdGetTamagoCount( VM_MACHINE * core )
{
	int max,tamago_max,i;
	POKEMON_PARAM * poke;
	FIELDSYS_WORK* fsys = core->fsys;
	u16* ret_wk			= VMGetWork( core );

	max = PokeParty_GetPokeCount(SaveData_GetTemotiPokemon(fsys->savedata));

	for(i=0,tamago_max=0;i<max;i++){
		poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), i);

		//^}S擾
		if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL )){
//ꍇɂẮA_^}S`FbN邩idlɂj
			tamago_max++;
		}
	}

	*ret_wk = tamago_max;

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * 莝|P̃|PXւ̊`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdChkTemotiPokerus( VM_MACHINE * core )
{
	u16 i, max;
	u16 * wk;
	u32 pokerus;
	POKEMON_PARAM * poke;
	FIELDSYS_WORK* fsys = core->fsys;

	wk = VMGetWork( core );


	max = PokeParty_GetPokeCount(SaveData_GetTemotiPokemon(fsys->savedata));

	//|PXĂ邩check
	*wk = 0;
	for(i=0;i<max;i++){
		//|Pւ̃|C^擾
		poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), i);

		pokerus = PokeParaGet(poke, ID_PARA_pokerus, NULL);

		if(pokerus!=0){
			*wk = 1;
			break;
		}
	}

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * 莝|P̐ʎ擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdTemotiPokeSexGet( VM_MACHINE * core )
{
	POKEMON_PARAM * poke;
	u16 pos		= VMGetWorkValue( core );
	u16* ret_wk	= VMGetWork( core );

	//|Pւ̃|C^擾
	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(core->fsys->savedata), pos );

	*ret_wk = PokeParaGet(poke, ID_PARA_sex, NULL);
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	ZY֘AFĂZJEg
 * @param	core		z}V\̂ւ̃|C^
 * @return	0
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdWazaCount( VM_MACHINE * core )
{
	FIELDSYS_WORK * fsys	= core->fsys;
	POKEMON_PARAM * poke;
	u16* ret_wk	= VMGetWork( core );
	u16 t_no	= VMGetWorkValue( core );
	u8 i;

	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), t_no);

	//܂`FbN
	if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) != 0 ){
		*ret_wk =0;
		return 0;
	}

	i=0;
	if( (PokeParaGet( poke, ID_PARA_waza1, NULL ) != 0)){
		i++;
	}

	if( (PokeParaGet( poke, ID_PARA_waza2, NULL ) != 0)){
		i++;
	}

	if( (PokeParaGet( poke, ID_PARA_waza3, NULL ) != 0)){
		i++;
	}

	if( (PokeParaGet( poke, ID_PARA_waza4, NULL ) != 0)){
		i++;
	}

	*ret_wk = i;
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	ZY֘AFU
 * @param	core		z}V\̂ւ̃|C^
 * @return	0
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdWazaDel( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	POKEMON_PARAM * poke;
	u32	buf;
	u8 i;

	u16 t_num = VMGetWorkValue(core);
	u16 w_num = VMGetWorkValue(core);

	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), t_num);

	PokeParaWazaDelPos(poke,w_num);

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 *@莝̂킴ԍA킴ԍ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdTemotiWazaNo( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	POKEMON_PARAM * poke;

	u16* ret_wk	= VMGetWork( core );
	u16 t_num = VMGetWorkValue(core);
	u16 w_num = VMGetWorkValue(core);

	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), t_num);

	*ret_wk = PokeParaGet( poke, ID_PARA_waza1+w_num, NULL );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 *	[Ă邩`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdPokeMailChk(VM_MACHINE * core)
{
	FIELDSYS_WORK* fsys = core->fsys;
	POKEMON_PARAM * poke;
	u16* ret_wk	= VMGetWork( core );
	u16 tno	= VMGetWorkValue(core);

	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), tno);
	*ret_wk = PokeParaGet(poke, ID_PARA_item, NULL);

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 *	Ă郁[폜
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdPokeMailDel(VM_MACHINE * core)
{
	FIELDSYS_WORK* fsys = core->fsys;
	POKEMON_PARAM * poke;
	u16 tno	= VMGetWorkValue(core);
	u16 itemno;

	poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), tno);

	itemno = 0;	//ĂȂԂ
	PokeParaPut( poke, ID_PARA_item, &itemno );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 *@莝ɓ̃|P邩`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdTemotiPokeChk( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	POKEMON_PARAM * poke;
	POKEPARTY * temoti;
	u16* ret_wk	= VMGetWork( core );
	u16		num = VMGetWorkValue(core);
	u8 i,max;
	u16 poke_no;

	temoti = SaveData_GetTemotiPokemon(fsys->savedata);
	max = PokeParty_GetPokeCount(temoti);

	*ret_wk = FALSE;
	for(i=0;i<max;i++){
		//|Pւ̃|C^擾
		poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), i);

		//^}S͏O
		if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) == 0 ){
			//|Pio[擾
			poke_no = PokeParaGet( poke, ID_PARA_monsno, NULL );

			if(num == poke_no){		//v
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łł́Aw肳ꂽ|P̕шʒuԂiȂꍇ͍lȂj
#ifdef PG5_TRIAL
				*ret_wk = i;
#else
				*ret_wk = TRUE;
#endif
// ----------------------------------------------------------------------------
				break;
			}
		}

	}

	return 0;
}

//-----------------------------------------------------------------------------
/**
 *	u{v̎擾iP|Pj
 *	
 */
//-----------------------------------------------------------------------------

BOOL EvCmdChkRibbonCount(VM_MACHINE * core)
{
	POKEMON_PARAM * pp;
	u16* ret_wk	= VMGetWork( core );
	u16		tno	= VMGetWorkValue(core);
	u16 i,cnt;

	pp = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(core->fsys->savedata), tno);

	for(i=0,cnt=0;i<RIBBON_MAX;i++){
		if(PokeParaGet(pp, RIBBON_DataGet(i, RIBBON_PARA_POKEPARA ), NULL) != 0){
			cnt++;
		}
	}

	*ret_wk = cnt;

	return 0;
}

//-----------------------------------------------------------------------------
/**
 *	u{v̎擾iS莝|Pv̎ށj
 *	
 */
//-----------------------------------------------------------------------------

BOOL EvCmdChkRibbonCountAll(VM_MACHINE * core)
{
	POKEMON_PARAM * pp;
	POKEPARTY * temoti;
	u16* ret_wk	= VMGetWork( core );
	u16 i,j,cnt,max;

	max = PokeParty_GetPokeCount(SaveData_GetTemotiPokemon(core->fsys->savedata));

	//poke party擾
	temoti = SaveData_GetTemotiPokemon(core->fsys->savedata);

	for(i=0,cnt=0;i<RIBBON_MAX;i++){
		for(j=0;j<max;j++){
			pp = PokeParty_GetMemberPointer( temoti, j);
			//^}S`FbN
			if( PokeParaGet( pp, ID_PARA_tamago_flag, NULL ) != 0 ){
				break;
			}

			if(PokeParaGet(pp, RIBBON_DataGet(i, RIBBON_PARA_POKEPARA ), NULL) != 0){
				cnt++;
				break;
			}

		}
	}

	*ret_wk = cnt;

	return 0;
}

//-----------------------------------------------------------------------------
/**
 *	u{vĂ邩
 *	0:Ȃ@1:
 */
//-----------------------------------------------------------------------------
BOOL EvCmdChkRibbon(VM_MACHINE * core)
{
	POKEMON_PARAM * pp;
	u16* ret_wk	= VMGetWork( core );
	u16		tno	= VMGetWorkValue(core);
	u16		rno	= VMGetWorkValue(core);
	u8	flag = 1;

	pp = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(core->fsys->savedata), tno);

	*ret_wk = PokeParaGet(pp, RIBBON_DataGet(rno, RIBBON_PARA_POKEPARA ), NULL);

	return 0;
}

//-----------------------------------------------------------------------------
/**
 *	u{vZbg
 */
//-----------------------------------------------------------------------------
BOOL EvCmdSetRibbon(VM_MACHINE * core)
{
	POKEMON_PARAM * pp;
	u16		tno	= VMGetWorkValue(core);
	u16		rno	= VMGetWorkValue(core);
	u8	flag = 1;

	pp = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(core->fsys->savedata), tno);

	PokeParaPut(pp, RIBBON_DataGet(rno, RIBBON_PARA_POKEPARA ), &flag);
	return 0;
}

//-----------------------------------------------------------------------------
/**
 *@_^}S`FbNS̔(莝ɂ:TRUE,Ȃ:FALSE)
 */
//-----------------------------------------------------------------------------
BOOL EvCmdDameTamagoChkAll(VM_MACHINE * core)
{

	POKEMON_PARAM * pp;
	POKEPARTY * temoti;
	u16* ret_wk	= VMGetWork( core );
	u16 i,j,max;

	max = PokeParty_GetPokeCount(SaveData_GetTemotiPokemon(core->fsys->savedata));

	//poke party擾
	temoti = SaveData_GetTemotiPokemon(core->fsys->savedata);

	//dlA_^}S@@^}S_^}StOĂ
	for(i=0;i<RIBBON_MAX;i++){
		for(j=0;j<max;j++){
			pp = PokeParty_GetMemberPointer( temoti, j);
			if( PokeParaGet( pp, ID_PARA_tamago_flag, NULL ) != 0 ){			//^}S`FbN
				if( PokeParaGet( pp, ID_PARA_fusei_tamago_flag, NULL ) != 0 ){	//_^}S`FbN
					*ret_wk = TRUE;
					return 0;

				}
			}
		}
	}

	*ret_wk = FALSE;

	return 0;
}

//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
//gp
BOOL EvCmdGetTemotiPokeNum( VM_MACHINE * core )
{

	return 0;
}

//============================================================================================
//============================================================================================
