//============================================================================================
/**
 * @file	scr_sound.c
 * @bfief	XNvgR}hFTEh֘A
 * @author	Satoshi Nohara
 * @date	06.06.26
 */
//============================================================================================
#include "common.h"
#include "system/lib_pack.h"
#include "fieldsys.h"

#include "script.h"
#include "scrcmd_def.h"
#include "field/eventflag.h"
#include "field/evwkdef.h"
#include "sysflag.h"
#include "syswork.h"

#include "savedata/perapvoice.h"
#include "system/snd_tool.h"
#include "system/snd_perap.h"
#include "fld_bgm.h"


//============================================================================================
//
//	vg^Cv錾
//
//============================================================================================
static BOOL EvWaitBgmFade( VM_MACHINE * core );
static BOOL EvWaitSe(VM_MACHINE * core);
static BOOL EvWaitVoicePlay(VM_MACHINE * core);
static BOOL EvWaitMe( VM_MACHINE * core );

BOOL EvCmdBgmPlay(VM_MACHINE * core );
BOOL EvCmdBgmStop(VM_MACHINE * core );
BOOL EvCmdBgmNowMapPlay(VM_MACHINE * core );
BOOL EvCmdBgmSpecialSet(VM_MACHINE * core );
BOOL EvCmdBgmFadeOut( VM_MACHINE * core );
BOOL EvWaitBgmFade( VM_MACHINE * core );
BOOL EvCmdBgmFadeIn( VM_MACHINE * core );
BOOL EvCmdBgmPlayerPause( VM_MACHINE * core );
BOOL EvCmdPlayerFieldDemoBgmPlay( VM_MACHINE * core );
BOOL EvCmdCtrlBgmFlagSet( VM_MACHINE * core );
BOOL EvCmdSePlay( VM_MACHINE * core );
BOOL EvCmdSeStop( VM_MACHINE * core );
BOOL EvCmdSeWait(VM_MACHINE * core);
BOOL EvCmdVoicePlay( VM_MACHINE * core );
BOOL EvCmdVoicePlayWait( VM_MACHINE * core );
BOOL EvCmdMePlay(VM_MACHINE * core );
BOOL EvCmdMeWait(VM_MACHINE * core );
BOOL EvCmdPerapDataCheck( VM_MACHINE * core );
BOOL EvCmdPerapRecStart( VM_MACHINE * core );
BOOL EvCmdPerapRecStop( VM_MACHINE * core );
BOOL EvCmdPerapSave( VM_MACHINE * core );
BOOL EvCmdSndClimaxDataLoad( VM_MACHINE * core );
BOOL EvCmdSndInitialVolSet( VM_MACHINE * core );
BOOL EvCmdBgmPlayCheck(VM_MACHINE * core );


//============================================================================================
//
//	R}h
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * BGMI҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdBgmPlayCheck( VM_MACHINE * core )
{
	u16 music	= VMGetU16(core);
	u16* ret_wk	= VMGetWork( core );

	*ret_wk = Snd_BgmPlayCheck( music );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * BGMύX
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdBgmPlay( VM_MACHINE * core )
{
	u16 music = VMGetU16(core);
	Snd_BgmPlay( music );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * BGM~
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdBgmStop( VM_MACHINE * core )
{
	u16 music = VMGetU16(core);	//"gp"
	//Snd_BgmStop( music, 0 );
	Snd_BgmStop( Snd_NowBgmNoGet(), 0 );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ݂̃}bvBGMĐ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdBgmNowMapPlay( VM_MACHINE * core )
{
	int zone_id = core->fsys->location->zone_id;
	//u16 music	= Snd_PcBgmNoGet( core->fsys, Snd_FieldBgmNoGet(core->fsys,zone_id) );
	u16 music	= Snd_FieldBgmNoGetNonBasicBank( core->fsys,zone_id );
	Snd_BgmPlay( music );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * }bvBGMw肪Zbg
 * ]BGM̐ȂǂɎgp
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdBgmSpecialSet( VM_MACHINE * core )
{
	Snd_FieldBgmSetSpecial( core->fsys, VMGetU16(core) );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * BGMtF[hAEg҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	1
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdBgmFadeOut( VM_MACHINE * core )
{
	u16 vol		= VMGetU16(core);
	u16 frame	= VMGetU16(core);
	Snd_BgmFadeOut( vol, frame );
	VM_SetWait( core, EvWaitBgmFade );
	return 1;
}

//return 1 = I
static BOOL EvWaitBgmFade( VM_MACHINE * core )
{
	if( Snd_FadeCheck() == 0 ){
		return TRUE;
	}
	return FALSE;
};

//--------------------------------------------------------------------------------------------
/**
 * BGMtF[hC҂(tF[hAEĝĊJ)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdBgmFadeIn( VM_MACHINE * core )
{
	u16 frame = VMGetU16(core);
	Snd_BgmFadeIn( BGM_VOL_MAX, frame, BGM_FADEIN_START_VOL_MIN );
	VM_SetWait( core, EvWaitBgmFade );
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * V[PXꎞ~܂͍ĊJ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdBgmPlayerPause( VM_MACHINE * core )
{
	u8 player = VMGetU8(core);
	BOOL flag = VMGetU8(core);

	Snd_PlayerPause( player, flag );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * oBGMĐ(CoAT|[gAĂ)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdPlayerFieldDemoBgmPlay( VM_MACHINE * core )
{
	Snd_PlayerFieldDemoBgmPlay( SND_SCENE_FIELD, VMGetU16(core) );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * tB[hBGMŒɂtOZbg(Z[uȂ)
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdCtrlBgmFlagSet( VM_MACHINE * core )
{
	Snd_CtrlBgmFlagSet( VMGetU8(core) );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * rd炷
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdSePlay( VM_MACHINE * core )
{
	Snd_SePlay( VMGetWorkValue(core) );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * rd~߂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdSeStop( VM_MACHINE * core )
{
	Snd_SeStopBySeqNo( VMGetWorkValue(core), 0 );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * SEI҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	1
 *
 * @li		JȂǂ̃[vŁA[vɂȂĂ܂̂ŁASEio[w肵āA`FbNI
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdSeWait(VM_MACHINE * core)
{
	//z}V̔ėpWX^BGMio[i[
	core->reg[0] = VMGetWorkValue(core);

	VM_SetWait( core, EvWaitSe );
	return 1;
}

//return 1 = I
static BOOL EvWaitSe(VM_MACHINE * core)
{
	//if( Snd_SePlayCheckAll() == 0 ){
	if( Snd_SePlayCheck(core->reg[0]) == 0 ){
		return TRUE;
	}

	return FALSE;
};


//--------------------------------------------------------------------------------------------
/**
 * 炷
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdVoicePlay( VM_MACHINE * core )
{
	u16 no, ptn;
	no	= VMGetWorkValue(core);
	ptn = VMGetWorkValue(core);

	//؃bvĐeXg
	//no = MONSNO_PERAPPU;

	//p^[wł֐ɒu\
	Snd_PMVoicePlay( no );
	return 0;
};

//--------------------------------------------------------------------------------------------
/**
 * I҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	1
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdVoicePlayWait( VM_MACHINE * core )
{
	VM_SetWait( core, EvWaitVoicePlay );
	return 1;
}

//return 1 = I
static BOOL EvWaitVoicePlay(VM_MACHINE * core)
{
	if( Snd_PMVoicePlayCheck() == 0 ){
		return 1;
	}
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * MEĐ
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdMePlay(VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;
	Snd_MePlay( VMGetU16(core) );
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * MEI҂
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdMeWait(VM_MACHINE * core )
{
	VM_SetWait( core, EvWaitMe );
	return 1;
}

//return 1 = I
static BOOL EvWaitMe( VM_MACHINE * core )
{
	FIELDSYS_WORK* fsys = core->fsys;

	//I҂̂
	//if( Snd_MePlayCheck() == 0 ){
	
	//I҂{EFCg[N҂
	if( Snd_MePlayCheckBgmPlay() == 0 ){ 
		return TRUE;
	}

	return FALSE;
};

//--------------------------------------------------------------------------------------------
/**
 * ybvf[^邩`FbN
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdPerapDataCheck( VM_MACHINE * core )
{
	u16* ret_wk	= VMGetWork( core );

	if( Snd_PerapVoiceCheck(SaveData_GetPerapVoice(core->fsys->savedata)) == TRUE ){
		*ret_wk = TRUE;
		return 0;
	}

	*ret_wk = FALSE;
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ybv^Jn
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdPerapRecStart( VM_MACHINE * core )
{
	u16* ret_wk			= VMGetWork( core );

	if( Snd_PerapVoiceRecStart() == MIC_RESULT_SUCCESS ){
		*ret_wk = TRUE;	//
		return 0;
	}

	*ret_wk = FALSE;	//s
	return 0;

}

//--------------------------------------------------------------------------------------------
/**
 * ybv^~
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdPerapRecStop( VM_MACHINE * core )
{
	Snd_PerapVoiceRecStop();
	return 1;

}

//--------------------------------------------------------------------------------------------
/**
 * ybv^f[^Z[u
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdPerapSave( VM_MACHINE * core )
{
	Snd_PerapVoiceDataSave( SaveData_GetPerapVoice(core->fsys->savedata) );
	return 1;

}

//--------------------------------------------------------------------------------------------
/**
 * NC}bNXoTEhf[^ǉ[h
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"1"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdSndClimaxDataLoad( VM_MACHINE * core )
{
	Snd_DataSetByScene( SND_SCENE_SUB_CLIMAX, 0, 0 );	//TEhf[^[h(BGMp)
	return 1;
}

//--------------------------------------------------------------------------------------------
/**
 * {[Zbg
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	"0"
 */
//--------------------------------------------------------------------------------------------
BOOL EvCmdSndInitialVolSet( VM_MACHINE * core )
{
	u16 no	= VMGetWorkValue(core);
	u16 vol = VMGetWorkValue(core);

	Snd_PlayerSetInitialVolumeBySeqNo( no, vol );
	return 0;
}


