//============================================================================================
/**
 * @file	script.c
 * @bfief	XNvg䃁C
 * @author	Satoshi Nohara
 * @date	05.08.04
 *
 * 01.11.07	Sousuke Tamada
 * 03.04.15	Satoshi Nohara
 * 05.04.25 Hiroyuki Nakamura
 */
//============================================================================================
#include "common.h"
#include "gflib/msg_print.h"						//STRCODE
#include "system\msgdata.h"							//MSGMAN_TYPE_DIRECT
#include "system\bmp_menu.h"
#include "system/bmp_list.h"
#include "system/pm_str.h"
#include "system/wordset.h"							//WORDSET_Create
#include "system/clact_tool.h"
#include "system/debug_flag.h"

#include "fieldsys.h"
#include "zonedata.h"
#include "sxy.h"
#include "field_clact.h"
#include "fld_menu.h"								//FieldMenuEvChg

#include "system/arc_tool.h"
#include "../fielddata/script/scr_seq.naix"
#include "msgdata\msg.naix"							//NARC_msg_??_dat

#include "field/eventflag.h"
#include "field/evwkdef.h"
#include "vm.h"
#include "scrcmd.h"
#include "script.h"
#include "script_def.h"								//SP_SCRID_SCENE_CHANGE
//#include "scr_tool.h"								//HideItemParamSet
#include "ev_win.h"
#include "report.h"

#include "itemtool/itemsym.h"						//ITEM_KIZUGUSURI
#include "eventdata.h"

#include "battle/battle_common.h"					//CN[hɕKv
#include "poketool/tr_tool.h"						//TT_TrainerDataParaGet

#include "../fielddata/script/init_scr_def.h"		//SCRID_INIT_SCRIPT

#ifdef PM_DEBUG
#include "../fielddata/script/debug_scr_def.h"
#endif


//============================================================================================
//
//	fobN
//
//============================================================================================
//VM_CODE* sp_script;


//============================================================================================
//
//	XNvgIDItZbg
//
//============================================================================================
#include "scr_offset.h"


//============================================================================================
//
//	`
//
//============================================================================================
#define SCR_MSG_BUF_SIZE	(1024)					//bZ[Wobt@TCY

typedef void (*fsysFunc)(FIELDSYS_WORK* fsys);		//֐|C^^

//g[i[f[^\
typedef struct {
	int range;						//
	int dir;						//ړ
	int scr_id;						//XNvgID
	int tr_id;						//g[i[ID
	int tr_type;					//g[i[^Cv
	FIELD_OBJ_PTR fldobj;			//
	TCB_PTR	tcb;					//TCB
}EV_TRAINER_EYE_HITDATA;

#define TRAINER_EYE_HITMAX (2)

//XNvg䃏[N\
struct _EV_SCRIPT_WORK{
	u32 magic_no;					//Cxg̃[NXNvg䃏[N𔻕
	u8 seq;							//
	u8 MsgIndex;					//bZ[WCfbNX
	u8 anm_count;					//Aj[VĂ鐔
	u8 common_scr_flag;				//[JEʃXNvg؂ւtO(0=[JA1=)
	u8 win_open_flag;				//bEBhEJtO(0=JĂȂA1=J)
	u8 vm_machine_count;			//ǉz}V̐
	u16 script_id;					//C̃XNvgID
	BOOL win_flag;					///<퓬ʕێp[N

	//CxgEBhE
	EV_WIN_WORK* ev_win;			//CxgEBhE[Nւ̃|C^

	//bEBhE
	GF_BGL_BMPWIN MsgWinDat;		//rbg}bvEBhEf[^
	BMPMENU_WORK* mw;				//rbg}bvj[[N

	int player_dir;					//CxgN̎ľ
	FIELD_OBJ_PTR target_obj;		//bΏۂOBJ̃|C^
	FIELD_OBJ_PTR dummy_obj;		//_~[OBJ̃|C^

	u16* ret_script_wk;				//XNvgʂ郏[Ñ|C^
	VM_MACHINE *vm[VM_MACHINE_MAX];	//z}Vւ̃|C^

	WORDSET* wordset;				//PZbg
	STRBUF* msg_buf;				//bZ[Wobt@|C^
	STRBUF* tmp_buf;				//e|obt@|C^
	void * waiticon;				///<ҋ@ACR̃|C^
	
	EV_TRAINER_EYE_HITDATA eye_hitdata[TRAINER_EYE_HITMAX];	//g[i[

	u16 work[EVSCR_WORK_MAX];		//[N(ANSWORK,TMPWORKȂǂ̑)

	fsysFunc next_func;				//XNvgIɌĂяo֐

	void * subproc_work;			//TuvZXƂ̂ƂɎgp郏[Nւ̃|C^
	void* pWork;					//[Nւ̔ėp|C^
	EOA_PTR eoa;					//ɃtB[hGtFNg̃|C^ƂĎg

	TCB_PTR player_tcb;				//@`ԃ|[gTCB

	GF_BGL_BMPWIN CoinWinDat;		//rbg}bvEBhEf[^
	GF_BGL_BMPWIN GoldWinDat;		//rbg}bvEBhEf[^

	REPORT_INFO * riw;				///<|[gpEBhE䃏[N
};

enum{
	WORDSET_SCRIPT_SETNUM = 8,		//ftHgobt@
	WORDSET_SCRIPT_BUFLEN = 64,		//ftHgobt@ij
};

//============================================================================================
//
//	BACef[^
//
//============================================================================================
typedef struct{
	u16 itemno;											//ACeio[
	u8	num;											//
	u8	response;										//x
	u16	sp;												//(gp)
	u16	index;											//tOCfbN
}HIDE_ITEM_DATA;
#include "../fielddata/script/hide_item.dat"			//BACef[^


//============================================================================================
//
//	vg^Cv錾
//
//============================================================================================
void EventSet_Script( FIELDSYS_WORK * fsys, u16 scr_id, FIELD_OBJ_PTR obj );
void EventCall_Script( GMEVENT_CONTROL* event, u16 scr_id, FIELD_OBJ_PTR obj, void* ret_script_wk );
static BOOL GMEVENT_ControlScript(GMEVENT_CONTROL * event);
static EV_SCRIPT_WORK* EvScriptWork_Alloc();
static void script_del( VM_MACHINE* core );
static void EvScriptWork_Init(FIELDSYS_WORK * fsys, EV_SCRIPT_WORK* sc, u16 scr_id, FIELD_OBJ_PTR obj, void* ret_wk);

//VM_MACHINE* VMMachineAdd(FIELDSYS_WORK* fsys, u16 scr_id, const VM_CMD* start, const VM_CMD* end);
VM_MACHINE* VMMachineAdd(FIELDSYS_WORK* fsys, u16 scr_id);

static void InitScript( FIELDSYS_WORK* fsys, VM_MACHINE* core, u16 id, u8 type );
static u16 SetScriptDataSub( FIELDSYS_WORK* fsys, VM_MACHINE* core, u16 id );
static void SetScriptData( FIELDSYS_WORK* fsys, VM_MACHINE* core, int index, u32 dat_id );
static void SetZoneScriptData( FIELDSYS_WORK* fsys, VM_MACHINE* core );

//EV_SCRIPT_WORK̃o[ANZX
void* GetEvScriptWorkMemberAdrs_Sub( EV_SCRIPT_WORK* sc, u32 id );
void* GetEvScriptWorkMemberAdrs( FIELDSYS_WORK* fsys, u32 id );
void SetEvScriptNextFunc( FIELDSYS_WORK* fsys );

static void EventDataIDJump( VM_MACHINE * core, u16 ev_id );

static void * LoadZoneScriptFile(int zone_id);
static u32 LoadZoneMsgNo(int zone_id);

//Cxg[NAXNvg[NANZX֐
u16 * GetEventWorkAdrs( FIELDSYS_WORK* fsys, u16 work_no );
u16 GetEventWorkValue( FIELDSYS_WORK* fsys, u16 work_no );
BOOL SetEventWorkValue( FIELDSYS_WORK* fsys, u16 work_no, u16 value );

u16 GetEvDefineObjCode( FIELDSYS_WORK* fsys, u16 no );
BOOL SetEvDefineObjCode( FIELDSYS_WORK* fsys, u16 no, u16 obj_code );

//CxgtO
BOOL CheckEventFlag( FIELDSYS_WORK* fsys, u16 flag_no);
void SetEventFlag( FIELDSYS_WORK* fsys, u16 flag_no);
void ResetEventFlag( FIELDSYS_WORK* fsys, u16 flag_no);

void LocalEventFlagClear( FIELDSYS_WORK* fsys );
void TimeEventFlagClear( FIELDSYS_WORK* fsys );

//g[i[֘A
u16 GetTrainerIdByScriptId( u16 scr_id );
BOOL GetTrainerLRByScriptId( u16 scr_id );
BOOL CheckTrainer2vs2Type( u16 tr_id );
BOOL CheckEventFlagTrainer( FIELDSYS_WORK* fsys, u16 tr_id );
void SetEventFlagTrainer( FIELDSYS_WORK* fsys, u16 tr_id );
void ResetEventFlagTrainer( FIELDSYS_WORK* fsys, u16 tr_id );

//BACe
u16 GetHideItemFlagNoByScriptId( u16 scr_id );
u16 GetHideItemFlagIndexByScriptId( u16 scr_id );
u8 GetHideItemResponseByScriptId( u16 scr_id );
static BOOL HideItemParamSet( EV_SCRIPT_WORK* sc, u16 scr_id );

//XNvg
void GameStartScriptInit( FIELDSYS_WORK* fsys );
void SpScriptStart( FIELDSYS_WORK* fsys, u16 scr_id );
BOOL SpScriptSearch( FIELDSYS_WORK* fsys, u8 key );
static u16 SpScriptSearch_Sub( const u8 * p, u8 key );
static u16 SpScriptSearch_Sub2( FIELDSYS_WORK* fsys, const u8 * p, u8 key );


//============================================================================================
//
//	O[oϐ
//
//============================================================================================
//extern const VM_CMD ScriptCommand[];		//XNvgR}h֐e[u
//extern const VM_CMD ScriptCommandEnd[];	//e[uŌ̃AhX

//fobNp
//u8 debug_script_flag = 0;				//XNvgNĂ邩tO
#define EV_SCRIPT_WORK_MAGIC_NO		(0x3643f)


//==============================================================================================
//
//	XNvg
//
//	XNvgCxgZbg
//		EventSet_Script(...)
//
//	̗
//		EvScriptWork_Alloc(...)					[Nm
//		EvScriptWork_Init(...)					ݒ
//		FieldEvent_Set(...)						Cxgݒ
//		GMEVENT_ControlScript(...)				Cxg֐
//				
//		VMMachineAdd(...)						VM}V[ǉ
//
//	z}V(VM_MACHINE)
//		Ez}Vǉ(VMMachineAdd)
//		Ez}V̐(vm_machine_count)ǉ
//
//	XNvg䃁C(GMEVENT_ControlScript)
//		Ez}V̐(vm_machine_count)`FbNăCxgI
//
//==============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * XNvgCxgZbg
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	scr_id		XNvgID
 * @param	obj			bΏOBJ̃|C^(ȂNULL)
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void EventSet_Script( FIELDSYS_WORK * fsys, u16 scr_id, FIELD_OBJ_PTR obj )
{
	EV_SCRIPT_WORK* sc = EvScriptWork_Alloc();			//[Nm
	EvScriptWork_Init( fsys, sc, scr_id, obj, NULL );	//ݒ
	FieldEvent_Set( fsys, GMEVENT_ControlScript, sc );	//Cxgݒ(_Set)
	return;
}

//----------------------------------------------------------------------------------------------
/**
 * g[i[i[@OEventSet_Script()NĂ
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	fldobj		qbgFIELD_OBJ_PTR
 * @param	range		ObhPʂ̎
 * @param	dir			ړ
 * @param	scr_id		qbgXNvgID
 * @param	tr_id		qbgg[i[ID
 * @param	tr_type		g[i[^Cv@VOA_uA^bO
 * @param	tr_no		ԖڂɃqbgg[i[Ȃ̂
 */
//----------------------------------------------------------------------------------------------
void EventSet_TrainerEyeData(
		FIELDSYS_WORK* fsys, FIELD_OBJ_PTR fldobj,
		int range, int dir, int scr_id, int tr_id, int tr_type, int tr_no )
{
	EV_SCRIPT_WORK* sc = FieldEvent_GetSpecialWork( fsys->event );
	EV_TRAINER_EYE_HITDATA *eye = &sc->eye_hitdata[tr_no];
	
	eye->range = range;
	eye->dir = dir;
	eye->scr_id = scr_id;
	eye->tr_id = tr_id;
	eye->tr_type = tr_type;
	eye->fldobj = fldobj;
}

#if 0
//----------------------------------------------------------------------------------------------
/**
 * g[i[擾
 *
 * @param	fldobj		qbgFIELD_OBJ_PTR
 * @param	range		ObhPʂ̎
 * @param	scr_id		qbgXNvgID
 * @param	tr_id		qbgg[i[ID
 * @param	tr_type		g[i[^Cv@VOA_uA^bO
 * @param	tr_no		ԖڂɃqbgg[i[Ȃ̂
 */
//----------------------------------------------------------------------------------------------
void GetTrainerEyeData( FIELD_OBJ_PTR flagobj, int* range, int* scr_id, int* tr_id, int* tr_type, int tr_no )
{
	EV_SCRIPT_WORK* sc = FieldEvent_GetSpecialWork( fsys->event );
	EV_TRAINER_EYE_HITDATA *eye = &sc->eye_hitdata[tr_no];
	
	*range	= eye->range;
	*scr_id	= eye->scr_id;
	*tr_id	= eye->tr_id;
	*tr_type= eye->tr_type;
	return;
}
#endif

//--------------------------------------------------------------------------------------------
/**
 * XNvgCxgR[
 *
 * @param	event		GMEVENT_CONTROL^̃|C^
 * @param	scr_id		XNvgID
 * @param	obj			bΏOBJ̃|C^(ȂNULL)
 * @param	ret_script_wk	XNvgʂ郏[Ñ|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void EventCall_Script( GMEVENT_CONTROL* event, u16 scr_id, FIELD_OBJ_PTR obj, void* ret_script_wk )
{
	FIELDSYS_WORK* fsys = FieldEvent_GetFieldSysWork( event );
	EV_SCRIPT_WORK* sc	= EvScriptWork_Alloc();					//[Nm
	EvScriptWork_Init( fsys, sc, scr_id, obj, ret_script_wk );	//ݒ
	FieldEvent_Call( event, GMEVENT_ControlScript, sc );		//Cxgݒ(_Call)
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * XNvgCxgؑ
 *
 * @param	event		GMEVENT_CONTROL^̃|C^
 * @param	scr_id		XNvgID
 * @param	obj			bΏOBJ̃|C^(ȂNULL)
 *
 * @retval	none
 *
 * ̃CxgXNvgւ̐ؑւs
 */
//--------------------------------------------------------------------------------------------
void EventChange_Script(GMEVENT_CONTROL* event, u16 scr_id, FIELD_OBJ_PTR obj)
{
	FIELDSYS_WORK* fsys = FieldEvent_GetFieldSysWork( event );
	EV_SCRIPT_WORK* sc	= EvScriptWork_Alloc();					//[Nm
	EvScriptWork_Init( fsys, sc, scr_id, obj, NULL );	//ݒ
	FieldEvent_Change( event, GMEVENT_ControlScript, sc );		//Cxgݒ
	return;
}


//--------------------------------------------------------------
/**
 * @brief	XNvg䃁C
 *
 * @param	event		GMEVENT_CONTROL^
 *
 * @retval	"FALSE = XNvgs"
 * @retval	"TRUE = XNvgsI"
 */
//--------------------------------------------------------------
static BOOL GMEVENT_ControlScript(GMEVENT_CONTROL * event)
{
	int i;
	fsysFunc func;
	VM_MACHINE* core = NULL;
	EV_SCRIPT_WORK * sc = FieldEvent_GetSpecialWork( event );
	FIELDSYS_WORK* fsys = FieldEvent_GetFieldSysWork( event );

	switch(sc->seq){
	case 0:
		//z}Vǉ
		sc->vm[VM_MACHINE_MAIN] = VMMachineAdd( fsys, sc->script_id );
		//VMMachineAdd( fsys, id, &ScriptCmdTbl[0], &ScriptCmdTbl[EVCMD_MAX] );
		sc->vm_machine_count = 1;

		//MSGMAN_Creatěɏ
		//sc->wordset = WORDSET_Create( HEAPID_WORLD );
		sc->wordset = WORDSET_CreateEx(WORDSET_SCRIPT_SETNUM, WORDSET_SCRIPT_BUFLEN, HEAPID_WORLD);
		sc->msg_buf = STRBUF_Create( SCR_MSG_BUF_SIZE, HEAPID_WORLD );
		sc->tmp_buf = STRBUF_Create( SCR_MSG_BUF_SIZE, HEAPID_WORLD );

		sc->seq++;
		/* FALL THROUGH */
		
	case 1:
		//z}VRg[
		for( i=0; i < VM_MACHINE_MAX; i++ ){

			core = sc->vm[i];

			if( core != NULL ){

				if( VM_Control(core) == FALSE ){				//䃁C

					script_del(core);							//XNvg폜

					if( sc->vm_machine_count == 0 ){
						GF_ASSERT( (0) && "z}V̐słI" );
					}

					sc->vm[i] = NULL;
					sc->vm_machine_count--;
				}
			}
		}

		//z}V̐`FbN
		if( sc->vm_machine_count <= 0 ){

			func = sc->next_func;								//ޔ

			WORDSET_Delete( sc->wordset );
			STRBUF_Delete( sc->msg_buf );
			STRBUF_Delete( sc->tmp_buf );

			//fobN
			//debug_script_flag = 0;
			sc->magic_no = 0;

			sys_FreeMemoryEz( sc );								//XNvg[N

			//XNvgIɌĂяo֐s
			if( func != NULL ){
				func(fsys);
				return FALSE;				//FieldEventIȂ悤FALSEԂI
			}

			return TRUE;										//FieldEvent_SetII
		}
		break;
	};

	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief	XNvg䃏[Nm
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 *
 * @retval	"XNvg䃏[ÑAhX"
 */
//--------------------------------------------------------------
static EV_SCRIPT_WORK* EvScriptWork_Alloc()
{
	EV_SCRIPT_WORK* sc;

	sc = sys_AllocMemory( HEAPID_WORLD, sizeof(EV_SCRIPT_WORK) );		//XNvg䃏[Nm
	if( sc == NULL ){
		GF_ASSERT( (0) && "mۂɎs܂I" );
	}
	memset( sc, 0, sizeof(EV_SCRIPT_WORK) );

	//fobN
	//debug_script_flag = 1;
	sc->magic_no = EV_SCRIPT_WORK_MAGIC_NO;

	return sc;
}

//--------------------------------------------------------------
/**
 * @brief	XNvgʍ폜
 *
 * @param	core		VM_MACHINE^̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void script_del( VM_MACHINE* core )
{
	MSGMAN_Delete( core->msgman );
	sys_FreeMemoryEz( core->pScript );			//XNvgf[^
	sys_FreeMemoryEz( core );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	XNvg䃏[Nݒ
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	sc			EV_SCRIPT_WORK^̃|C^
 * @param	scr_id		XNvgID
 * @param	obj			bΏOBJ̃|C^
 * @param	ret_wk		XNvgʂ郏[Ñ|C^
 *
 * @retval	"XNvg䃏[ÑAhX"
 */
//--------------------------------------------------------------
static void EvScriptWork_Init( FIELDSYS_WORK * fsys, EV_SCRIPT_WORK* sc, u16 scr_id, FIELD_OBJ_PTR obj, void* ret_wk )
{
	u16* objid = GetEvScriptWorkMemberAdrs_Sub( sc, ID_EVSCR_WK_TARGET_OBJID );

	//DIR_NOT = -1
	sc->player_dir = Player_DirGet(fsys->player);	//CxgN̎ľZbg
	sc->target_obj = obj;							//bΏOBJ̃|C^Zbg
	sc->script_id  = scr_id;						//C̃XNvgID
	sc->ret_script_wk = ret_wk;						//XNvgʂ郏[N

	if( obj != NULL ){
		*objid = FieldOBJ_OBJIDGet(obj);			//bΏOBJID̃Zbg
	}

	//BACẽXNvgID(Ƃňړ\)
	if( (scr_id >= ID_HIDE_ITEM_OFFSET) && (scr_id <= ID_HIDE_ITEM_OFFSET_END) ){
		HideItemParamSet( sc, scr_id );
	}

#ifdef	PM_DEBUG
	OS_Printf("ZONE:%s SCRID:%d\n",ZoneData_GetZoneName(fsys->location->zone_id), scr_id);
#endif

	return;
}

//--------------------------------------------------------------
/**
 * @brief	z}Vǉ
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	id			XNvgID
 * @param	start		߃e[uJnAhX
 * @param	end			߃e[uIAhX
 *
 * @retval	none
 */
//--------------------------------------------------------------
//VM_MACHINE* VMMachineAdd(FIELDSYS_WORK* fsys, u16 scr_id, const VM_CMD* start, const VM_CMD* end)
VM_MACHINE* VMMachineAdd(FIELDSYS_WORK* fsys, u16 scr_id)
{
	VM_MACHINE* core = NULL;

	core = sys_AllocMemory( HEAPID_WORLD, sizeof(VM_MACHINE) );
	if( core == NULL ){
		GF_ASSERT( (0) && "mۂɎs܂I" );
	}

	//z}V
	VM_Init( core, ScriptCmdTbl, ScriptCmdMax );
	//VM_Init( core, start, end );

	InitScript( fsys, core, scr_id, 0 );							//[JXNvg

	return core;
}

//--------------------------------------------------------------
/**
 * @brief	XNvgݒ菉
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	core		VM_MACHINE^̃|C^
 * @param	id			XNvgID
 * @param	type		"gp"
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void InitScript( FIELDSYS_WORK* fsys, VM_MACHINE* core, u16 id, u8 type )
{
	u16 scr_id;

	core->fsys = fsys;
	scr_id = SetScriptDataSub( fsys, core, id );	//XNvgf[^AbZ[Wf[^ǂݍ
	VM_Start( core, core->pScript );				//z}VɃR[hݒ
	EventDataIDJump( core, scr_id );
	VM_SetWork( core, (void *)fsys->event );		//R}hȂǂŎQƂ郏[NZbg
	return;
}

//--------------------------------------------------------------
/**
 * @brief	XNvgIDXNvgf[^AbZ[Wf[^ǂݍ
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	core		VM_MACHINE^̃|C^
 * @param	id			XNvgID
 *
 * @retval	"XNvgIDItZbgl"
 */
//--------------------------------------------------------------
static u16 SetScriptDataSub( FIELDSYS_WORK* fsys, VM_MACHINE* core, u16 id )
{
	u16 scr_id = id;

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łł́Ǎł݂̂ŎgXNvgID߂悤ɕύX
#ifdef PG5_TRIAL
	//̌ŃXNvgIDnꂽ
	if( scr_id >= ID_FESTA_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_festa_bin, NARC_msg_dp_festa_dat );
		scr_id -= ID_FESTA_OFFSET;
	}else
#endif
// ----------------------------------------------------------------------------
	//T|[gXNvgIDnꂽ
	if( scr_id >= ID_SUPPORT_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_support_bin, NARC_msg_support_dat );
		scr_id -= ID_SUPPORT_OFFSET;

	//zBXNvgIDnꂽ
	}else if( scr_id >= ID_HAITATU_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_haitatu_bin, NARC_msg_haitatu_dat );
		scr_id -= ID_HAITATU_OFFSET;

	//TVC^r[XNvgIDnꂽ
	}else if( scr_id >= ID_TV_INTERVIEW_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_tv_interview_bin, NARC_msg_tv_interview_dat );
		scr_id -= ID_TV_INTERVIEW_OFFSET;

	//TVXNvgIDnꂽ
	}else if( scr_id >= ID_TV_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_tv_bin, NARC_msg_tv_program_dat );
		scr_id -= ID_TV_OFFSET;

	//`XNvgIDnꂽ
	}else if( scr_id >= ID_HIDEN_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_hiden_bin, NARC_msg_hiden_dat );
		scr_id -= ID_HIDEN_OFFSET;

	//]XNvgIDnꂽ
	}else if( scr_id >= ID_HYOUKA_SCR_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_hyouka_scr_bin, NARC_msg_hyouka_dat );
		scr_id -= ID_HYOUKA_SCR_OFFSET;

	//fobNXNvgIDnꂽ
	}else if( scr_id >= ID_DEBUG_SCR_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_debug_scr_bin, NARC_msg_common_scr_dat );
		scr_id -= ID_DEBUG_SCR_OFFSET;

	//ReXgtXNvgIDnꂽ
	}else if( scr_id >= ID_CON_RECEPTION_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_con_reception_bin, NARC_msg_con_reception_dat );
		scr_id -= ID_CON_RECEPTION_OFFSET;

	//AXNvgIDnꂽ
	}else if( scr_id >= ID_PAIR_SCR_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_pair_scr_bin, NARC_msg_pair_scr_dat );
		scr_id -= ID_PAIR_SCR_OFFSET;

	//Q[JnXNvgIDnꂽ
	}else if( scr_id >= ID_INIT_SCR_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_init_scr_bin, NARC_msg_common_scr_dat );
		scr_id -= ID_INIT_SCR_OFFSET;

	//ĉXNvgIDnꂽ
	}else if( scr_id >= ID_SODATEYA_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_sodateya_bin, NARC_msg_sodateya_dat );
		scr_id -= ID_SODATEYA_OFFSET;

	//|g~jQ[XNvgIDnꂽ
	}else if( scr_id >= ID_PORUTO_SCR_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_poruto_scr_bin, NARC_msg_pgamestart_dat );
		scr_id -= ID_PORUTO_SCR_OFFSET;

	//O[vXNvgIDnꂽ
	}else if( scr_id >= ID_GROUP_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_group_bin, NARC_msg_group_dat );
		scr_id -= ID_GROUP_OFFSET;

	//|PZnXNvgIDnꂽ
	}else if( scr_id >= ID_PC_UG_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_pc_ug_bin, NARC_msg_pc_ug_dat );
		scr_id -= ID_PC_UG_OFFSET;

	//RVAXNvgIDnꂽ
	}else if( scr_id >= ID_BATTLE_ROOM_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_battle_room_bin, NARC_msg_battle_room_dat );
		scr_id -= ID_BATTLE_ROOM_OFFSET;

	//ʐMXNvgIDnꂽ
	}else if( scr_id >= ID_CONNECT_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_connect_bin, NARC_msg_connect_dat );
		scr_id -= ID_CONNECT_OFFSET;

	//|PT[`[XNvgIDnꂽ
	}else if( scr_id >= ID_POKESEARCHER_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_pokesearcher_bin, NARC_msg_bag_dat );
		scr_id -= ID_POKESEARCHER_OFFSET;

	//ĐXNvgIDnꂽ
	}else if( scr_id >= ID_SAISEN_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_saisen_bin, NARC_msg_saisen_dat );
		scr_id -= ID_SAISEN_OFFSET;

	//ybvXNvgIDnꂽ
	}else if( scr_id >= ID_PERAP_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_perap_bin, NARC_msg_perap_dat );
		scr_id -= ID_PERAP_OFFSET;

	//Tt@XNvgIDnꂽ
	}else if( scr_id >= ID_SAFARI_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_safari_bin, NARC_msg_safari_dat );
		scr_id -= ID_SAFARI_OFFSET;

	//BACeXNvgIDnꂽ
	}else if( scr_id >= ID_HIDE_ITEM_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_hide_item_bin, NARC_msg_hide_item_dat );
		scr_id -= ID_HIDE_ITEM_OFFSET;

	//tB[hACeXNvgIDnꂽ
	}else if( scr_id >= ID_FLD_ITEM_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_fld_item_bin, NARC_msg_fld_item_dat );
		scr_id -= ID_FLD_ITEM_OFFSET;

	//2vs2g[i[XNvgIDnꂽ
	}else if( scr_id >= ID_TRAINER_2VS2_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_trainer_bin, NARC_msg_common_scr_dat );
		scr_id -= ID_TRAINER_2VS2_OFFSET;

	//g[i[XNvgIDnꂽ
	}else if( scr_id >= ID_TRAINER_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_trainer_bin, NARC_msg_common_scr_dat );
		scr_id -= ID_TRAINER_OFFSET;

	//̂݃XNvgIDnꂽ
	}else if( scr_id >= ID_KINOMI_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_kinomi_bin, NARC_msg_kinomi_dat );
		scr_id -= ID_KINOMI_OFFSET;

	//BGXNvgIDnꂽ
	}else if( scr_id >= ID_BG_ATTR_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_bg_attr_bin, NARC_msg_bg_attr_dat );
		scr_id -= ID_BG_ATTR_OFFSET;

	//ʃXNvgIDnꂽ
	}else if( scr_id >= ID_COMMON_SCR_OFFSET ){
		SetScriptData( fsys, core, NARC_scr_seq_common_scr_bin, NARC_msg_common_scr_dat );
		scr_id -= ID_COMMON_SCR_OFFSET;

	//[JXNvgIDnꂽ
	}else if( scr_id >= ID_START_SCR_OFFSET ){
		SetZoneScriptData( fsys, core );						//][XNvgf[^Zbg
		scr_id -= ID_START_SCR_OFFSET;

	//SCRID_NULL(0)nꂽ
	}else{
		SetScriptData( fsys, core, NARC_scr_seq_dummy_scr_bin, NARC_msg_dummy_scr_dat );
		scr_id = 0;
	}

	return scr_id;
}

//----------------------------------------------------------------------------------------------
/**
 * XNvgf[^Zbg
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	core		VM_MACHINE^̃|C^
 * @param	index		XNvgf[^ID
 * @param	dat_id		bZ[Wf[^ID
 */
//----------------------------------------------------------------------------------------------
static void SetScriptData( FIELDSYS_WORK* fsys, VM_MACHINE* core, int index, u32 dat_id )
{
	//ʃXNvgf[^[h
	VM_CODE* script = ArchiveDataLoadMalloc(ARC_SCRIPT, index , HEAPID_WORLD);
	core->pScript = (VM_CODE *)script;

	//bZ[Wf[^}l[W[쐬
	core->msgman = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, dat_id, HEAPID_WORLD );
	
	return;
}

//----------------------------------------------------------------------------------------------
/**
 * ][XNvgf[^Zbg
 *
 * @param	ID		XNvgf[^ID
 */
//----------------------------------------------------------------------------------------------
static void SetZoneScriptData( FIELDSYS_WORK* fsys, VM_MACHINE* core )
{
	//][ID烍[hXNvgoCi擾
	VM_CODE* script = LoadZoneScriptFile(fsys->location->zone_id);
	core->pScript	= (VM_CODE*)script;

	//bZ[Wf[^}l[W[쐬
	core->msgman = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, 
									LoadZoneMsgNo(fsys->location->zone_id), HEAPID_WORLD );
	
	return;
}


//============================================================================================
//
//	XNvg䃏[Ño[ANZX
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * XNvg䃏[Ño[AhX擾
 *
 * @param	sc		EV_SCRIPT_WORK^̃|C^
 * @param	id		擾郁oID(script.hQ)
 *
 * @return	"AhX"
 */
//--------------------------------------------------------------------------------------------
void* GetEvScriptWorkMemberAdrs_Sub( EV_SCRIPT_WORK* sc, u32 id )
{
	EV_TRAINER_EYE_HITDATA *eye;

	switch( id ){
	//CxgEBhE[Ñ|C^
	case ID_EVSCR_EVWIN:
		return &sc->ev_win;

	//bEBhErbg}bvf[^̃|C^
	case ID_EVSCR_MSGWINDAT:
		return &sc->MsgWinDat;

	//rbg}bvj[[Ñ|C^
	case ID_EVSCR_MENUWORK:
		return &sc->mw;

	//bEBhEbZ[WCfbNX̃|C^
	case ID_EVSCR_MSGINDEX:
		return &sc->MsgIndex;

	//Aj[V̐̃|C^
	case ID_EVSCR_ANMCOUNT:
		return &sc->anm_count;

	//ʃXNvg؂ւtÕ|C^
	case ID_EVSCR_COMMON_SCR_FLAG:
		return &sc->common_scr_flag;

	//bEBhEJtÕ|C^
	case ID_EVSCR_WIN_OPEN_FLAG:
		return &sc->win_open_flag;

	//ǉz}V̐̃|C^
	case ID_EVSCR_VM_MACHINE_COUNT:
		return &sc->vm_machine_count;

	//C̃XNvgID
	case ID_EVSCR_SCRIPT_ID:
		return &sc->script_id;

	//CxgN̎ľ
	case ID_EVSCR_PLAYER_DIR:
		return &sc->player_dir;

	//bΏۂOBJ̃|C^
	case ID_EVSCR_TARGET_OBJ:
		return &sc->target_obj;

	//_~[OBJ̃|C^
	case ID_EVSCR_DUMMY_OBJ:
		return &sc->dummy_obj;

	//ʂ郏[Ñ|C^
	case ID_EVSCR_RETURN_SCRIPT_WK:
		return &sc->ret_script_wk;

	//z}V(C)̃|C^
	case ID_EVSCR_VM_MAIN:
		return &sc->vm[VM_MACHINE_MAIN];

	//z}V(Tu)̃|C^
	case ID_EVSCR_VM_SUB1:
		return &sc->vm[VM_MACHINE_SUB1];

	//PZbg
	case ID_EVSCR_WORDSET:
		return &sc->wordset;

	//bZ[Wobt@̃|C^
	case ID_EVSCR_MSGBUF:
		return &sc->msg_buf;

	//e|obt@̃|C^
	case ID_EVSCR_TMPBUF:
		return &sc->tmp_buf;

	//ҋ@ACR̃|C^
	case ID_EVSCR_WAITICON:
		return &sc->waiticon;

	//TuvZXƂ̂Ƃ胏[Nւ̃|C^
	case ID_EVSCR_SUBPROC_WORK:
		return &sc->subproc_work;

	//[Nւ̔ėp|C^
	case ID_EVSCR_PWORK:
		return &sc->pWork;

	//tB[hGtFNgւ̃|C^
	case ID_EVSCR_EOA:
		return &sc->eoa;

	//@`ԃ|[gTCB̃|C^
	case ID_EVSCR_PLAYER_TCB:
		return &sc->player_tcb;

	//퓬ʃtO
	case ID_EVSCR_WIN_FLAG:
		return &sc->win_flag;

	//(0)F
	case ID_EVSCR_TR0_RANGE:
		eye = &sc->eye_hitdata[0];
		return &eye->range;

	//(0)F
	case ID_EVSCR_TR0_DIR:
		eye = &sc->eye_hitdata[0];
		return &eye->dir;

	//(0)FXNvgID
	case ID_EVSCR_TR0_SCR_ID:
		eye = &sc->eye_hitdata[0];
		return &eye->scr_id;

	//(0)Fg[i[ID
	case ID_EVSCR_TR0_ID:
		eye = &sc->eye_hitdata[0];
		return &eye->tr_id;

	//(0)Fg[i[^Cv
	case ID_EVSCR_TR0_TYPE:
		eye = &sc->eye_hitdata[0];
		return &eye->tr_type;

	//(0)Fg[i[OBJ
	case ID_EVSCR_TR0_FLDOBJ:
		eye = &sc->eye_hitdata[0];
		return &eye->fldobj;

	//(0)FTCB
	case ID_EVSCR_TR0_TCB:
		eye = &sc->eye_hitdata[0];
		return &eye->tcb;

	//(1)F
	case ID_EVSCR_TR1_RANGE:
		eye = &sc->eye_hitdata[1];
		return &eye->range;

	//(1)F
	case ID_EVSCR_TR1_DIR:
		eye = &sc->eye_hitdata[1];
		return &eye->dir;

	//(1)FXNvgID
	case ID_EVSCR_TR1_SCR_ID:
		eye = &sc->eye_hitdata[1];
		return &eye->scr_id;

	//(1)Fg[i[ID
	case ID_EVSCR_TR1_ID:
		eye = &sc->eye_hitdata[1];
		return &eye->tr_id;

	//(1)Fg[i[^Cv
	case ID_EVSCR_TR1_TYPE:
		eye = &sc->eye_hitdata[1];
		return &eye->tr_type;

	//(1)Fg[i[OBJ
	case ID_EVSCR_TR1_FLDOBJ:
		eye = &sc->eye_hitdata[1];
		return &eye->fldobj;

	//(1)FTCB
	case ID_EVSCR_TR1_TCB:
		eye = &sc->eye_hitdata[1];
		return &eye->tcb;

	//RCEBhErbg}bvf[^̃|C^
	case ID_EVSCR_COINWINDAT:
		return &sc->CoinWinDat;

	//EBhErbg}bvf[^̃|C^
	case ID_EVSCR_GOLDWINDAT:
		return &sc->GoldWinDat;

	//|[g\EBhE䃏[Nւ̃|C^
	case ID_EVSCR_REPORTWIN:
		return &sc->riw;

	//[N(ANSWORK,TMPWORKȂǂ̑)̃|C^
	//XNvgƃvÕf[^p
	case ID_EVSCR_WK_PARAM0:				
	case ID_EVSCR_WK_PARAM1:
	case ID_EVSCR_WK_PARAM2:
	case ID_EVSCR_WK_PARAM3:
	//XNvgł̃e|
	case ID_EVSCR_WK_TEMP0:					
	case ID_EVSCR_WK_TEMP1:
	case ID_EVSCR_WK_TEMP2:
	case ID_EVSCR_WK_TEMP3:
	//XNvgł̏p
	case ID_EVSCR_WK_REG0:					
	case ID_EVSCR_WK_REG1:
	case ID_EVSCR_WK_REG2:
	case ID_EVSCR_WK_REG3:
	//XNvgɓԂėp[N
	case ID_EVSCR_WK_ANSWER:
	//bΏOBJID
	case ID_EVSCR_WK_TARGET_OBJID:
		return &sc->work[ id - ID_EVSCR_WK_START ];

	};

	//G[
	GF_ASSERT( (0) && "o[IDsłI" );

	return NULL;
}

//--------------------------------------------------------------------------------------------
/**
 * XNvg䃏[Ño[AhX擾
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 * @param	id		擾郁oID(script.hQ)
 *
 * @return	"AhX"
 */
//--------------------------------------------------------------------------------------------
void* GetEvScriptWorkMemberAdrs( FIELDSYS_WORK* fsys, u32 id )
{
	EV_SCRIPT_WORK* sc = FieldEvent_GetSpecialWork( fsys->event );

	if( sc->magic_no != EV_SCRIPT_WORK_MAGIC_NO ){
		GF_ASSERT( (0) && "N(m)ĂȂXNvg̃[NɃANZXĂ܂I" );
	}

	return GetEvScriptWorkMemberAdrs_Sub( sc, id );
}

//--------------------------------------------------------------------------------------------
/**
 * XNvg䃏[N"next_func"Ƀj[ĂяoZbg
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @return	none
 *
 * tB[hj[ĂяoI
 *
 * ꂪc炭Ȃ̂ŁAėpIɎgȂ悤ɂĂI
 */
//--------------------------------------------------------------------------------------------
void SetEvScriptNextFunc( FIELDSYS_WORK* fsys )
{
	EV_SCRIPT_WORK* sc	= FieldEvent_GetSpecialWork( fsys->event );

	// ----------------------------------------------------------------------------
	// localize_spec_mark(JP_VER10) imatake 2006/12/01
	if( FieldMenuCallCheck( fsys ) == TRUE ){	// uȂ̂΂v`FbN 2006/10/24 by nakahiro
		sc->next_func = FieldMenuEvChg;
	}
	// ----------------------------------------------------------------------------

	return;
}

//--------------------------------------------------------------------------------------------
/**
 * IDWv
 *
 * @param	core	VM_MACHINE^̃|C^
 * @param	id		XNvgID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void EventDataIDJump( VM_MACHINE * core, u16 ev_id )
{
	core->PC += (ev_id * 4);			//IDi߂(adrslongȂ̂*4)
	core->PC += VMGetU32( core );		//xItZbgi߂
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * 
 *
 * @param	zone_id		][ID
 *
 * @retval	""
 */
//--------------------------------------------------------------------------------------------
static void * LoadZoneScriptFile(int zone_id)
{
	return ArchiveDataLoadMalloc(ARC_SCRIPT, ZoneData_GetScriptArchiveID(zone_id), HEAPID_WORLD);
}

#if 0
void * LoadZoneMsgFile(int zone_id);
void * LoadZoneMsgFile(int zone_id)
{
	return ArchiveDataLoadMalloc(ARC_SCRIPT_MSG, ZoneData_GetMsgArchiveID(zone_id), HEAPID_WORLD);
}
#endif

//--------------------------------------------------------------------------------------------
/**
 * }bvǗ\ɓo^ĂAbZ[Wt@C̃A[JCuID擾
 *
 * @param	zone_id		][ID
 *
 * @retval	"A[JCuID"
 */
//--------------------------------------------------------------------------------------------
static u32 LoadZoneMsgNo(int zone_id)
{
	return ZoneData_GetMsgArchiveID(zone_id);
}


//============================================================================================
//
//
//
//============================================================================================

//------------------------------------------------------------------
/**
 * @brief	Cxg[NAhX擾
 *
 * @param	ev			Cxg[Nւ̃|C^
 * @param	fsys		FIELDSYS_WORKւ̃|C^
 * @param	work_no		[Nio[
 *
 * @return	"[ÑAhX"
 *
 * @li	work_no < 0x8000	ʏ̃Z[u[N
 * @li	work_no >= 0x8000	XNvg䃏[N̒ɊmۂĂ郏[N
 */
//------------------------------------------------------------------
u16 * GetEventWorkAdrs( FIELDSYS_WORK* fsys, u16 work_no )
{
	EVENTWORK* ev;
	ev = SaveData_GetEventWork(fsys->savedata);

	if( work_no < SVWK_START ){ return NULL; }
	if( work_no < SCWK_START ){ return EventWork_GetEventWorkAdrs(ev,work_no); }

	//XNvg䃏[N̒ŁAANSWORKȂǂ̃[NmۂĂ܂
	return GetEvScriptWorkMemberAdrs( fsys, (ID_EVSCR_WK_START + work_no - SCWK_START) );
}

//------------------------------------------------------------------
/**
 * @brief	Cxg[N̒l擾
 *
 * @param	fsys		FIELDSYS_WORKւ̃|C^
 * @param	work_no		[Nio[
 *
 * @return	"[N̒l"
 */
//------------------------------------------------------------------
u16 GetEventWorkValue( FIELDSYS_WORK* fsys, u16 work_no )
{
	u16* res = GetEventWorkAdrs( fsys, work_no );
	if( res == NULL ){ return work_no; }
	return *res;
}

//------------------------------------------------------------------
/**
 * @brief	Cxg[N̒lZbg
 *
 * @param	fsys		FIELDSYS_WORKւ̃|C^
 * @param	work_no		[Nio[
 * @param	value		Zbgl
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//------------------------------------------------------------------
BOOL SetEventWorkValue( FIELDSYS_WORK* fsys, u16 work_no, u16 value )
{
	u16* res = GetEventWorkAdrs( fsys, work_no );
	if( res == NULL ){ return FALSE; }
	*res = value;
	return TRUE;
}

//------------------------------------------------------------------
/**
 * @brief	XNvgw肷OBJR[h擾
 *
 * @param	fsys		FIELDSYS_WORKւ̃|C^
 * @param	no			0-15
 *
 * @return	"OBJLR[h"
 */
//------------------------------------------------------------------
u16 GetEvDefineObjCode( FIELDSYS_WORK* fsys, u16 no )
{
	GF_ASSERT( (no < OBJCHR_WORK_MAX) && "słI" );
	return GetEventWorkValue( fsys, (OBJCHR_WORK_START+no) );
}

//------------------------------------------------------------------
/**
 * @brief	XNvgw肷OBJR[hZbg
 *
 * @param	fsys		FIELDSYS_WORKւ̃|C^
 * @param	no			0-15
 * @param	obj_code	OBJR[h
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//------------------------------------------------------------------
BOOL SetEvDefineObjCode( FIELDSYS_WORK* fsys, u16 no, u16 obj_code )
{
	GF_ASSERT( (no < OBJCHR_WORK_MAX) && "słI" );
	return SetEventWorkValue( fsys, (OBJCHR_WORK_START+no), obj_code );
}


//============================================================================================
//
//	tO֘A
//
//============================================================================================

//------------------------------------------------------------------
/**
 * @brief	CxgtO`FbN
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 * @param	flag_no		tOio[
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//------------------------------------------------------------------
BOOL CheckEventFlag( FIELDSYS_WORK* fsys, u16 flag_no)
{
	return EventWork_CheckEventFlag( SaveData_GetEventWork(fsys->savedata),	flag_no );
}

//------------------------------------------------------------------
/**
 * @brief	CxgtOZbg
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 * @param	flag_no		tOio[
 *
 * @return	none
 */
//------------------------------------------------------------------
void SetEventFlag( FIELDSYS_WORK* fsys, u16 flag_no)
{
	EventWork_SetEventFlag( SaveData_GetEventWork(fsys->savedata),flag_no );
	return;
}

//------------------------------------------------------------------
/**
 * @brief	CxgtOZbg
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 * @param	flag_no		tOio[
 *
 * @return	none
 */
//------------------------------------------------------------------
void ResetEventFlag( FIELDSYS_WORK* fsys, u16 flag_no)
{
	EventWork_ResetEventFlag( SaveData_GetEventWork(fsys->savedata), flag_no );
	return;
}

//------------------------------------------------------------------
/**
 * @brief	}bṽZ[utONA
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 *
 * @return	none
 */
//------------------------------------------------------------------
void LocalEventFlagClear( FIELDSYS_WORK* fsys )
{
	int i;
	EVENTWORK* event;

#if 0
	//NAO
	for( i=0; i < 80 ;i++ ){
		OS_Printf( "flag %d= %d\n", i, CheckEventFlag(fsys,i) );
	}
	for( i=0x4000; i < 0x4020 ;i++ ){
		OS_Printf( "work %d= %d\n", i, GetEventWorkValue(fsys,i) );
	}
#endif

	//Cxg[Ñ|C^擾
	event = SaveData_GetEventWork(fsys->savedata);

	//[JtÕNA"8bit * 8 = 64"
	//"0"͖ȃio[Ȃ̂1nĎ擾Ă
	memset( EventWork_GetEventFlagAdrs(event,1), 0, LOCAL_FLAG_AREA_MAX );

	//[J[ÑNA"32"
	memset( EventWork_GetEventWorkAdrs(event,LOCAL_WORK_START), 0, 2*LOCAL_WORK_MAX );

#if 0
	//NA
	for( i=0; i < 80 ;i++ ){
		OS_Printf( "flag %d= %d\n", i, CheckEventFlag(fsys,i) );
	}
	for( i=0x4000; i < 0x4020 ;i++ ){
		OS_Printf( "work %d= %d\n", i, GetEventWorkValue(fsys,i) );
	}
#endif

	return;
}

//------------------------------------------------------------------
/**
 * @brief	1o߂ƂɃNAtONA
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 *
 * @return	none
 */
//------------------------------------------------------------------
void TimeEventFlagClear( FIELDSYS_WORK* fsys )
{
	EVENTWORK* event;

	//Cxg[Ñ|C^擾
	event = SaveData_GetEventWork(fsys->savedata);

	memset( EventWork_GetEventFlagAdrs(event,TIMEFLAG_START), 0, TIMEFLAG_AREA_MAX );

	return;
}

//============================================================================================
//
//		vOXNvgėp
//
//
//
//============================================================================================
//--------------------------------------------------------------
/**
 * @brief	vOXNvgփp[^n
 * @param	event	XNvgNĂCxgւ̃|C^
 * @param	prm0	p[^OiSCWK_PARAM0j
 * @param	prm1	p[^PiSCWK_PARAM1j
 * @param	prm2	p[^QiSCWK_PARAM2j
 * @param	prm3	p[^RiSCWK_PARAM3j
 */
//--------------------------------------------------------------
void EvScript_SetParam(FIELDSYS_WORK * fsys, u16 prm0, u16 prm1, u16 prm2, u16 prm3)
{
	*(u16*)GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WK_PARAM0 ) = prm0;
	*(u16*)GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WK_PARAM1 ) = prm1;
	*(u16*)GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WK_PARAM2 ) = prm2;
	*(u16*)GetEvScriptWorkMemberAdrs( fsys, ID_EVSCR_WK_PARAM3 ) = prm3;
}

//============================================================================================
//
//	g[i[tO֘A
//
//	EXNvgIDAg[i[ID擾āAtO`FbN
//	BOOL CheckEventFlagTrainer( fsys, GetTrainerIdByScriptId(scr_id) );
//
//============================================================================================
#define GET_TRAINER_FLAG(id)	( TR_FLAG_START+(id) )

//--------------------------------------------------------------
/**
 * XNvgIDAg[i[ID擾
 *
 * @param   scr_id		XNvgID
 *
 * @retval  "g[i[ID = tOCfbNX"
 */
//--------------------------------------------------------------
u16 GetTrainerIdByScriptId( u16 scr_id )
{
	if( scr_id < ID_TRAINER_2VS2_OFFSET ){
		return (scr_id - ID_TRAINER_OFFSET + 1);		//1IW
	}else{
		return (scr_id - ID_TRAINER_2VS2_OFFSET + 1);		//1IW
	}
}

//--------------------------------------------------------------
/**
 * XNvgIDAEǂ̃g[i[擾
 *
 * @param   scr_id		XNvgID
 *
 * @retval  "0=A1=E"
 */
//--------------------------------------------------------------
BOOL GetTrainerLRByScriptId( u16 scr_id )
{
	if( scr_id < ID_TRAINER_2VS2_OFFSET ){
		return 0;
	}else{
		return 1;
	}
}

//--------------------------------------------------------------
/**
 * g[i[IDA_uog^Cv擾
 *
 * @param   tr_id		g[i[ID
 *
 * @retval  "0=VOogA1=_uog"
 */
//--------------------------------------------------------------
BOOL CheckTrainer2vs2Type( u16 tr_id )
{
	if( TT_TrainerDataParaGet(tr_id, ID_TD_fight_type) == FIGHT_TYPE_1vs1 ){	//1vs1
		OS_Printf( "trainer_type = 1vs1 " );
		return 0;
		//return SCR_EYE_TR_TYPE_SINGLE;
	}

	OS_Printf( "trainer_type = 2vs2 " );
	return 1;
	//return SCR_EYE_TR_TYPE_DOUBLE;
}

//------------------------------------------------------------------
/**
 * @brief	g[i[CxgtO`FbN
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 * @param	tr_id		g[i[ID
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//------------------------------------------------------------------
BOOL CheckEventFlagTrainer( FIELDSYS_WORK* fsys, u16 tr_id )
{
	return EventWork_CheckEventFlag( 
				SaveData_GetEventWork(fsys->savedata), GET_TRAINER_FLAG(tr_id) );
}

//------------------------------------------------------------------
/**
 * @brief	g[i[CxgtOZbg
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 * @param	tr_id		g[i[ID
 *
 * @return	none
 */
//------------------------------------------------------------------
void SetEventFlagTrainer( FIELDSYS_WORK* fsys, u16 tr_id )
{
	EventWork_SetEventFlag( SaveData_GetEventWork(fsys->savedata), GET_TRAINER_FLAG(tr_id) );
	return;
}

//------------------------------------------------------------------
/**
 * @brief	g[i[CxgtOZbg
 *
 * @param	fsys		FIELDSYS_WORK̃|C^
 * @param	tr_id		g[i[ID
 *
 * @return	none
 */
//------------------------------------------------------------------
void ResetEventFlagTrainer( FIELDSYS_WORK* fsys, u16 tr_id )
{
	EventWork_ResetEventFlag( SaveData_GetEventWork(fsys->savedata), GET_TRAINER_FLAG(tr_id) );
	return;
}


//============================================================================================
//
//	BACe֘A
//
//	EXNvgIDABACetO擾āAtO`FbN
//	BOOL CheckEventFlag( fsys, GetHideItemFlagNoByScriptId(scr_id) );
//
//============================================================================================

//--------------------------------------------------------------
/**
 * XNvgIDABACetOio[擾
 *
 * @param   scr_id		XNvgID
 *
 * @retval  "tOio["
 */
//--------------------------------------------------------------
u16 GetHideItemFlagNoByScriptId( u16 scr_id )
{
	return (scr_id - ID_HIDE_ITEM_OFFSET + FH_FLAG_START);
}

//--------------------------------------------------------------
/**
 * XNvgIDABACetOCfbNX擾
 *
 * @param   scr_id		XNvgID
 *
 * @retval  "tOCfbNX"
 */
//--------------------------------------------------------------
u16 GetHideItemFlagIndexByScriptId( u16 scr_id )
{
	return (scr_id - ID_HIDE_ITEM_OFFSET);
}

//--------------------------------------------------------------
/**
 * XNvgIDABACe̔擾
 *
 * @param   scr_id		XNvgID
 *
 * @retval  ""
 *
 * BACẽXNvgĂԂ悤ɂI
 */
//--------------------------------------------------------------
u8 GetHideItemResponseByScriptId( u16 scr_id )
{
	int i;
	u8	index;
	const HIDE_ITEM_DATA* data;

	data	= &hide_item_data[0];
	index	= GetHideItemFlagIndexByScriptId(scr_id);			//tOCfbNX擾

	//T[`
	for( i=0; i < HIDE_ITEM_DATA_MAX ;i++ ){
		if( data[i].index == index ){
			break;
		}
	}

	//Ȃ
	if( i >= HIDE_ITEM_DATA_MAX ){
		GF_ASSERT( (0) && "BACef[^ɊYf[^܂I" );
		return 0;
	}

	return data[i].response;
}

//--------------------------------------------------------------
/**
 * BACep[^[NɃZbg
 *
 * @param   sc			EV_SCRIPT_WORK^̃|C^
 * @param   scr_id		XNvgID
 *
 * @retval  "0=ZbgsA1=Zbg"
 *
 * gpĂI
 * SCWK_PARAM0
 * SCWK_PARAM1
 * SCWK_PARAM2
 */
//--------------------------------------------------------------
static BOOL HideItemParamSet( EV_SCRIPT_WORK* sc, u16 scr_id )
{
	int i;
	u8	index;
	const HIDE_ITEM_DATA* data;
	u16* param0 = GetEvScriptWorkMemberAdrs_Sub( sc, ID_EVSCR_WK_PARAM0 );
	u16* param1 = GetEvScriptWorkMemberAdrs_Sub( sc, ID_EVSCR_WK_PARAM1 );
	u16* param2 = GetEvScriptWorkMemberAdrs_Sub( sc, ID_EVSCR_WK_PARAM2 );

	data	= &hide_item_data[0];
	index	= GetHideItemFlagIndexByScriptId(scr_id);		//tOCfbNX擾

	//T[`
	for( i=0; i < HIDE_ITEM_DATA_MAX ;i++ ){
		if( data[i].index == index ){
			break;
		}
	}

	//Ȃ
	if( i >= HIDE_ITEM_DATA_MAX ){
		GF_ASSERT( (0) && "BACef[^ɊYf[^܂I" );
		return 0;
	}

	*param0 = data[i].itemno;						//ACeio[
	*param1 = data[i].num;							//
	*param2 = GetHideItemFlagNoByScriptId(scr_id);	//tOio[

	return 1;
}

#define DEBUG_HIDE_ITEM_LIST	//fobNL
//--------------------------------------------------------------
/**
 * ʓɂBACeĊmۂXgɓo^
 *
 * @param   fsys		FIELDSYS_WORK^̃|C^
 * @param   heapid		q[vID
 *
 * @retval  "Xg̃AhX"
 *
 * YꂸɁI
 */
//--------------------------------------------------------------
HIDE_ITEM_LIST* HideItem_CreateList( FIELDSYS_WORK * fsys, int heapid );
HIDE_ITEM_LIST* HideItem_CreateList( FIELDSYS_WORK * fsys, int heapid )
{
	HIDE_ITEM_LIST* list;
	const BG_TALK_DATA* bg;
	int	hero_gx,hero_gz,i,max,count,tmp;
	int l,r,u,d;

	count = 0;

	//BGf[^擾
	max = EventData_GetNowBgTalkDataSize( fsys );
	max++;		//IR[ĥ+1

	//m
	list = sys_AllocMemory( heapid, sizeof(HIDE_ITEM_LIST) * max );

	//BGf[^݂ĂȂ
	if( max == 1 ){
		//IR[hZbg
		list[0].response= HIDE_LIST_RESPONSE_NONE;
		list[0].gx		= 0xffff;
		list[0].gz		= 0xffff;
		return list;
	}

	//BGf[^擾
	bg	= EventData_GetNowBgTalkData( fsys );
	if( bg == NULL ){
		//IR[hZbg
		list[0].response= HIDE_LIST_RESPONSE_NONE;
		list[0].gx		= 0xffff;
		list[0].gz		= 0xffff;
		return list;
	}

	//l̈ʒu擾
	hero_gx = Player_NowGPosXGet( fsys->player );
	hero_gz = Player_NowGPosZGet( fsys->player );

	//͈͂Zbg(3D͈ӎ̊ȈՔ)
	l = hero_gx - HIDE_LIST_SX;
	r = hero_gx + HIDE_LIST_SX;
	u = hero_gz - HIDE_LIST_TOP;
	d = hero_gz + HIDE_LIST_BOTTOM;

	//␳
	if( l < 0 ){ l = 0; }
	//if( r < 0 ){ 0 };
	if( u < 0 ){ u = 0; }
	//if( d < 0 ){ 0 };

#ifdef DEBUG_HIDE_ITEM_LIST
	OS_Printf( "\ń͈\n" );
	OS_Printf( "l = %d\n", l );
	OS_Printf( "r = %d\n", r );
	OS_Printf( "u = %d\n", u );
	OS_Printf( "d = %d\n", d );
#endif

	//BGf[^T[`
	for( i=0; i < max ;i++ ){

		//BACe^CvŁA܂肵ĂȂ
		if( (bg[i].type == BG_TALK_TYPE_HIDE) &&
			(CheckEventFlag(fsys, GetHideItemFlagNoByScriptId(bg[i].id)) == 0) ){

			//͈͓ɂ邩`FbN
			if( (bg[i].gx >= l) &&
				(bg[i].gx <= r) &&
				(bg[i].gz >= u) &&
				(bg[i].gz <= d) ){

				//XNvgIDABACe̔擾
				list[count].response= GetHideItemResponseByScriptId( bg[i].id );

#if 0
				//Ŵ܂ܑ
				list[count].gx		= bg[i].gx;
				list[count].gz		= bg[i].gz;

				//[JW
				list[count].gx		= (bg[i].gx % 32);
				list[count].gz		= (bg[i].gz % 32);
#endif	

				//0,0ƂĎ擾W
				//(l̈ʒu̍߂)
				tmp = ( hero_gx - bg[i].gx );
				list[count].gx = abs(HIDE_LIST_SX - tmp);
				tmp = ( hero_gz - bg[i].gz );
				list[count].gz = abs(HIDE_LIST_TOP - tmp);

#ifdef DEBUG_HIDE_ITEM_LIST
				OS_Printf( "\nl̈ʒu\n" );
				OS_Printf( "hero_gx = %d\n", hero_gx );
				OS_Printf( "hero_gz = %d\n", hero_gz );

				OS_Printf( "\nBACëʒu\n" );
				OS_Printf( "bg[i].gx = %d\n", bg[i].gx );
				OS_Printf( "bg[i].gz = %d\n", bg[i].gz );

				OS_Printf( "\n0,0ƂĎ擾W\n" );
				OS_Printf( "list[count].gx = %d\n", list[count].gx );
				OS_Printf( "list[count].gz = %d\n", list[count].gz );
#endif

				count++;
			}
		}
	}

	//IR[hZbg
	list[count].response= HIDE_LIST_RESPONSE_NONE;
	list[count].gx		= 0xffff;
	list[count].gz		= 0xffff;

	return list;
}


//============================================================================================
//
//	XNvg֘A
//
//============================================================================================

//------------------------------------------------------------------
/**
 * @brief	Q[Jn XNvgݒ̎s
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 *
 * @return	none
 */
//------------------------------------------------------------------
void GameStartScriptInit( FIELDSYS_WORK* fsys )
{
	SpScriptStart( fsys, SCRID_INIT_SCRIPT );

#ifdef PM_DEBUG

	//ufobNvIĂ
	if( DebugFlagData.debug_mode == TRUE ){

		//|PZnXgbp[폜AƂ蒠Cxg
		SpScriptStart( fsys, SCRID_DEBUG_PC_UG );
	}
#endif

	return;
}

//------------------------------------------------------------------
/**
 * @brief	EVENTł͂ȂXNvgs
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	scr_id		XNvgID
 *
 * @return	none
 *
 * ӁI
 * EV_SCRIPT_WORKmۂĂȂ̂ŁA
 * SCWK_ANSWERȂǂ̃[N͎gp邱ƂoȂI
 * LOCALWORK0Ȃǂgp悤ɂI
 *
 * ʃXNvgɂĂ͌gpsI
 * Ή\肾A][܂ɏ邩H
 * ܂ȂH
 *
 * tO`FWxŋʃXNvggƂ́A
 * tO`FWxƂɂȂ邩H
 * Е́A][łƂ́AЕ́AʃXNvgIDwHBBB
 */
//------------------------------------------------------------------
void SpScriptStart( FIELDSYS_WORK* fsys, u16 scr_id )
{
	VM_MACHINE*core = VMMachineAdd( fsys, scr_id );
	while( VM_Control( core ) == TRUE );
	script_del(core);	//XNvg폜
	return;
}

//------------------------------------------------------------------
/**
 * @brief	XNvgĎs
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	key			XNvgID
 *
 * @return	"TRUE=XNvgsAFALSE=Ȃ"
 */
//------------------------------------------------------------------
BOOL SpScriptSearch( FIELDSYS_WORK* fsys, u8 key )
{
	u16 scr_id;
	const u8 * p;

	p = EventData_GetSpecialScript(fsys);
	if (p == NULL) {
		return FALSE;
	}
	//XNvg
	if( key == SP_SCRID_SCENE_CHANGE ){
		scr_id = SpScriptSearch_Sub2( fsys, p, key );	//`FbNL
	}else{
		scr_id = SpScriptSearch_Sub( p, key );			//`FbN
	}

	//OS_Printf( "scr_id = %d\n", scr_id );
	if( scr_id == 0xffff ){
		return FALSE;
	}

	//XNvgs
	if( key == SP_SCRID_SCENE_CHANGE ){
		EventSet_Script( fsys, scr_id, NULL );
	}else{
		SpScriptStart( fsys, scr_id );
	}
	return TRUE;
}

//------------------------------------------------------------------
/**
 * @brief	wb_[f[^w^Cv̂̂
 *
 * @param	key			XNvgID
 *
 * @return	"XNvgID"
 */
//------------------------------------------------------------------
static u16 SpScriptSearch_Sub(const u8 * p, u8 key )
{

	while( 1 ){
		//ILq`FbN(SP_EVENT_DATA_END)
		if( *p == SP_SCRID_NONE ){
			return 0xffff;
		}

		//w^Cv̓XNvg
		if( *p == key ){
			p++;								//XNvgID
			return ( *p + ( *(p+1)<<8 ) );		//XNvgIDԂ
		}

		p += (1 + 2 + 2);						//XNvgID+XNvgID+_~[
	}

	return 0xffff;								//Ȃ
}

//------------------------------------------------------------------
/**
 * @brief	wb_[f[^w^Cv̂̂(V[Cxg)
 *
 * @param	key			XNvgID
 *
 * @return	"XNvgID"
 */
//------------------------------------------------------------------
static u16 SpScriptSearch_Sub2( FIELDSYS_WORK* fsys, const u8 * p, u8 key )
{
	u16 work1,work2;
	u32 pos;

	pos = 0;

	while( 1 ){
		//ILq`FbN(SP_EVENT_DATA_END)
		if( *p == SP_SCRID_NONE ){
			return 0xffff;
		}

		//w^Cv̓XNvg
		if( (*p) == key ){
			p++;								//XNvgID
			pos = ( *p + ( *(p+1)<<8 ) + ( *(p+2)<<16 ) + ( *(p+3)<<24 ) );
			p += 4;								//AhX
			break;
		}

		p += (1 + 4);							//XNvgID+AhX
	}

	//Ȃ
	if( pos == 0 ){
		return 0xffff;
	}

	//XNvge[uZbg
	p = (p + pos);

	while ( TRUE ) {
		//ILq`FbN(SP_SCRIPT_END)
		if( *p == 0 ){
			return 0xffff;
		}

		//r[N擾
		work1 = ( *p + ( *(p+1)<<8 ) );
		if( work1 == 0 ){
			return 0xffff;
		};
		p += 2;									//[N
		//OS_Printf( "work1 = %d\n", work1 );

		//rl([N)擾
		work2 = ( *p + ( *(p+1)<<8 ) );
		p += 2;									//rl([N)
		//OS_Printf( "work2 = %d\n", work2 );

		//`FbN
		if( GetEventWorkValue(fsys,work1) == GetEventWorkValue(fsys,work2) ){
			return ( *p + ( *(p+1)<<8 ) );
		}

		p += 2;									//XNvgID
	}

	return 0xffff;								//Ȃ
}


//============================================================================================
//
//	gp
//
//============================================================================================
#if 0
static void FieldScriptLoad( u16 map, u16 id );
static void FieldScriptFileNameMake( char * path, u16 map, u16 id );

static VM_MACHINE field_script;			// z}Vp\
static u8 field_script_status;			// XNvgԕϐ
//static u8 ForceEventFlag;				// CxgtO
static VM_CODE * pScript = NULL;		// ʏXNvg
//static u16 * ScriptWork = NULL;		// XNvg[N

//	XNvgԒ`
enum{
	SCRIPT_ON,
	SCRIPT_WAIT,
	SCRIPT_OFF,
};

static void FieldScriptFileNameMake( char * path, u16 map, u16 id )
{
	strcpy( path, "/data/script/script_map" );

	StrNumSet( &path[23], map, 3 );		// "/data/script/script_map"
	strcat( path, "_" );
	StrNumSet( &path[27], id, 2 );		// "/data/script/script_map000_"
	strcat( path, ".dat" );
}

static void FieldScriptLoad( u16 map, u16 id )
{
	char * path;

	path = (char *)sys_AllocMemory( APP_W_HEAP_AREA, 48 );
	FieldScriptFileNameMake( path, map, id );
	pScript = (VM_CODE *)sys_LoadFile( APP_W_HEAP_AREA, path );
	sys_FreeMemory( APP_W_HEAP_AREA, path );
}

//--------------------------------------------------------------------------------------------
/**
 * XNvgN`FbN
 *
 * @param	none
 *
 * @retval	"TRUE = NĂ"
 * @retval	"FALSE = NĂȂ"
 */
//--------------------------------------------------------------------------------------------
u8 CheckScriptStatus(void)
{
	if( field_script_status == SCRIPT_ON ){
		return TRUE;
	}
	return FALSE;
}

#endif


//============================================================================================
//
//	VMMachineTCBǉ
//
//============================================================================================

#if 0
//--------------------------------------------------------------
/**
 * @brief	z}Vǉ
 *
 * @param	fsys		FIELDSYS_WORK^̃|C^
 * @param	id			XNvgID
 * @param	start		߃e[uJnAhX
 * @param	end			߃e[uIAhX
 *
 * @retval	none
 */
//--------------------------------------------------------------
void VMMachineAddTCB(FIELDSYS_WORK* fsys, u16 id, const VM_CMD* start, const VM_CMD* end)
{
	EV_SCRIPT_WORK * sc;
	VM_MACHINE* core = NULL;

	sc = FieldEvent_GetSpecialWork( fsys->event );

	//core = sys_AllocMemory( HEAPID_FIELD, sizeof(VM_MACHINE) );
	core = sys_AllocMemory( HEAPID_WORLD, sizeof(VM_MACHINE) );
	if( core == NULL ){
		GF_ASSERT( (0) && "mۂɎs܂I" );
	}

	//z}V
	//VM_Init( core, &ScriptCmdTbl[0], &ScriptCmdTbl[EVCMD_MAX] );
	VM_Init( core, start, end );

	InitScript( fsys, core, id, 0 );							//[JXNvg
	
	TCB_Add( VMMachineControlTCB, core, 0 );
	sc->vm_machine_count++;
	return;
}

//--------------------------------------------------------------
/**
 * @brief	TCBC
 *
 * @param	tcb		TCB_PTR
 * @param	wk		[ÑAhX
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void VMMachineControlTCB( TCB_PTR tcb, void* wk )
{
	VM_MACHINE *core;
	FIELDSYS_WORK* fsys;
	EV_SCRIPT_WORK * sc;

	core = (VM_MACHINE *)wk;
	fsys = FieldEvent_GetFieldSysWork( core->event_work );
	sc = FieldEvent_GetSpecialWork( fsys->event );

	if( VM_Control( core ) == FALSE ){

		MSGMAN_Delete( core->msgman );

		sys_FreeMemoryEz( core->pScript );			//XNvgf[^

		TCB_Delete( tcb );
		sys_FreeMemoryEz( core );

		if( sc->vm_machine_count == 0 ){
			GF_ASSERT( (0) && "z}V̐słI" );
		}

		sc->vm_machine_count--;
	};

	return;
}
#endif

