//============================================================================================
/**
 * @file	sp_attribute.c
 * @brief	}gbNX֘A
 * @author	Nozomu Saito
 * @date	2006.02.17
 */
//============================================================================================
#include "common.h"
#include "fieldsys.h"
#include "worldmap.h"
#include "sp_attribute_def.h"

#include "system/arc_tool.h"

#define SP_MAP_SIZE			(15)

typedef struct SP_MATRIX_DATA_tag{
	u8 Matrix[SP_MAP_SIZE*SP_MAP_SIZE];
	u16 GroundAttr[GROUND_ATTR_SIZE];
}SP_MATRIX_DATA;

static void MakeSpMatrix(WORLD_MAP_PTR inWorld, SMD_PTR outUgMatrixData, const u8 inNum);
static const u8 AddSpArcList(const u16 inArcIndex, u16 *outList, u8 *ioListPos);

//--------------------------------------------------------------------------------------------
/**
 * Agr[gZbgAbv
 *
 * @param	fsys			tB[hVXe|C^
 * @param	inNum			f[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void SPATTR_SetUpGroundAttr(FIELDSYS_WORK *fsys, const u8 inNum)
{
	int i;
	void *mem;	
	//AP[V
	if (fsys->SpMatData == NULL){
		fsys->SpMatData = sys_AllocMemory( HEAPID_WORLD, sizeof(SP_MATRIX_DATA) );
		//}gNX쐬
		MakeSpMatrix(fsys->World, fsys->SpMatData, inNum);
		
	}
}

//--------------------------------------------------------------------------------------------
/**
 * Agr[g
 *
 * @param	fsys			tB[hVXe|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void SPATTR_FreeGroundAttr(FIELDSYS_WORK *fsys)
{
	if (fsys->SpMatData != NULL){
		sys_FreeMemoryEz(  fsys->SpMatData );
		fsys->SpMatData = NULL;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * Agr[gubN擾
 *
 * @param	inBlockindex	ubNCfbNX 
 * @param	inSpMatrixData	}gNXf[^
 *
 * @return	block_attr	ubNAgr[g擪|C^
 */
//--------------------------------------------------------------------------------------------
u16 const * SPATTR_GetSpBlockAttribute(const u32 inBlockindex, SMD_CONST_PTR inSpMatrixData)
{
	u16 const *block_attr;
	u8 list_idx;
	list_idx = inSpMatrixData->Matrix[inBlockindex];
	block_attr = (u16 const *)&(inSpMatrixData->GroundAttr[BLOCK_ATTR_SIZE*list_idx]);
	return block_attr;
}

//--------------------------------------------------------------------------------------------
/**
 * }gNX쐬
 *
 * @param	inWorld			[h|C^
 * @param	outSpMatrixData	}gNXf[^
 * @param	inNum			f[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void MakeSpMatrix(WORLD_MAP_PTR inWorld, SMD_PTR outSpMatrixData, const u8 inNum)
{
	u8 list_pos;
	u16 arc_idx;
	u8 list_idx;
	u16 idx;
	int i,j;
	int h,w;
	u16 list[SP_ATTR_DATA_NUM_MAX];
	void *mem;
	ARCHANDLE *arc_handle;

	list_pos = 0;

	//݃}bv}gNX擾
	w = GetWorldMapMatrixW(inWorld);
	h = GetWorldMapMatrixH(inWorld);

	//Agr[g擾pɃ}gNX쐬
	for(j=0;j<h;j++){
		for(i=0;i<w;i++){
			idx = j*w+i;
			arc_idx = GetArcIndexFromBlockIndex(idx,inWorld);
#ifdef DEBUG_ONLY_FOR_saitou			
			OS_Printf("local_print %d:arc_idx:%d\n",idx,arc_idx);
#endif			
			//}gbNX̃A[JCuCfbNXXgɒǉ
			list_idx = AddSpArcList(arc_idx, list, &list_pos);
			outSpMatrixData->Matrix[idx] = list_idx;
		}
	}
	//Agr[g܂Ƃ߂ă[h
	//A[JCunh̎擾
	arc_handle = ArchiveDataHandleOpen( ARC_FIELD_MAP_DATA, HEAPID_WORLD );

	for(i=0;i<inNum;i++){
		arc_idx = list[i];
		mem = &(outSpMatrixData->GroundAttr[BLOCK_ATTR_SIZE*i]);
		//Agr[g̓A[JCuf[^̐擪ŒoCgTCYȂ̂ŁAItZbgATCY擾͏Ȃ
		ArchiveDataLoadOfsByHandle( arc_handle, arc_idx, 0x10, 0x800,  mem);
	}
	//A[JCunh̉
	ArchiveDataHandleClose( arc_handle );
}

//--------------------------------------------------------------------------------------------
/**
 * Xgɓo^
 *
 * @param	inArcIndex	A[JCuCfbNX
 * @param	outList		Xg
 * @param	ioListPos	Xgʒu
 *
 * @return	u8			o^ĂijXgCfbNX
 */
//--------------------------------------------------------------------------------------------
static const u8 AddSpArcList(const u16 inArcIndex, u16 *outList, u8 *ioListPos)
{
	u8 i;
	//w肵A[JCuCfbNXXgɓo^ĂȂΒǉ
	for(i=0;i<(*ioListPos);i++){
		if (outList[i] == inArcIndex){
			return i;	//łɓo^ς
		}
	}
	//VKo^
	GF_ASSERT( i<SP_ATTR_DATA_NUM_MAX && "f[^I[o[Ă܂" );
	outList[i] = inArcIndex;
	(*ioListPos)++;
	return i;
	
}
