//============================================================================================
/**
 * @file	sway_grass_enc.c
 * @brief	hꑐGJEg
 * @author	saito GAME FREAK inc.
 * @date	2006.02.14
 */
//============================================================================================

#include "sway_grass_enc.h"
#include "field_effect.h"
#include "map_tool.h"

#include "fieldsys.h"	//for savedata

#include "bounding_box.h"

#include "battle/battle_common.h"	//for FIGHT_WIN, FIGHT_POKE_GET

#include "system/snd_tool.h"
#include "fld_bgm.h"

#include "savedata/encount.h"

#include "itemtool/itemsym.h"
#include "encount_define.h"

#include "script.h"		//for GetEvScriptWorkMemberAdrs
#include "fielddata/script/pokesearcher_def.h"
#include "sway_grass_hist.h"

#define ISMIN(rc,a,b) { \
	(a<b)? (rc=TRUE):(rc=FALSE); \
}

#define SEARCH_AROUND		(4)
#define SEARCH_WIDTH_MAX	(9)
#define SEARCH_OFFS			(SEARCH_WIDTH_MAX/2)
#define SERCH_NUM_ROUND1	(32)	//OO
#define SERCH_NUM_ROUND2	(24)	//
#define SERCH_NUM_ROUND3	(16)	//
#define SERCH_NUM_ROUND4	(8)		//O

#define RARE_POKE_PROP_MAX	(8200)	//ő8200
#define RARE_POKE_PROP_MIN	(200)	//ŏ200
#define SUB_PROP			(200)	//m

enum {
	SEQ_SWAY_SEARCH,
	SEQ_SWAY_BGM_START,
	SEQ_SWAY_WAIT,
	SEQ_SWAY_NG,
	SEQ_SWAY_END
};

typedef struct SWAY_GRASS_INFO_tag
{
	int GridX;
	int GridZ;
	int EncTblCode;	//GJEge[uR[h
	BOOL	SwayGrassFlg;
	BOOL	ChainFlg;	//AtO
	BOOL	IsRare;
	EOA_PTR	GrassAnime;
	VecFx32 GrassPos;
}SWAY_GRASS_INFO;

typedef struct SWAY_GRASS_tag{
	int EncTblCode;			//GJEge[uR[h
	int Chain;				//A
	int EncMonsNo;			//hꑐGJEgX^[io[
	int EncMonsLv;				//hꑐGJEgX^[x
	BOOL Valid;		//hꑐǂ
	BOOL FirstEnc;			//hꑐGJEg
	BOOL SwayEncReturn;	//ꑐ퓬ƂĕA
	SWAY_GRASS_INFO GrassInfo[SEARCH_AROUND];
	BOUNDING_BOX	BoundingBox;
	u8 RewritePos;			//`F[R[hʒu
}SWAY_GRASS;

static BOOL SetSwayGrassInfo(	FIELDSYS_WORK * fsys,
							const fx32 inPlayerHeight,
							const int inX, const int inZ,
							const u8 inSearchX, const u8 inSearchZ,
							SWAY_GRASS_INFO *outInfo	);
static BOOL CheckSwayGrass(	const SWAY_GRASS_PTR inSwayGrass,
							const int inX, const int inZ,
							u8 *outRound);
static void UpdateSwayGrassHist(FIELDSYS_WORK * fsys, SWAY_GRASS_PTR ioSwayGrass);
static u8 GetSwayGrassMinRecordPos(FIELDSYS_WORK * fsys);
static BOOL GetChainFlg(const u8 inRound, const int inBattleResult);
static BOOL SwayGrassSetupEvent(GMEVENT_CONTROL * event);
static BOOL CheckRare(const int inChain);
static void IncChain(int *outChain);

//-----------------------------------------------------------------------------
/**
 * @brief	mۊ֐
 * @param	inHeapID	q[vID
 * 
 * @retval	ptr			ꑐ\̂ւ̃|C^
 *
 */
//-----------------------------------------------------------------------------
SWAY_GRASS_PTR SwayGrass_AllocSwayGrass(const int inHeapID)
{
	SWAY_GRASS_PTR ptr;
	ptr = sys_AllocMemory(inHeapID, sizeof(SWAY_GRASS) );
	//oEfBO{bNX쐬(PObhAObhAsPObh)
	BB_MakeBoundingBox(FX32_ONE*16,FX32_ONE*8,FX32_ONE*16,&ptr->BoundingBox);
	return ptr;
}

//-----------------------------------------------------------------------------
/**
 * @brief	֐	(Q[n߂ɊmۂāÂ܂܂Ȃ̂ŉȂ)
 * @param	outSwayGrass		ꑐ\̂ւ̃|C^
 * 
 * @retval	
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_FreeSwayGrass(SWAY_GRASS_PTR outSwayGrass)
{
	sys_FreeMemoryEz(outSwayGrass);
}

//-----------------------------------------------------------------------------
/**
 * @brief	
 * @param	outSwayGrass		ꑐ\̂ւ̃|C^
 * 
 * @retval	none
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_InitSwayGrass(SWAY_GRASS_PTR outSwayGrass)
{
	u8 i;
	outSwayGrass->Chain = 0;
	outSwayGrass->EncTblCode = SWAY_GRASS_ENC_NORMAL;
	outSwayGrass->EncMonsNo = 0;
	outSwayGrass->EncMonsLv = 0;
	outSwayGrass->Valid = FALSE;
	outSwayGrass->RewritePos = 0;
	outSwayGrass->FirstEnc = TRUE;
	outSwayGrass->SwayEncReturn = FALSE;
	
	MI_CpuClear8(&(outSwayGrass->GrassInfo[0]), sizeof(SWAY_GRASS_INFO)*SEARCH_AROUND);
	for(i=0;i<SEARCH_AROUND;i++){
		outSwayGrass->GrassInfo[i].SwayGrassFlg = FALSE;
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	hꑐ{
 * @param	fsys			tB[hVXe|C^
 * @param	inX				SXW
 * @param	inZ				SZW
 * @param	ioSwayGrass	hꑐ\̂ւ̃|C^
 * 
 * @retval	BOOL		TRUE:hꑐL@FALSE:hꑐ
 *
 */
//-----------------------------------------------------------------------------
BOOL SwayGrass_SearchSwayGrass(	FIELDSYS_WORK * fsys,
								const int inX, const int inZ,
								SWAY_GRASS_PTR ioSwayGrass)
{
	u8 i;				//OJE^
	u8 size_x,size_z;	//OcTCY
	u8 num;				//ԍ
	u8 t_num;			//vZe|
	int x,z;			//W
///	BOOL chain_flg;		//AtO
	u8 valid_num;		//hꑐ

	const VecFx32 *player_vec;

	u8	rand_list[SEARCH_AROUND] = {	//_e[uieÕ_őlj
		SERCH_NUM_ROUND1,	//ԊO
		SERCH_NUM_ROUND2,
		SERCH_NUM_ROUND3,
		SERCH_NUM_ROUND4	//ԓ
	};

	//@擾
	player_vec = Player_VecPosPtrGet( fsys->player );

	valid_num = 0;
	for(i=0;i<SEARCH_AROUND;i++){
		BOOL rc;
		//ΏۍW_Ō
		num = gf_p_rand(rand_list[i]);
		//OS_Printf("num%d\n",num);
		//ݒ
		size_x = SEARCH_WIDTH_MAX-(i*2);
		//cݒ
		size_z = SEARCH_WIDTH_MAX-(i*2);

		//肵ԍ𕝂Ŋ
		t_num = num/size_x;
		//0ȂOA1Ȃ牺
		//AɃqbgꍇA]łWi͏Łj
		if (t_num == 0){
			x = i+num%size_x;
			z = i;
		}else if(t_num == 1){
			x = i+num%size_x;
			z = i+size_z-1;
		}else{
			//	//qbgȂꍇA肵ԍ-*2
			GF_ASSERT( num>=(size_x*2) );
			t_num = num-(size_x*2);
			//Hԍ2Ŋ
			//+1zi͍AEȂ̂ŁAŔfj
			z = i+(t_num/2)+1;
			if (t_num%2 == 0){	//O
				x = i;
			}else{				//OE
				x = i+size_x-1;
			}
		}
#if 0		
		//A邩ǂ
		chain_flg = GetChainFlg(i,inBattleResult);
#endif
		//OS_Printf("grass_anime%d,%d\n",x,z);

		//肵W̏Zbg
		rc = SetSwayGrassInfo(	fsys, player_vec->y, inX, inZ, x, z,
								&ioSwayGrass->GrassInfo[i]);
		if (rc){
			valid_num++;
		}
	}

	if (valid_num == 0){
		SwayGrass_InitSwayGrass(ioSwayGrass);
		//ȏI点
		Snd_FadeOutNextPlayCall(fsys,
								Snd_FieldBgmNoGet(fsys,fsys->location->zone_id),
								BGM_FADE_FIELD_MODE );
	}else{
		ioSwayGrass->Valid = TRUE;
	}

	return ioSwayGrass->Valid;
}

//-----------------------------------------------------------------------------
/**
 * @brief	Aݒ
 * @param	fsys			tB[hVXe|C^
 * @param	inBattleResult	퓬	 FIGHT_WIN	FIGHT_POKE_GET
 * @param	ioSwayGrass	hꑐ\̂ւ̃|C^
 * 
 * @retval	none
 *
 */
//-----------------------------------------------------------------------------
void	SwayGrass_SetChain(	FIELDSYS_WORK * fsys,
								const int inBattleResult,
								SWAY_GRASS_PTR ioSwayGrass)
{
	u8 i;				//OJE^
	for(i=0;i<SEARCH_AROUND;i++){
		if ( ioSwayGrass->GrassInfo[i].SwayGrassFlg){
			//A邩ǂ
			ioSwayGrass->GrassInfo[i].ChainFlg = GetChainFlg(i,inBattleResult);//AtOZbg
			//GJEge[uZbg
			if (!ioSwayGrass->GrassInfo[i].ChainFlg){
				//AȂ̂Ńe[u̒I(m1/2)
				if(gf_p_rand(100) < 50){	//m[}
					ioSwayGrass->GrassInfo[i].EncTblCode = SWAY_GRASS_ENC_NORMAL;
				}else{		//e[uύX
					ioSwayGrass->GrassInfo[i].EncTblCode = SWAY_GRASS_ENC_SP;
				}
				ioSwayGrass->GrassInfo[i].IsRare = FALSE;
			}else{
				//Aꍇ͑Õe[up
				ioSwayGrass->GrassInfo[i].EncTblCode = ioSwayGrass->EncTblCode;
				//A|PI
				ioSwayGrass->GrassInfo[i].IsRare = CheckRare(fsys->SwayGrass->Chain);
			}
		}
	}
}


//-----------------------------------------------------------------------------
/**
 * @brief	ꑐAjZbg
 * @param	fsys		tB[hVXe|C^
 * @param	outSwayGrass		ꑐ\̂ւ̃|C^
 * 
 * @retval	none
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_SetSwayGrassAnime(FIELDSYS_WORK * fsys, SWAY_GRASS_PTR outSwayGrass)
{
	u8 i;
	for(i=0;i<SEARCH_AROUND;i++){
		if (outSwayGrass->GrassInfo[i].SwayGrassFlg){
			int x = outSwayGrass->GrassInfo[i].GridX;
			int z = outSwayGrass->GrassInfo[i].GridZ;
			//AtOĂ邩ŃAj
			if (outSwayGrass->GrassInfo[i].IsRare){
				//A|PGJEgpAjZbg
				outSwayGrass->GrassInfo[i].GrassAnime =
					FE_EncGrass_Add( fsys, x, z, FE_GRASS_TYPE_ENCOUNT_KIRAKIRA );
			}else{
				//ZbgĂe[uR[hŃAj𕪊
				if (outSwayGrass->GrassInfo[i].EncTblCode == SWAY_GRASS_ENC_NORMAL){
					//ʏe[u
					outSwayGrass->GrassInfo[i].GrassAnime =
						FE_EncGrass_Add( fsys, x, z, FE_GRASS_TYPE_ENCOUNT_SMALL );
				}else{
					//hꑐpe[u
					outSwayGrass->GrassInfo[i].GrassAnime =
						FE_EncGrass_Add( fsys, x, z, FE_GRASS_TYPE_ENCOUNT_BIG );
				}
			}
		}else{
			outSwayGrass->GrassInfo[i].GrassAnime = NULL;
		}
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐAjI҂
 * @param	ioSwayGrass		ꑐ\̂ւ̃|C^
 * 
 * @retval	BOOL	TRUE:AjI	FALSE:Ajp
 *
 */
//-----------------------------------------------------------------------------
BOOL SwayGrass_CheckSwayGrassAnimeEnd(SWAY_GRASS_PTR ioSwayGrass)
{
	u8 count;
	u8 i;
	count = 0;
	for(i=0;i<SEARCH_AROUND;i++){
		if (ioSwayGrass->GrassInfo[i].GrassAnime != NULL){
			
			if (FE_EncGrass_AnimeCheck( ioSwayGrass->GrassInfo[i].GrassAnime )){
				EOA_Delete( ioSwayGrass->GrassInfo[i].GrassAnime );
				ioSwayGrass->GrassInfo[i].GrassAnime = NULL;
				count++;
			}
		}else{
			count++;
		}
	}
	if(count >= SEARCH_AROUND){
		return TRUE;
	}

	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐ`FbN
 * @param	fsys		tB[hVXe|C^
 * @param	ioSwayGrass		ꑐ\̂ւ̃|C^
 * @param	outUseEncTable	gpGJEge[uR[h
 * @param	outMonsDeside	GJEg|P肵Ă邩tO
 * @param	outRare			AtO
 * 
 * @retval	BOOL	TRUE:hꑐGJEg@FALSE:hꑐGJEgs
 *
 */
//-----------------------------------------------------------------------------
BOOL SwayGrass_CheckSpEncount(	const int inX, const int inZ,
								FIELDSYS_WORK * fsys,
								SWAY_GRASS_PTR ioSwayGrass,
								int *outUseEncTable,
								BOOL *outMonsDeside,
								BOOL *outRare)
{
	u8 round;
	BOOL chain_flg;
	int tbl_code;
	
	*outMonsDeside = FALSE;
	*outRare = FALSE;
	//ꑐGJEgǂ`FbN
	if ( !CheckSwayGrass(ioSwayGrass, inX, inZ, &round) ){
		//񂾍Whꑐł͂Ȃ
		return FALSE;//SWAY_GRASS_ENC_NO_ENC;
	}
	
	ioSwayGrass->SwayEncReturn = TRUE;	//퓬͂ꑐ
	
	chain_flg = ioSwayGrass->GrassInfo[round].ChainFlg;
	tbl_code = ioSwayGrass->GrassInfo[round].EncTblCode;
	//߂ăGJEg`FbN	
	if(ioSwayGrass->FirstEnc == FALSE){ //߂Ăł͂Ȃ
		if(chain_flg){			//AȂA|P
			IncChain(&(ioSwayGrass->Chain));		//A+1
			//*outUseEncTable = ioSwayGrass->EncTblCode;//ۑƂR[h
			*outUseEncTable = tbl_code;	//SwayGrass̃o璼Ɏ邱Ƃ\ǂAInfo
			*outMonsDeside = TRUE;
			//hꑐGJEg`FbNƍXV
			UpdateSwayGrassHist(fsys, ioSwayGrass);
			//ioSwayGrass->SwayGrassEnc = TRUE;	//hꑐGJEgtOI
			
			(*outRare) = ioSwayGrass->GrassInfo[round].IsRare;	//AtOZbg
			
			return TRUE;//SWAY_GRASS_ENC_KEEP_MONSTER;
		}else{		//Ⴄ|P
			*outUseEncTable = tbl_code;	//GJEge[uR[hZbg
		}
	}else{	//߂ėhꑐ
		*outUseEncTable = tbl_code;
		ioSwayGrass->FirstEnc = FALSE;
		//ΏۂƂȂhꑐGJEg擾
		//(3̗̒ňԘAȂR[h̏ꏊ擾)
		ioSwayGrass->RewritePos = GetSwayGrassMinRecordPos(fsys);
	}
	
	//ǂ̃e[uKpۑ
	ioSwayGrass->EncTblCode = *outUseEncTable;

	//ioSwayGrass->SwayGrassEnc = TRUE;	//hꑐGJEgtOI
	
	return TRUE;//SWAY_GRASS_ENC_START;
}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐGJEg|PL(io[Ax)
 * @param	outSwayGrass		ꑐ\̂ւ̃|C^
 * @param	inMonsNo			GJEgX^[io[
 * @param	inMonsLv			GJEgX^[x
 *
 * @retval	none
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_SetEncMonsNoLv(SWAY_GRASS_PTR outSwayGrass, const int inMonsNo, const int inMonsLv)
{
	GF_ASSERT(inMonsNo != 0);
	outSwayGrass->EncMonsNo = inMonsNo;
	outSwayGrass->EncMonsLv = inMonsLv;
}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐGJEg|P擾iio[Axj
 * @param	inSwayGrass		ꑐ\̂ւ̃|C^
 * @param	outMonsNo		GJEgX^[io[i[
 * @param	outMonsLv		GJEgX^[xi[
 *
 * @retval	none
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_GetEncMonsNoLv(SWAY_GRASS_PTR inSwayGrass,  int *outMonsNo, int *outMonsLv)
{
	(*outMonsNo) = inSwayGrass->EncMonsNo;
	(*outMonsLv) = inSwayGrass->EncMonsLv;

}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐGJEgA𒲂ׂ
 * @param	inSwayGrass		ꑐ\̂ւ̃|C^
 * @retval	BOOL		TRUE:hꑐGJEgA		FALSE:ʏGJEgA				
 *
 */
//-----------------------------------------------------------------------------
const BOOL SwayGrass_IsSwayEncRetern(const SWAY_GRASS_PTR inSwayGrass)
{
	return inSwayGrass->SwayEncReturn;
}

//-----------------------------------------------------------------------------
/**
 * @brief	ʓO`FbN
 * @param	fsys			tB[hVXe|C^
 * 
 * @retval	none
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_CheckIO(FIELDSYS_WORK * fsys)
{
	BOOL rc;
	SWAY_GRASS_INFO *info;
	
	int i;

	if ((!fsys->SwayGrass->Valid)||(fsys->event!=NULL)){
		return;
	}
	
	//ʓO`FbN
	for(i=0;i<SEARCH_AROUND;i++){
		info = &(fsys->SwayGrass->GrassInfo[i]);
		rc = BB_CullingCheck3DModelNonResQuick( &(info->GrassPos),
											 &(fsys->SwayGrass->BoundingBox) );
		if ((info->SwayGrassFlg)&&(!rc)){
			//ɂ
			info->SwayGrassFlg = FALSE;
		}
	}
	//S`FbN
	{
		int count;
		count = 0;
		for(i=0;i<SEARCH_AROUND;i++){
			info = &(fsys->SwayGrass->GrassInfo[i]);
			if (info->SwayGrassFlg == FALSE){
				count++;
			}
		}
		if (count == SEARCH_AROUND){
			///OS_Printf("hꑐ͖ɂȂ܂\n");
			SwayGrass_InitSwayGrass(fsys->SwayGrass);			
			//ȏI点
			Snd_FadeOutNextPlayCall(fsys,
									Snd_FieldBgmNoGet(fsys,fsys->location->zone_id),
									BGM_FADE_FIELD_MODE );
		}
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐL`FbN
 * @param	inSwayGrass	hꑐ\̂ւ̃|C^
 *
 * @retval	BOOL	TRUE:hꑐL		FALSE:hꑐ
 *
 */
//-----------------------------------------------------------------------------
BOOL SwayGrass_CheckValid( const SWAY_GRASS_PTR inSwayGrass )
{
	return inSwayGrass->Valid;
}


//-----------------------------------------------------------------------------
/**
 * @brief	ꑐZbg
 * @param	fsys			tB[hVXe|C^
 * @param	inPlayerHeight	@
 * @param	inX				SXW
 * @param	inZ				SZW
 * @param	inSearchX		XWi΁j
 * @param	inSearchZ		ZWi΁j
 * @param	outInfo			ꑐ\̂ւ̃|C^
 * 
 * @retval	BOOL			TRUE:hꑐL		FALSE:hꑐ
 *
 */
//-----------------------------------------------------------------------------
static BOOL SetSwayGrassInfo(	FIELDSYS_WORK * fsys,
								const fx32 inPlayerHeight,
								const int inX, const int inZ,
								const u8 inSearchX, const u8 inSearchZ,
								SWAY_GRASS_INFO *outInfo	)
{
	int x,z;
	MATR attr;
	x = (inX-SEARCH_OFFS)+inSearchX;
	z = (inZ-SEARCH_OFFS)+inSearchZ;
	//Wۑ
	outInfo->GridX = x;
	outInfo->GridZ = z;
	//Agr[g{
	attr = GetAttributeLSB(fsys, x, z);
	
	if (  MATR_IsGrass(attr) ){
		HEIGHT_TYPE code;
		//fx32^̍W擾
		outInfo->GrassPos.x = FX32_ONE*16*x;
		outInfo->GrassPos.z = FX32_ONE*16*z;
		outInfo->GrassPos.y = GetHeightPack(fsys,
											0, outInfo->GrassPos.x, outInfo->GrassPos.z,
											&code);
		//擾āA@̍Ɣr
		if (inPlayerHeight != outInfo->GrassPos.y){
			//ł͂Ȃ̂ŁA͂˂
			outInfo->SwayGrassFlg = 0;
			OS_Printf("Ⴄ̂ŁAhꑐƂ݂Ȃ\n");
			return FALSE;
		}
		//][hcႤꍇ́A͂˂
		{
			int zone_id;
			int block_x,block_z;
			block_x = x/BLOCK_GRID_W;
			block_z = z/BLOCK_GRID_H;
			zone_id = World_GetZoneIDFromMatrixXZ(fsys->World, block_x, block_z);
			if (fsys->location->zone_id != zone_id){
				outInfo->SwayGrassFlg = 0;
				OS_Printf("][hcႤ̂ŁAhꑐƂ݂Ȃ\n");
				return FALSE;
			}
		}
		

		//ȂꑐtO𗧂Ă
		outInfo->SwayGrassFlg = 1;
		
		return TRUE;
	}else{
		//ł͂Ȃ̂ŃtOIt
		outInfo->SwayGrassFlg = 0;
		return FALSE;
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐ`FbN
 * @param	inSwayGrass	hꑐ\̂ւ̃|C^
 * @param	inX			XW
 * @param	inZ			ZW
 * @param	outRound	qbg
 *
 * @retval	BOOL	TRUE:hꑐqbg		FALSE:hꑐqbgĂȂ
 *
 */
//-----------------------------------------------------------------------------
static BOOL CheckSwayGrass(	const SWAY_GRASS_PTR inSwayGrass,
							const int inX, const int inZ,
							u8 *outRound)
{
	u8 i;
	for(i=0;i<SEARCH_AROUND;i++){
		if (inSwayGrass->GrassInfo[i].SwayGrassFlg){
			if ( (inSwayGrass->GrassInfo[i].GridX == inX) &&
					(inSwayGrass->GrassInfo[i].GridZ == inZ) ){
				*outRound = i;
				return TRUE;
			}
		}
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	ꑐ`FbNƍXV
 * @param	fsys		tB[hVXe|C^	
 * @param	inSwayGrass	ꑐ\̂ւ̃|C^	
 *
 * @retval	none
 *
 */
//-----------------------------------------------------------------------------
static void UpdateSwayGrassHist(FIELDSYS_WORK * fsys, SWAY_GRASS_PTR ioSwayGrass)
{
	SWAY_GRASS_HIST * hist;
	int chain;
	int i;
	hist = EncDataSave_GetSwayGrassHist( EncDataSave_GetSaveDataPtr(fsys->savedata) );
	chain = hist->SwayGrassRec[ioSwayGrass->RewritePos].Chain;
	if (chain < ioSwayGrass->Chain){//L^H
		//XV
		hist->SwayGrassRec[ioSwayGrass->RewritePos].Chain = ioSwayGrass->Chain;
		hist->SwayGrassRec[ioSwayGrass->RewritePos].MonsNo = ioSwayGrass->EncMonsNo;
		//\[g
		SwayGrassHist_SortHistData(hist);
		//ʒȗ{
		if (hist->SwayGrassRec[ioSwayGrass->RewritePos].Chain <= ioSwayGrass->Chain){
			//ʒuꂽ̂ő{
			for(i=0;i<3;i++){
				if ( hist->SwayGrassRec[(2-i)].Chain == ioSwayGrass->Chain){
					ioSwayGrass->RewritePos = (2-i);
					return;
				}	
			}
			//ɂ͂Ȃ͂BĂ܂ꍇ͏]̏ʒu(ʒuύXȂ)
			GF_ASSERT(0);
		}
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	hꑐR[h̏ʒu擾
 *
 * @param	fsys	tB[hVXe|C^	
 *
 * @retval	u8		ʒu
 *
 */
//-----------------------------------------------------------------------------
static u8 GetSwayGrassMinRecordPos(FIELDSYS_WORK *fsys)
{
	SWAY_GRASS_HIST * hist;
	u8 pos;
	BOOL rc;

	hist = EncDataSave_GetSwayGrassHist( EncDataSave_GetSaveDataPtr(fsys->savedata) );

	//LOĂȂƂ̈ʒu擾
	for(pos=0;pos<3;pos++){
		if (hist->SwayGrassRec[pos].MonsNo == 0){
			return pos;
		}
	}

	//LO܂ĂƂ̈ʒu擾
	ISMIN(rc,hist->SwayGrassRec[0].Chain,hist->SwayGrassRec[1].Chain);
	if (rc){
		pos = 0;
	}else{
		pos = 1;
	}
	ISMIN(rc,hist->SwayGrassRec[pos].Chain,hist->SwayGrassRec[2].Chain);
	if (!rc){
		pos = 2;
	}

	return pos;
}

//-----------------------------------------------------------------------------
/**
 * @brief	AtǑ
 *
 * @param	inRound			O
 * @param	inBattleResult	퓬 FIGHT_WIN	FIGHT_POKE_GET
 * 
 * @retval	BOOL		AtO	TURE:A	FALSE:AȂ	
 *
 */
//-----------------------------------------------------------------------------
static BOOL GetChainFlg(const u8 inRound, const int inBattleResult)
{
	//|PomŌ߂
	u8 *tbl;
	u8 table1[SEARCH_AROUND] = {88,68,48,28};
	u8 table2[SEARCH_AROUND] = {98,78,58,38};
	//OAߊlĐ퓬IŃe[uύX
	if (inBattleResult == FIGHT_WIN){
		tbl = table1;
	}else if(inBattleResult == FIGHT_POKE_GET){
		tbl = table2;
	}
	if(gf_p_rand(100)<tbl[inRound]){			//A
		return TRUE;
	}else{		//AȂ
		return FALSE;
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	hꑐN
 *
 * @param	*fsys		tB[hVXe|C^
 * 
 * @retval	none	
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_Setup(FIELDSYS_WORK * fsys)
{
	int *seq;
	seq = sys_AllocMemoryLo(HEAPID_FIELD,sizeof(int));
	(*seq) = 0;
	//CxgZbg
	FieldEvent_Set(fsys, SwayGrass_SetupEvent, seq);
}

//-----------------------------------------------------------------------------
/**
 * @brief	hꑐZbgCxg
 * 
 * @param	*event		Cxg|C^
 * 
 * @retval	BOOL	TRUE:I	FALSE:p
 *
 */
//-----------------------------------------------------------------------------
BOOL SwayGrass_SetupEvent(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	int *seq = FieldEvent_GetSpecialWork(event);
	
	switch (*seq) {
	case SEQ_SWAY_SEARCH:
		{
			u8 *charge;
			//nai|[Y
			FieldOBJSys_MovePauseAll( fsys->fldobjsys );
			//|PT[`[gp\`FbN([dĂ邩H)
			//Z[uf[^擾
			charge = EncDataSave_GetPokeSearcherCharge(EncDataSave_GetSaveDataPtr(fsys->savedata));
			if ( (*charge)<POKESEARCHER_CHARGE_MAX ){
				EventCall_Script(event, SCRID_POKE_SEARCHER, NULL, NULL);
				*(u16*)(GetEvScriptWorkMemberAdrs(fsys,ID_EVSCR_WK_PARAM0)) = POKESEARCHER_CHARGE_MAX-(*charge);
				(*seq) = SEQ_SWAY_END;
			}else{
				int x,z;
				//|PT[`[[dNA
				(*charge) = 0;
				//@̈ʒu擾
				x = Player_NowGPosXGet(fsys->player);
				z = Player_NowGPosZGet(fsys->player);
				//T[`
				SwayGrass_SearchSwayGrass(fsys, x, z,fsys->SwayGrass);
				if (fsys->SwayGrass->Valid){
					SwayGrass_SetChain(fsys, FIGHT_WIN, fsys->SwayGrass);	//e[u͐퓬ŌŒ
					//AjZbg
					SwayGrass_SetSwayGrassAnime(fsys, fsys->SwayGrass);
					(*seq) = SEQ_SWAY_BGM_START;
				}else{
					(*seq) = SEQ_SWAY_NG;
				}
			}
		}
		break;
	case SEQ_SWAY_BGM_START:
		//ȊJn
		//Snd_FadeOutNextPlayCall( fsys, SEQ_KUSAGASA, BGM_FADE_FIELD_MODE );
		Snd_BgmPlay( SEQ_KUSAGASA );											//06.05.18
		(*seq) = SEQ_SWAY_WAIT;
		break;
	case SEQ_SWAY_WAIT:
		//AjI҂
		if (SwayGrass_CheckSwayGrassAnimeEnd(fsys->SwayGrass)){
			(*seq) = SEQ_SWAY_END;
		}
		break;
	case SEQ_SWAY_END:
		//I
		sys_FreeMemoryEz(seq);
		//OBJ|[YNA
		FieldOBJSys_MovePauseAllClear( fsys->fldobjsys );
		return TRUE;
		break;
		
	case SEQ_SWAY_NG:
		// bZ[W\
		EventCall_Script( event, SCRID_POKE_SEARCHER_NG, NULL, NULL );
		(*seq) = SEQ_SWAY_END;
		break;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	A`FbN
 * 
 * @param	inChain		A
 * 
 * @retval	BOOL	TRUE:A	FALSE:m[}
 *
 */
//-----------------------------------------------------------------------------
#if 0
static BOOL CheckRare(const int inChain)
{
	int prop;
	if (inChain == 0){
		return FALSE;
	}
	
	prop = RARE_POKE_PROP_MAX - (inChain*SUB_PROP);
	if (prop < 0){
		prop = 1;
	}

	if ( gf_rand()%prop == 0 ){
		return TRUE;
	}else{
		return FALSE;
	}
}
#else
static BOOL CheckRare(const int inChain)
{
	int prop;
	if (inChain == 0){
		return FALSE;
	}
	
	prop = RARE_POKE_PROP_MAX - (inChain*SUB_PROP);
	if (prop < RARE_POKE_PROP_MIN){
		prop = RARE_POKE_PROP_MIN;
	}

	if ( gf_p_rand(prop) == 0 ){
		return TRUE;
	}else{
		return FALSE;
	}
}
#endif

//-----------------------------------------------------------------------------
/**
 * @brief	AXVinYǓ|PƃGJEgƂpj
 * 
 * @param	fsys	tB[hVXe|C^
 * 
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_UpDateChain(FIELDSYS_WORK * fsys)
{
	IncChain(&(fsys->SwayGrass->Chain));	//A+1
	//hꑐGJEg`FbNƍXV
	UpdateSwayGrassHist(fsys, fsys->SwayGrass);
}

#if 0
//-----------------------------------------------------------------------------
/**
 * @brief	ʒuXV
 * 
 * @param	fsys	tB[hVXe|C^
 * 
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_ChangeHistRewritePos(FIELDSYS_WORK * fsys)
{
	fsys->SwayGrass->RewritePos = GetSwayGrassMinRecordPos(fsys);
}
#endif

//-----------------------------------------------------------------------------
/**
 * @brief	`F[擾
 * 
 * @param	fsys	tB[hVXe|C^
 * 
 * @retval	int		`F[
 *
 */
//-----------------------------------------------------------------------------
int SwayGrass_GetChain(FIELDSYS_WORK * fsys)
{
	return fsys->SwayGrass->Chain;
}

//==============================================================================
/**
 * |PT[`[`[W<<O|PgɂȂ炵B܂킵B
 *
 * @param	fsys			tB[hVXe|C^
 *
 * @return	none
 */
//==============================================================================
void SwayGrass_ChargePokeSearcher(FIELDSYS_WORK *fsys)
{
	u8 *charge;
	//|PT[`[Ă邩`FbN
	if( MyItem_CheckItem( SaveData_GetMyItem(fsys->savedata),
							ITEM_POKETORE,1,HEAPID_FIELD) == TRUE ){
		//Z[uf[^擾
		charge = EncDataSave_GetPokeSearcherCharge(EncDataSave_GetSaveDataPtr(fsys->savedata));
		if ( (*charge)<POKESEARCHER_CHARGE_MAX ){
			(*charge)++;
		}
	}
}

//==============================================================================
/**
 * ẢZ
 *
 * @param	outChain		Aւ̃|C^
 *
 * @return	none
 */
//==============================================================================
static void IncChain(int *outChain)
{
	(*outChain)++;
	if ( (*outChain) > SWAY_GRASS_CHAIN_MAX ){
		(*outChain) = SWAY_GRASS_CHAIN_MAX;
	}
}

#ifdef PM_DEBUG
//-----------------------------------------------------------------------------
/**
 * @brief	`F[ύX
 * 
 * @param	fsys	tB[hVXe|C^
 * @param	n		
 *
 * @retval	none
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_DebugIncChain(FIELDSYS_WORK * fsys, int n)
{
	if (fsys->SwayGrass->Chain + n > SWAY_GRASS_CHAIN_MAX){
		fsys->SwayGrass->Chain = SWAY_GRASS_CHAIN_MAX;
	}else{
		fsys->SwayGrass->Chain += n;
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	`F[Zbg
 * 
 * @param	fsys	tB[hVXe|C^
 * @param	n		
 *
 * @retval	none
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_DebugSetChain(FIELDSYS_WORK * fsys, int n)
{
	if (n > SWAY_GRASS_CHAIN_MAX){
		fsys->SwayGrass->Chain = SWAY_GRASS_CHAIN_MAX;
	}else{
		fsys->SwayGrass->Chain = n;
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	擾
 * 
 * @param	fsys	tB[hVXe|C^
 * @param	inIdx	\̃CfbNX	0`3
 *
 * @retval	none
 *
 */
//-----------------------------------------------------------------------------
void SwayGrass_GetGrassInfo(FIELDSYS_WORK * fsys, const u8 inIdx,
							int *outX, int *outZ, u8 *outTbl,
							BOOL *outValid, BOOL *outChainFlg, BOOL *outRare)
{
	SWAY_GRASS_INFO *info;
	GF_ASSERT(inIdx<SEARCH_AROUND);

	info = &fsys->SwayGrass->GrassInfo[inIdx];

	(*outX) = info->GridX;
	(*outZ) = info->GridZ;
	(*outTbl) = info->EncTblCode;
	(*outValid) = info->SwayGrassFlg;
	(*outChainFlg) = info->ChainFlg;
	(*outRare) = info->IsRare;


}

#endif
