//============================================================================================
/**
 * @file	sysflag.c
 * @bfief	vOAXNvgANZXVXetO
 * @author	Satoshi Nohara
 * @date	06.03.12
 */
//============================================================================================
#include "common.h"
#include "system/pm_rtc.h"			//GF_RTC_IsNightTime
#include "system/snd_tool.h"
#include "fieldsys.h"
#include "script.h"
#include "field/evwkdef.h"
#include "sysflag.h"
#include "contest/contest_def.h"
#include "mapdefine.h"				//ZONE_ID_C01


//============================================================================================
//
//	vg^Cv錾
//
//============================================================================================
static void SysFlag_Set( EVENTWORK* ev, u16 flag );
static void SysFlag_Reset( EVENTWORK* ev, u16 flag );
static BOOL SysFlag_Check( EVENTWORK* ev, u16 flag );
static BOOL SysFlag_Common( EVENTWORK* ev, SYSFLAG_MODE mode, u32 flag_id);


//============================================================================================
//
//	֐
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * VXetOZbg
 *
 * @param	ev			EVENTWORK̃|C^
 * @param	flag		tOio[
 *
 * @retval	none
 *
 * VXetÓAXNvg̃Z[utOgpĂ
 */
//--------------------------------------------------------------------------------------------
static void SysFlag_Set( EVENTWORK* ev, u16 flag )
{
	EventWork_SetEventFlag( ev, flag );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * VXetOZbg
 *
 * @param	ev			EVENTWORK̃|C^
 * @param	flag		tOio[
 *
 * @retval	none
 *
 * VXetÓAXNvg̃Z[utOgpĂ
 */
//--------------------------------------------------------------------------------------------
static void SysFlag_Reset( EVENTWORK* ev, u16 flag )
{
	EventWork_ResetEventFlag( ev, flag );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * VXetO`FbN
 *
 * @param	ev			EVENTWORK̃|C^
 * @param	flag		tOio[
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 *
 * VXetÓAXNvg̃Z[utOgpĂ
 */
//--------------------------------------------------------------------------------------------
static BOOL SysFlag_Check( EVENTWORK* ev, u16 flag )
{
	return EventWork_CheckEventFlag( ev, flag );
}

//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
static BOOL SysFlag_Common( EVENTWORK* ev, SYSFLAG_MODE mode, u32 flag_id)
{
	switch (mode) {
	case SYSFLAG_MODE_SET:
		SysFlag_Set( ev, flag_id);
		break;
	case SYSFLAG_MODE_RESET:
		SysFlag_Reset( ev, flag_id);
		break;
	case SYSFLAG_MODE_CHECK:
		return SysFlag_Check( ev, flag_id);
	default:
		GF_ASSERT_MSG(0, "FLAG %d, NOT DEFINED MODE %d\n", flag_id, mode);
	}
	return FALSE;
}

//============================================================================================
//
//	obO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * obOtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_BagSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_BAG_GET );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * obOtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_BagCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_BAG_GET );
}

//============================================================================================
//
//	JiM̃MKcCxg֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * JiM̃MKcCxgtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_T05GingaEventSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_T05_GINGA_EVENT );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * JiM̃MKcCxgtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_T05GingaEventCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_T05_GINGA_EVENT );
}

//============================================================================================
//
//	Q[NA֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * Q[NAtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_GameClearSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_GAME_CLEAR );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * Q[NAtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_GameClearCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_GAME_CLEAR );
}


//============================================================================================
//
//	AtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * AtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_PairSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_PAIR );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * AtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_PairReset( EVENTWORK* ev )
{
	SysFlag_Reset( ev, SYS_FLAG_PAIR );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * AtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_PairCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_PAIR );
}


//============================================================================================
//
//	tO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_OneStepSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_ONE_STEP );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_OneStepReset( EVENTWORK* ev )
{
	SysFlag_Reset( ev, SYS_FLAG_ONE_STEP );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * tÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_OneStepCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_ONE_STEP );
}


//============================================================================================
//
//	ogT[`[̃obe[gpĂ邩tO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ogT[`[̃obe[gpĂ邩tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_BtlSearcherUseSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_BTL_SEARCHER_USE );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * ogT[`[̃obe[gpĂ邩tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_BtlSearcherUseReset( EVENTWORK* ev )
{
	SysFlag_Reset( ev, SYS_FLAG_BTL_SEARCHER_USE );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * ogT[`[̃obe[gpĂ邩tÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_BtlSearcherUseCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_BTL_SEARCHER_USE );
}



//============================================================================================
//
//	ntO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * nFtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_UgArriveSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_UG_ARRIVE );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * nFtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_UgArriveReset( EVENTWORK* ev )
{
	SysFlag_Reset( ev, SYS_FLAG_UG_ARRIVE );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * nFtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_UgArriveCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_UG_ARRIVE );
}

//--------------------------------------------------------------------------------------------
/**
 * nF΃tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_UgDigSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_UG_DIG );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * nF΃tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_UgDigReset( EVENTWORK* ev )
{
	SysFlag_Reset( ev, SYS_FLAG_UG_DIG );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * nF΃tÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_UgDigCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_UG_DIG );
}

//--------------------------------------------------------------------------------------------
/**
 * nFʃtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_UgTamaSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_UG_TAMA );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * nFʃtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_UgTamaReset( EVENTWORK* ev )
{
	SysFlag_Reset( ev, SYS_FLAG_UG_TAMA );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * nFʃtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_UgTamaCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_UG_TAMA );
}

//--------------------------------------------------------------------------------------------
/**
 * nFntÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_UgBaseSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_UG_BASE );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * nFntÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_UgBaseReset( EVENTWORK* ev )
{
	SysFlag_Reset( ev, SYS_FLAG_UG_BASE );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * nFntÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_UgBaseCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_UG_BASE );
}

//--------------------------------------------------------------------------------------------
/**
 * nF͗lւtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_UgGoodsSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_UG_GOODS );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * nF͗lւtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_UgGoodsReset( EVENTWORK* ev )
{
	SysFlag_Reset( ev, SYS_FLAG_UG_GOODS );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * nF͗lւtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_UgGoodsCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_UG_GOODS );
}

//--------------------------------------------------------------------------------------------
/**
 * nFtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_UgHataSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_UG_HATA );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * nFtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_UgHataReset( EVENTWORK* ev )
{
	SysFlag_Reset( ev, SYS_FLAG_UG_HATA );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * nFtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_UgHataCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_UG_HATA );
}


//============================================================================================
//
//	ReXg }X^[NNAtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ReXg }X^[NNA tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 * @param	type	ReXg^Cv
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_ConMasterSet( EVENTWORK* ev, int type )
{
	switch( type ){

	///ReXg^CvFiD悳
	case  CONTYPE_STYLE:
		SysFlag_Set( ev, SYS_FLAG_CON_STYLE_MASTER );
		break;

	///ReXg^CvF
	case CONTYPE_BEAUTIFUL:
		SysFlag_Set( ev, SYS_FLAG_CON_BEAUTIFUL_MASTER );
		break;

	///ReXg^CvF
	case CONTYPE_CUTE:
		SysFlag_Set( ev, SYS_FLAG_CON_CUTE_MASTER );
		break;

	///ReXg^CvF
	case CONTYPE_CLEVER:
		SysFlag_Set( ev, SYS_FLAG_CON_CLEVER_MASTER );
		break;

	///ReXg^CvF痂
	case CONTYPE_STRONG:
		SysFlag_Set( ev, SYS_FLAG_CON_STRONG_MASTER );
		break;
	};

	return;
}

//--------------------------------------------------------------------------------------------
/**
 * ReXg }X^[NNA tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 * @param	type	ReXg^Cv
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_ConMasterReset( EVENTWORK* ev, int type )
{
	switch( type ){

	///ReXg^CvFiD悳
	case  CONTYPE_STYLE:
		SysFlag_Reset( ev, SYS_FLAG_CON_STYLE_MASTER );
		break;

	///ReXg^CvF
	case CONTYPE_BEAUTIFUL:
		SysFlag_Reset( ev, SYS_FLAG_CON_BEAUTIFUL_MASTER );
		break;

	///ReXg^CvF
	case CONTYPE_CUTE:
		SysFlag_Reset( ev, SYS_FLAG_CON_CUTE_MASTER );
		break;

	///ReXg^CvF
	case CONTYPE_CLEVER:
		SysFlag_Reset( ev, SYS_FLAG_CON_CLEVER_MASTER );
		break;

	///ReXg^CvF痂
	case CONTYPE_STRONG:
		SysFlag_Reset( ev, SYS_FLAG_CON_STRONG_MASTER );
		break;
	};

	return;
}

//--------------------------------------------------------------------------------------------
/**
 * ReXg }X^[NNA tÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 * @param	type	ReXg^Cv
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_ConMasterCheck( EVENTWORK* ev, int type )
{
	int ret;

	switch( type ){

	///ReXg^CvFiD悳
	case  CONTYPE_STYLE:
		ret = SysFlag_Check( ev, SYS_FLAG_CON_STYLE_MASTER );
		break;

	///ReXg^CvF
	case CONTYPE_BEAUTIFUL:
		ret = SysFlag_Check( ev, SYS_FLAG_CON_BEAUTIFUL_MASTER );
		break;

	///ReXg^CvF
	case CONTYPE_CUTE:
		ret = SysFlag_Check( ev, SYS_FLAG_CON_CUTE_MASTER );
		break;

	///ReXg^CvF
	case CONTYPE_CLEVER:
		ret = SysFlag_Check( ev, SYS_FLAG_CON_CLEVER_MASTER );
		break;

	///ReXg^CvF痂
	case CONTYPE_STRONG:
		ret = SysFlag_Check( ev, SYS_FLAG_CON_STRONG_MASTER );
		break;
	};

	return ret;
}


//============================================================================================
//
//	ogT[`[FtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ogT[`[ tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 * @param	lv		x
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_BsLvSet( EVENTWORK* ev, int lv )
{
	switch( lv ){

	case  1:
		SysFlag_Set( ev, SYS_FLAG_BS_LV1 );
		break;

	case 2:
		SysFlag_Set( ev, SYS_FLAG_BS_LV2 );
		break;

	case 3:
		SysFlag_Set( ev, SYS_FLAG_BS_LV3 );
		break;

	case 4:
		SysFlag_Set( ev, SYS_FLAG_BS_LV4 );
		break;

	case 5:
		SysFlag_Set( ev, SYS_FLAG_BS_LV5 );
		break;
	};

	return;
}

//--------------------------------------------------------------------------------------------
/**
 * ogT[`[ tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 * @param	lv		x
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_BsLvReset( EVENTWORK* ev, int lv )
{
	switch( lv ){

	case  1:
		SysFlag_Reset( ev, SYS_FLAG_BS_LV1 );
		break;

	case 2:
		SysFlag_Reset( ev, SYS_FLAG_BS_LV2 );
		break;

	case 3:
		SysFlag_Reset( ev, SYS_FLAG_BS_LV3 );
		break;

	case 4:
		SysFlag_Reset( ev, SYS_FLAG_BS_LV4 );
		break;

	case 5:
		SysFlag_Reset( ev, SYS_FLAG_BS_LV5 );
		break;
	};

	return;
}

//--------------------------------------------------------------------------------------------
/**
 * ogT[`[ tÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 * @param	lv		x
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_BsLvCheck( EVENTWORK* ev, int lv )
{
	int ret = FALSE;

	switch( lv ){

	case  1:
		ret = SysFlag_Check( ev, SYS_FLAG_BS_LV1 );
		break;

	case 2:
		ret = SysFlag_Check( ev, SYS_FLAG_BS_LV2 );
		break;

	case 3:
		ret = SysFlag_Check( ev, SYS_FLAG_BS_LV3 );
		break;

	case 4:
		ret = SysFlag_Check( ev, SYS_FLAG_BS_LV4 );
		break;

	case 5:
		ret = SysFlag_Check( ev, SYS_FLAG_BS_LV5 );
		break;
	};

	return ret;
}


//============================================================================================
//
//	CxgBGM؂ւFtO֘A
//
//	tOƂ͈ӖႤ̂ł̃\[Xɓ͔̂BBB
//
//	tO`͂̃\[XŎQƂA
//	case͂QӏɏȂA
//	w肪A
//
//	e[uāA][AtOABGMABGM邢B
//	e[uuꏊ́AɂȂH(tO͂̃\[XŎQƂ̂)
//	BBBƂ肠ۗB
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * CxgBGM؂ւ tÕ`FbNāA؂ւBGMio[擾
 *
 * @param	ev		EVENTWORK̃|C^
 * @param	zone_id ][ID
 *
 * @retval	"0		= tOItȂ̂ŉȂ"
 * @retval	"0ȊO	= ύXBGMio["
 */
//--------------------------------------------------------------------------------------------
u16 SysFlag_EventBgmGet( EVENTWORK* ev, int zone_id )
{
	u16 bgm = 0;

	switch( zone_id ){

	//bV
	case  ZONE_ID_D28R0101:
		if( SysFlag_Check(ev,SYS_FLAG_BGM_D28) == 1 ){
			bgm = SEQ_D_LAKE;
		}
		break;

	case  ZONE_ID_D28R0103:
		if( SysFlag_Check(ev,SYS_FLAG_BGM_D28) == 1 ){
			bgm = SEQ_D_RYAYHY;
		}
		break;

	//d27
	case  ZONE_ID_D27R0102:
		if( SysFlag_Check(ev,SYS_FLAG_BGM_D27) == 1 ){
			bgm = SEQ_D_LAKE;
		}
		break;

	//d29
	case  ZONE_ID_D29R0102:
		if( SysFlag_Check(ev,SYS_FLAG_BGM_D29) == 1 ){
			bgm = SEQ_D_LAKE;
		}
		break;

	//d10r0101
	case  ZONE_ID_D10R0101:
		if( SysFlag_Check(ev,SYS_FLAG_BGM_D10) == 1 ){
			bgm = SEQ_D_SAFARI;
		}
		break;

	//t02
	case  ZONE_ID_T02R0101:
		if( SysFlag_Check(ev,SYS_FLAG_BGM_T02) == 1 ){
			bgm = SEQ_OPENING2;
		}
		break;
#if 0
	//c02
	case  ZONE_ID_C02R0101:
	case  ZONE_ID_C02R0102:
	case  ZONE_ID_C02R0103:
		if( SysFlag_Check(ev,SYS_FLAG_BGM_C02) == 1 ){
			bgm = SEQ_THE_EVENT01;
		}
		break;
#endif

	//MKcAWg
	//MKc
	case  ZONE_ID_D26R0101:
	case  ZONE_ID_D26R0102:
	case  ZONE_ID_D26R0103:
	case  ZONE_ID_D26R0104:
	case  ZONE_ID_D26R0105:
	case  ZONE_ID_D26R0106:
	case  ZONE_ID_D26R0107:
	case  ZONE_ID_D26R0108:

		//MKc󂵂Ă
		if( SysFlag_Check(ev,SYS_FLAG_BGM_GINGA) == 1 ){

			if( GF_RTC_IsNightTime() == FALSE ){			//FALSE=ATRUE=
				bgm = SEQ_CITY07_D;
			}else{
				bgm = SEQ_CITY07_N;
			}
			break;	//KvI
		}

		//MKcAWgN}bv̎
		if( zone_id == ZONE_ID_D26R0101 ){
			if( SysFlag_Check(ev,SYS_FLAG_BGM_D26) == 1 ){
				bgm = SEQ_D_AGITO;
			}
		}
		break;

	//MKcx
	case  ZONE_ID_C04R0201:
	case  ZONE_ID_C04R0202:
	case  ZONE_ID_C04R0203:
	case  ZONE_ID_C04R0204:
		if( SysFlag_Check(ev,SYS_FLAG_BGM_C04) == 1 ){
			if( GF_RTC_IsNightTime() == FALSE ){			//FALSE=ATRUE=
				bgm = SEQ_CITY04_D;
			}else{
				bgm = SEQ_CITY04_N;
			}
		}
		break;

	//d
	case  ZONE_ID_D02R0101:
		if( SysFlag_Check(ev,SYS_FLAG_BGM_D02) == 1 ){
			if( GF_RTC_IsNightTime() == FALSE ){			//FALSE=ATRUE=
				bgm = SEQ_ROAD_C_D;
			}else{
				bgm = SEQ_ROAD_C_N;
			}
		}
		break;

	//\mỈԔ
	case  ZONE_ID_D13R0101:
		if( SysFlag_Check(ev,SYS_FLAG_BGM_D13) == 1 ){
			if( GF_RTC_IsNightTime() == FALSE ){			//FALSE=ATRUE=
				bgm = SEQ_TOWN03_D;
			}else{
				bgm = SEQ_TOWN03_N;
			}
		}
		break;

	//R224zzCxg
	case  ZONE_ID_R224:
		if( SysFlag_Check(ev,SYS_FLAG_BGM_R224) == 1 ){
			if( GF_RTC_IsNightTime() == FALSE ){			//FALSE=ATRUE=
				bgm = SEQ_TOWN03_D;
			}else{
				bgm = SEQ_TOWN03_N;
			}
		}
		break;

	//`sI̕
	case  ZONE_ID_C10R0111:
		if( SysFlag_Check(ev,SYS_FLAG_BGM_C10) == 1 ){
			bgm = SEQ_SILENCE_FIELD;
		}
		break;

	};


	return bgm;
}


//============================================================================================
//
//	ʐMJE^[ʉ߃tO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ʐMJE^[ʉ߃tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_CommCounterSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_COMM_COUNTER );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * ʐMJE^[ʉ߃tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_CommCounterReset( EVENTWORK* ev )
{
	SysFlag_Reset( ev, SYS_FLAG_COMM_COUNTER );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * ʐMJE^[ʉ߃tÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_CommCounterCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_COMM_COUNTER );
}

//============================================================================================
//
//	|PXe[^XFReXgZtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * |PXe[^XFReXgZtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_PSTContestSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_PST );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * |PXe[^XFReXgZtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_PSTContestReset( EVENTWORK* ev )
{
	SysFlag_Reset( ev, SYS_FLAG_PST );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * |PXe[^XFReXgZtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_PSTContestCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_PST );
}


//============================================================================================
//
//	nCxgtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * nCxgtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_UgFirstSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_UG_FIRST );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * nCxgtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_UgFirstReset( EVENTWORK* ev )
{
	SysFlag_Reset( ev, SYS_FLAG_UG_FIRST );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * nCxgtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_UgFirstCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_UG_FIRST );
}


//============================================================================================
//
//	GTCI[vtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * GTCI[vtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_GTCOpenSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_GTC_OPEN );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * GTCI[vtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_GTCOpenReset( EVENTWORK* ev )
{
	SysFlag_Reset( ev, SYS_FLAG_GTC_OPEN );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * GTCI[vtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_GTCOpenCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_GTC_OPEN );
}


//============================================================================================
//
//	og^[I[vtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * og^[I[vtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_BTowerOpenSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_BTOWER_OPEN );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * og^[I[vtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_BTowerOpenReset( EVENTWORK* ev )
{
	SysFlag_Reset( ev, SYS_FLAG_BTOWER_OPEN );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * og^[I[vtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_BTowerOpenCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_BTOWER_OPEN );
}


//============================================================================================
//
//	DgtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * DgtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_ShipSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_SHIP );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * DgtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_ShipReset( EVENTWORK* ev )
{
	SysFlag_Reset( ev, SYS_FLAG_SHIP );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * DgtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_ShipCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_SHIP );
}


//============================================================================================
//
//	CACnC~otO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * CACnC~otÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_ReiAiHaiSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_REIAIHAI );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * CACnC~otÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_ReiAiHaiReset( EVENTWORK* ev )
{
	SysFlag_Reset( ev, SYS_FLAG_REIAIHAI );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * CACnC~otÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_ReiAiHaiCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_REIAIHAI );
}


//============================================================================================
//
//	~YLtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ~YLtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_MizukiSet( EVENTWORK* ev )
{
	SysFlag_Set( ev, SYS_FLAG_MIZUKI );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * ~YLtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_MizukiReset( EVENTWORK* ev )
{
	SysFlag_Reset( ev, SYS_FLAG_MIZUKI );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * ~YLtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_MizukiCheck( EVENTWORK* ev )
{
	return SysFlag_Check( ev, SYS_FLAG_MIZUKI );
}


//============================================================================================
//
//	|Pb`}~֘A
//
//============================================================================================
//--------------------------------------------------------------------------------------------
///	VXetOZbgF|Pb`}~
//--------------------------------------------------------------------------------------------
void SysFlag_PoketchHookSet(EVENTWORK * ev)
{
	SysFlag_Set(ev, SYS_FLAG_POKETCH_HOOK);
}
//--------------------------------------------------------------------------------------------
///	VXetOZbgF|Pb`}~
//--------------------------------------------------------------------------------------------
void SysFlag_PoketchHookReset(EVENTWORK * ev)
{
	SysFlag_Reset(ev, SYS_FLAG_POKETCH_HOOK);
}
//--------------------------------------------------------------------------------------------
///	VXetO擾F|Pb`}~
//--------------------------------------------------------------------------------------------
BOOL SysFlag_PoketchHookCheck(EVENTWORK * ev)
{
	return SysFlag_Check(ev, SYS_FLAG_POKETCH_HOOK);
}

//============================================================================================
//		Tt@[h֘A
//============================================================================================
//--------------------------------------------------------------------------------------------
/**
 * @brief	Tt@[htÕZbg
 * @param	ev		EVENTWORK̃|C^
 */
//--------------------------------------------------------------------------------------------
void SysFlag_SafariSet(EVENTWORK * ev)
{
	SysFlag_Set(ev, SYS_FLAG_SAFARI_MODE);
}
//--------------------------------------------------------------------------------------------
/**
 * @brief	Tt@[htÕZbg
 * @param	ev		EVENTWORK̃|C^
 */
//--------------------------------------------------------------------------------------------
void SysFlag_SafariReset(EVENTWORK * ev)
{
	SysFlag_Reset(ev, SYS_FLAG_SAFARI_MODE);
}
//--------------------------------------------------------------------------------------------
/**
 * @brief	Tt@[htÕZbg
 * @param	ev		EVENTWORK̃|C^
 * @return	BOOL	tO̒l
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_SafariCheck(EVENTWORK * ev)
{
	return SysFlag_Check(ev, SYS_FLAG_SAFARI_MODE);
}

//============================================================================================
//		|Pp[N[h֘A
//============================================================================================
//--------------------------------------------------------------------------------------------
/**
 * @brief	|Pp[N[htÕZbg
 * @param	ev		EVENTWORK̃|C^
 */
//--------------------------------------------------------------------------------------------
void SysFlag_PokeParkSet(EVENTWORK * ev)
{
	SysFlag_Set(ev, SYS_FLAG_POKEPARK_MODE);
}
//--------------------------------------------------------------------------------------------
/**
 * @brief	|Pp[N[htÕZbg
 * @param	ev		EVENTWORK̃|C^
 */
//--------------------------------------------------------------------------------------------
void SysFlag_PokeParkReset(EVENTWORK * ev)
{
	SysFlag_Reset(ev, SYS_FLAG_POKEPARK_MODE);
}
//--------------------------------------------------------------------------------------------
/**
 * @brief	|Pp[N[htÕZbg
 * @param	ev		EVENTWORK̃|C^
 * @return	BOOL	tO̒l
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_PokeParkCheck(EVENTWORK * ev)
{
	return SysFlag_Check(ev, SYS_FLAG_POKEPARK_MODE);
}

//============================================================================================
//
//		TCNO[h֘A
//
//============================================================================================
//--------------------------------------------------------------------------------------------
/**
 * @brief	TCNO[h[htÕZbg
 * @param	ev		EVENTWORK̃|C^
 * @return	BOOL	tO̒l
 */
//--------------------------------------------------------------------------------------------
void SysFlag_CyclingRoadSet(EVENTWORK * ev)
{
	SysFlag_Set(ev, SYS_FLAG_CYCLINGROAD);
}
//--------------------------------------------------------------------------------------------
/**
 * @brief	TCNO[h[htÕZbg
 * @param	ev		EVENTWORK̃|C^
 * @return	BOOL	tO̒l
 */
//--------------------------------------------------------------------------------------------
void SysFlag_CyclingRoadReset(EVENTWORK * ev)
{
	SysFlag_Reset(ev, SYS_FLAG_CYCLINGROAD);
}
//--------------------------------------------------------------------------------------------
/**
 * @brief	TCNO[h[htÕ`FbN
 * @param	ev		EVENTWORK̃|C^
 * @return	BOOL	tO̒l
 */
//--------------------------------------------------------------------------------------------
BOOL SysFlag_CyclingRoadCheck(EVENTWORK * ev)
{
	return SysFlag_Check(ev, SYS_FLAG_CYCLINGROAD);
}

//============================================================================================
//
//	Ђł킴֘A
//
//============================================================================================
//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
BOOL SysFlag_Kairiki( EVENTWORK* ev, SYSFLAG_MODE mode)
{
	return SysFlag_Common( ev, mode, SYS_FLAG_KAIRIKI );
}

//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
void SysFlag_FlashSet(EVENTWORK* ev)
{
	SysFlag_Set(ev, SYS_FLAG_FLASH);
}
//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
void SysFlag_FlashReset(EVENTWORK* ev)
{
	SysFlag_Reset(ev, SYS_FLAG_FLASH);
}
//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
BOOL SysFlag_FlashCheck(EVENTWORK* ev)
{
	return SysFlag_Check(ev, SYS_FLAG_FLASH);
}

//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
void SysFlag_KiribaraiSet(EVENTWORK* ev)
{
	SysFlag_Set(ev, SYS_FLAG_KIRIBARAI);
}
//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
void SysFlag_KiribaraiReset(EVENTWORK* ev)
{
	SysFlag_Reset(ev, SYS_FLAG_KIRIBARAI);
}
//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
BOOL SysFlag_KiribaraiCheck(EVENTWORK* ev)
{
	return SysFlag_Check(ev, SYS_FLAG_KIRIBARAI);
}

//============================================================================================
//		`m[g֘A
//============================================================================================
//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
BOOL SysFlag_FNote( EVENTWORK* ev, SYSFLAG_MODE mode )
{
	return SysFlag_Common( ev, mode, SYS_FLAG_FNOTE_GET );
}

//============================================================================================
//
//		tO֘A
//
//============================================================================================
//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
BOOL SysFlag_Arrive( EVENTWORK* ev, SYSFLAG_MODE mode, u32 arrive_id )
{
	GF_ASSERT( arrive_id < FLAG_ARRIVE_MAX );
	return SysFlag_Common( ev, mode, SYS_FLAG_ARRIVE_START + arrive_id );
}

//============================================================================================
//
//		Cxg֘A
//
//============================================================================================
//--------------------------------------------------------------------------------------------
/**
 * WiFiɌq
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
void SysFlag_WifiUseSet( EVENTWORK* ev )
{
	SysFlag_Set(ev, SYS_FLAG_WIFI_USE);
}

//============================================================================================
//
//		fobO@\֘A
//
//============================================================================================
#ifdef PM_DEBUG

//VXetOnQbg
u32 DNumInput_SysFlagGet(SAVEDATA* sv,u32 param)
{
	EVENTWORK* ev = SaveData_GetEventWork(sv);
	return SysFlag_Check( ev,param);
}
//VXetOnZbg
void DNumInput_SysFlagSet(SAVEDATA* sv,u32 param,u32 value)
{
	EVENTWORK* ev = SaveData_GetEventWork(sv);
	if(value){
		SysFlag_Set(ev,param);
	}else{
		SysFlag_Reset(ev,param);
	}
}

#endif	//PM_DEBUG

