//============================================================================================
/**
 * @file	sysflag.c
 * @bfief	vOAXNvgANZXVXetO
 * @author	Satoshi Nohara
 * @date	05.11.01
 */
//============================================================================================
#ifndef	__SYSFLAG_H__
#define	__SYSFLAG_H__


#include "field/eventflag.h"


//============================================================================================
//	tO`
//
//	SysFlag_...Set
//	SysFlag_...Check
//	֐AANZX悤ɂ
//
//============================================================================================
#include "sysflag_def.h"


//--------------------------------------------------------------------------------------------
//	tOp[h`
//--------------------------------------------------------------------------------------------
typedef enum {
	SYSFLAG_MODE_RESET = 0,	///<tOFZbg
	SYSFLAG_MODE_SET,		///<tOFZbg
	SYSFLAG_MODE_CHECK,		///<tOF擾
}SYSFLAG_MODE;


//============================================================================================
//
//	obO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * obOtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_BagSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * obOtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_BagCheck( EVENTWORK* ev );


//============================================================================================
//
//	JiM̃MKcCxg֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * JiM̃MKcCxgtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_T05GingaEventSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * JiM̃MKcCxgtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_T05GingaEventCheck( EVENTWORK* ev );


//============================================================================================
//
//	Q[NA֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * Q[NAtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_GameClearSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * Q[NAtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_GameClearCheck( EVENTWORK* ev );


//============================================================================================
//
//	nCxgtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * nCxgtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_UgFirstSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nCxgtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_UgFirstReset( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nCxgtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_UgFirstCheck( EVENTWORK* ev );


//============================================================================================
//
//	AtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * AtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_PairSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * AtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_PairReset( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * AtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_PairCheck( EVENTWORK* ev );


//============================================================================================
//
//	tO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_OneStepSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_OneStepReset( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * tÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_OneStepCheck( EVENTWORK* ev );


//============================================================================================
//
//	ReXg }X^[NNAtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ReXg }X^[NNA tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 * @param	type	ReXg^Cv
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_ConMasterSet( EVENTWORK* ev, int type );

//--------------------------------------------------------------------------------------------
/**
 * ReXg }X^[NNA tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 * @param	type	ReXg^Cv
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_ConMasterReset( EVENTWORK* ev, int type );

//--------------------------------------------------------------------------------------------
/**
 * ReXg }X^[NNA tÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 * @param	type	ReXg^Cv
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_ConMasterCheck( EVENTWORK* ev, int type );


//============================================================================================
//
//	ogT[`[FtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ogT[`[ tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 * @param	lv		x
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_BsLvSet( EVENTWORK* ev, int lv );

//--------------------------------------------------------------------------------------------
/**
 * ogT[`[ tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 * @param	lv		x
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_BsLvReset( EVENTWORK* ev, int lv );

//--------------------------------------------------------------------------------------------
/**
 * ogT[`[ tÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 * @param	lv		x
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_BsLvCheck( EVENTWORK* ev, int lv );

//--------------------------------------------------------------------------------------------
/**
 * CxgBGM؂ւ tÕ`FbNāA؂ւBGMio[擾
 *
 * @param	ev		EVENTWORK̃|C^
 * @param	zone_id ][ID
 *
 * @retval	"0		= tOItȂ̂ŉȂ"
 * @retval	"0ȊO	= ύXBGMio["
 */
//--------------------------------------------------------------------------------------------
extern u16 SysFlag_EventBgmGet( EVENTWORK* ev, int zone_id );


//============================================================================================
//
//	ʐMJE^[ʉ߃tO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ʐMJE^[ʉ߃tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_CommCounterSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * ʐMJE^[ʉ߃tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_CommCounterReset( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * ʐMJE^[ʉ߃tÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_CommCounterCheck( EVENTWORK* ev );


//============================================================================================
//
//	|PXe[^XFReXgZtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * |PXe[^XFReXgZtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_PSTContestSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * |PXe[^XFReXgZtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_PSTContestReset( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * |PXe[^XFReXgZtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_PSTContestCheck( EVENTWORK* ev );


//============================================================================================
//
//	GTCI[vtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * GTCI[vtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_GTCOpenSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * GTCI[vtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_GTCOpenReset( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * GTCI[vtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_GTCOpenCheck( EVENTWORK* ev );

//============================================================================================
//
//	og^[I[vtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * og^[I[vtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_BTowerOpenSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * og^[I[vtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_BTowerOpenReset( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * og^[I[vtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_BTowerOpenCheck( EVENTWORK* ev );

//============================================================================================
//
//	DgtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * DgtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_ShipSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * DgtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_ShipReset( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * DgtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_ShipCheck( EVENTWORK* ev );


//============================================================================================
//
//	CACnC~otO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * CACnC~otÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_ReiAiHaiSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * CACnC~otÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_ReiAiHaiReset( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * CACnC~otÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_ReiAiHaiCheck( EVENTWORK* ev );


//============================================================================================
//
//	~YLtO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ~YLtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_MizukiSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * ~YLtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_MizukiReset( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * ~YLtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_MizukiCheck( EVENTWORK* ev );


//============================================================================================
//		|Pb`tbN֘A
//============================================================================================
extern void SysFlag_PoketchHookSet(EVENTWORK * ev);
extern void SysFlag_PoketchHookReset(EVENTWORK * ev);
extern BOOL SysFlag_PoketchHookCheck(EVENTWORK * ev);

//============================================================================================
//		Tt@[h֘A
//============================================================================================
extern void SysFlag_SafariSet(EVENTWORK * ev);
extern void SysFlag_SafariReset(EVENTWORK * ev);
extern BOOL SysFlag_SafariCheck(EVENTWORK * ev);

//============================================================================================
//		|Pp[N[h֘A
//============================================================================================
extern void SysFlag_PokeParkSet(EVENTWORK * ev);
extern void SysFlag_PokeParkReset(EVENTWORK * ev);
extern BOOL SysFlag_PokeParkCheck(EVENTWORK * ev);

//============================================================================================
//		TCNO[h[h֘A
//============================================================================================
extern void SysFlag_CyclingRoadSet(EVENTWORK * ev);
extern void SysFlag_CyclingRoadReset(EVENTWORK * ev);
extern BOOL SysFlag_CyclingRoadCheck(EVENTWORK * ev);

//============================================================================================
//		Ђł킴֘A
//============================================================================================
//--------------------------------------------------------------------------------------------
//		tbVԃtO
//--------------------------------------------------------------------------------------------
///tbVԃtOZbg
extern void SysFlag_FlashSet(EVENTWORK* ev);
///tbVԃtOZbg
extern void SysFlag_FlashReset(EVENTWORK* ev);
///tbVԃtO`FbN
extern BOOL SysFlag_FlashCheck(EVENTWORK* ev);

//--------------------------------------------------------------------------------------------
//		΂炢ԃtO
//--------------------------------------------------------------------------------------------
///΂炢ԃtOZbg
extern void SysFlag_KiribaraiSet(EVENTWORK* ev);
///΂炢ԃtOZbg
extern void SysFlag_KiribaraiReset(EVENTWORK* ev);
///΂炢ԃtO`FbN
extern BOOL SysFlag_KiribaraiCheck(EVENTWORK* ev);

//--------------------------------------------------------------------------------------------
//		肫tO
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_Kairiki( EVENTWORK* ev, SYSFLAG_MODE mode);

//--------------------------------------------------------------------------------------------
/**
 * @brief	肫tÕZbg
 * @param	ev		EVENTWORK̃|C^
 */
//--------------------------------------------------------------------------------------------
static inline void SysFlag_KairikiSet( EVENTWORK* ev )
{
	SysFlag_Kairiki(ev, SYSFLAG_MODE_SET);
}
//--------------------------------------------------------------------------------------------
/**
 * @brief	肫tÕZbg
 * @param	ev		EVENTWORK̃|C^
 */
//--------------------------------------------------------------------------------------------
static inline void SysFlag_KairikiReset( EVENTWORK* ev )
{
	SysFlag_Kairiki(ev, SYSFLAG_MODE_RESET);
}
//--------------------------------------------------------------------------------------------
/**
 * @brief	肫tÕ`FbN
 * @param	ev		EVENTWORK̃|C^
 * @return	BOOL	ON/OFF
 */
//--------------------------------------------------------------------------------------------
static inline BOOL SysFlag_KairikiCheck( EVENTWORK* ev )
{
	return SysFlag_Kairiki(ev, SYSFLAG_MODE_CHECK);
}

//--------------------------------------------------------------------------------------------
/**
 * ogT[`[̃obe[gpĂ邩tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_BtlSearcherUseSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * ogT[`[̃obe[gpĂ邩tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_BtlSearcherUseReset( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * ogT[`[̃obe[gpĂ邩tÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_BtlSearcherUseCheck( EVENTWORK* ev );


//============================================================================================
//
//	ntO֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * nFtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_UgArriveSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nFtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_UgArriveReset( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nFtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_UgArriveCheck( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nF΃tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_UgDigSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nF΃tÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_UgDigReset( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nF΃tÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_UgDigCheck( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nFʃtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_UgTamaSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nFʃtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_UgTamaReset( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nFʃtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_UgTamaCheck( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nFntÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_UgBaseSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nFntÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_UgBaseReset( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nFntÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_UgBaseCheck( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nF͗lւtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_UgGoodsSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nF͗lւtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_UgGoodsReset( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nF͗lւtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_UgGoodsCheck( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nFtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_UgHataSet( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nFtÕZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_UgHataReset( EVENTWORK* ev );

//--------------------------------------------------------------------------------------------
/**
 * nFtÕ`FbN
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_UgHataCheck( EVENTWORK* ev );

//============================================================================================
//		`m[g֘A
//============================================================================================
//--------------------------------------------------------------------------------------------
//		`m[gtO
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_FNote( EVENTWORK* ev, SYSFLAG_MODE mode);

//--------------------------------------------------------------------------------------------
/**
 * @brief	`m[gtÕZbg
 * @param	ev		EVENTWORK̃|C^
 */
//--------------------------------------------------------------------------------------------
static inline void SysFlag_FNoteSet( EVENTWORK* ev )
{
	SysFlag_FNote(ev, SYSFLAG_MODE_SET);
}
//--------------------------------------------------------------------------------------------
/**
 * @brief	`m[gtÕZbg
 * @param	ev		EVENTWORK̃|C^
 */
//--------------------------------------------------------------------------------------------
static inline void SysFlag_FNoteReset( EVENTWORK* ev )
{
	SysFlag_FNote(ev, SYSFLAG_MODE_RESET);
}
//--------------------------------------------------------------------------------------------
/**
 * @brief	`m[gtÕ`FbN
 * @param	ev		EVENTWORK̃|C^
 * @return	BOOL	ON/OFF
 */
//--------------------------------------------------------------------------------------------
static inline BOOL SysFlag_FNoteCheck( EVENTWORK* ev )
{
	return SysFlag_FNote(ev, SYSFLAG_MODE_CHECK);
}

//============================================================================================
//
//		tO֘A
//
//============================================================================================
//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
extern BOOL SysFlag_Arrive( EVENTWORK * ev, SYSFLAG_MODE mode, u32 arrive_id);

//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
static inline void SysFlag_ArriveSet( EVENTWORK * ev, u32 arrive_id)
{
	SysFlag_Arrive(ev, SYSFLAG_MODE_SET, arrive_id);
}
//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
static inline void SysFlag_ArriveReset( EVENTWORK * ev, u32 arrive_id)
{
	SysFlag_Arrive(ev, SYSFLAG_MODE_RESET, arrive_id);
}
//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
static inline BOOL SysFlag_ArriveGet( EVENTWORK * ev, u32 arrive_id)
{
	return SysFlag_Arrive(ev, SYSFLAG_MODE_CHECK, arrive_id);
}

//============================================================================================
//
//		Cxg֘A
//
//============================================================================================
//--------------------------------------------------------------------------------------------
/**
 * WiFiɌq
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------------------------------------
extern void SysFlag_WifiUseSet( EVENTWORK* ev );

//============================================================================================
//
//		fobO@\֘A
//
//============================================================================================
#ifdef PM_DEBUG
//VXetOnQbg
extern u32 DNumInput_SysFlagGet(SAVEDATA* sv,u32 param);
//VXetOnZbg
extern void DNumInput_SysFlagSet(SAVEDATA* sv,u32 param,u32 value);
#endif	//PM_DEBUG


#endif	//__SYSFLAG_H__


