//============================================================================================
/**
 * @file	syswork.c
 * @bfief	vOAXNvgANZXVXe[N
 * @author	Satoshi Nohara
 * @date	06.03.12
 */
//============================================================================================
#include "common.h"
#include "fieldsys.h"
#include "script.h"
#include "field/evwkdef.h"
#include "syswork.h"
#include "sysflag.h"				//SysFlag_
#include "poketool/monsno.h"		//|Pio[

#include "savedata/randomgroup.h"

//============================================================================================
//
//	vg^Cv錾
//
//============================================================================================
static BOOL SysWork_Set( EVENTWORK* ev, u16 work, u16 no );
static u16 SysWork_Get( EVENTWORK* ev, u16 work );
BOOL SysWork_FirstPokeNoSet( EVENTWORK* ev, u16 no );
u16 SysWork_FirstPokeNoGet( EVENTWORK* ev );
u16 SysWork_RivalPokeNoGet( EVENTWORK* ev );
u16 SysWork_SupportPokeNoGet( EVENTWORK* ev );


//============================================================================================
//
//	֐
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * VXe[NZbg
 *
 * @param	ev			EVENTWORKւ̃|C^
 * @param	work		[Nio[
 * @param	no			Zbgl
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//--------------------------------------------------------------------------------------------
static BOOL SysWork_Set( EVENTWORK* ev, u16 work, u16 no )
{
	u16* p	= EventWork_GetEventWorkAdrs( ev, work );

	if( (work < SVWK_START) || (work > SCWK_START ) ){
		GF_ASSERT( (0) && "sȃ[NIDn܂I" );
		return FALSE;
	}

	if( p == NULL ){
		return FALSE;
	}

	*p = no;
	return TRUE;
}

//--------------------------------------------------------------------------------------------
/**
 * VXe[NQbg
 *
 * @param	ev			EVENTWORK̃|C^
 * @param	work		[Nio[
 *
 * @return	"[N̒l"
 */
//--------------------------------------------------------------------------------------------
static u16 SysWork_Get( EVENTWORK* ev, u16 work )
{
	u16* p	= EventWork_GetEventWorkAdrs( ev, work );

	if( p == NULL ){
		return 0;
	}

	return *p;
}


//============================================================================================
//
//	Ag[i[IDi[[N֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * Ag[i[IDi[[NZbg
 *
 * @param	ev			EVENTWORKւ̃|C^
 * @param	no			g[i[ID
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_PairTrainerIDSet( EVENTWORK* ev, u16 no )
{
	return SysWork_Set( ev, SYS_WORK_PAIR_TRAINER_ID, no );
}

//--------------------------------------------------------------------------------------------
/**
 * Ag[i[IDi[[NQbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"g[i[ID"
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_PairTrainerIDGet( EVENTWORK* ev )
{
	return SysWork_Get( ev, SYS_WORK_PAIR_TRAINER_ID );
}


//============================================================================================
//
//	ŏ̃|Pio[֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ŏ̃|Pio[Zbg
 *
 * @param	ev			EVENTWORKւ̃|C^
 * @param	no			|Pio[
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_FirstPokeNoSet( EVENTWORK* ev, u16 no )
{
	return SysWork_Set( ev, SYS_WORK_FIRST_POKE_NO, no );
}

//--------------------------------------------------------------------------------------------
/**
 * ŏ̃|Pio[Qbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"ŏ̃|Pio["
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_FirstPokeNoGet( EVENTWORK* ev )
{
	return SysWork_Get( ev, SYS_WORK_FIRST_POKE_NO );
}

//--------------------------------------------------------------------------------------------
/**
 * Cõ|Pio[Qbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"Cõ|Pio["
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_RivalPokeNoGet( EVENTWORK* ev )
{
	u16 rival;
	u16 first = SysWork_Get( ev, SYS_WORK_FIRST_POKE_NO );

#if 1
	if( first == MONSNO_NAETORU ){
		rival = MONSNO_HIKOZARU;
	}else if( first == MONSNO_HIKOZARU ){
		rival = MONSNO_POTTYAMA;
	}else{
		rival = MONSNO_NAETORU;
	}
#endif

	return rival;
}

//--------------------------------------------------------------------------------------------
/**
 * T|[g̃|Pio[Qbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"T|[g̃|Pio["
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_SupportPokeNoGet( EVENTWORK* ev )
{
	u16 support;
	u16 first = SysWork_Get( ev, SYS_WORK_FIRST_POKE_NO );

#if 1
	if( first == MONSNO_NAETORU ){
		support = MONSNO_POTTYAMA;
	}else if( first == MONSNO_HIKOZARU ){
		support = MONSNO_NAETORU;
	}else{
		support = MONSNO_HIKOZARU;
	}
#endif

	return support;
}


//============================================================================================
//
//	׊֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ݂̋L^擾
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"̒l"
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_OokisaRecordGet( EVENTWORK* ev )
{
	return SysWork_Get( ev, SYS_WORK_OOKISA_RECORD );
}

//--------------------------------------------------------------------------------------------
/**
 * L^
 *
 * @param	ev		EVENTWORKւ̃|C^
 * @param	no			̒l
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_OokisaRecordSet( EVENTWORK* ev, u16 no )
{
	return SysWork_Set( ev, SYS_WORK_OOKISA_RECORD, no );
}


//============================================================================================
//
//	ogT[`[֘A
//
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * }bvJڂ̃Zbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Sys_BtlSearcherReset( EVENTWORK* ev )
{
	SysFlag_BtlSearcherUseReset( ev );		//gp
	SysWork_BtlSearcherClearSet( ev, 0 );	//NAJEg
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * obe[JEg擾
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"JEg"
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_BtlSearcherBatteryGet( EVENTWORK* ev )
{
	return SysWork_Get( ev, SYS_WORK_BTL_SEARCHER_BATTERY );
}

//--------------------------------------------------------------------------------------------
/**
 * obe[JEgZbg
 *
 * @param	ev		EVENTWORKւ̃|C^
 * @param	no		ZbgJEg
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_BtlSearcherBatterySet( EVENTWORK* ev, u16 no )
{
	return SysWork_Set( ev, SYS_WORK_BTL_SEARCHER_BATTERY, no );
}

//--------------------------------------------------------------------------------------------
/**
 * NAJEg擾
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"JEg"
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_BtlSearcherClearGet( EVENTWORK* ev )
{
	return SysWork_Get( ev, SYS_WORK_BTL_SEARCHER_CLEAR );
}

//--------------------------------------------------------------------------------------------
/**
 * NAJEgZbg
 *
 * @param	ev		EVENTWORKւ̃|C^
 * @param	no		ZbgJEg
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_BtlSearcherClearSet( EVENTWORK* ev, u16 no )
{
	return SysWork_Set( ev, SYS_WORK_BTL_SEARCHER_CLEAR, no );
}




//============================================================================================
//
//
//			zzCxg֘A
//
//
//============================================================================================
//--------------------------------------------------------------------------------------------
/**
 * @brief	ꂼ̔zzCxgɑΉ}WbNio[Ԃ
 */
//--------------------------------------------------------------------------------------------
static get_haihu_magicnumber(int ex_event_id)
{
	static const u16 magic_number[] = {
		0x1209,
		0x1112,
		0x1123,
	};
	GF_ASSERT(0 <= ex_event_id && ex_event_id < NELEMS(magic_number));
	return magic_number[ex_event_id];
}

//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
void SysWork_HaihuEventWorkSet(EVENTWORK * ev, int haihu_id)
{
	SysWork_Set(ev, SYS_WORK_HAIHU_EVENT01 + haihu_id, get_haihu_magicnumber(haihu_id));
}

//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
void SysWork_HaihuEventWorkClear(EVENTWORK * ev, int haihu_id)
{
	SysWork_Set(ev, SYS_WORK_HAIHU_EVENT01 + haihu_id, 0);
}

//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
BOOL SysWork_HaihuEventWorkCheck(EVENTWORK * ev, int haihu_id)
{
	if (SysWork_Get(ev, SYS_WORK_HAIHU_EVENT01 + haihu_id) == get_haihu_magicnumber(haihu_id)) {
		return TRUE;
	} else {
		return FALSE;
	}
}

//============================================================================================
//
//
//			B}bv֘A
//
//
//============================================================================================
//--------------------------------------------------------------------------------------------
/**
 * @brief	ꂼɑΉ}WbNio[Ԃ
 */
//--------------------------------------------------------------------------------------------
static get_hidemap_magicnumber(int hidemap_id)
{
	static const u16 magic_number[] = {
		0x0208,
		0x0229,
		0x0312,
		0x1028,
	};
	GF_ASSERT(0 <= hidemap_id && hidemap_id < 4);
	return magic_number[hidemap_id];

}
//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
void SysWork_HideMapWorkSet(EVENTWORK * ev, int hidemap_id)
{
	SysWork_Set(ev, SYS_WORK_HIDEMAP_01 + hidemap_id, get_hidemap_magicnumber(hidemap_id));
}
//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
void SysWork_HideMapWorkClear(EVENTWORK * ev, int hidemap_id)
{
	SysWork_Set(ev, SYS_WORK_HIDEMAP_01 + hidemap_id, 0);
}
//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
BOOL SysWork_HideMapWorkCheck(EVENTWORK * ev, int hidemap_id)
{
	if(SysWork_Get(ev, SYS_WORK_HIDEMAP_01 + hidemap_id) == get_hidemap_magicnumber(hidemap_id)) {
		return TRUE;
	} else {
		return FALSE;
	}
}


//--------------------------------------------------------------------------------------------
/**
 * ȒNA
 *
 * @param	ev			EVENTWORKւ̃|C^
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_ParkWalkCountClear( EVENTWORK* ev)
{
	return SysWork_Set( ev, SYS_WORK_PARK_WALK_COUNT, 0 );
}

//--------------------------------------------------------------------------------------------
/**
 * ȒQbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"ŏ̃|Pio["
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_ParkWalkCountGet( EVENTWORK* ev )
{
	return SysWork_Get( ev, SYS_WORK_PARK_WALK_COUNT );
}

//--------------------------------------------------------------------------------------------
/**
 * Ȓ{P
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"ŏ̃|Pio["
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_ParkWalkCountPlus( EVENTWORK* ev )
{
	u16 count;
	count = SysWork_Get( ev, SYS_WORK_PARK_WALK_COUNT );
	if(count < 10000) {		//ł̎gplđ߂ɁiR݂̂ȂQOOOKj
		count++;
	}else{
		count = 10000;
	}
	return SysWork_Set( ev, SYS_WORK_PARK_WALK_COUNT, count );
}

//--------------------------------------------------------------------------------------------
/**
 * VВߐ؂JE^擾
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"JEg"
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_NewsDaysCountGet( EVENTWORK* ev )
{
	return SysWork_Get( ev, SYS_WORK_NEWS_DAYS_COUNT );
}

//--------------------------------------------------------------------------------------------
/**
 * VВߐ؂JE^Zbg
 *
 * @param	ev		EVENTWORKւ̃|C^
 * @param	no		ZbgJEg
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_NewsDaysCountSet( EVENTWORK* ev, u16 no )
{
	return SysWork_Set( ev, SYS_WORK_NEWS_DAYS_COUNT, no );
}

//--------------------------------------------------------------------------------------------
//			|PNW֘A
//--------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------
/**
 * |PNWɒlZbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void SysWork_pokelot_value_set( EVENTWORK* ev ,u32 val)
{
	u16 L, H;

	H = (val >> 16) & 0xffff;
	L = val & 0xffff;
	SysWork_Set( ev, SYS_WORK_POKELOT_RND1, L );
	SysWork_Set( ev, SYS_WORK_POKELOT_RND1, H );

}

//--------------------------------------------------------------------------------------------
/**
 * |PNW̒lQbg
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
u32 SysWork_pokelot_value_get(EVENTWORK* ev)
{
	u16 L, H;
	L = SysWork_Get( ev, SYS_WORK_POKELOT_RND1 );
	H = SysWork_Get( ev, SYS_WORK_POKELOT_RND2 );
	return ((H<<16)|L);
}

//--------------------------------------------------------------------------------------------
/**
 * |PNW̒l
 *  Q[Jn̏
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void SysWorkInitPokeLot(EVENTWORK* ev)
{
	u16  L, H;

	L = gf_rand();
	H = gf_rand();
	OS_Printf("PokeLot L[%d] H[%d]\n",L,H);
	SysWork_pokelot_value_set(ev,(H<<16) | L);
}

//--------------------------------------------------------------------------------------------
/**
 * |PNW̒l
 * o߂ɂXV
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void SysWorkUpdatePokeLot(SAVEDATA *sv,u16 days)
{
	EVENTWORK * ev = SaveData_GetEventWork(sv);
	u32  value;

	value = RandomGroup_GetDefaultRandom(SaveData_GetRandomGroup(sv));

	value = value * 1103515245L + 12345;

	SysWork_pokelot_value_set(ev,value);
}


//--------------------------------------------------------------------------------------------
/**
 * PPA|P̃xƓ̂ƂAACe邨
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"JEg"
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_PokeLevelNoGet( EVENTWORK* ev )
{
	return SysWork_Get( ev, SYS_WORK_POKE_LEVEL_NO );
}

//--------------------------------------------------------------------------------------------
/**
 * PPA|P̃xƓ̂ƂAACe邨
 *
 * @param	ev		EVENTWORKւ̃|C^
 * @param	no		ZbgJEg
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_PokeLevelNoSet( EVENTWORK* ev ,u16 no)
{
	return SysWork_Set( ev, SYS_WORK_POKE_LEVEL_NO, no );
}

//--------------------------------------------------------------------------------------------
/**
 * PPA|P̃xƓ̂ƂAACe邨
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void SysWorkUpdatePokeLevelNo(SAVEDATA *sv)
{
	EVENTWORK * ev = SaveData_GetEventWork(sv);
	u32  value;

	value = (gf_rand() % 98) + 2;		//2-99
	SysWork_PokeLevelNoSet(ev,value);
}

//--------------------------------------------------------------------------------------------
/**
 * nbJEg擾(~JQp)
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"JEg"
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_UGTalkCountGet( EVENTWORK* ev )
{
	u16		count;
	count = SysWork_Get( ev, SYS_WORK_UG_TALK_COUNT );
	OS_Printf("SYS_WORK_UG_TALK_COUNT [%d]\n",count);
	return count;
}

//--------------------------------------------------------------------------------------------
/**
 * nbJEgZbg(~JQp)
 *
 * @param	ev		EVENTWORKւ̃|C^
 * @param	no		ZbgJEg
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_UGTalkCountSet( EVENTWORK* ev, u16 no )
{
	return SysWork_Set( ev, SYS_WORK_UG_TALK_COUNT , no );
}



//--------------------------------------------------------------------------------------------
/**
 * nbJEg擾
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"JEg"
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_UGTalkCount2Get( EVENTWORK* ev )
{
	u16		count;
	count = SysWork_Get( ev, SYS_WORK_UG_TALK_COUNT2 );
	OS_Printf("SYS_WORK_UG_TALK_COUNT2 [%d]\n",count);
	return count;
}

//--------------------------------------------------------------------------------------------
/**
 * nbJEgZbg
 *
 * @param	ev		EVENTWORKւ̃|C^
 * @param	no		ZbgJEg
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_UGTalkCount2Set( EVENTWORK* ev, u16 no )
{
	return SysWork_Set( ev, SYS_WORK_UG_TALK_COUNT2 , no );
}

//--------------------------------------------------------------------------------------------
/**
 * `Qbg
 *
 * @param	ev		EVENTWORKւ̃|C^
 * @param	no		ZbgJEg
 *
 * @return	JEg
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_RensyouCountGet( EVENTWORK* ev)
{
	u16		count;
	count = SysWork_Get( ev, SYS_WORK_RENSYOU_COUNT );
	return count;
}

//--------------------------------------------------------------------------------------------
/**
 * `Zbg
 *
 * @param	ev		EVENTWORKւ̃|C^
 * @param	no		ZbgJEg
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_RensyouCountSet( EVENTWORK* ev, u16 no )
{
	OS_Printf("SYS_WORK_RENSYOU_COUNT <- [%d]\n",no);
	return SysWork_Set( ev, SYS_WORK_RENSYOU_COUNT , no );
}

//--------------------------------------------------------------------------------------------
/**
 *	fp[gw
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"ŏ̃|Pio["
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_RegularCountPlus( EVENTWORK* ev )
{
	u16 count;
	count = SysWork_Get( ev, SYS_WORK_DEPART_COUNT );
	if(count < 10000) {		//[vȂ悤Ƀ~bg
		count++;
	}else{
		count = 10000;
	}
	return SysWork_Set( ev, SYS_WORK_DEPART_COUNT, count );
}

//--------------------------------------------------------------------------------------------
/**
 *	fp[gw
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"JEg"
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_RegularCountGet( EVENTWORK* ev )
{
	return SysWork_Get( ev, SYS_WORK_DEPART_COUNT );
}

//--------------------------------------------------------------------------------------------
/**
 *	nœl̗݌v
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"JEg"
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_UGToolGiveCountGet( EVENTWORK* ev )
{
	return SysWork_Get( ev, SYS_WORK_UG_TOOL_GIVE_COUNT	 );
}

//--------------------------------------------------------------------------------------------
/**
 *	nœlZbg
 *
 * @param	ev		EVENTWORKւ̃|C^
 * @param	no		ZbgJEg
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_UGToolGiveCountSet( EVENTWORK* ev, u16 no )
{
	return SysWork_Set( ev, SYS_WORK_UG_TOOL_GIVE_COUNT	 , no );
}

//--------------------------------------------------------------------------------------------
/**
 *	nł@񐔂̗݌v
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"JEg"
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_UGKasekiDigCountGet( EVENTWORK* ev )
{
	return SysWork_Get( ev, SYS_WORK_UG_KASEKI_DIG_COUNT	 );
}

//--------------------------------------------------------------------------------------------
/**
 *	nł@񐔂Zbg
 *
 * @param	ev		EVENTWORKւ̃|C^
 * @param	no		ZbgJEg
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_UGKasekiDigCountSet( EVENTWORK* ev, u16 no )
{
	return SysWork_Set( ev, SYS_WORK_UG_KASEKI_DIG_COUNT , no );
}

//--------------------------------------------------------------------------------------------
/**
 *	nŃgbvɂ񐔂̗݌v
 *
 * @param	ev		EVENTWORK̃|C^
 *
 * @return	"JEg"
 */
//--------------------------------------------------------------------------------------------
u16 SysWork_UGTrapHitCountGet( EVENTWORK* ev )
{
	return SysWork_Get( ev, SYS_WORK_UG_TRAP_HIT_COUNT	 );
}

//--------------------------------------------------------------------------------------------
/**
 *	nŃgbvɂ񐔂Zbg
 *
 * @param	ev		EVENTWORKւ̃|C^
 * @param	no		ZbgJEg
 *
 * @return	"TRUE=ZbgoAFALSE=ZbgoȂ"
 */
//--------------------------------------------------------------------------------------------
BOOL SysWork_UGTrapHitCountSet( EVENTWORK* ev, u16 no )
{
	return SysWork_Set( ev, SYS_WORK_UG_TRAP_HIT_COUNT , no );
}

//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
u16 SysWork_FriendlyStepCountGet(EVENTWORK * ev)
{
	return SysWork_Get(ev, SYS_WORK_FRIENDLY_COUNT);
}

//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
void SysWork_FriendlyStepCountSet(EVENTWORK * ev, u16 step)
{
	SysWork_Set(ev, SYS_WORK_FRIENDLY_COUNT, step);
}

