//============================================================================================
/**
 * @file	tr_card_setup.c
 * @bfief	g[i[J[hZbgAbv
 * @author	Nozomu Saito
 */
//============================================================================================
#include "common.h"
#include "fieldsys.h"
#include "field/field.h"
#include "system/mystatus.h"
#include "system/zukanwork.h"
#include "application/trainer_card.h"
#include "savedata/trainercard_data.h"
#include "savedata/record.h"
#include "savedata/playtime.h"
#include "ev_time.h"
#include "comm_union.h"
#include "field/eventflag.h"
#include "contest/contest_def.h"
#include "sysflag.h"
#include "savedata/undergrounddata.h"

#include "tr_card_setup.h"

#define COMM_NUM_MAX	(999999)
#define BATTLE_WIN_MAX	(9999)
#define BATTLE_LOSE_MAX	(9999)
#define TRADE_MAX		(99999)

static void TRCSET_SetTrCardDataCommon(	const u8 inBadgeBrushFlg,
										const u8 inVersion,
										const u8 inCardRank,
										const u8 inGymReaderMask,
										const u8 inCountryCode,
										TR_CARD_DATA *outTrCardData);

static void TRCSET_SetTrCardDataFace(	const u16 inID,
										const u8  inSex,
										const STRCODE *inName,
										const u32 inMoney,
										const u32 inPokeBook,
										const BOOL inPokeBookFlg,
										const u32 inScore,
										TR_CARD_DATA *outTrCardData);

static void TRCSET_SetTrCardDataTime(	const u8 inClearFlg,
										const PLAYTIME *inPlayTime,
										const RTCDate *inStartDate,
										const RTCDate *inClearDate,
										const RTCTime *inClearTime,
										const u8 TimeUpdate,
										TR_CARD_DATA *outTrCardData);

static void TRCSET_SetTrCardDataBack(	const u32 inCommNum,
										const u32 inCommBattleWin,
										const u32 inCommBattleLose,
										const u32 inCommTrade,
										const u8 *inSignData,
										TR_CARD_DATA *outTrCardData);
static void TRCSET_SetTrCardDataBadge(	MYSTATUS *inMySt, FIELDSYS_WORK *fsys, TR_CARD_DATA *outTrCardData );

static BOOL SetupTrCardEvent(GMEVENT_CONTROL * event);

//--------------------------------------------------------------------------------------------
/**
 * g[i[J[hWāAf[^쐬
 *
 * @param	inBadgeBrushFlg		obWLL
 * @param	inTimeUpdate		ԍXVtO
 * @;aram	inGymRaederMask		W[_[}XN
 * @param	inUnionTrNo			jIg[i[io[i0`15j@w肵ȂƂ,UNION_TR_NONE
 * @param	fsys				tB[hVXe|C^
 * @param	outTrCardData		g[i[J[hf[^|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void TRCSET_MakeTrainerInfo(const u8 inBadgeBrushFlg,
							const u8 inTimeUpdate,
							const u8 inGymReaderMask,
							const u8 inUnionTrNo,
							FIELDSYS_WORK *fsys, 
							TR_CARD_DATA *outTrCardData)
{
	MYSTATUS *my_st;
	RECORD *rec;
	SAVEDATA * sv;
	sv = GameSystem_GetSaveData(fsys);
	my_st = SaveData_GetMyStatus(sv);
	rec = SaveData_GetRecord(sv);

	outTrCardData->UnionTrNo = inUnionTrNo;

	{
		u8 rank;
		//NZo
		rank = TRCSET_GetCardRank(fsys);
	
		TRCSET_SetTrCardDataCommon( inBadgeBrushFlg, PM_VERSION, rank,
									inGymReaderMask, MyStatus_GetRegionCode(my_st), outTrCardData);
	}
	
	TRCSET_SetTrCardDataFace(	MyStatus_GetID_Low(my_st),
								MyStatus_GetMySex(my_st),
								MyStatus_GetMyName(my_st),
								MyStatus_GetGold(my_st),
								ZukanWork_GetZukanPokeSeeCount( SaveData_GetZukanWork(fsys->savedata) ),
								ZukanWork_GetZukanGetFlag(SaveData_GetZukanWork(fsys->savedata)),
								RECORD_Score_Get(rec),
								outTrCardData);

	{
		RTCDate start_date;	//JnN
		RTCDate clear_date;	//NAN
		RTCTime time;		//NA

		PLAYTIME *play_time;

		play_time = SaveData_GetPlayTime(sv);
		
		EVTIME_GetGameStartDateTime(fsys, &start_date, &time);
		EVTIME_GetGameClearDateTime(fsys, &clear_date, &time);

		TRCSET_SetTrCardDataTime(	SysFlag_GameClearCheck( SaveData_GetEventWork( fsys->savedata ) ),
									play_time,
									&start_date,
									&clear_date,
									&time,
									inTimeUpdate,
									outTrCardData);
	}

	{
		u32 count,win,lose,trade;
		TR_CARD_SV_PTR trc_ptr;
		trc_ptr = TRCSave_GetSaveDataPtr(fsys->savedata);
		
		//ʐM	CXReXg+CX+WiFi+CXΐ+WiFiΐ+CX|g
		count = RECORD_Get(rec, RECID_CONTEST_COMM_ENTRY)+
				RECORD_Get(rec, RECID_COMM_TRADE)+RECORD_Get(rec, RECID_WIFI_TRADE)+
				RECORD_Get(rec, RECID_COMM_BATTLE)+RECORD_Get(rec, RECID_WIFI_BATTLE)+
				RECORD_Get(rec, RECID_PORUTO_COMM);
		//	CX+WiFi
		win = RECORD_Get(rec, RECID_COMM_BTL_WIN)+RECORD_Get(rec, RECID_WIFI_BTL_WIN);
		//	CX+WiFi
		lose = RECORD_Get(rec, RECID_COMM_BTL_LOSE)+RECORD_Get(rec, RECID_WIFI_BTL_LOSE);
		//ʐM	CX+WiFi
		trade = RECORD_Get(rec, RECID_COMM_TRADE)+RECORD_Get(rec, RECID_WIFI_TRADE);

		TRCSET_SetTrCardDataBack(	count,
									win,
									lose,
									trade,
									TRCSave_GetSighnDataPtr(trc_ptr),
									outTrCardData);
	}

	TRCSET_SetTrCardDataBadge( my_st, fsys, outTrCardData );

	{
		int i,tmp=0;
		u8 *p = (u8*)outTrCardData;
		for(i=0;i<sizeof(TR_CARD_DATA);i++){
			tmp ^= p[i];
		}
		outTrCardData->_xor = tmp;
	}

	
	
	outTrCardData->reached  = 0;
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[J[hAP[V
 *
 * @param	inHeapID		q[vID
 *
 * @return	TR_CARD_DATA*	g[i[J[hf[^|C^
 */
//--------------------------------------------------------------------------------------------
TR_CARD_DATA *TRCSET_AllocTrainerCardData( const u16 inHeapID )
{
	TR_CARD_DATA * tcd = sys_AllocMemory( inHeapID, sizeof(TR_CARD_DATA) );
	memset( tcd, 0, sizeof(TR_CARD_DATA) );

	return tcd; 
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[J[h
 *
 * @param	*outData	郁
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void TRCSET_FreeTrainerCardData( TR_CARD_DATA *outData )
{
	sys_FreeMemoryEz(outData);
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[J[hN擾
 *
 * @param
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
u8 TRCSET_GetCardRank(FIELDSYS_WORK *fsys)
{
	u8 rank;
	SAVEDATA * sv;
	RECORD *rec;
	EVENTWORK *ev;
	SB_RECORD_DATA* sbd;
	
	sv = GameSystem_GetSaveData(fsys);
	rec = SaveData_GetRecord(sv);
	ev = SaveData_GetEventWork(sv);
	sbd = SaveData_GetSecretBaseRecord(sv);
	rank = TR_CARD_RANK_NORMAL;
	
	//aiNAtOj
	if ( SysFlag_GameClearCheck( ev ) ){
		rank++;
	}
	//S}ӊiCxgn|P|PQbgĂ邩j
	if ( ZukanWork_CheckZenkokuComp(SaveData_GetZukanWork(sv)) ){
		rank++;
	}
	//og^[100Ai^Cv͂Ȃłj
	if ( (RECORD_Get(rec,RECID_RENSHOU_SINGLE )>=100)||
		 (RECORD_Get(rec,RECID_RENSHOU_DOUBLE )>=100)||
		 (RECORD_Get(rec,RECID_RENSHOU_MULTI )>=100)||
		 (RECORD_Get(rec,RECID_RENSHOU_COMM_MULTI )>=100)||
		 (RECORD_Get(rec,RECID_RENSHOU_WIFI )>=100) ){ 
		rank++;
	}
	//ReXg}X^[Di^Cv͂Ȃłj
	if ( SysFlag_ConMasterCheck( ev, CONTYPE_STYLE )||
		 SysFlag_ConMasterCheck( ev, CONTYPE_BEAUTIFUL )||
		 SysFlag_ConMasterCheck( ev, CONTYPE_CLEVER )||
		 SysFlag_ConMasterCheck( ev, CONTYPE_STRONG )||
		 SysFlag_ConMasterCheck( ev, CONTYPE_CUTE ) ){
		rank++;
	}
	//n}X^[
	
	if ( SecretBaseRecordGetUGRank(sbd) == UG_RANK_MASTER ){
		rank++;
	}
	return rank;
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[J[hZbg
 *
 * @param	inBadgeBrushFlg		obWLL
 * @param	inVersion			o[W
 * @param	inCardRank			J[hN
 * @param	inGymReaderMask		W[_[}XN
 * @param	inCoutryCode		R[h
 * @param	outTrCardData		g[i[J[hf[^|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void TRCSET_SetTrCardDataCommon(	const u8 inBadgeBrushFlg,
										const u8 inVersion,
										const u8 inCardRank,
										const u8 inGymReaderMask,
										const u8 inCountryCode,
										TR_CARD_DATA *outTrCardData)
{
	//obWAvLtO
	outTrCardData->BrushValid = inBadgeBrushFlg;
	//\tgo[W
	outTrCardData->Version = inVersion;
	//J[hN;
	outTrCardData->CardRank = inCardRank;
	//R[h
	outTrCardData->CountryCode = inCountryCode;
	//W[_[}XN
	outTrCardData->GymReaderMask = inGymReaderMask;

	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/07
	// W[_[̃}XLOeXg폜
	// ----------------------------------------------------------------------------
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[J[hZbg(\)
 *
 * @param	inID			g[i[ID
 * @param	inSex			
 * @param	inName			Ȃ܂
 * @param	inMoney			Â
 * @param	inPokeBook		}ӃX^[
 * @param	inPokeBookFlg	}ӏtO
 * @param	inScore			XRA
 * @param	outTrCardData	g[i[J[hf[^|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void TRCSET_SetTrCardDataFace(	const u16 inID,
										const u8  inSex,
										const STRCODE *inName,
										const u32 inMoney,
										const u32 inPokeBook,
										const BOOL inPokeBookFlg,
										const u32 inScore,
										TR_CARD_DATA *outTrCardData)
{
	//g[i[ID
	outTrCardData->TrainerID = inID;
	//
	outTrCardData->TrSex = inSex;
	//g[i[
	PM_strncpy( outTrCardData->TrainerName, inName, PERSON_NAME_SIZE+EOM_SIZE );
//	outTrCardData->TrainerName = inName;
	//Â
	outTrCardData->Money = inMoney;
	//
	outTrCardData->PokeBook = inPokeBook;
	//񎝂Ă邩
	outTrCardData->PokeBookFlg = inPokeBookFlg;
	//XRA
	outTrCardData->Score = inScore;

}

//--------------------------------------------------------------------------------------------
/**
 * g[i[J[hZbg()
 * 
 * @param	inClearFlg		NAtO
 * @param	inPlayTime		vC
 * @param	inStartDate		JnN
 * @param	inClearDate		NAN
 * @param	inClearTime		NA
 * @param	outTrCardData	g[i[J[hf[^|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void TRCSET_SetTrCardDataTime(	const u8 inClearFlg,
										const PLAYTIME *inPlayTime, 
										const RTCDate *inStartDate,
										const RTCDate *inClearDate,
										const RTCTime *inClearTime,
										const u8 inTimeUpdate,
										TR_CARD_DATA *outTrCardData)
{
	//vC
	outTrCardData->PlayTime_h = PLAYTIME_GetHour(inPlayTime);
	outTrCardData->PlayTime_m = PLAYTIME_GetMinute(inPlayTime);
	//JnN
	outTrCardData->Start_y = inStartDate->year;
	outTrCardData->Start_m = inStartDate->month;
	outTrCardData->Start_d = inStartDate->day;
	if (inClearFlg){
		//NAN
		outTrCardData->Clear_y = inClearDate->year;
		outTrCardData->Clear_m = inClearDate->month;
		outTrCardData->Clear_d = inClearDate->day;
		//NA
		outTrCardData->ClearTime_h = inClearTime->hour;
		outTrCardData->ClearTime_m = inClearTime->minute;
	}else{
		//NAN
		outTrCardData->Clear_y = 0;
		outTrCardData->Clear_m = 0;
		outTrCardData->Clear_d = 0;
		//NA
		outTrCardData->ClearTime_h = 0;
		outTrCardData->ClearTime_m = 0;
	}
	
	//ԍXVtO
	outTrCardData->TimeUpdate = inTimeUpdate;
	//ԍXVtOĂȂ΁AvCԍ\̂̃|C^Zbg
	if (inTimeUpdate){
		outTrCardData->PlayTime = inPlayTime;
	}else{
		outTrCardData->PlayTime = NULL;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[J[hZbg()
 *
 * @param	inCommNum			ʐM
 * @param	inCommBattleWin		ʐMΐ폟
 * @param	inCommBattleLose	ʐMΐ핉
 * @param	inCommTrade			
 * @param	outTrCardData		g[i[J[hf[^|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void TRCSET_SetTrCardDataBack(	const u32 inCommNum,
										const u32 inCommBattleWin,
										const u32 inCommBattleLose,
										const u32 inCommTrade,
										const u8 *inSignData,
										TR_CARD_DATA *outTrCardData)
{
	//ʐM
	outTrCardData->CommNum = inCommNum;
	if (outTrCardData->CommNum > COMM_NUM_MAX){
		outTrCardData->CommNum = COMM_NUM_MAX;
	}
	
	//ʐM퓬
	outTrCardData->CommBattleWin = inCommBattleWin;
	outTrCardData->CommBattleLose = inCommBattleLose;
	if (outTrCardData->CommBattleWin > BATTLE_WIN_MAX){
		outTrCardData->CommBattleWin = BATTLE_WIN_MAX;
	}
	if (outTrCardData->CommBattleLose > BATTLE_LOSE_MAX){
		outTrCardData->CommBattleLose = BATTLE_LOSE_MAX;
	}
	//ʐM
	outTrCardData->CommTrade = inCommTrade;
	if (outTrCardData->CommTrade > TRADE_MAX){
		outTrCardData->CommTrade = TRADE_MAX;
	}
	//TCf[^Z[uf[^Rs[
	MI_CpuCopy8( inSignData, outTrCardData->SignRawData, SIGN_SIZE_X*SIGN_SIZE_Y*8 );
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[J[hZbg(\)
 *
 * @param	inMySt			}CXe[^X
 * @param	fsys			tB[hVXe|C^
 * @param	outTrCardData	g[i[J[hf[^|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void TRCSET_SetTrCardDataBadge(	MYSTATUS *inMySt, FIELDSYS_WORK *fsys, TR_CARD_DATA *outTrCardData )
{
	u8 i;
	TR_CARD_SV_PTR trc_ptr;
	TR_BADGE_DATA_PTR badge_ptr;
	trc_ptr = TRCSave_GetSaveDataPtr(fsys->savedata);
	badge_ptr = TRCSave_GetBadgeDataPtr(trc_ptr);
	
	for(i=0;i<8;i++){
		//obWtO
		if (MyStatus_GetBadgeFlag(inMySt, i)){
			outTrCardData->BadgeData[i].BadgeHold = 1;
		}else{
			outTrCardData->BadgeData[i].BadgeHold = 0;
		}
		
		//
		outTrCardData->BadgeData[i].BadgeScruchCount = TRCSave_GetBadgeScruchCount(i, badge_ptr);
	}
}

//--------------------------------------------------------------------------------------------
/**
 * obW񐔍XV
 *
 * @param	fsys			tB[hVXe|C^
 * @param	inTrCardData	g[i[J[hf[^|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void TRCSET_UpdateBadgeScruchCount(FIELDSYS_WORK *fsys, const TR_CARD_DATA *inTrCardData)
{
	u8 i;
	TR_CARD_SV_PTR trc_ptr;
	TR_BADGE_DATA_PTR badge_ptr;
	trc_ptr = TRCSave_GetSaveDataPtr(fsys->savedata);
	badge_ptr = TRCSave_GetBadgeDataPtr(trc_ptr);

	for(i=0;i<8;i++){
		TRCSave_SetBadgeScruchCount(i, inTrCardData->BadgeData[i].BadgeScruchCount, badge_ptr);
	}
}

//==============================================================================
// g[i[J[h[NCxgŎgp\
//==============================================================================
typedef struct{
	int	seq;
	TR_CARD_DATA *partner;
	
}COMM_TRAINER_EVENT_WORK;

//==============================================================================
/**
 * ʐMpg[i[J[h쐬
 * 
 * @param	fsys		tB[hVXe|C^
 *
 * @retval  none
 */
//==============================================================================
void TRCSET_SetupTrCardEvent(FIELDSYS_WORK * fsys)
{
	// Cxg[N쐬
	COMM_TRAINER_EVENT_WORK *wk = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(COMM_TRAINER_EVENT_WORK));
	wk->seq = 0;

	// g[i[J[h[N쐬{̃g[i[J[h|C^擾
	wk->partner = (TR_CARD_DATA*)Union_TrainerCardWorkInit(fsys->union_work);
	
	FieldEvent_Call(fsys->event, SetupTrCardEvent, wk);
}

//==============================================================================
/**
 * ʐMpg[i[J[h쐬Cxg
 * 
 * @param	@param	event	Cxg|C^
 *
 * @retval  BOOL	TRUE:CxgI@FALSEFCxgp
 */
//==============================================================================
static BOOL SetupTrCardEvent(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	COMM_TRAINER_EVENT_WORK *wk  = FieldEvent_GetSpecialWork(event);

	switch(wk->seq){
	case 0:
		//g[i[J[hf[^M
		Union_SendTrainerCardData(fsys->union_work);
		OS_Printf("J[ḧm\n");
		wk->seq = 1;
	case 1:
		// ̃J[hf[^M
		if(wk->partner->reached!=0){
			OS_Printf("J[hf[^M\n");
			wk->seq = 10;
		}
		break;
		

	case 10:
		// ̃g[i[J[h{Jn
		FieldTrCard_SetProc( fsys, wk->partner );	
		OS_Printf("J[h\Jn\n");
		wk->seq = 11;
		break;
	case 11:
		// TuvZXI҂
		if( !FieldEvent_Cmd_WaitSubProcEnd( fsys ) ) {

			// g[i[J[h[N
			Union_trainerCardWorkFree(fsys->union_work);

			// Cxg[N
			sys_FreeMemoryEz(wk);
			return TRUE;
		}
		break;
	}

	return FALSE;
}


