//============================================================================================
/**
 * @file	tv_broadcast.c
 * @brief
 * @author	tamada GAME FREAK inc.
 * @date	2006.05.17
 */
//============================================================================================

#include "common.h"

#include "fieldsys.h"

#include "savedata/tv_work.h"
#include "tv_define.h"


#include "system/pm_rtc.h"
#include "ev_time.h"

#include "tv.h"
#include "scr_tv.h"

#include "msgdata/msg.naix"

#include "system/pm_rtc.h"

#include "system/arc_tool.h"
#include "../arc/tv.naix"

#include "msgdata/msg_tv_program.h"
#include "msgdata/msg_tvcm.h"
#include "msgdata/msg_tv_interview.h"
#include "msgdata/msg_msg_tv_01.h"
#include "msgdata/msg_msg_tv_02.h"
#include "msgdata/msg_msg_tv_03.h"
#include "msgdata/msg_msg_tv_04.h"

#include "system/debug_flag.h"

#ifdef	PM_DEBUG
#define	TV_BROADCAST_DEBUG
#endif
//============================================================================================
//
//============================================================================================
//--------------------------------------------------------------------
/**
 * @brief	Pԑgŕ\ȃgsbNނ̍ől
 */
//--------------------------------------------------------------------
#define	PROG_TOPIC_MAX		8

#define	TOPIC_ARRAY_MAX		16

//--------------------------------------------------------------------
/**
 * @brief	ԑgef[^̒
 *
 * topic_typePoCgAtopic_idPoCgPROG_TOPIC_MAX̍v9oCgō\Ă܂B
 * 9oCg8ԑg72oCg̃oCif[^擾Ă܂B
 */
//--------------------------------------------------------------------
#define	CONTENTS_DATA_LEN	(1 + PROG_TOPIC_MAX)

//--------------------------------------------------------------------
/**
 */
//--------------------------------------------------------------------
typedef struct {
	u8 morning_id;
	u8 noon_id;
	u8 night_id;
	u8 first_intro_id;
	u8 next_intro_id;
	u8 end_id;
	u8 make_id;
}TVPROG_MSG;

//============================================================================================
//============================================================================================
//--------------------------------------------------------------------
//--------------------------------------------------------------------
static const TVPROG_MSG TVProgramMsg[] = {
	{	//01	@g[i[
		msg_tv_00_01_01,
		msg_tv_00_01_02,
		msg_tv_00_01_03,
		msg_tv_00_01_04,
		msg_tv_00_01_05,
		msg_tv_00_01_06,
		msg_tv_00_01_07,
	},
	{	//02	g[i[T[`
		msg_tv_00_02_01,
		msg_tv_00_02_02,
		msg_tv_00_02_03,
		msg_tv_00_02_04,
		msg_tv_00_02_05,
		msg_tv_00_02_06,
		msg_tv_00_02_07,
	},
	{	//03	ogEHb`
		msg_tv_00_03_01,
		msg_tv_00_03_02,
		msg_tv_00_03_03,
		msg_tv_00_03_04,
		msg_tv_00_03_05,
		msg_tv_00_03_06,
		msg_tv_00_03_07,
	},
	{	//04	g[i[́@ɂ傤
		msg_tv_00_04_01,
		msg_tv_00_04_02,
		msg_tv_00_04_03,
		msg_tv_00_04_04,
		msg_tv_00_04_05,
		msg_tv_00_04_06,
		msg_tv_00_04_07,
	},
	{	//05	VIE@j[X@lbg
		msg_tv_00_05_01,
		msg_tv_00_05_02,
		msg_tv_00_05_03,
		msg_tv_00_05_04,
		msg_tv_00_05_05,
		msg_tv_00_05_06,
		msg_tv_00_05_07,
	},
	{	//06	낭ŃSI
		msg_tv_00_06_01,
		msg_tv_00_06_02,
		msg_tv_00_06_03,
		msg_tv_00_06_04,
		msg_tv_00_06_05,
		msg_tv_00_06_06,
		msg_tv_00_06_07,
	},
	{	//07	VIEEiEI
		msg_tv_00_07_01,
		msg_tv_00_07_02,
		msg_tv_00_07_03,
		msg_tv_00_07_04,
		msg_tv_00_07_05,
		msg_tv_00_07_06,
		msg_tv_00_07_07,
	},
	{	//08	gh΂񂮂
		msg_tv_00_08_01,
		msg_tv_00_08_02,
		msg_tv_00_08_03,
		msg_tv_00_08_04,
		msg_tv_00_08_05,
		msg_tv_00_08_06,
		msg_tv_00_08_07,
	},
};
//============================================================================================
//============================================================================================

//--------------------------------------------------------------------
/**
 * @brief	ԑgIԂɂ
 * @param	fsys
 *
 * XNvgĂ΂
 */
//--------------------------------------------------------------------
void TV_SetEndFlag(FIELDSYS_WORK * fsys)
{
	TV_WORK * tvwk = SaveData_GetTvWork(fsys->savedata);
	TVWORK_SetProgramEnd(tvwk, TRUE);
}

//--------------------------------------------------------------------
/**
 * @brief	ԑg̏Ԃ擾
 * @param	fsys
 * @retval	TV_STATUS_PROGRAM_END
 * @retval	TV_STATUS_TOPIC_END
 * @retval	TV_STATUS_START
 * @retval	TV_STATUS_ONAIR
 * @retval	TV_STATUS_NO_TOPIC
 *
 * XNvgĂ΂
 */
//--------------------------------------------------------------------
int TV_GetBroadcastStatus(FIELDSYS_WORK * fsys)
{
	int num;
	TV_WORK * tvwk = SaveData_GetTvWork(fsys->savedata);

#ifdef	TV_BROADCAST_DEBUG
	TVWORK_DEBUG_Info(tvwk);
#endif
	if (TVWORK_IsProgramEnd(tvwk) == TRUE) {
		return	TV_STATUS_PROGRAM_END;	//ԑgI
	}
	num = TVWORK_GetUsedTopicNumber(tvwk);
	if (num == 0) {
		return TV_STATUS_START;			//ԑgJn
	}
	if (num == 4) {
		return TV_STATUS_TOPIC_END;		//SgsbN
	}
	return TV_STATUS_ONAIR;			//ԑgi2ڈȍ~j
}


//============================================================================================
//============================================================================================
#ifdef	TV_BROADCAST_DEBUG
static void DebugPutList(const char * name, const u8 * list, int max)
{
	int i;
	OS_Printf("%s", name);
	for (i = 0; i < PROG_TOPIC_MAX; i++) {
		OS_TPrintf("%02d ", list[i]);
	}
	OS_PutString("\n");
}
#endif

//--------------------------------------------------------------------
/**
 * @brief	݂̔ԑgID擾
 * @param	fsys
 * @return	int		ԑgID
 */
//--------------------------------------------------------------------
static TV_PROGRAM_ID GetNowProgramID(FIELDSYS_WORK * fsys)
{
	u8 id;
	u8 plist[7];
	int week, hour, min;
	int ofs;
	week = (EVTIME_GetWeek(fsys) + 6) % 7;
	hour = EVTIME_GetHour(fsys);
	min = EVTIME_GetMinute(fsys);
	ofs = (((19 + hour) % 24) * 4 + (min / 15)) * 7;
	ArchiveDataLoadOfs(plist, ARC_TV, NARC_tv_list_bin, ofs, sizeof(u8) * 7);
	id = plist[week];
#ifdef	TV_BROADCAST_DEBUG
	if (DebugFlagData.tv_program_id != 0) {
		id = DebugFlagData.tv_program_id;
	}
#endif
#ifdef	DEBUG_ONLY_FOR_tamada
	{
		int i;
		OS_TPrintf("TVID:%d week=%d %02d:%02d\n",id, EVTIME_GetWeek(fsys), hour, min);
		for (i = 0; i < 7; i++) {
			OS_TPrintf(" %02d",plist[i]);
		}
		OS_PutString("\n");
	}
#endif
	GF_ASSERT(0 < id && id < TV_PROGRAM_ID_MAX);
	return id;
}

//============================================================================================
//
//
//		ԑgef[^̎擾
//
//
//============================================================================================
//--------------------------------------------------------------------
/**
 * @brief	gsbNʂ̎擾
 * @param	prog_id
 * @return	TVTOPICTYPE
 */
//--------------------------------------------------------------------
static TVTOPICTYPE GetTopicType(TV_PROGRAM_ID prog_id)
{
	u8 type;
	int ofs = CONTENTS_DATA_LEN * (prog_id - 1);
	ArchiveDataLoadOfs(&type, ARC_TV, NARC_tv_contents_bin, ofs, sizeof(u8));
	OS_TPrintf("TV TOPIC TYPE %d\n", type);
	GF_ASSERT(type < TVTOPICTYPE_MAX);
	return type;
}
//--------------------------------------------------------------------
/**
 * @brief	ԑggsbNID̎擾
 * @param	prog_id
 * @param	list	gsbNIDRs[郏[Nւ̃|C^
 */
//--------------------------------------------------------------------
static void GetTopicList(TV_PROGRAM_ID prog_id, u8 * list)
{
	u8 type;
	int ofs = CONTENTS_DATA_LEN * (prog_id - 1) + 1;
	ArchiveDataLoadOfs(list, ARC_TV, NARC_tv_contents_bin, ofs, sizeof(u8) * PROG_TOPIC_MAX);
#ifdef TV_BROADCAST_DEBUG
	DebugPutList("TOPIC_ID:", list, PROG_TOPIC_MAX);
#endif
}

//============================================================================================
//============================================================================================

//--------------------------------------------------------------------
/**
 * @brief	gsbN
 * @param	fsys
 * @param	prog_id
 * @param	topic_id
 * @retval	TRUE
 * @retval	FALSE
 */
//--------------------------------------------------------------------
static BOOL IsEnableBroadcast(FIELDSYS_WORK * fsys, TV_PROGRAM_ID prog_id, int topic_id)
{
	return TRUE;
}

//--------------------------------------------------------------------
/**
 * @brief	̂ȂgsbÑXg쐬
 */
//--------------------------------------------------------------------
static void MakeTopicTypeList(TV_PROGRAM_ID prog_id, FIELDSYS_WORK * fsys, u8 * type_array)
{
	u8 tlist[PROG_TOPIC_MAX];
	int i, n;
	TV_WORK * tvwk = SaveData_GetTvWork(fsys->savedata);
	GetTopicList(prog_id, tlist);

	MI_CpuClear8(type_array, sizeof(u8) * PROG_TOPIC_MAX);

	//̂ĂȂgsbN𒊏o
	for (i = 0, n = 0; i < PROG_TOPIC_MAX; i++) {
		if (tlist[i] == 0) {
			break;
		}
		if (IsEnableBroadcast(fsys,prog_id,tlist[i]) == TRUE) {
			type_array[n] = tlist[i];
			n ++;
		}
	}
}

//--------------------------------------------------------------------
/**
 * @brief	_ŃCfbNXI
 */
//--------------------------------------------------------------------
static int SelectRandomTopicData(FIELDSYS_WORK * fsys, const u8 * t_array)
{
	u8 array[PROG_TOPIC_MAX];
	int i,n;
	MI_CpuClear8(array, sizeof(u8) * PROG_TOPIC_MAX);
	for (i = 0, n = 0; i < PROG_TOPIC_MAX; i++) {
		if (t_array[i] != 0) {
			array[n] = t_array[i];
			n ++;
		}
	}
	if (n == 0) {
		return 0;
	} else if (n == 1) {
		return array[0];
	}
	return array[gf_mtRand() % n];
}

//--------------------------------------------------------------------
/**
 * @brief	wgsbN̒o
 * @param	tvwk	er[Nւ̃|C^
 * @param	topic_type	gsbN̎
 * @param	topic_id	gsbNID
 * @param	mine	f[^ǂ
 * @param	see		ǂ
 * @param	array	gsbNCfbNXi[̂߂̔zւ̃|C^
 */
//--------------------------------------------------------------------
static int SelectExistTopic(TV_WORK * tvwk, TVTOPICTYPE topic_type,
		int topic_id, BOOL mine, BOOL see, u8 * array)
{
	if (topic_type != TVTOPICTYPE_EVENT) {
		return TVWORK_SearchTopics(tvwk, topic_type, topic_id, mine, see, array);
	}
	if (see) {	//ǂoĂȂ̂łƂ肠
		return 0;
	}
	if (!mine) {
		return 0;
	}
	if (TVWORK_IsUsedTopicIndex(tvwk, topic_id) == FALSE) {
		array[0] = topic_id;
		return 1;
	}
	return 0;
	
}

//--------------------------------------------------------------------
/**
 * @brief	
 * @param	fsys	tB[hւ̃|C^
 * @param	mine	f[^ǂ
 * @param	see		ǂ
 * @param	type_array	gsbNID̔zւ̃|C^
 * @param	topic_array	gsbNCfbNXi[̂߂̔zւ̃|C^
 */
//--------------------------------------------------------------------
static int SelectExistTopicData(TVTOPICTYPE topic_type,
		FIELDSYS_WORK * fsys, BOOL mine, BOOL see, const u8 * type_array, u8 * topic_array)
{
	u8 array[TOPIC_ARRAY_MAX];
	TV_WORK * tvwk = SaveData_GetTvWork(fsys->savedata);
	int i,j;
	int n = 0;

	while (*type_array != 0) {
		MI_CpuClear8(array, TOPIC_ARRAY_MAX);
		if (SelectExistTopic(tvwk, topic_type, *type_array, mine, see, array)) {
			for (j = 0; array[j] != 0 && j < TOPIC_ARRAY_MAX; j++) {
				topic_array[n] = array[j];
				n ++;
			}
		}
		type_array ++;
	}
	return n;
}

//--------------------------------------------------------------------
/**
 * @brief	fłȂgsbN폜
 * @param	fsys		tB[hւ̃|C^
 * @param	topic_type	gsbN̎
 * @param	topic_array	gsbNCfbNXi[̂߂̔zւ̃|C^
 */
//--------------------------------------------------------------------
static void SelectEnableTopicData(FIELDSYS_WORK * fsys, TVTOPICTYPE topic_type, u8 * topic_array)
{
	int i;
	TVBCD * bcd;
	for (i = 0; *topic_array != 0 && i < TOPIC_ARRAY_MAX; topic_array ++, i++) {
		bcd = TVBCD_Create(fsys, topic_type, *topic_array);
		if (!TVTOPIC_CheckLimit(topic_type, fsys, bcd)) {
			*topic_array = 0;
		}
		TVBCD_Delete(bcd);
	}
}

//--------------------------------------------------------------------
/**
 * @brief	ԑgŕgsbN폜
 * @param	fsys		tB[hւ̃|C^
 * @param	topic_array	gsbNCfbNXi[̂߂̔zւ̃|C^
 */
//--------------------------------------------------------------------
static void DeleteUsedTopicData(FIELDSYS_WORK * fsys, u8 * topic_array)
{
	TV_WORK * tvwk = SaveData_GetTvWork(fsys->savedata);
	while (*topic_array != 0) {
		if (TVWORK_IsUsedTopicIndex(tvwk, *topic_array)) {
			*topic_array = 0;
		}
		topic_array ++;
	}
}

//--------------------------------------------------------------------
/**
 * @brief	gsbN𒊏o
 * @param	fsys
 * @param	mine
 * @param	see
 * @return	int		0̂ƂAf[^Ȃ
 */
//--------------------------------------------------------------------
int TV_ChooseBroadcastTopic(FIELDSYS_WORK * fsys, BOOL mine, BOOL see)
{
	u8 type_array[PROG_TOPIC_MAX];
	u8 topic_array[TOPIC_ARRAY_MAX];
	int result;
	TV_PROGRAM_ID prog_id;
	int topic_type;
	
	prog_id = GetNowProgramID(fsys);
	topic_type = GetTopicType(prog_id);

	MI_CpuClear8(type_array, PROG_TOPIC_MAX);
	MI_CpuClear8(topic_array, TOPIC_ARRAY_MAX);

	//̂ȂgsbÑXg
	MakeTopicTypeList(prog_id, fsys, type_array);
#ifdef	TV_BROADCAST_DEBUG
	DebugPutList("TOPIC_ID:", type_array, PROG_TOPIC_MAX);
#endif

	//f[^݃`FbNőI
	result = SelectExistTopicData(topic_type, fsys, mine, see, type_array, topic_array);
#ifdef	TV_BROADCAST_DEBUG
	DebugPutList("EXIST  INDEX:",topic_array, TOPIC_ARRAY_MAX);
#endif
	if (result == 0) {
		return 0;			//f[^Ȃ
	}
	// łȂgsbN폜
	SelectEnableTopicData(fsys, topic_type, topic_array);
#ifdef	TV_BROADCAST_DEBUG
	DebugPutList("ENABLE INDEX:",topic_array, TOPIC_ARRAY_MAX);
#endif

	//ς݃gsbNr
	DeleteUsedTopicData(fsys, topic_array);
#ifdef	TV_BROADCAST_DEBUG
	DebugPutList("NOTUSE INDEX:",topic_array, TOPIC_ARRAY_MAX);
#endif

	//ĉ痐őI
	result = SelectRandomTopicData(fsys, topic_array);

	return result;
}

//--------------------------------------------------------------------
/**
 */
//--------------------------------------------------------------------
int TV_ChooseBroadcastTopicTotal(FIELDSYS_WORK * fsys)
{
	int result;
	result = TV_ChooseBroadcastTopic(fsys, TV_OTHER_TOPIC, TV_NEW_TOPIC);
	if (result) {
		return result;
	}
	result = TV_ChooseBroadcastTopic(fsys, TV_MINE_TOPIC, TV_NEW_TOPIC);
	if (result) {
		return result;
	}
	result = TV_ChooseBroadcastTopic(fsys, TV_OTHER_TOPIC, TV_OLD_TOPIC);
	if (result) {
		return result;
	}
	result = TV_ChooseBroadcastTopic(fsys, TV_MINE_TOPIC, TV_OLD_TOPIC);
	return result;
}

//============================================================================================
//============================================================================================

//--------------------------------------------------------------------
/**
 * @brief	ԑgɂ킹ăbZ[W\̂擾
 */
//--------------------------------------------------------------------
static const TVPROG_MSG * GetNowProgramMsgData(FIELDSYS_WORK * fsys)
{
	TV_PROGRAM_ID prog_id = GetNowProgramID(fsys);
	GF_ASSERT(prog_id <= NELEMS(TVProgramMsg));
	return &TVProgramMsg[prog_id - 1];
}

//--------------------------------------------------------------------
/**
 * @brief	ԑgƂɌ܂Ă郁bZ[WID擾i7ށAOtIȂǁj
 * @param	fsys
 * @param	prog_msg_id		TV_PRO_MSG_`iscr_tv.hQƁj
 * @return	int				bZ[WIDiNARC_msg_tv_program_datj
 *
 * XNvgĂ΂
 */
//--------------------------------------------------------------------
int TV_GetProgramMsg(FIELDSYS_WORK * fsys, int prog_msg_id)
{
	TV_WORK * tvwk = SaveData_GetTvWork(fsys->savedata);
	const TVPROG_MSG * pmsg = GetNowProgramMsgData(fsys);

	switch (prog_msg_id) {
	default:
		GF_ASSERT(0);
		/* FALL THROUGH */
	case TV_PROG_MSG_OPENING:
		switch (GF_RTC_GetTimeZone()) {
		case TIMEZONE_MORNING:
			return pmsg->morning_id;
		case TIMEZONE_NOON:
			return pmsg->noon_id;
		default:
			return pmsg->night_id;
		}
	case TV_PROG_MSG_INTRO:
		if (TVWORK_GetUsedTopicNumber(tvwk) == 0) {
			return pmsg->first_intro_id;
		} else {
			return pmsg->next_intro_id;
		}
	case TV_PROG_MSG_ENDING:
		return pmsg->end_id;
	case TV_PROG_MSG_PLEASE:
		return pmsg->make_id;
	}
}

//============================================================================================
//============================================================================================
//--------------------------------------------------------------------
/**
 * @brief	ԑggsbN
 * @param	fsys		tB[hւ̃|C^
 * @param	ws			WORDSETւ̃|C^
 * @param	idx			gsbNCfbNXw
 * @param	arc_id		A[JCuw󂯎邽߂̃|C^
 * @param	msg_id		bZ[Ww󂯎邽߂̃|C^
 */
//--------------------------------------------------------------------
BOOL TV_GetProgramID(FIELDSYS_WORK * fsys, WORDSET * ws, int idx, u16 * arc_id, u16 * msg_id)
{
	TV_PROGRAM_ID prog_id = GetNowProgramID(fsys);
	int topic_type = GetTopicType(prog_id);
	TV_WORK * tvwk = SaveData_GetTvWork(fsys->savedata);
	TVBCD * bcd;

	TVWORK_SetUsedTopicIndex(tvwk, idx);

	bcd = TVBCD_Create(fsys, topic_type, idx);
	//TVWORK_DEBUG_Info(tvwk);

	TVBCD_CountUpBroadCast(bcd);
	*msg_id = TVTOPIC_Make(topic_type, fsys, ws, bcd, arc_id);

	TVBCD_Delete(bcd);
	return TRUE;
}



